package databoxedge

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/databoxedge/mgmt/2019-07-01/databoxedge"

// Address the shipping address of the customer.
type Address struct {
	// AddressLine1 - The address line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - The address line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - The address line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// PostalCode - The postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// City - The city name.
	City *string `json:"city,omitempty"`
	// State - The state name.
	State *string `json:"state,omitempty"`
	// Country - The country name.
	Country *string `json:"country,omitempty"`
}

// Alert alert on the data box edge/gateway device.
type Alert struct {
	autorest.Response `json:"-"`
	// AlertProperties - READ-ONLY; Properties of alert.
	*AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertErrorDetails error details for the alert.
type AlertErrorDetails struct {
	// ErrorCode - READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; Error Message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Occurrences - READ-ONLY; Number of occurrences.
	Occurrences *int32 `json:"occurrences,omitempty"`
}

// AlertList collection of alerts.
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The value.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AlertList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AlertProperties properties of alert.
type AlertProperties struct {
	// Title - READ-ONLY; Alert title.
	Title *string `json:"title,omitempty"`
	// AlertType - READ-ONLY; Alert type.
	AlertType *string `json:"alertType,omitempty"`
	// AppearedAtDateTime - READ-ONLY; UTC time when the alert appeared.
	AppearedAtDateTime *date.Time `json:"appearedAtDateTime,omitempty"`
	// Recommendation - READ-ONLY; Alert recommendation.
	Recommendation *string `json:"recommendation,omitempty"`
	// Severity - READ-ONLY; Severity of the alert. Possible values include: 'Informational', 'Warning', 'Critical'
	Severity AlertSeverity `json:"severity,omitempty"`
	// ErrorDetails - READ-ONLY; Error details of the alert.
	ErrorDetails *AlertErrorDetails `json:"errorDetails,omitempty"`
	// DetailedInformation - READ-ONLY; Alert details.
	DetailedInformation map[string]*string `json:"detailedInformation"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ARMBaseModel represents the base class for all object models.
type ARMBaseModel struct {
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// AsymmetricEncryptedSecret represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// EncryptionCertThumbprint - Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string `json:"encryptionCertThumbprint,omitempty"`
	// EncryptionAlgorithm - The algorithm used to encrypt "Value". Possible values include: 'None', 'AES256', 'RSAESPKCS1V15'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// Authentication authentication mechanism for IoT devices.
type Authentication struct {
	// SymmetricKey - Symmetric key for authentication.
	SymmetricKey *SymmetricKey `json:"symmetricKey,omitempty"`
}

// AzureContainerInfo azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// StorageAccountCredentialID - ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string `json:"storageAccountCredentialId,omitempty"`
	// ContainerName - Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string `json:"containerName,omitempty"`
	// DataFormat - Storage format used for the file represented by the share. Possible values include: 'BlockBlob', 'PageBlob', 'AzureFile'
	DataFormat AzureContainerDataFormat `json:"dataFormat,omitempty"`
}

// BandwidthSchedule the bandwidth schedule details.
type BandwidthSchedule struct {
	autorest.Response `json:"-"`
	// BandwidthScheduleProperties - The properties of the bandwidth schedule.
	*BandwidthScheduleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BandwidthSchedule.
func (bs BandwidthSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.BandwidthScheduleProperties != nil {
		objectMap["properties"] = bs.BandwidthScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BandwidthSchedule struct.
func (bs *BandwidthSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bandwidthScheduleProperties BandwidthScheduleProperties
				err = json.Unmarshal(*v, &bandwidthScheduleProperties)
				if err != nil {
					return err
				}
				bs.BandwidthScheduleProperties = &bandwidthScheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bs.Type = &typeVar
			}
		}
	}

	return nil
}

// BandwidthScheduleProperties the properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// Start - The start time of the schedule in UTC.
	Start *string `json:"start,omitempty"`
	// Stop - The stop time of the schedule in UTC.
	Stop *string `json:"stop,omitempty"`
	// RateInMbps - The bandwidth rate in Mbps.
	RateInMbps *int32 `json:"rateInMbps,omitempty"`
	// Days - The days of the week when this schedule is applicable.
	Days *[]DayOfWeek `json:"days,omitempty"`
}

// BandwidthSchedulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSchedulesClient) (BandwidthSchedule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSchedulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSchedulesCreateOrUpdateFuture.Result.
func (future *BandwidthSchedulesCreateOrUpdateFuture) result(client BandwidthSchedulesClient) (bs BandwidthSchedule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.BandwidthSchedulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bs.Response.Response, err = future.GetResult(sender); err == nil && bs.Response.Response.StatusCode != http.StatusNoContent {
		bs, err = client.CreateOrUpdateResponder(bs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesCreateOrUpdateFuture", "Result", bs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BandwidthSchedulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BandwidthSchedulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BandwidthSchedulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BandwidthSchedulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BandwidthSchedulesDeleteFuture.Result.
func (future *BandwidthSchedulesDeleteFuture) result(client BandwidthSchedulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.BandwidthSchedulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.BandwidthSchedulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BandwidthSchedulesList the collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of bandwidth schedules.
	Value *[]BandwidthSchedule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BandwidthSchedulesListIterator provides access to a complete listing of BandwidthSchedule values.
type BandwidthSchedulesListIterator struct {
	i    int
	page BandwidthSchedulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BandwidthSchedulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BandwidthSchedulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BandwidthSchedulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BandwidthSchedulesListIterator) Response() BandwidthSchedulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BandwidthSchedulesListIterator) Value() BandwidthSchedule {
	if !iter.page.NotDone() {
		return BandwidthSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BandwidthSchedulesListIterator type.
func NewBandwidthSchedulesListIterator(page BandwidthSchedulesListPage) BandwidthSchedulesListIterator {
	return BandwidthSchedulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsl BandwidthSchedulesList) IsEmpty() bool {
	return bsl.Value == nil || len(*bsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsl BandwidthSchedulesList) hasNextLink() bool {
	return bsl.NextLink != nil && len(*bsl.NextLink) != 0
}

// bandwidthSchedulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsl BandwidthSchedulesList) bandwidthSchedulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !bsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsl.NextLink)))
}

// BandwidthSchedulesListPage contains a page of BandwidthSchedule values.
type BandwidthSchedulesListPage struct {
	fn  func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)
	bsl BandwidthSchedulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BandwidthSchedulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BandwidthSchedulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsl)
		if err != nil {
			return err
		}
		page.bsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BandwidthSchedulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BandwidthSchedulesListPage) NotDone() bool {
	return !page.bsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BandwidthSchedulesListPage) Response() BandwidthSchedulesList {
	return page.bsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BandwidthSchedulesListPage) Values() []BandwidthSchedule {
	if page.bsl.IsEmpty() {
		return nil
	}
	return *page.bsl.Value
}

// Creates a new instance of the BandwidthSchedulesListPage type.
func NewBandwidthSchedulesListPage(cur BandwidthSchedulesList, getNextPage func(context.Context, BandwidthSchedulesList) (BandwidthSchedulesList, error)) BandwidthSchedulesListPage {
	return BandwidthSchedulesListPage{
		fn:  getNextPage,
		bsl: cur,
	}
}

// ClientAccessRight the mapping between a particular client IP and the type of access client has on the
// NFS share.
type ClientAccessRight struct {
	// Client - IP of the client.
	Client *string `json:"client,omitempty"`
	// AccessPermission - Type of access to be allowed for the client. Possible values include: 'NoAccess', 'ReadOnly', 'ReadWrite'
	AccessPermission ClientPermissionType `json:"accessPermission,omitempty"`
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - The error details.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ContactDetails contains all the contact details of the customer.
type ContactDetails struct {
	// ContactPerson - The contact person name.
	ContactPerson *string `json:"contactPerson,omitempty"`
	// CompanyName - The name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// Phone - The phone number.
	Phone *string `json:"phone,omitempty"`
	// EmailList - The email list.
	EmailList *[]string `json:"emailList,omitempty"`
}

// Device the Data Box Edge/Gateway device.
type Device struct {
	autorest.Response `json:"-"`
	// Location - The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU type.
	Sku *Sku `json:"sku,omitempty"`
	// Etag - The etag for the devices.
	Etag *string `json:"etag,omitempty"`
	// DeviceProperties - The properties of the Data Box Edge/Gateway device.
	*DeviceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.Etag != nil {
		objectMap["etag"] = d.Etag
	}
	if d.DeviceProperties != nil {
		objectMap["properties"] = d.DeviceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Device struct.
func (d *Device) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d.Etag = &etag
			}
		case "properties":
			if v != nil {
				var deviceProperties DeviceProperties
				err = json.Unmarshal(*v, &deviceProperties)
				if err != nil {
					return err
				}
				d.DeviceProperties = &deviceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceExtendedInfo the extended Info of the Data Box Edge/Gateway device.
type DeviceExtendedInfo struct {
	autorest.Response `json:"-"`
	// DeviceExtendedInfoProperties - The extended info properties.
	*DeviceExtendedInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceExtendedInfo.
func (dei DeviceExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dei.DeviceExtendedInfoProperties != nil {
		objectMap["properties"] = dei.DeviceExtendedInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeviceExtendedInfo struct.
func (dei *DeviceExtendedInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceExtendedInfoProperties DeviceExtendedInfoProperties
				err = json.Unmarshal(*v, &deviceExtendedInfoProperties)
				if err != nil {
					return err
				}
				dei.DeviceExtendedInfoProperties = &deviceExtendedInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dei.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dei.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceExtendedInfoProperties the properties of the Data Box Edge/Gateway device extended info.
type DeviceExtendedInfoProperties struct {
	// EncryptionKeyThumbprint - The digital signature of encrypted certificate.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// EncryptionKey - The public part of the encryption certificate. Client uses this to encrypt any secret.
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// ResourceKey - READ-ONLY; The Resource ID of the Resource.
	ResourceKey *string `json:"resourceKey,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceExtendedInfoProperties.
func (deip DeviceExtendedInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if deip.EncryptionKeyThumbprint != nil {
		objectMap["encryptionKeyThumbprint"] = deip.EncryptionKeyThumbprint
	}
	if deip.EncryptionKey != nil {
		objectMap["encryptionKey"] = deip.EncryptionKey
	}
	return json.Marshal(objectMap)
}

// DeviceList the collection of Data Box Edge/Gateway devices.
type DeviceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Data Box Edge/Gateway devices.
	Value *[]Device `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeviceListIterator provides access to a complete listing of Device values.
type DeviceListIterator struct {
	i    int
	page DeviceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceListIterator) Response() DeviceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceListIterator) Value() Device {
	if !iter.page.NotDone() {
		return Device{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceListIterator type.
func NewDeviceListIterator(page DeviceListPage) DeviceListIterator {
	return DeviceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dl DeviceList) IsEmpty() bool {
	return dl.Value == nil || len(*dl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dl DeviceList) hasNextLink() bool {
	return dl.NextLink != nil && len(*dl.NextLink) != 0
}

// deviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dl DeviceList) deviceListPreparer(ctx context.Context) (*http.Request, error) {
	if !dl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dl.NextLink)))
}

// DeviceListPage contains a page of Device values.
type DeviceListPage struct {
	fn func(context.Context, DeviceList) (DeviceList, error)
	dl DeviceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dl)
		if err != nil {
			return err
		}
		page.dl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceListPage) NotDone() bool {
	return !page.dl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceListPage) Response() DeviceList {
	return page.dl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceListPage) Values() []Device {
	if page.dl.IsEmpty() {
		return nil
	}
	return *page.dl.Value
}

// Creates a new instance of the DeviceListPage type.
func NewDeviceListPage(cur DeviceList, getNextPage func(context.Context, DeviceList) (DeviceList, error)) DeviceListPage {
	return DeviceListPage{
		fn: getNextPage,
		dl: cur,
	}
}

// DevicePatch the Data Box Edge/Gateway device patch.
type DevicePatch struct {
	// Tags - The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DevicePatch.
func (dp DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	return json.Marshal(objectMap)
}

// DeviceProperties the properties of the Data Box Edge/Gateway device.
type DeviceProperties struct {
	// DataBoxEdgeDeviceStatus - The status of the Data Box Edge/Gateway device. Possible values include: 'ReadyToSetup', 'Online', 'Offline', 'NeedsAttention', 'Disconnected', 'PartiallyDisconnected', 'Maintenance'
	DataBoxEdgeDeviceStatus DeviceStatus `json:"dataBoxEdgeDeviceStatus,omitempty"`
	// SerialNumber - READ-ONLY; The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Description - The Description of the Data Box Edge/Gateway device.
	Description *string `json:"description,omitempty"`
	// ModelDescription - The description of the Data Box Edge/Gateway device model.
	ModelDescription *string `json:"modelDescription,omitempty"`
	// DeviceType - READ-ONLY; The type of the Data Box Edge/Gateway device. Possible values include: 'DataBoxEdgeDevice'
	DeviceType DeviceType `json:"deviceType,omitempty"`
	// FriendlyName - The Data Box Edge/Gateway device name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Culture - READ-ONLY; The Data Box Edge/Gateway device culture.
	Culture *string `json:"culture,omitempty"`
	// DeviceModel - READ-ONLY; The Data Box Edge/Gateway device model.
	DeviceModel *string `json:"deviceModel,omitempty"`
	// DeviceSoftwareVersion - READ-ONLY; The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string `json:"deviceSoftwareVersion,omitempty"`
	// DeviceLocalCapacity - READ-ONLY; The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64 `json:"deviceLocalCapacity,omitempty"`
	// TimeZone - READ-ONLY; The Data Box Edge/Gateway device timezone.
	TimeZone *string `json:"timeZone,omitempty"`
	// DeviceHcsVersion - READ-ONLY; The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string `json:"deviceHcsVersion,omitempty"`
	// ConfiguredRoleTypes - READ-ONLY; Type of compute roles configured.
	ConfiguredRoleTypes *[]RoleTypes `json:"configuredRoleTypes,omitempty"`
	// NodeCount - READ-ONLY; The number of nodes in the cluster.
	NodeCount *int32 `json:"nodeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceProperties.
func (dp DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.DataBoxEdgeDeviceStatus != "" {
		objectMap["dataBoxEdgeDeviceStatus"] = dp.DataBoxEdgeDeviceStatus
	}
	if dp.Description != nil {
		objectMap["description"] = dp.Description
	}
	if dp.ModelDescription != nil {
		objectMap["modelDescription"] = dp.ModelDescription
	}
	if dp.FriendlyName != nil {
		objectMap["friendlyName"] = dp.FriendlyName
	}
	return json.Marshal(objectMap)
}

// DevicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (Device, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesCreateOrUpdateFuture.Result.
func (future *DevicesCreateOrUpdateFuture) result(client DevicesClient) (d Device, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DevicesCreateOrUpdateSecuritySettingsFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DevicesCreateOrUpdateSecuritySettingsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesCreateOrUpdateSecuritySettingsFuture.Result.
func (future *DevicesCreateOrUpdateSecuritySettingsFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesCreateOrUpdateSecuritySettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesCreateOrUpdateSecuritySettingsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDeleteFuture.Result.
func (future *DevicesDeleteFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesDownloadUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesDownloadUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesDownloadUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesDownloadUpdatesFuture.Result.
func (future *DevicesDownloadUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesDownloadUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesDownloadUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesInstallUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesInstallUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesInstallUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesInstallUpdatesFuture.Result.
func (future *DevicesInstallUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesInstallUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesInstallUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DevicesScanForUpdatesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DevicesScanForUpdatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DevicesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DevicesScanForUpdatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DevicesScanForUpdatesFuture.Result.
func (future *DevicesScanForUpdatesFuture) result(client DevicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.DevicesScanForUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.DevicesScanForUpdatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FileEventTrigger trigger details.
type FileEventTrigger struct {
	// FileTriggerProperties - File trigger properties.
	*FileTriggerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEventTrigger.
func (fet FileEventTrigger) MarshalJSON() ([]byte, error) {
	fet.Kind = KindFileEvent
	objectMap := make(map[string]interface{})
	if fet.FileTriggerProperties != nil {
		objectMap["properties"] = fet.FileTriggerProperties
	}
	if fet.Kind != "" {
		objectMap["kind"] = fet.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return &fet, true
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for FileEventTrigger.
func (fet FileEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &fet, true
}

// UnmarshalJSON is the custom unmarshaler for FileEventTrigger struct.
func (fet *FileEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileTriggerProperties FileTriggerProperties
				err = json.Unmarshal(*v, &fileTriggerProperties)
				if err != nil {
					return err
				}
				fet.FileTriggerProperties = &fileTriggerProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fet.Type = &typeVar
			}
		}
	}

	return nil
}

// FileSourceInfo file source details.
type FileSourceInfo struct {
	// ShareID - File share ID.
	ShareID *string `json:"shareId,omitempty"`
}

// FileTriggerProperties file trigger properties.
type FileTriggerProperties struct {
	// SourceInfo - File event source details.
	SourceInfo *FileSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role sink info.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// IoTDeviceInfo metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// DeviceID - ID of the IoT device/edge device.
	DeviceID *string `json:"deviceId,omitempty"`
	// IoTHostHub - Host name for the IoT hub associated to the device.
	IoTHostHub *string `json:"ioTHostHub,omitempty"`
	// IoTHostHubID - Id of the IoT hub associated to the device.
	IoTHostHubID *string `json:"ioTHostHubId,omitempty"`
	// Authentication - IoT device authentication info.
	Authentication *Authentication `json:"authentication,omitempty"`
}

// IoTRole compute role.
type IoTRole struct {
	// IoTRoleProperties - Properties specific to IoT role.
	*IoTRoleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindRole', 'KindIOT'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTRole.
func (itr IoTRole) MarshalJSON() ([]byte, error) {
	itr.Kind = KindIOT
	objectMap := make(map[string]interface{})
	if itr.IoTRoleProperties != nil {
		objectMap["properties"] = itr.IoTRoleProperties
	}
	if itr.Kind != "" {
		objectMap["kind"] = itr.Kind
	}
	return json.Marshal(objectMap)
}

// AsIoTRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsIoTRole() (*IoTRole, bool) {
	return &itr, true
}

// AsRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsRole() (*Role, bool) {
	return nil, false
}

// AsBasicRole is the BasicRole implementation for IoTRole.
func (itr IoTRole) AsBasicRole() (BasicRole, bool) {
	return &itr, true
}

// UnmarshalJSON is the custom unmarshaler for IoTRole struct.
func (itr *IoTRole) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTRoleProperties IoTRoleProperties
				err = json.Unmarshal(*v, &ioTRoleProperties)
				if err != nil {
					return err
				}
				itr.IoTRoleProperties = &ioTRoleProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				itr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itr.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTRoleProperties ioT role properties.
type IoTRoleProperties struct {
	// HostPlatform - Host OS supported by the IoT role. Possible values include: 'Windows', 'Linux'
	HostPlatform PlatformType `json:"hostPlatform,omitempty"`
	// IoTDeviceDetails - IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo `json:"ioTDeviceDetails,omitempty"`
	// IoTEdgeDeviceDetails - IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo `json:"ioTEdgeDeviceDetails,omitempty"`
	// ShareMappings - Mount points of shares in role(s).
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// RoleStatus - Role status. Possible values include: 'RoleStatusEnabled', 'RoleStatusDisabled'
	RoleStatus RoleStatus `json:"roleStatus,omitempty"`
}

// Ipv4Config details related to the IPv4 address configuration.
type Ipv4Config struct {
	// IPAddress - READ-ONLY; The IPv4 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - READ-ONLY; The IPv4 subnet of the network adapter.
	Subnet *string `json:"subnet,omitempty"`
	// Gateway - READ-ONLY; The IPv4 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Ipv6Config details related to the IPv6 address configuration.
type Ipv6Config struct {
	// IPAddress - READ-ONLY; The IPv6 address of the network adapter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PrefixLength - READ-ONLY; The IPv6 prefix of the network adapter.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
	// Gateway - READ-ONLY; The IPv6 gateway of the network adapter.
	Gateway *string `json:"gateway,omitempty"`
}

// Job a device job.
type Job struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the object.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
	// Status - READ-ONLY; The current status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusRunning', 'JobStatusSucceeded', 'JobStatusFailed', 'JobStatusCanceled', 'JobStatusPaused', 'JobStatusScheduled'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - READ-ONLY; The UTC date and time at which the job started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The UTC date and time at which the job completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the job that is complete.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Error - READ-ONLY; The error details.
	Error *JobErrorDetails `json:"error,omitempty"`
	// JobProperties - READ-ONLY; The properties of the job.
	*JobProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete int32
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				j.PercentComplete = &percentComplete
			}
		case "error":
			if v != nil {
				var errorVar JobErrorDetails
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		}
	}

	return nil
}

// JobErrorDetails the job error information containing the list of job errors.
type JobErrorDetails struct {
	// ErrorDetails - READ-ONLY; The error details.
	ErrorDetails *[]JobErrorItem `json:"errorDetails,omitempty"`
	// Code - READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobErrorItem the job error items.
type JobErrorItem struct {
	// Recommendations - READ-ONLY; The recommended actions.
	Recommendations *[]string `json:"recommendations,omitempty"`
	// Code - READ-ONLY; The code intended for programmatic access.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The message that describes the error in detail.
	Message *string `json:"message,omitempty"`
}

// JobProperties the properties for the job.
type JobProperties struct {
	// JobType - READ-ONLY; The type of the job. Possible values include: 'JobTypeInvalid', 'JobTypeScanForUpdates', 'JobTypeDownloadUpdates', 'JobTypeInstallUpdates', 'JobTypeRefreshShare'
	JobType JobType `json:"jobType,omitempty"`
	// CurrentStage - READ-ONLY; Current stage of the update operation. Possible values include: 'UpdateOperationStageUnknown', 'UpdateOperationStageInitial', 'UpdateOperationStageScanStarted', 'UpdateOperationStageScanComplete', 'UpdateOperationStageScanFailed', 'UpdateOperationStageDownloadStarted', 'UpdateOperationStageDownloadComplete', 'UpdateOperationStageDownloadFailed', 'UpdateOperationStageInstallStarted', 'UpdateOperationStageInstallComplete', 'UpdateOperationStageInstallFailed', 'UpdateOperationStageRebootInitiated', 'UpdateOperationStageSuccess', 'UpdateOperationStageFailure', 'UpdateOperationStageRescanStarted', 'UpdateOperationStageRescanComplete', 'UpdateOperationStageRescanFailed'
	CurrentStage UpdateOperationStage `json:"currentStage,omitempty"`
	// DownloadProgress - READ-ONLY; The download progress.
	DownloadProgress *UpdateDownloadProgress `json:"downloadProgress,omitempty"`
	// InstallProgress - READ-ONLY; The install progress.
	InstallProgress *UpdateInstallProgress `json:"installProgress,omitempty"`
	// TotalRefreshErrors - READ-ONLY; Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32 `json:"totalRefreshErrors,omitempty"`
	// ErrorManifestFile - READ-ONLY; Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// ShareID - READ-ONLY; ARM ID of the share that was refreshed.
	ShareID *string `json:"shareId,omitempty"`
	// Folder - If only subfolders need to be refreshed, then the subfolder path inside the share. (The path is empty if there are no subfolders.)
	Folder *string `json:"folder,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Folder != nil {
		objectMap["folder"] = jp.Folder
	}
	return json.Marshal(objectMap)
}

// MetricDimensionV1 metric Dimension v1.
type MetricDimensionV1 struct {
	// Name - Name of the metrics dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metrics dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - To be exported to shoe box.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecificationV1 metric specification version 1.
type MetricSpecificationV1 struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Description of the metric to be displayed.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric units. Possible values include: 'NotSpecified', 'Percent', 'Count', 'Seconds', 'Milliseconds', 'Bytes', 'BytesPerSecond', 'CountPerSecond'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type. Possible values include: 'MetricAggregationTypeNotSpecified', 'MetricAggregationTypeNone', 'MetricAggregationTypeAverage', 'MetricAggregationTypeMinimum', 'MetricAggregationTypeMaximum', 'MetricAggregationTypeTotal', 'MetricAggregationTypeCount'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// Dimensions - Metric dimensions, other than default dimension which is resource.
	Dimensions *[]MetricDimensionV1 `json:"dimensions,omitempty"`
	// FillGapWithZero - Set true to fill the gaps with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - Metric category. Possible values include: 'Capacity', 'Transaction'
	Category MetricCategory `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Resource name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
	// SupportedTimeGrainTypes - Support granularity of metrics.
	SupportedTimeGrainTypes *[]TimeGrain `json:"supportedTimeGrainTypes,omitempty"`
	// SupportedAggregationTypes - Support metric aggregation type.
	SupportedAggregationTypes *[]MetricAggregationType `json:"supportedAggregationTypes,omitempty"`
}

// MountPointMap the share mount point.
type MountPointMap struct {
	// ShareID - ID of the share mounted to the role VM.
	ShareID *string `json:"shareId,omitempty"`
	// RoleID - READ-ONLY; ID of the role to which share is mounted.
	RoleID *string `json:"roleId,omitempty"`
	// MountPoint - READ-ONLY; Mount point for the share.
	MountPoint *string `json:"mountPoint,omitempty"`
	// RoleType - READ-ONLY; Role type. Possible values include: 'IOT', 'ASA', 'Functions', 'Cognitive'
	RoleType RoleTypes `json:"roleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MountPointMap.
func (mpm MountPointMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpm.ShareID != nil {
		objectMap["shareId"] = mpm.ShareID
	}
	return json.Marshal(objectMap)
}

// NetworkAdapter represents the networkAdapter on a device.
type NetworkAdapter struct {
	// AdapterID - READ-ONLY; Instance ID of network adapter.
	AdapterID *string `json:"adapterId,omitempty"`
	// AdapterPosition - READ-ONLY; Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition `json:"adapterPosition,omitempty"`
	// Index - READ-ONLY; Logical index of the adapter.
	Index *int32 `json:"index,omitempty"`
	// NodeID - READ-ONLY; Node ID of the network adapter.
	NodeID *string `json:"nodeId,omitempty"`
	// NetworkAdapterName - READ-ONLY; Network adapter name.
	NetworkAdapterName *string `json:"networkAdapterName,omitempty"`
	// Label - READ-ONLY; Hardware label for the adapter.
	Label *string `json:"label,omitempty"`
	// MacAddress - READ-ONLY; MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
	// LinkSpeed - READ-ONLY; Link speed.
	LinkSpeed *int64 `json:"linkSpeed,omitempty"`
	// Status - READ-ONLY; Value indicating whether this adapter is valid. Possible values include: 'Inactive', 'Active'
	Status NetworkAdapterStatus `json:"status,omitempty"`
	// RdmaStatus - Value indicating whether this adapter is RDMA capable. Possible values include: 'Incapable', 'Capable'
	RdmaStatus NetworkAdapterRDMAStatus `json:"rdmaStatus,omitempty"`
	// DhcpStatus - Value indicating whether this adapter has DHCP enabled. Possible values include: 'NetworkAdapterDHCPStatusDisabled', 'NetworkAdapterDHCPStatusEnabled'
	DhcpStatus NetworkAdapterDHCPStatus `json:"dhcpStatus,omitempty"`
	// Ipv4Configuration - READ-ONLY; The IPv4 configuration of the network adapter.
	Ipv4Configuration *Ipv4Config `json:"ipv4Configuration,omitempty"`
	// Ipv6Configuration - READ-ONLY; The IPv6 configuration of the network adapter.
	Ipv6Configuration *Ipv6Config `json:"ipv6Configuration,omitempty"`
	// Ipv6LinkLocalAddress - READ-ONLY; The IPv6 local address.
	Ipv6LinkLocalAddress *string `json:"ipv6LinkLocalAddress,omitempty"`
	// DNSServers - READ-ONLY; The list of DNS Servers of the device.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkAdapter.
func (na NetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if na.RdmaStatus != "" {
		objectMap["rdmaStatus"] = na.RdmaStatus
	}
	if na.DhcpStatus != "" {
		objectMap["dhcpStatus"] = na.DhcpStatus
	}
	return json.Marshal(objectMap)
}

// NetworkAdapterPosition the network adapter position.
type NetworkAdapterPosition struct {
	// NetworkGroup - READ-ONLY; The network group. Possible values include: 'NetworkGroupNone', 'NetworkGroupNonRDMA', 'NetworkGroupRDMA'
	NetworkGroup NetworkGroup `json:"networkGroup,omitempty"`
	// Port - READ-ONLY; The port.
	Port *int32 `json:"port,omitempty"`
}

// NetworkSettings the network settings of a device.
type NetworkSettings struct {
	autorest.Response `json:"-"`
	// NetworkSettingsProperties - READ-ONLY; The properties of network settings of a device.
	*NetworkSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSettings.
func (ns NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkSettings struct.
func (ns *NetworkSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkSettingsProperties NetworkSettingsProperties
				err = json.Unmarshal(*v, &networkSettingsProperties)
				if err != nil {
					return err
				}
				ns.NetworkSettingsProperties = &networkSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ns.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkSettingsProperties the properties of network settings.
type NetworkSettingsProperties struct {
	// NetworkAdapters - READ-ONLY; The network adapter list on the device.
	NetworkAdapters *[]NetworkAdapter `json:"networkAdapters,omitempty"`
}

// Node represents a single node in a Data box Edge/Gateway device
// Gateway devices, standalone Edge devices and a single node cluster Edge device will all have 1 node
// Multi-node Edge devices will have more than 1 nodes
type Node struct {
	// NodeProperties - READ-ONLY; The properties of the node
	*NodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Node.
func (n Node) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Node struct.
func (n *Node) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var nodeProperties NodeProperties
				err = json.Unmarshal(*v, &nodeProperties)
				if err != nil {
					return err
				}
				n.NodeProperties = &nodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				n.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				n.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				n.Type = &typeVar
			}
		}
	}

	return nil
}

// NodeList collection of Nodes.
type NodeList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Nodes.
	Value *[]Node `json:"value,omitempty"`
}

// NodeProperties this class represents the nodes in a highly available cluster
type NodeProperties struct {
	// NodeStatus - READ-ONLY; The current status of the individual node. Possible values include: 'NodeStatusUnknown', 'NodeStatusUp', 'NodeStatusDown', 'NodeStatusRebooting', 'NodeStatusShuttingDown'
	NodeStatus NodeStatus `json:"nodeStatus,omitempty"`
	// NodeChassisSerialNumber - READ-ONLY; Serial number of the Chassis
	NodeChassisSerialNumber *string `json:"nodeChassisSerialNumber,omitempty"`
	// NodeSerialNumber - READ-ONLY; Serial number of the individual node
	NodeSerialNumber *string `json:"nodeSerialNumber,omitempty"`
	// NodeDisplayName - READ-ONLY; Display Name of the individual node
	NodeDisplayName *string `json:"nodeDisplayName,omitempty"`
	// NodeFriendlySoftwareVersion - READ-ONLY; Friendly software version name that is currently installed on the node
	NodeFriendlySoftwareVersion *string `json:"nodeFriendlySoftwareVersion,omitempty"`
	// NodeHcsVersion - READ-ONLY; HCS version that is currently installed on the node
	NodeHcsVersion *string `json:"nodeHcsVersion,omitempty"`
	// NodeInstanceID - READ-ONLY; Guid instance id of the node
	NodeInstanceID *string `json:"nodeInstanceId,omitempty"`
}

// Operation operations.
type Operation struct {
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Properties displayed for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Operation properties.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay operation display properties.
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The type of resource in which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation to be performed on the resource.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation to be performed.
	Description *string `json:"description,omitempty"`
}

// OperationProperties operation properties.
type OperationProperties struct {
	// ServiceSpecification - Service specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsList the list of operations used for the discovery of available provider operations.
type OperationsList struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationsList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// Order the order details.
type Order struct {
	autorest.Response `json:"-"`
	// OrderProperties - The order properties.
	*OrderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Order.
func (o Order) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OrderProperties != nil {
		objectMap["properties"] = o.OrderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Order struct.
func (o *Order) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				o.OrderProperties = &orderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// OrderList list of order entities.
type OrderList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of orders.
	Value *[]Order `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OrderListIterator provides access to a complete listing of Order values.
type OrderListIterator struct {
	i    int
	page OrderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderListIterator) Response() OrderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderListIterator) Value() Order {
	if !iter.page.NotDone() {
		return Order{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderListIterator type.
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return OrderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OrderList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OrderList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// orderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OrderList) orderListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OrderListPage contains a page of Order values.
type OrderListPage struct {
	fn func(context.Context, OrderList) (OrderList, error)
	ol OrderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderListPage) Response() OrderList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderListPage) Values() []Order {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OrderListPage type.
func NewOrderListPage(cur OrderList, getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return OrderListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OrderProperties order properties.
type OrderProperties struct {
	// ContactInformation - The contact details.
	ContactInformation *ContactDetails `json:"contactInformation,omitempty"`
	// ShippingAddress - The shipping address.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`
	// CurrentStatus - Current status of the order.
	CurrentStatus *OrderStatus `json:"currentStatus,omitempty"`
	// OrderHistory - READ-ONLY; List of status changes in the order.
	OrderHistory *[]OrderStatus `json:"orderHistory,omitempty"`
	// SerialNumber - READ-ONLY; Serial number of the device.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// DeliveryTrackingInfo - READ-ONLY; Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo *[]TrackingInfo `json:"deliveryTrackingInfo,omitempty"`
	// ReturnTrackingInfo - READ-ONLY; Tracking information for the package returned from the customer whether it has an original or a replacement device.
	ReturnTrackingInfo *[]TrackingInfo `json:"returnTrackingInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderProperties.
func (op OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.ContactInformation != nil {
		objectMap["contactInformation"] = op.ContactInformation
	}
	if op.ShippingAddress != nil {
		objectMap["shippingAddress"] = op.ShippingAddress
	}
	if op.CurrentStatus != nil {
		objectMap["currentStatus"] = op.CurrentStatus
	}
	return json.Marshal(objectMap)
}

// OrdersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OrdersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrdersClient) (Order, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrdersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrdersCreateOrUpdateFuture.Result.
func (future *OrdersCreateOrUpdateFuture) result(client OrdersClient) (o Order, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.OrdersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		o.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.OrdersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.CreateOrUpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.OrdersCreateOrUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OrdersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OrdersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrdersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrdersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrdersDeleteFuture.Result.
func (future *OrdersDeleteFuture) result(client OrdersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.OrdersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.OrdersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OrderStatus represents a single status change.
type OrderStatus struct {
	// Status - Status of the order as per the allowed status types. Possible values include: 'Untracked', 'AwaitingFulfilment', 'AwaitingPreparation', 'AwaitingShipment', 'Shipped', 'Arriving', 'Delivered', 'ReplacementRequested', 'LostDevice', 'Declined', 'ReturnInitiated', 'AwaitingReturnShipment', 'ShippedBack', 'CollectedAtMicrosoft'
	Status OrderState `json:"status,omitempty"`
	// UpdateDateTime - READ-ONLY; Time of status update.
	UpdateDateTime *date.Time `json:"updateDateTime,omitempty"`
	// Comments - Comments related to this status change.
	Comments *string `json:"comments,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderStatus.
func (osVar OrderStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osVar.Status != "" {
		objectMap["status"] = osVar.Status
	}
	if osVar.Comments != nil {
		objectMap["comments"] = osVar.Comments
	}
	return json.Marshal(objectMap)
}

// PeriodicTimerEventTrigger trigger details.
type PeriodicTimerEventTrigger struct {
	// PeriodicTimerProperties - Periodic timer trigger properties.
	*PeriodicTimerProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) MarshalJSON() ([]byte, error) {
	ptet.Kind = KindPeriodicTimerEvent
	objectMap := make(map[string]interface{})
	if ptet.PeriodicTimerProperties != nil {
		objectMap["properties"] = ptet.PeriodicTimerProperties
	}
	if ptet.Kind != "" {
		objectMap["kind"] = ptet.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return &ptet, true
}

// AsTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for PeriodicTimerEventTrigger.
func (ptet PeriodicTimerEventTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &ptet, true
}

// UnmarshalJSON is the custom unmarshaler for PeriodicTimerEventTrigger struct.
func (ptet *PeriodicTimerEventTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var periodicTimerProperties PeriodicTimerProperties
				err = json.Unmarshal(*v, &periodicTimerProperties)
				if err != nil {
					return err
				}
				ptet.PeriodicTimerProperties = &periodicTimerProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ptet.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ptet.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ptet.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ptet.Type = &typeVar
			}
		}
	}

	return nil
}

// PeriodicTimerProperties periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// SourceInfo - Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo `json:"sourceInfo,omitempty"`
	// SinkInfo - Role Sink information.
	SinkInfo *RoleSinkInfo `json:"sinkInfo,omitempty"`
	// CustomContextTag - A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
	CustomContextTag *string `json:"customContextTag,omitempty"`
}

// PeriodicTimerSourceInfo periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// StartTime - The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified upto seconds. If timezone is not specified the time will considered to be in device timezone. The value will always be returned as UTC time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Schedule - Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string `json:"schedule,omitempty"`
	// Topic - Topic where periodic events are published to IoT device.
	Topic *string `json:"topic,omitempty"`
}

// RawCertificateData raw Certificate Data.
type RawCertificateData struct {
	// AuthenticationType - The authentication type. Possible values include: 'Invalid', 'AzureActiveDirectory'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// Certificate - The base64 encoded certificate raw data.
	Certificate *string `json:"certificate,omitempty"`
}

// RefreshDetails fields for tracking refresh job on the share.
type RefreshDetails struct {
	// InProgressRefreshJobID - If a refresh share job is currently in progress on this share, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string `json:"inProgressRefreshJobId,omitempty"`
	// LastCompletedRefreshJobTimeInUTC - Indicates the completed time for the last refresh job on this particular share, if any.This could be a failed job or a successful job.
	LastCompletedRefreshJobTimeInUTC *date.Time `json:"lastCompletedRefreshJobTimeInUTC,omitempty"`
	// ErrorManifestFile - Indicates the relative path of the error xml for the last refresh job on this particular share, if any. This could be a failed job or a successful job.
	ErrorManifestFile *string `json:"errorManifestFile,omitempty"`
	// LastJob - Indicates the id of the last refresh job on this particular share,if any. This could be a failed job or a successful job.
	LastJob *string `json:"lastJob,omitempty"`
}

// BasicRole compute role.
type BasicRole interface {
	AsIoTRole() (*IoTRole, bool)
	AsRole() (*Role, bool)
}

// Role compute role.
type Role struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindRole', 'KindIOT'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicRole(body []byte) (BasicRole, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindIOT):
		var itr IoTRole
		err := json.Unmarshal(body, &itr)
		return itr, err
	default:
		var r Role
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRoleArray(body []byte) ([]BasicRole, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRole, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRole(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Role.
func (r Role) MarshalJSON() ([]byte, error) {
	r.Kind = KindRole
	objectMap := make(map[string]interface{})
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	return json.Marshal(objectMap)
}

// AsIoTRole is the BasicRole implementation for Role.
func (r Role) AsIoTRole() (*IoTRole, bool) {
	return nil, false
}

// AsRole is the BasicRole implementation for Role.
func (r Role) AsRole() (*Role, bool) {
	return &r, true
}

// AsBasicRole is the BasicRole implementation for Role.
func (r Role) AsBasicRole() (BasicRole, bool) {
	return &r, true
}

// RoleList collection of all the roles on the Data Box Edge device.
type RoleList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The Value.
	Value *[]BasicRole `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleList struct.
func (rl *RoleList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicRoleArray(*v)
				if err != nil {
					return err
				}
				rl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				rl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// RoleListIterator provides access to a complete listing of Role values.
type RoleListIterator struct {
	i    int
	page RoleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleListIterator) Response() RoleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleListIterator) Value() BasicRole {
	if !iter.page.NotDone() {
		return Role{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleListIterator type.
func NewRoleListIterator(page RoleListPage) RoleListIterator {
	return RoleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl RoleList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rl RoleList) hasNextLink() bool {
	return rl.NextLink != nil && len(*rl.NextLink) != 0
}

// roleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl RoleList) roleListPreparer(ctx context.Context) (*http.Request, error) {
	if !rl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// RoleListPage contains a page of BasicRole values.
type RoleListPage struct {
	fn func(context.Context, RoleList) (RoleList, error)
	rl RoleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rl)
		if err != nil {
			return err
		}
		page.rl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleListPage) Response() RoleList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleListPage) Values() []BasicRole {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the RoleListPage type.
func NewRoleListPage(cur RoleList, getNextPage func(context.Context, RoleList) (RoleList, error)) RoleListPage {
	return RoleListPage{
		fn: getNextPage,
		rl: cur,
	}
}

// RoleModel ...
type RoleModel struct {
	autorest.Response `json:"-"`
	Value             BasicRole `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RoleModel struct.
func (rm *RoleModel) UnmarshalJSON(body []byte) error {
	r, err := unmarshalBasicRole(body)
	if err != nil {
		return err
	}
	rm.Value = r

	return nil
}

// RolesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RolesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RolesClient) (RoleModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RolesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RolesCreateOrUpdateFuture.Result.
func (future *RolesCreateOrUpdateFuture) result(client RolesClient) (rm RoleModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.RolesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.RolesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rm.Response.Response, err = future.GetResult(sender); err == nil && rm.Response.Response.StatusCode != http.StatusNoContent {
		rm, err = client.CreateOrUpdateResponder(rm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.RolesCreateOrUpdateFuture", "Result", rm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RolesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RolesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RolesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RolesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RolesDeleteFuture.Result.
func (future *RolesDeleteFuture) result(client RolesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.RolesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.RolesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoleSinkInfo compute role against which events will be raised.
type RoleSinkInfo struct {
	// RoleID - Compute role ID.
	RoleID *string `json:"roleId,omitempty"`
}

// SecuritySettings the security settings of a device.
type SecuritySettings struct {
	// SecuritySettingsProperties - Properties of the security settings.
	*SecuritySettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecuritySettings.
func (ss SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SecuritySettingsProperties != nil {
		objectMap["properties"] = ss.SecuritySettingsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecuritySettings struct.
func (ss *SecuritySettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securitySettingsProperties SecuritySettingsProperties
				err = json.Unmarshal(*v, &securitySettingsProperties)
				if err != nil {
					return err
				}
				ss.SecuritySettingsProperties = &securitySettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SecuritySettingsProperties the properties of security settings.
type SecuritySettingsProperties struct {
	// DeviceAdminPassword - Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret `json:"deviceAdminPassword,omitempty"`
}

// ServiceSpecification service specification.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specification as defined by shoebox.
	MetricSpecifications *[]MetricSpecificationV1 `json:"metricSpecifications,omitempty"`
}

// Share represents a share on the  Data Box Edge/Gateway device.
type Share struct {
	autorest.Response `json:"-"`
	// ShareProperties - The share properties.
	*ShareProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Share.
func (s Share) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ShareProperties != nil {
		objectMap["properties"] = s.ShareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Share struct.
func (s *Share) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var shareProperties ShareProperties
				err = json.Unmarshal(*v, &shareProperties)
				if err != nil {
					return err
				}
				s.ShareProperties = &shareProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ShareAccessRight specifies the mapping between this particular user and the type of access he has on
// shares on this device.
type ShareAccessRight struct {
	// ShareID - The share ID.
	ShareID *string `json:"shareId,omitempty"`
	// AccessType - Type of access to be allowed on the share for this user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// ShareList collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of shares.
	Value *[]Share `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareListIterator provides access to a complete listing of Share values.
type ShareListIterator struct {
	i    int
	page ShareListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ShareListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ShareListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ShareListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ShareListIterator) Response() ShareList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ShareListIterator) Value() Share {
	if !iter.page.NotDone() {
		return Share{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ShareListIterator type.
func NewShareListIterator(page ShareListPage) ShareListIterator {
	return ShareListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ShareList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl ShareList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// shareListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ShareList) shareListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ShareListPage contains a page of Share values.
type ShareListPage struct {
	fn func(context.Context, ShareList) (ShareList, error)
	sl ShareList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ShareListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ShareListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ShareListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ShareListPage) Response() ShareList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ShareListPage) Values() []Share {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ShareListPage type.
func NewShareListPage(cur ShareList, getNextPage func(context.Context, ShareList) (ShareList, error)) ShareListPage {
	return ShareListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// ShareProperties the share properties.
type ShareProperties struct {
	// Description - Description for the share.
	Description *string `json:"description,omitempty"`
	// ShareStatus - Current status of the share. Possible values include: 'ShareStatusOffline', 'ShareStatusUnknown', 'ShareStatusOK', 'ShareStatusUpdating', 'ShareStatusNeedsAttention'
	ShareStatus ShareStatus `json:"shareStatus,omitempty"`
	// MonitoringStatus - Current monitoring status of the share. Possible values include: 'Enabled', 'Disabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// AzureContainerInfo - Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo `json:"azureContainerInfo,omitempty"`
	// AccessProtocol - Access protocol to be used by the share. Possible values include: 'SMB', 'NFS'
	AccessProtocol ShareAccessProtocol `json:"accessProtocol,omitempty"`
	// UserAccessRights - Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights *[]UserAccessRight `json:"userAccessRights,omitempty"`
	// ClientAccessRights - List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights *[]ClientAccessRight `json:"clientAccessRights,omitempty"`
	// RefreshDetails - Details of the refresh job on this share.
	RefreshDetails *RefreshDetails `json:"refreshDetails,omitempty"`
	// ShareMappings - READ-ONLY; Share mount point to the role.
	ShareMappings *[]MountPointMap `json:"shareMappings,omitempty"`
	// DataPolicy - Data policy of the share. Possible values include: 'Cloud', 'Local'
	DataPolicy DataPolicy `json:"dataPolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for ShareProperties.
func (sp ShareProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Description != nil {
		objectMap["description"] = sp.Description
	}
	if sp.ShareStatus != "" {
		objectMap["shareStatus"] = sp.ShareStatus
	}
	if sp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = sp.MonitoringStatus
	}
	if sp.AzureContainerInfo != nil {
		objectMap["azureContainerInfo"] = sp.AzureContainerInfo
	}
	if sp.AccessProtocol != "" {
		objectMap["accessProtocol"] = sp.AccessProtocol
	}
	if sp.UserAccessRights != nil {
		objectMap["userAccessRights"] = sp.UserAccessRights
	}
	if sp.ClientAccessRights != nil {
		objectMap["clientAccessRights"] = sp.ClientAccessRights
	}
	if sp.RefreshDetails != nil {
		objectMap["refreshDetails"] = sp.RefreshDetails
	}
	if sp.DataPolicy != "" {
		objectMap["dataPolicy"] = sp.DataPolicy
	}
	return json.Marshal(objectMap)
}

// SharesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (Share, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesCreateOrUpdateFuture.Result.
func (future *SharesCreateOrUpdateFuture) result(client SharesClient) (s Share, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.SharesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SharesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SharesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesDeleteFuture.Result.
func (future *SharesDeleteFuture) result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SharesRefreshFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SharesRefreshFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharesRefreshFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharesRefreshFuture.Result.
func (future *SharesRefreshFuture) result(client SharesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.SharesRefreshFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.SharesRefreshFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Sku the SKU type.
type Sku struct {
	// Name - SKU name. Possible values include: 'Gateway', 'Edge'
	Name SkuName `json:"name,omitempty"`
	// Tier - The SKU tier. This is based on the SKU name. Possible values include: 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
}

// StorageAccountCredential the storage account credential.
type StorageAccountCredential struct {
	autorest.Response `json:"-"`
	// StorageAccountCredentialProperties - The storage account credential properties.
	*StorageAccountCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountCredential.
func (sac StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sac.StorageAccountCredentialProperties != nil {
		objectMap["properties"] = sac.StorageAccountCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageAccountCredential struct.
func (sac *StorageAccountCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageAccountCredentialProperties StorageAccountCredentialProperties
				err = json.Unmarshal(*v, &storageAccountCredentialProperties)
				if err != nil {
					return err
				}
				sac.StorageAccountCredentialProperties = &storageAccountCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sac.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageAccountCredentialList the collection of storage account credentials.
type StorageAccountCredentialList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The value.
	Value *[]StorageAccountCredential `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageAccountCredentialListIterator provides access to a complete listing of StorageAccountCredential
// values.
type StorageAccountCredentialListIterator struct {
	i    int
	page StorageAccountCredentialListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageAccountCredentialListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StorageAccountCredentialListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageAccountCredentialListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageAccountCredentialListIterator) Response() StorageAccountCredentialList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageAccountCredentialListIterator) Value() StorageAccountCredential {
	if !iter.page.NotDone() {
		return StorageAccountCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StorageAccountCredentialListIterator type.
func NewStorageAccountCredentialListIterator(page StorageAccountCredentialListPage) StorageAccountCredentialListIterator {
	return StorageAccountCredentialListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sacl StorageAccountCredentialList) IsEmpty() bool {
	return sacl.Value == nil || len(*sacl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sacl StorageAccountCredentialList) hasNextLink() bool {
	return sacl.NextLink != nil && len(*sacl.NextLink) != 0
}

// storageAccountCredentialListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sacl StorageAccountCredentialList) storageAccountCredentialListPreparer(ctx context.Context) (*http.Request, error) {
	if !sacl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sacl.NextLink)))
}

// StorageAccountCredentialListPage contains a page of StorageAccountCredential values.
type StorageAccountCredentialListPage struct {
	fn   func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)
	sacl StorageAccountCredentialList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageAccountCredentialListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StorageAccountCredentialListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sacl)
		if err != nil {
			return err
		}
		page.sacl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StorageAccountCredentialListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageAccountCredentialListPage) NotDone() bool {
	return !page.sacl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageAccountCredentialListPage) Response() StorageAccountCredentialList {
	return page.sacl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageAccountCredentialListPage) Values() []StorageAccountCredential {
	if page.sacl.IsEmpty() {
		return nil
	}
	return *page.sacl.Value
}

// Creates a new instance of the StorageAccountCredentialListPage type.
func NewStorageAccountCredentialListPage(cur StorageAccountCredentialList, getNextPage func(context.Context, StorageAccountCredentialList) (StorageAccountCredentialList, error)) StorageAccountCredentialListPage {
	return StorageAccountCredentialListPage{
		fn:   getNextPage,
		sacl: cur,
	}
}

// StorageAccountCredentialProperties the storage account credential properties.
type StorageAccountCredentialProperties struct {
	// Alias - Alias for the storage account.
	Alias *string `json:"alias,omitempty"`
	// UserName - Username for the storage account.
	UserName *string `json:"userName,omitempty"`
	// AccountKey - Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret `json:"accountKey,omitempty"`
	// ConnectionString - Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string `json:"connectionString,omitempty"`
	// SslStatus - Signifies whether SSL needs to be enabled or not. Possible values include: 'SSLStatusEnabled', 'SSLStatusDisabled'
	SslStatus SSLStatus `json:"sslStatus,omitempty"`
	// BlobDomainName - Blob end point for private clouds.
	BlobDomainName *string `json:"blobDomainName,omitempty"`
	// AccountType - Type of storage accessed on the storage account. Possible values include: 'GeneralPurposeStorage', 'BlobStorage'
	AccountType AccountType `json:"accountType,omitempty"`
	// StorageAccountID - Id of the storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// StorageAccountCredentialsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type StorageAccountCredentialsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (StorageAccountCredential, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsCreateOrUpdateFuture.Result.
func (future *StorageAccountCredentialsCreateOrUpdateFuture) result(client StorageAccountCredentialsClient) (sac StorageAccountCredential, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sac.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountCredentialsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sac.Response.Response, err = future.GetResult(sender); err == nil && sac.Response.Response.StatusCode != http.StatusNoContent {
		sac, err = client.CreateOrUpdateResponder(sac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsCreateOrUpdateFuture", "Result", sac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StorageAccountCredentialsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StorageAccountCredentialsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StorageAccountCredentialsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StorageAccountCredentialsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StorageAccountCredentialsDeleteFuture.Result.
func (future *StorageAccountCredentialsDeleteFuture) result(client StorageAccountCredentialsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.StorageAccountCredentialsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.StorageAccountCredentialsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SymmetricKey symmetric key for authentication.
type SymmetricKey struct {
	// ConnectionString - Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret `json:"connectionString,omitempty"`
}

// TrackingInfo tracking courier information.
type TrackingInfo struct {
	// SerialNumber - Serial number of the device being tracked.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// CarrierName - Name of the carrier used in the delivery.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - Tracking ID of the shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - Tracking URL of the shipment.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// BasicTrigger trigger details.
type BasicTrigger interface {
	AsFileEventTrigger() (*FileEventTrigger, bool)
	AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool)
	AsTrigger() (*Trigger, bool)
}

// Trigger trigger details.
type Trigger struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindTrigger', 'KindFileEvent', 'KindPeriodicTimerEvent'
	Kind KindBasicTrigger `json:"kind,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicTrigger(body []byte) (BasicTrigger, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindFileEvent):
		var fet FileEventTrigger
		err := json.Unmarshal(body, &fet)
		return fet, err
	case string(KindPeriodicTimerEvent):
		var ptet PeriodicTimerEventTrigger
		err := json.Unmarshal(body, &ptet)
		return ptet, err
	default:
		var t Trigger
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicTriggerArray(body []byte) ([]BasicTrigger, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicTrigger, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicTrigger(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Trigger.
func (t Trigger) MarshalJSON() ([]byte, error) {
	t.Kind = KindTrigger
	objectMap := make(map[string]interface{})
	if t.Kind != "" {
		objectMap["kind"] = t.Kind
	}
	return json.Marshal(objectMap)
}

// AsFileEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsFileEventTrigger() (*FileEventTrigger, bool) {
	return nil, false
}

// AsPeriodicTimerEventTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsPeriodicTimerEventTrigger() (*PeriodicTimerEventTrigger, bool) {
	return nil, false
}

// AsTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsTrigger() (*Trigger, bool) {
	return &t, true
}

// AsBasicTrigger is the BasicTrigger implementation for Trigger.
func (t Trigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &t, true
}

// TriggerList collection of all trigger on the data box edge device.
type TriggerList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of triggers.
	Value *[]BasicTrigger `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerList struct.
func (tl *TriggerList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicTriggerArray(*v)
				if err != nil {
					return err
				}
				tl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				tl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// TriggerListIterator provides access to a complete listing of Trigger values.
type TriggerListIterator struct {
	i    int
	page TriggerListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggerListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggerListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggerListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggerListIterator) Response() TriggerList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggerListIterator) Value() BasicTrigger {
	if !iter.page.NotDone() {
		return Trigger{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggerListIterator type.
func NewTriggerListIterator(page TriggerListPage) TriggerListIterator {
	return TriggerListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TriggerList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TriggerList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// triggerListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TriggerList) triggerListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TriggerListPage contains a page of BasicTrigger values.
type TriggerListPage struct {
	fn func(context.Context, TriggerList) (TriggerList, error)
	tl TriggerList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggerListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggerListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggerListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggerListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggerListPage) Response() TriggerList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggerListPage) Values() []BasicTrigger {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TriggerListPage type.
func NewTriggerListPage(cur TriggerList, getNextPage func(context.Context, TriggerList) (TriggerList, error)) TriggerListPage {
	return TriggerListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TriggerModel ...
type TriggerModel struct {
	autorest.Response `json:"-"`
	Value             BasicTrigger `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TriggerModel struct.
func (tm *TriggerModel) UnmarshalJSON(body []byte) error {
	t, err := unmarshalBasicTrigger(body)
	if err != nil {
		return err
	}
	tm.Value = t

	return nil
}

// TriggersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TriggersClient) (TriggerModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TriggersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TriggersCreateOrUpdateFuture.Result.
func (future *TriggersCreateOrUpdateFuture) result(client TriggersClient) (tm TriggerModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.TriggersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		tm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.TriggersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tm.Response.Response, err = future.GetResult(sender); err == nil && tm.Response.Response.StatusCode != http.StatusNoContent {
		tm, err = client.CreateOrUpdateResponder(tm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.TriggersCreateOrUpdateFuture", "Result", tm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TriggersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TriggersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TriggersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TriggersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TriggersDeleteFuture.Result.
func (future *TriggersDeleteFuture) result(client TriggersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.TriggersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.TriggersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// UpdateDownloadProgress details about the download progress of update.
type UpdateDownloadProgress struct {
	// DownloadPhase - READ-ONLY; The download phase. Possible values include: 'Unknown', 'Initializing', 'Downloading', 'Verifying'
	DownloadPhase DownloadPhase `json:"downloadPhase,omitempty"`
	// PercentComplete - READ-ONLY; Percentage of completion.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// TotalBytesToDownload - READ-ONLY; Total bytes to download.
	TotalBytesToDownload *float64 `json:"totalBytesToDownload,omitempty"`
	// TotalBytesDownloaded - READ-ONLY; Total bytes downloaded.
	TotalBytesDownloaded *float64 `json:"totalBytesDownloaded,omitempty"`
	// NumberOfUpdatesToDownload - READ-ONLY; Number of updates to download.
	NumberOfUpdatesToDownload *int32 `json:"numberOfUpdatesToDownload,omitempty"`
	// NumberOfUpdatesDownloaded - READ-ONLY; Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32 `json:"numberOfUpdatesDownloaded,omitempty"`
}

// UpdateInstallProgress progress details during installation of updates.
type UpdateInstallProgress struct {
	// PercentComplete - READ-ONLY; Percentage completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// NumberOfUpdatesToInstall - READ-ONLY; Number of updates to install.
	NumberOfUpdatesToInstall *int32 `json:"numberOfUpdatesToInstall,omitempty"`
	// NumberOfUpdatesInstalled - READ-ONLY; Number of updates installed.
	NumberOfUpdatesInstalled *int32 `json:"numberOfUpdatesInstalled,omitempty"`
}

// UpdateSummary details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	autorest.Response `json:"-"`
	// UpdateSummaryProperties - The device update information summary.
	*UpdateSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateSummary.
func (us UpdateSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if us.UpdateSummaryProperties != nil {
		objectMap["properties"] = us.UpdateSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateSummary struct.
func (us *UpdateSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateSummaryProperties UpdateSummaryProperties
				err = json.Unmarshal(*v, &updateSummaryProperties)
				if err != nil {
					return err
				}
				us.UpdateSummaryProperties = &updateSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		}
	}

	return nil
}

// UpdateSummaryProperties the device update information summary.
type UpdateSummaryProperties struct {
	// DeviceVersionNumber - The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string `json:"deviceVersionNumber,omitempty"`
	// FriendlyDeviceVersionName - The current version of the device in text format.
	FriendlyDeviceVersionName *string `json:"friendlyDeviceVersionName,omitempty"`
	// DeviceLastScannedDateTime - The last time when a scan was done on the device.
	DeviceLastScannedDateTime *date.Time `json:"deviceLastScannedDateTime,omitempty"`
	// LastCompletedScanJobDateTime - The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *date.Time `json:"lastCompletedScanJobDateTime,omitempty"`
	// LastCompletedDownloadJobDateTime - READ-ONLY; The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *date.Time `json:"lastCompletedDownloadJobDateTime,omitempty"`
	// LastCompletedInstallJobDateTime - READ-ONLY; The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *date.Time `json:"lastCompletedInstallJobDateTime,omitempty"`
	// TotalNumberOfUpdatesAvailable - READ-ONLY; The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32 `json:"totalNumberOfUpdatesAvailable,omitempty"`
	// TotalNumberOfUpdatesPendingDownload - READ-ONLY; The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32 `json:"totalNumberOfUpdatesPendingDownload,omitempty"`
	// TotalNumberOfUpdatesPendingInstall - READ-ONLY; The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32 `json:"totalNumberOfUpdatesPendingInstall,omitempty"`
	// RebootBehavior - READ-ONLY; Indicates if updates are available and at least one of the updates needs a reboot. Possible values include: 'NeverReboots', 'RequiresReboot', 'RequestReboot'
	RebootBehavior InstallRebootBehavior `json:"rebootBehavior,omitempty"`
	// OngoingUpdateOperation - READ-ONLY; The current update operation. Possible values include: 'UpdateOperationNone', 'UpdateOperationScan', 'UpdateOperationDownload', 'UpdateOperationInstall'
	OngoingUpdateOperation UpdateOperation `json:"ongoingUpdateOperation,omitempty"`
	// InProgressDownloadJobID - READ-ONLY; The job ID of the download job in progress.
	InProgressDownloadJobID *string `json:"inProgressDownloadJobId,omitempty"`
	// InProgressInstallJobID - READ-ONLY; The job ID of the install job in progress.
	InProgressInstallJobID *string `json:"inProgressInstallJobId,omitempty"`
	// InProgressDownloadJobStartedDateTime - READ-ONLY; The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *date.Time `json:"inProgressDownloadJobStartedDateTime,omitempty"`
	// InProgressInstallJobStartedDateTime - READ-ONLY; The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *date.Time `json:"inProgressInstallJobStartedDateTime,omitempty"`
	// UpdateTitles - READ-ONLY; The list of updates available for install.
	UpdateTitles *[]string `json:"updateTitles,omitempty"`
	// TotalUpdateSizeInBytes - READ-ONLY; The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64 `json:"totalUpdateSizeInBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateSummaryProperties.
func (usp UpdateSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usp.DeviceVersionNumber != nil {
		objectMap["deviceVersionNumber"] = usp.DeviceVersionNumber
	}
	if usp.FriendlyDeviceVersionName != nil {
		objectMap["friendlyDeviceVersionName"] = usp.FriendlyDeviceVersionName
	}
	if usp.DeviceLastScannedDateTime != nil {
		objectMap["deviceLastScannedDateTime"] = usp.DeviceLastScannedDateTime
	}
	if usp.LastCompletedScanJobDateTime != nil {
		objectMap["lastCompletedScanJobDateTime"] = usp.LastCompletedScanJobDateTime
	}
	return json.Marshal(objectMap)
}

// UploadCertificateRequest the upload certificate request.
type UploadCertificateRequest struct {
	// RawCertificateData - The Base 64 encoded certificate raw data.
	*RawCertificateData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UploadCertificateRequest.
func (ucr UploadCertificateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucr.RawCertificateData != nil {
		objectMap["properties"] = ucr.RawCertificateData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UploadCertificateRequest struct.
func (ucr *UploadCertificateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var rawCertificateData RawCertificateData
				err = json.Unmarshal(*v, &rawCertificateData)
				if err != nil {
					return err
				}
				ucr.RawCertificateData = &rawCertificateData
			}
		}
	}

	return nil
}

// UploadCertificateResponse the upload registration certificate response.
type UploadCertificateResponse struct {
	autorest.Response `json:"-"`
	// AuthType - Specifies authentication type. Possible values include: 'Invalid', 'AzureActiveDirectory'
	AuthType AuthenticationType `json:"authType,omitempty"`
	// ResourceID - The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string `json:"resourceId,omitempty"`
	// AadAuthority - Azure Active Directory tenant authority.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// AadTenantID - Azure Active Directory tenant ID.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// ServicePrincipalObjectID - Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`
	// AzureManagementEndpointAudience - The azure management endpoint audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`
}

// User represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - The storage account credential properties.
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The path ID that uniquely identifies the object.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The object name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The hierarchical type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UserAccessRight the mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// UserID - User ID (already existing in the device).
	UserID *string `json:"userId,omitempty"`
	// AccessType - Type of access to be allowed for the user. Possible values include: 'Change', 'Read', 'Custom'
	AccessType ShareAccessType `json:"accessType,omitempty"`
}

// UserList collection of users.
type UserList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of users.
	Value *[]User `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserListIterator provides access to a complete listing of User values.
type UserListIterator struct {
	i    int
	page UserListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListIterator) Response() UserList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserListIterator type.
func NewUserListIterator(page UserListPage) UserListIterator {
	return UserListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ul UserList) IsEmpty() bool {
	return ul.Value == nil || len(*ul.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ul UserList) hasNextLink() bool {
	return ul.NextLink != nil && len(*ul.NextLink) != 0
}

// userListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ul UserList) userListPreparer(ctx context.Context) (*http.Request, error) {
	if !ul.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ul.NextLink)))
}

// UserListPage contains a page of User values.
type UserListPage struct {
	fn func(context.Context, UserList) (UserList, error)
	ul UserList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ul)
		if err != nil {
			return err
		}
		page.ul = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListPage) NotDone() bool {
	return !page.ul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListPage) Response() UserList {
	return page.ul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListPage) Values() []User {
	if page.ul.IsEmpty() {
		return nil
	}
	return *page.ul.Value
}

// Creates a new instance of the UserListPage type.
func NewUserListPage(cur UserList, getNextPage func(context.Context, UserList) (UserList, error)) UserListPage {
	return UserListPage{
		fn: getNextPage,
		ul: cur,
	}
}

// UserProperties the user properties.
type UserProperties struct {
	// EncryptedPassword - The password details.
	EncryptedPassword *AsymmetricEncryptedSecret `json:"encryptedPassword,omitempty"`
	// ShareAccessRights - List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights *[]ShareAccessRight `json:"shareAccessRights,omitempty"`
}

// UsersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UsersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (User, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersCreateOrUpdateFuture.Result.
func (future *UsersCreateOrUpdateFuture) result(client UsersClient) (u User, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.UsersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		u.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.UsersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.CreateOrUpdateResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databoxedge.UsersCreateOrUpdateFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersDeleteFuture.Result.
func (future *UsersDeleteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databoxedge.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("databoxedge.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
