// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package storagepool

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/storagepool/mgmt/2020-03-15-preview/storagepool"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type OperationalStatus = original.OperationalStatus

const (
	Healthy   OperationalStatus = original.Healthy
	Invalid   OperationalStatus = original.Invalid
	Unhealthy OperationalStatus = original.Unhealthy
	Unknown   OperationalStatus = original.Unknown
)

type ProvisioningStates = original.ProvisioningStates

const (
	ProvisioningStatesCanceled  ProvisioningStates = original.ProvisioningStatesCanceled
	ProvisioningStatesCreating  ProvisioningStates = original.ProvisioningStatesCreating
	ProvisioningStatesDeleting  ProvisioningStates = original.ProvisioningStatesDeleting
	ProvisioningStatesFailed    ProvisioningStates = original.ProvisioningStatesFailed
	ProvisioningStatesInvalid   ProvisioningStates = original.ProvisioningStatesInvalid
	ProvisioningStatesPending   ProvisioningStates = original.ProvisioningStatesPending
	ProvisioningStatesSucceeded ProvisioningStates = original.ProvisioningStatesSucceeded
	ProvisioningStatesUpdating  ProvisioningStates = original.ProvisioningStatesUpdating
)

type SkuTier = original.SkuTier

const (
	Basic    SkuTier = original.Basic
	Free     SkuTier = original.Free
	Premium  SkuTier = original.Premium
	Standard SkuTier = original.Standard
)

type ACL = original.ACL
type Attributes = original.Attributes
type BaseClient = original.BaseClient
type Disk = original.Disk
type DiskPool = original.DiskPool
type DiskPoolListResult = original.DiskPoolListResult
type DiskPoolListResultIterator = original.DiskPoolListResultIterator
type DiskPoolListResultPage = original.DiskPoolListResultPage
type DiskPoolProperties = original.DiskPoolProperties
type DiskPoolsClient = original.DiskPoolsClient
type DiskPoolsCreateOrUpdateFuture = original.DiskPoolsCreateOrUpdateFuture
type DiskPoolsDeleteFuture = original.DiskPoolsDeleteFuture
type Error = original.Error
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type IscsiLun = original.IscsiLun
type IscsiTarget = original.IscsiTarget
type IscsiTargetCredentials = original.IscsiTargetCredentials
type IscsiTargetList = original.IscsiTargetList
type IscsiTargetListIterator = original.IscsiTargetListIterator
type IscsiTargetListPage = original.IscsiTargetListPage
type IscsiTargetProperties = original.IscsiTargetProperties
type IscsiTargetsClient = original.IscsiTargetsClient
type IscsiTargetsCreateOrUpdateFuture = original.IscsiTargetsCreateOrUpdateFuture
type IscsiTargetsDeleteFuture = original.IscsiTargetsDeleteFuture
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type RPOperation = original.RPOperation
type Resource = original.Resource
type Sku = original.Sku
type SystemMetadata = original.SystemMetadata
type TargetPortalGroup = original.TargetPortalGroup
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDiskPoolListResultIterator(page DiskPoolListResultPage) DiskPoolListResultIterator {
	return original.NewDiskPoolListResultIterator(page)
}
func NewDiskPoolListResultPage(cur DiskPoolListResult, getNextPage func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)) DiskPoolListResultPage {
	return original.NewDiskPoolListResultPage(cur, getNextPage)
}
func NewDiskPoolsClient(subscriptionID string) DiskPoolsClient {
	return original.NewDiskPoolsClient(subscriptionID)
}
func NewDiskPoolsClientWithBaseURI(baseURI string, subscriptionID string) DiskPoolsClient {
	return original.NewDiskPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIscsiTargetListIterator(page IscsiTargetListPage) IscsiTargetListIterator {
	return original.NewIscsiTargetListIterator(page)
}
func NewIscsiTargetListPage(cur IscsiTargetList, getNextPage func(context.Context, IscsiTargetList) (IscsiTargetList, error)) IscsiTargetListPage {
	return original.NewIscsiTargetListPage(cur, getNextPage)
}
func NewIscsiTargetsClient(subscriptionID string) IscsiTargetsClient {
	return original.NewIscsiTargetsClient(subscriptionID)
}
func NewIscsiTargetsClientWithBaseURI(baseURI string, subscriptionID string) IscsiTargetsClient {
	return original.NewIscsiTargetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleOperationalStatusValues() []OperationalStatus {
	return original.PossibleOperationalStatusValues()
}
func PossibleProvisioningStatesValues() []ProvisioningStates {
	return original.PossibleProvisioningStatesValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
