// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetAggregateResourceConfig = "BatchGetAggregateResourceConfig"

// BatchGetAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAggregateResourceConfig for more information on using the BatchGetAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetAggregateResourceConfigRequest method.
//    req, resp := client.BatchGetAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig
func (c *ConfigService) BatchGetAggregateResourceConfigRequest(input *BatchGetAggregateResourceConfigInput) (req *request.Request, output *BatchGetAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opBatchGetAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetAggregateResourceConfigInput{}
	}

	output = &BatchGetAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetAggregateResourceConfig API operation for AWS Config.
//
// Returns the current configuration items for resources that are present in
// your AWS Config aggregator. The operation also returns a list of resources
// that are not processed in the current request. If there are no unprocessed
// resources, the operation returns an empty unprocessedResourceIdentifiers
// list.
//
//    * The API does not return results for deleted resources.
//
//    * The API does not return tags and relationships.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation BatchGetAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig
func (c *ConfigService) BatchGetAggregateResourceConfig(input *BatchGetAggregateResourceConfigInput) (*BatchGetAggregateResourceConfigOutput, error) {
	req, out := c.BatchGetAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// BatchGetAggregateResourceConfigWithContext is the same as BatchGetAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) BatchGetAggregateResourceConfigWithContext(ctx aws.Context, input *BatchGetAggregateResourceConfigInput, opts ...request.Option) (*BatchGetAggregateResourceConfigOutput, error) {
	req, out := c.BatchGetAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetResourceConfig = "BatchGetResourceConfig"

// BatchGetResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetResourceConfig for more information on using the BatchGetResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetResourceConfigRequest method.
//    req, resp := client.BatchGetResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfigRequest(input *BatchGetResourceConfigInput) (req *request.Request, output *BatchGetResourceConfigOutput) {
	op := &request.Operation{
		Name:       opBatchGetResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetResourceConfigInput{}
	}

	output = &BatchGetResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetResourceConfig API operation for AWS Config.
//
// Returns the current configuration for one or more requested resources. The
// operation also returns a list of resources that are not processed in the
// current request. If there are no unprocessed resources, the operation returns
// an empty unprocessedResourceKeys list.
//
//    * The API does not return results for deleted resources.
//
//    * The API does not return any tags for the requested resources. This information
//    is filtered out of the supplementaryConfiguration section of the API response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation BatchGetResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfig(input *BatchGetResourceConfigInput) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	return out, req.Send()
}

// BatchGetResourceConfigWithContext is the same as BatchGetResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) BatchGetResourceConfigWithContext(ctx aws.Context, input *BatchGetResourceConfigInput, opts ...request.Option) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAggregationAuthorization = "DeleteAggregationAuthorization"

// DeleteAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAggregationAuthorization for more information on using the DeleteAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAggregationAuthorizationRequest method.
//    req, resp := client.DeleteAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorizationRequest(input *DeleteAggregationAuthorizationInput) (req *request.Request, output *DeleteAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAggregationAuthorizationInput{}
	}

	output = &DeleteAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAggregationAuthorization API operation for AWS Config.
//
// Deletes the authorization granted to the specified configuration aggregator
// account in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteAggregationAuthorization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorization(input *DeleteAggregationAuthorizationInput) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteAggregationAuthorizationWithContext is the same as DeleteAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteAggregationAuthorizationWithContext(ctx aws.Context, input *DeleteAggregationAuthorizationInput, opts ...request.Option) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigRule = "DeleteConfigRule"

// DeleteConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigRule for more information on using the DeleteConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigRuleRequest method.
//    req, resp := client.DeleteConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRuleRequest(input *DeleteConfigRuleInput) (req *request.Request, output *DeleteConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigRuleInput{}
	}

	output = &DeleteConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigRule API operation for AWS Config.
//
// Deletes the specified AWS Config rule and all of its evaluation results.
//
// AWS Config sets the state of a rule to DELETING until the deletion is complete.
// You cannot update a rule while it is in this state. If you make a PutConfigRule
// or DeleteConfigRule request for the rule, you will receive a ResourceInUseException.
//
// You can check the state of a rule by using the DescribeConfigRules request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigRule for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRule(input *DeleteConfigRuleInput) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	return out, req.Send()
}

// DeleteConfigRuleWithContext is the same as DeleteConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigRuleWithContext(ctx aws.Context, input *DeleteConfigRuleInput, opts ...request.Option) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationAggregator = "DeleteConfigurationAggregator"

// DeleteConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationAggregator for more information on using the DeleteConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationAggregatorRequest method.
//    req, resp := client.DeleteConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregatorRequest(input *DeleteConfigurationAggregatorInput) (req *request.Request, output *DeleteConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationAggregatorInput{}
	}

	output = &DeleteConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationAggregator API operation for AWS Config.
//
// Deletes the specified configuration aggregator and the aggregated data associated
// with the aggregator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationAggregator for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregator(input *DeleteConfigurationAggregatorInput) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// DeleteConfigurationAggregatorWithContext is the same as DeleteConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationAggregatorWithContext(ctx aws.Context, input *DeleteConfigurationAggregatorInput, opts ...request.Option) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationRecorder = "DeleteConfigurationRecorder"

// DeleteConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationRecorder for more information on using the DeleteConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationRecorderRequest method.
//    req, resp := client.DeleteConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorderRequest(input *DeleteConfigurationRecorderInput) (req *request.Request, output *DeleteConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationRecorderInput{}
	}

	output = &DeleteConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationRecorder API operation for AWS Config.
//
// Deletes the configuration recorder.
//
// After the configuration recorder is deleted, AWS Config will not record resource
// configuration changes until you create a new configuration recorder.
//
// This action does not delete the configuration information that was previously
// recorded. You will be able to access the previously recorded information
// by using the GetResourceConfigHistory action, but you will not be able to
// access this information in the AWS Config console until you create a new
// configuration recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorder(input *DeleteConfigurationRecorderInput) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	return out, req.Send()
}

// DeleteConfigurationRecorderWithContext is the same as DeleteConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationRecorderWithContext(ctx aws.Context, input *DeleteConfigurationRecorderInput, opts ...request.Option) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConformancePack = "DeleteConformancePack"

// DeleteConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConformancePack for more information on using the DeleteConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConformancePackRequest method.
//    req, resp := client.DeleteConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack
func (c *ConfigService) DeleteConformancePackRequest(input *DeleteConformancePackInput) (req *request.Request, output *DeleteConformancePackOutput) {
	op := &request.Operation{
		Name:       opDeleteConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConformancePackInput{}
	}

	output = &DeleteConformancePackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConformancePack API operation for AWS Config.
//
// Deletes the specified conformance pack and all the AWS Config rules, remediation
// actions, and all evaluation results within that conformance pack.
//
// AWS Config sets the conformance pack to DELETE_IN_PROGRESS until the deletion
// is complete. You cannot update a conformance pack while it is in this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConformancePack for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack
func (c *ConfigService) DeleteConformancePack(input *DeleteConformancePackInput) (*DeleteConformancePackOutput, error) {
	req, out := c.DeleteConformancePackRequest(input)
	return out, req.Send()
}

// DeleteConformancePackWithContext is the same as DeleteConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConformancePackWithContext(ctx aws.Context, input *DeleteConformancePackInput, opts ...request.Option) (*DeleteConformancePackOutput, error) {
	req, out := c.DeleteConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeliveryChannel = "DeleteDeliveryChannel"

// DeleteDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeliveryChannel for more information on using the DeleteDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeliveryChannelRequest method.
//    req, resp := client.DeleteDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannelRequest(input *DeleteDeliveryChannelInput) (req *request.Request, output *DeleteDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryChannelInput{}
	}

	output = &DeleteDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeliveryChannel API operation for AWS Config.
//
// Deletes the delivery channel.
//
// Before you can delete the delivery channel, you must stop the configuration
// recorder by using the StopConfigurationRecorder action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteDeliveryChannel for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
//   * LastDeliveryChannelDeleteFailedException
//   You cannot delete the delivery channel you specified because the configuration
//   recorder is running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannel(input *DeleteDeliveryChannelInput) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	return out, req.Send()
}

// DeleteDeliveryChannelWithContext is the same as DeleteDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteDeliveryChannelWithContext(ctx aws.Context, input *DeleteDeliveryChannelInput, opts ...request.Option) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvaluationResults = "DeleteEvaluationResults"

// DeleteEvaluationResultsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvaluationResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvaluationResults for more information on using the DeleteEvaluationResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEvaluationResultsRequest method.
//    req, resp := client.DeleteEvaluationResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResultsRequest(input *DeleteEvaluationResultsInput) (req *request.Request, output *DeleteEvaluationResultsOutput) {
	op := &request.Operation{
		Name:       opDeleteEvaluationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationResultsInput{}
	}

	output = &DeleteEvaluationResultsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvaluationResults API operation for AWS Config.
//
// Deletes the evaluation results for the specified AWS Config rule. You can
// specify one AWS Config rule per request. After you delete the evaluation
// results, you can call the StartConfigRulesEvaluation API to start evaluating
// your AWS resources against the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteEvaluationResults for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResults(input *DeleteEvaluationResultsInput) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	return out, req.Send()
}

// DeleteEvaluationResultsWithContext is the same as DeleteEvaluationResults with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvaluationResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteEvaluationResultsWithContext(ctx aws.Context, input *DeleteEvaluationResultsInput, opts ...request.Option) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationConfigRule = "DeleteOrganizationConfigRule"

// DeleteOrganizationConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganizationConfigRule for more information on using the DeleteOrganizationConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationConfigRuleRequest method.
//    req, resp := client.DeleteOrganizationConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule
func (c *ConfigService) DeleteOrganizationConfigRuleRequest(input *DeleteOrganizationConfigRuleInput) (req *request.Request, output *DeleteOrganizationConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationConfigRuleInput{}
	}

	output = &DeleteOrganizationConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationConfigRule API operation for AWS Config.
//
// Deletes the specified organization config rule and all of its evaluation
// results from all member accounts in that organization.
//
// Only a master account and a delegated administrator account can delete an
// organization config rule. When calling this API with a delegated administrator,
// you must ensure AWS Organizations ListDelegatedAdministrator permissions
// are added.
//
// AWS Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion
// is complete. You cannot update a rule while it is in this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteOrganizationConfigRule for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   You specified one or more organization config rules that do not exist.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule
func (c *ConfigService) DeleteOrganizationConfigRule(input *DeleteOrganizationConfigRuleInput) (*DeleteOrganizationConfigRuleOutput, error) {
	req, out := c.DeleteOrganizationConfigRuleRequest(input)
	return out, req.Send()
}

// DeleteOrganizationConfigRuleWithContext is the same as DeleteOrganizationConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteOrganizationConfigRuleWithContext(ctx aws.Context, input *DeleteOrganizationConfigRuleInput, opts ...request.Option) (*DeleteOrganizationConfigRuleOutput, error) {
	req, out := c.DeleteOrganizationConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationConformancePack = "DeleteOrganizationConformancePack"

// DeleteOrganizationConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganizationConformancePack for more information on using the DeleteOrganizationConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationConformancePackRequest method.
//    req, resp := client.DeleteOrganizationConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack
func (c *ConfigService) DeleteOrganizationConformancePackRequest(input *DeleteOrganizationConformancePackInput) (req *request.Request, output *DeleteOrganizationConformancePackOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationConformancePackInput{}
	}

	output = &DeleteOrganizationConformancePackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationConformancePack API operation for AWS Config.
//
// Deletes the specified organization conformance pack and all of the config
// rules and remediation actions from all member accounts in that organization.
//
// Only a master account or a delegated administrator account can delete an
// organization conformance pack. When calling this API with a delegated administrator,
// you must ensure AWS Organizations ListDelegatedAdministrator permissions
// are added.
//
// AWS Config sets the state of a conformance pack to DELETE_IN_PROGRESS until
// the deletion is complete. You cannot update a conformance pack while it is
// in this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteOrganizationConformancePack for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   AWS Config organization conformance pack that you passed in the filter does
//   not exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack
func (c *ConfigService) DeleteOrganizationConformancePack(input *DeleteOrganizationConformancePackInput) (*DeleteOrganizationConformancePackOutput, error) {
	req, out := c.DeleteOrganizationConformancePackRequest(input)
	return out, req.Send()
}

// DeleteOrganizationConformancePackWithContext is the same as DeleteOrganizationConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteOrganizationConformancePackWithContext(ctx aws.Context, input *DeleteOrganizationConformancePackInput, opts ...request.Option) (*DeleteOrganizationConformancePackOutput, error) {
	req, out := c.DeleteOrganizationConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePendingAggregationRequest = "DeletePendingAggregationRequest"

// DeletePendingAggregationRequestRequest generates a "aws/request.Request" representing the
// client's request for the DeletePendingAggregationRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePendingAggregationRequest for more information on using the DeletePendingAggregationRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePendingAggregationRequestRequest method.
//    req, resp := client.DeletePendingAggregationRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequestRequest(input *DeletePendingAggregationRequestInput) (req *request.Request, output *DeletePendingAggregationRequestOutput) {
	op := &request.Operation{
		Name:       opDeletePendingAggregationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePendingAggregationRequestInput{}
	}

	output = &DeletePendingAggregationRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePendingAggregationRequest API operation for AWS Config.
//
// Deletes pending authorization requests for a specified aggregator account
// in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeletePendingAggregationRequest for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequest(input *DeletePendingAggregationRequestInput) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	return out, req.Send()
}

// DeletePendingAggregationRequestWithContext is the same as DeletePendingAggregationRequest with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePendingAggregationRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeletePendingAggregationRequestWithContext(ctx aws.Context, input *DeletePendingAggregationRequestInput, opts ...request.Option) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRemediationConfiguration = "DeleteRemediationConfiguration"

// DeleteRemediationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemediationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRemediationConfiguration for more information on using the DeleteRemediationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRemediationConfigurationRequest method.
//    req, resp := client.DeleteRemediationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration
func (c *ConfigService) DeleteRemediationConfigurationRequest(input *DeleteRemediationConfigurationInput) (req *request.Request, output *DeleteRemediationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRemediationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemediationConfigurationInput{}
	}

	output = &DeleteRemediationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRemediationConfiguration API operation for AWS Config.
//
// Deletes the remediation configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRemediationConfiguration for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationConfigurationException
//   You specified an AWS Config rule without a remediation configuration.
//
//   * RemediationInProgressException
//   Remediation action is in progress. You can either cancel execution in AWS
//   Systems Manager or wait and try again later.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration
func (c *ConfigService) DeleteRemediationConfiguration(input *DeleteRemediationConfigurationInput) (*DeleteRemediationConfigurationOutput, error) {
	req, out := c.DeleteRemediationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRemediationConfigurationWithContext is the same as DeleteRemediationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRemediationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRemediationConfigurationWithContext(ctx aws.Context, input *DeleteRemediationConfigurationInput, opts ...request.Option) (*DeleteRemediationConfigurationOutput, error) {
	req, out := c.DeleteRemediationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRemediationExceptions = "DeleteRemediationExceptions"

// DeleteRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRemediationExceptions for more information on using the DeleteRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRemediationExceptionsRequest method.
//    req, resp := client.DeleteRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions
func (c *ConfigService) DeleteRemediationExceptionsRequest(input *DeleteRemediationExceptionsInput) (req *request.Request, output *DeleteRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemediationExceptionsInput{}
	}

	output = &DeleteRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRemediationExceptions API operation for AWS Config.
//
// Deletes one or more remediation exceptions mentioned in the resource keys.
//
// AWS Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationExceptionException
//   You tried to delete a remediation exception that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions
func (c *ConfigService) DeleteRemediationExceptions(input *DeleteRemediationExceptionsInput) (*DeleteRemediationExceptionsOutput, error) {
	req, out := c.DeleteRemediationExceptionsRequest(input)
	return out, req.Send()
}

// DeleteRemediationExceptionsWithContext is the same as DeleteRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRemediationExceptionsWithContext(ctx aws.Context, input *DeleteRemediationExceptionsInput, opts ...request.Option) (*DeleteRemediationExceptionsOutput, error) {
	req, out := c.DeleteRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceConfig = "DeleteResourceConfig"

// DeleteResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceConfig for more information on using the DeleteResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceConfigRequest method.
//    req, resp := client.DeleteResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig
func (c *ConfigService) DeleteResourceConfigRequest(input *DeleteResourceConfigInput) (req *request.Request, output *DeleteResourceConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceConfigInput{}
	}

	output = &DeleteResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceConfig API operation for AWS Config.
//
// Records the configuration state for a custom resource that has been deleted.
// This API records a new ConfigurationItem with a ResourceDeleted status. You
// can retrieve the ConfigurationItems recorded for this resource in your AWS
// Config History.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig
func (c *ConfigService) DeleteResourceConfig(input *DeleteResourceConfigInput) (*DeleteResourceConfigOutput, error) {
	req, out := c.DeleteResourceConfigRequest(input)
	return out, req.Send()
}

// DeleteResourceConfigWithContext is the same as DeleteResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteResourceConfigWithContext(ctx aws.Context, input *DeleteResourceConfigInput, opts ...request.Option) (*DeleteResourceConfigOutput, error) {
	req, out := c.DeleteResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRetentionConfiguration = "DeleteRetentionConfiguration"

// DeleteRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRetentionConfiguration for more information on using the DeleteRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRetentionConfigurationRequest method.
//    req, resp := client.DeleteRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfigurationRequest(input *DeleteRetentionConfigurationInput) (req *request.Request, output *DeleteRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionConfigurationInput{}
	}

	output = &DeleteRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRetentionConfiguration API operation for AWS Config.
//
// Deletes the retention configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRetentionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchRetentionConfigurationException
//   You have specified a retention configuration that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfiguration(input *DeleteRetentionConfigurationInput) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRetentionConfigurationWithContext is the same as DeleteRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRetentionConfigurationWithContext(ctx aws.Context, input *DeleteRetentionConfigurationInput, opts ...request.Option) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStoredQuery = "DeleteStoredQuery"

// DeleteStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStoredQuery for more information on using the DeleteStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStoredQueryRequest method.
//    req, resp := client.DeleteStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery
func (c *ConfigService) DeleteStoredQueryRequest(input *DeleteStoredQueryInput) (req *request.Request, output *DeleteStoredQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStoredQueryInput{}
	}

	output = &DeleteStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStoredQuery API operation for AWS Config.
//
// Deletes the stored query for a single AWS account and a single AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery
func (c *ConfigService) DeleteStoredQuery(input *DeleteStoredQueryInput) (*DeleteStoredQueryOutput, error) {
	req, out := c.DeleteStoredQueryRequest(input)
	return out, req.Send()
}

// DeleteStoredQueryWithContext is the same as DeleteStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteStoredQueryWithContext(ctx aws.Context, input *DeleteStoredQueryInput, opts ...request.Option) (*DeleteStoredQueryOutput, error) {
	req, out := c.DeleteStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeliverConfigSnapshot = "DeliverConfigSnapshot"

// DeliverConfigSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeliverConfigSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeliverConfigSnapshot for more information on using the DeliverConfigSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeliverConfigSnapshotRequest method.
//    req, resp := client.DeliverConfigSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshotRequest(input *DeliverConfigSnapshotInput) (req *request.Request, output *DeliverConfigSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeliverConfigSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeliverConfigSnapshotInput{}
	}

	output = &DeliverConfigSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeliverConfigSnapshot API operation for AWS Config.
//
// Schedules delivery of a configuration snapshot to the Amazon S3 bucket in
// the specified delivery channel. After the delivery has started, AWS Config
// sends the following notifications using an Amazon SNS topic that you have
// specified.
//
//    * Notification of the start of the delivery.
//
//    * Notification of the completion of the delivery, if the delivery was
//    successfully completed.
//
//    * Notification of delivery failure, if the delivery failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeliverConfigSnapshot for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshot(input *DeliverConfigSnapshotInput) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	return out, req.Send()
}

// DeliverConfigSnapshotWithContext is the same as DeliverConfigSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeliverConfigSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeliverConfigSnapshotWithContext(ctx aws.Context, input *DeliverConfigSnapshotInput, opts ...request.Option) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregateComplianceByConfigRules = "DescribeAggregateComplianceByConfigRules"

// DescribeAggregateComplianceByConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateComplianceByConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateComplianceByConfigRules for more information on using the DescribeAggregateComplianceByConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateComplianceByConfigRulesRequest method.
//    req, resp := client.DescribeAggregateComplianceByConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesRequest(input *DescribeAggregateComplianceByConfigRulesInput) (req *request.Request, output *DescribeAggregateComplianceByConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateComplianceByConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConfigRulesInput{}
	}

	output = &DescribeAggregateComplianceByConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateComplianceByConfigRules API operation for AWS Config.
//
// Returns a list of compliant and noncompliant rules with the number of resources
// for compliant and noncompliant rules.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregateComplianceByConfigRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRules(input *DescribeAggregateComplianceByConfigRulesInput) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeAggregateComplianceByConfigRulesWithContext is the same as DescribeAggregateComplianceByConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateComplianceByConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConfigRulesInput, opts ...request.Option) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregateComplianceByConformancePacks = "DescribeAggregateComplianceByConformancePacks"

// DescribeAggregateComplianceByConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateComplianceByConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateComplianceByConformancePacks for more information on using the DescribeAggregateComplianceByConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateComplianceByConformancePacksRequest method.
//    req, resp := client.DescribeAggregateComplianceByConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksRequest(input *DescribeAggregateComplianceByConformancePacksInput) (req *request.Request, output *DescribeAggregateComplianceByConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateComplianceByConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConformancePacksInput{}
	}

	output = &DescribeAggregateComplianceByConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateComplianceByConformancePacks API operation for AWS Config.
//
// Returns a list of the conformance packs and their associated compliance status
// with the count of compliant and noncompliant AWS Config rules within each
// conformance pack. Also returns the total rule count which includes compliant
// rules, noncompliant rules, and rules that cannot be evaluated due to insufficient
// data.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregateComplianceByConformancePacks for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks
func (c *ConfigService) DescribeAggregateComplianceByConformancePacks(input *DescribeAggregateComplianceByConformancePacksInput) (*DescribeAggregateComplianceByConformancePacksOutput, error) {
	req, out := c.DescribeAggregateComplianceByConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeAggregateComplianceByConformancePacksWithContext is the same as DescribeAggregateComplianceByConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateComplianceByConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConformancePacksInput, opts ...request.Option) (*DescribeAggregateComplianceByConformancePacksOutput, error) {
	req, out := c.DescribeAggregateComplianceByConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregationAuthorizations = "DescribeAggregationAuthorizations"

// DescribeAggregationAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregationAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregationAuthorizations for more information on using the DescribeAggregationAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregationAuthorizationsRequest method.
//    req, resp := client.DescribeAggregationAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizationsRequest(input *DescribeAggregationAuthorizationsInput) (req *request.Request, output *DescribeAggregationAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregationAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregationAuthorizationsInput{}
	}

	output = &DescribeAggregationAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregationAuthorizations API operation for AWS Config.
//
// Returns a list of authorizations granted to various aggregator accounts and
// regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregationAuthorizations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizations(input *DescribeAggregationAuthorizationsInput) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	return out, req.Send()
}

// DescribeAggregationAuthorizationsWithContext is the same as DescribeAggregationAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregationAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregationAuthorizationsWithContext(ctx aws.Context, input *DescribeAggregationAuthorizationsInput, opts ...request.Option) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComplianceByConfigRule = "DescribeComplianceByConfigRule"

// DescribeComplianceByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByConfigRule for more information on using the DescribeComplianceByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByConfigRuleRequest method.
//    req, resp := client.DescribeComplianceByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRuleRequest(input *DescribeComplianceByConfigRuleInput) (req *request.Request, output *DescribeComplianceByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByConfigRuleInput{}
	}

	output = &DescribeComplianceByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByConfigRule API operation for AWS Config.
//
// Indicates whether the specified AWS Config rules are compliant. If a rule
// is noncompliant, this action returns the number of AWS resources that do
// not comply with the rule.
//
// A rule is compliant if all of the evaluated resources comply with it. It
// is noncompliant if any of these resources do not comply.
//
// If AWS Config has no current evaluation results for the rule, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRule(input *DescribeComplianceByConfigRuleInput) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	return out, req.Send()
}

// DescribeComplianceByConfigRuleWithContext is the same as DescribeComplianceByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByConfigRuleWithContext(ctx aws.Context, input *DescribeComplianceByConfigRuleInput, opts ...request.Option) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComplianceByResource = "DescribeComplianceByResource"

// DescribeComplianceByResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByResource for more information on using the DescribeComplianceByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByResourceRequest method.
//    req, resp := client.DescribeComplianceByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResourceRequest(input *DescribeComplianceByResourceInput) (req *request.Request, output *DescribeComplianceByResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByResourceInput{}
	}

	output = &DescribeComplianceByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByResource API operation for AWS Config.
//
// Indicates whether the specified AWS resources are compliant. If a resource
// is noncompliant, this action returns the number of AWS Config rules that
// the resource does not comply with.
//
// A resource is compliant if it complies with all the AWS Config rules that
// evaluate it. It is noncompliant if it does not comply with one or more of
// these rules.
//
// If AWS Config has no current evaluation results for the resource, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions
// about the rules that evaluate the resource:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role that you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResource(input *DescribeComplianceByResourceInput) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	return out, req.Send()
}

// DescribeComplianceByResourceWithContext is the same as DescribeComplianceByResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByResourceWithContext(ctx aws.Context, input *DescribeComplianceByResourceInput, opts ...request.Option) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigRuleEvaluationStatus = "DescribeConfigRuleEvaluationStatus"

// DescribeConfigRuleEvaluationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRuleEvaluationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRuleEvaluationStatus for more information on using the DescribeConfigRuleEvaluationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRuleEvaluationStatusRequest method.
//    req, resp := client.DescribeConfigRuleEvaluationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatusRequest(input *DescribeConfigRuleEvaluationStatusInput) (req *request.Request, output *DescribeConfigRuleEvaluationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRuleEvaluationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRuleEvaluationStatusInput{}
	}

	output = &DescribeConfigRuleEvaluationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRuleEvaluationStatus API operation for AWS Config.
//
// Returns status information for each of your AWS managed Config rules. The
// status includes information such as the last time AWS Config invoked the
// rule, the last time AWS Config failed to invoke the rule, and the related
// error for the last failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRuleEvaluationStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatus(input *DescribeConfigRuleEvaluationStatusInput) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigRuleEvaluationStatusWithContext is the same as DescribeConfigRuleEvaluationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRuleEvaluationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRuleEvaluationStatusWithContext(ctx aws.Context, input *DescribeConfigRuleEvaluationStatusInput, opts ...request.Option) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigRules = "DescribeConfigRules"

// DescribeConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRules for more information on using the DescribeConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRulesRequest method.
//    req, resp := client.DescribeConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRulesRequest(input *DescribeConfigRulesInput) (req *request.Request, output *DescribeConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRulesInput{}
	}

	output = &DescribeConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRules API operation for AWS Config.
//
// Returns details about your AWS Config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRules for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRules(input *DescribeConfigRulesInput) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeConfigRulesWithContext is the same as DescribeConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRulesWithContext(ctx aws.Context, input *DescribeConfigRulesInput, opts ...request.Option) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationAggregatorSourcesStatus = "DescribeConfigurationAggregatorSourcesStatus"

// DescribeConfigurationAggregatorSourcesStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregatorSourcesStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregatorSourcesStatus for more information on using the DescribeConfigurationAggregatorSourcesStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorSourcesStatusRequest method.
//    req, resp := client.DescribeConfigurationAggregatorSourcesStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusRequest(input *DescribeConfigurationAggregatorSourcesStatusInput) (req *request.Request, output *DescribeConfigurationAggregatorSourcesStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregatorSourcesStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorSourcesStatusInput{}
	}

	output = &DescribeConfigurationAggregatorSourcesStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregatorSourcesStatus API operation for AWS Config.
//
// Returns status information for sources within an aggregator. The status includes
// information about the last time AWS Config verified authorization between
// the source account and an aggregator account. In case of a failure, the status
// contains the related error code or message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregatorSourcesStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatus(input *DescribeConfigurationAggregatorSourcesStatusInput) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorSourcesStatusWithContext is the same as DescribeConfigurationAggregatorSourcesStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregatorSourcesStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorSourcesStatusInput, opts ...request.Option) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationAggregators = "DescribeConfigurationAggregators"

// DescribeConfigurationAggregatorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregators for more information on using the DescribeConfigurationAggregators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorsRequest method.
//    req, resp := client.DescribeConfigurationAggregatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregatorsRequest(input *DescribeConfigurationAggregatorsInput) (req *request.Request, output *DescribeConfigurationAggregatorsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorsInput{}
	}

	output = &DescribeConfigurationAggregatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregators API operation for AWS Config.
//
// Returns the details of one or more configuration aggregators. If the configuration
// aggregator is not specified, this action returns the details for all the
// configuration aggregators associated with the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregators for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregators(input *DescribeConfigurationAggregatorsInput) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorsWithContext is the same as DescribeConfigurationAggregators with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorsWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorsInput, opts ...request.Option) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRecorderStatus = "DescribeConfigurationRecorderStatus"

// DescribeConfigurationRecorderStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorderStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorderStatus for more information on using the DescribeConfigurationRecorderStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecorderStatusRequest method.
//    req, resp := client.DescribeConfigurationRecorderStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatusRequest(input *DescribeConfigurationRecorderStatusInput) (req *request.Request, output *DescribeConfigurationRecorderStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorderStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecorderStatusInput{}
	}

	output = &DescribeConfigurationRecorderStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorderStatus API operation for AWS Config.
//
// Returns the current status of the specified configuration recorder. If a
// configuration recorder is not specified, this action returns the status of
// all configuration recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorderStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatus(input *DescribeConfigurationRecorderStatusInput) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecorderStatusWithContext is the same as DescribeConfigurationRecorderStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorderStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecorderStatusWithContext(ctx aws.Context, input *DescribeConfigurationRecorderStatusInput, opts ...request.Option) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRecorders = "DescribeConfigurationRecorders"

// DescribeConfigurationRecordersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorders for more information on using the DescribeConfigurationRecorders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecordersRequest method.
//    req, resp := client.DescribeConfigurationRecordersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecordersRequest(input *DescribeConfigurationRecordersInput) (req *request.Request, output *DescribeConfigurationRecordersOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecordersInput{}
	}

	output = &DescribeConfigurationRecordersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorders API operation for AWS Config.
//
// Returns the details for the specified configuration recorders. If the configuration
// recorder is not specified, this action returns the details for all configuration
// recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorders for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecorders(input *DescribeConfigurationRecordersInput) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecordersWithContext is the same as DescribeConfigurationRecorders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecordersWithContext(ctx aws.Context, input *DescribeConfigurationRecordersInput, opts ...request.Option) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConformancePackCompliance = "DescribeConformancePackCompliance"

// DescribeConformancePackComplianceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePackCompliance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePackCompliance for more information on using the DescribeConformancePackCompliance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePackComplianceRequest method.
//    req, resp := client.DescribeConformancePackComplianceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance
func (c *ConfigService) DescribeConformancePackComplianceRequest(input *DescribeConformancePackComplianceInput) (req *request.Request, output *DescribeConformancePackComplianceOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePackCompliance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConformancePackComplianceInput{}
	}

	output = &DescribeConformancePackComplianceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePackCompliance API operation for AWS Config.
//
// Returns compliance details for each rule in that conformance pack.
//
// You must provide exact rule names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePackCompliance for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigRuleInConformancePackException
//   AWS Config rule that you passed in the filter does not exist.
//
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance
func (c *ConfigService) DescribeConformancePackCompliance(input *DescribeConformancePackComplianceInput) (*DescribeConformancePackComplianceOutput, error) {
	req, out := c.DescribeConformancePackComplianceRequest(input)
	return out, req.Send()
}

// DescribeConformancePackComplianceWithContext is the same as DescribeConformancePackCompliance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePackCompliance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackComplianceWithContext(ctx aws.Context, input *DescribeConformancePackComplianceInput, opts ...request.Option) (*DescribeConformancePackComplianceOutput, error) {
	req, out := c.DescribeConformancePackComplianceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConformancePackStatus = "DescribeConformancePackStatus"

// DescribeConformancePackStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePackStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePackStatus for more information on using the DescribeConformancePackStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePackStatusRequest method.
//    req, resp := client.DescribeConformancePackStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus
func (c *ConfigService) DescribeConformancePackStatusRequest(input *DescribeConformancePackStatusInput) (req *request.Request, output *DescribeConformancePackStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePackStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConformancePackStatusInput{}
	}

	output = &DescribeConformancePackStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePackStatus API operation for AWS Config.
//
// Provides one or more conformance packs deployment status.
//
// If there are no conformance packs then you will see an empty result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePackStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus
func (c *ConfigService) DescribeConformancePackStatus(input *DescribeConformancePackStatusInput) (*DescribeConformancePackStatusOutput, error) {
	req, out := c.DescribeConformancePackStatusRequest(input)
	return out, req.Send()
}

// DescribeConformancePackStatusWithContext is the same as DescribeConformancePackStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePackStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackStatusWithContext(ctx aws.Context, input *DescribeConformancePackStatusInput, opts ...request.Option) (*DescribeConformancePackStatusOutput, error) {
	req, out := c.DescribeConformancePackStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConformancePacks = "DescribeConformancePacks"

// DescribeConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePacks for more information on using the DescribeConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePacksRequest method.
//    req, resp := client.DescribeConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks
func (c *ConfigService) DescribeConformancePacksRequest(input *DescribeConformancePacksInput) (req *request.Request, output *DescribeConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConformancePacksInput{}
	}

	output = &DescribeConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePacks API operation for AWS Config.
//
// Returns a list of one or more conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePacks for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks
func (c *ConfigService) DescribeConformancePacks(input *DescribeConformancePacksInput) (*DescribeConformancePacksOutput, error) {
	req, out := c.DescribeConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeConformancePacksWithContext is the same as DescribeConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePacksWithContext(ctx aws.Context, input *DescribeConformancePacksInput, opts ...request.Option) (*DescribeConformancePacksOutput, error) {
	req, out := c.DescribeConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryChannelStatus = "DescribeDeliveryChannelStatus"

// DescribeDeliveryChannelStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannelStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannelStatus for more information on using the DescribeDeliveryChannelStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelStatusRequest method.
//    req, resp := client.DescribeDeliveryChannelStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatusRequest(input *DescribeDeliveryChannelStatusInput) (req *request.Request, output *DescribeDeliveryChannelStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannelStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelStatusInput{}
	}

	output = &DescribeDeliveryChannelStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannelStatus API operation for AWS Config.
//
// Returns the current status of the specified delivery channel. If a delivery
// channel is not specified, this action returns the current status of all delivery
// channels associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannelStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatus(input *DescribeDeliveryChannelStatusInput) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelStatusWithContext is the same as DescribeDeliveryChannelStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannelStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelStatusWithContext(ctx aws.Context, input *DescribeDeliveryChannelStatusInput, opts ...request.Option) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryChannels = "DescribeDeliveryChannels"

// DescribeDeliveryChannelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannels for more information on using the DescribeDeliveryChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelsRequest method.
//    req, resp := client.DescribeDeliveryChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannelsRequest(input *DescribeDeliveryChannelsInput) (req *request.Request, output *DescribeDeliveryChannelsOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelsInput{}
	}

	output = &DescribeDeliveryChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannels API operation for AWS Config.
//
// Returns details about the specified delivery channel. If a delivery channel
// is not specified, this action returns the details of all delivery channels
// associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannels for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannels(input *DescribeDeliveryChannelsInput) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelsWithContext is the same as DescribeDeliveryChannels with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelsWithContext(ctx aws.Context, input *DescribeDeliveryChannelsInput, opts ...request.Option) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfigRuleStatuses = "DescribeOrganizationConfigRuleStatuses"

// DescribeOrganizationConfigRuleStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfigRuleStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfigRuleStatuses for more information on using the DescribeOrganizationConfigRuleStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigRuleStatusesRequest method.
//    req, resp := client.DescribeOrganizationConfigRuleStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesRequest(input *DescribeOrganizationConfigRuleStatusesInput) (req *request.Request, output *DescribeOrganizationConfigRuleStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfigRuleStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConfigRuleStatusesInput{}
	}

	output = &DescribeOrganizationConfigRuleStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfigRuleStatuses API operation for AWS Config.
//
// Provides organization config rule deployment status for an organization.
//
// The status is not considered successful until organization config rule is
// successfully deployed in all the member accounts with an exception of excluded
// accounts.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization config
// rule names. It is only applicable, when you request all the organization
// config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConfigRuleStatuses for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   You specified one or more organization config rules that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses
func (c *ConfigService) DescribeOrganizationConfigRuleStatuses(input *DescribeOrganizationConfigRuleStatusesInput) (*DescribeOrganizationConfigRuleStatusesOutput, error) {
	req, out := c.DescribeOrganizationConfigRuleStatusesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigRuleStatusesWithContext is the same as DescribeOrganizationConfigRuleStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfigRuleStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRuleStatusesInput, opts ...request.Option) (*DescribeOrganizationConfigRuleStatusesOutput, error) {
	req, out := c.DescribeOrganizationConfigRuleStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfigRules = "DescribeOrganizationConfigRules"

// DescribeOrganizationConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfigRules for more information on using the DescribeOrganizationConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigRulesRequest method.
//    req, resp := client.DescribeOrganizationConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules
func (c *ConfigService) DescribeOrganizationConfigRulesRequest(input *DescribeOrganizationConfigRulesInput) (req *request.Request, output *DescribeOrganizationConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConfigRulesInput{}
	}

	output = &DescribeOrganizationConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfigRules API operation for AWS Config.
//
// Returns a list of organization config rules.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization config
// rule names. It is only applicable, when you request all the organization
// config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConfigRules for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   You specified one or more organization config rules that do not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules
func (c *ConfigService) DescribeOrganizationConfigRules(input *DescribeOrganizationConfigRulesInput) (*DescribeOrganizationConfigRulesOutput, error) {
	req, out := c.DescribeOrganizationConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigRulesWithContext is the same as DescribeOrganizationConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRulesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRulesInput, opts ...request.Option) (*DescribeOrganizationConfigRulesOutput, error) {
	req, out := c.DescribeOrganizationConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConformancePackStatuses = "DescribeOrganizationConformancePackStatuses"

// DescribeOrganizationConformancePackStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConformancePackStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConformancePackStatuses for more information on using the DescribeOrganizationConformancePackStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConformancePackStatusesRequest method.
//    req, resp := client.DescribeOrganizationConformancePackStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses
func (c *ConfigService) DescribeOrganizationConformancePackStatusesRequest(input *DescribeOrganizationConformancePackStatusesInput) (req *request.Request, output *DescribeOrganizationConformancePackStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConformancePackStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConformancePackStatusesInput{}
	}

	output = &DescribeOrganizationConformancePackStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConformancePackStatuses API operation for AWS Config.
//
// Provides organization conformance pack deployment status for an organization.
//
// The status is not considered successful until organization conformance pack
// is successfully deployed in all the member accounts with an exception of
// excluded accounts.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization conformance
// pack names. They are only applicable, when you request all the organization
// conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConformancePackStatuses for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   AWS Config organization conformance pack that you passed in the filter does
//   not exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses
func (c *ConfigService) DescribeOrganizationConformancePackStatuses(input *DescribeOrganizationConformancePackStatusesInput) (*DescribeOrganizationConformancePackStatusesOutput, error) {
	req, out := c.DescribeOrganizationConformancePackStatusesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConformancePackStatusesWithContext is the same as DescribeOrganizationConformancePackStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConformancePackStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePackStatusesWithContext(ctx aws.Context, input *DescribeOrganizationConformancePackStatusesInput, opts ...request.Option) (*DescribeOrganizationConformancePackStatusesOutput, error) {
	req, out := c.DescribeOrganizationConformancePackStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConformancePacks = "DescribeOrganizationConformancePacks"

// DescribeOrganizationConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConformancePacks for more information on using the DescribeOrganizationConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConformancePacksRequest method.
//    req, resp := client.DescribeOrganizationConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks
func (c *ConfigService) DescribeOrganizationConformancePacksRequest(input *DescribeOrganizationConformancePacksInput) (req *request.Request, output *DescribeOrganizationConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationConformancePacksInput{}
	}

	output = &DescribeOrganizationConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConformancePacks API operation for AWS Config.
//
// Returns a list of organization conformance packs.
//
// When you specify the limit and the next token, you receive a paginated response.
//
// Limit and next token are not applicable if you specify organization conformance
// packs names. They are only applicable, when you request all the organization
// conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConformancePacks for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   AWS Config organization conformance pack that you passed in the filter does
//   not exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks
func (c *ConfigService) DescribeOrganizationConformancePacks(input *DescribeOrganizationConformancePacksInput) (*DescribeOrganizationConformancePacksOutput, error) {
	req, out := c.DescribeOrganizationConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConformancePacksWithContext is the same as DescribeOrganizationConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePacksWithContext(ctx aws.Context, input *DescribeOrganizationConformancePacksInput, opts ...request.Option) (*DescribeOrganizationConformancePacksOutput, error) {
	req, out := c.DescribeOrganizationConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePendingAggregationRequests = "DescribePendingAggregationRequests"

// DescribePendingAggregationRequestsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingAggregationRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingAggregationRequests for more information on using the DescribePendingAggregationRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingAggregationRequestsRequest method.
//    req, resp := client.DescribePendingAggregationRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequestsRequest(input *DescribePendingAggregationRequestsInput) (req *request.Request, output *DescribePendingAggregationRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingAggregationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingAggregationRequestsInput{}
	}

	output = &DescribePendingAggregationRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingAggregationRequests API operation for AWS Config.
//
// Returns a list of all pending aggregation requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribePendingAggregationRequests for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequests(input *DescribePendingAggregationRequestsInput) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	return out, req.Send()
}

// DescribePendingAggregationRequestsWithContext is the same as DescribePendingAggregationRequests with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingAggregationRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribePendingAggregationRequestsWithContext(ctx aws.Context, input *DescribePendingAggregationRequestsInput, opts ...request.Option) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRemediationConfigurations = "DescribeRemediationConfigurations"

// DescribeRemediationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationConfigurations for more information on using the DescribeRemediationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationConfigurationsRequest method.
//    req, resp := client.DescribeRemediationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations
func (c *ConfigService) DescribeRemediationConfigurationsRequest(input *DescribeRemediationConfigurationsInput) (req *request.Request, output *DescribeRemediationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRemediationConfigurationsInput{}
	}

	output = &DescribeRemediationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationConfigurations API operation for AWS Config.
//
// Returns the details of one or more remediation configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations
func (c *ConfigService) DescribeRemediationConfigurations(input *DescribeRemediationConfigurationsInput) (*DescribeRemediationConfigurationsOutput, error) {
	req, out := c.DescribeRemediationConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeRemediationConfigurationsWithContext is the same as DescribeRemediationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationConfigurationsWithContext(ctx aws.Context, input *DescribeRemediationConfigurationsInput, opts ...request.Option) (*DescribeRemediationConfigurationsOutput, error) {
	req, out := c.DescribeRemediationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRemediationExceptions = "DescribeRemediationExceptions"

// DescribeRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationExceptions for more information on using the DescribeRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationExceptionsRequest method.
//    req, resp := client.DescribeRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions
func (c *ConfigService) DescribeRemediationExceptionsRequest(input *DescribeRemediationExceptionsInput) (req *request.Request, output *DescribeRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRemediationExceptionsInput{}
	}

	output = &DescribeRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationExceptions API operation for AWS Config.
//
// Returns the details of one or more remediation exceptions. A detailed view
// of a remediation exception for a set of resources that includes an explanation
// of an exception and the time when the exception will be deleted. When you
// specify the limit and the next token, you receive a paginated response.
//
// AWS Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// When you specify the limit and the next token, you receive a paginated response.
//
// Limit and next token are not applicable if you request resources in batch.
// It is only applicable, when you request all resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions
func (c *ConfigService) DescribeRemediationExceptions(input *DescribeRemediationExceptionsInput) (*DescribeRemediationExceptionsOutput, error) {
	req, out := c.DescribeRemediationExceptionsRequest(input)
	return out, req.Send()
}

// DescribeRemediationExceptionsWithContext is the same as DescribeRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExceptionsWithContext(ctx aws.Context, input *DescribeRemediationExceptionsInput, opts ...request.Option) (*DescribeRemediationExceptionsOutput, error) {
	req, out := c.DescribeRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRemediationExceptionsPages iterates over the pages of a DescribeRemediationExceptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRemediationExceptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRemediationExceptions operation.
//    pageNum := 0
//    err := client.DescribeRemediationExceptionsPages(params,
//        func(page *configservice.DescribeRemediationExceptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeRemediationExceptionsPages(input *DescribeRemediationExceptionsInput, fn func(*DescribeRemediationExceptionsOutput, bool) bool) error {
	return c.DescribeRemediationExceptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRemediationExceptionsPagesWithContext same as DescribeRemediationExceptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExceptionsPagesWithContext(ctx aws.Context, input *DescribeRemediationExceptionsInput, fn func(*DescribeRemediationExceptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRemediationExceptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRemediationExceptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRemediationExceptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRemediationExecutionStatus = "DescribeRemediationExecutionStatus"

// DescribeRemediationExecutionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationExecutionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationExecutionStatus for more information on using the DescribeRemediationExecutionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationExecutionStatusRequest method.
//    req, resp := client.DescribeRemediationExecutionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus
func (c *ConfigService) DescribeRemediationExecutionStatusRequest(input *DescribeRemediationExecutionStatusInput) (req *request.Request, output *DescribeRemediationExecutionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationExecutionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRemediationExecutionStatusInput{}
	}

	output = &DescribeRemediationExecutionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationExecutionStatus API operation for AWS Config.
//
// Provides a detailed view of a Remediation Execution for a set of resources
// including state, timestamps for when steps for the remediation execution
// occur, and any error messages for steps that have failed. When you specify
// the limit and the next token, you receive a paginated response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationExecutionStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationConfigurationException
//   You specified an AWS Config rule without a remediation configuration.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus
func (c *ConfigService) DescribeRemediationExecutionStatus(input *DescribeRemediationExecutionStatusInput) (*DescribeRemediationExecutionStatusOutput, error) {
	req, out := c.DescribeRemediationExecutionStatusRequest(input)
	return out, req.Send()
}

// DescribeRemediationExecutionStatusWithContext is the same as DescribeRemediationExecutionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationExecutionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExecutionStatusWithContext(ctx aws.Context, input *DescribeRemediationExecutionStatusInput, opts ...request.Option) (*DescribeRemediationExecutionStatusOutput, error) {
	req, out := c.DescribeRemediationExecutionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRemediationExecutionStatusPages iterates over the pages of a DescribeRemediationExecutionStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRemediationExecutionStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRemediationExecutionStatus operation.
//    pageNum := 0
//    err := client.DescribeRemediationExecutionStatusPages(params,
//        func(page *configservice.DescribeRemediationExecutionStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeRemediationExecutionStatusPages(input *DescribeRemediationExecutionStatusInput, fn func(*DescribeRemediationExecutionStatusOutput, bool) bool) error {
	return c.DescribeRemediationExecutionStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRemediationExecutionStatusPagesWithContext same as DescribeRemediationExecutionStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExecutionStatusPagesWithContext(ctx aws.Context, input *DescribeRemediationExecutionStatusInput, fn func(*DescribeRemediationExecutionStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRemediationExecutionStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRemediationExecutionStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRemediationExecutionStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRetentionConfigurations = "DescribeRetentionConfigurations"

// DescribeRetentionConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRetentionConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRetentionConfigurations for more information on using the DescribeRetentionConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRetentionConfigurationsRequest method.
//    req, resp := client.DescribeRetentionConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurationsRequest(input *DescribeRetentionConfigurationsInput) (req *request.Request, output *DescribeRetentionConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRetentionConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRetentionConfigurationsInput{}
	}

	output = &DescribeRetentionConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRetentionConfigurations API operation for AWS Config.
//
// Returns the details of one or more retention configurations. If the retention
// configuration name is not specified, this action returns the details for
// all the retention configurations for that account.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRetentionConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchRetentionConfigurationException
//   You have specified a retention configuration that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurations(input *DescribeRetentionConfigurationsInput) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeRetentionConfigurationsWithContext is the same as DescribeRetentionConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRetentionConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRetentionConfigurationsWithContext(ctx aws.Context, input *DescribeRetentionConfigurationsInput, opts ...request.Option) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateComplianceDetailsByConfigRule = "GetAggregateComplianceDetailsByConfigRule"

// GetAggregateComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateComplianceDetailsByConfigRule for more information on using the GetAggregateComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetAggregateComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleRequest(input *GetAggregateComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetAggregateComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetAggregateComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateComplianceDetailsByConfigRuleInput{}
	}

	output = &GetAggregateComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS Config rule for a specific
// resource in a rule. The results indicate which AWS resources were evaluated
// by the rule, when each resource was last evaluated, and whether each resource
// complies with the rule.
//
// The results can return an empty result page. But if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRule(input *GetAggregateComplianceDetailsByConfigRuleInput) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetAggregateComplianceDetailsByConfigRuleWithContext is the same as GetAggregateComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetAggregateComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateConfigRuleComplianceSummary = "GetAggregateConfigRuleComplianceSummary"

// GetAggregateConfigRuleComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateConfigRuleComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateConfigRuleComplianceSummary for more information on using the GetAggregateConfigRuleComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateConfigRuleComplianceSummaryRequest method.
//    req, resp := client.GetAggregateConfigRuleComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryRequest(input *GetAggregateConfigRuleComplianceSummaryInput) (req *request.Request, output *GetAggregateConfigRuleComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAggregateConfigRuleComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	output = &GetAggregateConfigRuleComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateConfigRuleComplianceSummary API operation for AWS Config.
//
// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateConfigRuleComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummary(input *GetAggregateConfigRuleComplianceSummaryInput) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetAggregateConfigRuleComplianceSummaryWithContext is the same as GetAggregateConfigRuleComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateConfigRuleComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryWithContext(ctx aws.Context, input *GetAggregateConfigRuleComplianceSummaryInput, opts ...request.Option) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateConformancePackComplianceSummary = "GetAggregateConformancePackComplianceSummary"

// GetAggregateConformancePackComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateConformancePackComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateConformancePackComplianceSummary for more information on using the GetAggregateConformancePackComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateConformancePackComplianceSummaryRequest method.
//    req, resp := client.GetAggregateConformancePackComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryRequest(input *GetAggregateConformancePackComplianceSummaryInput) (req *request.Request, output *GetAggregateConformancePackComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAggregateConformancePackComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateConformancePackComplianceSummaryInput{}
	}

	output = &GetAggregateConformancePackComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateConformancePackComplianceSummary API operation for AWS Config.
//
// Returns the count of compliant and noncompliant conformance packs across
// all AWS Accounts and AWS Regions in an aggregator. You can filter based on
// AWS Account ID or AWS Region.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateConformancePackComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary
func (c *ConfigService) GetAggregateConformancePackComplianceSummary(input *GetAggregateConformancePackComplianceSummaryInput) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConformancePackComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetAggregateConformancePackComplianceSummaryWithContext is the same as GetAggregateConformancePackComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateConformancePackComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryWithContext(ctx aws.Context, input *GetAggregateConformancePackComplianceSummaryInput, opts ...request.Option) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConformancePackComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateDiscoveredResourceCounts = "GetAggregateDiscoveredResourceCounts"

// GetAggregateDiscoveredResourceCountsRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateDiscoveredResourceCounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateDiscoveredResourceCounts for more information on using the GetAggregateDiscoveredResourceCounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateDiscoveredResourceCountsRequest method.
//    req, resp := client.GetAggregateDiscoveredResourceCountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts
func (c *ConfigService) GetAggregateDiscoveredResourceCountsRequest(input *GetAggregateDiscoveredResourceCountsInput) (req *request.Request, output *GetAggregateDiscoveredResourceCountsOutput) {
	op := &request.Operation{
		Name:       opGetAggregateDiscoveredResourceCounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateDiscoveredResourceCountsInput{}
	}

	output = &GetAggregateDiscoveredResourceCountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateDiscoveredResourceCounts API operation for AWS Config.
//
// Returns the resource counts across accounts and regions that are present
// in your AWS Config aggregator. You can request the resource counts by providing
// filters and GroupByKey.
//
// For example, if the input contains accountID 12345678910 and region us-east-1
// in filters, the API returns the count of resources in account ID 12345678910
// and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the
// API returns resource counts for all source accounts that are present in your
// aggregator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateDiscoveredResourceCounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts
func (c *ConfigService) GetAggregateDiscoveredResourceCounts(input *GetAggregateDiscoveredResourceCountsInput) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	req, out := c.GetAggregateDiscoveredResourceCountsRequest(input)
	return out, req.Send()
}

// GetAggregateDiscoveredResourceCountsWithContext is the same as GetAggregateDiscoveredResourceCounts with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateDiscoveredResourceCounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateDiscoveredResourceCountsWithContext(ctx aws.Context, input *GetAggregateDiscoveredResourceCountsInput, opts ...request.Option) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	req, out := c.GetAggregateDiscoveredResourceCountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateResourceConfig = "GetAggregateResourceConfig"

// GetAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateResourceConfig for more information on using the GetAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateResourceConfigRequest method.
//    req, resp := client.GetAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig
func (c *ConfigService) GetAggregateResourceConfigRequest(input *GetAggregateResourceConfigInput) (req *request.Request, output *GetAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opGetAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateResourceConfigInput{}
	}

	output = &GetAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateResourceConfig API operation for AWS Config.
//
// Returns configuration item that is aggregated for your specific resource
// in a specific source account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * OversizedConfigurationItemException
//   The configuration item size is outside the allowable range.
//
//   * ResourceNotDiscoveredException
//   You have specified a resource that is either unknown or has not been discovered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig
func (c *ConfigService) GetAggregateResourceConfig(input *GetAggregateResourceConfigInput) (*GetAggregateResourceConfigOutput, error) {
	req, out := c.GetAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// GetAggregateResourceConfigWithContext is the same as GetAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateResourceConfigWithContext(ctx aws.Context, input *GetAggregateResourceConfigInput, opts ...request.Option) (*GetAggregateResourceConfigOutput, error) {
	req, out := c.GetAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetailsByConfigRule = "GetComplianceDetailsByConfigRule"

// GetComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByConfigRule for more information on using the GetComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRuleRequest(input *GetComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailsByConfigRuleInput{}
	}

	output = &GetComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS Config rule. The results
// indicate which AWS resources were evaluated by the rule, when each resource
// was last evaluated, and whether each resource complies with the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRule(input *GetComplianceDetailsByConfigRuleInput) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByConfigRuleWithContext is the same as GetComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetailsByResource = "GetComplianceDetailsByResource"

// GetComplianceDetailsByResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByResource for more information on using the GetComplianceDetailsByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByResourceRequest method.
//    req, resp := client.GetComplianceDetailsByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResourceRequest(input *GetComplianceDetailsByResourceInput) (req *request.Request, output *GetComplianceDetailsByResourceOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailsByResourceInput{}
	}

	output = &GetComplianceDetailsByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByResource API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS resource. The results
// indicate which AWS Config rules were used to evaluate the resource, when
// each rule was last used, and whether the resource complies with each rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResource(input *GetComplianceDetailsByResourceInput) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByResourceWithContext is the same as GetComplianceDetailsByResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByResourceWithContext(ctx aws.Context, input *GetComplianceDetailsByResourceInput, opts ...request.Option) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummaryByConfigRule = "GetComplianceSummaryByConfigRule"

// GetComplianceSummaryByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByConfigRule for more information on using the GetComplianceSummaryByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByConfigRuleRequest method.
//    req, resp := client.GetComplianceSummaryByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRuleRequest(input *GetComplianceSummaryByConfigRuleInput) (req *request.Request, output *GetComplianceSummaryByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByConfigRuleInput{}
	}

	output = &GetComplianceSummaryByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByConfigRule API operation for AWS Config.
//
// Returns the number of AWS Config rules that are compliant and noncompliant,
// up to a maximum of 25 for each.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByConfigRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRule(input *GetComplianceSummaryByConfigRuleInput) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByConfigRuleWithContext is the same as GetComplianceSummaryByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByConfigRuleWithContext(ctx aws.Context, input *GetComplianceSummaryByConfigRuleInput, opts ...request.Option) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummaryByResourceType = "GetComplianceSummaryByResourceType"

// GetComplianceSummaryByResourceTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByResourceType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByResourceType for more information on using the GetComplianceSummaryByResourceType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByResourceTypeRequest method.
//    req, resp := client.GetComplianceSummaryByResourceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceTypeRequest(input *GetComplianceSummaryByResourceTypeInput) (req *request.Request, output *GetComplianceSummaryByResourceTypeOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByResourceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByResourceTypeInput{}
	}

	output = &GetComplianceSummaryByResourceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByResourceType API operation for AWS Config.
//
// Returns the number of resources that are compliant and the number that are
// noncompliant. You can specify one or more resource types to get these numbers
// for each resource type. The maximum number returned is 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByResourceType for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceType(input *GetComplianceSummaryByResourceTypeInput) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByResourceTypeWithContext is the same as GetComplianceSummaryByResourceType with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByResourceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByResourceTypeWithContext(ctx aws.Context, input *GetComplianceSummaryByResourceTypeInput, opts ...request.Option) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConformancePackComplianceDetails = "GetConformancePackComplianceDetails"

// GetConformancePackComplianceDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetConformancePackComplianceDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConformancePackComplianceDetails for more information on using the GetConformancePackComplianceDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConformancePackComplianceDetailsRequest method.
//    req, resp := client.GetConformancePackComplianceDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails
func (c *ConfigService) GetConformancePackComplianceDetailsRequest(input *GetConformancePackComplianceDetailsInput) (req *request.Request, output *GetConformancePackComplianceDetailsOutput) {
	op := &request.Operation{
		Name:       opGetConformancePackComplianceDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConformancePackComplianceDetailsInput{}
	}

	output = &GetConformancePackComplianceDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConformancePackComplianceDetails API operation for AWS Config.
//
// Returns compliance details of a conformance pack for all AWS resources that
// are monitered by conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetConformancePackComplianceDetails for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * NoSuchConfigRuleInConformancePackException
//   AWS Config rule that you passed in the filter does not exist.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails
func (c *ConfigService) GetConformancePackComplianceDetails(input *GetConformancePackComplianceDetailsInput) (*GetConformancePackComplianceDetailsOutput, error) {
	req, out := c.GetConformancePackComplianceDetailsRequest(input)
	return out, req.Send()
}

// GetConformancePackComplianceDetailsWithContext is the same as GetConformancePackComplianceDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetConformancePackComplianceDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceDetailsWithContext(ctx aws.Context, input *GetConformancePackComplianceDetailsInput, opts ...request.Option) (*GetConformancePackComplianceDetailsOutput, error) {
	req, out := c.GetConformancePackComplianceDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConformancePackComplianceSummary = "GetConformancePackComplianceSummary"

// GetConformancePackComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetConformancePackComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConformancePackComplianceSummary for more information on using the GetConformancePackComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConformancePackComplianceSummaryRequest method.
//    req, resp := client.GetConformancePackComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary
func (c *ConfigService) GetConformancePackComplianceSummaryRequest(input *GetConformancePackComplianceSummaryInput) (req *request.Request, output *GetConformancePackComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetConformancePackComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConformancePackComplianceSummaryInput{}
	}

	output = &GetConformancePackComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConformancePackComplianceSummary API operation for AWS Config.
//
// Returns compliance details for the conformance pack based on the cumulative
// compliance results of all the rules in that conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetConformancePackComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary
func (c *ConfigService) GetConformancePackComplianceSummary(input *GetConformancePackComplianceSummaryInput) (*GetConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetConformancePackComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetConformancePackComplianceSummaryWithContext is the same as GetConformancePackComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetConformancePackComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceSummaryWithContext(ctx aws.Context, input *GetConformancePackComplianceSummaryInput, opts ...request.Option) (*GetConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetConformancePackComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoveredResourceCounts = "GetDiscoveredResourceCounts"

// GetDiscoveredResourceCountsRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoveredResourceCounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoveredResourceCounts for more information on using the GetDiscoveredResourceCounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoveredResourceCountsRequest method.
//    req, resp := client.GetDiscoveredResourceCountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCountsRequest(input *GetDiscoveredResourceCountsInput) (req *request.Request, output *GetDiscoveredResourceCountsOutput) {
	op := &request.Operation{
		Name:       opGetDiscoveredResourceCounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiscoveredResourceCountsInput{}
	}

	output = &GetDiscoveredResourceCountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoveredResourceCounts API operation for AWS Config.
//
// Returns the resource types, the number of each resource type, and the total
// number of resources that AWS Config is recording in this region for your
// AWS account.
//
// Example
//
// AWS Config is recording three resource types in the US East (Ohio) Region
// for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.
//
// You make a call to the GetDiscoveredResourceCounts action and specify that
// you want all resource types.
//
// AWS Config returns the following:
//
//    * The resource types (EC2 instances, IAM users, and S3 buckets).
//
//    * The number of each resource type (25, 20, and 15).
//
//    * The total number of all resources (60).
//
// The response is paginated. By default, AWS Config lists 100 ResourceCount
// objects on each page. You can customize this number with the limit parameter.
// The response includes a nextToken string. To get the next page of results,
// run the request again and specify the string for the nextToken parameter.
//
// If you make a call to the GetDiscoveredResourceCounts action, you might not
// immediately receive resource counts in the following situations:
//
//    * You are a new AWS Config customer.
//
//    * You just enabled resource recording.
//
// It might take a few minutes for AWS Config to record and count your resources.
// Wait a few minutes and then retry the GetDiscoveredResourceCounts action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetDiscoveredResourceCounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCounts(input *GetDiscoveredResourceCountsInput) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	return out, req.Send()
}

// GetDiscoveredResourceCountsWithContext is the same as GetDiscoveredResourceCounts with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoveredResourceCounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetDiscoveredResourceCountsWithContext(ctx aws.Context, input *GetDiscoveredResourceCountsInput, opts ...request.Option) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOrganizationConfigRuleDetailedStatus = "GetOrganizationConfigRuleDetailedStatus"

// GetOrganizationConfigRuleDetailedStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationConfigRuleDetailedStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationConfigRuleDetailedStatus for more information on using the GetOrganizationConfigRuleDetailedStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationConfigRuleDetailedStatusRequest method.
//    req, resp := client.GetOrganizationConfigRuleDetailedStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusRequest(input *GetOrganizationConfigRuleDetailedStatusInput) (req *request.Request, output *GetOrganizationConfigRuleDetailedStatusOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationConfigRuleDetailedStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOrganizationConfigRuleDetailedStatusInput{}
	}

	output = &GetOrganizationConfigRuleDetailedStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationConfigRuleDetailedStatus API operation for AWS Config.
//
// Returns detailed status for each member account within an organization for
// a given organization config rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetOrganizationConfigRuleDetailedStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   You specified one or more organization config rules that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatus(input *GetOrganizationConfigRuleDetailedStatusInput) (*GetOrganizationConfigRuleDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConfigRuleDetailedStatusRequest(input)
	return out, req.Send()
}

// GetOrganizationConfigRuleDetailedStatusWithContext is the same as GetOrganizationConfigRuleDetailedStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationConfigRuleDetailedStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusWithContext(ctx aws.Context, input *GetOrganizationConfigRuleDetailedStatusInput, opts ...request.Option) (*GetOrganizationConfigRuleDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConfigRuleDetailedStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOrganizationConformancePackDetailedStatus = "GetOrganizationConformancePackDetailedStatus"

// GetOrganizationConformancePackDetailedStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationConformancePackDetailedStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationConformancePackDetailedStatus for more information on using the GetOrganizationConformancePackDetailedStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationConformancePackDetailedStatusRequest method.
//    req, resp := client.GetOrganizationConformancePackDetailedStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusRequest(input *GetOrganizationConformancePackDetailedStatusInput) (req *request.Request, output *GetOrganizationConformancePackDetailedStatusOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationConformancePackDetailedStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOrganizationConformancePackDetailedStatusInput{}
	}

	output = &GetOrganizationConformancePackDetailedStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationConformancePackDetailedStatus API operation for AWS Config.
//
// Returns detailed status for each member account within an organization for
// a given organization conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetOrganizationConformancePackDetailedStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   AWS Config organization conformance pack that you passed in the filter does
//   not exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus
func (c *ConfigService) GetOrganizationConformancePackDetailedStatus(input *GetOrganizationConformancePackDetailedStatusInput) (*GetOrganizationConformancePackDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConformancePackDetailedStatusRequest(input)
	return out, req.Send()
}

// GetOrganizationConformancePackDetailedStatusWithContext is the same as GetOrganizationConformancePackDetailedStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationConformancePackDetailedStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusWithContext(ctx aws.Context, input *GetOrganizationConformancePackDetailedStatusInput, opts ...request.Option) (*GetOrganizationConformancePackDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConformancePackDetailedStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceConfigHistory = "GetResourceConfigHistory"

// GetResourceConfigHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceConfigHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceConfigHistory for more information on using the GetResourceConfigHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceConfigHistoryRequest method.
//    req, resp := client.GetResourceConfigHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistoryRequest(input *GetResourceConfigHistoryInput) (req *request.Request, output *GetResourceConfigHistoryOutput) {
	op := &request.Operation{
		Name:       opGetResourceConfigHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceConfigHistoryInput{}
	}

	output = &GetResourceConfigHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceConfigHistory API operation for AWS Config.
//
// Returns a list of configuration items for the specified resource. The list
// contains details about each state of the resource during the specified time
// interval. If you specified a retention period to retain your ConfigurationItems
// between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
// returns the ConfigurationItems for the specified retention period.
//
// The response is paginated. By default, AWS Config returns a limit of 10 configuration
// items per page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Each call to the API is limited to span a duration of seven days. It is likely
// that the number of records returned is smaller than the specified limit.
// In such cases, you can make another call, using the nextToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetResourceConfigHistory for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidTimeRangeException
//   The specified time range is not valid. The earlier time is not chronologically
//   before the later time.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * ResourceNotDiscoveredException
//   You have specified a resource that is either unknown or has not been discovered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistory(input *GetResourceConfigHistoryInput) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	return out, req.Send()
}

// GetResourceConfigHistoryWithContext is the same as GetResourceConfigHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceConfigHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, opts ...request.Option) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceConfigHistoryPages iterates over the pages of a GetResourceConfigHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceConfigHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceConfigHistory operation.
//    pageNum := 0
//    err := client.GetResourceConfigHistoryPages(params,
//        func(page *configservice.GetResourceConfigHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetResourceConfigHistoryPages(input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool) error {
	return c.GetResourceConfigHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceConfigHistoryPagesWithContext same as GetResourceConfigHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryPagesWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceConfigHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceConfigHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceConfigHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetStoredQuery = "GetStoredQuery"

// GetStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStoredQuery for more information on using the GetStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStoredQueryRequest method.
//    req, resp := client.GetStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery
func (c *ConfigService) GetStoredQueryRequest(input *GetStoredQueryInput) (req *request.Request, output *GetStoredQueryOutput) {
	op := &request.Operation{
		Name:       opGetStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStoredQueryInput{}
	}

	output = &GetStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStoredQuery API operation for AWS Config.
//
// Returns the details of a specific stored query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery
func (c *ConfigService) GetStoredQuery(input *GetStoredQueryInput) (*GetStoredQueryOutput, error) {
	req, out := c.GetStoredQueryRequest(input)
	return out, req.Send()
}

// GetStoredQueryWithContext is the same as GetStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetStoredQueryWithContext(ctx aws.Context, input *GetStoredQueryInput, opts ...request.Option) (*GetStoredQueryOutput, error) {
	req, out := c.GetStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAggregateDiscoveredResources = "ListAggregateDiscoveredResources"

// ListAggregateDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAggregateDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAggregateDiscoveredResources for more information on using the ListAggregateDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAggregateDiscoveredResourcesRequest method.
//    req, resp := client.ListAggregateDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources
func (c *ConfigService) ListAggregateDiscoveredResourcesRequest(input *ListAggregateDiscoveredResourcesInput) (req *request.Request, output *ListAggregateDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListAggregateDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAggregateDiscoveredResourcesInput{}
	}

	output = &ListAggregateDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAggregateDiscoveredResources API operation for AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers that are
// aggregated for a specific resource type across accounts and regions. A resource
// identifier includes the resource type, ID, (if available) the custom resource
// name, source account, and source region. You can narrow the results to include
// only resources that have specific resource IDs, or a resource name, or source
// account ID, or source region.
//
// For example, if the input consists of accountID 12345678910 and the region
// is us-east-1 for resource type AWS::EC2::Instance then the API returns all
// the EC2 instance identifiers of accountID 12345678910 and region us-east-1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListAggregateDiscoveredResources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources
func (c *ConfigService) ListAggregateDiscoveredResources(input *ListAggregateDiscoveredResourcesInput) (*ListAggregateDiscoveredResourcesOutput, error) {
	req, out := c.ListAggregateDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListAggregateDiscoveredResourcesWithContext is the same as ListAggregateDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAggregateDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListAggregateDiscoveredResourcesWithContext(ctx aws.Context, input *ListAggregateDiscoveredResourcesInput, opts ...request.Option) (*ListAggregateDiscoveredResourcesOutput, error) {
	req, out := c.ListAggregateDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDiscoveredResources = "ListDiscoveredResources"

// ListDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveredResources for more information on using the ListDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDiscoveredResourcesRequest method.
//    req, resp := client.ListDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResourcesRequest(input *ListDiscoveredResourcesInput) (req *request.Request, output *ListDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDiscoveredResourcesInput{}
	}

	output = &ListDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoveredResources API operation for AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers for the
// resources of that type. A resource identifier includes the resource type,
// ID, and (if available) the custom resource name. The results consist of resources
// that AWS Config has discovered, including those that AWS Config is not currently
// recording. You can narrow the results to include only resources that have
// specific resource IDs or a resource name.
//
// You can specify either resource IDs or a resource name, but not both, in
// the same request.
//
// The response is paginated. By default, AWS Config lists 100 resource identifiers
// on each page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListDiscoveredResources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResources(input *ListDiscoveredResourcesInput) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListDiscoveredResourcesWithContext is the same as ListDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListDiscoveredResourcesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, opts ...request.Option) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStoredQueries = "ListStoredQueries"

// ListStoredQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListStoredQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStoredQueries for more information on using the ListStoredQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStoredQueriesRequest method.
//    req, resp := client.ListStoredQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries
func (c *ConfigService) ListStoredQueriesRequest(input *ListStoredQueriesInput) (req *request.Request, output *ListStoredQueriesOutput) {
	op := &request.Operation{
		Name:       opListStoredQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStoredQueriesInput{}
	}

	output = &ListStoredQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStoredQueries API operation for AWS Config.
//
// Lists the stored queries for a single AWS account and a single AWS Region.
// The default is 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListStoredQueries for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries
func (c *ConfigService) ListStoredQueries(input *ListStoredQueriesInput) (*ListStoredQueriesOutput, error) {
	req, out := c.ListStoredQueriesRequest(input)
	return out, req.Send()
}

// ListStoredQueriesWithContext is the same as ListStoredQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListStoredQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListStoredQueriesWithContext(ctx aws.Context, input *ListStoredQueriesInput, opts ...request.Option) (*ListStoredQueriesOutput, error) {
	req, out := c.ListStoredQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStoredQueriesPages iterates over the pages of a ListStoredQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStoredQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStoredQueries operation.
//    pageNum := 0
//    err := client.ListStoredQueriesPages(params,
//        func(page *configservice.ListStoredQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) ListStoredQueriesPages(input *ListStoredQueriesInput, fn func(*ListStoredQueriesOutput, bool) bool) error {
	return c.ListStoredQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStoredQueriesPagesWithContext same as ListStoredQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListStoredQueriesPagesWithContext(ctx aws.Context, input *ListStoredQueriesInput, fn func(*ListStoredQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStoredQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStoredQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStoredQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource
func (c *ConfigService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Config.
//
// List the tags for AWS Config resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource
func (c *ConfigService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAggregationAuthorization = "PutAggregationAuthorization"

// PutAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the PutAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAggregationAuthorization for more information on using the PutAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAggregationAuthorizationRequest method.
//    req, resp := client.PutAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorizationRequest(input *PutAggregationAuthorizationInput) (req *request.Request, output *PutAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opPutAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAggregationAuthorizationInput{}
	}

	output = &PutAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAggregationAuthorization API operation for AWS Config.
//
// Authorizes the aggregator account and region to collect data from the source
// account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutAggregationAuthorization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorization(input *PutAggregationAuthorizationInput) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// PutAggregationAuthorizationWithContext is the same as PutAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See PutAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutAggregationAuthorizationWithContext(ctx aws.Context, input *PutAggregationAuthorizationInput, opts ...request.Option) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigRule = "PutConfigRule"

// PutConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigRule for more information on using the PutConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigRuleRequest method.
//    req, resp := client.PutConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRuleRequest(input *PutConfigRuleInput) (req *request.Request, output *PutConfigRuleOutput) {
	op := &request.Operation{
		Name:       opPutConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigRuleInput{}
	}

	output = &PutConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigRule API operation for AWS Config.
//
// Adds or updates an AWS Config rule for evaluating whether your AWS resources
// comply with your desired configurations.
//
// You can use this action for custom AWS Config rules and AWS managed Config
// rules. A custom AWS Config rule is a rule that you develop and maintain.
// An AWS managed Config rule is a customizable, predefined rule that AWS Config
// provides.
//
// If you are adding a new custom AWS Config rule, you must first create the
// AWS Lambda function that the rule invokes to evaluate your resources. When
// you use the PutConfigRule action to add the rule to AWS Config, you must
// specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function.
// Specify the ARN for the SourceIdentifier key. This key is part of the Source
// object, which is part of the ConfigRule object.
//
// If you are adding an AWS managed Config rule, specify the rule's identifier
// for the SourceIdentifier key. To reference AWS managed Config rule identifiers,
// see About AWS Managed Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
//
// For any new rule that you add, specify the ConfigRuleName in the ConfigRule
// object. Do not specify the ConfigRuleArn or the ConfigRuleId. These values
// are generated by AWS Config for new rules.
//
// If you are updating a rule that you added previously, you can specify the
// rule by ConfigRuleName, ConfigRuleId, or ConfigRuleArn in the ConfigRule
// data type that you use in this request.
//
// The maximum number of rules that AWS Config supports is 150.
//
// For information about requesting a rule limit increase, see AWS Config Limits
// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
// in the AWS General Reference Guide.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfConfigRulesExceededException
//   Failed to add the AWS Config rule because the account already contains the
//   maximum number of 150 rules. Consider deleting any deactivated rules before
//   you add new rules.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRule(input *PutConfigRuleInput) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	return out, req.Send()
}

// PutConfigRuleWithContext is the same as PutConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigRuleWithContext(ctx aws.Context, input *PutConfigRuleInput, opts ...request.Option) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationAggregator = "PutConfigurationAggregator"

// PutConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationAggregator for more information on using the PutConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationAggregatorRequest method.
//    req, resp := client.PutConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregatorRequest(input *PutConfigurationAggregatorInput) (req *request.Request, output *PutConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationAggregatorInput{}
	}

	output = &PutConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConfigurationAggregator API operation for AWS Config.
//
// Creates and updates the configuration aggregator with the selected source
// accounts and regions. The source account can be individual account(s) or
// an organization.
//
// accountIds that are passed will be replaced with existing accounts. If you
// want to add additional accounts into the aggregator, call DescribeAggregator
// to get the previous accounts and then append new ones.
//
// AWS Config should be enabled in source accounts and regions you want to aggregate.
//
// If your source type is an organization, you must be signed in to the management
// account or a registered delegated administrator and all the features must
// be enabled in your organization. If the caller is a management account, AWS
// Config calls EnableAwsServiceAccess API to enable integration between AWS
// Config and AWS Organizations. If the caller is a registered delegated administrator,
// AWS Config calls ListDelegatedAdministrators API to verify whether the caller
// is a valid delegated administrator.
//
// To register a delegated administrator, see Register a Delegated Administrator
// (https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli)
// in the AWS Config developer guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationAggregator for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * LimitExceededException
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * InvalidRoleException
//   You have provided a null or empty role ARN.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
//   * OrganizationAllFeaturesNotEnabledException
//   AWS Config resource cannot be created because your organization does not
//   have all features enabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregator(input *PutConfigurationAggregatorInput) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// PutConfigurationAggregatorWithContext is the same as PutConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationAggregatorWithContext(ctx aws.Context, input *PutConfigurationAggregatorInput, opts ...request.Option) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationRecorder = "PutConfigurationRecorder"

// PutConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationRecorder for more information on using the PutConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationRecorderRequest method.
//    req, resp := client.PutConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorderRequest(input *PutConfigurationRecorderInput) (req *request.Request, output *PutConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationRecorderInput{}
	}

	output = &PutConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationRecorder API operation for AWS Config.
//
// Creates a new configuration recorder to record the selected resource configurations.
//
// You can use this action to change the role roleARN or the recordingGroup
// of an existing recorder. To change the role, call the action on the existing
// configuration recorder and specify a role.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// If ConfigurationRecorder does not have the recordingGroup parameter specified,
// the default is to record all supported resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfConfigurationRecordersExceededException
//   You have reached the limit of the number of recorders you can create.
//
//   * InvalidConfigurationRecorderNameException
//   You have provided a configuration recorder name that is not valid.
//
//   * InvalidRoleException
//   You have provided a null or empty role ARN.
//
//   * InvalidRecordingGroupException
//   AWS Config throws an exception if the recording group does not contain a
//   valid list of resource types. Invalid values might also be incorrectly formatted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorder(input *PutConfigurationRecorderInput) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	return out, req.Send()
}

// PutConfigurationRecorderWithContext is the same as PutConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationRecorderWithContext(ctx aws.Context, input *PutConfigurationRecorderInput, opts ...request.Option) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConformancePack = "PutConformancePack"

// PutConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the PutConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConformancePack for more information on using the PutConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConformancePackRequest method.
//    req, resp := client.PutConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack
func (c *ConfigService) PutConformancePackRequest(input *PutConformancePackInput) (req *request.Request, output *PutConformancePackOutput) {
	op := &request.Operation{
		Name:       opPutConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConformancePackInput{}
	}

	output = &PutConformancePackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConformancePack API operation for AWS Config.
//
// Creates or updates a conformance pack. A conformance pack is a collection
// of AWS Config rules that can be easily deployed in an account and a region
// and across AWS Organization.
//
// This API creates a service linked role AWSServiceRoleForConfigConforms in
// your account. The service linked role is created only when the role does
// not exist in your account.
//
// You must specify either the TemplateS3Uri or the TemplateBody parameter,
// but not both. If you provide both AWS Config uses the TemplateS3Uri parameter
// and ignores the TemplateBody parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConformancePack for usage and error information.
//
// Returned Error Types:
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * ConformancePackTemplateValidationException
//   You have specified a template that is not valid or supported.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfConformancePacksExceededException
//   You have reached the limit (6) of the number of conformance packs in an account
//   (6 conformance pack with 25 AWS Config rules per pack).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack
func (c *ConfigService) PutConformancePack(input *PutConformancePackInput) (*PutConformancePackOutput, error) {
	req, out := c.PutConformancePackRequest(input)
	return out, req.Send()
}

// PutConformancePackWithContext is the same as PutConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See PutConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConformancePackWithContext(ctx aws.Context, input *PutConformancePackInput, opts ...request.Option) (*PutConformancePackOutput, error) {
	req, out := c.PutConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDeliveryChannel = "PutDeliveryChannel"

// PutDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the PutDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDeliveryChannel for more information on using the PutDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDeliveryChannelRequest method.
//    req, resp := client.PutDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannelRequest(input *PutDeliveryChannelInput) (req *request.Request, output *PutDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opPutDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDeliveryChannelInput{}
	}

	output = &PutDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDeliveryChannel API operation for AWS Config.
//
// Creates a delivery channel object to deliver configuration information to
// an Amazon S3 bucket and Amazon SNS topic.
//
// Before you can create a delivery channel, you must create a configuration
// recorder.
//
// You can use this action to change the Amazon S3 bucket or an Amazon SNS topic
// of the existing delivery channel. To change the Amazon S3 bucket or an Amazon
// SNS topic, call this action and specify the changed values for the S3 bucket
// and the SNS topic. If you specify a different value for either the S3 bucket
// or the SNS topic, this action will keep the existing value for the parameter
// that is not changed.
//
// You can have only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutDeliveryChannel for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfDeliveryChannelsExceededException
//   You have reached the limit of the number of delivery channels you can create.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * InvalidDeliveryChannelNameException
//   The specified delivery channel name is not valid.
//
//   * NoSuchBucketException
//   The specified Amazon S3 bucket does not exist.
//
//   * InvalidS3KeyPrefixException
//   The specified Amazon S3 key prefix is not valid.
//
//   * InvalidS3KmsKeyArnException
//   The specified Amazon KMS Key ARN is not valid.
//
//   * InvalidSNSTopicARNException
//   The specified Amazon SNS topic does not exist.
//
//   * InsufficientDeliveryPolicyException
//   Your Amazon S3 bucket policy does not permit AWS Config to write to it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannel(input *PutDeliveryChannelInput) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	return out, req.Send()
}

// PutDeliveryChannelWithContext is the same as PutDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See PutDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutDeliveryChannelWithContext(ctx aws.Context, input *PutDeliveryChannelInput, opts ...request.Option) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvaluations = "PutEvaluations"

// PutEvaluationsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvaluations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvaluations for more information on using the PutEvaluations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEvaluationsRequest method.
//    req, resp := client.PutEvaluationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluationsRequest(input *PutEvaluationsInput) (req *request.Request, output *PutEvaluationsOutput) {
	op := &request.Operation{
		Name:       opPutEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEvaluationsInput{}
	}

	output = &PutEvaluationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvaluations API operation for AWS Config.
//
// Used by an AWS Lambda function to deliver evaluation results to AWS Config.
// This action is required in every AWS Lambda function that is invoked by an
// AWS Config rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutEvaluations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidResultTokenException
//   The specified ResultToken is invalid.
//
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluations(input *PutEvaluationsInput) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	return out, req.Send()
}

// PutEvaluationsWithContext is the same as PutEvaluations with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvaluations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutEvaluationsWithContext(ctx aws.Context, input *PutEvaluationsInput, opts ...request.Option) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutExternalEvaluation = "PutExternalEvaluation"

// PutExternalEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the PutExternalEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutExternalEvaluation for more information on using the PutExternalEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutExternalEvaluationRequest method.
//    req, resp := client.PutExternalEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation
func (c *ConfigService) PutExternalEvaluationRequest(input *PutExternalEvaluationInput) (req *request.Request, output *PutExternalEvaluationOutput) {
	op := &request.Operation{
		Name:       opPutExternalEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutExternalEvaluationInput{}
	}

	output = &PutExternalEvaluationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutExternalEvaluation API operation for AWS Config.
//
// Add or updates the evaluations for process checks. This API checks if the
// rule is a process check when the name of the AWS Config rule is provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutExternalEvaluation for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation
func (c *ConfigService) PutExternalEvaluation(input *PutExternalEvaluationInput) (*PutExternalEvaluationOutput, error) {
	req, out := c.PutExternalEvaluationRequest(input)
	return out, req.Send()
}

// PutExternalEvaluationWithContext is the same as PutExternalEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See PutExternalEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutExternalEvaluationWithContext(ctx aws.Context, input *PutExternalEvaluationInput, opts ...request.Option) (*PutExternalEvaluationOutput, error) {
	req, out := c.PutExternalEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOrganizationConfigRule = "PutOrganizationConfigRule"

// PutOrganizationConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutOrganizationConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOrganizationConfigRule for more information on using the PutOrganizationConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOrganizationConfigRuleRequest method.
//    req, resp := client.PutOrganizationConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule
func (c *ConfigService) PutOrganizationConfigRuleRequest(input *PutOrganizationConfigRuleInput) (req *request.Request, output *PutOrganizationConfigRuleOutput) {
	op := &request.Operation{
		Name:       opPutOrganizationConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOrganizationConfigRuleInput{}
	}

	output = &PutOrganizationConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutOrganizationConfigRule API operation for AWS Config.
//
// Adds or updates organization config rule for your entire organization evaluating
// whether your AWS resources comply with your desired configurations.
//
// Only a master account and a delegated administrator can create or update
// an organization config rule. When calling this API with a delegated administrator,
// you must ensure AWS Organizations ListDelegatedAdministrator permissions
// are added.
//
// This API enables organization service access through the EnableAWSServiceAccess
// action and creates a service linked role AWSServiceRoleForConfigMultiAccountSetup
// in the master or delegated administrator account of your organization. The
// service linked role is created only when the role does not exist in the caller
// account. AWS Config verifies the existence of role with GetRole action.
//
// To use this API with delegated administrator, register a delegated administrator
// by calling AWS Organization register-delegated-administrator for config-multiaccountsetup.amazonaws.com.
//
// You can use this action to create both custom AWS Config rules and AWS managed
// Config rules. If you are adding a new custom AWS Config rule, you must first
// create AWS Lambda function in the master account or a delegated administrator
// that the rule invokes to evaluate your resources. When you use the PutOrganizationConfigRule
// action to add the rule to AWS Config, you must specify the Amazon Resource
// Name (ARN) that AWS Lambda assigns to the function. If you are adding an
// AWS managed Config rule, specify the rule's identifier for the RuleIdentifier
// key.
//
// The maximum number of organization config rules that AWS Config supports
// is 150 and 3 delegated administrator per organization.
//
// Prerequisite: Ensure you call EnableAllFeatures API to enable all features
// in an organization.
//
// Specify either OrganizationCustomRuleMetadata or OrganizationManagedRuleMetadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutOrganizationConfigRule for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfOrganizationConfigRulesExceededException
//   You have reached the limit of the number of organization config rules you
//   can create.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
//   * OrganizationAllFeaturesNotEnabledException
//   AWS Config resource cannot be created because your organization does not
//   have all features enabled.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule
func (c *ConfigService) PutOrganizationConfigRule(input *PutOrganizationConfigRuleInput) (*PutOrganizationConfigRuleOutput, error) {
	req, out := c.PutOrganizationConfigRuleRequest(input)
	return out, req.Send()
}

// PutOrganizationConfigRuleWithContext is the same as PutOrganizationConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutOrganizationConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutOrganizationConfigRuleWithContext(ctx aws.Context, input *PutOrganizationConfigRuleInput, opts ...request.Option) (*PutOrganizationConfigRuleOutput, error) {
	req, out := c.PutOrganizationConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOrganizationConformancePack = "PutOrganizationConformancePack"

// PutOrganizationConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the PutOrganizationConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOrganizationConformancePack for more information on using the PutOrganizationConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOrganizationConformancePackRequest method.
//    req, resp := client.PutOrganizationConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack
func (c *ConfigService) PutOrganizationConformancePackRequest(input *PutOrganizationConformancePackInput) (req *request.Request, output *PutOrganizationConformancePackOutput) {
	op := &request.Operation{
		Name:       opPutOrganizationConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOrganizationConformancePackInput{}
	}

	output = &PutOrganizationConformancePackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutOrganizationConformancePack API operation for AWS Config.
//
// Deploys conformance packs across member accounts in an AWS Organization.
//
// Only a master account and a delegated administrator can call this API. When
// calling this API with a delegated administrator, you must ensure AWS Organizations
// ListDelegatedAdministrator permissions are added.
//
// This API enables organization service access for config-multiaccountsetup.amazonaws.com
// through the EnableAWSServiceAccess action and creates a service linked role
// AWSServiceRoleForConfigMultiAccountSetup in the master or delegated administrator
// account of your organization. The service linked role is created only when
// the role does not exist in the caller account. To use this API with delegated
// administrator, register a delegated administrator by calling AWS Organization
// register-delegate-admin for config-multiaccountsetup.amazonaws.com.
//
// Prerequisite: Ensure you call EnableAllFeatures API to enable all features
// in an organization.
//
// You must specify either the TemplateS3Uri or the TemplateBody parameter,
// but not both. If you provide both AWS Config uses the TemplateS3Uri parameter
// and ignores the TemplateBody parameter.
//
// AWS Config sets the state of a conformance pack to CREATE_IN_PROGRESS and
// UPDATE_IN_PROGRESS until the conformance pack is created or updated. You
// cannot update a conformance pack while it is in this state.
//
// You can create 50 conformance packs with 25 AWS Config rules in each pack
// and 3 delegated administrator per organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutOrganizationConformancePack for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfOrganizationConformancePacksExceededException
//   You have reached the limit (6) of the number of organization conformance
//   packs in an account (6 conformance pack with 25 AWS Config rules per pack
//   per account).
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your AWS Organization
//      management account or the delegated administrator role changed. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * The configuration aggregator is associated with a previous AWS Organization
//      and AWS Config cannot aggregate data with current AWS Organization. Delete
//      this aggregator and create a new one with the current AWS Organization.
//
//      * You are not a registered delegated administrator for AWS Config with
//      permissions to call ListDelegatedAdministrators API. Ensure that the management
//      account registers delagated administrator for AWS Config service principle
//      name before the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
//   Config throws an exception if APIs are called from member accounts. All APIs
//   must be called from organization master account.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * OrganizationConformancePackTemplateValidationException
//   You have specified a template that is not valid or supported.
//
//   * OrganizationAllFeaturesNotEnabledException
//   AWS Config resource cannot be created because your organization does not
//   have all features enabled.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack
func (c *ConfigService) PutOrganizationConformancePack(input *PutOrganizationConformancePackInput) (*PutOrganizationConformancePackOutput, error) {
	req, out := c.PutOrganizationConformancePackRequest(input)
	return out, req.Send()
}

// PutOrganizationConformancePackWithContext is the same as PutOrganizationConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See PutOrganizationConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutOrganizationConformancePackWithContext(ctx aws.Context, input *PutOrganizationConformancePackInput, opts ...request.Option) (*PutOrganizationConformancePackOutput, error) {
	req, out := c.PutOrganizationConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRemediationConfigurations = "PutRemediationConfigurations"

// PutRemediationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the PutRemediationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRemediationConfigurations for more information on using the PutRemediationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRemediationConfigurationsRequest method.
//    req, resp := client.PutRemediationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations
func (c *ConfigService) PutRemediationConfigurationsRequest(input *PutRemediationConfigurationsInput) (req *request.Request, output *PutRemediationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opPutRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRemediationConfigurationsInput{}
	}

	output = &PutRemediationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRemediationConfigurations API operation for AWS Config.
//
// Adds or updates the remediation configuration with a specific AWS Config
// rule with the selected target or action. The API creates the RemediationConfiguration
// object for the AWS Config rule. The AWS Config rule must already exist for
// you to add a remediation configuration. The target (SSM document) must exist
// and have permissions to use the target.
//
// If you make backward incompatible changes to the SSM document, you must call
// this again to ensure the remediations can run.
//
// This API does not support adding remediation configurations for service-linked
// AWS Config Rules such as Organization Config rules, the rules deployed by
// conformance packs, and rules deployed by AWS Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRemediationConfigurations for usage and error information.
//
// Returned Error Types:
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations
func (c *ConfigService) PutRemediationConfigurations(input *PutRemediationConfigurationsInput) (*PutRemediationConfigurationsOutput, error) {
	req, out := c.PutRemediationConfigurationsRequest(input)
	return out, req.Send()
}

// PutRemediationConfigurationsWithContext is the same as PutRemediationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See PutRemediationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRemediationConfigurationsWithContext(ctx aws.Context, input *PutRemediationConfigurationsInput, opts ...request.Option) (*PutRemediationConfigurationsOutput, error) {
	req, out := c.PutRemediationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRemediationExceptions = "PutRemediationExceptions"

// PutRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRemediationExceptions for more information on using the PutRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRemediationExceptionsRequest method.
//    req, resp := client.PutRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions
func (c *ConfigService) PutRemediationExceptionsRequest(input *PutRemediationExceptionsInput) (req *request.Request, output *PutRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opPutRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRemediationExceptionsInput{}
	}

	output = &PutRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRemediationExceptions API operation for AWS Config.
//
// A remediation exception is when a specific resource is no longer considered
// for auto-remediation. This API adds a new exception or updates an existing
// exception for a specific resource with a specific AWS Config rule.
//
// AWS Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions
func (c *ConfigService) PutRemediationExceptions(input *PutRemediationExceptionsInput) (*PutRemediationExceptionsOutput, error) {
	req, out := c.PutRemediationExceptionsRequest(input)
	return out, req.Send()
}

// PutRemediationExceptionsWithContext is the same as PutRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRemediationExceptionsWithContext(ctx aws.Context, input *PutRemediationExceptionsInput, opts ...request.Option) (*PutRemediationExceptionsOutput, error) {
	req, out := c.PutRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourceConfig = "PutResourceConfig"

// PutResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourceConfig for more information on using the PutResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourceConfigRequest method.
//    req, resp := client.PutResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig
func (c *ConfigService) PutResourceConfigRequest(input *PutResourceConfigInput) (req *request.Request, output *PutResourceConfigOutput) {
	op := &request.Operation{
		Name:       opPutResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourceConfigInput{}
	}

	output = &PutResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourceConfig API operation for AWS Config.
//
// Records the configuration state for the resource provided in the request.
// The configuration state of a resource is represented in AWS Config as Configuration
// Items. Once this API records the configuration item, you can retrieve the
// list of configuration items for the custom resource type using existing AWS
// Config APIs.
//
// The custom resource type must be registered with AWS CloudFormation. This
// API accepts the configuration item registered with AWS CloudFormation.
//
// When you call this API, AWS Config only stores configuration state of the
// resource provided in the request. This API does not change or remediate the
// configuration of the resource.
//
// Write-only schema properites are not recorded as part of the published configuration
// item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
//   * MaxActiveResourcesExceededException
//   You have reached the limit (100,000) of active custom resource types in your
//   account. Delete unused resources using DeleteResourceConfig.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig
func (c *ConfigService) PutResourceConfig(input *PutResourceConfigInput) (*PutResourceConfigOutput, error) {
	req, out := c.PutResourceConfigRequest(input)
	return out, req.Send()
}

// PutResourceConfigWithContext is the same as PutResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutResourceConfigWithContext(ctx aws.Context, input *PutResourceConfigInput, opts ...request.Option) (*PutResourceConfigOutput, error) {
	req, out := c.PutResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRetentionConfiguration = "PutRetentionConfiguration"

// PutRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRetentionConfiguration for more information on using the PutRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRetentionConfigurationRequest method.
//    req, resp := client.PutRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfigurationRequest(input *PutRetentionConfigurationInput) (req *request.Request, output *PutRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionConfigurationInput{}
	}

	output = &PutRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRetentionConfiguration API operation for AWS Config.
//
// Creates and updates the retention configuration with details about retention
// period (number of days) that AWS Config stores your historical information.
// The API creates the RetentionConfiguration object and names the object as
// default. When you have a RetentionConfiguration object named default, calling
// the API modifies the default object.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRetentionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfRetentionConfigurationsExceededException
//   Failed to add the retention configuration because a retention configuration
//   with that name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfiguration(input *PutRetentionConfigurationInput) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	return out, req.Send()
}

// PutRetentionConfigurationWithContext is the same as PutRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRetentionConfigurationWithContext(ctx aws.Context, input *PutRetentionConfigurationInput, opts ...request.Option) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStoredQuery = "PutStoredQuery"

// PutStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the PutStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStoredQuery for more information on using the PutStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutStoredQueryRequest method.
//    req, resp := client.PutStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery
func (c *ConfigService) PutStoredQueryRequest(input *PutStoredQueryInput) (req *request.Request, output *PutStoredQueryOutput) {
	op := &request.Operation{
		Name:       opPutStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutStoredQueryInput{}
	}

	output = &PutStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutStoredQuery API operation for AWS Config.
//
// Saves a new query or updates an existing saved query. The QueryName must
// be unique for a single AWS account and a single AWS Region. You can create
// upto 300 queries in a single AWS account and a single AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * TooManyTagsException
//   You have reached the limit of the number of tags you can use. You have more
//   than 50 tags.
//
//   * ResourceConcurrentModificationException
//   Two users are trying to modify the same query at the same time. Wait for
//   a moment and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery
func (c *ConfigService) PutStoredQuery(input *PutStoredQueryInput) (*PutStoredQueryOutput, error) {
	req, out := c.PutStoredQueryRequest(input)
	return out, req.Send()
}

// PutStoredQueryWithContext is the same as PutStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See PutStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutStoredQueryWithContext(ctx aws.Context, input *PutStoredQueryInput, opts ...request.Option) (*PutStoredQueryOutput, error) {
	req, out := c.PutStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSelectAggregateResourceConfig = "SelectAggregateResourceConfig"

// SelectAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the SelectAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SelectAggregateResourceConfig for more information on using the SelectAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SelectAggregateResourceConfigRequest method.
//    req, resp := client.SelectAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig
func (c *ConfigService) SelectAggregateResourceConfigRequest(input *SelectAggregateResourceConfigInput) (req *request.Request, output *SelectAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opSelectAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SelectAggregateResourceConfigInput{}
	}

	output = &SelectAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SelectAggregateResourceConfig API operation for AWS Config.
//
// Accepts a structured query language (SQL) SELECT command and an aggregator
// to query configuration state of AWS resources across multiple accounts and
// regions, performs the corresponding search, and returns resource configurations
// matching the properties.
//
// For more information about query components, see the Query Components (https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
// section in the AWS Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation SelectAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidExpressionException
//   The syntax of the query is incorrect.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig
func (c *ConfigService) SelectAggregateResourceConfig(input *SelectAggregateResourceConfigInput) (*SelectAggregateResourceConfigOutput, error) {
	req, out := c.SelectAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// SelectAggregateResourceConfigWithContext is the same as SelectAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SelectAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectAggregateResourceConfigWithContext(ctx aws.Context, input *SelectAggregateResourceConfigInput, opts ...request.Option) (*SelectAggregateResourceConfigOutput, error) {
	req, out := c.SelectAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SelectAggregateResourceConfigPages iterates over the pages of a SelectAggregateResourceConfig operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SelectAggregateResourceConfig method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SelectAggregateResourceConfig operation.
//    pageNum := 0
//    err := client.SelectAggregateResourceConfigPages(params,
//        func(page *configservice.SelectAggregateResourceConfigOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) SelectAggregateResourceConfigPages(input *SelectAggregateResourceConfigInput, fn func(*SelectAggregateResourceConfigOutput, bool) bool) error {
	return c.SelectAggregateResourceConfigPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SelectAggregateResourceConfigPagesWithContext same as SelectAggregateResourceConfigPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectAggregateResourceConfigPagesWithContext(ctx aws.Context, input *SelectAggregateResourceConfigInput, fn func(*SelectAggregateResourceConfigOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SelectAggregateResourceConfigInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SelectAggregateResourceConfigRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SelectAggregateResourceConfigOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSelectResourceConfig = "SelectResourceConfig"

// SelectResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the SelectResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SelectResourceConfig for more information on using the SelectResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SelectResourceConfigRequest method.
//    req, resp := client.SelectResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig
func (c *ConfigService) SelectResourceConfigRequest(input *SelectResourceConfigInput) (req *request.Request, output *SelectResourceConfigOutput) {
	op := &request.Operation{
		Name:       opSelectResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SelectResourceConfigInput{}
	}

	output = &SelectResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SelectResourceConfig API operation for AWS Config.
//
// Accepts a structured query language (SQL) SELECT command, performs the corresponding
// search, and returns resource configurations matching the properties.
//
// For more information about query components, see the Query Components (https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
// section in the AWS Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation SelectResourceConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidExpressionException
//   The syntax of the query is incorrect.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig
func (c *ConfigService) SelectResourceConfig(input *SelectResourceConfigInput) (*SelectResourceConfigOutput, error) {
	req, out := c.SelectResourceConfigRequest(input)
	return out, req.Send()
}

// SelectResourceConfigWithContext is the same as SelectResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SelectResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectResourceConfigWithContext(ctx aws.Context, input *SelectResourceConfigInput, opts ...request.Option) (*SelectResourceConfigOutput, error) {
	req, out := c.SelectResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConfigRulesEvaluation = "StartConfigRulesEvaluation"

// StartConfigRulesEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigRulesEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigRulesEvaluation for more information on using the StartConfigRulesEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigRulesEvaluationRequest method.
//    req, resp := client.StartConfigRulesEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluationRequest(input *StartConfigRulesEvaluationInput) (req *request.Request, output *StartConfigRulesEvaluationOutput) {
	op := &request.Operation{
		Name:       opStartConfigRulesEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigRulesEvaluationInput{}
	}

	output = &StartConfigRulesEvaluationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartConfigRulesEvaluation API operation for AWS Config.
//
// Runs an on-demand evaluation for the specified AWS Config rules against the
// last known configuration state of the resources. Use StartConfigRulesEvaluation
// when you want to test that a rule you updated is working as expected. StartConfigRulesEvaluation
// does not re-record the latest configuration state for your resources. It
// re-runs an evaluation against the last known state of your resources.
//
// You can specify up to 25 AWS Config rules per request.
//
// An existing StartConfigRulesEvaluation call for the specified rules must
// complete before you can call the API again. If you chose to have AWS Config
// stream to an Amazon SNS topic, you will receive a ConfigRuleEvaluationStarted
// notification when the evaluation starts.
//
// You don't need to call the StartConfigRulesEvaluation API to run an evaluation
// for a new rule. When you create a rule, AWS Config evaluates your resources
// against the rule automatically.
//
// The StartConfigRulesEvaluation API is useful if you want to run on-demand
// evaluations, such as the following example:
//
// You have a custom rule that evaluates your IAM resources every 24 hours.
//
// You update your Lambda function to add additional conditions to your rule.
//
// Instead of waiting for the next periodic evaluation, you call the StartConfigRulesEvaluation
// API.
//
// AWS Config invokes your Lambda function and evaluates your IAM resources.
//
// Your custom rule will still run periodic evaluations every 24 hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigRulesEvaluation for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * LimitExceededException
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and AWS Config cannot delete this rule. Delete the remediation action
//      associated with the rule before deleting the rule and try your request
//      again later.
//
//      * For PutConfigOrganizationRule, organization config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluation(input *StartConfigRulesEvaluationInput) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	return out, req.Send()
}

// StartConfigRulesEvaluationWithContext is the same as StartConfigRulesEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigRulesEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigRulesEvaluationWithContext(ctx aws.Context, input *StartConfigRulesEvaluationInput, opts ...request.Option) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConfigurationRecorder = "StartConfigurationRecorder"

// StartConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigurationRecorder for more information on using the StartConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigurationRecorderRequest method.
//    req, resp := client.StartConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorderRequest(input *StartConfigurationRecorderInput) (req *request.Request, output *StartConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStartConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigurationRecorderInput{}
	}

	output = &StartConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartConfigurationRecorder API operation for AWS Config.
//
// Starts recording configurations of the AWS resources you have selected to
// record in your AWS account.
//
// You must have created at least one delivery channel to successfully start
// the configuration recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
//   * NoAvailableDeliveryChannelException
//   There is no delivery channel available to record configurations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorder(input *StartConfigurationRecorderInput) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StartConfigurationRecorderWithContext is the same as StartConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigurationRecorderWithContext(ctx aws.Context, input *StartConfigurationRecorderInput, opts ...request.Option) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRemediationExecution = "StartRemediationExecution"

// StartRemediationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartRemediationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRemediationExecution for more information on using the StartRemediationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartRemediationExecutionRequest method.
//    req, resp := client.StartRemediationExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution
func (c *ConfigService) StartRemediationExecutionRequest(input *StartRemediationExecutionInput) (req *request.Request, output *StartRemediationExecutionOutput) {
	op := &request.Operation{
		Name:       opStartRemediationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRemediationExecutionInput{}
	}

	output = &StartRemediationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRemediationExecution API operation for AWS Config.
//
// Runs an on-demand remediation for the specified AWS Config rules against
// the last known remediation configuration. It runs an execution against the
// current state of your resources. Remediation execution is asynchronous.
//
// You can specify up to 100 resource keys per request. An existing StartRemediationExecution
// call for the specified resource keys must complete before you can call the
// API again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartRemediationExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to AWS Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//      the function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoSuchRemediationConfigurationException
//   You specified an AWS Config rule without a remediation configuration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution
func (c *ConfigService) StartRemediationExecution(input *StartRemediationExecutionInput) (*StartRemediationExecutionOutput, error) {
	req, out := c.StartRemediationExecutionRequest(input)
	return out, req.Send()
}

// StartRemediationExecutionWithContext is the same as StartRemediationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartRemediationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartRemediationExecutionWithContext(ctx aws.Context, input *StartRemediationExecutionInput, opts ...request.Option) (*StartRemediationExecutionOutput, error) {
	req, out := c.StartRemediationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopConfigurationRecorder = "StopConfigurationRecorder"

// StopConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StopConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopConfigurationRecorder for more information on using the StopConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopConfigurationRecorderRequest method.
//    req, resp := client.StopConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorderRequest(input *StopConfigurationRecorderInput) (req *request.Request, output *StopConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStopConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopConfigurationRecorderInput{}
	}

	output = &StopConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopConfigurationRecorder API operation for AWS Config.
//
// Stops recording configurations of the AWS resources you have selected to
// record in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StopConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorder(input *StopConfigurationRecorderInput) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StopConfigurationRecorderWithContext is the same as StopConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StopConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StopConfigurationRecorderWithContext(ctx aws.Context, input *StopConfigurationRecorderInput, opts ...request.Option) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource
func (c *ConfigService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Config.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
//   * TooManyTagsException
//   You have reached the limit of the number of tags you can use. You have more
//   than 50 tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource
func (c *ConfigService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource
func (c *ConfigService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Config.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource
func (c *ConfigService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A collection of accounts and regions.
type AccountAggregationSource struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account being aggregated.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s AccountAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountAggregationSource"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *AccountAggregationSource) SetAccountIds(v []*string) *AccountAggregationSource {
	s.AccountIds = v
	return s
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *AccountAggregationSource) SetAllAwsRegions(v bool) *AccountAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *AccountAggregationSource) SetAwsRegions(v []*string) *AccountAggregationSource {
	s.AwsRegions = v
	return s
}

// Indicates whether an AWS Config rule is compliant based on account ID, region,
// compliance, and rule name.
//
// A rule is compliant if all of the resources that the rule evaluated comply
// with it. It is noncompliant if any of these resources do not comply.
type AggregateComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// Indicates whether an AWS resource or AWS Config rule is compliant and provides
	// the number of contributors that affect the compliance.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateComplianceByConfigRule) SetAccountId(v string) *AggregateComplianceByConfigRule {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateComplianceByConfigRule) SetAwsRegion(v string) *AggregateComplianceByConfigRule {
	s.AwsRegion = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AggregateComplianceByConfigRule) SetCompliance(v *Compliance) *AggregateComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *AggregateComplianceByConfigRule) SetConfigRuleName(v string) *AggregateComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Provides aggregate compliance of the conformance pack. Indicates whether
// a conformance pack is compliant based on the name of the conformance pack,
// account ID, and region.
//
// A conformance pack is compliant if all of the rules in a conformance packs
// are compliant. It is noncompliant if any of the rules are not compliant.
// The compliance status of a conformance pack is INSUFFICIENT_DATA only if
// all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the compliance
// status of other rules in that same conformance pack is INSUFFICIENT_DATA,
// the conformance pack shows compliant.
type AggregateComplianceByConformancePack struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID of the source account.
	AccountId *string `type:"string"`

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The compliance status of the conformance pack.
	Compliance *AggregateConformancePackCompliance `type:"structure"`

	// The name of the conformance pack.
	ConformancePackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceByConformancePack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateComplianceByConformancePack) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateComplianceByConformancePack) SetAccountId(v string) *AggregateComplianceByConformancePack {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateComplianceByConformancePack) SetAwsRegion(v string) *AggregateComplianceByConformancePack {
	s.AwsRegion = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AggregateComplianceByConformancePack) SetCompliance(v *AggregateConformancePackCompliance) *AggregateComplianceByConformancePack {
	s.Compliance = v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *AggregateComplianceByConformancePack) SetConformancePackName(v string) *AggregateComplianceByConformancePack {
	s.ConformancePackName = &v
	return s
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
type AggregateComplianceCount struct {
	_ struct{} `type:"structure"`

	// The number of compliant and noncompliant AWS Config rules.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateComplianceCount) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *AggregateComplianceCount) SetComplianceSummary(v *ComplianceSummary) *AggregateComplianceCount {
	s.ComplianceSummary = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AggregateComplianceCount) SetGroupName(v string) *AggregateComplianceCount {
	s.GroupName = &v
	return s
}

// Provides the number of compliant and noncompliant rules within a conformance
// pack. Also provides the compliance status of the conformance pack and the
// total rule count which includes compliant rules, noncompliant rules, and
// rules that cannot be evaluated due to insufficient data.
//
// A conformance pack is compliant if all of the rules in a conformance packs
// are compliant. It is noncompliant if any of the rules are not compliant.
// The compliance status of a conformance pack is INSUFFICIENT_DATA only if
// all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the compliance
// status of other rules in that same conformance pack is INSUFFICIENT_DATA,
// the conformance pack shows compliant.
type AggregateConformancePackCompliance struct {
	_ struct{} `type:"structure"`

	// The compliance status of the conformance pack.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// The number of compliant AWS Config Rules.
	CompliantRuleCount *int64 `type:"integer"`

	// The number of noncompliant AWS Config Rules.
	NonCompliantRuleCount *int64 `type:"integer"`

	// Total number of compliant rules, noncompliant rules, and the rules that do
	// not have any applicable resources to evaluate upon resulting in insufficient
	// data.
	TotalRuleCount *int64 `type:"integer"`
}

// String returns the string representation
func (s AggregateConformancePackCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateConformancePackCompliance) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateConformancePackCompliance) SetComplianceType(v string) *AggregateConformancePackCompliance {
	s.ComplianceType = &v
	return s
}

// SetCompliantRuleCount sets the CompliantRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetCompliantRuleCount(v int64) *AggregateConformancePackCompliance {
	s.CompliantRuleCount = &v
	return s
}

// SetNonCompliantRuleCount sets the NonCompliantRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetNonCompliantRuleCount(v int64) *AggregateConformancePackCompliance {
	s.NonCompliantRuleCount = &v
	return s
}

// SetTotalRuleCount sets the TotalRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetTotalRuleCount(v int64) *AggregateConformancePackCompliance {
	s.TotalRuleCount = &v
	return s
}

// The number of conformance packs that are compliant and noncompliant.
type AggregateConformancePackComplianceCount struct {
	_ struct{} `type:"structure"`

	// Number of compliant conformance packs.
	CompliantConformancePackCount *int64 `type:"integer"`

	// Number of noncompliant conformance packs.
	NonCompliantConformancePackCount *int64 `type:"integer"`
}

// String returns the string representation
func (s AggregateConformancePackComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateConformancePackComplianceCount) GoString() string {
	return s.String()
}

// SetCompliantConformancePackCount sets the CompliantConformancePackCount field's value.
func (s *AggregateConformancePackComplianceCount) SetCompliantConformancePackCount(v int64) *AggregateConformancePackComplianceCount {
	s.CompliantConformancePackCount = &v
	return s
}

// SetNonCompliantConformancePackCount sets the NonCompliantConformancePackCount field's value.
func (s *AggregateConformancePackComplianceCount) SetNonCompliantConformancePackCount(v int64) *AggregateConformancePackComplianceCount {
	s.NonCompliantConformancePackCount = &v
	return s
}

// Filters the conformance packs based on an account ID, region, compliance
// type, and the name of the conformance pack.
type AggregateConformancePackComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID of the source account.
	AccountId *string `type:"string"`

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The compliance status of the conformance pack.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// The name of the conformance pack.
	ConformancePackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateConformancePackComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateConformancePackComplianceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateConformancePackComplianceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateConformancePackComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateConformancePackComplianceFilters) SetAccountId(v string) *AggregateConformancePackComplianceFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateConformancePackComplianceFilters) SetAwsRegion(v string) *AggregateConformancePackComplianceFilters {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateConformancePackComplianceFilters) SetComplianceType(v string) *AggregateConformancePackComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *AggregateConformancePackComplianceFilters) SetConformancePackName(v string) *AggregateConformancePackComplianceFilters {
	s.ConformancePackName = &v
	return s
}

// Provides a summary of compliance based on either account ID or region.
type AggregateConformancePackComplianceSummary struct {
	_ struct{} `type:"structure"`

	// Returns an AggregateConformancePackComplianceCount object.
	ComplianceSummary *AggregateConformancePackComplianceCount `type:"structure"`

	// Groups the result based on AWS Account ID or AWS Region.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateConformancePackComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateConformancePackComplianceSummary) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *AggregateConformancePackComplianceSummary) SetComplianceSummary(v *AggregateConformancePackComplianceCount) *AggregateConformancePackComplianceSummary {
	s.ComplianceSummary = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AggregateConformancePackComplianceSummary) SetGroupName(v string) *AggregateConformancePackComplianceSummary {
	s.GroupName = &v
	return s
}

// Filters the results based on account ID and region.
type AggregateConformancePackComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID of the source account.
	AccountId *string `type:"string"`

	// The source AWS Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateConformancePackComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateConformancePackComplianceSummaryFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateConformancePackComplianceSummaryFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateConformancePackComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateConformancePackComplianceSummaryFilters) SetAccountId(v string) *AggregateConformancePackComplianceSummaryFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateConformancePackComplianceSummaryFilters) SetAwsRegion(v string) *AggregateConformancePackComplianceSummaryFilters {
	s.AwsRegion = &v
	return s
}

// The details of an AWS Config evaluation for an account ID and region in an
// aggregator. Provides the AWS resource that was evaluated, the compliance
// of the resource, related time stamps, and supplementary information.
type AggregateEvaluationResult struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string `min:"1" type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The resource compliance status.
	//
	// For the AggregationEvaluationResult data type, AWS Config supports only the
	// COMPLIANT and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE
	// and INSUFFICIENT_DATA value.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AggregateEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateEvaluationResult) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateEvaluationResult) SetAccountId(v string) *AggregateEvaluationResult {
	s.AccountId = &v
	return s
}

// SetAnnotation sets the Annotation field's value.
func (s *AggregateEvaluationResult) SetAnnotation(v string) *AggregateEvaluationResult {
	s.Annotation = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateEvaluationResult) SetAwsRegion(v string) *AggregateEvaluationResult {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateEvaluationResult) SetComplianceType(v string) *AggregateEvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *AggregateEvaluationResult) SetConfigRuleInvokedTime(v time.Time) *AggregateEvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *AggregateEvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *AggregateEvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *AggregateEvaluationResult) SetResultRecordedTime(v time.Time) *AggregateEvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// The details that identify a resource that is collected by AWS Config aggregator,
// including the resource type, ID, (if available) the custom resource name,
// the source account, and source region.
type AggregateResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The name of the AWS resource.
	ResourceName *string `type:"string"`

	// The type of the AWS resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`

	// The 12-digit account ID of the source account.
	//
	// SourceAccountId is a required field
	SourceAccountId *string `type:"string" required:"true"`

	// The source region where data is aggregated.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AggregateResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateResourceIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateResourceIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateResourceIdentifier"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SourceAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceAccountId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AggregateResourceIdentifier) SetResourceId(v string) *AggregateResourceIdentifier {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *AggregateResourceIdentifier) SetResourceName(v string) *AggregateResourceIdentifier {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AggregateResourceIdentifier) SetResourceType(v string) *AggregateResourceIdentifier {
	s.ResourceType = &v
	return s
}

// SetSourceAccountId sets the SourceAccountId field's value.
func (s *AggregateResourceIdentifier) SetSourceAccountId(v string) *AggregateResourceIdentifier {
	s.SourceAccountId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *AggregateResourceIdentifier) SetSourceRegion(v string) *AggregateResourceIdentifier {
	s.SourceRegion = &v
	return s
}

// The current sync status between the source and the aggregator account.
type AggregatedSourceStatus struct {
	_ struct{} `type:"structure"`

	// The region authorized to collect aggregated data.
	AwsRegion *string `min:"1" type:"string"`

	// The error code that AWS Config returned when the source account aggregation
	// last failed.
	LastErrorCode *string `type:"string"`

	// The message indicating that the source account aggregation failed due to
	// an error.
	LastErrorMessage *string `type:"string"`

	// Filters the last updated status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus *string `type:"string" enum:"AggregatedSourceStatusType"`

	// The time of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The source account ID or an organization.
	SourceId *string `type:"string"`

	// The source account or an organization.
	SourceType *string `type:"string" enum:"AggregatedSourceType"`
}

// String returns the string representation
func (s AggregatedSourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregatedSourceStatus) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregatedSourceStatus) SetAwsRegion(v string) *AggregatedSourceStatus {
	s.AwsRegion = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *AggregatedSourceStatus) SetLastErrorCode(v string) *AggregatedSourceStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *AggregatedSourceStatus) SetLastErrorMessage(v string) *AggregatedSourceStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastUpdateStatus sets the LastUpdateStatus field's value.
func (s *AggregatedSourceStatus) SetLastUpdateStatus(v string) *AggregatedSourceStatus {
	s.LastUpdateStatus = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AggregatedSourceStatus) SetLastUpdateTime(v time.Time) *AggregatedSourceStatus {
	s.LastUpdateTime = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *AggregatedSourceStatus) SetSourceId(v string) *AggregatedSourceStatus {
	s.SourceId = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AggregatedSourceStatus) SetSourceType(v string) *AggregatedSourceStatus {
	s.SourceType = &v
	return s
}

// An object that represents the authorizations granted to aggregator accounts
// and regions.
type AggregationAuthorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string `type:"string"`

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string `type:"string"`

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string `min:"1" type:"string"`

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AggregationAuthorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregationAuthorization) GoString() string {
	return s.String()
}

// SetAggregationAuthorizationArn sets the AggregationAuthorizationArn field's value.
func (s *AggregationAuthorization) SetAggregationAuthorizationArn(v string) *AggregationAuthorization {
	s.AggregationAuthorizationArn = &v
	return s
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *AggregationAuthorization) SetAuthorizedAccountId(v string) *AggregationAuthorization {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *AggregationAuthorization) SetAuthorizedAwsRegion(v string) *AggregationAuthorization {
	s.AuthorizedAwsRegion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AggregationAuthorization) SetCreationTime(v time.Time) *AggregationAuthorization {
	s.CreationTime = &v
	return s
}

// The detailed configuration of a specified resource.
type BaseConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// The configuration item status. The valid values are:
	//
	//    * OK – The resource configuration has been updated
	//
	//    * ResourceDiscovered – The resource was newly discovered
	//
	//    * ResourceNotRecorded – The resource was discovered but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	//    * ResourceDeleted – The resource was deleted
	//
	//    * ResourceDeletedNotRecorded – The resource was deleted but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s BaseConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaseConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BaseConfigurationItem) SetAccountId(v string) *BaseConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *BaseConfigurationItem) SetArn(v string) *BaseConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *BaseConfigurationItem) SetAvailabilityZone(v string) *BaseConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *BaseConfigurationItem) SetAwsRegion(v string) *BaseConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *BaseConfigurationItem) SetConfiguration(v string) *BaseConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *BaseConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *BaseConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *BaseConfigurationItem) SetConfigurationItemStatus(v string) *BaseConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *BaseConfigurationItem) SetConfigurationStateId(v string) *BaseConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *BaseConfigurationItem) SetResourceCreationTime(v time.Time) *BaseConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *BaseConfigurationItem) SetResourceId(v string) *BaseConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *BaseConfigurationItem) SetResourceName(v string) *BaseConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *BaseConfigurationItem) SetResourceType(v string) *BaseConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *BaseConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *BaseConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaseConfigurationItem) SetVersion(v string) *BaseConfigurationItem {
	s.Version = &v
	return s
}

type BatchGetAggregateResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// A list of aggregate ResourceIdentifiers objects.
	//
	// ResourceIdentifiers is a required field
	ResourceIdentifiers []*AggregateResourceIdentifier `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetAggregateResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetAggregateResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAggregateResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAggregateResourceConfigInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifiers"))
	}
	if s.ResourceIdentifiers != nil && len(s.ResourceIdentifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifiers", 1))
	}
	if s.ResourceIdentifiers != nil {
		for i, v := range s.ResourceIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *BatchGetAggregateResourceConfigInput) SetConfigurationAggregatorName(v string) *BatchGetAggregateResourceConfigInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *BatchGetAggregateResourceConfigInput) SetResourceIdentifiers(v []*AggregateResourceIdentifier) *BatchGetAggregateResourceConfigInput {
	s.ResourceIdentifiers = v
	return s
}

type BatchGetAggregateResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the current configuration of one or more resources.
	BaseConfigurationItems []*BaseConfigurationItem `type:"list"`

	// A list of resource identifiers that were not processed with current scope.
	// The list is empty if all the resources are processed.
	UnprocessedResourceIdentifiers []*AggregateResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s BatchGetAggregateResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetAggregateResourceConfigOutput) GoString() string {
	return s.String()
}

// SetBaseConfigurationItems sets the BaseConfigurationItems field's value.
func (s *BatchGetAggregateResourceConfigOutput) SetBaseConfigurationItems(v []*BaseConfigurationItem) *BatchGetAggregateResourceConfigOutput {
	s.BaseConfigurationItems = v
	return s
}

// SetUnprocessedResourceIdentifiers sets the UnprocessedResourceIdentifiers field's value.
func (s *BatchGetAggregateResourceConfigOutput) SetUnprocessedResourceIdentifiers(v []*AggregateResourceIdentifier) *BatchGetAggregateResourceConfigOutput {
	s.UnprocessedResourceIdentifiers = v
	return s
}

type BatchGetResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	//
	// ResourceKeys is a required field
	ResourceKeys []*ResourceKey `locationName:"resourceKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetResourceConfigInput"}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *BatchGetResourceConfigInput) SetResourceKeys(v []*ResourceKey) *BatchGetResourceConfigInput {
	s.ResourceKeys = v
	return s
}

type BatchGetResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the current configuration of one or more resources.
	BaseConfigurationItems []*BaseConfigurationItem `locationName:"baseConfigurationItems" type:"list"`

	// A list of resource keys that were not processed with the current response.
	// The unprocessesResourceKeys value is in the same form as ResourceKeys, so
	// the value can be directly provided to a subsequent BatchGetResourceConfig
	// operation. If there are no unprocessed resource keys, the response contains
	// an empty unprocessedResourceKeys list.
	UnprocessedResourceKeys []*ResourceKey `locationName:"unprocessedResourceKeys" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetResourceConfigOutput) GoString() string {
	return s.String()
}

// SetBaseConfigurationItems sets the BaseConfigurationItems field's value.
func (s *BatchGetResourceConfigOutput) SetBaseConfigurationItems(v []*BaseConfigurationItem) *BatchGetResourceConfigOutput {
	s.BaseConfigurationItems = v
	return s
}

// SetUnprocessedResourceKeys sets the UnprocessedResourceKeys field's value.
func (s *BatchGetResourceConfigOutput) SetUnprocessedResourceKeys(v []*ResourceKey) *BatchGetResourceConfigOutput {
	s.UnprocessedResourceKeys = v
	return s
}

// Indicates whether an AWS resource or AWS Config rule is compliant and provides
// the number of contributors that affect the compliance.
type Compliance struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources or AWS Config rules that cause a result of NON_COMPLIANT,
	// up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount `type:"structure"`

	// Indicates whether an AWS resource or AWS Config rule is compliant.
	//
	// A resource is compliant if it complies with all of the AWS Config rules that
	// evaluate it. A resource is noncompliant if it does not comply with one or
	// more of these rules.
	//
	// A rule is compliant if all of the resources that the rule evaluates comply
	// with it. A rule is noncompliant if any of these resources do not comply.
	//
	// AWS Config returns the INSUFFICIENT_DATA value when no evaluation results
	// are available for the AWS resource or AWS Config rule.
	//
	// For the Compliance data type, AWS Config supports only COMPLIANT, NON_COMPLIANT,
	// and INSUFFICIENT_DATA values. AWS Config does not support the NOT_APPLICABLE
	// value for the Compliance data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compliance) GoString() string {
	return s.String()
}

// SetComplianceContributorCount sets the ComplianceContributorCount field's value.
func (s *Compliance) SetComplianceContributorCount(v *ComplianceContributorCount) *Compliance {
	s.ComplianceContributorCount = v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Compliance) SetComplianceType(v string) *Compliance {
	s.ComplianceType = &v
	return s
}

// Indicates whether an AWS Config rule is compliant. A rule is compliant if
// all of the resources that the rule evaluated comply with it. A rule is noncompliant
// if any of these resources do not comply.
type ComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS Config rule is compliant.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByConfigRule) SetCompliance(v *Compliance) *ComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ComplianceByConfigRule) SetConfigRuleName(v string) *ComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Indicates whether an AWS resource that is evaluated according to one or more
// AWS Config rules is compliant. A resource is compliant if it complies with
// all of the rules that evaluate it. A resource is noncompliant if it does
// not comply with one or more of these rules.
type ComplianceByResource struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS resource complies with all of the AWS Config rules
	// that evaluated it.
	Compliance *Compliance `type:"structure"`

	// The ID of the AWS resource that was evaluated.
	ResourceId *string `min:"1" type:"string"`

	// The type of the AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceByResource) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByResource) SetCompliance(v *Compliance) *ComplianceByResource {
	s.Compliance = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceByResource) SetResourceId(v string) *ComplianceByResource {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceByResource) SetResourceType(v string) *ComplianceByResource {
	s.ResourceType = &v
	return s
}

// The number of AWS resources or AWS Config rules responsible for the current
// compliance of the item, up to a maximum number.
type ComplianceContributorCount struct {
	_ struct{} `type:"structure"`

	// Indicates whether the maximum count is reached.
	CapExceeded *bool `type:"boolean"`

	// The number of AWS resources or AWS Config rules responsible for the current
	// compliance of the item.
	CappedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ComplianceContributorCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceContributorCount) GoString() string {
	return s.String()
}

// SetCapExceeded sets the CapExceeded field's value.
func (s *ComplianceContributorCount) SetCapExceeded(v bool) *ComplianceContributorCount {
	s.CapExceeded = &v
	return s
}

// SetCappedCount sets the CappedCount field's value.
func (s *ComplianceContributorCount) SetCappedCount(v int64) *ComplianceContributorCount {
	s.CappedCount = &v
	return s
}

// The number of AWS Config rules or AWS resources that are compliant and noncompliant.
type ComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The time that AWS Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time `type:"timestamp"`

	// The number of AWS Config rules or AWS resources that are compliant, up to
	// a maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount `type:"structure"`

	// The number of AWS Config rules or AWS resources that are noncompliant, up
	// to a maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount `type:"structure"`
}

// String returns the string representation
func (s ComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceSummary) GoString() string {
	return s.String()
}

// SetComplianceSummaryTimestamp sets the ComplianceSummaryTimestamp field's value.
func (s *ComplianceSummary) SetComplianceSummaryTimestamp(v time.Time) *ComplianceSummary {
	s.ComplianceSummaryTimestamp = &v
	return s
}

// SetCompliantResourceCount sets the CompliantResourceCount field's value.
func (s *ComplianceSummary) SetCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.CompliantResourceCount = v
	return s
}

// SetNonCompliantResourceCount sets the NonCompliantResourceCount field's value.
func (s *ComplianceSummary) SetNonCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.NonCompliantResourceCount = v
	return s
}

// The number of AWS resources of a specific type that are compliant or noncompliant,
// up to a maximum of 100 for each.
type ComplianceSummaryByResourceType struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that are compliant or noncompliant, up to a maximum
	// of 100 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The type of AWS resource.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceSummaryByResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceSummaryByResourceType) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *ComplianceSummaryByResourceType) SetComplianceSummary(v *ComplianceSummary) *ComplianceSummaryByResourceType {
	s.ComplianceSummary = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceSummaryByResourceType) SetResourceType(v string) *ComplianceSummaryByResourceType {
	s.ResourceType = &v
	return s
}

// Provides status of the delivery of the snapshot or the configuration history
// to the specified Amazon S3 bucket. Also provides the status of notifications
// about the Amazon S3 delivery to the specified Amazon SNS topic.
type ConfigExportDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time `locationName:"lastAttemptTime" type:"timestamp"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time `locationName:"lastSuccessfulTime" type:"timestamp"`

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time `locationName:"nextDeliveryTime" type:"timestamp"`
}

// String returns the string representation
func (s ConfigExportDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigExportDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastAttemptTime sets the LastAttemptTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastAttemptTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastAttemptTime = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorCode(v string) *ConfigExportDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorMessage(v string) *ConfigExportDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigExportDeliveryInfo) SetLastStatus(v string) *ConfigExportDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastSuccessfulTime sets the LastSuccessfulTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastSuccessfulTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastSuccessfulTime = &v
	return s
}

// SetNextDeliveryTime sets the NextDeliveryTime field's value.
func (s *ConfigExportDeliveryInfo) SetNextDeliveryTime(v time.Time) *ConfigExportDeliveryInfo {
	s.NextDeliveryTime = &v
	return s
}

// An AWS Config rule represents an AWS Lambda function that you create for
// a custom rule or a predefined function for an AWS managed rule. The function
// evaluates configuration items to assess whether your AWS resources comply
// with your desired configurations. This function can run when AWS Config detects
// a configuration change to an AWS resource and at a periodic frequency that
// you choose (for example, every 24 hours).
//
// You can use the AWS CLI and AWS SDKs if you want to create a rule that triggers
// evaluations for your resources when AWS Config delivers the configuration
// snapshot. For more information, see ConfigSnapshotDeliveryProperties.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
type ConfigRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `min:"1" type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `min:"1" type:"string"`

	// The name that you assign to the AWS Config rule. The name is required if
	// you are adding a new rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Indicates whether the AWS Config rule is active or is currently being deleted
	// by AWS Config. It can also indicate the evaluation status for the AWS Config
	// rule.
	//
	// AWS Config sets the state of the rule to EVALUATING temporarily after you
	// use the StartConfigRulesEvaluation request to evaluate your resources against
	// the AWS Config rule.
	//
	// AWS Config sets the state of the rule to DELETING_RESULTS temporarily after
	// you use the DeleteEvaluationResults request to delete the current evaluation
	// results for the AWS Config rule.
	//
	// AWS Config temporarily sets the state of a rule to DELETING after you use
	// the DeleteConfigRule request to delete the rule. After AWS Config deletes
	// the rule, the rule and all of its evaluations are erased and are no longer
	// available.
	ConfigRuleState *string `type:"string" enum:"ConfigRuleState"`

	// Service principal name of the service that created the rule.
	//
	// The field is populated only if the service linked rule is created by a service.
	// The field is empty if you create your own rule.
	CreatedBy *string `min:"1" type:"string"`

	// The description that you provide for the AWS Config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to the AWS Config rule Lambda function.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which AWS Config runs evaluations for a rule.
	// You can specify a value for MaximumExecutionFrequency when:
	//
	//    * You are using an AWS managed rule that is triggered at a periodic frequency.
	//
	//    * Your custom rule is triggered when AWS Config delivers the configuration
	//    snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// Defines which resources can trigger an evaluation for the rule. The scope
	// can include one or more resource types, a combination of one resource type
	// and one resource ID, or a combination of a tag key and value. Specify a scope
	// to constrain the resources that can trigger an evaluation for the rule. If
	// you do not specify a scope, evaluations are triggered when any resource in
	// the recording group changes.
	//
	// The scope can be empty.
	Scope *Scope `type:"structure"`

	// Provides the rule owner (AWS or customer), the rule identifier, and the notifications
	// that cause the function to evaluate your AWS resources.
	//
	// Source is a required field
	Source *Source `type:"structure" required:"true"`
}

// String returns the string representation
func (s ConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRule"}
	if s.ConfigRuleArn != nil && len(*s.ConfigRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleArn", 1))
	}
	if s.ConfigRuleId != nil && len(*s.ConfigRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleId", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.CreatedBy != nil && len(*s.CreatedBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatedBy", 1))
	}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputParameters", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRule) SetConfigRuleArn(v string) *ConfigRule {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRule) SetConfigRuleId(v string) *ConfigRule {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRule) SetConfigRuleName(v string) *ConfigRule {
	s.ConfigRuleName = &v
	return s
}

// SetConfigRuleState sets the ConfigRuleState field's value.
func (s *ConfigRule) SetConfigRuleState(v string) *ConfigRule {
	s.ConfigRuleState = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConfigRule) SetCreatedBy(v string) *ConfigRule {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigRule) SetDescription(v string) *ConfigRule {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *ConfigRule) SetInputParameters(v string) *ConfigRule {
	s.InputParameters = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *ConfigRule) SetMaximumExecutionFrequency(v string) *ConfigRule {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ConfigRule) SetScope(v *Scope) *ConfigRule {
	s.Scope = v
	return s
}

// SetSource sets the Source field's value.
func (s *ConfigRule) SetSource(v *Source) *ConfigRule {
	s.Source = v
	return s
}

// Filters the compliance results based on account ID, region, compliance type,
// and rule name.
type ConfigRuleComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The rule compliance status.
	//
	// For the ConfigRuleComplianceFilters data type, AWS Config supports only COMPLIANT
	// and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE and the
	// INSUFFICIENT_DATA values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleComplianceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceFilters) SetAccountId(v string) *ConfigRuleComplianceFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceFilters) SetAwsRegion(v string) *ConfigRuleComplianceFilters {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConfigRuleComplianceFilters) SetComplianceType(v string) *ConfigRuleComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleComplianceFilters) SetConfigRuleName(v string) *ConfigRuleComplianceFilters {
	s.ConfigRuleName = &v
	return s
}

// Filters the results based on the account IDs and regions.
type ConfigRuleComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleComplianceSummaryFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceSummaryFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAccountId(v string) *ConfigRuleComplianceSummaryFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAwsRegion(v string) *ConfigRuleComplianceSummaryFilters {
	s.AwsRegion = &v
	return s
}

// Status information for your AWS managed Config rules. The status includes
// information such as the last time the rule ran, the last time it failed,
// and the related error for the last failure.
//
// This action does not return status information about custom AWS Config rules.
type ConfigRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `type:"string"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// The time that you first activated the AWS Config rule.
	FirstActivatedTime *time.Time `type:"timestamp"`

	// Indicates whether AWS Config has evaluated your resources against the rule
	// at least once.
	//
	//    * true - AWS Config has evaluated your AWS resources against the rule
	//    at least once.
	//
	//    * false - AWS Config has not once finished evaluating your AWS resources
	//    against the rule.
	FirstEvaluationStarted *bool `type:"boolean"`

	// The time that you last turned off the AWS Config rule.
	LastDeactivatedTime *time.Time `type:"timestamp"`

	// The error code that AWS Config returned when the rule last failed.
	LastErrorCode *string `type:"string"`

	// The error message that AWS Config returned when the rule last failed.
	LastErrorMessage *string `type:"string"`

	// The time that AWS Config last failed to evaluate your AWS resources against
	// the rule.
	LastFailedEvaluationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last failed to invoke the AWS Config rule to evaluate
	// your AWS resources.
	LastFailedInvocationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last successfully evaluated your AWS resources against
	// the rule.
	LastSuccessfulEvaluationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last successfully invoked the AWS Config rule to
	// evaluate your AWS resources.
	LastSuccessfulInvocationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ConfigRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleEvaluationStatus) GoString() string {
	return s.String()
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleArn(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleId(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleName(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleName = &v
	return s
}

// SetFirstActivatedTime sets the FirstActivatedTime field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstActivatedTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.FirstActivatedTime = &v
	return s
}

// SetFirstEvaluationStarted sets the FirstEvaluationStarted field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstEvaluationStarted(v bool) *ConfigRuleEvaluationStatus {
	s.FirstEvaluationStarted = &v
	return s
}

// SetLastDeactivatedTime sets the LastDeactivatedTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastDeactivatedTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastDeactivatedTime = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorCode(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorMessage(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastFailedEvaluationTime sets the LastFailedEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedEvaluationTime = &v
	return s
}

// SetLastFailedInvocationTime sets the LastFailedInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedInvocationTime = &v
	return s
}

// SetLastSuccessfulEvaluationTime sets the LastSuccessfulEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulEvaluationTime = &v
	return s
}

// SetLastSuccessfulInvocationTime sets the LastSuccessfulInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulInvocationTime = &v
	return s
}

// Provides options for how often AWS Config delivers configuration snapshots
// to the Amazon S3 bucket in your delivery channel.
//
// The frequency for a rule that triggers evaluations for your resources when
// AWS Config delivers the configuration snapshot is set by one of two values,
// depending on which is less frequent:
//
//    * The value for the deliveryFrequency parameter within the delivery channel
//    configuration, which sets how often AWS Config delivers configuration
//    snapshots. This value also sets how often AWS Config invokes evaluations
//    for AWS Config rules.
//
//    * The value for the MaximumExecutionFrequency parameter, which sets the
//    maximum frequency with which AWS Config invokes evaluations for the rule.
//    For more information, see ConfigRule.
//
// If the deliveryFrequency value is less frequent than the MaximumExecutionFrequency
// value for a rule, AWS Config invokes the rule only as often as the deliveryFrequency
// value.
//
// For example, you want your rule to run evaluations when AWS Config delivers
// the configuration snapshot.
//
// You specify the MaximumExecutionFrequency value for Six_Hours.
//
// You then specify the delivery channel deliveryFrequency value for TwentyFour_Hours.
//
// Because the value for deliveryFrequency is less frequent than MaximumExecutionFrequency,
// AWS Config invokes evaluations for the rule every 24 hours.
//
// You should set the MaximumExecutionFrequency value to be at least as frequent
// as the deliveryFrequency value. You can view the deliveryFrequency value
// by using the DescribeDeliveryChannnels action.
//
// To update the deliveryFrequency with which AWS Config delivers your configuration
// snapshots, use the PutDeliveryChannel action.
type ConfigSnapshotDeliveryProperties struct {
	_ struct{} `type:"structure"`

	// The frequency with which AWS Config delivers configuration snapshots.
	DeliveryFrequency *string `locationName:"deliveryFrequency" type:"string" enum:"MaximumExecutionFrequency"`
}

// String returns the string representation
func (s ConfigSnapshotDeliveryProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigSnapshotDeliveryProperties) GoString() string {
	return s.String()
}

// SetDeliveryFrequency sets the DeliveryFrequency field's value.
func (s *ConfigSnapshotDeliveryProperties) SetDeliveryFrequency(v string) *ConfigSnapshotDeliveryProperties {
	s.DeliveryFrequency = &v
	return s
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
type ConfigStreamDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	//
	// Note Providing an SNS topic on a DeliveryChannel (https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for AWS Config is optional. If the SNS delivery is turned off, the last status
	// will be Not_Applicable.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time from the last status change.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`
}

// String returns the string representation
func (s ConfigStreamDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigStreamDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorCode(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorMessage(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatus(v string) *ConfigStreamDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatusChangeTime(v time.Time) *ConfigStreamDeliveryInfo {
	s.LastStatusChangeTime = &v
	return s
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
type ConfigurationAggregator struct {
	_ struct{} `type:"structure"`

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []*AccountAggregationSource `type:"list"`

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string `type:"string"`

	// The name of the aggregator.
	ConfigurationAggregatorName *string `min:"1" type:"string"`

	// AWS service that created the configuration aggregator.
	CreatedBy *string `min:"1" type:"string"`

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time of the last update.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`
}

// String returns the string representation
func (s ConfigurationAggregator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationAggregator) GoString() string {
	return s.String()
}

// SetAccountAggregationSources sets the AccountAggregationSources field's value.
func (s *ConfigurationAggregator) SetAccountAggregationSources(v []*AccountAggregationSource) *ConfigurationAggregator {
	s.AccountAggregationSources = v
	return s
}

// SetConfigurationAggregatorArn sets the ConfigurationAggregatorArn field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorArn(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorArn = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorName(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConfigurationAggregator) SetCreatedBy(v string) *ConfigurationAggregator {
	s.CreatedBy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConfigurationAggregator) SetCreationTime(v time.Time) *ConfigurationAggregator {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ConfigurationAggregator) SetLastUpdatedTime(v time.Time) *ConfigurationAggregator {
	s.LastUpdatedTime = &v
	return s
}

// SetOrganizationAggregationSource sets the OrganizationAggregationSource field's value.
func (s *ConfigurationAggregator) SetOrganizationAggregationSource(v *OrganizationAggregationSource) *ConfigurationAggregator {
	s.OrganizationAggregationSource = v
	return s
}

// A list that contains detailed configurations of a specified resource.
type ConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// Amazon Resource Name (ARN) associated with the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// Unique MD5 hash that represents the configuration item's state.
	//
	// You can use MD5 hash to compare the states of two or more configuration items
	// that are associated with the same resource.
	ConfigurationItemMD5Hash *string `locationName:"configurationItemMD5Hash" type:"string"`

	// The configuration item status. The valid values are:
	//
	//    * OK – The resource configuration has been updated
	//
	//    * ResourceDiscovered – The resource was newly discovered
	//
	//    * ResourceNotRecorded – The resource was discovered but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	//    * ResourceDeleted – The resource was deleted
	//
	//    * ResourceDeletedNotRecorded – The resource was deleted but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// A list of CloudTrail event IDs.
	//
	// A populated field indicates that the current configuration was initiated
	// by the events recorded in the CloudTrail log. For more information about
	// CloudTrail, see What Is AWS CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
	//
	// An empty field indicates that the current configuration was not initiated
	// by any event. As of Version 1.3, the relatedEvents field is empty. You can
	// access the LookupEvents API (https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html)
	// in the AWS CloudTrail API Reference to retrieve the events for the resource.
	RelatedEvents []*string `locationName:"relatedEvents" type:"list"`

	// A list of related AWS resources.
	Relationships []*Relationship `locationName:"relationships" type:"list"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// A mapping of key value tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigurationItem) SetAccountId(v string) *ConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ConfigurationItem) SetArn(v string) *ConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ConfigurationItem) SetAvailabilityZone(v string) *ConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigurationItem) SetAwsRegion(v string) *ConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ConfigurationItem) SetConfiguration(v string) *ConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *ConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *ConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemMD5Hash sets the ConfigurationItemMD5Hash field's value.
func (s *ConfigurationItem) SetConfigurationItemMD5Hash(v string) *ConfigurationItem {
	s.ConfigurationItemMD5Hash = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *ConfigurationItem) SetConfigurationItemStatus(v string) *ConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *ConfigurationItem) SetConfigurationStateId(v string) *ConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *ConfigurationItem) SetRelatedEvents(v []*string) *ConfigurationItem {
	s.RelatedEvents = v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *ConfigurationItem) SetRelationships(v []*Relationship) *ConfigurationItem {
	s.Relationships = v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *ConfigurationItem) SetResourceCreationTime(v time.Time) *ConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConfigurationItem) SetResourceId(v string) *ConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ConfigurationItem) SetResourceName(v string) *ConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConfigurationItem) SetResourceType(v string) *ConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *ConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *ConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConfigurationItem) SetTags(v map[string]*string) *ConfigurationItem {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ConfigurationItem) SetVersion(v string) *ConfigurationItem {
	s.Version = &v
	return s
}

// An object that represents the recording of configuration changes of an AWS
// resource.
type ConfigurationRecorder struct {
	_ struct{} `type:"structure"`

	// The name of the recorder. By default, AWS Config automatically assigns the
	// name "default" when creating the configuration recorder. You cannot change
	// the assigned name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the types of AWS resources for which AWS Config records configuration
	// changes.
	RecordingGroup *RecordingGroup `locationName:"recordingGroup" type:"structure"`

	// Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources
	// associated with the account.
	RoleARN *string `locationName:"roleARN" type:"string"`
}

// String returns the string representation
func (s ConfigurationRecorder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRecorder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationRecorder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationRecorder"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorder) SetName(v string) *ConfigurationRecorder {
	s.Name = &v
	return s
}

// SetRecordingGroup sets the RecordingGroup field's value.
func (s *ConfigurationRecorder) SetRecordingGroup(v *RecordingGroup) *ConfigurationRecorder {
	s.RecordingGroup = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ConfigurationRecorder) SetRoleARN(v string) *ConfigurationRecorder {
	s.RoleARN = &v
	return s
}

// The current status of the configuration recorder.
type ConfigurationRecorderStatus struct {
	_ struct{} `type:"structure"`

	// The error code indicating that the recording failed.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The message indicating that the recording failed due to an error.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// The time the recorder was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The last (previous) status of the recorder.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"RecorderStatus"`

	// The time when the status was last changed.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`

	// The time the recorder was last stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp"`

	// The name of the configuration recorder.
	Name *string `locationName:"name" type:"string"`

	// Specifies whether or not the recorder is currently recording.
	Recording *bool `locationName:"recording" type:"boolean"`
}

// String returns the string representation
func (s ConfigurationRecorderStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRecorderStatus) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorCode(v string) *ConfigurationRecorderStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorMessage(v string) *ConfigurationRecorderStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStartTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStartTime = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigurationRecorderStatus) SetLastStatus(v string) *ConfigurationRecorderStatus {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStatusChangeTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStatusChangeTime = &v
	return s
}

// SetLastStopTime sets the LastStopTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStopTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStopTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorderStatus) SetName(v string) *ConfigurationRecorderStatus {
	s.Name = &v
	return s
}

// SetRecording sets the Recording field's value.
func (s *ConfigurationRecorderStatus) SetRecording(v bool) *ConfigurationRecorderStatus {
	s.Recording = &v
	return s
}

// Filters the conformance pack by compliance types and AWS Config rule names.
type ConformancePackComplianceFilters struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT. INSUFFICIENT_DATA is
	// not supported.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Filters the results by AWS Config rule names.
	ConfigRuleNames []*string `type:"list"`
}

// String returns the string representation
func (s ConformancePackComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackComplianceFilters) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackComplianceFilters) SetComplianceType(v string) *ConformancePackComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *ConformancePackComplianceFilters) SetConfigRuleNames(v []*string) *ConformancePackComplianceFilters {
	s.ConfigRuleNames = v
	return s
}

// Summary includes the name and status of the conformance pack.
type ConformancePackComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The status of the conformance pack. The allowed values are COMPLIANT, NON_COMPLIANT
	// and INSUFFICIENT_DATA.
	//
	// ConformancePackComplianceStatus is a required field
	ConformancePackComplianceStatus *string `type:"string" required:"true" enum:"ConformancePackComplianceType"`

	// The name of the conformance pack name.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConformancePackComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackComplianceSummary) GoString() string {
	return s.String()
}

// SetConformancePackComplianceStatus sets the ConformancePackComplianceStatus field's value.
func (s *ConformancePackComplianceSummary) SetConformancePackComplianceStatus(v string) *ConformancePackComplianceSummary {
	s.ConformancePackComplianceStatus = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackComplianceSummary) SetConformancePackName(v string) *ConformancePackComplianceSummary {
	s.ConformancePackName = &v
	return s
}

// Returns details of a conformance pack. A conformance pack is a collection
// of AWS Config rules and remediation actions that can be easily deployed in
// an account and a region.
type ConformancePackDetail struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the conformance pack.
	//
	// ConformancePackArn is a required field
	ConformancePackArn *string `min:"1" type:"string" required:"true"`

	// ID of the conformance pack.
	//
	// ConformancePackId is a required field
	ConformancePackId *string `min:"1" type:"string" required:"true"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// AWS service that created the conformance pack.
	CreatedBy *string `min:"1" type:"string"`

	// Amazon S3 bucket where AWS Config stores conformance pack templates.
	//
	// This field is optional.
	DeliveryS3Bucket *string `type:"string"`

	// The prefix for the Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// Last time when conformation pack update was requested.
	LastUpdateRequestedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ConformancePackDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackDetail) GoString() string {
	return s.String()
}

// SetConformancePackArn sets the ConformancePackArn field's value.
func (s *ConformancePackDetail) SetConformancePackArn(v string) *ConformancePackDetail {
	s.ConformancePackArn = &v
	return s
}

// SetConformancePackId sets the ConformancePackId field's value.
func (s *ConformancePackDetail) SetConformancePackId(v string) *ConformancePackDetail {
	s.ConformancePackId = &v
	return s
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *ConformancePackDetail) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *ConformancePackDetail {
	s.ConformancePackInputParameters = v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackDetail) SetConformancePackName(v string) *ConformancePackDetail {
	s.ConformancePackName = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConformancePackDetail) SetCreatedBy(v string) *ConformancePackDetail {
	s.CreatedBy = &v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *ConformancePackDetail) SetDeliveryS3Bucket(v string) *ConformancePackDetail {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *ConformancePackDetail) SetDeliveryS3KeyPrefix(v string) *ConformancePackDetail {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetLastUpdateRequestedTime sets the LastUpdateRequestedTime field's value.
func (s *ConformancePackDetail) SetLastUpdateRequestedTime(v time.Time) *ConformancePackDetail {
	s.LastUpdateRequestedTime = &v
	return s
}

// Filters a conformance pack by AWS Config rule names, compliance types, AWS
// resource types, and resource IDs.
type ConformancePackEvaluationFilters struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT. INSUFFICIENT_DATA is
	// not supported.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Filters the results by AWS Config rule names.
	ConfigRuleNames []*string `type:"list"`

	// Filters the results by resource IDs.
	//
	// This is valid only when you provide resource type. If there is no resource
	// type, you will see an error.
	ResourceIds []*string `type:"list"`

	// Filters the results by the resource type (for example, "AWS::EC2::Instance").
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConformancePackEvaluationFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackEvaluationFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConformancePackEvaluationFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConformancePackEvaluationFilters"}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackEvaluationFilters) SetComplianceType(v string) *ConformancePackEvaluationFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *ConformancePackEvaluationFilters) SetConfigRuleNames(v []*string) *ConformancePackEvaluationFilters {
	s.ConfigRuleNames = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ConformancePackEvaluationFilters) SetResourceIds(v []*string) *ConformancePackEvaluationFilters {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConformancePackEvaluationFilters) SetResourceType(v string) *ConformancePackEvaluationFilters {
	s.ResourceType = &v
	return s
}

// The details of a conformance pack evaluation. Provides AWS Config rule and
// AWS resource type that was evaluated, the compliance of the conformance pack,
// related time stamps, and supplementary information.
type ConformancePackEvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `type:"string"`

	// The compliance type. The allowed values are COMPLIANT and NON_COMPLIANT.
	// INSUFFICIENT_DATA is not supported.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ConformancePackComplianceType"`

	// The time when AWS Config rule evaluated AWS resource.
	//
	// ConfigRuleInvokedTime is a required field
	ConfigRuleInvokedTime *time.Time `type:"timestamp" required:"true"`

	// Uniquely identifies an evaluation result.
	//
	// EvaluationResultIdentifier is a required field
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure" required:"true"`

	// The time when AWS Config recorded the evaluation result.
	//
	// ResultRecordedTime is a required field
	ResultRecordedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ConformancePackEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackEvaluationResult) GoString() string {
	return s.String()
}

// SetAnnotation sets the Annotation field's value.
func (s *ConformancePackEvaluationResult) SetAnnotation(v string) *ConformancePackEvaluationResult {
	s.Annotation = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackEvaluationResult) SetComplianceType(v string) *ConformancePackEvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *ConformancePackEvaluationResult) SetConfigRuleInvokedTime(v time.Time) *ConformancePackEvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *ConformancePackEvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *ConformancePackEvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *ConformancePackEvaluationResult) SetResultRecordedTime(v time.Time) *ConformancePackEvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// Input parameters in the form of key-value pairs for the conformance pack,
// both of which you define. Keys can have a maximum character length of 255
// characters, and values can have a maximum length of 4096 characters.
type ConformancePackInputParameter struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair.
	//
	// ParameterName is a required field
	ParameterName *string `type:"string" required:"true"`

	// Another part of the key-value pair.
	//
	// ParameterValue is a required field
	ParameterValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConformancePackInputParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackInputParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConformancePackInputParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConformancePackInputParameter"}
	if s.ParameterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterName"))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterName sets the ParameterName field's value.
func (s *ConformancePackInputParameter) SetParameterName(v string) *ConformancePackInputParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ConformancePackInputParameter) SetParameterValue(v string) *ConformancePackInputParameter {
	s.ParameterValue = &v
	return s
}

// Compliance information of one or more AWS Config rules within a conformance
// pack. You can filter using AWS Config rule names and compliance types.
type ConformancePackRuleCompliance struct {
	_ struct{} `type:"structure"`

	// Compliance of the AWS Config rule.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Name of the config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Controls for the conformance pack. A control is a process to prevent or detect
	// problems while meeting objectives. A control can align with a specific compliance
	// regime or map to internal controls defined by an organization.
	Controls []*string `type:"list"`
}

// String returns the string representation
func (s ConformancePackRuleCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackRuleCompliance) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackRuleCompliance) SetComplianceType(v string) *ConformancePackRuleCompliance {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConformancePackRuleCompliance) SetConfigRuleName(v string) *ConformancePackRuleCompliance {
	s.ConfigRuleName = &v
	return s
}

// SetControls sets the Controls field's value.
func (s *ConformancePackRuleCompliance) SetControls(v []*string) *ConformancePackRuleCompliance {
	s.Controls = v
	return s
}

// Status details of a conformance pack.
type ConformancePackStatusDetail struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of comformance pack.
	//
	// ConformancePackArn is a required field
	ConformancePackArn *string `min:"1" type:"string" required:"true"`

	// ID of the conformance pack.
	//
	// ConformancePackId is a required field
	ConformancePackId *string `min:"1" type:"string" required:"true"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of conformance pack.
	//
	// AWS Config sets the state of the conformance pack to:
	//
	//    * CREATE_IN_PROGRESS when a conformance pack creation is in progress for
	//    an account.
	//
	//    * CREATE_COMPLETE when a conformance pack has been successfully created
	//    in your account.
	//
	//    * CREATE_FAILED when a conformance pack creation failed in your account.
	//
	//    * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
	//
	//    * DELETE_FAILED when a conformance pack deletion failed in your account.
	//
	// ConformancePackState is a required field
	ConformancePackState *string `type:"string" required:"true" enum:"ConformancePackState"`

	// The reason of conformance pack creation failure.
	ConformancePackStatusReason *string `type:"string"`

	// Last time when conformation pack creation and update was successful.
	LastUpdateCompletedTime *time.Time `type:"timestamp"`

	// Last time when conformation pack creation and update was requested.
	//
	// LastUpdateRequestedTime is a required field
	LastUpdateRequestedTime *time.Time `type:"timestamp" required:"true"`

	// Amazon Resource Name (ARN) of AWS CloudFormation stack.
	//
	// StackArn is a required field
	StackArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConformancePackStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackStatusDetail) GoString() string {
	return s.String()
}

// SetConformancePackArn sets the ConformancePackArn field's value.
func (s *ConformancePackStatusDetail) SetConformancePackArn(v string) *ConformancePackStatusDetail {
	s.ConformancePackArn = &v
	return s
}

// SetConformancePackId sets the ConformancePackId field's value.
func (s *ConformancePackStatusDetail) SetConformancePackId(v string) *ConformancePackStatusDetail {
	s.ConformancePackId = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackStatusDetail) SetConformancePackName(v string) *ConformancePackStatusDetail {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackState sets the ConformancePackState field's value.
func (s *ConformancePackStatusDetail) SetConformancePackState(v string) *ConformancePackStatusDetail {
	s.ConformancePackState = &v
	return s
}

// SetConformancePackStatusReason sets the ConformancePackStatusReason field's value.
func (s *ConformancePackStatusDetail) SetConformancePackStatusReason(v string) *ConformancePackStatusDetail {
	s.ConformancePackStatusReason = &v
	return s
}

// SetLastUpdateCompletedTime sets the LastUpdateCompletedTime field's value.
func (s *ConformancePackStatusDetail) SetLastUpdateCompletedTime(v time.Time) *ConformancePackStatusDetail {
	s.LastUpdateCompletedTime = &v
	return s
}

// SetLastUpdateRequestedTime sets the LastUpdateRequestedTime field's value.
func (s *ConformancePackStatusDetail) SetLastUpdateRequestedTime(v time.Time) *ConformancePackStatusDetail {
	s.LastUpdateRequestedTime = &v
	return s
}

// SetStackArn sets the StackArn field's value.
func (s *ConformancePackStatusDetail) SetStackArn(v string) *ConformancePackStatusDetail {
	s.StackArn = &v
	return s
}

// You have specified a template that is not valid or supported.
type ConformancePackTemplateValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConformancePackTemplateValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConformancePackTemplateValidationException) GoString() string {
	return s.String()
}

func newErrorConformancePackTemplateValidationException(v protocol.ResponseMetadata) error {
	return &ConformancePackTemplateValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConformancePackTemplateValidationException) Code() string {
	return "ConformancePackTemplateValidationException"
}

// Message returns the exception's message.
func (s *ConformancePackTemplateValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConformancePackTemplateValidationException) OrigErr() error {
	return nil
}

func (s *ConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConformancePackTemplateValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConformancePackTemplateValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAggregationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAggregationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAggregationAuthorizationInput"}
	if s.AuthorizedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAccountId"))
	}
	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAccountId(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAwsRegion(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAwsRegion = &v
	return s
}

type DeleteAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAggregationAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule that you want to delete.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteConfigRuleInput) SetConfigRuleName(v string) *DeleteConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

type DeleteConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigRuleOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationAggregatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationAggregatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationAggregatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationAggregatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationAggregatorInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DeleteConfigurationAggregatorInput) SetConfigurationAggregatorName(v string) *DeleteConfigurationAggregatorInput {
	s.ConfigurationAggregatorName = &v
	return s
}

type DeleteConfigurationAggregatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationAggregatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationAggregatorOutput) GoString() string {
	return s.String()
}

// The request object for the DeleteConfigurationRecorder action.
type DeleteConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration recorder to be deleted. You can retrieve the
	// name of your configuration recorder by using the DescribeConfigurationRecorders
	// action.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *DeleteConfigurationRecorderInput) SetConfigurationRecorderName(v string) *DeleteConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type DeleteConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationRecorderOutput) GoString() string {
	return s.String()
}

type DeleteConformancePackInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack you want to delete.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConformancePackInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DeleteConformancePackInput) SetConformancePackName(v string) *DeleteConformancePackInput {
	s.ConformancePackName = &v
	return s
}

type DeleteConformancePackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConformancePackOutput) GoString() string {
	return s.String()
}

// The input for the DeleteDeliveryChannel action. The action accepts the following
// data, in JSON format.
type DeleteDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel to delete.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryChannelInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeleteDeliveryChannelInput) SetDeliveryChannelName(v string) *DeleteDeliveryChannelInput {
	s.DeliveryChannelName = &v
	return s
}

type DeleteDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryChannelOutput) GoString() string {
	return s.String()
}

type DeleteEvaluationResultsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete the evaluation
	// results.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEvaluationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEvaluationResultsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteEvaluationResultsInput) SetConfigRuleName(v string) *DeleteEvaluationResultsInput {
	s.ConfigRuleName = &v
	return s
}

// The output when you delete the evaluation results for the specified AWS Config
// rule.
type DeleteEvaluationResultsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEvaluationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationResultsOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of organization config rule that you want to delete.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOrganizationConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationConfigRuleInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *DeleteOrganizationConfigRuleInput) SetOrganizationConfigRuleName(v string) *DeleteOrganizationConfigRuleInput {
	s.OrganizationConfigRuleName = &v
	return s
}

type DeleteOrganizationConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationConfigRuleOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationConformancePackInput struct {
	_ struct{} `type:"structure"`

	// The name of organization conformance pack that you want to delete.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOrganizationConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationConformancePackInput"}
	if s.OrganizationConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConformancePackName"))
	}
	if s.OrganizationConformancePackName != nil && len(*s.OrganizationConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *DeleteOrganizationConformancePackInput) SetOrganizationConformancePackName(v string) *DeleteOrganizationConformancePackInput {
	s.OrganizationConformancePackName = &v
	return s
}

type DeleteOrganizationConformancePackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationConformancePackOutput) GoString() string {
	return s.String()
}

type DeletePendingAggregationRequestInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	//
	// RequesterAccountId is a required field
	RequesterAccountId *string `type:"string" required:"true"`

	// The region requesting to aggregate data.
	//
	// RequesterAwsRegion is a required field
	RequesterAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePendingAggregationRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePendingAggregationRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePendingAggregationRequestInput"}
	if s.RequesterAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAccountId"))
	}
	if s.RequesterAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAwsRegion"))
	}
	if s.RequesterAwsRegion != nil && len(*s.RequesterAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequesterAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequesterAccountId sets the RequesterAccountId field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAccountId(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAccountId = &v
	return s
}

// SetRequesterAwsRegion sets the RequesterAwsRegion field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAwsRegion(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAwsRegion = &v
	return s
}

type DeletePendingAggregationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePendingAggregationRequestOutput) GoString() string {
	return s.String()
}

type DeleteRemediationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete remediation
	// configuration.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The type of a resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s DeleteRemediationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemediationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemediationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemediationConfigurationInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteRemediationConfigurationInput) SetConfigRuleName(v string) *DeleteRemediationConfigurationInput {
	s.ConfigRuleName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteRemediationConfigurationInput) SetResourceType(v string) *DeleteRemediationConfigurationInput {
	s.ResourceType = &v
	return s
}

type DeleteRemediationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRemediationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemediationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteRemediationExceptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete remediation
	// exception configuration.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An exception list of resource exception keys to be processed with the current
	// request. AWS Config adds exception for each resource key. For example, AWS
	// Config adds 3 exceptions for 3 resource keys.
	//
	// ResourceKeys is a required field
	ResourceKeys []*RemediationExceptionResourceKey `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteRemediationExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemediationExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemediationExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemediationExceptionsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteRemediationExceptionsInput) SetConfigRuleName(v string) *DeleteRemediationExceptionsInput {
	s.ConfigRuleName = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DeleteRemediationExceptionsInput) SetResourceKeys(v []*RemediationExceptionResourceKey) *DeleteRemediationExceptionsInput {
	s.ResourceKeys = v
	return s
}

type DeleteRemediationExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of failed delete remediation exceptions batch objects. Each
	// object in the batch consists of a list of failed items and failure messages.
	FailedBatches []*FailedDeleteRemediationExceptionsBatch `type:"list"`
}

// String returns the string representation
func (s DeleteRemediationExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemediationExceptionsOutput) GoString() string {
	return s.String()
}

// SetFailedBatches sets the FailedBatches field's value.
func (s *DeleteRemediationExceptionsOutput) SetFailedBatches(v []*FailedDeleteRemediationExceptionsBatch) *DeleteRemediationExceptionsOutput {
	s.FailedBatches = v
	return s
}

type DeleteResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteResourceConfigInput) SetResourceId(v string) *DeleteResourceConfigInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteResourceConfigInput) SetResourceType(v string) *DeleteResourceConfigInput {
	s.ResourceType = &v
	return s
}

type DeleteResourceConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceConfigOutput) GoString() string {
	return s.String()
}

type DeleteRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration to delete.
	//
	// RetentionConfigurationName is a required field
	RetentionConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRetentionConfigurationInput"}
	if s.RetentionConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionConfigurationName"))
	}
	if s.RetentionConfigurationName != nil && len(*s.RetentionConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetentionConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionConfigurationName sets the RetentionConfigurationName field's value.
func (s *DeleteRetentionConfigurationInput) SetRetentionConfigurationName(v string) *DeleteRetentionConfigurationInput {
	s.RetentionConfigurationName = &v
	return s
}

type DeleteRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStoredQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the query that you want to delete.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStoredQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStoredQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStoredQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStoredQueryInput"}
	if s.QueryName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryName"))
	}
	if s.QueryName != nil && len(*s.QueryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryName sets the QueryName field's value.
func (s *DeleteStoredQueryInput) SetQueryName(v string) *DeleteStoredQueryInput {
	s.QueryName = &v
	return s
}

type DeleteStoredQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStoredQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStoredQueryOutput) GoString() string {
	return s.String()
}

// The input for the DeliverConfigSnapshot action.
type DeliverConfigSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel through which the snapshot is delivered.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `locationName:"deliveryChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeliverConfigSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverConfigSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliverConfigSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliverConfigSnapshotInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeliverConfigSnapshotInput) SetDeliveryChannelName(v string) *DeliverConfigSnapshotInput {
	s.DeliveryChannelName = &v
	return s
}

// The output for the DeliverConfigSnapshot action, in JSON format.
type DeliverConfigSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot that is being created.
	ConfigSnapshotId *string `locationName:"configSnapshotId" type:"string"`
}

// String returns the string representation
func (s DeliverConfigSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverConfigSnapshotOutput) GoString() string {
	return s.String()
}

// SetConfigSnapshotId sets the ConfigSnapshotId field's value.
func (s *DeliverConfigSnapshotOutput) SetConfigSnapshotId(v string) *DeliverConfigSnapshotOutput {
	s.ConfigSnapshotId = &v
	return s
}

// The channel through which AWS Config delivers notifications and updated configuration
// states.
type DeliveryChannel struct {
	_ struct{} `type:"structure"`

	// The options for how often AWS Config delivers configuration snapshots to
	// the Amazon S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties `locationName:"configSnapshotDeliveryProperties" type:"structure"`

	// The name of the delivery channel. By default, AWS Config assigns the name
	// "default" when creating the delivery channel. To change the delivery channel
	// name, you must use the DeleteDeliveryChannel action to delete your current
	// delivery channel, and then you must use the PutDeliveryChannel command to
	// create a delivery channel that has the desired name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The name of the Amazon S3 bucket to which AWS Config delivers configuration
	// snapshots and configuration history files.
	//
	// If you specify a bucket that belongs to another AWS account, that bucket
	// must have policies that grant access permissions to AWS Config. For more
	// information, see Permissions for the Amazon S3 Bucket (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the AWS Config Developer Guide.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) customer
	// managed key (CMK) used to encrypt objects delivered by AWS Config. Must belong
	// to the same Region as the destination S3 bucket.
	S3KmsKeyArn *string `locationName:"s3KmsKeyArn" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config
	// sends notifications about configuration changes.
	//
	// If you choose a topic from another account, the topic must have policies
	// that grant access permissions to AWS Config. For more information, see Permissions
	// for the Amazon SNS Topic (https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the AWS Config Developer Guide.
	SnsTopicARN *string `locationName:"snsTopicARN" type:"string"`
}

// String returns the string representation
func (s DeliveryChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliveryChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliveryChannel"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigSnapshotDeliveryProperties sets the ConfigSnapshotDeliveryProperties field's value.
func (s *DeliveryChannel) SetConfigSnapshotDeliveryProperties(v *ConfigSnapshotDeliveryProperties) *DeliveryChannel {
	s.ConfigSnapshotDeliveryProperties = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannel) SetName(v string) *DeliveryChannel {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DeliveryChannel) SetS3BucketName(v string) *DeliveryChannel {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *DeliveryChannel) SetS3KeyPrefix(v string) *DeliveryChannel {
	s.S3KeyPrefix = &v
	return s
}

// SetS3KmsKeyArn sets the S3KmsKeyArn field's value.
func (s *DeliveryChannel) SetS3KmsKeyArn(v string) *DeliveryChannel {
	s.S3KmsKeyArn = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *DeliveryChannel) SetSnsTopicARN(v string) *DeliveryChannel {
	s.SnsTopicARN = &v
	return s
}

// The status of a specified delivery channel.
//
// Valid values: Success | Failure
type DeliveryChannelStatus struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of the delivery of the configuration history
	// to the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configHistoryDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configSnapshotDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo `locationName:"configStreamDeliveryInfo" type:"structure"`

	// The name of the delivery channel.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DeliveryChannelStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryChannelStatus) GoString() string {
	return s.String()
}

// SetConfigHistoryDeliveryInfo sets the ConfigHistoryDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigHistoryDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigHistoryDeliveryInfo = v
	return s
}

// SetConfigSnapshotDeliveryInfo sets the ConfigSnapshotDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigSnapshotDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigSnapshotDeliveryInfo = v
	return s
}

// SetConfigStreamDeliveryInfo sets the ConfigStreamDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigStreamDeliveryInfo(v *ConfigStreamDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigStreamDeliveryInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannelStatus) SetName(v string) *DeliveryChannelStatus {
	s.Name = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results by ConfigRuleComplianceFilters object.
	Filters *ConfigRuleComplianceFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConfigRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConfigRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAggregateComplianceByConfigRulesInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetConfigurationAggregatorName(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetFilters(v *ConfigRuleComplianceFilters) *DescribeAggregateComplianceByConfigRulesInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetLimit(v int64) *DescribeAggregateComplianceByConfigRulesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceByConfigRule object.
	AggregateComplianceByConfigRules []*AggregateComplianceByConfigRule `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConfigRulesOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceByConfigRules sets the AggregateComplianceByConfigRules field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetAggregateComplianceByConfigRules(v []*AggregateComplianceByConfigRule) *DescribeAggregateComplianceByConfigRulesOutput {
	s.AggregateComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the result by AggregateConformancePackComplianceFilters object.
	Filters *AggregateConformancePackComplianceFilters `type:"structure"`

	// The maximum number of conformance packs compliance details returned on each
	// page. The default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConformancePacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConformancePacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAggregateComplianceByConformancePacksInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetConfigurationAggregatorName(v string) *DescribeAggregateComplianceByConformancePacksInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetFilters(v *AggregateConformancePackComplianceFilters) *DescribeAggregateComplianceByConformancePacksInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetLimit(v int64) *DescribeAggregateComplianceByConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetNextToken(v string) *DescribeAggregateComplianceByConformancePacksInput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// Returns the AggregateComplianceByConformancePack object.
	AggregateComplianceByConformancePacks []*AggregateComplianceByConformancePack `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConformancePacksOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceByConformancePacks sets the AggregateComplianceByConformancePacks field's value.
func (s *DescribeAggregateComplianceByConformancePacksOutput) SetAggregateComplianceByConformancePacks(v []*AggregateComplianceByConformancePack) *DescribeAggregateComplianceByConformancePacksOutput {
	s.AggregateComplianceByConformancePacks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConformancePacksOutput) SetNextToken(v string) *DescribeAggregateComplianceByConformancePacksOutput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregationAuthorizationsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregationAuthorizationsInput) SetLimit(v int64) *DescribeAggregationAuthorizationsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsInput) SetNextToken(v string) *DescribeAggregationAuthorizationsInput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of authorizations granted to various aggregator accounts and
	// regions.
	AggregationAuthorizations []*AggregationAuthorization `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregationAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetAggregationAuthorizations sets the AggregationAuthorizations field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetAggregationAuthorizations(v []*AggregationAuthorization) *DescribeAggregationAuthorizationsOutput {
	s.AggregationAuthorizations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetNextToken(v string) *DescribeAggregationAuthorizationsOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT.
	ComplianceTypes []*string `type:"list"`

	// Specify one or more AWS Config rule names to filter the results by rule.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByConfigRuleInput) GoString() string {
	return s.String()
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByConfigRuleInput) SetComplianceTypes(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeComplianceByConfigRuleInput) SetConfigRuleNames(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleInput) SetNextToken(v string) *DescribeComplianceByConfigRuleInput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether each of the specified AWS Config rules is compliant.
	ComplianceByConfigRules []*ComplianceByConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceByConfigRules sets the ComplianceByConfigRules field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetComplianceByConfigRules(v []*ComplianceByConfigRule) *DescribeComplianceByConfigRuleOutput {
	s.ComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetNextToken(v string) *DescribeComplianceByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceTypes []*string `type:"list"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information. You
	// can specify only one resource ID. If you specify a resource ID, you must
	// also specify a type for ResourceType.
	ResourceId *string `min:"1" type:"string"`

	// The types of AWS resources for which you want compliance information (for
	// example, AWS::EC2::Instance). For this action, you can specify that the resource
	// type is an AWS account by specifying AWS::::Account.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComplianceByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComplianceByResourceInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByResourceInput) SetComplianceTypes(v []*string) *DescribeComplianceByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeComplianceByResourceInput) SetLimit(v int64) *DescribeComplianceByResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceInput) SetNextToken(v string) *DescribeComplianceByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeComplianceByResourceInput) SetResourceId(v string) *DescribeComplianceByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeComplianceByResourceInput) SetResourceType(v string) *DescribeComplianceByResourceInput {
	s.ResourceType = &v
	return s
}

type DescribeComplianceByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies with all of the AWS
	// Config rules that evaluate it.
	ComplianceByResources []*ComplianceByResource `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByResourceOutput) GoString() string {
	return s.String()
}

// SetComplianceByResources sets the ComplianceByResources field's value.
func (s *DescribeComplianceByResourceOutput) SetComplianceByResources(v []*ComplianceByResource) *DescribeComplianceByResourceOutput {
	s.ComplianceByResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceOutput) SetNextToken(v string) *DescribeComplianceByResourceOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS managed Config rules for which you want status information.
	// If you do not specify any names, AWS Config returns status information for
	// all AWS managed Config rules that you use.
	ConfigRuleNames []*string `type:"list"`

	// The number of rule evaluation results that you want returned.
	//
	// This parameter is required if the rule limit for your account is more than
	// the default of 150 rules.
	//
	// For information about requesting a rule limit increase, see AWS Config Limits
	// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
	// in the AWS General Reference Guide.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRuleEvaluationStatusInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetConfigRuleNames(v []*string) *DescribeConfigRuleEvaluationStatusInput {
	s.ConfigRuleNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetLimit(v int64) *DescribeConfigRuleEvaluationStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status information about your AWS managed Config rules.
	ConfigRulesEvaluationStatus []*ConfigRuleEvaluationStatus `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRuleEvaluationStatusOutput) GoString() string {
	return s.String()
}

// SetConfigRulesEvaluationStatus sets the ConfigRulesEvaluationStatus field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetConfigRulesEvaluationStatus(v []*ConfigRuleEvaluationStatus) *DescribeConfigRuleEvaluationStatusOutput {
	s.ConfigRulesEvaluationStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The names of the AWS Config rules for which you want details. If you do not
	// specify any names, AWS Config returns details for all your rules.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRulesInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRulesInput) SetConfigRuleNames(v []*string) *DescribeConfigRulesInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesInput) SetNextToken(v string) *DescribeConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The details about your AWS Config rules.
	ConfigRules []*ConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRulesOutput) GoString() string {
	return s.String()
}

// SetConfigRules sets the ConfigRules field's value.
func (s *DescribeConfigRulesOutput) SetConfigRules(v []*ConfigRule) *DescribeConfigRulesOutput {
	s.ConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesOutput) SetNextToken(v string) *DescribeConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of AggregatorSourceStatus returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Filters the status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	UpdateStatus []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationAggregatorSourcesStatusInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.UpdateStatus != nil && len(s.UpdateStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateStatus", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetConfigurationAggregatorName(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetLimit(v int64) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.NextToken = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetUpdateStatus(v []*string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.UpdateStatus = v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregatedSourceStatus object.
	AggregatedSourceStatusList []*AggregatedSourceStatus `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusOutput) GoString() string {
	return s.String()
}

// SetAggregatedSourceStatusList sets the AggregatedSourceStatusList field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetAggregatedSourceStatusList(v []*AggregatedSourceStatus) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.AggregatedSourceStatusList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregators.
	ConfigurationAggregatorNames []*string `type:"list"`

	// The maximum number of configuration aggregators returned on each page. The
	// default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorsInput) GoString() string {
	return s.String()
}

// SetConfigurationAggregatorNames sets the ConfigurationAggregatorNames field's value.
func (s *DescribeConfigurationAggregatorsInput) SetConfigurationAggregatorNames(v []*string) *DescribeConfigurationAggregatorsInput {
	s.ConfigurationAggregatorNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorsInput) SetLimit(v int64) *DescribeConfigurationAggregatorsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsInput) SetNextToken(v string) *DescribeConfigurationAggregatorsInput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationAggregators object.
	ConfigurationAggregators []*ConfigurationAggregator `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorsOutput) GoString() string {
	return s.String()
}

// SetConfigurationAggregators sets the ConfigurationAggregators field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetConfigurationAggregators(v []*ConfigurationAggregator) *DescribeConfigurationAggregatorsOutput {
	s.ConfigurationAggregators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetNextToken(v string) *DescribeConfigurationAggregatorsOutput {
	s.NextToken = &v
	return s
}

// The input for the DescribeConfigurationRecorderStatus action.
type DescribeConfigurationRecorderStatusInput struct {
	_ struct{} `type:"structure"`

	// The name(s) of the configuration recorder. If the name is not specified,
	// the action returns the current status of all the configuration recorders
	// associated with the account.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecorderStatusInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecorderStatusInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecorderStatusInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorderStatus action, in JSON format.
type DescribeConfigurationRecorderStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains status of the specified recorders.
	ConfigurationRecordersStatus []*ConfigurationRecorderStatus `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecorderStatusOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecordersStatus sets the ConfigurationRecordersStatus field's value.
func (s *DescribeConfigurationRecorderStatusOutput) SetConfigurationRecordersStatus(v []*ConfigurationRecorderStatus) *DescribeConfigurationRecorderStatusOutput {
	s.ConfigurationRecordersStatus = v
	return s
}

// The input for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration recorder names.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecordersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecordersInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecordersInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecordersInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified configuration recorders.
	ConfigurationRecorders []*ConfigurationRecorder `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecordersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecordersOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecorders sets the ConfigurationRecorders field's value.
func (s *DescribeConfigurationRecordersOutput) SetConfigurationRecorders(v []*ConfigurationRecorder) *DescribeConfigurationRecordersOutput {
	s.ConfigurationRecorders = v
	return s
}

type DescribeConformancePackComplianceInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackComplianceFilters object.
	Filters *ConformancePackComplianceFilters `type:"structure"`

	// The maximum number of AWS Config rules within a conformance pack are returned
	// on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackComplianceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePackComplianceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConformancePackComplianceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConformancePackComplianceInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DescribeConformancePackComplianceInput) SetConformancePackName(v string) *DescribeConformancePackComplianceInput {
	s.ConformancePackName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeConformancePackComplianceInput) SetFilters(v *ConformancePackComplianceFilters) *DescribeConformancePackComplianceInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePackComplianceInput) SetLimit(v int64) *DescribeConformancePackComplianceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackComplianceInput) SetNextToken(v string) *DescribeConformancePackComplianceInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackComplianceOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackRuleCompliance objects.
	//
	// ConformancePackRuleComplianceList is a required field
	ConformancePackRuleComplianceList []*ConformancePackRuleCompliance `type:"list" required:"true"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackComplianceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePackComplianceOutput) GoString() string {
	return s.String()
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DescribeConformancePackComplianceOutput) SetConformancePackName(v string) *DescribeConformancePackComplianceOutput {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackRuleComplianceList sets the ConformancePackRuleComplianceList field's value.
func (s *DescribeConformancePackComplianceOutput) SetConformancePackRuleComplianceList(v []*ConformancePackRuleCompliance) *DescribeConformancePackComplianceOutput {
	s.ConformancePackRuleComplianceList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackComplianceOutput) SetNextToken(v string) *DescribeConformancePackComplianceOutput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackStatusInput struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of conformance pack names.
	ConformancePackNames []*string `type:"list"`

	// The maximum number of conformance packs status returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePackStatusInput) GoString() string {
	return s.String()
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *DescribeConformancePackStatusInput) SetConformancePackNames(v []*string) *DescribeConformancePackStatusInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePackStatusInput) SetLimit(v int64) *DescribeConformancePackStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackStatusInput) SetNextToken(v string) *DescribeConformancePackStatusInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackStatusDetail objects.
	ConformancePackStatusDetails []*ConformancePackStatusDetail `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePackStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePackStatusOutput) GoString() string {
	return s.String()
}

// SetConformancePackStatusDetails sets the ConformancePackStatusDetails field's value.
func (s *DescribeConformancePackStatusOutput) SetConformancePackStatusDetails(v []*ConformancePackStatusDetail) *DescribeConformancePackStatusOutput {
	s.ConformancePackStatusDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackStatusOutput) SetNextToken(v string) *DescribeConformancePackStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of conformance pack names for which you want details.
	// If you do not specify any names, AWS Config returns details for all your
	// conformance packs.
	ConformancePackNames []*string `type:"list"`

	// The maximum number of conformance packs returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePacksInput) GoString() string {
	return s.String()
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *DescribeConformancePacksInput) SetConformancePackNames(v []*string) *DescribeConformancePacksInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePacksInput) SetLimit(v int64) *DescribeConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePacksInput) SetNextToken(v string) *DescribeConformancePacksInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of ConformancePackDetail objects.
	ConformancePackDetails []*ConformancePackDetail `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConformancePacksOutput) GoString() string {
	return s.String()
}

// SetConformancePackDetails sets the ConformancePackDetails field's value.
func (s *DescribeConformancePacksOutput) SetConformancePackDetails(v []*ConformancePackDetail) *DescribeConformancePacksOutput {
	s.ConformancePackDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePacksOutput) SetNextToken(v string) *DescribeConformancePacksOutput {
	s.NextToken = &v
	return s
}

// The input for the DeliveryChannelStatus action.
type DescribeDeliveryChannelStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelStatusInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelStatusInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelStatusInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannelStatus action.
type DescribeDeliveryChannelStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of a specified delivery channel.
	DeliveryChannelsStatus []*DeliveryChannelStatus `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelStatusOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannelsStatus sets the DeliveryChannelsStatus field's value.
func (s *DescribeDeliveryChannelStatusOutput) SetDeliveryChannelsStatus(v []*DeliveryChannelStatus) *DescribeDeliveryChannelStatusOutput {
	s.DeliveryChannelsStatus = v
	return s
}

// The input for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelsInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelsInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelsInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified delivery channel.
	DeliveryChannels []*DeliveryChannel `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelsOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannels sets the DeliveryChannels field's value.
func (s *DescribeDeliveryChannelsOutput) SetDeliveryChannels(v []*DeliveryChannel) *DescribeDeliveryChannelsOutput {
	s.DeliveryChannels = v
	return s
}

type DescribeOrganizationConfigRuleStatusesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of OrganizationConfigRuleStatuses returned on each page.
	// If you do no specify a number, AWS Config uses the default. The default is
	// 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization config rules for which you want status details.
	// If you do not specify any names, AWS Config returns details for all your
	// organization AWS Confg rules.
	OrganizationConfigRuleNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRuleStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigRuleStatusesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetLimit(v int64) *DescribeOrganizationConfigRuleStatusesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetNextToken(v string) *DescribeOrganizationConfigRuleStatusesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleNames sets the OrganizationConfigRuleNames field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetOrganizationConfigRuleNames(v []*string) *DescribeOrganizationConfigRuleStatusesInput {
	s.OrganizationConfigRuleNames = v
	return s
}

type DescribeOrganizationConfigRuleStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConfigRuleStatus objects.
	OrganizationConfigRuleStatuses []*OrganizationConfigRuleStatus `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRuleStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigRuleStatusesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRuleStatusesOutput) SetNextToken(v string) *DescribeOrganizationConfigRuleStatusesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleStatuses sets the OrganizationConfigRuleStatuses field's value.
func (s *DescribeOrganizationConfigRuleStatusesOutput) SetOrganizationConfigRuleStatuses(v []*OrganizationConfigRuleStatus) *DescribeOrganizationConfigRuleStatusesOutput {
	s.OrganizationConfigRuleStatuses = v
	return s
}

type DescribeOrganizationConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of organization config rules returned on each page. If
	// you do no specify a number, AWS Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization config rules for which you want details. If you
	// do not specify any names, AWS Config returns details for all your organization
	// config rules.
	OrganizationConfigRuleNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigRulesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConfigRulesInput) SetLimit(v int64) *DescribeOrganizationConfigRulesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRulesInput) SetNextToken(v string) *DescribeOrganizationConfigRulesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleNames sets the OrganizationConfigRuleNames field's value.
func (s *DescribeOrganizationConfigRulesInput) SetOrganizationConfigRuleNames(v []*string) *DescribeOrganizationConfigRulesInput {
	s.OrganizationConfigRuleNames = v
	return s
}

type DescribeOrganizationConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of OrganizationConfigRule objects.
	OrganizationConfigRules []*OrganizationConfigRule `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRulesOutput) SetNextToken(v string) *DescribeOrganizationConfigRulesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRules sets the OrganizationConfigRules field's value.
func (s *DescribeOrganizationConfigRulesOutput) SetOrganizationConfigRules(v []*OrganizationConfigRule) *DescribeOrganizationConfigRulesOutput {
	s.OrganizationConfigRules = v
	return s
}

type DescribeOrganizationConformancePackStatusesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of OrganizationConformancePackStatuses returned on each
	// page. If you do no specify a number, AWS Config uses the default. The default
	// is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization conformance packs for which you want status details.
	// If you do not specify any names, AWS Config returns details for all your
	// organization conformance packs.
	OrganizationConformancePackNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePackStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConformancePackStatusesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetLimit(v int64) *DescribeOrganizationConformancePackStatusesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetNextToken(v string) *DescribeOrganizationConformancePackStatusesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackNames sets the OrganizationConformancePackNames field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetOrganizationConformancePackNames(v []*string) *DescribeOrganizationConformancePackStatusesInput {
	s.OrganizationConformancePackNames = v
	return s
}

type DescribeOrganizationConformancePackStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConformancePackStatus objects.
	OrganizationConformancePackStatuses []*OrganizationConformancePackStatus `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePackStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConformancePackStatusesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePackStatusesOutput) SetNextToken(v string) *DescribeOrganizationConformancePackStatusesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackStatuses sets the OrganizationConformancePackStatuses field's value.
func (s *DescribeOrganizationConformancePackStatusesOutput) SetOrganizationConformancePackStatuses(v []*OrganizationConformancePackStatus) *DescribeOrganizationConformancePackStatusesOutput {
	s.OrganizationConformancePackStatuses = v
	return s
}

type DescribeOrganizationConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of organization config packs returned on each page. If
	// you do no specify a number, AWS Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name that you assign to an organization conformance pack.
	OrganizationConformancePackNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConformancePacksInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConformancePacksInput) SetLimit(v int64) *DescribeOrganizationConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePacksInput) SetNextToken(v string) *DescribeOrganizationConformancePacksInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackNames sets the OrganizationConformancePackNames field's value.
func (s *DescribeOrganizationConformancePacksInput) SetOrganizationConformancePackNames(v []*string) *DescribeOrganizationConformancePacksInput {
	s.OrganizationConformancePackNames = v
	return s
}

type DescribeOrganizationConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of OrganizationConformancePacks objects.
	OrganizationConformancePacks []*OrganizationConformancePack `type:"list"`
}

// String returns the string representation
func (s DescribeOrganizationConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConformancePacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePacksOutput) SetNextToken(v string) *DescribeOrganizationConformancePacksOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePacks sets the OrganizationConformancePacks field's value.
func (s *DescribeOrganizationConformancePacksOutput) SetOrganizationConformancePacks(v []*OrganizationConformancePack) *DescribeOrganizationConformancePacksOutput {
	s.OrganizationConformancePacks = v
	return s
}

type DescribePendingAggregationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingAggregationRequestsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribePendingAggregationRequestsInput) SetLimit(v int64) *DescribePendingAggregationRequestsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsInput) SetNextToken(v string) *DescribePendingAggregationRequestsInput {
	s.NextToken = &v
	return s
}

type DescribePendingAggregationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a PendingAggregationRequests object.
	PendingAggregationRequests []*PendingAggregationRequest `type:"list"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingAggregationRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsOutput) SetNextToken(v string) *DescribePendingAggregationRequestsOutput {
	s.NextToken = &v
	return s
}

// SetPendingAggregationRequests sets the PendingAggregationRequests field's value.
func (s *DescribePendingAggregationRequestsOutput) SetPendingAggregationRequests(v []*PendingAggregationRequest) *DescribePendingAggregationRequestsOutput {
	s.PendingAggregationRequests = v
	return s
}

type DescribeRemediationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS Config rule names of remediation configurations for which you
	// want details.
	//
	// ConfigRuleNames is a required field
	ConfigRuleNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeRemediationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationConfigurationsInput"}
	if s.ConfigRuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeRemediationConfigurationsInput) SetConfigRuleNames(v []*string) *DescribeRemediationConfigurationsInput {
	s.ConfigRuleNames = v
	return s
}

type DescribeRemediationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a remediation configuration object.
	RemediationConfigurations []*RemediationConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeRemediationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationConfigurationsOutput) GoString() string {
	return s.String()
}

// SetRemediationConfigurations sets the RemediationConfigurations field's value.
func (s *DescribeRemediationConfigurationsOutput) SetRemediationConfigurations(v []*RemediationConfiguration) *DescribeRemediationConfigurationsOutput {
	s.RemediationConfigurations = v
	return s
}

type DescribeRemediationExceptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of RemediationExceptionResourceKey returned on each page.
	// The default is 25. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// An exception list of resource exception keys to be processed with the current
	// request. AWS Config adds exception for each resource key. For example, AWS
	// Config adds 3 exceptions for 3 resource keys.
	ResourceKeys []*RemediationExceptionResourceKey `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationExceptionsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DescribeRemediationExceptionsInput) SetConfigRuleName(v string) *DescribeRemediationExceptionsInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeRemediationExceptionsInput) SetLimit(v int64) *DescribeRemediationExceptionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExceptionsInput) SetNextToken(v string) *DescribeRemediationExceptionsInput {
	s.NextToken = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DescribeRemediationExceptionsInput) SetResourceKeys(v []*RemediationExceptionResourceKey) *DescribeRemediationExceptionsInput {
	s.ResourceKeys = v
	return s
}

type DescribeRemediationExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of remediation exception objects.
	RemediationExceptions []*RemediationException `type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationExceptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExceptionsOutput) SetNextToken(v string) *DescribeRemediationExceptionsOutput {
	s.NextToken = &v
	return s
}

// SetRemediationExceptions sets the RemediationExceptions field's value.
func (s *DescribeRemediationExceptionsOutput) SetRemediationExceptions(v []*RemediationException) *DescribeRemediationExceptionsOutput {
	s.RemediationExceptions = v
	return s
}

type DescribeRemediationExecutionStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS Config rule names.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of RemediationExecutionStatuses returned on each page.
	// The default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	ResourceKeys []*ResourceKey `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExecutionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationExecutionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationExecutionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationExecutionStatusInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DescribeRemediationExecutionStatusInput) SetConfigRuleName(v string) *DescribeRemediationExecutionStatusInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeRemediationExecutionStatusInput) SetLimit(v int64) *DescribeRemediationExecutionStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExecutionStatusInput) SetNextToken(v string) *DescribeRemediationExecutionStatusInput {
	s.NextToken = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DescribeRemediationExecutionStatusInput) SetResourceKeys(v []*ResourceKey) *DescribeRemediationExecutionStatusInput {
	s.ResourceKeys = v
	return s
}

type DescribeRemediationExecutionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of remediation execution statuses objects.
	RemediationExecutionStatuses []*RemediationExecutionStatus `type:"list"`
}

// String returns the string representation
func (s DescribeRemediationExecutionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRemediationExecutionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExecutionStatusOutput) SetNextToken(v string) *DescribeRemediationExecutionStatusOutput {
	s.NextToken = &v
	return s
}

// SetRemediationExecutionStatuses sets the RemediationExecutionStatuses field's value.
func (s *DescribeRemediationExecutionStatusOutput) SetRemediationExecutionStatuses(v []*RemediationExecutionStatus) *DescribeRemediationExecutionStatusOutput {
	s.RemediationExecutionStatuses = v
	return s
}

type DescribeRetentionConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of names of retention configurations for which you want details. If
	// you do not specify a name, AWS Config returns details for all the retention
	// configurations for that account.
	//
	// Currently, AWS Config supports only one retention configuration per region
	// in your account.
	RetentionConfigurationNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRetentionConfigurationsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsInput) SetNextToken(v string) *DescribeRetentionConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurationNames sets the RetentionConfigurationNames field's value.
func (s *DescribeRetentionConfigurationsInput) SetRetentionConfigurationNames(v []*string) *DescribeRetentionConfigurationsInput {
	s.RetentionConfigurationNames = v
	return s
}

type DescribeRetentionConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a retention configuration object.
	RetentionConfigurations []*RetentionConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRetentionConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsOutput) SetNextToken(v string) *DescribeRetentionConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurations sets the RetentionConfigurations field's value.
func (s *DescribeRetentionConfigurationsOutput) SetRetentionConfigurations(v []*RetentionConfiguration) *DescribeRetentionConfigurationsOutput {
	s.RetentionConfigurations = v
	return s
}

// Identifies an AWS resource and indicates whether it complies with the AWS
// Config rule that it was evaluated against.
type Evaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// The ID of the AWS resource that was evaluated.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The type of AWS resource that was evaluated.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// it was evaluated against.
	//
	// For the Evaluation data type, AWS Config supports only the COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE values. AWS Config does not support the INSUFFICIENT_DATA
	// value for this data type.
	//
	// Similarly, AWS Config does not accept INSUFFICIENT_DATA as the value for
	// ComplianceType from a PutEvaluations request. For example, an AWS Lambda
	// function for a custom AWS Config rule cannot pass an INSUFFICIENT_DATA value
	// to AWS Config.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ComplianceType"`

	// The time of the event in AWS Config that triggered the evaluation. For event-based
	// evaluations, the time indicates when AWS Config created the configuration
	// item that triggered the evaluation. For periodic evaluations, the time indicates
	// when AWS Config triggered the evaluation at the frequency that you specified
	// (for example, every 24 hours).
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evaluation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Evaluation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Evaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Annotation", 1))
	}
	if s.ComplianceResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.ComplianceResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if s.ComplianceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceType"))
	}
	if s.OrderingTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotation sets the Annotation field's value.
func (s *Evaluation) SetAnnotation(v string) *Evaluation {
	s.Annotation = &v
	return s
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *Evaluation) SetComplianceResourceId(v string) *Evaluation {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceType sets the ComplianceResourceType field's value.
func (s *Evaluation) SetComplianceResourceType(v string) *Evaluation {
	s.ComplianceResourceType = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Evaluation) SetComplianceType(v string) *Evaluation {
	s.ComplianceType = &v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *Evaluation) SetOrderingTimestamp(v time.Time) *Evaluation {
	s.OrderingTimestamp = &v
	return s
}

// The details of an AWS Config evaluation. Provides the AWS resource that was
// evaluated, the compliance of the resource, related time stamps, and supplementary
// information.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// evaluated it.
	//
	// For the EvaluationResult data type, AWS Config supports only the COMPLIANT,
	// NON_COMPLIANT, and NOT_APPLICABLE values. AWS Config does not support the
	// INSUFFICIENT_DATA value for the EvaluationResult data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// The token identifies the rule, the AWS resource being evaluated, and the
	// event that triggered the evaluation.
	ResultToken *string `type:"string"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetAnnotation sets the Annotation field's value.
func (s *EvaluationResult) SetAnnotation(v string) *EvaluationResult {
	s.Annotation = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *EvaluationResult) SetComplianceType(v string) *EvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *EvaluationResult) SetConfigRuleInvokedTime(v time.Time) *EvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *EvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *EvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *EvaluationResult) SetResultRecordedTime(v time.Time) *EvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// SetResultToken sets the ResultToken field's value.
func (s *EvaluationResult) SetResultToken(v string) *EvaluationResult {
	s.ResultToken = &v
	return s
}

// Uniquely identifies an evaluation result.
type EvaluationResultIdentifier struct {
	_ struct{} `type:"structure"`

	// Identifies an AWS Config rule used to evaluate an AWS resource, and provides
	// the type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier `type:"structure"`

	// The time of the event that triggered the evaluation of your AWS resources.
	// The time can indicate when AWS Config delivered a configuration item change
	// notification, or it can indicate when AWS Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EvaluationResultIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResultIdentifier) GoString() string {
	return s.String()
}

// SetEvaluationResultQualifier sets the EvaluationResultQualifier field's value.
func (s *EvaluationResultIdentifier) SetEvaluationResultQualifier(v *EvaluationResultQualifier) *EvaluationResultIdentifier {
	s.EvaluationResultQualifier = v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *EvaluationResultIdentifier) SetOrderingTimestamp(v time.Time) *EvaluationResultIdentifier {
	s.OrderingTimestamp = &v
	return s
}

// Identifies an AWS Config rule that evaluated an AWS resource, and provides
// the type and ID of the resource that the rule evaluated.
type EvaluationResultQualifier struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule that was used in the evaluation.
	ConfigRuleName *string `min:"1" type:"string"`

	// The ID of the evaluated AWS resource.
	ResourceId *string `min:"1" type:"string"`

	// The type of AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EvaluationResultQualifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResultQualifier) GoString() string {
	return s.String()
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *EvaluationResultQualifier) SetConfigRuleName(v string) *EvaluationResultQualifier {
	s.ConfigRuleName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *EvaluationResultQualifier) SetResourceId(v string) *EvaluationResultQualifier {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *EvaluationResultQualifier) SetResourceType(v string) *EvaluationResultQualifier {
	s.ResourceType = &v
	return s
}

// The controls that AWS Config uses for executing remediations.
type ExecutionControls struct {
	_ struct{} `type:"structure"`

	// A SsmControls object.
	SsmControls *SsmControls `type:"structure"`
}

// String returns the string representation
func (s ExecutionControls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionControls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionControls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionControls"}
	if s.SsmControls != nil {
		if err := s.SsmControls.Validate(); err != nil {
			invalidParams.AddNested("SsmControls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSsmControls sets the SsmControls field's value.
func (s *ExecutionControls) SetSsmControls(v *SsmControls) *ExecutionControls {
	s.SsmControls = v
	return s
}

// Identifies an AWS resource and indicates whether it complies with the AWS
// Config rule that it was evaluated against.
type ExternalEvaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about the reason of compliance. For example, this
	// task was completed on a specific date.
	Annotation *string `min:"1" type:"string"`

	// The evaluated compliance resource ID. AWS Config accepts only AWS account
	// ID.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The evaluated compliance resource type. AWS Config accepts AWS::::Account
	// resource type.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// The compliance of the AWS resource. The valid values are COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ComplianceType"`

	// The time when the compliance was recorded.
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ExternalEvaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalEvaluation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalEvaluation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalEvaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Annotation", 1))
	}
	if s.ComplianceResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.ComplianceResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if s.ComplianceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceType"))
	}
	if s.OrderingTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotation sets the Annotation field's value.
func (s *ExternalEvaluation) SetAnnotation(v string) *ExternalEvaluation {
	s.Annotation = &v
	return s
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *ExternalEvaluation) SetComplianceResourceId(v string) *ExternalEvaluation {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceType sets the ComplianceResourceType field's value.
func (s *ExternalEvaluation) SetComplianceResourceType(v string) *ExternalEvaluation {
	s.ComplianceResourceType = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ExternalEvaluation) SetComplianceType(v string) *ExternalEvaluation {
	s.ComplianceType = &v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *ExternalEvaluation) SetOrderingTimestamp(v time.Time) *ExternalEvaluation {
	s.OrderingTimestamp = &v
	return s
}

// List of each of the failed delete remediation exceptions with specific reasons.
type FailedDeleteRemediationExceptionsBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation exception resource key object of the failed items.
	FailedItems []*RemediationExceptionResourceKey `min:"1" type:"list"`

	// Returns a failure message for delete remediation exception. For example,
	// AWS Config creates an exception due to an internal error.
	FailureMessage *string `type:"string"`
}

// String returns the string representation
func (s FailedDeleteRemediationExceptionsBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedDeleteRemediationExceptionsBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedDeleteRemediationExceptionsBatch) SetFailedItems(v []*RemediationExceptionResourceKey) *FailedDeleteRemediationExceptionsBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedDeleteRemediationExceptionsBatch) SetFailureMessage(v string) *FailedDeleteRemediationExceptionsBatch {
	s.FailureMessage = &v
	return s
}

// List of each of the failed remediations with specific reasons.
type FailedRemediationBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation configurations of the failed items.
	FailedItems []*RemediationConfiguration `type:"list"`

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string `type:"string"`
}

// String returns the string representation
func (s FailedRemediationBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedRemediationBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedRemediationBatch) SetFailedItems(v []*RemediationConfiguration) *FailedRemediationBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedRemediationBatch) SetFailureMessage(v string) *FailedRemediationBatch {
	s.FailureMessage = &v
	return s
}

// List of each of the failed remediation exceptions with specific reasons.
type FailedRemediationExceptionBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation exception resource key object of the failed items.
	FailedItems []*RemediationException `type:"list"`

	// Returns a failure message. For example, the auto-remediation has failed.
	FailureMessage *string `type:"string"`
}

// String returns the string representation
func (s FailedRemediationExceptionBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedRemediationExceptionBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedRemediationExceptionBatch) SetFailedItems(v []*RemediationException) *FailedRemediationExceptionBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedRemediationExceptionBatch) SetFailureMessage(v string) *FailedRemediationExceptionBatch {
	s.FailureMessage = &v
	return s
}

// Details about the fields such as name of the field.
type FieldInfo struct {
	_ struct{} `type:"structure"`

	// Name of the field.
	Name *string `type:"string"`
}

// String returns the string representation
func (s FieldInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FieldInfo) SetName(v string) *FieldInfo {
	s.Name = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The source region from where the data is aggregated.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The resource compliance status.
	//
	// For the GetAggregateComplianceDetailsByConfigRuleRequest data type, AWS Config
	// supports only the COMPLIANT and NON_COMPLIANT. AWS Config does not support
	// the NOT_APPLICABLE and INSUFFICIENT_DATA values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the AWS Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 50. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateComplianceDetailsByConfigRuleInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAccountId(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAwsRegion(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetComplianceType(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigurationAggregatorName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregateEvaluationResults object.
	AggregateEvaluationResults []*AggregateEvaluationResult `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetAggregateEvaluationResults sets the AggregateEvaluationResults field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetAggregateEvaluationResults(v []*AggregateEvaluationResult) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.AggregateEvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ConfigRuleComplianceSummaryFilters object.
	Filters *ConfigRuleComplianceSummaryFilters `type:"structure"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `type:"string" enum:"ConfigRuleComplianceSummaryGroupKey"`

	// The maximum number of evaluation results returned on each page. The default
	// is 1000. You cannot specify a number greater than 1000. If you specify 0,
	// AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConfigRuleComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateConfigRuleComplianceSummaryInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetConfigurationAggregatorName(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetFilters(v *ConfigRuleComplianceSummaryFilters) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetLimit(v int64) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceCounts object.
	AggregateComplianceCounts []*AggregateComplianceCount `type:"list"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceCounts sets the AggregateComplianceCounts field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetAggregateComplianceCounts(v []*AggregateComplianceCount) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.AggregateComplianceCounts = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.GroupByKey = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetAggregateConformancePackComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the AggregateConformancePackComplianceSummaryFilters
	// object.
	Filters *AggregateConformancePackComplianceSummaryFilters `type:"structure"`

	// Groups the result based on AWS Account ID or AWS Region.
	GroupByKey *string `type:"string" enum:"AggregateConformancePackComplianceSummaryGroupKey"`

	// The maximum number of results returned on each page. The default is maximum.
	// If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConformancePackComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConformancePackComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConformancePackComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateConformancePackComplianceSummaryInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetConfigurationAggregatorName(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetFilters(v *AggregateConformancePackComplianceSummaryFilters) *GetAggregateConformancePackComplianceSummaryInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetGroupByKey(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetLimit(v int64) *GetAggregateConformancePackComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetNextToken(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetAggregateConformancePackComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateConformancePackComplianceSummary object.
	AggregateConformancePackComplianceSummaries []*AggregateConformancePackComplianceSummary `type:"list"`

	// Groups the result based on AWS Account ID or AWS Region.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConformancePackComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConformancePackComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetAggregateConformancePackComplianceSummaries sets the AggregateConformancePackComplianceSummaries field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetAggregateConformancePackComplianceSummaries(v []*AggregateConformancePackComplianceSummary) *GetAggregateConformancePackComplianceSummaryOutput {
	s.AggregateConformancePackComplianceSummaries = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetGroupByKey(v string) *GetAggregateConformancePackComplianceSummaryOutput {
	s.GroupByKey = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetNextToken(v string) *GetAggregateConformancePackComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetAggregateDiscoveredResourceCountsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ResourceCountFilters object.
	Filters *ResourceCountFilters `type:"structure"`

	// The key to group the resource counts.
	GroupByKey *string `type:"string" enum:"ResourceCountGroupKey"`

	// The maximum number of GroupedResourceCount objects returned on each page.
	// The default is 1000. You cannot specify a number greater than 1000. If you
	// specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateDiscoveredResourceCountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateDiscoveredResourceCountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateDiscoveredResourceCountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateDiscoveredResourceCountsInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetConfigurationAggregatorName(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetFilters(v *ResourceCountFilters) *GetAggregateDiscoveredResourceCountsInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetGroupByKey(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetLimit(v int64) *GetAggregateDiscoveredResourceCountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetNextToken(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.NextToken = &v
	return s
}

type GetAggregateDiscoveredResourceCountsOutput struct {
	_ struct{} `type:"structure"`

	// The key passed into the request object. If GroupByKey is not provided, the
	// result will be empty.
	GroupByKey *string `min:"1" type:"string"`

	// Returns a list of GroupedResourceCount objects.
	GroupedResourceCounts []*GroupedResourceCount `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The total number of resources that are present in an aggregator with the
	// filters that you provide.
	//
	// TotalDiscoveredResources is a required field
	TotalDiscoveredResources *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetAggregateDiscoveredResourceCountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateDiscoveredResourceCountsOutput) GoString() string {
	return s.String()
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetGroupByKey(v string) *GetAggregateDiscoveredResourceCountsOutput {
	s.GroupByKey = &v
	return s
}

// SetGroupedResourceCounts sets the GroupedResourceCounts field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetGroupedResourceCounts(v []*GroupedResourceCount) *GetAggregateDiscoveredResourceCountsOutput {
	s.GroupedResourceCounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetNextToken(v string) *GetAggregateDiscoveredResourceCountsOutput {
	s.NextToken = &v
	return s
}

// SetTotalDiscoveredResources sets the TotalDiscoveredResources field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetTotalDiscoveredResources(v int64) *GetAggregateDiscoveredResourceCountsOutput {
	s.TotalDiscoveredResources = &v
	return s
}

type GetAggregateResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// An object that identifies aggregate resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *AggregateResourceIdentifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAggregateResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateResourceConfigInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil {
		if err := s.ResourceIdentifier.Validate(); err != nil {
			invalidParams.AddNested("ResourceIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateResourceConfigInput) SetConfigurationAggregatorName(v string) *GetAggregateResourceConfigInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetAggregateResourceConfigInput) SetResourceIdentifier(v *AggregateResourceIdentifier) *GetAggregateResourceConfigInput {
	s.ResourceIdentifier = v
	return s
}

type GetAggregateResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationItem object.
	ConfigurationItem *ConfigurationItem `type:"structure"`
}

// String returns the string representation
func (s GetAggregateResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateResourceConfigOutput) GoString() string {
	return s.String()
}

// SetConfigurationItem sets the ConfigurationItem field's value.
func (s *GetAggregateResourceConfigOutput) SetConfigurationItem(v *ConfigurationItem) *GetAggregateResourceConfigOutput {
	s.ConfigurationItem = v
	return s
}

type GetComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list"`

	// The name of the AWS Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS resource complies with the specified AWS Config
	// rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByConfigRuleOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the AWS resource for which you want compliance information.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByResourceInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceInput) SetNextToken(v string) *GetComplianceDetailsByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceId(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceType(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceType = &v
	return s
}

type GetComplianceDetailsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies each AWS Config rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByResourceOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByResourceOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByResourceOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceOutput) SetNextToken(v string) *GetComplianceDetailsByResourceOutput {
	s.NextToken = &v
	return s
}

type GetComplianceSummaryByConfigRuleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetComplianceSummaryByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByConfigRuleInput) GoString() string {
	return s.String()
}

type GetComplianceSummaryByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// The number of AWS Config rules that are compliant and the number that are
	// noncompliant, up to a maximum of 25 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`
}

// String returns the string representation
func (s GetComplianceSummaryByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *GetComplianceSummaryByConfigRuleOutput) SetComplianceSummary(v *ComplianceSummary) *GetComplianceSummaryByConfigRuleOutput {
	s.ComplianceSummary = v
	return s
}

type GetComplianceSummaryByResourceTypeInput struct {
	_ struct{} `type:"structure"`

	// Specify one or more resource types to get the number of resources that are
	// compliant and the number that are noncompliant for each resource type.
	//
	// For this request, you can specify an AWS resource type such as AWS::EC2::Instance.
	// You can specify that the resource type is an AWS account by specifying AWS::::Account.
	ResourceTypes []*string `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByResourceTypeInput) GoString() string {
	return s.String()
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetComplianceSummaryByResourceTypeInput) SetResourceTypes(v []*string) *GetComplianceSummaryByResourceTypeInput {
	s.ResourceTypes = v
	return s
}

type GetComplianceSummaryByResourceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The number of resources that are compliant and the number that are noncompliant.
	// If one or more resource types were provided with the request, the numbers
	// are returned for each resource type. The maximum number returned is 100.
	ComplianceSummariesByResourceType []*ComplianceSummaryByResourceType `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByResourceTypeOutput) GoString() string {
	return s.String()
}

// SetComplianceSummariesByResourceType sets the ComplianceSummariesByResourceType field's value.
func (s *GetComplianceSummaryByResourceTypeOutput) SetComplianceSummariesByResourceType(v []*ComplianceSummaryByResourceType) *GetComplianceSummaryByResourceTypeOutput {
	s.ComplianceSummariesByResourceType = v
	return s
}

type GetConformancePackComplianceDetailsInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackEvaluationFilters object.
	Filters *ConformancePackEvaluationFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. If you do
	// no specify a number, AWS Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConformancePackComplianceDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConformancePackComplianceDetailsInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *GetConformancePackComplianceDetailsInput) SetConformancePackName(v string) *GetConformancePackComplianceDetailsInput {
	s.ConformancePackName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetConformancePackComplianceDetailsInput) SetFilters(v *ConformancePackEvaluationFilters) *GetConformancePackComplianceDetailsInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetConformancePackComplianceDetailsInput) SetLimit(v int64) *GetConformancePackComplianceDetailsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceDetailsInput) SetNextToken(v string) *GetConformancePackComplianceDetailsInput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackEvaluationResult objects.
	ConformancePackRuleEvaluationResults []*ConformancePackEvaluationResult `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConformancePackComplianceDetailsOutput) GoString() string {
	return s.String()
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetConformancePackName(v string) *GetConformancePackComplianceDetailsOutput {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackRuleEvaluationResults sets the ConformancePackRuleEvaluationResults field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetConformancePackRuleEvaluationResults(v []*ConformancePackEvaluationResult) *GetConformancePackComplianceDetailsOutput {
	s.ConformancePackRuleEvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetNextToken(v string) *GetConformancePackComplianceDetailsOutput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// Names of conformance packs.
	//
	// ConformancePackNames is a required field
	ConformancePackNames []*string `min:"1" type:"list" required:"true"`

	// The maximum number of conformance packs returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConformancePackComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConformancePackComplianceSummaryInput"}
	if s.ConformancePackNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackNames"))
	}
	if s.ConformancePackNames != nil && len(s.ConformancePackNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *GetConformancePackComplianceSummaryInput) SetConformancePackNames(v []*string) *GetConformancePackComplianceSummaryInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetConformancePackComplianceSummaryInput) SetLimit(v int64) *GetConformancePackComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceSummaryInput) SetNextToken(v string) *GetConformancePackComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackComplianceSummary objects.
	ConformancePackComplianceSummaryList []*ConformancePackComplianceSummary `min:"1" type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConformancePackComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetConformancePackComplianceSummaryList sets the ConformancePackComplianceSummaryList field's value.
func (s *GetConformancePackComplianceSummaryOutput) SetConformancePackComplianceSummaryList(v []*ConformancePackComplianceSummary) *GetConformancePackComplianceSummaryOutput {
	s.ConformancePackComplianceSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceSummaryOutput) SetNextToken(v string) *GetConformancePackComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetDiscoveredResourceCountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of ResourceCount objects returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The comma-separated list that specifies the resource types that you want
	// AWS Config to return (for example, "AWS::EC2::Instance", "AWS::IAM::User").
	//
	// If a value for resourceTypes is not specified, AWS Config returns all resource
	// types that AWS Config is recording in the region for your account.
	//
	// If the configuration recorder is turned off, AWS Config returns an empty
	// list of ResourceCount objects. If the configuration recorder is not recording
	// a specific resource type (for example, S3 buckets), that resource type is
	// not returned in the list of ResourceCount objects.
	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s GetDiscoveredResourceCountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoveredResourceCountsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetDiscoveredResourceCountsInput) SetLimit(v int64) *GetDiscoveredResourceCountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsInput) SetNextToken(v string) *GetDiscoveredResourceCountsInput {
	s.NextToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetDiscoveredResourceCountsInput) SetResourceTypes(v []*string) *GetDiscoveredResourceCountsInput {
	s.ResourceTypes = v
	return s
}

type GetDiscoveredResourceCountsOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ResourceCount objects. Each object is listed in descending order
	// by the number of resources.
	ResourceCounts []*ResourceCount `locationName:"resourceCounts" type:"list"`

	// The total number of resources that AWS Config is recording in the region
	// for your account. If you specify resource types in the request, AWS Config
	// returns only the total number of resources for those resource types.
	//
	// Example
	//
	// AWS Config is recording three resource types in the US East (Ohio) Region
	// for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for
	// a total of 60 resources.
	//
	// You make a call to the GetDiscoveredResourceCounts action and specify the
	// resource type, "AWS::EC2::Instances", in the request.
	//
	// AWS Config returns 25 for totalDiscoveredResources.
	TotalDiscoveredResources *int64 `locationName:"totalDiscoveredResources" type:"long"`
}

// String returns the string representation
func (s GetDiscoveredResourceCountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoveredResourceCountsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsOutput) SetNextToken(v string) *GetDiscoveredResourceCountsOutput {
	s.NextToken = &v
	return s
}

// SetResourceCounts sets the ResourceCounts field's value.
func (s *GetDiscoveredResourceCountsOutput) SetResourceCounts(v []*ResourceCount) *GetDiscoveredResourceCountsOutput {
	s.ResourceCounts = v
	return s
}

// SetTotalDiscoveredResources sets the TotalDiscoveredResources field's value.
func (s *GetDiscoveredResourceCountsOutput) SetTotalDiscoveredResources(v int64) *GetDiscoveredResourceCountsOutput {
	s.TotalDiscoveredResources = &v
	return s
}

type GetOrganizationConfigRuleDetailedStatusInput struct {
	_ struct{} `type:"structure"`

	// A StatusDetailFilters object.
	Filters *StatusDetailFilters `type:"structure"`

	// The maximum number of OrganizationConfigRuleDetailedStatus returned on each
	// page. If you do not specify a number, AWS Config uses the default. The default
	// is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name of organization config rule for which you want status details for
	// member accounts.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOrganizationConfigRuleDetailedStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationConfigRuleDetailedStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationConfigRuleDetailedStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationConfigRuleDetailedStatusInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetFilters(v *StatusDetailFilters) *GetOrganizationConfigRuleDetailedStatusInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetLimit(v int64) *GetOrganizationConfigRuleDetailedStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetNextToken(v string) *GetOrganizationConfigRuleDetailedStatusInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetOrganizationConfigRuleName(v string) *GetOrganizationConfigRuleDetailedStatusInput {
	s.OrganizationConfigRuleName = &v
	return s
}

type GetOrganizationConfigRuleDetailedStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of MemberAccountStatus objects.
	OrganizationConfigRuleDetailedStatus []*MemberAccountStatus `type:"list"`
}

// String returns the string representation
func (s GetOrganizationConfigRuleDetailedStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationConfigRuleDetailedStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConfigRuleDetailedStatusOutput) SetNextToken(v string) *GetOrganizationConfigRuleDetailedStatusOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleDetailedStatus sets the OrganizationConfigRuleDetailedStatus field's value.
func (s *GetOrganizationConfigRuleDetailedStatusOutput) SetOrganizationConfigRuleDetailedStatus(v []*MemberAccountStatus) *GetOrganizationConfigRuleDetailedStatusOutput {
	s.OrganizationConfigRuleDetailedStatus = v
	return s
}

type GetOrganizationConformancePackDetailedStatusInput struct {
	_ struct{} `type:"structure"`

	// An OrganizationResourceDetailedStatusFilters object.
	Filters *OrganizationResourceDetailedStatusFilters `type:"structure"`

	// The maximum number of OrganizationConformancePackDetailedStatuses returned
	// on each page. If you do not specify a number, AWS Config uses the default.
	// The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name of organization conformance pack for which you want status details
	// for member accounts.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOrganizationConformancePackDetailedStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationConformancePackDetailedStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationConformancePackDetailedStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationConformancePackDetailedStatusInput"}
	if s.OrganizationConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConformancePackName"))
	}
	if s.OrganizationConformancePackName != nil && len(*s.OrganizationConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetFilters(v *OrganizationResourceDetailedStatusFilters) *GetOrganizationConformancePackDetailedStatusInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetLimit(v int64) *GetOrganizationConformancePackDetailedStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetNextToken(v string) *GetOrganizationConformancePackDetailedStatusInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetOrganizationConformancePackName(v string) *GetOrganizationConformancePackDetailedStatusInput {
	s.OrganizationConformancePackName = &v
	return s
}

type GetOrganizationConformancePackDetailedStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConformancePackDetailedStatus objects.
	OrganizationConformancePackDetailedStatuses []*OrganizationConformancePackDetailedStatus `type:"list"`
}

// String returns the string representation
func (s GetOrganizationConformancePackDetailedStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOrganizationConformancePackDetailedStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConformancePackDetailedStatusOutput) SetNextToken(v string) *GetOrganizationConformancePackDetailedStatusOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackDetailedStatuses sets the OrganizationConformancePackDetailedStatuses field's value.
func (s *GetOrganizationConformancePackDetailedStatusOutput) SetOrganizationConformancePackDetailedStatuses(v []*OrganizationConformancePackDetailedStatus) *GetOrganizationConformancePackDetailedStatusOutput {
	s.OrganizationConformancePackDetailedStatuses = v
	return s
}

// The input for the GetResourceConfigHistory action.
type GetResourceConfigHistoryInput struct {
	_ struct{} `type:"structure"`

	// The chronological order for configuration items listed. By default, the results
	// are listed in reverse chronological order.
	ChronologicalOrder *string `locationName:"chronologicalOrder" type:"string" enum:"ChronologicalOrder"`

	// The time stamp that indicates an earlier time. If not specified, the action
	// returns paginated results that contain configuration items that start when
	// the first configuration item was recorded.
	EarlierTime *time.Time `locationName:"earlierTime" type:"timestamp"`

	// The time stamp that indicates a later time. If not specified, current time
	// is taken.
	LaterTime *time.Time `locationName:"laterTime" type:"timestamp"`

	// The maximum number of configuration items returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s GetResourceConfigHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceConfigHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceConfigHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceConfigHistoryInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChronologicalOrder sets the ChronologicalOrder field's value.
func (s *GetResourceConfigHistoryInput) SetChronologicalOrder(v string) *GetResourceConfigHistoryInput {
	s.ChronologicalOrder = &v
	return s
}

// SetEarlierTime sets the EarlierTime field's value.
func (s *GetResourceConfigHistoryInput) SetEarlierTime(v time.Time) *GetResourceConfigHistoryInput {
	s.EarlierTime = &v
	return s
}

// SetLaterTime sets the LaterTime field's value.
func (s *GetResourceConfigHistoryInput) SetLaterTime(v time.Time) *GetResourceConfigHistoryInput {
	s.LaterTime = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetResourceConfigHistoryInput) SetLimit(v int64) *GetResourceConfigHistoryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryInput) SetNextToken(v string) *GetResourceConfigHistoryInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResourceConfigHistoryInput) SetResourceId(v string) *GetResourceConfigHistoryInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetResourceConfigHistoryInput) SetResourceType(v string) *GetResourceConfigHistoryInput {
	s.ResourceType = &v
	return s
}

// The output for the GetResourceConfigHistory action.
type GetResourceConfigHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the configuration history of one or more resources.
	ConfigurationItems []*ConfigurationItem `locationName:"configurationItems" type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetResourceConfigHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceConfigHistoryOutput) GoString() string {
	return s.String()
}

// SetConfigurationItems sets the ConfigurationItems field's value.
func (s *GetResourceConfigHistoryOutput) SetConfigurationItems(v []*ConfigurationItem) *GetResourceConfigHistoryOutput {
	s.ConfigurationItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryOutput) SetNextToken(v string) *GetResourceConfigHistoryOutput {
	s.NextToken = &v
	return s
}

type GetStoredQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the query.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStoredQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStoredQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStoredQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStoredQueryInput"}
	if s.QueryName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryName"))
	}
	if s.QueryName != nil && len(*s.QueryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryName sets the QueryName field's value.
func (s *GetStoredQueryInput) SetQueryName(v string) *GetStoredQueryInput {
	s.QueryName = &v
	return s
}

type GetStoredQueryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a StoredQuery object.
	StoredQuery *StoredQuery `type:"structure"`
}

// String returns the string representation
func (s GetStoredQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStoredQueryOutput) GoString() string {
	return s.String()
}

// SetStoredQuery sets the StoredQuery field's value.
func (s *GetStoredQueryOutput) SetStoredQuery(v *StoredQuery) *GetStoredQueryOutput {
	s.StoredQuery = v
	return s
}

// The count of resources that are grouped by the group name.
type GroupedResourceCount struct {
	_ struct{} `type:"structure"`

	// The name of the group that can be region, account ID, or resource type. For
	// example, region1, region2 if the region was chosen as GroupByKey.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The number of resources in the group.
	//
	// ResourceCount is a required field
	ResourceCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GroupedResourceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupedResourceCount) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GroupedResourceCount) SetGroupName(v string) *GroupedResourceCount {
	s.GroupName = &v
	return s
}

// SetResourceCount sets the ResourceCount field's value.
func (s *GroupedResourceCount) SetResourceCount(v int64) *GroupedResourceCount {
	s.ResourceCount = &v
	return s
}

// Your Amazon S3 bucket policy does not permit AWS Config to write to it.
type InsufficientDeliveryPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InsufficientDeliveryPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsufficientDeliveryPolicyException) GoString() string {
	return s.String()
}

func newErrorInsufficientDeliveryPolicyException(v protocol.ResponseMetadata) error {
	return &InsufficientDeliveryPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientDeliveryPolicyException) Code() string {
	return "InsufficientDeliveryPolicyException"
}

// Message returns the exception's message.
func (s *InsufficientDeliveryPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientDeliveryPolicyException) OrigErr() error {
	return nil
}

func (s *InsufficientDeliveryPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientDeliveryPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientDeliveryPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates one of the following errors:
//
//    * For PutConfigRule, the rule cannot be created because the IAM role assigned
//    to AWS Config lacks permissions to perform the config:Put* action.
//
//    * For PutConfigRule, the AWS Lambda function cannot be invoked. Check
//    the function ARN, and check the function's permissions.
//
//    * For PutOrganizationConfigRule, organization config rule cannot be created
//    because you do not have permissions to call IAM GetRole action or create
//    a service linked role.
//
//    * For PutConformancePack and PutOrganizationConformancePack, a conformance
//    pack cannot be created because you do not have permissions: To call IAM
//    GetRole action or create a service linked role. To read Amazon S3 bucket.
type InsufficientPermissionsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InsufficientPermissionsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsufficientPermissionsException) GoString() string {
	return s.String()
}

func newErrorInsufficientPermissionsException(v protocol.ResponseMetadata) error {
	return &InsufficientPermissionsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientPermissionsException) Code() string {
	return "InsufficientPermissionsException"
}

// Message returns the exception's message.
func (s *InsufficientPermissionsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientPermissionsException) OrigErr() error {
	return nil
}

func (s *InsufficientPermissionsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientPermissionsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientPermissionsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have provided a configuration recorder name that is not valid.
type InvalidConfigurationRecorderNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidConfigurationRecorderNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidConfigurationRecorderNameException) GoString() string {
	return s.String()
}

func newErrorInvalidConfigurationRecorderNameException(v protocol.ResponseMetadata) error {
	return &InvalidConfigurationRecorderNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidConfigurationRecorderNameException) Code() string {
	return "InvalidConfigurationRecorderNameException"
}

// Message returns the exception's message.
func (s *InvalidConfigurationRecorderNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidConfigurationRecorderNameException) OrigErr() error {
	return nil
}

func (s *InvalidConfigurationRecorderNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidConfigurationRecorderNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidConfigurationRecorderNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified delivery channel name is not valid.
type InvalidDeliveryChannelNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidDeliveryChannelNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidDeliveryChannelNameException) GoString() string {
	return s.String()
}

func newErrorInvalidDeliveryChannelNameException(v protocol.ResponseMetadata) error {
	return &InvalidDeliveryChannelNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidDeliveryChannelNameException) Code() string {
	return "InvalidDeliveryChannelNameException"
}

// Message returns the exception's message.
func (s *InvalidDeliveryChannelNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidDeliveryChannelNameException) OrigErr() error {
	return nil
}

func (s *InvalidDeliveryChannelNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidDeliveryChannelNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidDeliveryChannelNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The syntax of the query is incorrect.
type InvalidExpressionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidExpressionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidExpressionException) GoString() string {
	return s.String()
}

func newErrorInvalidExpressionException(v protocol.ResponseMetadata) error {
	return &InvalidExpressionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidExpressionException) Code() string {
	return "InvalidExpressionException"
}

// Message returns the exception's message.
func (s *InvalidExpressionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidExpressionException) OrigErr() error {
	return nil
}

func (s *InvalidExpressionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidExpressionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidExpressionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified limit is outside the allowable range.
type InvalidLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidLimitException) GoString() string {
	return s.String()
}

func newErrorInvalidLimitException(v protocol.ResponseMetadata) error {
	return &InvalidLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLimitException) Code() string {
	return "InvalidLimitException"
}

// Message returns the exception's message.
func (s *InvalidLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLimitException) OrigErr() error {
	return nil
}

func (s *InvalidLimitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified next token is invalid. Specify the nextToken string that was
// returned in the previous response to get the next page of results.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more of the specified parameters are invalid. Verify that your parameters
// are valid and try again.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Config throws an exception if the recording group does not contain a
// valid list of resource types. Invalid values might also be incorrectly formatted.
type InvalidRecordingGroupException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRecordingGroupException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRecordingGroupException) GoString() string {
	return s.String()
}

func newErrorInvalidRecordingGroupException(v protocol.ResponseMetadata) error {
	return &InvalidRecordingGroupException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRecordingGroupException) Code() string {
	return "InvalidRecordingGroupException"
}

// Message returns the exception's message.
func (s *InvalidRecordingGroupException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRecordingGroupException) OrigErr() error {
	return nil
}

func (s *InvalidRecordingGroupException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRecordingGroupException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRecordingGroupException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified ResultToken is invalid.
type InvalidResultTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidResultTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResultTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidResultTokenException(v protocol.ResponseMetadata) error {
	return &InvalidResultTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResultTokenException) Code() string {
	return "InvalidResultTokenException"
}

// Message returns the exception's message.
func (s *InvalidResultTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResultTokenException) OrigErr() error {
	return nil
}

func (s *InvalidResultTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResultTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResultTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have provided a null or empty role ARN.
type InvalidRoleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRoleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRoleException) GoString() string {
	return s.String()
}

func newErrorInvalidRoleException(v protocol.ResponseMetadata) error {
	return &InvalidRoleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRoleException) Code() string {
	return "InvalidRoleException"
}

// Message returns the exception's message.
func (s *InvalidRoleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRoleException) OrigErr() error {
	return nil
}

func (s *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRoleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRoleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon S3 key prefix is not valid.
type InvalidS3KeyPrefixException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidS3KeyPrefixException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidS3KeyPrefixException) GoString() string {
	return s.String()
}

func newErrorInvalidS3KeyPrefixException(v protocol.ResponseMetadata) error {
	return &InvalidS3KeyPrefixException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3KeyPrefixException) Code() string {
	return "InvalidS3KeyPrefixException"
}

// Message returns the exception's message.
func (s *InvalidS3KeyPrefixException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3KeyPrefixException) OrigErr() error {
	return nil
}

func (s *InvalidS3KeyPrefixException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3KeyPrefixException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3KeyPrefixException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon KMS Key ARN is not valid.
type InvalidS3KmsKeyArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidS3KmsKeyArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidS3KmsKeyArnException) GoString() string {
	return s.String()
}

func newErrorInvalidS3KmsKeyArnException(v protocol.ResponseMetadata) error {
	return &InvalidS3KmsKeyArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3KmsKeyArnException) Code() string {
	return "InvalidS3KmsKeyArnException"
}

// Message returns the exception's message.
func (s *InvalidS3KmsKeyArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3KmsKeyArnException) OrigErr() error {
	return nil
}

func (s *InvalidS3KmsKeyArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3KmsKeyArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3KmsKeyArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon SNS topic does not exist.
type InvalidSNSTopicARNException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidSNSTopicARNException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSNSTopicARNException) GoString() string {
	return s.String()
}

func newErrorInvalidSNSTopicARNException(v protocol.ResponseMetadata) error {
	return &InvalidSNSTopicARNException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSNSTopicARNException) Code() string {
	return "InvalidSNSTopicARNException"
}

// Message returns the exception's message.
func (s *InvalidSNSTopicARNException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSNSTopicARNException) OrigErr() error {
	return nil
}

func (s *InvalidSNSTopicARNException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSNSTopicARNException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSNSTopicARNException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified time range is not valid. The earlier time is not chronologically
// before the later time.
type InvalidTimeRangeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidTimeRangeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTimeRangeException) GoString() string {
	return s.String()
}

func newErrorInvalidTimeRangeException(v protocol.ResponseMetadata) error {
	return &InvalidTimeRangeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTimeRangeException) Code() string {
	return "InvalidTimeRangeException"
}

// Message returns the exception's message.
func (s *InvalidTimeRangeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTimeRangeException) OrigErr() error {
	return nil
}

func (s *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTimeRangeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTimeRangeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You cannot delete the delivery channel you specified because the configuration
// recorder is running.
type LastDeliveryChannelDeleteFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LastDeliveryChannelDeleteFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LastDeliveryChannelDeleteFailedException) GoString() string {
	return s.String()
}

func newErrorLastDeliveryChannelDeleteFailedException(v protocol.ResponseMetadata) error {
	return &LastDeliveryChannelDeleteFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LastDeliveryChannelDeleteFailedException) Code() string {
	return "LastDeliveryChannelDeleteFailedException"
}

// Message returns the exception's message.
func (s *LastDeliveryChannelDeleteFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LastDeliveryChannelDeleteFailedException) OrigErr() error {
	return nil
}

func (s *LastDeliveryChannelDeleteFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LastDeliveryChannelDeleteFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LastDeliveryChannelDeleteFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
// is in progress or if you call the StartConfigRulesEvaluation API more than
// once per minute.
//
// For PutConfigurationAggregator API, this exception is thrown if the number
// of accounts and aggregators exceeds the limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAggregateDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ResourceFilters object.
	Filters *ResourceFilters `type:"structure"`

	// The maximum number of resource identifiers returned on each page. You cannot
	// specify a number greater than 100. If you specify 0, AWS Config uses the
	// default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The type of resources that you want AWS Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s ListAggregateDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAggregateDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAggregateDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAggregateDiscoveredResourcesInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetConfigurationAggregatorName(v string) *ListAggregateDiscoveredResourcesInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetFilters(v *ResourceFilters) *ListAggregateDiscoveredResourcesInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetLimit(v int64) *ListAggregateDiscoveredResourcesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetNextToken(v string) *ListAggregateDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetResourceType(v string) *ListAggregateDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListAggregateDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of ResourceIdentifiers objects.
	ResourceIdentifiers []*AggregateResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s ListAggregateDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAggregateDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregateDiscoveredResourcesOutput) SetNextToken(v string) *ListAggregateDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListAggregateDiscoveredResourcesOutput) SetResourceIdentifiers(v []*AggregateResourceIdentifier) *ListAggregateDiscoveredResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether AWS Config includes deleted resources in the results. By
	// default, deleted resources are not included.
	IncludeDeletedResources *bool `locationName:"includeDeletedResources" type:"boolean"`

	// The maximum number of resource identifiers returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of only those resources that you want AWS Config to list in the response.
	// If you do not specify this parameter, AWS Config lists all resources of the
	// specified type that it has discovered.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`

	// The custom name of only those resources that you want AWS Config to list
	// in the response. If you do not specify this parameter, AWS Config lists all
	// resources of the specified type that it has discovered.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resources that you want AWS Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s ListDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveredResourcesInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeletedResources sets the IncludeDeletedResources field's value.
func (s *ListDiscoveredResourcesInput) SetIncludeDeletedResources(v bool) *ListDiscoveredResourcesInput {
	s.IncludeDeletedResources = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDiscoveredResourcesInput) SetLimit(v int64) *ListDiscoveredResourcesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesInput) SetNextToken(v string) *ListDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListDiscoveredResourcesInput) SetResourceIds(v []*string) *ListDiscoveredResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListDiscoveredResourcesInput) SetResourceName(v string) *ListDiscoveredResourcesInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListDiscoveredResourcesInput) SetResourceType(v string) *ListDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details that identify a resource that is discovered by AWS Config, including
	// the resource type, ID, and (if available) the custom resource name.
	ResourceIdentifiers []*ResourceIdentifier `locationName:"resourceIdentifiers" type:"list"`
}

// String returns the string representation
func (s ListDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesOutput) SetNextToken(v string) *ListDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListDiscoveredResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *ListDiscoveredResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListStoredQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call.
	MaxResults *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListStoredQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStoredQueriesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStoredQueriesInput) SetMaxResults(v int64) *ListStoredQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStoredQueriesInput) SetNextToken(v string) *ListStoredQueriesInput {
	s.NextToken = &v
	return s
}

type ListStoredQueriesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `type:"string"`

	// A list of StoredQueryMetadata objects.
	StoredQueryMetadata []*StoredQueryMetadata `type:"list"`
}

// String returns the string representation
func (s ListStoredQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStoredQueriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStoredQueriesOutput) SetNextToken(v string) *ListStoredQueriesOutput {
	s.NextToken = &v
	return s
}

// SetStoredQueryMetadata sets the StoredQueryMetadata field's value.
func (s *ListStoredQueriesOutput) SetStoredQueryMetadata(v []*StoredQueryMetadata) *ListStoredQueriesOutput {
	s.StoredQueryMetadata = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags returned on each page. The limit maximum is 50.
	// You cannot specify a number greater than 50. If you specify 0, AWS Config
	// uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
	// and AggregatorAuthorization.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The tags for the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// You have reached the limit (100,000) of active custom resource types in your
// account. Delete unused resources using DeleteResourceConfig.
type MaxActiveResourcesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxActiveResourcesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxActiveResourcesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxActiveResourcesExceededException(v protocol.ResponseMetadata) error {
	return &MaxActiveResourcesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxActiveResourcesExceededException) Code() string {
	return "MaxActiveResourcesExceededException"
}

// Message returns the exception's message.
func (s *MaxActiveResourcesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxActiveResourcesExceededException) OrigErr() error {
	return nil
}

func (s *MaxActiveResourcesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxActiveResourcesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxActiveResourcesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Failed to add the AWS Config rule because the account already contains the
// maximum number of 150 rules. Consider deleting any deactivated rules before
// you add new rules.
type MaxNumberOfConfigRulesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfConfigRulesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfConfigRulesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConfigRulesExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConfigRulesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConfigRulesExceededException) Code() string {
	return "MaxNumberOfConfigRulesExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConfigRulesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConfigRulesExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConfigRulesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConfigRulesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of recorders you can create.
type MaxNumberOfConfigurationRecordersExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfConfigurationRecordersExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfConfigurationRecordersExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConfigurationRecordersExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConfigurationRecordersExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConfigurationRecordersExceededException) Code() string {
	return "MaxNumberOfConfigurationRecordersExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConfigurationRecordersExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConfigurationRecordersExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConfigurationRecordersExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConfigurationRecordersExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConfigurationRecordersExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit (6) of the number of conformance packs in an account
// (6 conformance pack with 25 AWS Config rules per pack).
type MaxNumberOfConformancePacksExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfConformancePacksExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfConformancePacksExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConformancePacksExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConformancePacksExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConformancePacksExceededException) Code() string {
	return "MaxNumberOfConformancePacksExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConformancePacksExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConformancePacksExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConformancePacksExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConformancePacksExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of delivery channels you can create.
type MaxNumberOfDeliveryChannelsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfDeliveryChannelsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfDeliveryChannelsExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfDeliveryChannelsExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfDeliveryChannelsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfDeliveryChannelsExceededException) Code() string {
	return "MaxNumberOfDeliveryChannelsExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfDeliveryChannelsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfDeliveryChannelsExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfDeliveryChannelsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfDeliveryChannelsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfDeliveryChannelsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of organization config rules you
// can create.
type MaxNumberOfOrganizationConfigRulesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfOrganizationConfigRulesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfOrganizationConfigRulesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfOrganizationConfigRulesExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfOrganizationConfigRulesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) Code() string {
	return "MaxNumberOfOrganizationConfigRulesExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfOrganizationConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit (6) of the number of organization conformance
// packs in an account (6 conformance pack with 25 AWS Config rules per pack
// per account).
type MaxNumberOfOrganizationConformancePacksExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfOrganizationConformancePacksExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfOrganizationConformancePacksExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfOrganizationConformancePacksExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfOrganizationConformancePacksExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) Code() string {
	return "MaxNumberOfOrganizationConformancePacksExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfOrganizationConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Failed to add the retention configuration because a retention configuration
// with that name already exists.
type MaxNumberOfRetentionConfigurationsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxNumberOfRetentionConfigurationsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxNumberOfRetentionConfigurationsExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfRetentionConfigurationsExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfRetentionConfigurationsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfRetentionConfigurationsExceededException) Code() string {
	return "MaxNumberOfRetentionConfigurationsExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfRetentionConfigurationsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfRetentionConfigurationsExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfRetentionConfigurationsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfRetentionConfigurationsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfRetentionConfigurationsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Organization config rule creation or deletion status in each member account.
// This includes the name of the rule, the status, error code and error message
// when the rule creation or deletion failed.
type MemberAccountStatus struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of a member account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The name of config rule deployed in the member account.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An error code that is returned when config rule creation or deletion failed
	// in the member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that config rule account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last status update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Indicates deployment status for config rule in the member account. When master
	// account calls PutOrganizationConfigRule action for the first time, config
	// rule status is created in the member account. When master account calls PutOrganizationConfigRule
	// action for the second time, config rule status is updated in the member account.
	// Config rule status is deleted when the master account deletes OrganizationConfigRule
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the rule to:
	//
	//    * CREATE_SUCCESSFUL when config rule has been created in the member account.
	//
	//    * CREATE_IN_PROGRESS when config rule is being created in the member account.
	//
	//    * CREATE_FAILED when config rule creation has failed in the member account.
	//
	//    * DELETE_FAILED when config rule deletion has failed in the member account.
	//
	//    * DELETE_IN_PROGRESS when config rule is being deleted in the member account.
	//
	//    * DELETE_SUCCESSFUL when config rule has been deleted in the member account.
	//
	//    * UPDATE_SUCCESSFUL when config rule has been updated in the member account.
	//
	//    * UPDATE_IN_PROGRESS when config rule is being updated in the member account.
	//
	//    * UPDATE_FAILED when config rule deletion has failed in the member account.
	//
	// MemberAccountRuleStatus is a required field
	MemberAccountRuleStatus *string `type:"string" required:"true" enum:"MemberAccountRuleStatus"`
}

// String returns the string representation
func (s MemberAccountStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberAccountStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberAccountStatus) SetAccountId(v string) *MemberAccountStatus {
	s.AccountId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *MemberAccountStatus) SetConfigRuleName(v string) *MemberAccountStatus {
	s.ConfigRuleName = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *MemberAccountStatus) SetErrorCode(v string) *MemberAccountStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *MemberAccountStatus) SetErrorMessage(v string) *MemberAccountStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *MemberAccountStatus) SetLastUpdateTime(v time.Time) *MemberAccountStatus {
	s.LastUpdateTime = &v
	return s
}

// SetMemberAccountRuleStatus sets the MemberAccountRuleStatus field's value.
func (s *MemberAccountStatus) SetMemberAccountRuleStatus(v string) *MemberAccountStatus {
	s.MemberAccountRuleStatus = &v
	return s
}

// There are no configuration recorders available to provide the role needed
// to describe your resources. Create a configuration recorder.
type NoAvailableConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoAvailableConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoAvailableConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoAvailableConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoAvailableConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableConfigurationRecorderException) Code() string {
	return "NoAvailableConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoAvailableConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoAvailableConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is no delivery channel available to record configurations.
type NoAvailableDeliveryChannelException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoAvailableDeliveryChannelException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoAvailableDeliveryChannelException) GoString() string {
	return s.String()
}

func newErrorNoAvailableDeliveryChannelException(v protocol.ResponseMetadata) error {
	return &NoAvailableDeliveryChannelException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableDeliveryChannelException) Code() string {
	return "NoAvailableDeliveryChannelException"
}

// Message returns the exception's message.
func (s *NoAvailableDeliveryChannelException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableDeliveryChannelException) OrigErr() error {
	return nil
}

func (s *NoAvailableDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableDeliveryChannelException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableDeliveryChannelException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Organization is no longer available.
type NoAvailableOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoAvailableOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoAvailableOrganizationException) GoString() string {
	return s.String()
}

func newErrorNoAvailableOrganizationException(v protocol.ResponseMetadata) error {
	return &NoAvailableOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableOrganizationException) Code() string {
	return "NoAvailableOrganizationException"
}

// Message returns the exception's message.
func (s *NoAvailableOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableOrganizationException) OrigErr() error {
	return nil
}

func (s *NoAvailableOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is no configuration recorder running.
type NoRunningConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoRunningConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoRunningConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoRunningConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoRunningConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoRunningConfigurationRecorderException) Code() string {
	return "NoRunningConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoRunningConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoRunningConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoRunningConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoRunningConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoRunningConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon S3 bucket does not exist.
type NoSuchBucketException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchBucketException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchBucketException) GoString() string {
	return s.String()
}

func newErrorNoSuchBucketException(v protocol.ResponseMetadata) error {
	return &NoSuchBucketException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchBucketException) Code() string {
	return "NoSuchBucketException"
}

// Message returns the exception's message.
func (s *NoSuchBucketException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchBucketException) OrigErr() error {
	return nil
}

func (s *NoSuchBucketException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchBucketException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchBucketException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more AWS Config rules in the request are invalid. Verify that the
// rule names are correct and try again.
type NoSuchConfigRuleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchConfigRuleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchConfigRuleException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigRuleException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigRuleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigRuleException) Code() string {
	return "NoSuchConfigRuleException"
}

// Message returns the exception's message.
func (s *NoSuchConfigRuleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigRuleException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigRuleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigRuleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Config rule that you passed in the filter does not exist.
type NoSuchConfigRuleInConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchConfigRuleInConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchConfigRuleInConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigRuleInConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigRuleInConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigRuleInConformancePackException) Code() string {
	return "NoSuchConfigRuleInConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchConfigRuleInConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigRuleInConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigRuleInConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigRuleInConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigRuleInConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a configuration aggregator that does not exist.
type NoSuchConfigurationAggregatorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchConfigurationAggregatorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchConfigurationAggregatorException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigurationAggregatorException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigurationAggregatorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigurationAggregatorException) Code() string {
	return "NoSuchConfigurationAggregatorException"
}

// Message returns the exception's message.
func (s *NoSuchConfigurationAggregatorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigurationAggregatorException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigurationAggregatorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigurationAggregatorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigurationAggregatorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a configuration recorder that does not exist.
type NoSuchConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigurationRecorderException) Code() string {
	return "NoSuchConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoSuchConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You specified one or more conformance packs that do not exist.
type NoSuchConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConformancePackException) Code() string {
	return "NoSuchConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a delivery channel that does not exist.
type NoSuchDeliveryChannelException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchDeliveryChannelException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchDeliveryChannelException) GoString() string {
	return s.String()
}

func newErrorNoSuchDeliveryChannelException(v protocol.ResponseMetadata) error {
	return &NoSuchDeliveryChannelException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchDeliveryChannelException) Code() string {
	return "NoSuchDeliveryChannelException"
}

// Message returns the exception's message.
func (s *NoSuchDeliveryChannelException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchDeliveryChannelException) OrigErr() error {
	return nil
}

func (s *NoSuchDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchDeliveryChannelException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchDeliveryChannelException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You specified one or more organization config rules that do not exist.
type NoSuchOrganizationConfigRuleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchOrganizationConfigRuleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchOrganizationConfigRuleException) GoString() string {
	return s.String()
}

func newErrorNoSuchOrganizationConfigRuleException(v protocol.ResponseMetadata) error {
	return &NoSuchOrganizationConfigRuleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchOrganizationConfigRuleException) Code() string {
	return "NoSuchOrganizationConfigRuleException"
}

// Message returns the exception's message.
func (s *NoSuchOrganizationConfigRuleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchOrganizationConfigRuleException) OrigErr() error {
	return nil
}

func (s *NoSuchOrganizationConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchOrganizationConfigRuleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchOrganizationConfigRuleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Config organization conformance pack that you passed in the filter does
// not exist.
//
// For DeleteOrganizationConformancePack, you tried to delete an organization
// conformance pack that does not exist.
type NoSuchOrganizationConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchOrganizationConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchOrganizationConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchOrganizationConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchOrganizationConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchOrganizationConformancePackException) Code() string {
	return "NoSuchOrganizationConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchOrganizationConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchOrganizationConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchOrganizationConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchOrganizationConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchOrganizationConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You specified an AWS Config rule without a remediation configuration.
type NoSuchRemediationConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchRemediationConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchRemediationConfigurationException) GoString() string {
	return s.String()
}

func newErrorNoSuchRemediationConfigurationException(v protocol.ResponseMetadata) error {
	return &NoSuchRemediationConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRemediationConfigurationException) Code() string {
	return "NoSuchRemediationConfigurationException"
}

// Message returns the exception's message.
func (s *NoSuchRemediationConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRemediationConfigurationException) OrigErr() error {
	return nil
}

func (s *NoSuchRemediationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRemediationConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRemediationConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You tried to delete a remediation exception that does not exist.
type NoSuchRemediationExceptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchRemediationExceptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchRemediationExceptionException) GoString() string {
	return s.String()
}

func newErrorNoSuchRemediationExceptionException(v protocol.ResponseMetadata) error {
	return &NoSuchRemediationExceptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRemediationExceptionException) Code() string {
	return "NoSuchRemediationExceptionException"
}

// Message returns the exception's message.
func (s *NoSuchRemediationExceptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRemediationExceptionException) OrigErr() error {
	return nil
}

func (s *NoSuchRemediationExceptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRemediationExceptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRemediationExceptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a retention configuration that does not exist.
type NoSuchRetentionConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NoSuchRetentionConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoSuchRetentionConfigurationException) GoString() string {
	return s.String()
}

func newErrorNoSuchRetentionConfigurationException(v protocol.ResponseMetadata) error {
	return &NoSuchRetentionConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRetentionConfigurationException) Code() string {
	return "NoSuchRetentionConfigurationException"
}

// Message returns the exception's message.
func (s *NoSuchRetentionConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRetentionConfigurationException) OrigErr() error {
	return nil
}

func (s *NoSuchRetentionConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRetentionConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRetentionConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For PutConfigurationAggregator API, you can see this exception for the following
// reasons:
//
//    * No permission to call EnableAWSServiceAccess API
//
//    * The configuration aggregator cannot be updated because your AWS Organization
//    management account or the delegated administrator role changed. Delete
//    this aggregator and create a new one with the current AWS Organization.
//
//    * The configuration aggregator is associated with a previous AWS Organization
//    and AWS Config cannot aggregate data with current AWS Organization. Delete
//    this aggregator and create a new one with the current AWS Organization.
//
//    * You are not a registered delegated administrator for AWS Config with
//    permissions to call ListDelegatedAdministrators API. Ensure that the management
//    account registers delagated administrator for AWS Config service principle
//    name before the delegated administrator creates an aggregator.
//
// For all OrganizationConfigRule and OrganizationConformancePack APIs, AWS
// Config throws an exception if APIs are called from member accounts. All APIs
// must be called from organization master account.
type OrganizationAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OrganizationAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorOrganizationAccessDeniedException(v protocol.ResponseMetadata) error {
	return &OrganizationAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationAccessDeniedException) Code() string {
	return "OrganizationAccessDeniedException"
}

// Message returns the exception's message.
func (s *OrganizationAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationAccessDeniedException) OrigErr() error {
	return nil
}

func (s *OrganizationAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This object contains regions to set up the aggregator and an IAM role to
// retrieve organization details.
type OrganizationAggregationSource struct {
	_ struct{} `type:"structure"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`

	// ARN of the IAM role used to retrieve AWS Organization details associated
	// with the aggregator account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OrganizationAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationAggregationSource"}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *OrganizationAggregationSource) SetAllAwsRegions(v bool) *OrganizationAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *OrganizationAggregationSource) SetAwsRegions(v []*string) *OrganizationAggregationSource {
	s.AwsRegions = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *OrganizationAggregationSource) SetRoleArn(v string) *OrganizationAggregationSource {
	s.RoleArn = &v
	return s
}

// AWS Config resource cannot be created because your organization does not
// have all features enabled.
type OrganizationAllFeaturesNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OrganizationAllFeaturesNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationAllFeaturesNotEnabledException) GoString() string {
	return s.String()
}

func newErrorOrganizationAllFeaturesNotEnabledException(v protocol.ResponseMetadata) error {
	return &OrganizationAllFeaturesNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationAllFeaturesNotEnabledException) Code() string {
	return "OrganizationAllFeaturesNotEnabledException"
}

// Message returns the exception's message.
func (s *OrganizationAllFeaturesNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationAllFeaturesNotEnabledException) OrigErr() error {
	return nil
}

func (s *OrganizationAllFeaturesNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationAllFeaturesNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationAllFeaturesNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An organization config rule that has information about config rules that
// AWS Config creates in member accounts.
type OrganizationConfigRule struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of accounts excluded from organization config rule.
	ExcludedAccounts []*string `type:"list"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of organization config rule.
	//
	// OrganizationConfigRuleArn is a required field
	OrganizationConfigRuleArn *string `min:"1" type:"string" required:"true"`

	// The name that you assign to organization config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata `type:"structure"`

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata `type:"structure"`
}

// String returns the string representation
func (s OrganizationConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConfigRule) GoString() string {
	return s.String()
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *OrganizationConfigRule) SetExcludedAccounts(v []*string) *OrganizationConfigRule {
	s.ExcludedAccounts = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConfigRule) SetLastUpdateTime(v time.Time) *OrganizationConfigRule {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConfigRuleArn sets the OrganizationConfigRuleArn field's value.
func (s *OrganizationConfigRule) SetOrganizationConfigRuleArn(v string) *OrganizationConfigRule {
	s.OrganizationConfigRuleArn = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *OrganizationConfigRule) SetOrganizationConfigRuleName(v string) *OrganizationConfigRule {
	s.OrganizationConfigRuleName = &v
	return s
}

// SetOrganizationCustomRuleMetadata sets the OrganizationCustomRuleMetadata field's value.
func (s *OrganizationConfigRule) SetOrganizationCustomRuleMetadata(v *OrganizationCustomRuleMetadata) *OrganizationConfigRule {
	s.OrganizationCustomRuleMetadata = v
	return s
}

// SetOrganizationManagedRuleMetadata sets the OrganizationManagedRuleMetadata field's value.
func (s *OrganizationConfigRule) SetOrganizationManagedRuleMetadata(v *OrganizationManagedRuleMetadata) *OrganizationConfigRule {
	s.OrganizationManagedRuleMetadata = v
	return s
}

// Returns the status for an organization config rule in an organization.
type OrganizationConfigRuleStatus struct {
	_ struct{} `type:"structure"`

	// An error code that is returned when organization config rule creation or
	// deletion has failed.
	ErrorCode *string `type:"string"`

	// An error message indicating that organization config rule creation or deletion
	// failed due to an error.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The name that you assign to organization config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of an organization config rule. When master account
	// calls PutOrganizationConfigRule action for the first time, config rule status
	// is created in all the member accounts. When master account calls PutOrganizationConfigRule
	// action for the second time, config rule status is updated in all the member
	// accounts. Additionally, config rule status is updated when one or more member
	// accounts join or leave an organization. Config rule status is deleted when
	// the master account deletes OrganizationConfigRule in all the member accounts
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the rule to:
	//
	//    * CREATE_SUCCESSFUL when an organization config rule has been successfully
	//    created in all the member accounts.
	//
	//    * CREATE_IN_PROGRESS when an organization config rule creation is in progress.
	//
	//    * CREATE_FAILED when an organization config rule creation failed in one
	//    or more member accounts within that organization.
	//
	//    * DELETE_FAILED when an organization config rule deletion failed in one
	//    or more member accounts within that organization.
	//
	//    * DELETE_IN_PROGRESS when an organization config rule deletion is in progress.
	//
	//    * DELETE_SUCCESSFUL when an organization config rule has been successfully
	//    deleted from all the member accounts.
	//
	//    * UPDATE_SUCCESSFUL when an organization config rule has been successfully
	//    updated in all the member accounts.
	//
	//    * UPDATE_IN_PROGRESS when an organization config rule update is in progress.
	//
	//    * UPDATE_FAILED when an organization config rule update failed in one
	//    or more member accounts within that organization.
	//
	// OrganizationRuleStatus is a required field
	OrganizationRuleStatus *string `type:"string" required:"true" enum:"OrganizationRuleStatus"`
}

// String returns the string representation
func (s OrganizationConfigRuleStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConfigRuleStatus) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConfigRuleStatus) SetErrorCode(v string) *OrganizationConfigRuleStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConfigRuleStatus) SetErrorMessage(v string) *OrganizationConfigRuleStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConfigRuleStatus) SetLastUpdateTime(v time.Time) *OrganizationConfigRuleStatus {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *OrganizationConfigRuleStatus) SetOrganizationConfigRuleName(v string) *OrganizationConfigRuleStatus {
	s.OrganizationConfigRuleName = &v
	return s
}

// SetOrganizationRuleStatus sets the OrganizationRuleStatus field's value.
func (s *OrganizationConfigRuleStatus) SetOrganizationRuleStatus(v string) *OrganizationConfigRuleStatus {
	s.OrganizationRuleStatus = &v
	return s
}

// An organization conformance pack that has information about conformance packs
// that AWS Config creates in member accounts.
type OrganizationConformancePack struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// Amazon S3 bucket where AWS Config stores conformance pack templates.
	//
	// This field is optional.
	DeliveryS3Bucket *string `type:"string"`

	// Any folder structure you want to add to an Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// A comma-separated list of accounts excluded from organization conformance
	// pack.
	ExcludedAccounts []*string `type:"list"`

	// Last time when organization conformation pack was updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// Amazon Resource Name (ARN) of organization conformance pack.
	//
	// OrganizationConformancePackArn is a required field
	OrganizationConformancePackArn *string `min:"1" type:"string" required:"true"`

	// The name you assign to an organization conformance pack.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OrganizationConformancePack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConformancePack) GoString() string {
	return s.String()
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *OrganizationConformancePack) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *OrganizationConformancePack {
	s.ConformancePackInputParameters = v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *OrganizationConformancePack) SetDeliveryS3Bucket(v string) *OrganizationConformancePack {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *OrganizationConformancePack) SetDeliveryS3KeyPrefix(v string) *OrganizationConformancePack {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *OrganizationConformancePack) SetExcludedAccounts(v []*string) *OrganizationConformancePack {
	s.ExcludedAccounts = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePack) SetLastUpdateTime(v time.Time) *OrganizationConformancePack {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConformancePackArn sets the OrganizationConformancePackArn field's value.
func (s *OrganizationConformancePack) SetOrganizationConformancePackArn(v string) *OrganizationConformancePack {
	s.OrganizationConformancePackArn = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *OrganizationConformancePack) SetOrganizationConformancePackName(v string) *OrganizationConformancePack {
	s.OrganizationConformancePackName = &v
	return s
}

// Organization conformance pack creation or deletion status in each member
// account. This includes the name of the conformance pack, the status, error
// code and error message when the conformance pack creation or deletion failed.
type OrganizationConformancePackDetailedStatus struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of a member account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The name of conformance pack deployed in the member account.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// An error code that is returned when conformance pack creation or deletion
	// failed in the member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that conformance pack account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last status update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Indicates deployment status for conformance pack in a member account. When
	// master account calls PutOrganizationConformancePack action for the first
	// time, conformance pack status is created in the member account. When master
	// account calls PutOrganizationConformancePack action for the second time,
	// conformance pack status is updated in the member account. Conformance pack
	// status is deleted when the master account deletes OrganizationConformancePack
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the conformance pack to:
	//
	//    * CREATE_SUCCESSFUL when conformance pack has been created in the member
	//    account.
	//
	//    * CREATE_IN_PROGRESS when conformance pack is being created in the member
	//    account.
	//
	//    * CREATE_FAILED when conformance pack creation has failed in the member
	//    account.
	//
	//    * DELETE_FAILED when conformance pack deletion has failed in the member
	//    account.
	//
	//    * DELETE_IN_PROGRESS when conformance pack is being deleted in the member
	//    account.
	//
	//    * DELETE_SUCCESSFUL when conformance pack has been deleted in the member
	//    account.
	//
	//    * UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	//    account.
	//
	//    * UPDATE_IN_PROGRESS when conformance pack is being updated in the member
	//    account.
	//
	//    * UPDATE_FAILED when conformance pack deletion has failed in the member
	//    account.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"OrganizationResourceDetailedStatus"`
}

// String returns the string representation
func (s OrganizationConformancePackDetailedStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConformancePackDetailedStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *OrganizationConformancePackDetailedStatus) SetAccountId(v string) *OrganizationConformancePackDetailedStatus {
	s.AccountId = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *OrganizationConformancePackDetailedStatus) SetConformancePackName(v string) *OrganizationConformancePackDetailedStatus {
	s.ConformancePackName = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConformancePackDetailedStatus) SetErrorCode(v string) *OrganizationConformancePackDetailedStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConformancePackDetailedStatus) SetErrorMessage(v string) *OrganizationConformancePackDetailedStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePackDetailedStatus) SetLastUpdateTime(v time.Time) *OrganizationConformancePackDetailedStatus {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationConformancePackDetailedStatus) SetStatus(v string) *OrganizationConformancePackDetailedStatus {
	s.Status = &v
	return s
}

// Returns the status for an organization conformance pack in an organization.
type OrganizationConformancePackStatus struct {
	_ struct{} `type:"structure"`

	// An error code that is returned when organization conformance pack creation
	// or deletion has failed in a member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that organization conformance pack creation or
	// deletion failed due to an error.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The name that you assign to organization conformance pack.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of an organization conformance pack. When master
	// account calls PutOrganizationConformancePack for the first time, conformance
	// pack status is created in all the member accounts. When master account calls
	// PutOrganizationConformancePack for the second time, conformance pack status
	// is updated in all the member accounts. Additionally, conformance pack status
	// is updated when one or more member accounts join or leave an organization.
	// Conformance pack status is deleted when the master account deletes OrganizationConformancePack
	// in all the member accounts and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the conformance pack to:
	//
	//    * CREATE_SUCCESSFUL when an organization conformance pack has been successfully
	//    created in all the member accounts.
	//
	//    * CREATE_IN_PROGRESS when an organization conformance pack creation is
	//    in progress.
	//
	//    * CREATE_FAILED when an organization conformance pack creation failed
	//    in one or more member accounts within that organization.
	//
	//    * DELETE_FAILED when an organization conformance pack deletion failed
	//    in one or more member accounts within that organization.
	//
	//    * DELETE_IN_PROGRESS when an organization conformance pack deletion is
	//    in progress.
	//
	//    * DELETE_SUCCESSFUL when an organization conformance pack has been successfully
	//    deleted from all the member accounts.
	//
	//    * UPDATE_SUCCESSFUL when an organization conformance pack has been successfully
	//    updated in all the member accounts.
	//
	//    * UPDATE_IN_PROGRESS when an organization conformance pack update is in
	//    progress.
	//
	//    * UPDATE_FAILED when an organization conformance pack update failed in
	//    one or more member accounts within that organization.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"OrganizationResourceStatus"`
}

// String returns the string representation
func (s OrganizationConformancePackStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConformancePackStatus) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConformancePackStatus) SetErrorCode(v string) *OrganizationConformancePackStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConformancePackStatus) SetErrorMessage(v string) *OrganizationConformancePackStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePackStatus) SetLastUpdateTime(v time.Time) *OrganizationConformancePackStatus {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *OrganizationConformancePackStatus) SetOrganizationConformancePackName(v string) *OrganizationConformancePackStatus {
	s.OrganizationConformancePackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationConformancePackStatus) SetStatus(v string) *OrganizationConformancePackStatus {
	s.Status = &v
	return s
}

// You have specified a template that is not valid or supported.
type OrganizationConformancePackTemplateValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OrganizationConformancePackTemplateValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConformancePackTemplateValidationException) GoString() string {
	return s.String()
}

func newErrorOrganizationConformancePackTemplateValidationException(v protocol.ResponseMetadata) error {
	return &OrganizationConformancePackTemplateValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationConformancePackTemplateValidationException) Code() string {
	return "OrganizationConformancePackTemplateValidationException"
}

// Message returns the exception's message.
func (s *OrganizationConformancePackTemplateValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationConformancePackTemplateValidationException) OrigErr() error {
	return nil
}

func (s *OrganizationConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationConformancePackTemplateValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationConformancePackTemplateValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that specifies organization custom rule metadata such as resource
// type, resource ID of AWS resource, Lamdba function ARN, and organization
// trigger types that trigger AWS Config to evaluate your AWS resources against
// a rule. It also provides the frequency with which you want AWS Config to
// run evaluations for the rule if the trigger type is periodic.
type OrganizationCustomRuleMetadata struct {
	_ struct{} `type:"structure"`

	// The description that you provide for organization config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to organization config rule Lambda
	// function.
	InputParameters *string `min:"1" type:"string"`

	// The lambda function ARN.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `min:"1" type:"string" required:"true"`

	// The maximum frequency with which AWS Config runs evaluations for a rule.
	// Your custom rule is triggered when AWS Config delivers the configuration
	// snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// The type of notification that triggers AWS Config to run an evaluation for
	// a rule. You can specify the following notification types:
	//
	//    * ConfigurationItemChangeNotification - Triggers an evaluation when AWS
	//    Config delivers a configuration item as a result of a resource change.
	//
	//    * OversizedConfigurationItemChangeNotification - Triggers an evaluation
	//    when AWS Config delivers an oversized configuration item. AWS Config may
	//    generate this notification type when a resource changes and the notification
	//    exceeds the maximum size allowed by Amazon SNS.
	//
	//    * ScheduledNotification - Triggers a periodic evaluation at the frequency
	//    specified for MaximumExecutionFrequency.
	//
	// OrganizationConfigRuleTriggerTypes is a required field
	OrganizationConfigRuleTriggerTypes []*string `type:"list" required:"true"`

	// The ID of the AWS resource that was evaluated.
	ResourceIdScope *string `min:"1" type:"string"`

	// The type of the AWS resource that was evaluated.
	ResourceTypesScope []*string `type:"list"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	TagKeyScope *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	TagValueScope *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OrganizationCustomRuleMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationCustomRuleMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationCustomRuleMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationCustomRuleMetadata"}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputParameters", 1))
	}
	if s.LambdaFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionArn"))
	}
	if s.LambdaFunctionArn != nil && len(*s.LambdaFunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionArn", 1))
	}
	if s.OrganizationConfigRuleTriggerTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleTriggerTypes"))
	}
	if s.ResourceIdScope != nil && len(*s.ResourceIdScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdScope", 1))
	}
	if s.TagKeyScope != nil && len(*s.TagKeyScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeyScope", 1))
	}
	if s.TagValueScope != nil && len(*s.TagValueScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValueScope", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *OrganizationCustomRuleMetadata) SetDescription(v string) *OrganizationCustomRuleMetadata {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *OrganizationCustomRuleMetadata) SetInputParameters(v string) *OrganizationCustomRuleMetadata {
	s.InputParameters = &v
	return s
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *OrganizationCustomRuleMetadata) SetLambdaFunctionArn(v string) *OrganizationCustomRuleMetadata {
	s.LambdaFunctionArn = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *OrganizationCustomRuleMetadata) SetMaximumExecutionFrequency(v string) *OrganizationCustomRuleMetadata {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetOrganizationConfigRuleTriggerTypes sets the OrganizationConfigRuleTriggerTypes field's value.
func (s *OrganizationCustomRuleMetadata) SetOrganizationConfigRuleTriggerTypes(v []*string) *OrganizationCustomRuleMetadata {
	s.OrganizationConfigRuleTriggerTypes = v
	return s
}

// SetResourceIdScope sets the ResourceIdScope field's value.
func (s *OrganizationCustomRuleMetadata) SetResourceIdScope(v string) *OrganizationCustomRuleMetadata {
	s.ResourceIdScope = &v
	return s
}

// SetResourceTypesScope sets the ResourceTypesScope field's value.
func (s *OrganizationCustomRuleMetadata) SetResourceTypesScope(v []*string) *OrganizationCustomRuleMetadata {
	s.ResourceTypesScope = v
	return s
}

// SetTagKeyScope sets the TagKeyScope field's value.
func (s *OrganizationCustomRuleMetadata) SetTagKeyScope(v string) *OrganizationCustomRuleMetadata {
	s.TagKeyScope = &v
	return s
}

// SetTagValueScope sets the TagValueScope field's value.
func (s *OrganizationCustomRuleMetadata) SetTagValueScope(v string) *OrganizationCustomRuleMetadata {
	s.TagValueScope = &v
	return s
}

// An object that specifies organization managed rule metadata such as resource
// type and ID of AWS resource along with the rule identifier. It also provides
// the frequency with which you want AWS Config to run evaluations for the rule
// if the trigger type is periodic.
type OrganizationManagedRuleMetadata struct {
	_ struct{} `type:"structure"`

	// The description that you provide for organization config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to organization config rule Lambda
	// function.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which AWS Config runs evaluations for a rule.
	// You are using an AWS managed rule that is triggered at a periodic frequency.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// The ID of the AWS resource that was evaluated.
	ResourceIdScope *string `min:"1" type:"string"`

	// The type of the AWS resource that was evaluated.
	ResourceTypesScope []*string `type:"list"`

	// For organization config managed rules, a predefined identifier from a list.
	// For example, IAM_PASSWORD_POLICY is a managed rule. To reference a managed
	// rule, see Using AWS Managed Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	//
	// RuleIdentifier is a required field
	RuleIdentifier *string `min:"1" type:"string" required:"true"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	TagKeyScope *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	TagValueScope *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OrganizationManagedRuleMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationManagedRuleMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationManagedRuleMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationManagedRuleMetadata"}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputParameters", 1))
	}
	if s.ResourceIdScope != nil && len(*s.ResourceIdScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdScope", 1))
	}
	if s.RuleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleIdentifier"))
	}
	if s.RuleIdentifier != nil && len(*s.RuleIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleIdentifier", 1))
	}
	if s.TagKeyScope != nil && len(*s.TagKeyScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeyScope", 1))
	}
	if s.TagValueScope != nil && len(*s.TagValueScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValueScope", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *OrganizationManagedRuleMetadata) SetDescription(v string) *OrganizationManagedRuleMetadata {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *OrganizationManagedRuleMetadata) SetInputParameters(v string) *OrganizationManagedRuleMetadata {
	s.InputParameters = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *OrganizationManagedRuleMetadata) SetMaximumExecutionFrequency(v string) *OrganizationManagedRuleMetadata {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetResourceIdScope sets the ResourceIdScope field's value.
func (s *OrganizationManagedRuleMetadata) SetResourceIdScope(v string) *OrganizationManagedRuleMetadata {
	s.ResourceIdScope = &v
	return s
}

// SetResourceTypesScope sets the ResourceTypesScope field's value.
func (s *OrganizationManagedRuleMetadata) SetResourceTypesScope(v []*string) *OrganizationManagedRuleMetadata {
	s.ResourceTypesScope = v
	return s
}

// SetRuleIdentifier sets the RuleIdentifier field's value.
func (s *OrganizationManagedRuleMetadata) SetRuleIdentifier(v string) *OrganizationManagedRuleMetadata {
	s.RuleIdentifier = &v
	return s
}

// SetTagKeyScope sets the TagKeyScope field's value.
func (s *OrganizationManagedRuleMetadata) SetTagKeyScope(v string) *OrganizationManagedRuleMetadata {
	s.TagKeyScope = &v
	return s
}

// SetTagValueScope sets the TagValueScope field's value.
func (s *OrganizationManagedRuleMetadata) SetTagValueScope(v string) *OrganizationManagedRuleMetadata {
	s.TagValueScope = &v
	return s
}

// Status filter object to filter results based on specific member account ID
// or status type for an organization conformance pack.
type OrganizationResourceDetailedStatusFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the member account within an organization.
	AccountId *string `type:"string"`

	// Indicates deployment status for conformance pack in a member account. When
	// master account calls PutOrganizationConformancePack action for the first
	// time, conformance pack status is created in the member account. When master
	// account calls PutOrganizationConformancePack action for the second time,
	// conformance pack status is updated in the member account. Conformance pack
	// status is deleted when the master account deletes OrganizationConformancePack
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the conformance pack to:
	//
	//    * CREATE_SUCCESSFUL when conformance pack has been created in the member
	//    account.
	//
	//    * CREATE_IN_PROGRESS when conformance pack is being created in the member
	//    account.
	//
	//    * CREATE_FAILED when conformance pack creation has failed in the member
	//    account.
	//
	//    * DELETE_FAILED when conformance pack deletion has failed in the member
	//    account.
	//
	//    * DELETE_IN_PROGRESS when conformance pack is being deleted in the member
	//    account.
	//
	//    * DELETE_SUCCESSFUL when conformance pack has been deleted in the member
	//    account.
	//
	//    * UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	//    account.
	//
	//    * UPDATE_IN_PROGRESS when conformance pack is being updated in the member
	//    account.
	//
	//    * UPDATE_FAILED when conformance pack deletion has failed in the member
	//    account.
	Status *string `type:"string" enum:"OrganizationResourceDetailedStatus"`
}

// String returns the string representation
func (s OrganizationResourceDetailedStatusFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationResourceDetailedStatusFilters) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *OrganizationResourceDetailedStatusFilters) SetAccountId(v string) *OrganizationResourceDetailedStatusFilters {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationResourceDetailedStatusFilters) SetStatus(v string) *OrganizationResourceDetailedStatusFilters {
	s.Status = &v
	return s
}

// The configuration item size is outside the allowable range.
type OversizedConfigurationItemException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OversizedConfigurationItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OversizedConfigurationItemException) GoString() string {
	return s.String()
}

func newErrorOversizedConfigurationItemException(v protocol.ResponseMetadata) error {
	return &OversizedConfigurationItemException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OversizedConfigurationItemException) Code() string {
	return "OversizedConfigurationItemException"
}

// Message returns the exception's message.
func (s *OversizedConfigurationItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OversizedConfigurationItemException) OrigErr() error {
	return nil
}

func (s *OversizedConfigurationItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OversizedConfigurationItemException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OversizedConfigurationItemException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the account ID and region of an aggregator account
// that is requesting authorization but is not yet authorized.
type PendingAggregationRequest struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	RequesterAccountId *string `type:"string"`

	// The region requesting to aggregate data.
	RequesterAwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PendingAggregationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingAggregationRequest) GoString() string {
	return s.String()
}

// SetRequesterAccountId sets the RequesterAccountId field's value.
func (s *PendingAggregationRequest) SetRequesterAccountId(v string) *PendingAggregationRequest {
	s.RequesterAccountId = &v
	return s
}

// SetRequesterAwsRegion sets the RequesterAwsRegion field's value.
func (s *PendingAggregationRequest) SetRequesterAwsRegion(v string) *PendingAggregationRequest {
	s.RequesterAwsRegion = &v
	return s
}

type PutAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`

	// An array of tag object.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s PutAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAggregationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAggregationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAggregationAuthorizationInput"}
	if s.AuthorizedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAccountId"))
	}
	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *PutAggregationAuthorizationInput) SetAuthorizedAccountId(v string) *PutAggregationAuthorizationInput {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *PutAggregationAuthorizationInput) SetAuthorizedAwsRegion(v string) *PutAggregationAuthorizationInput {
	s.AuthorizedAwsRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutAggregationAuthorizationInput) SetTags(v []*Tag) *PutAggregationAuthorizationInput {
	s.Tags = v
	return s
}

type PutAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregationAuthorization object.
	AggregationAuthorization *AggregationAuthorization `type:"structure"`
}

// String returns the string representation
func (s PutAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAggregationAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAggregationAuthorization sets the AggregationAuthorization field's value.
func (s *PutAggregationAuthorizationOutput) SetAggregationAuthorization(v *AggregationAuthorization) *PutAggregationAuthorizationOutput {
	s.AggregationAuthorization = v
	return s
}

type PutConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule that you want to add to your account.
	//
	// ConfigRule is a required field
	ConfigRule *ConfigRule `type:"structure" required:"true"`

	// An array of tag object.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s PutConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigRuleInput"}
	if s.ConfigRule == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRule"))
	}
	if s.ConfigRule != nil {
		if err := s.ConfigRule.Validate(); err != nil {
			invalidParams.AddNested("ConfigRule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRule sets the ConfigRule field's value.
func (s *PutConfigRuleInput) SetConfigRule(v *ConfigRule) *PutConfigRuleInput {
	s.ConfigRule = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutConfigRuleInput) SetTags(v []*Tag) *PutConfigRuleInput {
	s.Tags = v
	return s
}

type PutConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigRuleOutput) GoString() string {
	return s.String()
}

type PutConfigurationAggregatorInput struct {
	_ struct{} `type:"structure"`

	// A list of AccountAggregationSource object.
	AccountAggregationSources []*AccountAggregationSource `type:"list"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// An OrganizationAggregationSource object.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`

	// An array of tag object.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s PutConfigurationAggregatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationAggregatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationAggregatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationAggregatorInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.AccountAggregationSources != nil {
		for i, v := range s.AccountAggregationSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountAggregationSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OrganizationAggregationSource != nil {
		if err := s.OrganizationAggregationSource.Validate(); err != nil {
			invalidParams.AddNested("OrganizationAggregationSource", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAggregationSources sets the AccountAggregationSources field's value.
func (s *PutConfigurationAggregatorInput) SetAccountAggregationSources(v []*AccountAggregationSource) *PutConfigurationAggregatorInput {
	s.AccountAggregationSources = v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *PutConfigurationAggregatorInput) SetConfigurationAggregatorName(v string) *PutConfigurationAggregatorInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetOrganizationAggregationSource sets the OrganizationAggregationSource field's value.
func (s *PutConfigurationAggregatorInput) SetOrganizationAggregationSource(v *OrganizationAggregationSource) *PutConfigurationAggregatorInput {
	s.OrganizationAggregationSource = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutConfigurationAggregatorInput) SetTags(v []*Tag) *PutConfigurationAggregatorInput {
	s.Tags = v
	return s
}

type PutConfigurationAggregatorOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationAggregator object.
	ConfigurationAggregator *ConfigurationAggregator `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationAggregatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationAggregatorOutput) GoString() string {
	return s.String()
}

// SetConfigurationAggregator sets the ConfigurationAggregator field's value.
func (s *PutConfigurationAggregatorOutput) SetConfigurationAggregator(v *ConfigurationAggregator) *PutConfigurationAggregatorOutput {
	s.ConfigurationAggregator = v
	return s
}

// The input for the PutConfigurationRecorder action.
type PutConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The configuration recorder object that records each configuration change
	// made to the resources.
	//
	// ConfigurationRecorder is a required field
	ConfigurationRecorder *ConfigurationRecorder `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationRecorderInput"}
	if s.ConfigurationRecorder == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorder"))
	}
	if s.ConfigurationRecorder != nil {
		if err := s.ConfigurationRecorder.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationRecorder", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorder sets the ConfigurationRecorder field's value.
func (s *PutConfigurationRecorderInput) SetConfigurationRecorder(v *ConfigurationRecorder) *PutConfigurationRecorderInput {
	s.ConfigurationRecorder = v
	return s
}

type PutConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationRecorderOutput) GoString() string {
	return s.String()
}

type PutConformancePackInput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// Name of the conformance pack you want to create.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Amazon S3 bucket where AWS Config stores conformance pack templates.
	//
	// This field is optional.
	DeliveryS3Bucket *string `type:"string"`

	// The prefix for the Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// A string containing full conformance pack template body. Structure containing
	// the template body with a minimum length of 1 byte and a maximum length of
	// 51,200 bytes.
	//
	// You can only use a YAML template with one resource type, that is, config
	// rule and a remediation action.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body (s3://bucketname/prefix). The
	// uri must point to the conformance pack template (max size: 300 KB) that is
	// located in an Amazon S3 bucket in the same region as the conformance pack.
	//
	// You must have access to read Amazon S3 bucket.
	TemplateS3Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConformancePackInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateS3Uri != nil && len(*s.TemplateS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateS3Uri", 1))
	}
	if s.ConformancePackInputParameters != nil {
		for i, v := range s.ConformancePackInputParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConformancePackInputParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *PutConformancePackInput) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *PutConformancePackInput {
	s.ConformancePackInputParameters = v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *PutConformancePackInput) SetConformancePackName(v string) *PutConformancePackInput {
	s.ConformancePackName = &v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *PutConformancePackInput) SetDeliveryS3Bucket(v string) *PutConformancePackInput {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *PutConformancePackInput) SetDeliveryS3KeyPrefix(v string) *PutConformancePackInput {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *PutConformancePackInput) SetTemplateBody(v string) *PutConformancePackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateS3Uri sets the TemplateS3Uri field's value.
func (s *PutConformancePackInput) SetTemplateS3Uri(v string) *PutConformancePackInput {
	s.TemplateS3Uri = &v
	return s
}

type PutConformancePackOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the conformance pack.
	ConformancePackArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConformancePackOutput) GoString() string {
	return s.String()
}

// SetConformancePackArn sets the ConformancePackArn field's value.
func (s *PutConformancePackOutput) SetConformancePackArn(v string) *PutConformancePackOutput {
	s.ConformancePackArn = &v
	return s
}

// The input for the PutDeliveryChannel action.
type PutDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The configuration delivery channel object that delivers the configuration
	// information to an Amazon S3 bucket and to an Amazon SNS topic.
	//
	// DeliveryChannel is a required field
	DeliveryChannel *DeliveryChannel `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliveryChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDeliveryChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDeliveryChannelInput"}
	if s.DeliveryChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannel"))
	}
	if s.DeliveryChannel != nil {
		if err := s.DeliveryChannel.Validate(); err != nil {
			invalidParams.AddNested("DeliveryChannel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannel sets the DeliveryChannel field's value.
func (s *PutDeliveryChannelInput) SetDeliveryChannel(v *DeliveryChannel) *PutDeliveryChannelInput {
	s.DeliveryChannel = v
	return s
}

type PutDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliveryChannelOutput) GoString() string {
	return s.String()
}

type PutEvaluationsInput struct {
	_ struct{} `type:"structure"`

	// The assessments that the AWS Lambda function performs. Each evaluation identifies
	// an AWS resource and indicates whether it complies with the AWS Config rule
	// that invokes the AWS Lambda function.
	Evaluations []*Evaluation `type:"list"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// Identifies the rule and the event that triggered the evaluation.
	//
	// ResultToken is a required field
	ResultToken *string `type:"string" required:"true"`

	// Use this parameter to specify a test run for PutEvaluations. You can verify
	// whether your AWS Lambda function will deliver evaluation results to AWS Config.
	// No updates occur to your existing evaluations, and evaluation results are
	// not sent to AWS Config.
	//
	// When TestMode is true, PutEvaluations doesn't require a valid value for the
	// ResultToken parameter, but the value cannot be null.
	TestMode *bool `type:"boolean"`
}

// String returns the string representation
func (s PutEvaluationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEvaluationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEvaluationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEvaluationsInput"}
	if s.ResultToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultToken"))
	}
	if s.Evaluations != nil {
		for i, v := range s.Evaluations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Evaluations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluations sets the Evaluations field's value.
func (s *PutEvaluationsInput) SetEvaluations(v []*Evaluation) *PutEvaluationsInput {
	s.Evaluations = v
	return s
}

// SetResultToken sets the ResultToken field's value.
func (s *PutEvaluationsInput) SetResultToken(v string) *PutEvaluationsInput {
	s.ResultToken = &v
	return s
}

// SetTestMode sets the TestMode field's value.
func (s *PutEvaluationsInput) SetTestMode(v bool) *PutEvaluationsInput {
	s.TestMode = &v
	return s
}

type PutEvaluationsOutput struct {
	_ struct{} `type:"structure"`

	// Requests that failed because of a client or server error.
	FailedEvaluations []*Evaluation `type:"list"`
}

// String returns the string representation
func (s PutEvaluationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEvaluationsOutput) GoString() string {
	return s.String()
}

// SetFailedEvaluations sets the FailedEvaluations field's value.
func (s *PutEvaluationsOutput) SetFailedEvaluations(v []*Evaluation) *PutEvaluationsOutput {
	s.FailedEvaluations = v
	return s
}

type PutExternalEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An ExternalEvaluation object that provides details about compliance.
	//
	// ExternalEvaluation is a required field
	ExternalEvaluation *ExternalEvaluation `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutExternalEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutExternalEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutExternalEvaluationInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ExternalEvaluation == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalEvaluation"))
	}
	if s.ExternalEvaluation != nil {
		if err := s.ExternalEvaluation.Validate(); err != nil {
			invalidParams.AddNested("ExternalEvaluation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *PutExternalEvaluationInput) SetConfigRuleName(v string) *PutExternalEvaluationInput {
	s.ConfigRuleName = &v
	return s
}

// SetExternalEvaluation sets the ExternalEvaluation field's value.
func (s *PutExternalEvaluationInput) SetExternalEvaluation(v *ExternalEvaluation) *PutExternalEvaluationInput {
	s.ExternalEvaluation = v
	return s
}

type PutExternalEvaluationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutExternalEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalEvaluationOutput) GoString() string {
	return s.String()
}

type PutOrganizationConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of accounts that you want to exclude from an organization
	// config rule.
	ExcludedAccounts []*string `type:"list"`

	// The name that you assign to an organization config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata `type:"structure"`

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata `type:"structure"`
}

// String returns the string representation
func (s PutOrganizationConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOrganizationConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOrganizationConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOrganizationConfigRuleInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}
	if s.OrganizationCustomRuleMetadata != nil {
		if err := s.OrganizationCustomRuleMetadata.Validate(); err != nil {
			invalidParams.AddNested("OrganizationCustomRuleMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.OrganizationManagedRuleMetadata != nil {
		if err := s.OrganizationManagedRuleMetadata.Validate(); err != nil {
			invalidParams.AddNested("OrganizationManagedRuleMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *PutOrganizationConfigRuleInput) SetExcludedAccounts(v []*string) *PutOrganizationConfigRuleInput {
	s.ExcludedAccounts = v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *PutOrganizationConfigRuleInput) SetOrganizationConfigRuleName(v string) *PutOrganizationConfigRuleInput {
	s.OrganizationConfigRuleName = &v
	return s
}

// SetOrganizationCustomRuleMetadata sets the OrganizationCustomRuleMetadata field's value.
func (s *PutOrganizationConfigRuleInput) SetOrganizationCustomRuleMetadata(v *OrganizationCustomRuleMetadata) *PutOrganizationConfigRuleInput {
	s.OrganizationCustomRuleMetadata = v
	return s
}

// SetOrganizationManagedRuleMetadata sets the OrganizationManagedRuleMetadata field's value.
func (s *PutOrganizationConfigRuleInput) SetOrganizationManagedRuleMetadata(v *OrganizationManagedRuleMetadata) *PutOrganizationConfigRuleInput {
	s.OrganizationManagedRuleMetadata = v
	return s
}

type PutOrganizationConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an organization config rule.
	OrganizationConfigRuleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutOrganizationConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOrganizationConfigRuleOutput) GoString() string {
	return s.String()
}

// SetOrganizationConfigRuleArn sets the OrganizationConfigRuleArn field's value.
func (s *PutOrganizationConfigRuleOutput) SetOrganizationConfigRuleArn(v string) *PutOrganizationConfigRuleOutput {
	s.OrganizationConfigRuleArn = &v
	return s
}

type PutOrganizationConformancePackInput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// Amazon S3 bucket where AWS Config stores conformance pack templates.
	//
	// This field is optional. If used, it must be prefixed with awsconfigconforms.
	DeliveryS3Bucket *string `type:"string"`

	// The prefix for the Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// A list of AWS accounts to be excluded from an organization conformance pack
	// while deploying a conformance pack.
	ExcludedAccounts []*string `type:"list"`

	// Name of the organization conformance pack you want to create.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`

	// A string containing full conformance pack template body. Structure containing
	// the template body with a minimum length of 1 byte and a maximum length of
	// 51,200 bytes.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The uri must point to the
	// conformance pack template (max size: 300 KB).
	//
	// You must have access to read Amazon S3 bucket.
	TemplateS3Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutOrganizationConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOrganizationConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOrganizationConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOrganizationConformancePackInput"}
	if s.OrganizationConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConformancePackName"))
	}
	if s.OrganizationConformancePackName != nil && len(*s.OrganizationConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConformancePackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateS3Uri != nil && len(*s.TemplateS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateS3Uri", 1))
	}
	if s.ConformancePackInputParameters != nil {
		for i, v := range s.ConformancePackInputParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConformancePackInputParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *PutOrganizationConformancePackInput) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *PutOrganizationConformancePackInput {
	s.ConformancePackInputParameters = v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *PutOrganizationConformancePackInput) SetDeliveryS3Bucket(v string) *PutOrganizationConformancePackInput {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *PutOrganizationConformancePackInput) SetDeliveryS3KeyPrefix(v string) *PutOrganizationConformancePackInput {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *PutOrganizationConformancePackInput) SetExcludedAccounts(v []*string) *PutOrganizationConformancePackInput {
	s.ExcludedAccounts = v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *PutOrganizationConformancePackInput) SetOrganizationConformancePackName(v string) *PutOrganizationConformancePackInput {
	s.OrganizationConformancePackName = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *PutOrganizationConformancePackInput) SetTemplateBody(v string) *PutOrganizationConformancePackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateS3Uri sets the TemplateS3Uri field's value.
func (s *PutOrganizationConformancePackInput) SetTemplateS3Uri(v string) *PutOrganizationConformancePackInput {
	s.TemplateS3Uri = &v
	return s
}

type PutOrganizationConformancePackOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the organization conformance pack.
	OrganizationConformancePackArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutOrganizationConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOrganizationConformancePackOutput) GoString() string {
	return s.String()
}

// SetOrganizationConformancePackArn sets the OrganizationConformancePackArn field's value.
func (s *PutOrganizationConformancePackOutput) SetOrganizationConformancePackArn(v string) *PutOrganizationConformancePackOutput {
	s.OrganizationConformancePackArn = &v
	return s
}

type PutRemediationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of remediation configuration objects.
	//
	// RemediationConfigurations is a required field
	RemediationConfigurations []*RemediationConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s PutRemediationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRemediationConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRemediationConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRemediationConfigurationsInput"}
	if s.RemediationConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("RemediationConfigurations"))
	}
	if s.RemediationConfigurations != nil {
		for i, v := range s.RemediationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemediationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRemediationConfigurations sets the RemediationConfigurations field's value.
func (s *PutRemediationConfigurationsInput) SetRemediationConfigurations(v []*RemediationConfiguration) *PutRemediationConfigurationsInput {
	s.RemediationConfigurations = v
	return s
}

type PutRemediationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of failed remediation batch objects.
	FailedBatches []*FailedRemediationBatch `type:"list"`
}

// String returns the string representation
func (s PutRemediationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRemediationConfigurationsOutput) GoString() string {
	return s.String()
}

// SetFailedBatches sets the FailedBatches field's value.
func (s *PutRemediationConfigurationsOutput) SetFailedBatches(v []*FailedRemediationBatch) *PutRemediationConfigurationsOutput {
	s.FailedBatches = v
	return s
}

type PutRemediationExceptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to create remediation
	// exception.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The exception is automatically deleted after the expiration date.
	ExpirationTime *time.Time `type:"timestamp"`

	// The message contains an explanation of the exception.
	Message *string `min:"1" type:"string"`

	// An exception list of resource exception keys to be processed with the current
	// request. AWS Config adds exception for each resource key. For example, AWS
	// Config adds 3 exceptions for 3 resource keys.
	//
	// ResourceKeys is a required field
	ResourceKeys []*RemediationExceptionResourceKey `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRemediationExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRemediationExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRemediationExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRemediationExceptionsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *PutRemediationExceptionsInput) SetConfigRuleName(v string) *PutRemediationExceptionsInput {
	s.ConfigRuleName = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *PutRemediationExceptionsInput) SetExpirationTime(v time.Time) *PutRemediationExceptionsInput {
	s.ExpirationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PutRemediationExceptionsInput) SetMessage(v string) *PutRemediationExceptionsInput {
	s.Message = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *PutRemediationExceptionsInput) SetResourceKeys(v []*RemediationExceptionResourceKey) *PutRemediationExceptionsInput {
	s.ResourceKeys = v
	return s
}

type PutRemediationExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of failed remediation exceptions batch objects. Each object
	// in the batch consists of a list of failed items and failure messages.
	FailedBatches []*FailedRemediationExceptionBatch `type:"list"`
}

// String returns the string representation
func (s PutRemediationExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRemediationExceptionsOutput) GoString() string {
	return s.String()
}

// SetFailedBatches sets the FailedBatches field's value.
func (s *PutRemediationExceptionsOutput) SetFailedBatches(v []*FailedRemediationExceptionBatch) *PutRemediationExceptionsOutput {
	s.FailedBatches = v
	return s
}

type PutResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The configuration object of the resource in valid JSON format. It must match
	// the schema registered with AWS CloudFormation.
	//
	// The configuration JSON must not exceed 64 KB.
	//
	// Configuration is a required field
	Configuration *string `type:"string" required:"true"`

	// Unique identifier of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// Name of the resource.
	ResourceName *string `type:"string"`

	// The type of the resource. The custom resource type must be registered with
	// AWS CloudFormation.
	//
	// You cannot use the organization names “aws”, “amzn”, “amazon”,
	// “alexa”, “custom” with custom resource types. It is the first part
	// of the ResourceType up to the first ::.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Version of the schema registered for the ResourceType in AWS CloudFormation.
	//
	// SchemaVersionId is a required field
	SchemaVersionId *string `min:"1" type:"string" required:"true"`

	// Tags associated with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s PutResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourceConfigInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.SchemaVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersionId"))
	}
	if s.SchemaVersionId != nil && len(*s.SchemaVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *PutResourceConfigInput) SetConfiguration(v string) *PutResourceConfigInput {
	s.Configuration = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutResourceConfigInput) SetResourceId(v string) *PutResourceConfigInput {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *PutResourceConfigInput) SetResourceName(v string) *PutResourceConfigInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *PutResourceConfigInput) SetResourceType(v string) *PutResourceConfigInput {
	s.ResourceType = &v
	return s
}

// SetSchemaVersionId sets the SchemaVersionId field's value.
func (s *PutResourceConfigInput) SetSchemaVersionId(v string) *PutResourceConfigInput {
	s.SchemaVersionId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutResourceConfigInput) SetTags(v map[string]*string) *PutResourceConfigInput {
	s.Tags = v
	return s
}

type PutResourceConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourceConfigOutput) GoString() string {
	return s.String()
}

type PutRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s PutRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRetentionConfigurationInput"}
	if s.RetentionPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodInDays"))
	}
	if s.RetentionPeriodInDays != nil && *s.RetentionPeriodInDays < 30 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriodInDays", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodInDays sets the RetentionPeriodInDays field's value.
func (s *PutRetentionConfigurationInput) SetRetentionPeriodInDays(v int64) *PutRetentionConfigurationInput {
	s.RetentionPeriodInDays = &v
	return s
}

type PutRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns a retention configuration object.
	RetentionConfiguration *RetentionConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionConfigurationOutput) GoString() string {
	return s.String()
}

// SetRetentionConfiguration sets the RetentionConfiguration field's value.
func (s *PutRetentionConfigurationOutput) SetRetentionConfiguration(v *RetentionConfiguration) *PutRetentionConfigurationOutput {
	s.RetentionConfiguration = v
	return s
}

type PutStoredQueryInput struct {
	_ struct{} `type:"structure"`

	// A list of StoredQuery objects. The mandatory fields are QueryName and Expression.
	//
	// When you are creating a query, you must provide a query name and an expression.
	// When you are updating a query, you must provide a query name but updating
	// the description is optional.
	//
	// StoredQuery is a required field
	StoredQuery *StoredQuery `type:"structure" required:"true"`

	// A list of Tags object.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s PutStoredQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStoredQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutStoredQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutStoredQueryInput"}
	if s.StoredQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("StoredQuery"))
	}
	if s.StoredQuery != nil {
		if err := s.StoredQuery.Validate(); err != nil {
			invalidParams.AddNested("StoredQuery", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStoredQuery sets the StoredQuery field's value.
func (s *PutStoredQueryInput) SetStoredQuery(v *StoredQuery) *PutStoredQueryInput {
	s.StoredQuery = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutStoredQueryInput) SetTags(v []*Tag) *PutStoredQueryInput {
	s.Tags = v
	return s
}

type PutStoredQueryOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	QueryArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutStoredQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStoredQueryOutput) GoString() string {
	return s.String()
}

// SetQueryArn sets the QueryArn field's value.
func (s *PutStoredQueryOutput) SetQueryArn(v string) *PutStoredQueryOutput {
	s.QueryArn = &v
	return s
}

// Details about the query.
type QueryInfo struct {
	_ struct{} `type:"structure"`

	// Returns a FieldInfo object.
	SelectFields []*FieldInfo `type:"list"`
}

// String returns the string representation
func (s QueryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryInfo) GoString() string {
	return s.String()
}

// SetSelectFields sets the SelectFields field's value.
func (s *QueryInfo) SetSelectFields(v []*FieldInfo) *QueryInfo {
	s.SelectFields = v
	return s
}

// Specifies the types of AWS resource for which AWS Config records configuration
// changes.
//
// In the recording group, you specify whether all supported types or specific
// types of resources are recorded.
//
// By default, AWS Config records configuration changes for all supported types
// of regional resources that AWS Config discovers in the region in which it
// is running. Regional resources are tied to a region and can be used only
// in that region. Examples of regional resources are EC2 instances and EBS
// volumes.
//
// You can also have AWS Config record configuration changes for supported types
// of global resources (for example, IAM resources). Global resources are not
// tied to an individual region and can be used in all regions.
//
// The configuration details for any global resource are the same in all regions.
// If you customize AWS Config in multiple regions to record global resources,
// it will create multiple configuration items each time a global resource changes:
// one configuration item for each region. These configuration items will contain
// identical data. To prevent duplicate configuration items, you should consider
// customizing AWS Config in only one region to record global resources, unless
// you want the configuration items to be available in multiple regions.
//
// If you don't want AWS Config to record all resources, you can specify which
// types of resources it will record with the resourceTypes parameter.
//
// For a list of supported resource types, see Supported Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
//
// For more information, see Selecting Which Resources AWS Config Records (https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html).
type RecordingGroup struct {
	_ struct{} `type:"structure"`

	// Specifies whether AWS Config records configuration changes for every supported
	// type of regional resource.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of regional resource, it starts recording resources of that type automatically.
	//
	// If you set this option to true, you cannot enumerate a list of resourceTypes.
	AllSupported *bool `locationName:"allSupported" type:"boolean"`

	// Specifies whether AWS Config includes all supported types of global resources
	// (for example, IAM resources) with the resources that it records.
	//
	// Before you can set this option to true, you must set the allSupported option
	// to true.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of global resource, it starts recording resources of that type automatically.
	//
	// The configuration details for any global resource are the same in all regions.
	// To prevent duplicate configuration items, you should consider customizing
	// AWS Config in only one region to record global resources.
	IncludeGlobalResourceTypes *bool `locationName:"includeGlobalResourceTypes" type:"boolean"`

	// A comma-separated list that specifies the types of AWS resources for which
	// AWS Config records configuration changes (for example, AWS::EC2::Instance
	// or AWS::CloudTrail::Trail).
	//
	// To record all configuration changes, you must set the allSupported option
	// to true.
	//
	// If you set this option to false, when AWS Config adds support for a new type
	// of resource, it will not record resources of that type unless you manually
	// add that type to your recording group.
	//
	// For a list of valid resourceTypes values, see the resourceType Value column
	// in Supported AWS Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s RecordingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordingGroup) GoString() string {
	return s.String()
}

// SetAllSupported sets the AllSupported field's value.
func (s *RecordingGroup) SetAllSupported(v bool) *RecordingGroup {
	s.AllSupported = &v
	return s
}

// SetIncludeGlobalResourceTypes sets the IncludeGlobalResourceTypes field's value.
func (s *RecordingGroup) SetIncludeGlobalResourceTypes(v bool) *RecordingGroup {
	s.IncludeGlobalResourceTypes = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *RecordingGroup) SetResourceTypes(v []*string) *RecordingGroup {
	s.ResourceTypes = v
	return s
}

// The relationship of the related resource to the main resource.
type Relationship struct {
	_ struct{} `type:"structure"`

	// The type of relationship with the related resource.
	RelationshipName *string `locationName:"relationshipName" type:"string"`

	// The ID of the related resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the related resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type of the related resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Relationship) GoString() string {
	return s.String()
}

// SetRelationshipName sets the RelationshipName field's value.
func (s *Relationship) SetRelationshipName(v string) *Relationship {
	s.RelationshipName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Relationship) SetResourceId(v string) *Relationship {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *Relationship) SetResourceName(v string) *Relationship {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Relationship) SetResourceType(v string) *Relationship {
	s.ResourceType = &v
	return s
}

// An object that represents the details about the remediation configuration
// that includes the remediation action, parameters, and data to execute the
// action.
type RemediationConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of remediation configuration.
	Arn *string `min:"1" type:"string"`

	// The remediation is triggered automatically.
	Automatic *bool `type:"boolean"`

	// The name of the AWS Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// Name of the service that owns the service linked rule, if applicable.
	CreatedByService *string `min:"1" type:"string"`

	// An ExecutionControls object.
	ExecutionControls *ExecutionControls `type:"structure"`

	// The maximum number of failed attempts for auto-remediation. If you do not
	// select a number, the default is 5.
	//
	// For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds
	// as 50 seconds, AWS Config will put a RemediationException on your behalf
	// for the failing resource after the 5th failed attempt within 50 seconds.
	MaximumAutomaticAttempts *int64 `min:"1" type:"integer"`

	// An object of the RemediationParameterValue.
	Parameters map[string]*RemediationParameterValue `type:"map"`

	// The type of a resource.
	ResourceType *string `type:"string"`

	// Maximum time in seconds that AWS Config runs auto-remediation. If you do
	// not select a number, the default is 60 seconds.
	//
	// For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts
	// as 5, AWS Config will run auto-remediations 5 times within 50 seconds before
	// throwing an exception.
	RetryAttemptSeconds *int64 `min:"1" type:"long"`

	// Target ID is the name of the public document.
	//
	// TargetId is a required field
	TargetId *string `min:"1" type:"string" required:"true"`

	// The type of the target. Target executes remediation. For example, SSM document.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"RemediationTargetType"`

	// Version of the target. For example, version of the SSM document.
	//
	// If you make backward incompatible changes to the SSM document, you must call
	// PutRemediationConfiguration API again to ensure the remediations can run.
	TargetVersion *string `type:"string"`
}

// String returns the string representation
func (s RemediationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemediationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemediationConfiguration"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.CreatedByService != nil && len(*s.CreatedByService) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatedByService", 1))
	}
	if s.MaximumAutomaticAttempts != nil && *s.MaximumAutomaticAttempts < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumAutomaticAttempts", 1))
	}
	if s.RetryAttemptSeconds != nil && *s.RetryAttemptSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetryAttemptSeconds", 1))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}
	if s.TargetId != nil && len(*s.TargetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetId", 1))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}
	if s.ExecutionControls != nil {
		if err := s.ExecutionControls.Validate(); err != nil {
			invalidParams.AddNested("ExecutionControls", err.(request.ErrInvalidParams))
		}
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RemediationConfiguration) SetArn(v string) *RemediationConfiguration {
	s.Arn = &v
	return s
}

// SetAutomatic sets the Automatic field's value.
func (s *RemediationConfiguration) SetAutomatic(v bool) *RemediationConfiguration {
	s.Automatic = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *RemediationConfiguration) SetConfigRuleName(v string) *RemediationConfiguration {
	s.ConfigRuleName = &v
	return s
}

// SetCreatedByService sets the CreatedByService field's value.
func (s *RemediationConfiguration) SetCreatedByService(v string) *RemediationConfiguration {
	s.CreatedByService = &v
	return s
}

// SetExecutionControls sets the ExecutionControls field's value.
func (s *RemediationConfiguration) SetExecutionControls(v *ExecutionControls) *RemediationConfiguration {
	s.ExecutionControls = v
	return s
}

// SetMaximumAutomaticAttempts sets the MaximumAutomaticAttempts field's value.
func (s *RemediationConfiguration) SetMaximumAutomaticAttempts(v int64) *RemediationConfiguration {
	s.MaximumAutomaticAttempts = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RemediationConfiguration) SetParameters(v map[string]*RemediationParameterValue) *RemediationConfiguration {
	s.Parameters = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RemediationConfiguration) SetResourceType(v string) *RemediationConfiguration {
	s.ResourceType = &v
	return s
}

// SetRetryAttemptSeconds sets the RetryAttemptSeconds field's value.
func (s *RemediationConfiguration) SetRetryAttemptSeconds(v int64) *RemediationConfiguration {
	s.RetryAttemptSeconds = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *RemediationConfiguration) SetTargetId(v string) *RemediationConfiguration {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *RemediationConfiguration) SetTargetType(v string) *RemediationConfiguration {
	s.TargetType = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *RemediationConfiguration) SetTargetVersion(v string) *RemediationConfiguration {
	s.TargetVersion = &v
	return s
}

// An object that represents the details about the remediation exception. The
// details include the rule name, an explanation of an exception, the time when
// the exception will be deleted, the resource ID, and resource type.
type RemediationException struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The time when the remediation exception will be deleted.
	ExpirationTime *time.Time `type:"timestamp"`

	// An explanation of an remediation exception.
	Message *string `min:"1" type:"string"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of a resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemediationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationException) GoString() string {
	return s.String()
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *RemediationException) SetConfigRuleName(v string) *RemediationException {
	s.ConfigRuleName = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *RemediationException) SetExpirationTime(v time.Time) *RemediationException {
	s.ExpirationTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RemediationException) SetMessage(v string) *RemediationException {
	s.Message = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *RemediationException) SetResourceId(v string) *RemediationException {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RemediationException) SetResourceType(v string) *RemediationException {
	s.ResourceType = &v
	return s
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
type RemediationExceptionResourceKey struct {
	_ struct{} `type:"structure"`

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string `min:"1" type:"string"`

	// The type of a resource.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RemediationExceptionResourceKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationExceptionResourceKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemediationExceptionResourceKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemediationExceptionResourceKey"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *RemediationExceptionResourceKey) SetResourceId(v string) *RemediationExceptionResourceKey {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RemediationExceptionResourceKey) SetResourceType(v string) *RemediationExceptionResourceKey {
	s.ResourceType = &v
	return s
}

// Provides details of the current status of the invoked remediation action
// for that resource.
type RemediationExecutionStatus struct {
	_ struct{} `type:"structure"`

	// Start time when the remediation was executed.
	InvocationTime *time.Time `type:"timestamp"`

	// The time when the remediation execution was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The details that identify a resource within AWS Config, including the resource
	// type and resource ID.
	ResourceKey *ResourceKey `type:"structure"`

	// ENUM of the values.
	State *string `type:"string" enum:"RemediationExecutionState"`

	// Details of every step.
	StepDetails []*RemediationExecutionStep `type:"list"`
}

// String returns the string representation
func (s RemediationExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationExecutionStatus) GoString() string {
	return s.String()
}

// SetInvocationTime sets the InvocationTime field's value.
func (s *RemediationExecutionStatus) SetInvocationTime(v time.Time) *RemediationExecutionStatus {
	s.InvocationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *RemediationExecutionStatus) SetLastUpdatedTime(v time.Time) *RemediationExecutionStatus {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceKey sets the ResourceKey field's value.
func (s *RemediationExecutionStatus) SetResourceKey(v *ResourceKey) *RemediationExecutionStatus {
	s.ResourceKey = v
	return s
}

// SetState sets the State field's value.
func (s *RemediationExecutionStatus) SetState(v string) *RemediationExecutionStatus {
	s.State = &v
	return s
}

// SetStepDetails sets the StepDetails field's value.
func (s *RemediationExecutionStatus) SetStepDetails(v []*RemediationExecutionStep) *RemediationExecutionStatus {
	s.StepDetails = v
	return s
}

// Name of the step from the SSM document.
type RemediationExecutionStep struct {
	_ struct{} `type:"structure"`

	// An error message if the step was interrupted during execution.
	ErrorMessage *string `type:"string"`

	// The details of the step.
	Name *string `type:"string"`

	// The time when the step started.
	StartTime *time.Time `type:"timestamp"`

	// The valid status of the step.
	State *string `type:"string" enum:"RemediationExecutionStepState"`

	// The time when the step stopped.
	StopTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s RemediationExecutionStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationExecutionStep) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RemediationExecutionStep) SetErrorMessage(v string) *RemediationExecutionStep {
	s.ErrorMessage = &v
	return s
}

// SetName sets the Name field's value.
func (s *RemediationExecutionStep) SetName(v string) *RemediationExecutionStep {
	s.Name = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RemediationExecutionStep) SetStartTime(v time.Time) *RemediationExecutionStep {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *RemediationExecutionStep) SetState(v string) *RemediationExecutionStep {
	s.State = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *RemediationExecutionStep) SetStopTime(v time.Time) *RemediationExecutionStep {
	s.StopTime = &v
	return s
}

// Remediation action is in progress. You can either cancel execution in AWS
// Systems Manager or wait and try again later.
type RemediationInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RemediationInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationInProgressException) GoString() string {
	return s.String()
}

func newErrorRemediationInProgressException(v protocol.ResponseMetadata) error {
	return &RemediationInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RemediationInProgressException) Code() string {
	return "RemediationInProgressException"
}

// Message returns the exception's message.
func (s *RemediationInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RemediationInProgressException) OrigErr() error {
	return nil
}

func (s *RemediationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RemediationInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RemediationInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value is either a dynamic (resource) value or a static value. You must
// select either a dynamic value or a static value.
type RemediationParameterValue struct {
	_ struct{} `type:"structure"`

	// The value is dynamic and changes at run-time.
	ResourceValue *ResourceValue `type:"structure"`

	// The value is static and does not change at run-time.
	StaticValue *StaticValue `type:"structure"`
}

// String returns the string representation
func (s RemediationParameterValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemediationParameterValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemediationParameterValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemediationParameterValue"}
	if s.ResourceValue != nil {
		if err := s.ResourceValue.Validate(); err != nil {
			invalidParams.AddNested("ResourceValue", err.(request.ErrInvalidParams))
		}
	}
	if s.StaticValue != nil {
		if err := s.StaticValue.Validate(); err != nil {
			invalidParams.AddNested("StaticValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceValue sets the ResourceValue field's value.
func (s *RemediationParameterValue) SetResourceValue(v *ResourceValue) *RemediationParameterValue {
	s.ResourceValue = v
	return s
}

// SetStaticValue sets the StaticValue field's value.
func (s *RemediationParameterValue) SetStaticValue(v *StaticValue) *RemediationParameterValue {
	s.StaticValue = v
	return s
}

// Two users are trying to modify the same query at the same time. Wait for
// a moment and try again.
type ResourceConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorResourceConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ResourceConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConcurrentModificationException) Code() string {
	return "ResourceConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ResourceConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ResourceConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains the resource type and the number of resources.
type ResourceCount struct {
	_ struct{} `type:"structure"`

	// The number of resources.
	Count *int64 `locationName:"count" type:"long"`

	// The resource type (for example, "AWS::EC2::Instance").
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCount) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ResourceCount) SetCount(v int64) *ResourceCount {
	s.Count = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceCount) SetResourceType(v string) *ResourceCount {
	s.ResourceType = &v
	return s
}

// Filters the resource count based on account ID, region, and resource type.
type ResourceCountFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit ID of the account.
	AccountId *string `type:"string"`

	// The region where the account is located.
	Region *string `min:"1" type:"string"`

	// The type of the AWS resource.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceCountFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCountFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceCountFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceCountFilters"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ResourceCountFilters) SetAccountId(v string) *ResourceCountFilters {
	s.AccountId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ResourceCountFilters) SetRegion(v string) *ResourceCountFilters {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceCountFilters) SetResourceType(v string) *ResourceCountFilters {
	s.ResourceType = &v
	return s
}

// Filters the results by resource account ID, region, resource ID, and resource
// name.
type ResourceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit source account ID.
	AccountId *string `type:"string"`

	// The source region.
	Region *string `min:"1" type:"string"`

	// The ID of the resource.
	ResourceId *string `min:"1" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`
}

// String returns the string representation
func (s ResourceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceFilters"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ResourceFilters) SetAccountId(v string) *ResourceFilters {
	s.AccountId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ResourceFilters) SetRegion(v string) *ResourceFilters {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceFilters) SetResourceId(v string) *ResourceFilters {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ResourceFilters) SetResourceName(v string) *ResourceFilters {
	s.ResourceName = &v
	return s
}

// The details that identify a resource that is discovered by AWS Config, including
// the resource type, ID, and (if available) the custom resource name.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The time that the resource was deleted.
	ResourceDeletionTime *time.Time `locationName:"resourceDeletionTime" type:"timestamp"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource (if available).
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceIdentifier) GoString() string {
	return s.String()
}

// SetResourceDeletionTime sets the ResourceDeletionTime field's value.
func (s *ResourceIdentifier) SetResourceDeletionTime(v time.Time) *ResourceIdentifier {
	s.ResourceDeletionTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceIdentifier) SetResourceId(v string) *ResourceIdentifier {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ResourceIdentifier) SetResourceName(v string) *ResourceIdentifier {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifier) SetResourceType(v string) *ResourceIdentifier {
	s.ResourceType = &v
	return s
}

// You see this exception in the following cases:
//
//    * For DeleteConfigRule, AWS Config is deleting this rule. Try your request
//    again later.
//
//    * For DeleteConfigRule, the rule is deleting your evaluation results.
//    Try your request again later.
//
//    * For DeleteConfigRule, a remediation action is associated with the rule
//    and AWS Config cannot delete this rule. Delete the remediation action
//    associated with the rule before deleting the rule and try your request
//    again later.
//
//    * For PutConfigOrganizationRule, organization config rule deletion is
//    in progress. Try your request again later.
//
//    * For DeleteOrganizationConfigRule, organization config rule creation
//    is in progress. Try your request again later.
//
//    * For PutConformancePack and PutOrganizationConformancePack, a conformance
//    pack creation, update, and deletion is in progress. Try your request again
//    later.
//
//    * For DeleteConformancePack, a conformance pack creation, update, and
//    deletion is in progress. Try your request again later.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
type ResourceKey struct {
	_ struct{} `type:"structure"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceKey"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceKey) SetResourceId(v string) *ResourceKey {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceKey) SetResourceType(v string) *ResourceKey {
	s.ResourceType = &v
	return s
}

// You have specified a resource that is either unknown or has not been discovered.
type ResourceNotDiscoveredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotDiscoveredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotDiscoveredException) GoString() string {
	return s.String()
}

func newErrorResourceNotDiscoveredException(v protocol.ResponseMetadata) error {
	return &ResourceNotDiscoveredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotDiscoveredException) Code() string {
	return "ResourceNotDiscoveredException"
}

// Message returns the exception's message.
func (s *ResourceNotDiscoveredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotDiscoveredException) OrigErr() error {
	return nil
}

func (s *ResourceNotDiscoveredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotDiscoveredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotDiscoveredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The dynamic value of the resource.
type ResourceValue struct {
	_ struct{} `type:"structure"`

	// The value is a resource ID.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" enum:"ResourceValueType"`
}

// String returns the string representation
func (s ResourceValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceValue"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *ResourceValue) SetValue(v string) *ResourceValue {
	s.Value = &v
	return s
}

// An object with the name of the retention configuration and the retention
// period in days. The object stores the configuration for data retention in
// AWS Config.
type RetentionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration object.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s RetentionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetentionConfiguration) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RetentionConfiguration) SetName(v string) *RetentionConfiguration {
	s.Name = &v
	return s
}

// SetRetentionPeriodInDays sets the RetentionPeriodInDays field's value.
func (s *RetentionConfiguration) SetRetentionPeriodInDays(v int64) *RetentionConfiguration {
	s.RetentionPeriodInDays = &v
	return s
}

// Defines which resources trigger an evaluation for an AWS Config rule. The
// scope can include one or more resource types, a combination of a tag key
// and value, or a combination of one resource type and one resource ID. Specify
// a scope to constrain which resources trigger an evaluation for a rule. Otherwise,
// evaluations for the rule are triggered when any resource in your recording
// group changes in configuration.
type Scope struct {
	_ struct{} `type:"structure"`

	// The ID of the only AWS resource that you want to trigger an evaluation for
	// the rule. If you specify a resource ID, you must specify one resource type
	// for ComplianceResourceTypes.
	ComplianceResourceId *string `min:"1" type:"string"`

	// The resource types of only those AWS resources that you want to trigger an
	// evaluation for the rule. You can only specify one type if you also specify
	// a resource ID for ComplianceResourceId.
	ComplianceResourceTypes []*string `type:"list"`

	// The tag key that is applied to only those AWS resources that you want to
	// trigger an evaluation for the rule.
	TagKey *string `min:"1" type:"string"`

	// The tag value applied to only those AWS resources that you want to trigger
	// an evaluation for the rule. If you specify a value for TagValue, you must
	// also specify a value for TagKey.
	TagValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scope) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scope) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scope"}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue != nil && len(*s.TagValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *Scope) SetComplianceResourceId(v string) *Scope {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceTypes sets the ComplianceResourceTypes field's value.
func (s *Scope) SetComplianceResourceTypes(v []*string) *Scope {
	s.ComplianceResourceTypes = v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *Scope) SetTagKey(v string) *Scope {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *Scope) SetTagValue(v string) *Scope {
	s.TagValue = &v
	return s
}

type SelectAggregateResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The SQL query SELECT command.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`

	// The maximum number of query results returned on each page.
	Limit *int64 `type:"integer"`

	// The maximum number of query results returned on each page. AWS Config also
	// allows the Limit request parameter.
	MaxResults *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SelectAggregateResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectAggregateResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectAggregateResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectAggregateResourceConfigInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *SelectAggregateResourceConfigInput) SetConfigurationAggregatorName(v string) *SelectAggregateResourceConfigInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *SelectAggregateResourceConfigInput) SetExpression(v string) *SelectAggregateResourceConfigInput {
	s.Expression = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *SelectAggregateResourceConfigInput) SetLimit(v int64) *SelectAggregateResourceConfigInput {
	s.Limit = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SelectAggregateResourceConfigInput) SetMaxResults(v int64) *SelectAggregateResourceConfigInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SelectAggregateResourceConfigInput) SetNextToken(v string) *SelectAggregateResourceConfigInput {
	s.NextToken = &v
	return s
}

type SelectAggregateResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Details about the query.
	QueryInfo *QueryInfo `type:"structure"`

	// Returns the results for the SQL query.
	Results []*string `type:"list"`
}

// String returns the string representation
func (s SelectAggregateResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectAggregateResourceConfigOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SelectAggregateResourceConfigOutput) SetNextToken(v string) *SelectAggregateResourceConfigOutput {
	s.NextToken = &v
	return s
}

// SetQueryInfo sets the QueryInfo field's value.
func (s *SelectAggregateResourceConfigOutput) SetQueryInfo(v *QueryInfo) *SelectAggregateResourceConfigOutput {
	s.QueryInfo = v
	return s
}

// SetResults sets the Results field's value.
func (s *SelectAggregateResourceConfigOutput) SetResults(v []*string) *SelectAggregateResourceConfigOutput {
	s.Results = v
	return s
}

type SelectResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The SQL query SELECT command.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`

	// The maximum number of query results returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SelectResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectResourceConfigInput"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *SelectResourceConfigInput) SetExpression(v string) *SelectResourceConfigInput {
	s.Expression = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *SelectResourceConfigInput) SetLimit(v int64) *SelectResourceConfigInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SelectResourceConfigInput) SetNextToken(v string) *SelectResourceConfigInput {
	s.NextToken = &v
	return s
}

type SelectResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns the QueryInfo object.
	QueryInfo *QueryInfo `type:"structure"`

	// Returns the results for the SQL query.
	Results []*string `type:"list"`
}

// String returns the string representation
func (s SelectResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectResourceConfigOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SelectResourceConfigOutput) SetNextToken(v string) *SelectResourceConfigOutput {
	s.NextToken = &v
	return s
}

// SetQueryInfo sets the QueryInfo field's value.
func (s *SelectResourceConfigOutput) SetQueryInfo(v *QueryInfo) *SelectResourceConfigOutput {
	s.QueryInfo = v
	return s
}

// SetResults sets the Results field's value.
func (s *SelectResourceConfigOutput) SetResults(v []*string) *SelectResourceConfigOutput {
	s.Results = v
	return s
}

// Provides the AWS Config rule owner (AWS or customer), the rule identifier,
// and the events that trigger the evaluation of your AWS resources.
type Source struct {
	_ struct{} `type:"structure"`

	// Indicates whether AWS or the customer owns and manages the AWS Config rule.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true" enum:"Owner"`

	// Provides the source and type of the event that causes AWS Config to evaluate
	// your AWS resources.
	SourceDetails []*SourceDetail `type:"list"`

	// For AWS Config managed rules, a predefined identifier from a list. For example,
	// IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see Using
	// AWS Managed Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	//
	// For custom rules, the identifier is the Amazon Resource Name (ARN) of the
	// rule's AWS Lambda function, such as arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SourceIdentifier != nil && len(*s.SourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwner sets the Owner field's value.
func (s *Source) SetOwner(v string) *Source {
	s.Owner = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *Source) SetSourceDetails(v []*SourceDetail) *Source {
	s.SourceDetails = v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Source) SetSourceIdentifier(v string) *Source {
	s.SourceIdentifier = &v
	return s
}

// Provides the source and the message types that trigger AWS Config to evaluate
// your AWS resources against a rule. It also provides the frequency with which
// you want AWS Config to run evaluations for the rule if the trigger type is
// periodic. You can specify the parameter values for SourceDetail only for
// custom rules.
type SourceDetail struct {
	_ struct{} `type:"structure"`

	// The source of the event, such as an AWS service, that triggers AWS Config
	// to evaluate your AWS resources.
	EventSource *string `type:"string" enum:"EventSource"`

	// The frequency at which you want AWS Config to run evaluations for a custom
	// rule with a periodic trigger. If you specify a value for MaximumExecutionFrequency,
	// then MessageType must use the ScheduledNotification value.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	//
	// Based on the valid value you choose, AWS Config runs evaluations once for
	// each valid value. For example, if you choose Three_Hours, AWS Config runs
	// evaluations once every three hours. In this case, Three_Hours is the frequency
	// of this rule.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// The type of notification that triggers AWS Config to run an evaluation for
	// a rule. You can specify the following notification types:
	//
	//    * ConfigurationItemChangeNotification - Triggers an evaluation when AWS
	//    Config delivers a configuration item as a result of a resource change.
	//
	//    * OversizedConfigurationItemChangeNotification - Triggers an evaluation
	//    when AWS Config delivers an oversized configuration item. AWS Config may
	//    generate this notification type when a resource changes and the notification
	//    exceeds the maximum size allowed by Amazon SNS.
	//
	//    * ScheduledNotification - Triggers a periodic evaluation at the frequency
	//    specified for MaximumExecutionFrequency.
	//
	//    * ConfigurationSnapshotDeliveryCompleted - Triggers a periodic evaluation
	//    when AWS Config delivers a configuration snapshot.
	//
	// If you want your custom rule to be triggered by configuration changes, specify
	// two SourceDetail objects, one for ConfigurationItemChangeNotification and
	// one for OversizedConfigurationItemChangeNotification.
	MessageType *string `type:"string" enum:"MessageType"`
}

// String returns the string representation
func (s SourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceDetail) GoString() string {
	return s.String()
}

// SetEventSource sets the EventSource field's value.
func (s *SourceDetail) SetEventSource(v string) *SourceDetail {
	s.EventSource = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *SourceDetail) SetMaximumExecutionFrequency(v string) *SourceDetail {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SourceDetail) SetMessageType(v string) *SourceDetail {
	s.MessageType = &v
	return s
}

// AWS Systems Manager (SSM) specific remediation controls.
type SsmControls struct {
	_ struct{} `type:"structure"`

	// The maximum percentage of remediation actions allowed to run in parallel
	// on the non-compliant resources for that specific rule. You can specify a
	// percentage, such as 10%. The default value is 10.
	ConcurrentExecutionRatePercentage *int64 `min:"1" type:"integer"`

	// The percentage of errors that are allowed before SSM stops running automations
	// on non-compliant resources for that specific rule. You can specify a percentage
	// of errors, for example 10%. If you do not specifiy a percentage, the default
	// is 50%. For example, if you set the ErrorPercentage to 40% for 10 non-compliant
	// resources, then SSM stops running the automations when the fifth error is
	// received.
	ErrorPercentage *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s SsmControls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SsmControls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SsmControls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SsmControls"}
	if s.ConcurrentExecutionRatePercentage != nil && *s.ConcurrentExecutionRatePercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConcurrentExecutionRatePercentage", 1))
	}
	if s.ErrorPercentage != nil && *s.ErrorPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ErrorPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConcurrentExecutionRatePercentage sets the ConcurrentExecutionRatePercentage field's value.
func (s *SsmControls) SetConcurrentExecutionRatePercentage(v int64) *SsmControls {
	s.ConcurrentExecutionRatePercentage = &v
	return s
}

// SetErrorPercentage sets the ErrorPercentage field's value.
func (s *SsmControls) SetErrorPercentage(v int64) *SsmControls {
	s.ErrorPercentage = &v
	return s
}

type StartConfigRulesEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The list of names of AWS Config rules that you want to run evaluations for.
	ConfigRuleNames []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigRulesEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConfigRulesEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartConfigRulesEvaluationInput"}
	if s.ConfigRuleNames != nil && len(s.ConfigRuleNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *StartConfigRulesEvaluationInput) SetConfigRuleNames(v []*string) *StartConfigRulesEvaluationInput {
	s.ConfigRuleNames = v
	return s
}

// The output when you start the evaluation for the specified AWS Config rule.
type StartConfigRulesEvaluationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigRulesEvaluationOutput) GoString() string {
	return s.String()
}

// The input for the StartConfigurationRecorder action.
type StartConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the recorder object that records each configuration change made
	// to the resources.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *StartConfigurationRecorderInput) SetConfigurationRecorderName(v string) *StartConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type StartConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigurationRecorderOutput) GoString() string {
	return s.String()
}

type StartRemediationExecutionInput struct {
	_ struct{} `type:"structure"`

	// The list of names of AWS Config rules that you want to run remediation execution
	// for.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	//
	// ResourceKeys is a required field
	ResourceKeys []*ResourceKey `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StartRemediationExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRemediationExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRemediationExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRemediationExecutionInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *StartRemediationExecutionInput) SetConfigRuleName(v string) *StartRemediationExecutionInput {
	s.ConfigRuleName = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *StartRemediationExecutionInput) SetResourceKeys(v []*ResourceKey) *StartRemediationExecutionInput {
	s.ResourceKeys = v
	return s
}

type StartRemediationExecutionOutput struct {
	_ struct{} `type:"structure"`

	// For resources that have failed to start execution, the API returns a resource
	// key object.
	FailedItems []*ResourceKey `min:"1" type:"list"`

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string `type:"string"`
}

// String returns the string representation
func (s StartRemediationExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRemediationExecutionOutput) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *StartRemediationExecutionOutput) SetFailedItems(v []*ResourceKey) *StartRemediationExecutionOutput {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *StartRemediationExecutionOutput) SetFailureMessage(v string) *StartRemediationExecutionOutput {
	s.FailureMessage = &v
	return s
}

// The static value of the resource.
type StaticValue struct {
	_ struct{} `type:"structure"`

	// A list of values. For example, the ARN of the assumed role.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s StaticValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticValue"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValues sets the Values field's value.
func (s *StaticValue) SetValues(v []*string) *StaticValue {
	s.Values = v
	return s
}

// Status filter object to filter results based on specific member account ID
// or status type for an organization config rule.
type StatusDetailFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the member account within an organization.
	AccountId *string `type:"string"`

	// Indicates deployment status for config rule in the member account. When master
	// account calls PutOrganizationConfigRule action for the first time, config
	// rule status is created in the member account. When master account calls PutOrganizationConfigRule
	// action for the second time, config rule status is updated in the member account.
	// Config rule status is deleted when the master account deletes OrganizationConfigRule
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// AWS Config sets the state of the rule to:
	//
	//    * CREATE_SUCCESSFUL when config rule has been created in the member account.
	//
	//    * CREATE_IN_PROGRESS when config rule is being created in the member account.
	//
	//    * CREATE_FAILED when config rule creation has failed in the member account.
	//
	//    * DELETE_FAILED when config rule deletion has failed in the member account.
	//
	//    * DELETE_IN_PROGRESS when config rule is being deleted in the member account.
	//
	//    * DELETE_SUCCESSFUL when config rule has been deleted in the member account.
	//
	//    * UPDATE_SUCCESSFUL when config rule has been updated in the member account.
	//
	//    * UPDATE_IN_PROGRESS when config rule is being updated in the member account.
	//
	//    * UPDATE_FAILED when config rule deletion has failed in the member account.
	MemberAccountRuleStatus *string `type:"string" enum:"MemberAccountRuleStatus"`
}

// String returns the string representation
func (s StatusDetailFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusDetailFilters) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *StatusDetailFilters) SetAccountId(v string) *StatusDetailFilters {
	s.AccountId = &v
	return s
}

// SetMemberAccountRuleStatus sets the MemberAccountRuleStatus field's value.
func (s *StatusDetailFilters) SetMemberAccountRuleStatus(v string) *StatusDetailFilters {
	s.MemberAccountRuleStatus = &v
	return s
}

// The input for the StopConfigurationRecorder action.
type StopConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the recorder object that records each configuration change made
	// to the resources.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *StopConfigurationRecorderInput) SetConfigurationRecorderName(v string) *StopConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type StopConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopConfigurationRecorderOutput) GoString() string {
	return s.String()
}

// Provides the details of a stored query.
type StoredQuery struct {
	_ struct{} `type:"structure"`

	// A unique description for the query.
	Description *string `type:"string"`

	// The expression of the query. For example, SELECT resourceId, resourceType,
	// supplementaryConfiguration.BucketVersioningConfiguration.status WHERE resourceType
	// = 'AWS::S3::Bucket' AND supplementaryConfiguration.BucketVersioningConfiguration.status
	// = 'Off'.
	Expression *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	QueryArn *string `min:"1" type:"string"`

	// The ID of the query.
	QueryId *string `min:"1" type:"string"`

	// The name of the query.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StoredQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StoredQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StoredQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StoredQuery"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.QueryArn != nil && len(*s.QueryArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryArn", 1))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}
	if s.QueryName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryName"))
	}
	if s.QueryName != nil && len(*s.QueryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StoredQuery) SetDescription(v string) *StoredQuery {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *StoredQuery) SetExpression(v string) *StoredQuery {
	s.Expression = &v
	return s
}

// SetQueryArn sets the QueryArn field's value.
func (s *StoredQuery) SetQueryArn(v string) *StoredQuery {
	s.QueryArn = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *StoredQuery) SetQueryId(v string) *StoredQuery {
	s.QueryId = &v
	return s
}

// SetQueryName sets the QueryName field's value.
func (s *StoredQuery) SetQueryName(v string) *StoredQuery {
	s.QueryName = &v
	return s
}

// Returns details of a specific query.
type StoredQueryMetadata struct {
	_ struct{} `type:"structure"`

	// A unique description for the query.
	Description *string `type:"string"`

	// Amazon Resource Name (ARN) of the query. For example, arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
	//
	// QueryArn is a required field
	QueryArn *string `min:"1" type:"string" required:"true"`

	// The ID of the query.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// The name of the query.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StoredQueryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StoredQueryMetadata) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StoredQueryMetadata) SetDescription(v string) *StoredQueryMetadata {
	s.Description = &v
	return s
}

// SetQueryArn sets the QueryArn field's value.
func (s *StoredQueryMetadata) SetQueryArn(v string) *StoredQueryMetadata {
	s.QueryArn = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *StoredQueryMetadata) SetQueryId(v string) *StoredQueryMetadata {
	s.QueryId = &v
	return s
}

// SetQueryName sets the QueryName field's value.
func (s *StoredQueryMetadata) SetQueryName(v string) *StoredQueryMetadata {
	s.QueryName = &v
	return s
}

// The tags for the resource. The metadata that you apply to a resource to help
// you categorize and organize them. Each tag consists of a key and an optional
// value, both of which you define. Tag keys can have a maximum character length
// of 128 characters, and tag values can have a maximum length of 256 characters.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
	// and AggregatorAuthorization.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// An array of tag object.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// You have reached the limit of the number of tags you can use. You have more
// than 50 tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
	// and AggregatorAuthorization.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The requested action is not valid.
//
// For PutStoredQuery, you will see this exception if there are missing required
// fields or if the input value fails the validation, or if you are trying to
// create more than 300 queries.
//
// For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
// exception if there are missing required fields or if the input value fails
// the validation.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AggregateConformancePackComplianceSummaryGroupKeyAccountId is a AggregateConformancePackComplianceSummaryGroupKey enum value
	AggregateConformancePackComplianceSummaryGroupKeyAccountId = "ACCOUNT_ID"

	// AggregateConformancePackComplianceSummaryGroupKeyAwsRegion is a AggregateConformancePackComplianceSummaryGroupKey enum value
	AggregateConformancePackComplianceSummaryGroupKeyAwsRegion = "AWS_REGION"
)

// AggregateConformancePackComplianceSummaryGroupKey_Values returns all elements of the AggregateConformancePackComplianceSummaryGroupKey enum
func AggregateConformancePackComplianceSummaryGroupKey_Values() []string {
	return []string{
		AggregateConformancePackComplianceSummaryGroupKeyAccountId,
		AggregateConformancePackComplianceSummaryGroupKeyAwsRegion,
	}
}

const (
	// AggregatedSourceStatusTypeFailed is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeFailed = "FAILED"

	// AggregatedSourceStatusTypeSucceeded is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeSucceeded = "SUCCEEDED"

	// AggregatedSourceStatusTypeOutdated is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeOutdated = "OUTDATED"
)

// AggregatedSourceStatusType_Values returns all elements of the AggregatedSourceStatusType enum
func AggregatedSourceStatusType_Values() []string {
	return []string{
		AggregatedSourceStatusTypeFailed,
		AggregatedSourceStatusTypeSucceeded,
		AggregatedSourceStatusTypeOutdated,
	}
}

const (
	// AggregatedSourceTypeAccount is a AggregatedSourceType enum value
	AggregatedSourceTypeAccount = "ACCOUNT"

	// AggregatedSourceTypeOrganization is a AggregatedSourceType enum value
	AggregatedSourceTypeOrganization = "ORGANIZATION"
)

// AggregatedSourceType_Values returns all elements of the AggregatedSourceType enum
func AggregatedSourceType_Values() []string {
	return []string{
		AggregatedSourceTypeAccount,
		AggregatedSourceTypeOrganization,
	}
}

const (
	// ChronologicalOrderReverse is a ChronologicalOrder enum value
	ChronologicalOrderReverse = "Reverse"

	// ChronologicalOrderForward is a ChronologicalOrder enum value
	ChronologicalOrderForward = "Forward"
)

// ChronologicalOrder_Values returns all elements of the ChronologicalOrder enum
func ChronologicalOrder_Values() []string {
	return []string{
		ChronologicalOrderReverse,
		ChronologicalOrderForward,
	}
}

const (
	// ComplianceTypeCompliant is a ComplianceType enum value
	ComplianceTypeCompliant = "COMPLIANT"

	// ComplianceTypeNonCompliant is a ComplianceType enum value
	ComplianceTypeNonCompliant = "NON_COMPLIANT"

	// ComplianceTypeNotApplicable is a ComplianceType enum value
	ComplianceTypeNotApplicable = "NOT_APPLICABLE"

	// ComplianceTypeInsufficientData is a ComplianceType enum value
	ComplianceTypeInsufficientData = "INSUFFICIENT_DATA"
)

// ComplianceType_Values returns all elements of the ComplianceType enum
func ComplianceType_Values() []string {
	return []string{
		ComplianceTypeCompliant,
		ComplianceTypeNonCompliant,
		ComplianceTypeNotApplicable,
		ComplianceTypeInsufficientData,
	}
}

const (
	// ConfigRuleComplianceSummaryGroupKeyAccountId is a ConfigRuleComplianceSummaryGroupKey enum value
	ConfigRuleComplianceSummaryGroupKeyAccountId = "ACCOUNT_ID"

	// ConfigRuleComplianceSummaryGroupKeyAwsRegion is a ConfigRuleComplianceSummaryGroupKey enum value
	ConfigRuleComplianceSummaryGroupKeyAwsRegion = "AWS_REGION"
)

// ConfigRuleComplianceSummaryGroupKey_Values returns all elements of the ConfigRuleComplianceSummaryGroupKey enum
func ConfigRuleComplianceSummaryGroupKey_Values() []string {
	return []string{
		ConfigRuleComplianceSummaryGroupKeyAccountId,
		ConfigRuleComplianceSummaryGroupKeyAwsRegion,
	}
}

const (
	// ConfigRuleStateActive is a ConfigRuleState enum value
	ConfigRuleStateActive = "ACTIVE"

	// ConfigRuleStateDeleting is a ConfigRuleState enum value
	ConfigRuleStateDeleting = "DELETING"

	// ConfigRuleStateDeletingResults is a ConfigRuleState enum value
	ConfigRuleStateDeletingResults = "DELETING_RESULTS"

	// ConfigRuleStateEvaluating is a ConfigRuleState enum value
	ConfigRuleStateEvaluating = "EVALUATING"
)

// ConfigRuleState_Values returns all elements of the ConfigRuleState enum
func ConfigRuleState_Values() []string {
	return []string{
		ConfigRuleStateActive,
		ConfigRuleStateDeleting,
		ConfigRuleStateDeletingResults,
		ConfigRuleStateEvaluating,
	}
}

const (
	// ConfigurationItemStatusOk is a ConfigurationItemStatus enum value
	ConfigurationItemStatusOk = "OK"

	// ConfigurationItemStatusResourceDiscovered is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDiscovered = "ResourceDiscovered"

	// ConfigurationItemStatusResourceNotRecorded is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceNotRecorded = "ResourceNotRecorded"

	// ConfigurationItemStatusResourceDeleted is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDeleted = "ResourceDeleted"

	// ConfigurationItemStatusResourceDeletedNotRecorded is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDeletedNotRecorded = "ResourceDeletedNotRecorded"
)

// ConfigurationItemStatus_Values returns all elements of the ConfigurationItemStatus enum
func ConfigurationItemStatus_Values() []string {
	return []string{
		ConfigurationItemStatusOk,
		ConfigurationItemStatusResourceDiscovered,
		ConfigurationItemStatusResourceNotRecorded,
		ConfigurationItemStatusResourceDeleted,
		ConfigurationItemStatusResourceDeletedNotRecorded,
	}
}

const (
	// ConformancePackComplianceTypeCompliant is a ConformancePackComplianceType enum value
	ConformancePackComplianceTypeCompliant = "COMPLIANT"

	// ConformancePackComplianceTypeNonCompliant is a ConformancePackComplianceType enum value
	ConformancePackComplianceTypeNonCompliant = "NON_COMPLIANT"

	// ConformancePackComplianceTypeInsufficientData is a ConformancePackComplianceType enum value
	ConformancePackComplianceTypeInsufficientData = "INSUFFICIENT_DATA"
)

// ConformancePackComplianceType_Values returns all elements of the ConformancePackComplianceType enum
func ConformancePackComplianceType_Values() []string {
	return []string{
		ConformancePackComplianceTypeCompliant,
		ConformancePackComplianceTypeNonCompliant,
		ConformancePackComplianceTypeInsufficientData,
	}
}

const (
	// ConformancePackStateCreateInProgress is a ConformancePackState enum value
	ConformancePackStateCreateInProgress = "CREATE_IN_PROGRESS"

	// ConformancePackStateCreateComplete is a ConformancePackState enum value
	ConformancePackStateCreateComplete = "CREATE_COMPLETE"

	// ConformancePackStateCreateFailed is a ConformancePackState enum value
	ConformancePackStateCreateFailed = "CREATE_FAILED"

	// ConformancePackStateDeleteInProgress is a ConformancePackState enum value
	ConformancePackStateDeleteInProgress = "DELETE_IN_PROGRESS"

	// ConformancePackStateDeleteFailed is a ConformancePackState enum value
	ConformancePackStateDeleteFailed = "DELETE_FAILED"
)

// ConformancePackState_Values returns all elements of the ConformancePackState enum
func ConformancePackState_Values() []string {
	return []string{
		ConformancePackStateCreateInProgress,
		ConformancePackStateCreateComplete,
		ConformancePackStateCreateFailed,
		ConformancePackStateDeleteInProgress,
		ConformancePackStateDeleteFailed,
	}
}

const (
	// DeliveryStatusSuccess is a DeliveryStatus enum value
	DeliveryStatusSuccess = "Success"

	// DeliveryStatusFailure is a DeliveryStatus enum value
	DeliveryStatusFailure = "Failure"

	// DeliveryStatusNotApplicable is a DeliveryStatus enum value
	DeliveryStatusNotApplicable = "Not_Applicable"
)

// DeliveryStatus_Values returns all elements of the DeliveryStatus enum
func DeliveryStatus_Values() []string {
	return []string{
		DeliveryStatusSuccess,
		DeliveryStatusFailure,
		DeliveryStatusNotApplicable,
	}
}

const (
	// EventSourceAwsConfig is a EventSource enum value
	EventSourceAwsConfig = "aws.config"
)

// EventSource_Values returns all elements of the EventSource enum
func EventSource_Values() []string {
	return []string{
		EventSourceAwsConfig,
	}
}

const (
	// MaximumExecutionFrequencyOneHour is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyOneHour = "One_Hour"

	// MaximumExecutionFrequencyThreeHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyThreeHours = "Three_Hours"

	// MaximumExecutionFrequencySixHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencySixHours = "Six_Hours"

	// MaximumExecutionFrequencyTwelveHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyTwelveHours = "Twelve_Hours"

	// MaximumExecutionFrequencyTwentyFourHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyTwentyFourHours = "TwentyFour_Hours"
)

// MaximumExecutionFrequency_Values returns all elements of the MaximumExecutionFrequency enum
func MaximumExecutionFrequency_Values() []string {
	return []string{
		MaximumExecutionFrequencyOneHour,
		MaximumExecutionFrequencyThreeHours,
		MaximumExecutionFrequencySixHours,
		MaximumExecutionFrequencyTwelveHours,
		MaximumExecutionFrequencyTwentyFourHours,
	}
}

const (
	// MemberAccountRuleStatusCreateSuccessful is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusCreateSuccessful = "CREATE_SUCCESSFUL"

	// MemberAccountRuleStatusCreateInProgress is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// MemberAccountRuleStatusCreateFailed is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusCreateFailed = "CREATE_FAILED"

	// MemberAccountRuleStatusDeleteSuccessful is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusDeleteSuccessful = "DELETE_SUCCESSFUL"

	// MemberAccountRuleStatusDeleteFailed is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusDeleteFailed = "DELETE_FAILED"

	// MemberAccountRuleStatusDeleteInProgress is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// MemberAccountRuleStatusUpdateSuccessful is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusUpdateSuccessful = "UPDATE_SUCCESSFUL"

	// MemberAccountRuleStatusUpdateInProgress is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// MemberAccountRuleStatusUpdateFailed is a MemberAccountRuleStatus enum value
	MemberAccountRuleStatusUpdateFailed = "UPDATE_FAILED"
)

// MemberAccountRuleStatus_Values returns all elements of the MemberAccountRuleStatus enum
func MemberAccountRuleStatus_Values() []string {
	return []string{
		MemberAccountRuleStatusCreateSuccessful,
		MemberAccountRuleStatusCreateInProgress,
		MemberAccountRuleStatusCreateFailed,
		MemberAccountRuleStatusDeleteSuccessful,
		MemberAccountRuleStatusDeleteFailed,
		MemberAccountRuleStatusDeleteInProgress,
		MemberAccountRuleStatusUpdateSuccessful,
		MemberAccountRuleStatusUpdateInProgress,
		MemberAccountRuleStatusUpdateFailed,
	}
}

const (
	// MessageTypeConfigurationItemChangeNotification is a MessageType enum value
	MessageTypeConfigurationItemChangeNotification = "ConfigurationItemChangeNotification"

	// MessageTypeConfigurationSnapshotDeliveryCompleted is a MessageType enum value
	MessageTypeConfigurationSnapshotDeliveryCompleted = "ConfigurationSnapshotDeliveryCompleted"

	// MessageTypeScheduledNotification is a MessageType enum value
	MessageTypeScheduledNotification = "ScheduledNotification"

	// MessageTypeOversizedConfigurationItemChangeNotification is a MessageType enum value
	MessageTypeOversizedConfigurationItemChangeNotification = "OversizedConfigurationItemChangeNotification"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeConfigurationItemChangeNotification,
		MessageTypeConfigurationSnapshotDeliveryCompleted,
		MessageTypeScheduledNotification,
		MessageTypeOversizedConfigurationItemChangeNotification,
	}
}

const (
	// OrganizationConfigRuleTriggerTypeConfigurationItemChangeNotification is a OrganizationConfigRuleTriggerType enum value
	OrganizationConfigRuleTriggerTypeConfigurationItemChangeNotification = "ConfigurationItemChangeNotification"

	// OrganizationConfigRuleTriggerTypeOversizedConfigurationItemChangeNotification is a OrganizationConfigRuleTriggerType enum value
	OrganizationConfigRuleTriggerTypeOversizedConfigurationItemChangeNotification = "OversizedConfigurationItemChangeNotification"

	// OrganizationConfigRuleTriggerTypeScheduledNotification is a OrganizationConfigRuleTriggerType enum value
	OrganizationConfigRuleTriggerTypeScheduledNotification = "ScheduledNotification"
)

// OrganizationConfigRuleTriggerType_Values returns all elements of the OrganizationConfigRuleTriggerType enum
func OrganizationConfigRuleTriggerType_Values() []string {
	return []string{
		OrganizationConfigRuleTriggerTypeConfigurationItemChangeNotification,
		OrganizationConfigRuleTriggerTypeOversizedConfigurationItemChangeNotification,
		OrganizationConfigRuleTriggerTypeScheduledNotification,
	}
}

const (
	// OrganizationResourceDetailedStatusCreateSuccessful is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusCreateSuccessful = "CREATE_SUCCESSFUL"

	// OrganizationResourceDetailedStatusCreateInProgress is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// OrganizationResourceDetailedStatusCreateFailed is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusCreateFailed = "CREATE_FAILED"

	// OrganizationResourceDetailedStatusDeleteSuccessful is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusDeleteSuccessful = "DELETE_SUCCESSFUL"

	// OrganizationResourceDetailedStatusDeleteFailed is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusDeleteFailed = "DELETE_FAILED"

	// OrganizationResourceDetailedStatusDeleteInProgress is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// OrganizationResourceDetailedStatusUpdateSuccessful is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusUpdateSuccessful = "UPDATE_SUCCESSFUL"

	// OrganizationResourceDetailedStatusUpdateInProgress is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// OrganizationResourceDetailedStatusUpdateFailed is a OrganizationResourceDetailedStatus enum value
	OrganizationResourceDetailedStatusUpdateFailed = "UPDATE_FAILED"
)

// OrganizationResourceDetailedStatus_Values returns all elements of the OrganizationResourceDetailedStatus enum
func OrganizationResourceDetailedStatus_Values() []string {
	return []string{
		OrganizationResourceDetailedStatusCreateSuccessful,
		OrganizationResourceDetailedStatusCreateInProgress,
		OrganizationResourceDetailedStatusCreateFailed,
		OrganizationResourceDetailedStatusDeleteSuccessful,
		OrganizationResourceDetailedStatusDeleteFailed,
		OrganizationResourceDetailedStatusDeleteInProgress,
		OrganizationResourceDetailedStatusUpdateSuccessful,
		OrganizationResourceDetailedStatusUpdateInProgress,
		OrganizationResourceDetailedStatusUpdateFailed,
	}
}

const (
	// OrganizationResourceStatusCreateSuccessful is a OrganizationResourceStatus enum value
	OrganizationResourceStatusCreateSuccessful = "CREATE_SUCCESSFUL"

	// OrganizationResourceStatusCreateInProgress is a OrganizationResourceStatus enum value
	OrganizationResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// OrganizationResourceStatusCreateFailed is a OrganizationResourceStatus enum value
	OrganizationResourceStatusCreateFailed = "CREATE_FAILED"

	// OrganizationResourceStatusDeleteSuccessful is a OrganizationResourceStatus enum value
	OrganizationResourceStatusDeleteSuccessful = "DELETE_SUCCESSFUL"

	// OrganizationResourceStatusDeleteFailed is a OrganizationResourceStatus enum value
	OrganizationResourceStatusDeleteFailed = "DELETE_FAILED"

	// OrganizationResourceStatusDeleteInProgress is a OrganizationResourceStatus enum value
	OrganizationResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// OrganizationResourceStatusUpdateSuccessful is a OrganizationResourceStatus enum value
	OrganizationResourceStatusUpdateSuccessful = "UPDATE_SUCCESSFUL"

	// OrganizationResourceStatusUpdateInProgress is a OrganizationResourceStatus enum value
	OrganizationResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// OrganizationResourceStatusUpdateFailed is a OrganizationResourceStatus enum value
	OrganizationResourceStatusUpdateFailed = "UPDATE_FAILED"
)

// OrganizationResourceStatus_Values returns all elements of the OrganizationResourceStatus enum
func OrganizationResourceStatus_Values() []string {
	return []string{
		OrganizationResourceStatusCreateSuccessful,
		OrganizationResourceStatusCreateInProgress,
		OrganizationResourceStatusCreateFailed,
		OrganizationResourceStatusDeleteSuccessful,
		OrganizationResourceStatusDeleteFailed,
		OrganizationResourceStatusDeleteInProgress,
		OrganizationResourceStatusUpdateSuccessful,
		OrganizationResourceStatusUpdateInProgress,
		OrganizationResourceStatusUpdateFailed,
	}
}

const (
	// OrganizationRuleStatusCreateSuccessful is a OrganizationRuleStatus enum value
	OrganizationRuleStatusCreateSuccessful = "CREATE_SUCCESSFUL"

	// OrganizationRuleStatusCreateInProgress is a OrganizationRuleStatus enum value
	OrganizationRuleStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// OrganizationRuleStatusCreateFailed is a OrganizationRuleStatus enum value
	OrganizationRuleStatusCreateFailed = "CREATE_FAILED"

	// OrganizationRuleStatusDeleteSuccessful is a OrganizationRuleStatus enum value
	OrganizationRuleStatusDeleteSuccessful = "DELETE_SUCCESSFUL"

	// OrganizationRuleStatusDeleteFailed is a OrganizationRuleStatus enum value
	OrganizationRuleStatusDeleteFailed = "DELETE_FAILED"

	// OrganizationRuleStatusDeleteInProgress is a OrganizationRuleStatus enum value
	OrganizationRuleStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// OrganizationRuleStatusUpdateSuccessful is a OrganizationRuleStatus enum value
	OrganizationRuleStatusUpdateSuccessful = "UPDATE_SUCCESSFUL"

	// OrganizationRuleStatusUpdateInProgress is a OrganizationRuleStatus enum value
	OrganizationRuleStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// OrganizationRuleStatusUpdateFailed is a OrganizationRuleStatus enum value
	OrganizationRuleStatusUpdateFailed = "UPDATE_FAILED"
)

// OrganizationRuleStatus_Values returns all elements of the OrganizationRuleStatus enum
func OrganizationRuleStatus_Values() []string {
	return []string{
		OrganizationRuleStatusCreateSuccessful,
		OrganizationRuleStatusCreateInProgress,
		OrganizationRuleStatusCreateFailed,
		OrganizationRuleStatusDeleteSuccessful,
		OrganizationRuleStatusDeleteFailed,
		OrganizationRuleStatusDeleteInProgress,
		OrganizationRuleStatusUpdateSuccessful,
		OrganizationRuleStatusUpdateInProgress,
		OrganizationRuleStatusUpdateFailed,
	}
}

const (
	// OwnerCustomLambda is a Owner enum value
	OwnerCustomLambda = "CUSTOM_LAMBDA"

	// OwnerAws is a Owner enum value
	OwnerAws = "AWS"
)

// Owner_Values returns all elements of the Owner enum
func Owner_Values() []string {
	return []string{
		OwnerCustomLambda,
		OwnerAws,
	}
}

const (
	// RecorderStatusPending is a RecorderStatus enum value
	RecorderStatusPending = "Pending"

	// RecorderStatusSuccess is a RecorderStatus enum value
	RecorderStatusSuccess = "Success"

	// RecorderStatusFailure is a RecorderStatus enum value
	RecorderStatusFailure = "Failure"
)

// RecorderStatus_Values returns all elements of the RecorderStatus enum
func RecorderStatus_Values() []string {
	return []string{
		RecorderStatusPending,
		RecorderStatusSuccess,
		RecorderStatusFailure,
	}
}

const (
	// RemediationExecutionStateQueued is a RemediationExecutionState enum value
	RemediationExecutionStateQueued = "QUEUED"

	// RemediationExecutionStateInProgress is a RemediationExecutionState enum value
	RemediationExecutionStateInProgress = "IN_PROGRESS"

	// RemediationExecutionStateSucceeded is a RemediationExecutionState enum value
	RemediationExecutionStateSucceeded = "SUCCEEDED"

	// RemediationExecutionStateFailed is a RemediationExecutionState enum value
	RemediationExecutionStateFailed = "FAILED"
)

// RemediationExecutionState_Values returns all elements of the RemediationExecutionState enum
func RemediationExecutionState_Values() []string {
	return []string{
		RemediationExecutionStateQueued,
		RemediationExecutionStateInProgress,
		RemediationExecutionStateSucceeded,
		RemediationExecutionStateFailed,
	}
}

const (
	// RemediationExecutionStepStateSucceeded is a RemediationExecutionStepState enum value
	RemediationExecutionStepStateSucceeded = "SUCCEEDED"

	// RemediationExecutionStepStatePending is a RemediationExecutionStepState enum value
	RemediationExecutionStepStatePending = "PENDING"

	// RemediationExecutionStepStateFailed is a RemediationExecutionStepState enum value
	RemediationExecutionStepStateFailed = "FAILED"
)

// RemediationExecutionStepState_Values returns all elements of the RemediationExecutionStepState enum
func RemediationExecutionStepState_Values() []string {
	return []string{
		RemediationExecutionStepStateSucceeded,
		RemediationExecutionStepStatePending,
		RemediationExecutionStepStateFailed,
	}
}

const (
	// RemediationTargetTypeSsmDocument is a RemediationTargetType enum value
	RemediationTargetTypeSsmDocument = "SSM_DOCUMENT"
)

// RemediationTargetType_Values returns all elements of the RemediationTargetType enum
func RemediationTargetType_Values() []string {
	return []string{
		RemediationTargetTypeSsmDocument,
	}
}

const (
	// ResourceCountGroupKeyResourceType is a ResourceCountGroupKey enum value
	ResourceCountGroupKeyResourceType = "RESOURCE_TYPE"

	// ResourceCountGroupKeyAccountId is a ResourceCountGroupKey enum value
	ResourceCountGroupKeyAccountId = "ACCOUNT_ID"

	// ResourceCountGroupKeyAwsRegion is a ResourceCountGroupKey enum value
	ResourceCountGroupKeyAwsRegion = "AWS_REGION"
)

// ResourceCountGroupKey_Values returns all elements of the ResourceCountGroupKey enum
func ResourceCountGroupKey_Values() []string {
	return []string{
		ResourceCountGroupKeyResourceType,
		ResourceCountGroupKeyAccountId,
		ResourceCountGroupKeyAwsRegion,
	}
}

const (
	// ResourceTypeAwsEc2CustomerGateway is a ResourceType enum value
	ResourceTypeAwsEc2CustomerGateway = "AWS::EC2::CustomerGateway"

	// ResourceTypeAwsEc2Eip is a ResourceType enum value
	ResourceTypeAwsEc2Eip = "AWS::EC2::EIP"

	// ResourceTypeAwsEc2Host is a ResourceType enum value
	ResourceTypeAwsEc2Host = "AWS::EC2::Host"

	// ResourceTypeAwsEc2Instance is a ResourceType enum value
	ResourceTypeAwsEc2Instance = "AWS::EC2::Instance"

	// ResourceTypeAwsEc2InternetGateway is a ResourceType enum value
	ResourceTypeAwsEc2InternetGateway = "AWS::EC2::InternetGateway"

	// ResourceTypeAwsEc2NetworkAcl is a ResourceType enum value
	ResourceTypeAwsEc2NetworkAcl = "AWS::EC2::NetworkAcl"

	// ResourceTypeAwsEc2NetworkInterface is a ResourceType enum value
	ResourceTypeAwsEc2NetworkInterface = "AWS::EC2::NetworkInterface"

	// ResourceTypeAwsEc2RouteTable is a ResourceType enum value
	ResourceTypeAwsEc2RouteTable = "AWS::EC2::RouteTable"

	// ResourceTypeAwsEc2SecurityGroup is a ResourceType enum value
	ResourceTypeAwsEc2SecurityGroup = "AWS::EC2::SecurityGroup"

	// ResourceTypeAwsEc2Subnet is a ResourceType enum value
	ResourceTypeAwsEc2Subnet = "AWS::EC2::Subnet"

	// ResourceTypeAwsCloudTrailTrail is a ResourceType enum value
	ResourceTypeAwsCloudTrailTrail = "AWS::CloudTrail::Trail"

	// ResourceTypeAwsEc2Volume is a ResourceType enum value
	ResourceTypeAwsEc2Volume = "AWS::EC2::Volume"

	// ResourceTypeAwsEc2Vpc is a ResourceType enum value
	ResourceTypeAwsEc2Vpc = "AWS::EC2::VPC"

	// ResourceTypeAwsEc2Vpnconnection is a ResourceType enum value
	ResourceTypeAwsEc2Vpnconnection = "AWS::EC2::VPNConnection"

	// ResourceTypeAwsEc2Vpngateway is a ResourceType enum value
	ResourceTypeAwsEc2Vpngateway = "AWS::EC2::VPNGateway"

	// ResourceTypeAwsEc2RegisteredHainstance is a ResourceType enum value
	ResourceTypeAwsEc2RegisteredHainstance = "AWS::EC2::RegisteredHAInstance"

	// ResourceTypeAwsEc2NatGateway is a ResourceType enum value
	ResourceTypeAwsEc2NatGateway = "AWS::EC2::NatGateway"

	// ResourceTypeAwsEc2EgressOnlyInternetGateway is a ResourceType enum value
	ResourceTypeAwsEc2EgressOnlyInternetGateway = "AWS::EC2::EgressOnlyInternetGateway"

	// ResourceTypeAwsEc2Vpcendpoint is a ResourceType enum value
	ResourceTypeAwsEc2Vpcendpoint = "AWS::EC2::VPCEndpoint"

	// ResourceTypeAwsEc2VpcendpointService is a ResourceType enum value
	ResourceTypeAwsEc2VpcendpointService = "AWS::EC2::VPCEndpointService"

	// ResourceTypeAwsEc2FlowLog is a ResourceType enum value
	ResourceTypeAwsEc2FlowLog = "AWS::EC2::FlowLog"

	// ResourceTypeAwsEc2VpcpeeringConnection is a ResourceType enum value
	ResourceTypeAwsEc2VpcpeeringConnection = "AWS::EC2::VPCPeeringConnection"

	// ResourceTypeAwsElasticsearchDomain is a ResourceType enum value
	ResourceTypeAwsElasticsearchDomain = "AWS::Elasticsearch::Domain"

	// ResourceTypeAwsIamGroup is a ResourceType enum value
	ResourceTypeAwsIamGroup = "AWS::IAM::Group"

	// ResourceTypeAwsIamPolicy is a ResourceType enum value
	ResourceTypeAwsIamPolicy = "AWS::IAM::Policy"

	// ResourceTypeAwsIamRole is a ResourceType enum value
	ResourceTypeAwsIamRole = "AWS::IAM::Role"

	// ResourceTypeAwsIamUser is a ResourceType enum value
	ResourceTypeAwsIamUser = "AWS::IAM::User"

	// ResourceTypeAwsElasticLoadBalancingV2LoadBalancer is a ResourceType enum value
	ResourceTypeAwsElasticLoadBalancingV2LoadBalancer = "AWS::ElasticLoadBalancingV2::LoadBalancer"

	// ResourceTypeAwsAcmCertificate is a ResourceType enum value
	ResourceTypeAwsAcmCertificate = "AWS::ACM::Certificate"

	// ResourceTypeAwsRdsDbinstance is a ResourceType enum value
	ResourceTypeAwsRdsDbinstance = "AWS::RDS::DBInstance"

	// ResourceTypeAwsRdsDbsubnetGroup is a ResourceType enum value
	ResourceTypeAwsRdsDbsubnetGroup = "AWS::RDS::DBSubnetGroup"

	// ResourceTypeAwsRdsDbsecurityGroup is a ResourceType enum value
	ResourceTypeAwsRdsDbsecurityGroup = "AWS::RDS::DBSecurityGroup"

	// ResourceTypeAwsRdsDbsnapshot is a ResourceType enum value
	ResourceTypeAwsRdsDbsnapshot = "AWS::RDS::DBSnapshot"

	// ResourceTypeAwsRdsDbcluster is a ResourceType enum value
	ResourceTypeAwsRdsDbcluster = "AWS::RDS::DBCluster"

	// ResourceTypeAwsRdsDbclusterSnapshot is a ResourceType enum value
	ResourceTypeAwsRdsDbclusterSnapshot = "AWS::RDS::DBClusterSnapshot"

	// ResourceTypeAwsRdsEventSubscription is a ResourceType enum value
	ResourceTypeAwsRdsEventSubscription = "AWS::RDS::EventSubscription"

	// ResourceTypeAwsS3Bucket is a ResourceType enum value
	ResourceTypeAwsS3Bucket = "AWS::S3::Bucket"

	// ResourceTypeAwsS3AccountPublicAccessBlock is a ResourceType enum value
	ResourceTypeAwsS3AccountPublicAccessBlock = "AWS::S3::AccountPublicAccessBlock"

	// ResourceTypeAwsRedshiftCluster is a ResourceType enum value
	ResourceTypeAwsRedshiftCluster = "AWS::Redshift::Cluster"

	// ResourceTypeAwsRedshiftClusterSnapshot is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSnapshot = "AWS::Redshift::ClusterSnapshot"

	// ResourceTypeAwsRedshiftClusterParameterGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterParameterGroup = "AWS::Redshift::ClusterParameterGroup"

	// ResourceTypeAwsRedshiftClusterSecurityGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSecurityGroup = "AWS::Redshift::ClusterSecurityGroup"

	// ResourceTypeAwsRedshiftClusterSubnetGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSubnetGroup = "AWS::Redshift::ClusterSubnetGroup"

	// ResourceTypeAwsRedshiftEventSubscription is a ResourceType enum value
	ResourceTypeAwsRedshiftEventSubscription = "AWS::Redshift::EventSubscription"

	// ResourceTypeAwsSsmManagedInstanceInventory is a ResourceType enum value
	ResourceTypeAwsSsmManagedInstanceInventory = "AWS::SSM::ManagedInstanceInventory"

	// ResourceTypeAwsCloudWatchAlarm is a ResourceType enum value
	ResourceTypeAwsCloudWatchAlarm = "AWS::CloudWatch::Alarm"

	// ResourceTypeAwsCloudFormationStack is a ResourceType enum value
	ResourceTypeAwsCloudFormationStack = "AWS::CloudFormation::Stack"

	// ResourceTypeAwsElasticLoadBalancingLoadBalancer is a ResourceType enum value
	ResourceTypeAwsElasticLoadBalancingLoadBalancer = "AWS::ElasticLoadBalancing::LoadBalancer"

	// ResourceTypeAwsAutoScalingAutoScalingGroup is a ResourceType enum value
	ResourceTypeAwsAutoScalingAutoScalingGroup = "AWS::AutoScaling::AutoScalingGroup"

	// ResourceTypeAwsAutoScalingLaunchConfiguration is a ResourceType enum value
	ResourceTypeAwsAutoScalingLaunchConfiguration = "AWS::AutoScaling::LaunchConfiguration"

	// ResourceTypeAwsAutoScalingScalingPolicy is a ResourceType enum value
	ResourceTypeAwsAutoScalingScalingPolicy = "AWS::AutoScaling::ScalingPolicy"

	// ResourceTypeAwsAutoScalingScheduledAction is a ResourceType enum value
	ResourceTypeAwsAutoScalingScheduledAction = "AWS::AutoScaling::ScheduledAction"

	// ResourceTypeAwsDynamoDbTable is a ResourceType enum value
	ResourceTypeAwsDynamoDbTable = "AWS::DynamoDB::Table"

	// ResourceTypeAwsCodeBuildProject is a ResourceType enum value
	ResourceTypeAwsCodeBuildProject = "AWS::CodeBuild::Project"

	// ResourceTypeAwsWafRateBasedRule is a ResourceType enum value
	ResourceTypeAwsWafRateBasedRule = "AWS::WAF::RateBasedRule"

	// ResourceTypeAwsWafRule is a ResourceType enum value
	ResourceTypeAwsWafRule = "AWS::WAF::Rule"

	// ResourceTypeAwsWafRuleGroup is a ResourceType enum value
	ResourceTypeAwsWafRuleGroup = "AWS::WAF::RuleGroup"

	// ResourceTypeAwsWafWebAcl is a ResourceType enum value
	ResourceTypeAwsWafWebAcl = "AWS::WAF::WebACL"

	// ResourceTypeAwsWafregionalRateBasedRule is a ResourceType enum value
	ResourceTypeAwsWafregionalRateBasedRule = "AWS::WAFRegional::RateBasedRule"

	// ResourceTypeAwsWafregionalRule is a ResourceType enum value
	ResourceTypeAwsWafregionalRule = "AWS::WAFRegional::Rule"

	// ResourceTypeAwsWafregionalRuleGroup is a ResourceType enum value
	ResourceTypeAwsWafregionalRuleGroup = "AWS::WAFRegional::RuleGroup"

	// ResourceTypeAwsWafregionalWebAcl is a ResourceType enum value
	ResourceTypeAwsWafregionalWebAcl = "AWS::WAFRegional::WebACL"

	// ResourceTypeAwsCloudFrontDistribution is a ResourceType enum value
	ResourceTypeAwsCloudFrontDistribution = "AWS::CloudFront::Distribution"

	// ResourceTypeAwsCloudFrontStreamingDistribution is a ResourceType enum value
	ResourceTypeAwsCloudFrontStreamingDistribution = "AWS::CloudFront::StreamingDistribution"

	// ResourceTypeAwsLambdaFunction is a ResourceType enum value
	ResourceTypeAwsLambdaFunction = "AWS::Lambda::Function"

	// ResourceTypeAwsNetworkFirewallFirewall is a ResourceType enum value
	ResourceTypeAwsNetworkFirewallFirewall = "AWS::NetworkFirewall::Firewall"

	// ResourceTypeAwsNetworkFirewallFirewallPolicy is a ResourceType enum value
	ResourceTypeAwsNetworkFirewallFirewallPolicy = "AWS::NetworkFirewall::FirewallPolicy"

	// ResourceTypeAwsNetworkFirewallRuleGroup is a ResourceType enum value
	ResourceTypeAwsNetworkFirewallRuleGroup = "AWS::NetworkFirewall::RuleGroup"

	// ResourceTypeAwsElasticBeanstalkApplication is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkApplication = "AWS::ElasticBeanstalk::Application"

	// ResourceTypeAwsElasticBeanstalkApplicationVersion is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkApplicationVersion = "AWS::ElasticBeanstalk::ApplicationVersion"

	// ResourceTypeAwsElasticBeanstalkEnvironment is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkEnvironment = "AWS::ElasticBeanstalk::Environment"

	// ResourceTypeAwsWafv2WebAcl is a ResourceType enum value
	ResourceTypeAwsWafv2WebAcl = "AWS::WAFv2::WebACL"

	// ResourceTypeAwsWafv2RuleGroup is a ResourceType enum value
	ResourceTypeAwsWafv2RuleGroup = "AWS::WAFv2::RuleGroup"

	// ResourceTypeAwsWafv2Ipset is a ResourceType enum value
	ResourceTypeAwsWafv2Ipset = "AWS::WAFv2::IPSet"

	// ResourceTypeAwsWafv2RegexPatternSet is a ResourceType enum value
	ResourceTypeAwsWafv2RegexPatternSet = "AWS::WAFv2::RegexPatternSet"

	// ResourceTypeAwsWafv2ManagedRuleSet is a ResourceType enum value
	ResourceTypeAwsWafv2ManagedRuleSet = "AWS::WAFv2::ManagedRuleSet"

	// ResourceTypeAwsXrayEncryptionConfig is a ResourceType enum value
	ResourceTypeAwsXrayEncryptionConfig = "AWS::XRay::EncryptionConfig"

	// ResourceTypeAwsSsmAssociationCompliance is a ResourceType enum value
	ResourceTypeAwsSsmAssociationCompliance = "AWS::SSM::AssociationCompliance"

	// ResourceTypeAwsSsmPatchCompliance is a ResourceType enum value
	ResourceTypeAwsSsmPatchCompliance = "AWS::SSM::PatchCompliance"

	// ResourceTypeAwsShieldProtection is a ResourceType enum value
	ResourceTypeAwsShieldProtection = "AWS::Shield::Protection"

	// ResourceTypeAwsShieldRegionalProtection is a ResourceType enum value
	ResourceTypeAwsShieldRegionalProtection = "AWS::ShieldRegional::Protection"

	// ResourceTypeAwsConfigConformancePackCompliance is a ResourceType enum value
	ResourceTypeAwsConfigConformancePackCompliance = "AWS::Config::ConformancePackCompliance"

	// ResourceTypeAwsConfigResourceCompliance is a ResourceType enum value
	ResourceTypeAwsConfigResourceCompliance = "AWS::Config::ResourceCompliance"

	// ResourceTypeAwsApiGatewayStage is a ResourceType enum value
	ResourceTypeAwsApiGatewayStage = "AWS::ApiGateway::Stage"

	// ResourceTypeAwsApiGatewayRestApi is a ResourceType enum value
	ResourceTypeAwsApiGatewayRestApi = "AWS::ApiGateway::RestApi"

	// ResourceTypeAwsApiGatewayV2Stage is a ResourceType enum value
	ResourceTypeAwsApiGatewayV2Stage = "AWS::ApiGatewayV2::Stage"

	// ResourceTypeAwsApiGatewayV2Api is a ResourceType enum value
	ResourceTypeAwsApiGatewayV2Api = "AWS::ApiGatewayV2::Api"

	// ResourceTypeAwsCodePipelinePipeline is a ResourceType enum value
	ResourceTypeAwsCodePipelinePipeline = "AWS::CodePipeline::Pipeline"

	// ResourceTypeAwsServiceCatalogCloudFormationProvisionedProduct is a ResourceType enum value
	ResourceTypeAwsServiceCatalogCloudFormationProvisionedProduct = "AWS::ServiceCatalog::CloudFormationProvisionedProduct"

	// ResourceTypeAwsServiceCatalogCloudFormationProduct is a ResourceType enum value
	ResourceTypeAwsServiceCatalogCloudFormationProduct = "AWS::ServiceCatalog::CloudFormationProduct"

	// ResourceTypeAwsServiceCatalogPortfolio is a ResourceType enum value
	ResourceTypeAwsServiceCatalogPortfolio = "AWS::ServiceCatalog::Portfolio"

	// ResourceTypeAwsSqsQueue is a ResourceType enum value
	ResourceTypeAwsSqsQueue = "AWS::SQS::Queue"

	// ResourceTypeAwsKmsKey is a ResourceType enum value
	ResourceTypeAwsKmsKey = "AWS::KMS::Key"

	// ResourceTypeAwsQldbLedger is a ResourceType enum value
	ResourceTypeAwsQldbLedger = "AWS::QLDB::Ledger"

	// ResourceTypeAwsSecretsManagerSecret is a ResourceType enum value
	ResourceTypeAwsSecretsManagerSecret = "AWS::SecretsManager::Secret"

	// ResourceTypeAwsSnsTopic is a ResourceType enum value
	ResourceTypeAwsSnsTopic = "AWS::SNS::Topic"

	// ResourceTypeAwsSsmFileData is a ResourceType enum value
	ResourceTypeAwsSsmFileData = "AWS::SSM::FileData"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAwsEc2CustomerGateway,
		ResourceTypeAwsEc2Eip,
		ResourceTypeAwsEc2Host,
		ResourceTypeAwsEc2Instance,
		ResourceTypeAwsEc2InternetGateway,
		ResourceTypeAwsEc2NetworkAcl,
		ResourceTypeAwsEc2NetworkInterface,
		ResourceTypeAwsEc2RouteTable,
		ResourceTypeAwsEc2SecurityGroup,
		ResourceTypeAwsEc2Subnet,
		ResourceTypeAwsCloudTrailTrail,
		ResourceTypeAwsEc2Volume,
		ResourceTypeAwsEc2Vpc,
		ResourceTypeAwsEc2Vpnconnection,
		ResourceTypeAwsEc2Vpngateway,
		ResourceTypeAwsEc2RegisteredHainstance,
		ResourceTypeAwsEc2NatGateway,
		ResourceTypeAwsEc2EgressOnlyInternetGateway,
		ResourceTypeAwsEc2Vpcendpoint,
		ResourceTypeAwsEc2VpcendpointService,
		ResourceTypeAwsEc2FlowLog,
		ResourceTypeAwsEc2VpcpeeringConnection,
		ResourceTypeAwsElasticsearchDomain,
		ResourceTypeAwsIamGroup,
		ResourceTypeAwsIamPolicy,
		ResourceTypeAwsIamRole,
		ResourceTypeAwsIamUser,
		ResourceTypeAwsElasticLoadBalancingV2LoadBalancer,
		ResourceTypeAwsAcmCertificate,
		ResourceTypeAwsRdsDbinstance,
		ResourceTypeAwsRdsDbsubnetGroup,
		ResourceTypeAwsRdsDbsecurityGroup,
		ResourceTypeAwsRdsDbsnapshot,
		ResourceTypeAwsRdsDbcluster,
		ResourceTypeAwsRdsDbclusterSnapshot,
		ResourceTypeAwsRdsEventSubscription,
		ResourceTypeAwsS3Bucket,
		ResourceTypeAwsS3AccountPublicAccessBlock,
		ResourceTypeAwsRedshiftCluster,
		ResourceTypeAwsRedshiftClusterSnapshot,
		ResourceTypeAwsRedshiftClusterParameterGroup,
		ResourceTypeAwsRedshiftClusterSecurityGroup,
		ResourceTypeAwsRedshiftClusterSubnetGroup,
		ResourceTypeAwsRedshiftEventSubscription,
		ResourceTypeAwsSsmManagedInstanceInventory,
		ResourceTypeAwsCloudWatchAlarm,
		ResourceTypeAwsCloudFormationStack,
		ResourceTypeAwsElasticLoadBalancingLoadBalancer,
		ResourceTypeAwsAutoScalingAutoScalingGroup,
		ResourceTypeAwsAutoScalingLaunchConfiguration,
		ResourceTypeAwsAutoScalingScalingPolicy,
		ResourceTypeAwsAutoScalingScheduledAction,
		ResourceTypeAwsDynamoDbTable,
		ResourceTypeAwsCodeBuildProject,
		ResourceTypeAwsWafRateBasedRule,
		ResourceTypeAwsWafRule,
		ResourceTypeAwsWafRuleGroup,
		ResourceTypeAwsWafWebAcl,
		ResourceTypeAwsWafregionalRateBasedRule,
		ResourceTypeAwsWafregionalRule,
		ResourceTypeAwsWafregionalRuleGroup,
		ResourceTypeAwsWafregionalWebAcl,
		ResourceTypeAwsCloudFrontDistribution,
		ResourceTypeAwsCloudFrontStreamingDistribution,
		ResourceTypeAwsLambdaFunction,
		ResourceTypeAwsNetworkFirewallFirewall,
		ResourceTypeAwsNetworkFirewallFirewallPolicy,
		ResourceTypeAwsNetworkFirewallRuleGroup,
		ResourceTypeAwsElasticBeanstalkApplication,
		ResourceTypeAwsElasticBeanstalkApplicationVersion,
		ResourceTypeAwsElasticBeanstalkEnvironment,
		ResourceTypeAwsWafv2WebAcl,
		ResourceTypeAwsWafv2RuleGroup,
		ResourceTypeAwsWafv2Ipset,
		ResourceTypeAwsWafv2RegexPatternSet,
		ResourceTypeAwsWafv2ManagedRuleSet,
		ResourceTypeAwsXrayEncryptionConfig,
		ResourceTypeAwsSsmAssociationCompliance,
		ResourceTypeAwsSsmPatchCompliance,
		ResourceTypeAwsShieldProtection,
		ResourceTypeAwsShieldRegionalProtection,
		ResourceTypeAwsConfigConformancePackCompliance,
		ResourceTypeAwsConfigResourceCompliance,
		ResourceTypeAwsApiGatewayStage,
		ResourceTypeAwsApiGatewayRestApi,
		ResourceTypeAwsApiGatewayV2Stage,
		ResourceTypeAwsApiGatewayV2Api,
		ResourceTypeAwsCodePipelinePipeline,
		ResourceTypeAwsServiceCatalogCloudFormationProvisionedProduct,
		ResourceTypeAwsServiceCatalogCloudFormationProduct,
		ResourceTypeAwsServiceCatalogPortfolio,
		ResourceTypeAwsSqsQueue,
		ResourceTypeAwsKmsKey,
		ResourceTypeAwsQldbLedger,
		ResourceTypeAwsSecretsManagerSecret,
		ResourceTypeAwsSnsTopic,
		ResourceTypeAwsSsmFileData,
	}
}

const (
	// ResourceValueTypeResourceId is a ResourceValueType enum value
	ResourceValueTypeResourceId = "RESOURCE_ID"
)

// ResourceValueType_Values returns all elements of the ResourceValueType enum
func ResourceValueType_Values() []string {
	return []string{
		ResourceValueTypeResourceId,
	}
}
