//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "k8s.io/api/networking/v1beta1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&v1beta1.Ingress{}, func(obj interface{}) { SetObjectDefaults_Ingress(obj.(*v1beta1.Ingress)) })
	scheme.AddTypeDefaultingFunc(&v1beta1.IngressList{}, func(obj interface{}) { SetObjectDefaults_IngressList(obj.(*v1beta1.IngressList)) })
	return nil
}

func SetObjectDefaults_Ingress(in *v1beta1.Ingress) {
	for i := range in.Spec.Rules {
		a := &in.Spec.Rules[i]
		if a.IngressRuleValue.HTTP != nil {
			for j := range a.IngressRuleValue.HTTP.Paths {
				b := &a.IngressRuleValue.HTTP.Paths[j]
				SetDefaults_HTTPIngressPath(b)
			}
		}
	}
}

func SetObjectDefaults_IngressList(in *v1beta1.IngressList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Ingress(a)
	}
}
