import { IRow } from '@patternfly/react-table';
import { NodeKind, K8sResourceCommon, Toleration } from '@console/internal/module/k8s';

export type NodeTableRow = {
  cells: IRow['cells'];
  props: {
    id: string;
  };
  selected: boolean;
};

export enum DiskType {
  RawDisk = 'disk',
  Partition = 'part',
}

export enum DiskMechanicalProperties {
  'NonRotational' = 'NonRotational',
  'Rotational' = 'Rotational',
}

export type LocalVolumeSetKind = K8sResourceCommon & {
  spec: {
    storageClassName: string;
    volumeMode: string;
    deviceInclusionSpec: {
      deviceTypes?: DiskType[];
      deviceMechanicalProperties: [keyof typeof DiskMechanicalProperties];
      minSize?: string;
      maxSize?: string;
    };
    nodeSelector?: {
      nodeSelectorTerms: {
        matchExpressions: { key: string; operator: string; values: string[] }[];
      }[];
    };
    maxDeviceCount?: number;
    tolerations?: Toleration[];
  };
};

export type GetRows = (
  {
    componentProps,
    customData,
  }: {
    componentProps: { data: NodeKind[] };
    customData?: {
      filteredNodes: string[];
      preSelected?: string[];
      taintsFilter?: (node: NodeKind) => boolean;
    };
  },
  visibleRows: Set<string>,
  setVisibleRows: React.Dispatch<React.SetStateAction<Set<string>>>,
  selectedNodes: Set<string>,
  setSelectedNodes?: (nodes: NodeKind[]) => void,
) => NodeTableRow[];
