package contentmoderator

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ListManagementTermListsClient is the you use the API to scan your content as it is generated. Content Moderator then
// processes your content and sends the results along with relevant information either back to your systems or to the
// built-in review tool. You can use this information to take decisions e.g. take it down, send to human judge, etc.
//
// When using the API, images need to have a minimum of 128 pixels and a maximum file size of 4MB.
// Text can be at most 1024 characters long.
// If the content passed to the text API or the image API exceeds the size limits, the API will return an error code
// that informs about the issue.
//
// This API is currently available in:
//
// * West US - westus.api.cognitive.microsoft.com
// * East US 2 - eastus2.api.cognitive.microsoft.com
// * West Central US - westcentralus.api.cognitive.microsoft.com
// * West Europe - westeurope.api.cognitive.microsoft.com
// * Southeast Asia - southeastasia.api.cognitive.microsoft.com .
type ListManagementTermListsClient struct {
	BaseClient
}

// NewListManagementTermListsClient creates an instance of the ListManagementTermListsClient client.
func NewListManagementTermListsClient(baseURL AzureRegionBaseURL) ListManagementTermListsClient {
	return ListManagementTermListsClient{New(baseURL)}
}

// Create creates a Term List
// Parameters:
// contentType - the content type.
// body - schema of the body.
func (client ListManagementTermListsClient) Create(ctx context.Context, contentType string, body Body) (result TermList, err error) {
	req, err := client.CreatePreparer(ctx, contentType, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ListManagementTermListsClient) CreatePreparer(ctx context.Context, contentType string, body Body) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/lists/v1.0/termlists"),
		autorest.WithJSON(body),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) CreateResponder(resp *http.Response) (result TermList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes term list with the list Id equal to list Id passed.
// Parameters:
// listID - list Id of the image list.
func (client ListManagementTermListsClient) Delete(ctx context.Context, listID string) (result String, err error) {
	req, err := client.DeletePreparer(ctx, listID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ListManagementTermListsClient) DeletePreparer(ctx context.Context, listID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	pathParameters := map[string]interface{}{
		"listId": autorest.Encode("path", listID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/lists/v1.0/termlists/{listId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) DeleteResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAllTermLists gets all the Term Lists
func (client ListManagementTermListsClient) GetAllTermLists(ctx context.Context) (result ListTermList, err error) {
	req, err := client.GetAllTermListsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetAllTermLists", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAllTermListsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetAllTermLists", resp, "Failure sending request")
		return
	}

	result, err = client.GetAllTermListsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetAllTermLists", resp, "Failure responding to request")
	}

	return
}

// GetAllTermListsPreparer prepares the GetAllTermLists request.
func (client ListManagementTermListsClient) GetAllTermListsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/lists/v1.0/termlists"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAllTermListsSender sends the GetAllTermLists request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) GetAllTermListsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAllTermListsResponder handles the response to the GetAllTermLists request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) GetAllTermListsResponder(resp *http.Response) (result ListTermList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDetails returns list Id details of the term list with list Id equal to list Id passed.
// Parameters:
// listID - list Id of the image list.
func (client ListManagementTermListsClient) GetDetails(ctx context.Context, listID string) (result TermList, err error) {
	req, err := client.GetDetailsPreparer(ctx, listID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetDetails", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDetailsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetDetails", resp, "Failure sending request")
		return
	}

	result, err = client.GetDetailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "GetDetails", resp, "Failure responding to request")
	}

	return
}

// GetDetailsPreparer prepares the GetDetails request.
func (client ListManagementTermListsClient) GetDetailsPreparer(ctx context.Context, listID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	pathParameters := map[string]interface{}{
		"listId": autorest.Encode("path", listID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/lists/v1.0/termlists/{listId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDetailsSender sends the GetDetails request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) GetDetailsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetDetailsResponder handles the response to the GetDetails request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) GetDetailsResponder(resp *http.Response) (result TermList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RefreshIndexMethod refreshes the index of the list with list Id equal to list ID passed.
// Parameters:
// listID - list Id of the image list.
// language - language of the terms.
func (client ListManagementTermListsClient) RefreshIndexMethod(ctx context.Context, listID string, language string) (result RefreshIndex, err error) {
	req, err := client.RefreshIndexMethodPreparer(ctx, listID, language)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "RefreshIndexMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.RefreshIndexMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "RefreshIndexMethod", resp, "Failure sending request")
		return
	}

	result, err = client.RefreshIndexMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "RefreshIndexMethod", resp, "Failure responding to request")
	}

	return
}

// RefreshIndexMethodPreparer prepares the RefreshIndexMethod request.
func (client ListManagementTermListsClient) RefreshIndexMethodPreparer(ctx context.Context, listID string, language string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	pathParameters := map[string]interface{}{
		"listId": autorest.Encode("path", listID),
	}

	queryParameters := map[string]interface{}{
		"language": autorest.Encode("query", language),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/lists/v1.0/termlists/{listId}/RefreshIndex", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RefreshIndexMethodSender sends the RefreshIndexMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) RefreshIndexMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// RefreshIndexMethodResponder handles the response to the RefreshIndexMethod request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) RefreshIndexMethodResponder(resp *http.Response) (result RefreshIndex, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates an Term List.
// Parameters:
// listID - list Id of the image list.
// contentType - the content type.
// body - schema of the body.
func (client ListManagementTermListsClient) Update(ctx context.Context, listID string, contentType string, body Body) (result TermList, err error) {
	req, err := client.UpdatePreparer(ctx, listID, contentType, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ListManagementTermListsClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ListManagementTermListsClient) UpdatePreparer(ctx context.Context, listID string, contentType string, body Body) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	pathParameters := map[string]interface{}{
		"listId": autorest.Encode("path", listID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPathParameters("/contentmoderator/lists/v1.0/termlists/{listId}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ListManagementTermListsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ListManagementTermListsClient) UpdateResponder(resp *http.Response) (result TermList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
