// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteJourneyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJourneyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJourneyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteJourneyInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJourneyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteJourneyOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteJourneyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJourneyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyResponse != nil {
		v := s.JourneyResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyResponse", v, metadata)
	}
	return nil
}

const opDeleteJourney = "DeleteJourney"

// DeleteJourneyRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes a journey from an application.
//
//    // Example sending a request using DeleteJourneyRequest.
//    req := client.DeleteJourneyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney
func (c *Client) DeleteJourneyRequest(input *DeleteJourneyInput) DeleteJourneyRequest {
	op := &aws.Operation{
		Name:       opDeleteJourney,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}",
	}

	if input == nil {
		input = &DeleteJourneyInput{}
	}

	req := c.newRequest(op, input, &DeleteJourneyOutput{})
	return DeleteJourneyRequest{Request: req, Input: input, Copy: c.DeleteJourneyRequest}
}

// DeleteJourneyRequest is the request type for the
// DeleteJourney API operation.
type DeleteJourneyRequest struct {
	*aws.Request
	Input *DeleteJourneyInput
	Copy  func(*DeleteJourneyInput) DeleteJourneyRequest
}

// Send marshals and sends the DeleteJourney API request.
func (r DeleteJourneyRequest) Send(ctx context.Context) (*DeleteJourneyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteJourneyResponse{
		DeleteJourneyOutput: r.Request.Data.(*DeleteJourneyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteJourneyResponse is the response type for the
// DeleteJourney API operation.
type DeleteJourneyResponse struct {
	*DeleteJourneyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteJourney request.
func (r *DeleteJourneyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
