// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the job for which to retrieve triggers. The trigger that can
	// start this job is returned. If there is no such trigger, all triggers are
	// returned.
	DependentJobName *string `min:"1" type:"string"`

	// The maximum size of a list to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation request.
	NextToken *string `type:"string"`

	// Specifies to return only these tagged resources.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s ListTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTriggersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTriggersInput"}
	if s.DependentJobName != nil && len(*s.DependentJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DependentJobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTriggersOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if the returned list does not contain the last metric
	// available.
	NextToken *string `type:"string"`

	// The names of all triggers in the account, or the triggers with the specified
	// tags.
	TriggerNames []string `type:"list"`
}

// String returns the string representation
func (s ListTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTriggers = "ListTriggers"

// ListTriggersRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves the names of all trigger resources in this AWS account, or the
// resources with the specified tag. This operation allows you to see which
// resources are available in your account, and their names.
//
// This operation takes the optional Tags field, which you can use as a filter
// on the response so that tagged resources can be retrieved as a group. If
// you choose to use tags filtering, only resources with the tag are retrieved.
//
//    // Example sending a request using ListTriggersRequest.
//    req := client.ListTriggersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers
func (c *Client) ListTriggersRequest(input *ListTriggersInput) ListTriggersRequest {
	op := &aws.Operation{
		Name:       opListTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTriggersInput{}
	}

	req := c.newRequest(op, input, &ListTriggersOutput{})
	return ListTriggersRequest{Request: req, Input: input, Copy: c.ListTriggersRequest}
}

// ListTriggersRequest is the request type for the
// ListTriggers API operation.
type ListTriggersRequest struct {
	*aws.Request
	Input *ListTriggersInput
	Copy  func(*ListTriggersInput) ListTriggersRequest
}

// Send marshals and sends the ListTriggers API request.
func (r ListTriggersRequest) Send(ctx context.Context) (*ListTriggersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTriggersResponse{
		ListTriggersOutput: r.Request.Data.(*ListTriggersOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTriggersRequestPaginator returns a paginator for ListTriggers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTriggersRequest(input)
//   p := glue.NewListTriggersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTriggersPaginator(req ListTriggersRequest) ListTriggersPaginator {
	return ListTriggersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTriggersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTriggersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTriggersPaginator struct {
	aws.Pager
}

func (p *ListTriggersPaginator) CurrentPage() *ListTriggersOutput {
	return p.Pager.CurrentPage().(*ListTriggersOutput)
}

// ListTriggersResponse is the response type for the
// ListTriggers API operation.
type ListTriggersResponse struct {
	*ListTriggersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTriggers request.
func (r *ListTriggersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
