// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateScriptInput struct {
	_ struct{} `type:"structure"`

	// A list of the edges in the DAG.
	DagEdges []CodeGenEdge `type:"list"`

	// A list of the nodes in the DAG.
	DagNodes []CodeGenNode `type:"list"`

	// The programming language of the resulting code from the DAG.
	Language Language `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateScriptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScriptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateScriptInput"}
	if s.DagEdges != nil {
		for i, v := range s.DagEdges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagEdges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.DagNodes != nil {
		for i, v := range s.DagNodes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagNodes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateScriptOutput struct {
	_ struct{} `type:"structure"`

	// The Python script generated from the DAG.
	PythonScript *string `type:"string"`

	// The Scala code generated from the DAG.
	ScalaCode *string `type:"string"`
}

// String returns the string representation
func (s CreateScriptOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateScript = "CreateScript"

// CreateScriptRequest returns a request value for making API operation for
// AWS Glue.
//
// Transforms a directed acyclic graph (DAG) into code.
//
//    // Example sending a request using CreateScriptRequest.
//    req := client.CreateScriptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript
func (c *Client) CreateScriptRequest(input *CreateScriptInput) CreateScriptRequest {
	op := &aws.Operation{
		Name:       opCreateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScriptInput{}
	}

	req := c.newRequest(op, input, &CreateScriptOutput{})
	return CreateScriptRequest{Request: req, Input: input, Copy: c.CreateScriptRequest}
}

// CreateScriptRequest is the request type for the
// CreateScript API operation.
type CreateScriptRequest struct {
	*aws.Request
	Input *CreateScriptInput
	Copy  func(*CreateScriptInput) CreateScriptRequest
}

// Send marshals and sends the CreateScript API request.
func (r CreateScriptRequest) Send(ctx context.Context) (*CreateScriptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateScriptResponse{
		CreateScriptOutput: r.Request.Data.(*CreateScriptOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateScriptResponse is the response type for the
// CreateScript API operation.
type CreateScriptResponse struct {
	*CreateScriptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateScript request.
func (r *CreateScriptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
