// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchAssociateApprovalRuleTemplateWithRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The name of the template you want to associate with one or more repositories.
	//
	// ApprovalRuleTemplateName is a required field
	ApprovalRuleTemplateName *string `locationName:"approvalRuleTemplateName" min:"1" type:"string" required:"true"`

	// The names of the repositories you want to associate with the template.
	//
	// The length constraint limit is for each string in the array. The array itself
	// can be empty.
	//
	// RepositoryNames is a required field
	RepositoryNames []string `locationName:"repositoryNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateApprovalRuleTemplateWithRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateApprovalRuleTemplateWithRepositoriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAssociateApprovalRuleTemplateWithRepositoriesInput"}

	if s.ApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleTemplateName"))
	}
	if s.ApprovalRuleTemplateName != nil && len(*s.ApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleTemplateName", 1))
	}

	if s.RepositoryNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchAssociateApprovalRuleTemplateWithRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of names of the repositories that have been associated with the template.
	//
	// AssociatedRepositoryNames is a required field
	AssociatedRepositoryNames []string `locationName:"associatedRepositoryNames" type:"list" required:"true"`

	// A list of any errors that might have occurred while attempting to create
	// the association between the template and the repositories.
	//
	// Errors is a required field
	Errors []BatchAssociateApprovalRuleTemplateWithRepositoriesError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateApprovalRuleTemplateWithRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchAssociateApprovalRuleTemplateWithRepositories = "BatchAssociateApprovalRuleTemplateWithRepositories"

// BatchAssociateApprovalRuleTemplateWithRepositoriesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Creates an association between an approval rule template and one or more
// specified repositories.
//
//    // Example sending a request using BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.
//    req := client.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchAssociateApprovalRuleTemplateWithRepositories
func (c *Client) BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(input *BatchAssociateApprovalRuleTemplateWithRepositoriesInput) BatchAssociateApprovalRuleTemplateWithRepositoriesRequest {
	op := &aws.Operation{
		Name:       opBatchAssociateApprovalRuleTemplateWithRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAssociateApprovalRuleTemplateWithRepositoriesInput{}
	}

	req := c.newRequest(op, input, &BatchAssociateApprovalRuleTemplateWithRepositoriesOutput{})
	return BatchAssociateApprovalRuleTemplateWithRepositoriesRequest{Request: req, Input: input, Copy: c.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest}
}

// BatchAssociateApprovalRuleTemplateWithRepositoriesRequest is the request type for the
// BatchAssociateApprovalRuleTemplateWithRepositories API operation.
type BatchAssociateApprovalRuleTemplateWithRepositoriesRequest struct {
	*aws.Request
	Input *BatchAssociateApprovalRuleTemplateWithRepositoriesInput
	Copy  func(*BatchAssociateApprovalRuleTemplateWithRepositoriesInput) BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
}

// Send marshals and sends the BatchAssociateApprovalRuleTemplateWithRepositories API request.
func (r BatchAssociateApprovalRuleTemplateWithRepositoriesRequest) Send(ctx context.Context) (*BatchAssociateApprovalRuleTemplateWithRepositoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchAssociateApprovalRuleTemplateWithRepositoriesResponse{
		BatchAssociateApprovalRuleTemplateWithRepositoriesOutput: r.Request.Data.(*BatchAssociateApprovalRuleTemplateWithRepositoriesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchAssociateApprovalRuleTemplateWithRepositoriesResponse is the response type for the
// BatchAssociateApprovalRuleTemplateWithRepositories API operation.
type BatchAssociateApprovalRuleTemplateWithRepositoriesResponse struct {
	*BatchAssociateApprovalRuleTemplateWithRepositoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchAssociateApprovalRuleTemplateWithRepositories request.
func (r *BatchAssociateApprovalRuleTemplateWithRepositoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
