// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchUsersInput struct {
	_ struct{} `type:"structure"`

	// The filters to use for listing a specific set of users. Required. Supported
	// filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	Filters []Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved. Required.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	// Required.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the filtered set of users. Required. Supported
	// sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.
	SortCriteria []Sort `type:"list"`
}

// String returns the string representation
func (s SearchUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of users returned.
	TotalCount *int64 `type:"integer"`

	// The users that meet the specified set of filter criteria, in sort order.
	Users []UserData `type:"list"`
}

// String returns the string representation
func (s SearchUsersOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchUsers = "SearchUsers"

// SearchUsersRequest returns a request value for making API operation for
// Alexa For Business.
//
// Searches users and lists the ones that meet a set of filter and sort criteria.
//
//    // Example sending a request using SearchUsersRequest.
//    req := client.SearchUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers
func (c *Client) SearchUsersRequest(input *SearchUsersInput) SearchUsersRequest {
	op := &aws.Operation{
		Name:       opSearchUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchUsersInput{}
	}

	req := c.newRequest(op, input, &SearchUsersOutput{})
	return SearchUsersRequest{Request: req, Input: input, Copy: c.SearchUsersRequest}
}

// SearchUsersRequest is the request type for the
// SearchUsers API operation.
type SearchUsersRequest struct {
	*aws.Request
	Input *SearchUsersInput
	Copy  func(*SearchUsersInput) SearchUsersRequest
}

// Send marshals and sends the SearchUsers API request.
func (r SearchUsersRequest) Send(ctx context.Context) (*SearchUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchUsersResponse{
		SearchUsersOutput: r.Request.Data.(*SearchUsersOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchUsersRequestPaginator returns a paginator for SearchUsers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchUsersRequest(input)
//   p := alexaforbusiness.NewSearchUsersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchUsersPaginator(req SearchUsersRequest) SearchUsersPaginator {
	return SearchUsersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchUsersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchUsersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchUsersPaginator struct {
	aws.Pager
}

func (p *SearchUsersPaginator) CurrentPage() *SearchUsersOutput {
	return p.Pager.CurrentPage().(*SearchUsersOutput)
}

// SearchUsersResponse is the response type for the
// SearchUsers API operation.
type SearchUsersResponse struct {
	*SearchUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchUsers request.
func (r *SearchUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
