---
title: v1.3.0
weight: 998997000
---

## Update `packagemanifests` make recipe variable `PKG_MAN_OPTS`

If your project uses the `packagemanifests` make recipe, update your `PKG_MAN_OPTS` variable to include `PKG_FROM_VERSION` instead of `FROM_VERSION`, ex:

```make
PKG_MAN_OPTS ?= $(PKG_FROM_VERSION) $(PKG_CHANNELS) $(PKG_IS_DEFAULT_CHANNEL)
```

_See [#4303](https://github.com/operator-framework/operator-sdk/pull/4303) for more details._

## Update your Go project's controller-runtime version to v0.6.4

In your go.mod file, update the `sigs.k8s.io/controller-runtime` version to v0.6.4

_See [#4282](https://github.com/operator-framework/operator-sdk/pull/4282) for more details._

## Upgrade your Go project from "go.kubebuilder.io/v2" to "go.kubebuilder.io/v3"

The newly released go/v3 plugin has many new features and (breaking) changes incompatible with projects created by go/v2. You are not required to upgrade and your go/v2 project will continue to work with new operator-sdk versions. If you wish to upgrade, check out the upstream [migration guide](https://master.book.kubebuilder.io/migration/plugin/plugins.html).

Additionally, if using project version "3-alpha", you must update your `plugins` config field:

Old:
```yaml
plugins:
  go.sdk.operatorframework.io/v2-alpha: {}
```

New:
```yaml
plugins:
  manifests.sdk.operatorframework.io/v2: {}
  scorecard.sdk.operatorframework.io/v2: {}
```

_See [#4307](https://github.com/operator-framework/operator-sdk/pull/4307) for more details._
