// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTransitGatewayPeeringAttachmentsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// One or more IDs of the transit gateway peering attachments.
	TransitGatewayAttachmentIds []string `type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayPeeringAttachmentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransitGatewayPeeringAttachmentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTransitGatewayPeeringAttachmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTransitGatewayPeeringAttachmentsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The transit gateway peering attachments.
	TransitGatewayPeeringAttachments []TransitGatewayPeeringAttachment `locationName:"transitGatewayPeeringAttachments" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayPeeringAttachmentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTransitGatewayPeeringAttachments = "DescribeTransitGatewayPeeringAttachments"

// DescribeTransitGatewayPeeringAttachmentsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes your transit gateway peering attachments.
//
//    // Example sending a request using DescribeTransitGatewayPeeringAttachmentsRequest.
//    req := client.DescribeTransitGatewayPeeringAttachmentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPeeringAttachments
func (c *Client) DescribeTransitGatewayPeeringAttachmentsRequest(input *DescribeTransitGatewayPeeringAttachmentsInput) DescribeTransitGatewayPeeringAttachmentsRequest {
	op := &aws.Operation{
		Name:       opDescribeTransitGatewayPeeringAttachments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTransitGatewayPeeringAttachmentsInput{}
	}

	req := c.newRequest(op, input, &DescribeTransitGatewayPeeringAttachmentsOutput{})
	return DescribeTransitGatewayPeeringAttachmentsRequest{Request: req, Input: input, Copy: c.DescribeTransitGatewayPeeringAttachmentsRequest}
}

// DescribeTransitGatewayPeeringAttachmentsRequest is the request type for the
// DescribeTransitGatewayPeeringAttachments API operation.
type DescribeTransitGatewayPeeringAttachmentsRequest struct {
	*aws.Request
	Input *DescribeTransitGatewayPeeringAttachmentsInput
	Copy  func(*DescribeTransitGatewayPeeringAttachmentsInput) DescribeTransitGatewayPeeringAttachmentsRequest
}

// Send marshals and sends the DescribeTransitGatewayPeeringAttachments API request.
func (r DescribeTransitGatewayPeeringAttachmentsRequest) Send(ctx context.Context) (*DescribeTransitGatewayPeeringAttachmentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTransitGatewayPeeringAttachmentsResponse{
		DescribeTransitGatewayPeeringAttachmentsOutput: r.Request.Data.(*DescribeTransitGatewayPeeringAttachmentsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTransitGatewayPeeringAttachmentsResponse is the response type for the
// DescribeTransitGatewayPeeringAttachments API operation.
type DescribeTransitGatewayPeeringAttachmentsResponse struct {
	*DescribeTransitGatewayPeeringAttachmentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTransitGatewayPeeringAttachments request.
func (r *DescribeTransitGatewayPeeringAttachmentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
