// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchDeleteBuilds = "BatchDeleteBuilds"

// BatchDeleteBuildsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteBuilds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteBuilds for more information on using the BatchDeleteBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteBuildsRequest method.
//    req, resp := client.BatchDeleteBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchDeleteBuilds
func (c *CodeBuild) BatchDeleteBuildsRequest(input *BatchDeleteBuildsInput) (req *request.Request, output *BatchDeleteBuildsOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteBuildsInput{}
	}

	output = &BatchDeleteBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteBuilds API operation for AWS CodeBuild.
//
// Deletes one or more builds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation BatchDeleteBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchDeleteBuilds
func (c *CodeBuild) BatchDeleteBuilds(input *BatchDeleteBuildsInput) (*BatchDeleteBuildsOutput, error) {
	req, out := c.BatchDeleteBuildsRequest(input)
	return out, req.Send()
}

// BatchDeleteBuildsWithContext is the same as BatchDeleteBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) BatchDeleteBuildsWithContext(ctx aws.Context, input *BatchDeleteBuildsInput, opts ...request.Option) (*BatchDeleteBuildsOutput, error) {
	req, out := c.BatchDeleteBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetBuilds = "BatchGetBuilds"

// BatchGetBuildsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetBuilds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetBuilds for more information on using the BatchGetBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetBuildsRequest method.
//    req, resp := client.BatchGetBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds
func (c *CodeBuild) BatchGetBuildsRequest(input *BatchGetBuildsInput) (req *request.Request, output *BatchGetBuildsOutput) {
	op := &request.Operation{
		Name:       opBatchGetBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetBuildsInput{}
	}

	output = &BatchGetBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetBuilds API operation for AWS CodeBuild.
//
// Gets information about builds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation BatchGetBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds
func (c *CodeBuild) BatchGetBuilds(input *BatchGetBuildsInput) (*BatchGetBuildsOutput, error) {
	req, out := c.BatchGetBuildsRequest(input)
	return out, req.Send()
}

// BatchGetBuildsWithContext is the same as BatchGetBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) BatchGetBuildsWithContext(ctx aws.Context, input *BatchGetBuildsInput, opts ...request.Option) (*BatchGetBuildsOutput, error) {
	req, out := c.BatchGetBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetProjects = "BatchGetProjects"

// BatchGetProjectsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetProjects for more information on using the BatchGetProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetProjectsRequest method.
//    req, resp := client.BatchGetProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects
func (c *CodeBuild) BatchGetProjectsRequest(input *BatchGetProjectsInput) (req *request.Request, output *BatchGetProjectsOutput) {
	op := &request.Operation{
		Name:       opBatchGetProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetProjectsInput{}
	}

	output = &BatchGetProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetProjects API operation for AWS CodeBuild.
//
// Gets information about build projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation BatchGetProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects
func (c *CodeBuild) BatchGetProjects(input *BatchGetProjectsInput) (*BatchGetProjectsOutput, error) {
	req, out := c.BatchGetProjectsRequest(input)
	return out, req.Send()
}

// BatchGetProjectsWithContext is the same as BatchGetProjects with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) BatchGetProjectsWithContext(ctx aws.Context, input *BatchGetProjectsInput, opts ...request.Option) (*BatchGetProjectsOutput, error) {
	req, out := c.BatchGetProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject
func (c *CodeBuild) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS CodeBuild.
//
// Creates a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation CreateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified AWS resource cannot be created, because an AWS resource with
//   the same settings already exists.
//
//   * ErrCodeAccountLimitExceededException "AccountLimitExceededException"
//   An AWS service limit was exceeded for the calling AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject
func (c *CodeBuild) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebhook = "CreateWebhook"

// CreateWebhookRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebhook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebhook for more information on using the CreateWebhook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWebhookRequest method.
//    req, resp := client.CreateWebhookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateWebhook
func (c *CodeBuild) CreateWebhookRequest(input *CreateWebhookInput) (req *request.Request, output *CreateWebhookOutput) {
	op := &request.Operation{
		Name:       opCreateWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWebhookInput{}
	}

	output = &CreateWebhookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebhook API operation for AWS CodeBuild.
//
// For an existing AWS CodeBuild build project that has its source code stored
// in a GitHub or Bitbucket repository, enables AWS CodeBuild to start rebuilding
// the source code every time a code change is pushed to the repository.
//
// If you enable webhooks for an AWS CodeBuild project, and the project is used
// as a build step in AWS CodePipeline, then two identical builds are created
// for each commit. One build is triggered through webhooks, and one through
// AWS CodePipeline. Because billing is on a per-build basis, you are billed
// for both builds. Therefore, if you are using AWS CodePipeline, we recommend
// that you disable webhooks in AWS CodeBuild. In the AWS CodeBuild console,
// clear the Webhook box. For more information, see step 5 in Change a Build
// Project's Settings (http://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation CreateWebhook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeOAuthProviderException "OAuthProviderException"
//   There was a problem with the underlying OAuth provider.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified AWS resource cannot be created, because an AWS resource with
//   the same settings already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateWebhook
func (c *CodeBuild) CreateWebhook(input *CreateWebhookInput) (*CreateWebhookOutput, error) {
	req, out := c.CreateWebhookRequest(input)
	return out, req.Send()
}

// CreateWebhookWithContext is the same as CreateWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) CreateWebhookWithContext(ctx aws.Context, input *CreateWebhookInput, opts ...request.Option) (*CreateWebhookOutput, error) {
	req, out := c.CreateWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject
func (c *CodeBuild) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for AWS CodeBuild.
//
// Deletes a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation DeleteProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject
func (c *CodeBuild) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSourceCredentials = "DeleteSourceCredentials"

// DeleteSourceCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSourceCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSourceCredentials for more information on using the DeleteSourceCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSourceCredentialsRequest method.
//    req, resp := client.DeleteSourceCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials
func (c *CodeBuild) DeleteSourceCredentialsRequest(input *DeleteSourceCredentialsInput) (req *request.Request, output *DeleteSourceCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteSourceCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSourceCredentialsInput{}
	}

	output = &DeleteSourceCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSourceCredentials API operation for AWS CodeBuild.
//
// Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation DeleteSourceCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials
func (c *CodeBuild) DeleteSourceCredentials(input *DeleteSourceCredentialsInput) (*DeleteSourceCredentialsOutput, error) {
	req, out := c.DeleteSourceCredentialsRequest(input)
	return out, req.Send()
}

// DeleteSourceCredentialsWithContext is the same as DeleteSourceCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSourceCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) DeleteSourceCredentialsWithContext(ctx aws.Context, input *DeleteSourceCredentialsInput, opts ...request.Option) (*DeleteSourceCredentialsOutput, error) {
	req, out := c.DeleteSourceCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebhook = "DeleteWebhook"

// DeleteWebhookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebhook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebhook for more information on using the DeleteWebhook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWebhookRequest method.
//    req, resp := client.DeleteWebhookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteWebhook
func (c *CodeBuild) DeleteWebhookRequest(input *DeleteWebhookInput) (req *request.Request, output *DeleteWebhookOutput) {
	op := &request.Operation{
		Name:       opDeleteWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebhookInput{}
	}

	output = &DeleteWebhookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWebhook API operation for AWS CodeBuild.
//
// For an existing AWS CodeBuild build project that has its source code stored
// in a GitHub or Bitbucket repository, stops AWS CodeBuild from rebuilding
// the source code every time a code change is pushed to the repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation DeleteWebhook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
//   * ErrCodeOAuthProviderException "OAuthProviderException"
//   There was a problem with the underlying OAuth provider.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteWebhook
func (c *CodeBuild) DeleteWebhook(input *DeleteWebhookInput) (*DeleteWebhookOutput, error) {
	req, out := c.DeleteWebhookRequest(input)
	return out, req.Send()
}

// DeleteWebhookWithContext is the same as DeleteWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) DeleteWebhookWithContext(ctx aws.Context, input *DeleteWebhookInput, opts ...request.Option) (*DeleteWebhookOutput, error) {
	req, out := c.DeleteWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportSourceCredentials = "ImportSourceCredentials"

// ImportSourceCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ImportSourceCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportSourceCredentials for more information on using the ImportSourceCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportSourceCredentialsRequest method.
//    req, resp := client.ImportSourceCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials
func (c *CodeBuild) ImportSourceCredentialsRequest(input *ImportSourceCredentialsInput) (req *request.Request, output *ImportSourceCredentialsOutput) {
	op := &request.Operation{
		Name:       opImportSourceCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSourceCredentialsInput{}
	}

	output = &ImportSourceCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSourceCredentials API operation for AWS CodeBuild.
//
// Imports the source repository credentials for an AWS CodeBuild project that
// has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ImportSourceCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeAccountLimitExceededException "AccountLimitExceededException"
//   An AWS service limit was exceeded for the calling AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials
func (c *CodeBuild) ImportSourceCredentials(input *ImportSourceCredentialsInput) (*ImportSourceCredentialsOutput, error) {
	req, out := c.ImportSourceCredentialsRequest(input)
	return out, req.Send()
}

// ImportSourceCredentialsWithContext is the same as ImportSourceCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See ImportSourceCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ImportSourceCredentialsWithContext(ctx aws.Context, input *ImportSourceCredentialsInput, opts ...request.Option) (*ImportSourceCredentialsOutput, error) {
	req, out := c.ImportSourceCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvalidateProjectCache = "InvalidateProjectCache"

// InvalidateProjectCacheRequest generates a "aws/request.Request" representing the
// client's request for the InvalidateProjectCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvalidateProjectCache for more information on using the InvalidateProjectCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvalidateProjectCacheRequest method.
//    req, resp := client.InvalidateProjectCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache
func (c *CodeBuild) InvalidateProjectCacheRequest(input *InvalidateProjectCacheInput) (req *request.Request, output *InvalidateProjectCacheOutput) {
	op := &request.Operation{
		Name:       opInvalidateProjectCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InvalidateProjectCacheInput{}
	}

	output = &InvalidateProjectCacheOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// InvalidateProjectCache API operation for AWS CodeBuild.
//
// Resets the cache for a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation InvalidateProjectCache for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache
func (c *CodeBuild) InvalidateProjectCache(input *InvalidateProjectCacheInput) (*InvalidateProjectCacheOutput, error) {
	req, out := c.InvalidateProjectCacheRequest(input)
	return out, req.Send()
}

// InvalidateProjectCacheWithContext is the same as InvalidateProjectCache with the addition of
// the ability to pass a context and additional request options.
//
// See InvalidateProjectCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) InvalidateProjectCacheWithContext(ctx aws.Context, input *InvalidateProjectCacheInput, opts ...request.Option) (*InvalidateProjectCacheOutput, error) {
	req, out := c.InvalidateProjectCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuilds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuilds for more information on using the ListBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBuildsRequest method.
//    req, resp := client.ListBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds
func (c *CodeBuild) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	output = &ListBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuilds API operation for AWS CodeBuild.
//
// Gets a list of build IDs, with each build ID representing a single build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds
func (c *CodeBuild) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	return out, req.Send()
}

// ListBuildsWithContext is the same as ListBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListBuildsWithContext(ctx aws.Context, input *ListBuildsInput, opts ...request.Option) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuildsForProject = "ListBuildsForProject"

// ListBuildsForProjectRequest generates a "aws/request.Request" representing the
// client's request for the ListBuildsForProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuildsForProject for more information on using the ListBuildsForProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBuildsForProjectRequest method.
//    req, resp := client.ListBuildsForProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject
func (c *CodeBuild) ListBuildsForProjectRequest(input *ListBuildsForProjectInput) (req *request.Request, output *ListBuildsForProjectOutput) {
	op := &request.Operation{
		Name:       opListBuildsForProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsForProjectInput{}
	}

	output = &ListBuildsForProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuildsForProject API operation for AWS CodeBuild.
//
// Gets a list of build IDs for the specified build project, with each build
// ID representing a single build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListBuildsForProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject
func (c *CodeBuild) ListBuildsForProject(input *ListBuildsForProjectInput) (*ListBuildsForProjectOutput, error) {
	req, out := c.ListBuildsForProjectRequest(input)
	return out, req.Send()
}

// ListBuildsForProjectWithContext is the same as ListBuildsForProject with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuildsForProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListBuildsForProjectWithContext(ctx aws.Context, input *ListBuildsForProjectInput, opts ...request.Option) (*ListBuildsForProjectOutput, error) {
	req, out := c.ListBuildsForProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCuratedEnvironmentImages = "ListCuratedEnvironmentImages"

// ListCuratedEnvironmentImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListCuratedEnvironmentImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCuratedEnvironmentImages for more information on using the ListCuratedEnvironmentImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCuratedEnvironmentImagesRequest method.
//    req, resp := client.ListCuratedEnvironmentImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages
func (c *CodeBuild) ListCuratedEnvironmentImagesRequest(input *ListCuratedEnvironmentImagesInput) (req *request.Request, output *ListCuratedEnvironmentImagesOutput) {
	op := &request.Operation{
		Name:       opListCuratedEnvironmentImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCuratedEnvironmentImagesInput{}
	}

	output = &ListCuratedEnvironmentImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCuratedEnvironmentImages API operation for AWS CodeBuild.
//
// Gets information about Docker images that are managed by AWS CodeBuild.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListCuratedEnvironmentImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages
func (c *CodeBuild) ListCuratedEnvironmentImages(input *ListCuratedEnvironmentImagesInput) (*ListCuratedEnvironmentImagesOutput, error) {
	req, out := c.ListCuratedEnvironmentImagesRequest(input)
	return out, req.Send()
}

// ListCuratedEnvironmentImagesWithContext is the same as ListCuratedEnvironmentImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListCuratedEnvironmentImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListCuratedEnvironmentImagesWithContext(ctx aws.Context, input *ListCuratedEnvironmentImagesInput, opts ...request.Option) (*ListCuratedEnvironmentImagesOutput, error) {
	req, out := c.ListCuratedEnvironmentImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects
func (c *CodeBuild) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS CodeBuild.
//
// Gets a list of build project names, with each build project name representing
// a single build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects
func (c *CodeBuild) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSourceCredentials = "ListSourceCredentials"

// ListSourceCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ListSourceCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSourceCredentials for more information on using the ListSourceCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSourceCredentialsRequest method.
//    req, resp := client.ListSourceCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials
func (c *CodeBuild) ListSourceCredentialsRequest(input *ListSourceCredentialsInput) (req *request.Request, output *ListSourceCredentialsOutput) {
	op := &request.Operation{
		Name:       opListSourceCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSourceCredentialsInput{}
	}

	output = &ListSourceCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSourceCredentials API operation for AWS CodeBuild.
//
// Returns a list of SourceCredentialsInfo objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListSourceCredentials for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials
func (c *CodeBuild) ListSourceCredentials(input *ListSourceCredentialsInput) (*ListSourceCredentialsOutput, error) {
	req, out := c.ListSourceCredentialsRequest(input)
	return out, req.Send()
}

// ListSourceCredentialsWithContext is the same as ListSourceCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See ListSourceCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListSourceCredentialsWithContext(ctx aws.Context, input *ListSourceCredentialsInput, opts ...request.Option) (*ListSourceCredentialsOutput, error) {
	req, out := c.ListSourceCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBuild = "StartBuild"

// StartBuildRequest generates a "aws/request.Request" representing the
// client's request for the StartBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBuild for more information on using the StartBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartBuildRequest method.
//    req, resp := client.StartBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild
func (c *CodeBuild) StartBuildRequest(input *StartBuildInput) (req *request.Request, output *StartBuildOutput) {
	op := &request.Operation{
		Name:       opStartBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartBuildInput{}
	}

	output = &StartBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBuild API operation for AWS CodeBuild.
//
// Starts running a build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation StartBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
//   * ErrCodeAccountLimitExceededException "AccountLimitExceededException"
//   An AWS service limit was exceeded for the calling AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild
func (c *CodeBuild) StartBuild(input *StartBuildInput) (*StartBuildOutput, error) {
	req, out := c.StartBuildRequest(input)
	return out, req.Send()
}

// StartBuildWithContext is the same as StartBuild with the addition of
// the ability to pass a context and additional request options.
//
// See StartBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) StartBuildWithContext(ctx aws.Context, input *StartBuildInput, opts ...request.Option) (*StartBuildOutput, error) {
	req, out := c.StartBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBuild = "StopBuild"

// StopBuildRequest generates a "aws/request.Request" representing the
// client's request for the StopBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopBuild for more information on using the StopBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopBuildRequest method.
//    req, resp := client.StopBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild
func (c *CodeBuild) StopBuildRequest(input *StopBuildInput) (req *request.Request, output *StopBuildOutput) {
	op := &request.Operation{
		Name:       opStopBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopBuildInput{}
	}

	output = &StopBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopBuild API operation for AWS CodeBuild.
//
// Attempts to stop running a build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation StopBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild
func (c *CodeBuild) StopBuild(input *StopBuildInput) (*StopBuildOutput, error) {
	req, out := c.StopBuildRequest(input)
	return out, req.Send()
}

// StopBuildWithContext is the same as StopBuild with the addition of
// the ability to pass a context and additional request options.
//
// See StopBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) StopBuildWithContext(ctx aws.Context, input *StopBuildInput, opts ...request.Option) (*StopBuildOutput, error) {
	req, out := c.StopBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject
func (c *CodeBuild) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS CodeBuild.
//
// Changes the settings of a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation UpdateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject
func (c *CodeBuild) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebhook = "UpdateWebhook"

// UpdateWebhookRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebhook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWebhook for more information on using the UpdateWebhook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWebhookRequest method.
//    req, resp := client.UpdateWebhookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook
func (c *CodeBuild) UpdateWebhookRequest(input *UpdateWebhookInput) (req *request.Request, output *UpdateWebhookOutput) {
	op := &request.Operation{
		Name:       opUpdateWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebhookInput{}
	}

	output = &UpdateWebhookOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWebhook API operation for AWS CodeBuild.
//
// Updates the webhook associated with an AWS CodeBuild build project.
//
// If you use Bitbucket for your repository, rotateSecret is ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation UpdateWebhook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
//   * ErrCodeOAuthProviderException "OAuthProviderException"
//   There was a problem with the underlying OAuth provider.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook
func (c *CodeBuild) UpdateWebhook(input *UpdateWebhookInput) (*UpdateWebhookOutput, error) {
	req, out := c.UpdateWebhookRequest(input)
	return out, req.Send()
}

// UpdateWebhookWithContext is the same as UpdateWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) UpdateWebhookWithContext(ctx aws.Context, input *UpdateWebhookInput, opts ...request.Option) (*UpdateWebhookOutput, error) {
	req, out := c.UpdateWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchDeleteBuildsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the builds to delete.
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteBuildsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchDeleteBuildsInput) SetIds(v []*string) *BatchDeleteBuildsInput {
	s.Ids = v
	return s
}

type BatchDeleteBuildsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the builds that were successfully deleted.
	BuildsDeleted []*string `locationName:"buildsDeleted" min:"1" type:"list"`

	// Information about any builds that could not be successfully deleted.
	BuildsNotDeleted []*BuildNotDeleted `locationName:"buildsNotDeleted" type:"list"`
}

// String returns the string representation
func (s BatchDeleteBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteBuildsOutput) GoString() string {
	return s.String()
}

// SetBuildsDeleted sets the BuildsDeleted field's value.
func (s *BatchDeleteBuildsOutput) SetBuildsDeleted(v []*string) *BatchDeleteBuildsOutput {
	s.BuildsDeleted = v
	return s
}

// SetBuildsNotDeleted sets the BuildsNotDeleted field's value.
func (s *BatchDeleteBuildsOutput) SetBuildsNotDeleted(v []*BuildNotDeleted) *BatchDeleteBuildsOutput {
	s.BuildsNotDeleted = v
	return s
}

type BatchGetBuildsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the builds.
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetBuildsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchGetBuildsInput) SetIds(v []*string) *BatchGetBuildsInput {
	s.Ids = v
	return s
}

type BatchGetBuildsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the requested builds.
	Builds []*Build `locationName:"builds" type:"list"`

	// The IDs of builds for which information could not be found.
	BuildsNotFound []*string `locationName:"buildsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetBuildsOutput) GoString() string {
	return s.String()
}

// SetBuilds sets the Builds field's value.
func (s *BatchGetBuildsOutput) SetBuilds(v []*Build) *BatchGetBuildsOutput {
	s.Builds = v
	return s
}

// SetBuildsNotFound sets the BuildsNotFound field's value.
func (s *BatchGetBuildsOutput) SetBuildsNotFound(v []*string) *BatchGetBuildsOutput {
	s.BuildsNotFound = v
	return s
}

type BatchGetProjectsInput struct {
	_ struct{} `type:"structure"`

	// The names of the build projects.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetProjectsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *BatchGetProjectsInput) SetNames(v []*string) *BatchGetProjectsInput {
	s.Names = v
	return s
}

type BatchGetProjectsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the requested build projects.
	Projects []*Project `locationName:"projects" type:"list"`

	// The names of build projects for which information could not be found.
	ProjectsNotFound []*string `locationName:"projectsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetProjectsOutput) GoString() string {
	return s.String()
}

// SetProjects sets the Projects field's value.
func (s *BatchGetProjectsOutput) SetProjects(v []*Project) *BatchGetProjectsOutput {
	s.Projects = v
	return s
}

// SetProjectsNotFound sets the ProjectsNotFound field's value.
func (s *BatchGetProjectsOutput) SetProjectsNotFound(v []*string) *BatchGetProjectsOutput {
	s.ProjectsNotFound = v
	return s
}

// Information about a build.
type Build struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Information about the output artifacts for the build.
	Artifacts *BuildArtifacts `locationName:"artifacts" type:"structure"`

	// Whether the build is complete. True if complete; otherwise, false.
	BuildComplete *bool `locationName:"buildComplete" type:"boolean"`

	// The current status of the build. Valid values include:
	//
	//    * FAILED: The build failed.
	//
	//    * FAULT: The build faulted.
	//
	//    * IN_PROGRESS: The build is still in progress.
	//
	//    * STOPPED: The build stopped.
	//
	//    * SUCCEEDED: The build succeeded.
	//
	//    * TIMED_OUT: The build timed out.
	BuildStatus *string `locationName:"buildStatus" type:"string" enum:"StatusType"`

	// Information about the cache for the build.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// The current build phase.
	CurrentPhase *string `locationName:"currentPhase" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// This is expressed either as the Amazon Resource Name (ARN) of the CMK or,
	// if specified, the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// When the build process ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Information about the build environment for this build.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// The unique ID for the build.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The entity that started the build. Valid values include:
	//
	//    * If AWS CodePipeline started the build, the pipeline's name (for example,
	//    codepipeline/my-demo-pipeline).
	//
	//    * If an AWS Identity and Access Management (IAM) user started the build,
	//    the user's name (for example, MyUserName).
	//
	//    * If the Jenkins plugin for AWS CodeBuild started the build, the string
	//    CodeBuild-Jenkins-Plugin.
	Initiator *string `locationName:"initiator" type:"string"`

	// Information about the build's logs in Amazon CloudWatch Logs.
	Logs *LogsLocation `locationName:"logs" type:"structure"`

	// Describes a network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Information about all previous build phases that are complete and information
	// about any current build phase that is not yet complete.
	Phases []*BuildPhase `locationName:"phases" type:"list"`

	// The name of the AWS CodeBuild project.
	ProjectName *string `locationName:"projectName" min:"1" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" type:"integer"`

	// An identifier for the version of this build's source code.
	//
	//    *  For AWS CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit
	//    ID.
	//
	//    *  For AWS CodePipeline, the source revision provided by AWS CodePipeline.
	//
	//
	//    *  For Amazon Simple Storage Service (Amazon S3), this does not apply.
	ResolvedSourceVersion *string `locationName:"resolvedSourceVersion" min:"1" type:"string"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []*BuildArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSourceVersion objects. Each ProjectSourceVersion must
	// be one of:
	//
	//    * For AWS CodeCommit: the commit ID to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	SecondarySourceVersions []*ProjectSourceVersion `locationName:"secondarySourceVersions" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []*ProjectSource `locationName:"secondarySources" type:"list"`

	// The name of a service role used for this build.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the source code to be built.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// Any version identifier for the version of the source code to be built.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`

	// When the build process started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// How long, in minutes, for AWS CodeBuild to wait before timing out this build
	// if it does not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" type:"integer"`

	// If your AWS CodeBuild project accesses resources in an Amazon VPC, you provide
	// this parameter that identifies the VPC ID and the list of security group
	// IDs and subnet IDs. The security groups and subnets must belong to the same
	// VPC. You must provide at least one security group and one subnet ID.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Build) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Build) SetArn(v string) *Build {
	s.Arn = &v
	return s
}

// SetArtifacts sets the Artifacts field's value.
func (s *Build) SetArtifacts(v *BuildArtifacts) *Build {
	s.Artifacts = v
	return s
}

// SetBuildComplete sets the BuildComplete field's value.
func (s *Build) SetBuildComplete(v bool) *Build {
	s.BuildComplete = &v
	return s
}

// SetBuildStatus sets the BuildStatus field's value.
func (s *Build) SetBuildStatus(v string) *Build {
	s.BuildStatus = &v
	return s
}

// SetCache sets the Cache field's value.
func (s *Build) SetCache(v *ProjectCache) *Build {
	s.Cache = v
	return s
}

// SetCurrentPhase sets the CurrentPhase field's value.
func (s *Build) SetCurrentPhase(v string) *Build {
	s.CurrentPhase = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *Build) SetEncryptionKey(v string) *Build {
	s.EncryptionKey = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Build) SetEndTime(v time.Time) *Build {
	s.EndTime = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Build) SetEnvironment(v *ProjectEnvironment) *Build {
	s.Environment = v
	return s
}

// SetId sets the Id field's value.
func (s *Build) SetId(v string) *Build {
	s.Id = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *Build) SetInitiator(v string) *Build {
	s.Initiator = &v
	return s
}

// SetLogs sets the Logs field's value.
func (s *Build) SetLogs(v *LogsLocation) *Build {
	s.Logs = v
	return s
}

// SetNetworkInterface sets the NetworkInterface field's value.
func (s *Build) SetNetworkInterface(v *NetworkInterface) *Build {
	s.NetworkInterface = v
	return s
}

// SetPhases sets the Phases field's value.
func (s *Build) SetPhases(v []*BuildPhase) *Build {
	s.Phases = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *Build) SetProjectName(v string) *Build {
	s.ProjectName = &v
	return s
}

// SetQueuedTimeoutInMinutes sets the QueuedTimeoutInMinutes field's value.
func (s *Build) SetQueuedTimeoutInMinutes(v int64) *Build {
	s.QueuedTimeoutInMinutes = &v
	return s
}

// SetResolvedSourceVersion sets the ResolvedSourceVersion field's value.
func (s *Build) SetResolvedSourceVersion(v string) *Build {
	s.ResolvedSourceVersion = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *Build) SetSecondaryArtifacts(v []*BuildArtifacts) *Build {
	s.SecondaryArtifacts = v
	return s
}

// SetSecondarySourceVersions sets the SecondarySourceVersions field's value.
func (s *Build) SetSecondarySourceVersions(v []*ProjectSourceVersion) *Build {
	s.SecondarySourceVersions = v
	return s
}

// SetSecondarySources sets the SecondarySources field's value.
func (s *Build) SetSecondarySources(v []*ProjectSource) *Build {
	s.SecondarySources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Build) SetServiceRole(v string) *Build {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Build) SetSource(v *ProjectSource) *Build {
	s.Source = v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *Build) SetSourceVersion(v string) *Build {
	s.SourceVersion = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Build) SetStartTime(v time.Time) *Build {
	s.StartTime = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Build) SetTimeoutInMinutes(v int64) *Build {
	s.TimeoutInMinutes = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Build) SetVpcConfig(v *VpcConfig) *Build {
	s.VpcConfig = v
	return s
}

// Information about build output artifacts.
type BuildArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Information that tells you if encryption for build artifacts is disabled.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the location of the build artifacts.
	Location *string `locationName:"location" type:"string"`

	// The MD5 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Md5sum *string `locationName:"md5sum" type:"string"`

	// If this flag is set, a name specified in the build spec file overrides the
	// artifact name. The name specified in a build spec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The SHA-256 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Sha256sum *string `locationName:"sha256sum" type:"string"`
}

// String returns the string representation
func (s BuildArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildArtifacts) GoString() string {
	return s.String()
}

// SetArtifactIdentifier sets the ArtifactIdentifier field's value.
func (s *BuildArtifacts) SetArtifactIdentifier(v string) *BuildArtifacts {
	s.ArtifactIdentifier = &v
	return s
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *BuildArtifacts) SetEncryptionDisabled(v bool) *BuildArtifacts {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *BuildArtifacts) SetLocation(v string) *BuildArtifacts {
	s.Location = &v
	return s
}

// SetMd5sum sets the Md5sum field's value.
func (s *BuildArtifacts) SetMd5sum(v string) *BuildArtifacts {
	s.Md5sum = &v
	return s
}

// SetOverrideArtifactName sets the OverrideArtifactName field's value.
func (s *BuildArtifacts) SetOverrideArtifactName(v bool) *BuildArtifacts {
	s.OverrideArtifactName = &v
	return s
}

// SetSha256sum sets the Sha256sum field's value.
func (s *BuildArtifacts) SetSha256sum(v string) *BuildArtifacts {
	s.Sha256sum = &v
	return s
}

// Information about a build that could not be successfully deleted.
type BuildNotDeleted struct {
	_ struct{} `type:"structure"`

	// The ID of the build that could not be successfully deleted.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Additional information about the build that could not be successfully deleted.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s BuildNotDeleted) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildNotDeleted) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *BuildNotDeleted) SetId(v string) *BuildNotDeleted {
	s.Id = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BuildNotDeleted) SetStatusCode(v string) *BuildNotDeleted {
	s.StatusCode = &v
	return s
}

// Information about a stage for a build.
type BuildPhase struct {
	_ struct{} `type:"structure"`

	// Additional information about a build phase, especially to help troubleshoot
	// a failed build.
	Contexts []*PhaseContext `locationName:"contexts" type:"list"`

	// How long, in seconds, between the starting and ending times of the build's
	// phase.
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"long"`

	// When the build phase ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The current status of the build phase. Valid values include:
	//
	//    * FAILED: The build phase failed.
	//
	//    * FAULT: The build phase faulted.
	//
	//    * IN_PROGRESS: The build phase is still in progress.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * STOPPED: The build phase stopped.
	//
	//    * SUCCEEDED: The build phase succeeded.
	//
	//    * TIMED_OUT: The build phase timed out.
	PhaseStatus *string `locationName:"phaseStatus" type:"string" enum:"StatusType"`

	// The name of the build phase. Valid values include:
	//
	//    * BUILD: Core build activities typically occur in this build phase.
	//
	//    * COMPLETED: The build has been completed.
	//
	//    * DOWNLOAD_SOURCE: Source code is being downloaded in this build phase.
	//
	//    * FINALIZING: The build process is completing in this build phase.
	//
	//    * INSTALL: Installation activities typically occur in this build phase.
	//
	//    * POST_BUILD: Post-build activities typically occur in this build phase.
	//
	//    * PRE_BUILD: Pre-build activities typically occur in this build phase.
	//
	//    * PROVISIONING: The build environment is being set up.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * SUBMITTED: The build has been submitted.
	//
	//    * UPLOAD_ARTIFACTS: Build output artifacts are being uploaded to the output
	//    location.
	PhaseType *string `locationName:"phaseType" type:"string" enum:"BuildPhaseType"`

	// When the build phase started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s BuildPhase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildPhase) GoString() string {
	return s.String()
}

// SetContexts sets the Contexts field's value.
func (s *BuildPhase) SetContexts(v []*PhaseContext) *BuildPhase {
	s.Contexts = v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *BuildPhase) SetDurationInSeconds(v int64) *BuildPhase {
	s.DurationInSeconds = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *BuildPhase) SetEndTime(v time.Time) *BuildPhase {
	s.EndTime = &v
	return s
}

// SetPhaseStatus sets the PhaseStatus field's value.
func (s *BuildPhase) SetPhaseStatus(v string) *BuildPhase {
	s.PhaseStatus = &v
	return s
}

// SetPhaseType sets the PhaseType field's value.
func (s *BuildPhase) SetPhaseType(v string) *BuildPhase {
	s.PhaseType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BuildPhase) SetStartTime(v time.Time) *BuildPhase {
	s.StartTime = &v
	return s
}

// Information about Amazon CloudWatch Logs for a build project.
type CloudWatchLogsConfig struct {
	_ struct{} `type:"structure"`

	// The group name of the logs in Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	GroupName *string `locationName:"groupName" type:"string"`

	// The current status of the logs in Amazon CloudWatch Logs for a build project.
	// Valid values are:
	//
	//    * ENABLED: Amazon CloudWatch Logs are enabled for this build project.
	//
	//    * DISABLED: Amazon CloudWatch Logs are not enabled for this build project.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"LogsConfigStatusType"`

	// The prefix of the stream name of the Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s CloudWatchLogsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLogsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogsConfig"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *CloudWatchLogsConfig) SetGroupName(v string) *CloudWatchLogsConfig {
	s.GroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CloudWatchLogsConfig) SetStatus(v string) *CloudWatchLogsConfig {
	s.Status = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CloudWatchLogsConfig) SetStreamName(v string) *CloudWatchLogsConfig {
	s.StreamName = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// Information about the build output artifacts for the build project.
	//
	// Artifacts is a required field
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure" required:"true"`

	// Set this to true to generate a publicly accessible URL for your project's
	// build badge.
	BadgeEnabled *bool `locationName:"badgeEnabled" type:"boolean"`

	// Stores recently used information so that it can be quickly accessed at a
	// later time.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for the build project.
	//
	// Environment is a required field
	Environment *ProjectEnvironment `locationName:"environment" type:"structure" required:"true"`

	// Information about logs for the build project. These can be logs in Amazon
	// CloudWatch Logs, logs uploaded to a specified S3 bucket, or both.
	LogsConfig *LogsConfig `locationName:"logsConfig" type:"structure"`

	// The name of the build project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"2" type:"string" required:"true"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" min:"5" type:"integer"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []*ProjectArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []*ProjectSource `locationName:"secondarySources" type:"list"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	//
	// ServiceRole is a required field
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string" required:"true"`

	// Information about the build input source code for the build project.
	//
	// Source is a required field
	Source *ProjectSource `locationName:"source" type:"structure" required:"true"`

	// A set of tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// before it times out any build that has not been marked as completed. The
	// default is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`

	// VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.Artifacts == nil {
		invalidParams.Add(request.NewErrParamRequired("Artifacts"))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Environment == nil {
		invalidParams.Add(request.NewErrParamRequired("Environment"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.QueuedTimeoutInMinutes != nil && *s.QueuedTimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("QueuedTimeoutInMinutes", 5))
	}
	if s.ServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRole"))
	}
	if s.ServiceRole != nil && len(*s.ServiceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRole", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 5))
	}
	if s.Artifacts != nil {
		if err := s.Artifacts.Validate(); err != nil {
			invalidParams.AddNested("Artifacts", err.(request.ErrInvalidParams))
		}
	}
	if s.Cache != nil {
		if err := s.Cache.Validate(); err != nil {
			invalidParams.AddNested("Cache", err.(request.ErrInvalidParams))
		}
	}
	if s.Environment != nil {
		if err := s.Environment.Validate(); err != nil {
			invalidParams.AddNested("Environment", err.(request.ErrInvalidParams))
		}
	}
	if s.LogsConfig != nil {
		if err := s.LogsConfig.Validate(); err != nil {
			invalidParams.AddNested("LogsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SecondaryArtifacts != nil {
		for i, v := range s.SecondaryArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondaryArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecondarySources != nil {
		for i, v := range s.SecondarySources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondarySources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifacts sets the Artifacts field's value.
func (s *CreateProjectInput) SetArtifacts(v *ProjectArtifacts) *CreateProjectInput {
	s.Artifacts = v
	return s
}

// SetBadgeEnabled sets the BadgeEnabled field's value.
func (s *CreateProjectInput) SetBadgeEnabled(v bool) *CreateProjectInput {
	s.BadgeEnabled = &v
	return s
}

// SetCache sets the Cache field's value.
func (s *CreateProjectInput) SetCache(v *ProjectCache) *CreateProjectInput {
	s.Cache = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateProjectInput) SetEncryptionKey(v string) *CreateProjectInput {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateProjectInput) SetEnvironment(v *ProjectEnvironment) *CreateProjectInput {
	s.Environment = v
	return s
}

// SetLogsConfig sets the LogsConfig field's value.
func (s *CreateProjectInput) SetLogsConfig(v *LogsConfig) *CreateProjectInput {
	s.LogsConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetQueuedTimeoutInMinutes sets the QueuedTimeoutInMinutes field's value.
func (s *CreateProjectInput) SetQueuedTimeoutInMinutes(v int64) *CreateProjectInput {
	s.QueuedTimeoutInMinutes = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *CreateProjectInput) SetSecondaryArtifacts(v []*ProjectArtifacts) *CreateProjectInput {
	s.SecondaryArtifacts = v
	return s
}

// SetSecondarySources sets the SecondarySources field's value.
func (s *CreateProjectInput) SetSecondarySources(v []*ProjectSource) *CreateProjectInput {
	s.SecondarySources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CreateProjectInput) SetServiceRole(v string) *CreateProjectInput {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateProjectInput) SetSource(v *ProjectSource) *CreateProjectInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v []*Tag) *CreateProjectInput {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *CreateProjectInput) SetTimeoutInMinutes(v int64) *CreateProjectInput {
	s.TimeoutInMinutes = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateProjectInput) SetVpcConfig(v *VpcConfig) *CreateProjectInput {
	s.VpcConfig = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build project that was created.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *CreateProjectOutput) SetProject(v *Project) *CreateProjectOutput {
	s.Project = v
	return s
}

type CreateWebhookInput struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebhookInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchFilter sets the BranchFilter field's value.
func (s *CreateWebhookInput) SetBranchFilter(v string) *CreateWebhookInput {
	s.BranchFilter = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateWebhookInput) SetProjectName(v string) *CreateWebhookInput {
	s.ProjectName = &v
	return s
}

type CreateWebhookOutput struct {
	_ struct{} `type:"structure"`

	// Information about a webhook that connects repository events to a build project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s CreateWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebhookOutput) GoString() string {
	return s.String()
}

// SetWebhook sets the Webhook field's value.
func (s *CreateWebhookOutput) SetWebhook(v *Webhook) *CreateWebhookOutput {
	s.Webhook = v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the build project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteProjectInput) SetName(v string) *DeleteProjectInput {
	s.Name = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DeleteSourceCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSourceCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSourceCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSourceCredentialsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteSourceCredentialsInput) SetArn(v string) *DeleteSourceCredentialsInput {
	s.Arn = &v
	return s
}

type DeleteSourceCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSourceCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSourceCredentialsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteSourceCredentialsOutput) SetArn(v string) *DeleteSourceCredentialsOutput {
	s.Arn = &v
	return s
}

type DeleteWebhookInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWebhookInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteWebhookInput) SetProjectName(v string) *DeleteWebhookInput {
	s.ProjectName = &v
	return s
}

type DeleteWebhookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebhookOutput) GoString() string {
	return s.String()
}

// Information about a Docker image that is managed by AWS CodeBuild.
type EnvironmentImage struct {
	_ struct{} `type:"structure"`

	// The description of the Docker image.
	Description *string `locationName:"description" type:"string"`

	// The name of the Docker image.
	Name *string `locationName:"name" type:"string"`

	// A list of environment image versions.
	Versions []*string `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s EnvironmentImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentImage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EnvironmentImage) SetDescription(v string) *EnvironmentImage {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentImage) SetName(v string) *EnvironmentImage {
	s.Name = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *EnvironmentImage) SetVersions(v []*string) *EnvironmentImage {
	s.Versions = v
	return s
}

// A set of Docker images that are related by programming language and are managed
// by AWS CodeBuild.
type EnvironmentLanguage struct {
	_ struct{} `type:"structure"`

	// The list of Docker images that are related by the specified programming language.
	Images []*EnvironmentImage `locationName:"images" type:"list"`

	// The programming language for the Docker images.
	Language *string `locationName:"language" type:"string" enum:"LanguageType"`
}

// String returns the string representation
func (s EnvironmentLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentLanguage) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *EnvironmentLanguage) SetImages(v []*EnvironmentImage) *EnvironmentLanguage {
	s.Images = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *EnvironmentLanguage) SetLanguage(v string) *EnvironmentLanguage {
	s.Language = &v
	return s
}

// A set of Docker images that are related by platform and are managed by AWS
// CodeBuild.
type EnvironmentPlatform struct {
	_ struct{} `type:"structure"`

	// The list of programming languages that are available for the specified platform.
	Languages []*EnvironmentLanguage `locationName:"languages" type:"list"`

	// The platform's name.
	Platform *string `locationName:"platform" type:"string" enum:"PlatformType"`
}

// String returns the string representation
func (s EnvironmentPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentPlatform) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *EnvironmentPlatform) SetLanguages(v []*EnvironmentLanguage) *EnvironmentPlatform {
	s.Languages = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EnvironmentPlatform) SetPlatform(v string) *EnvironmentPlatform {
	s.Platform = &v
	return s
}

// Information about an environment variable for a build project or a build.
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name or key of the environment variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of environment variable. Valid values include:
	//
	//    * PARAMETER_STORE: An environment variable stored in Amazon EC2 Systems
	//    Manager Parameter Store.
	//
	//    * PLAINTEXT: An environment variable in plaintext format.
	Type *string `locationName:"type" type:"string" enum:"EnvironmentVariableType"`

	// The value of the environment variable.
	//
	// We strongly discourage the use of environment variables to store sensitive
	// values, especially AWS secret key IDs and secret access keys. Environment
	// variables can be displayed in plain text using the AWS CodeBuild console
	// and the AWS Command Line Interface (AWS CLI).
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EnvironmentVariable) SetName(v string) *EnvironmentVariable {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EnvironmentVariable) SetType(v string) *EnvironmentVariable {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvironmentVariable) SetValue(v string) *EnvironmentVariable {
	s.Value = &v
	return s
}

type ImportSourceCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The type of authentication used to connect to a GitHub, GitHub Enterprise,
	// or Bitbucket repository. An OAUTH connection is not supported by the API
	// and must be created using the AWS CodeBuild console.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"AuthType"`

	// The source provider used for this project.
	//
	// ServerType is a required field
	ServerType *string `locationName:"serverType" type:"string" required:"true" enum:"ServerType"`

	// For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket,
	// this is the app password.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"1" type:"string" required:"true" sensitive:"true"`

	// The Bitbucket username when the authType is BASIC_AUTH. This parameter is
	// not valid for other types of source providers or connections.
	Username *string `locationName:"username" min:"1" type:"string"`
}

// String returns the string representation
func (s ImportSourceCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSourceCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSourceCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSourceCredentialsInput"}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.ServerType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerType"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *ImportSourceCredentialsInput) SetAuthType(v string) *ImportSourceCredentialsInput {
	s.AuthType = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *ImportSourceCredentialsInput) SetServerType(v string) *ImportSourceCredentialsInput {
	s.ServerType = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ImportSourceCredentialsInput) SetToken(v string) *ImportSourceCredentialsInput {
	s.Token = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *ImportSourceCredentialsInput) SetUsername(v string) *ImportSourceCredentialsInput {
	s.Username = &v
	return s
}

type ImportSourceCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`
}

// String returns the string representation
func (s ImportSourceCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSourceCredentialsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImportSourceCredentialsOutput) SetArn(v string) *ImportSourceCredentialsOutput {
	s.Arn = &v
	return s
}

type InvalidateProjectCacheInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeBuild build project that the cache is reset for.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidateProjectCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidateProjectCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvalidateProjectCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvalidateProjectCacheInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *InvalidateProjectCacheInput) SetProjectName(v string) *InvalidateProjectCacheInput {
	s.ProjectName = &v
	return s
}

type InvalidateProjectCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s InvalidateProjectCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidateProjectCacheOutput) GoString() string {
	return s.String()
}

type ListBuildsForProjectInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListBuildsForProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsForProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsForProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuildsForProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsForProjectInput) SetNextToken(v string) *ListBuildsForProjectInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListBuildsForProjectInput) SetProjectName(v string) *ListBuildsForProjectInput {
	s.ProjectName = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListBuildsForProjectInput) SetSortOrder(v string) *ListBuildsForProjectInput {
	s.SortOrder = &v
	return s
}

type ListBuildsForProjectOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs for the specified build project, with each build ID representing
	// a single build.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsForProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsForProjectOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListBuildsForProjectOutput) SetIds(v []*string) *ListBuildsForProjectOutput {
	s.Ids = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsForProjectOutput) SetNextToken(v string) *ListBuildsForProjectOutput {
	s.NextToken = &v
	return s
}

type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsInput) SetNextToken(v string) *ListBuildsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListBuildsInput) SetSortOrder(v string) *ListBuildsInput {
	s.SortOrder = &v
	return s
}

type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs, with each build ID representing a single build.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListBuildsOutput) SetIds(v []*string) *ListBuildsOutput {
	s.Ids = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsOutput) SetNextToken(v string) *ListBuildsOutput {
	s.NextToken = &v
	return s
}

type ListCuratedEnvironmentImagesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCuratedEnvironmentImagesInput) GoString() string {
	return s.String()
}

type ListCuratedEnvironmentImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about supported platforms for Docker images that are managed
	// by AWS CodeBuild.
	Platforms []*EnvironmentPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCuratedEnvironmentImagesOutput) GoString() string {
	return s.String()
}

// SetPlatforms sets the Platforms field's value.
func (s *ListCuratedEnvironmentImagesOutput) SetPlatforms(v []*EnvironmentPlatform) *ListCuratedEnvironmentImagesOutput {
	s.Platforms = v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The criterion to be used to list build project names. Valid values include:
	//
	//    * CREATED_TIME: List based on when each build project was created.
	//
	//    * LAST_MODIFIED_TIME: List based on when information about each build
	//    project was last changed.
	//
	//    * NAME: List based on each build project's name.
	//
	// Use sortOrder to specify in what order to list the build project names based
	// on the preceding criteria.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ProjectSortByType"`

	// The order in which to list build projects. Valid values include:
	//
	//    * ASCENDING: List in ascending order.
	//
	//    * DESCENDING: List in descending order.
	//
	// Use sortBy to specify the criterion to be used to list build project names.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListProjectsInput) SetSortBy(v string) *ListProjectsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListProjectsInput) SetSortOrder(v string) *ListProjectsInput {
	s.SortOrder = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of build project names, with each build project name representing
	// a single build project.
	Projects []*string `locationName:"projects" min:"1" type:"list"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*string) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListSourceCredentialsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListSourceCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSourceCredentialsInput) GoString() string {
	return s.String()
}

type ListSourceCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A list of SourceCredentialsInfo objects. Each SourceCredentialsInfo object
	// includes the authentication type, token ARN, and type of source provider
	// for one set of credentials.
	SourceCredentialsInfos []*SourceCredentialsInfo `locationName:"sourceCredentialsInfos" type:"list"`
}

// String returns the string representation
func (s ListSourceCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSourceCredentialsOutput) GoString() string {
	return s.String()
}

// SetSourceCredentialsInfos sets the SourceCredentialsInfos field's value.
func (s *ListSourceCredentialsOutput) SetSourceCredentialsInfos(v []*SourceCredentialsInfo) *ListSourceCredentialsOutput {
	s.SourceCredentialsInfos = v
	return s
}

// Information about logs for a build project. These can be logs in Amazon CloudWatch
// Logs, built in a specified S3 bucket, or both.
type LogsConfig struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project. Amazon CloudWatch
	// Logs are enabled by default.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// Information about logs built to an S3 bucket for a build project. S3 logs
	// are not enabled by default.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogsConfig"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *LogsConfig) SetCloudWatchLogs(v *CloudWatchLogsConfig) *LogsConfig {
	s.CloudWatchLogs = v
	return s
}

// SetS3Logs sets the S3Logs field's value.
func (s *LogsConfig) SetS3Logs(v *S3LogsConfig) *LogsConfig {
	s.S3Logs = v
	return s
}

// Information about build logs in Amazon CloudWatch Logs.
type LogsLocation struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// The URL to an individual build log in Amazon CloudWatch Logs.
	DeepLink *string `locationName:"deepLink" type:"string"`

	// The name of the Amazon CloudWatch Logs group for the build logs.
	GroupName *string `locationName:"groupName" type:"string"`

	// The URL to a build log in an S3 bucket.
	S3DeepLink *string `locationName:"s3DeepLink" type:"string"`

	// Information about S3 logs for a build project.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`

	// The name of the Amazon CloudWatch Logs stream for the build logs.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s LogsLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogsLocation) GoString() string {
	return s.String()
}

// SetCloudWatchLogs sets the CloudWatchLogs field's value.
func (s *LogsLocation) SetCloudWatchLogs(v *CloudWatchLogsConfig) *LogsLocation {
	s.CloudWatchLogs = v
	return s
}

// SetDeepLink sets the DeepLink field's value.
func (s *LogsLocation) SetDeepLink(v string) *LogsLocation {
	s.DeepLink = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *LogsLocation) SetGroupName(v string) *LogsLocation {
	s.GroupName = &v
	return s
}

// SetS3DeepLink sets the S3DeepLink field's value.
func (s *LogsLocation) SetS3DeepLink(v string) *LogsLocation {
	s.S3DeepLink = &v
	return s
}

// SetS3Logs sets the S3Logs field's value.
func (s *LogsLocation) SetS3Logs(v *S3LogsConfig) *LogsLocation {
	s.S3Logs = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *LogsLocation) SetStreamName(v string) *LogsLocation {
	s.StreamName = &v
	return s
}

// Describes a network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" min:"1" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkInterface) SetSubnetId(v string) *NetworkInterface {
	s.SubnetId = &v
	return s
}

// Additional information about a build phase that has an error. You can use
// this information for troubleshooting.
type PhaseContext struct {
	_ struct{} `type:"structure"`

	// An explanation of the build phase's context. This might include a command
	// ID and an exit code.
	Message *string `locationName:"message" type:"string"`

	// The status code for the context of the build phase.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s PhaseContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhaseContext) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *PhaseContext) SetMessage(v string) *PhaseContext {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *PhaseContext) SetStatusCode(v string) *PhaseContext {
	s.StatusCode = &v
	return s
}

// Information about a build project.
type Project struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build project.
	Arn *string `locationName:"arn" type:"string"`

	// Information about the build output artifacts for the build project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// Information about the build badge for the build project.
	Badge *ProjectBadge `locationName:"badge" type:"structure"`

	// Information about the cache for the build project.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// When the build project was created, expressed in Unix time format.
	Created *time.Time `locationName:"created" type:"timestamp"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// This is expressed either as the Amazon Resource Name (ARN) of the CMK or,
	// if specified, the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for this build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// When the build project's settings were last modified, expressed in Unix time
	// format.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp"`

	// Information about logs for the build project. A project can create logs in
	// Amazon CloudWatch Logs, an S3 bucket, or both.
	LogsConfig *LogsConfig `locationName:"logsConfig" type:"structure"`

	// The name of the build project.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" min:"5" type:"integer"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []*ProjectArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []*ProjectSource `locationName:"secondarySources" type:"list"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the build input source code for this build project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// The tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// before timing out any related build that did not get marked as completed.
	// The default is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`

	// Information about a webhook that connects repository events to a build project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Project) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Project) SetArn(v string) *Project {
	s.Arn = &v
	return s
}

// SetArtifacts sets the Artifacts field's value.
func (s *Project) SetArtifacts(v *ProjectArtifacts) *Project {
	s.Artifacts = v
	return s
}

// SetBadge sets the Badge field's value.
func (s *Project) SetBadge(v *ProjectBadge) *Project {
	s.Badge = v
	return s
}

// SetCache sets the Cache field's value.
func (s *Project) SetCache(v *ProjectCache) *Project {
	s.Cache = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Project) SetCreated(v time.Time) *Project {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Project) SetDescription(v string) *Project {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *Project) SetEncryptionKey(v string) *Project {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Project) SetEnvironment(v *ProjectEnvironment) *Project {
	s.Environment = v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Project) SetLastModified(v time.Time) *Project {
	s.LastModified = &v
	return s
}

// SetLogsConfig sets the LogsConfig field's value.
func (s *Project) SetLogsConfig(v *LogsConfig) *Project {
	s.LogsConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// SetQueuedTimeoutInMinutes sets the QueuedTimeoutInMinutes field's value.
func (s *Project) SetQueuedTimeoutInMinutes(v int64) *Project {
	s.QueuedTimeoutInMinutes = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *Project) SetSecondaryArtifacts(v []*ProjectArtifacts) *Project {
	s.SecondaryArtifacts = v
	return s
}

// SetSecondarySources sets the SecondarySources field's value.
func (s *Project) SetSecondarySources(v []*ProjectSource) *Project {
	s.SecondarySources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Project) SetServiceRole(v string) *Project {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Project) SetSource(v *ProjectSource) *Project {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Project) SetTags(v []*Tag) *Project {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Project) SetTimeoutInMinutes(v int64) *Project {
	s.TimeoutInMinutes = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Project) SetVpcConfig(v *VpcConfig) *Project {
	s.VpcConfig = v
	return s
}

// SetWebhook sets the Webhook field's value.
func (s *Project) SetWebhook(v *Webhook) *Project {
	s.Webhook = v
	return s
}

// Information about the build output artifacts for the build project.
type ProjectArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Set to true if you do not want your output artifacts encrypted. This option
	// is valid only if your artifacts type is Amazon Simple Storage Service (Amazon
	// S3). If this is set with another artifacts type, an invalidInputException
	// is thrown.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the build output artifact location:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    locations instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output bucket.
	Location *string `locationName:"location" type:"string"`

	// Along with path and namespaceType, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output artifact object.
	//    If you set the name to be a forward slash ("/"), the artifact is stored
	//    in the root of the output bucket.
	//
	// For example:
	//
	//    *  If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to MyArtifact.zip, then the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	//
	//
	//    *  If path is empty, namespaceType is set to NONE, and name is set to
	//    "/", the output artifact is stored in the root of the output bucket.
	//
	//    *  If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to "/", the output artifact is stored in MyArtifacts/build-ID.
	Name *string `locationName:"name" type:"string"`

	// Along with path and name, the pattern that AWS CodeBuild uses to determine
	// the name and location to store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include:
	//
	// BUILD_ID: Include the build ID in the location of the build output artifact.
	//
	// NONE: Do not include the build ID. This is the default if namespaceType is
	//    not specified.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to BUILD_ID,
	// and name is set to MyArtifact.zip, the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	NamespaceType *string `locationName:"namespaceType" type:"string" enum:"ArtifactNamespace"`

	// If this flag is set, a name specified in the build spec file overrides the
	// artifact name. The name specified in a build spec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The type of build output artifact to create:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    artifacts instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include:
	//
	// NONE: AWS CodeBuild creates in the output bucket a folder that contains the
	//    build output. This is the default if packaging is not specified.
	//
	// ZIP: AWS CodeBuild creates in the output bucket a ZIP file that contains
	//    the build output.
	Packaging *string `locationName:"packaging" type:"string" enum:"ArtifactPackaging"`

	// Along with namespaceType and name, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the path to the output artifact. If path
	//    is not specified, path is not used.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to NONE,
	// and name is set to MyArtifact.zip, the output artifact is stored in the output
	// bucket at MyArtifacts/MyArtifact.zip.
	Path *string `locationName:"path" type:"string"`

	// The type of build output artifact. Valid values include:
	//
	//    * CODEPIPELINE: The build project has build output generated through AWS
	//    CodePipeline.
	//
	//    * NO_ARTIFACTS: The build project does not produce any build output.
	//
	//    * S3: The build project stores build output in Amazon Simple Storage Service
	//    (Amazon S3).
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactsType"`
}

// String returns the string representation
func (s ProjectArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectArtifacts) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectArtifacts) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectArtifacts"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactIdentifier sets the ArtifactIdentifier field's value.
func (s *ProjectArtifacts) SetArtifactIdentifier(v string) *ProjectArtifacts {
	s.ArtifactIdentifier = &v
	return s
}

// SetEncryptionDisabled sets the EncryptionDisabled field's value.
func (s *ProjectArtifacts) SetEncryptionDisabled(v bool) *ProjectArtifacts {
	s.EncryptionDisabled = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ProjectArtifacts) SetLocation(v string) *ProjectArtifacts {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectArtifacts) SetName(v string) *ProjectArtifacts {
	s.Name = &v
	return s
}

// SetNamespaceType sets the NamespaceType field's value.
func (s *ProjectArtifacts) SetNamespaceType(v string) *ProjectArtifacts {
	s.NamespaceType = &v
	return s
}

// SetOverrideArtifactName sets the OverrideArtifactName field's value.
func (s *ProjectArtifacts) SetOverrideArtifactName(v bool) *ProjectArtifacts {
	s.OverrideArtifactName = &v
	return s
}

// SetPackaging sets the Packaging field's value.
func (s *ProjectArtifacts) SetPackaging(v string) *ProjectArtifacts {
	s.Packaging = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ProjectArtifacts) SetPath(v string) *ProjectArtifacts {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectArtifacts) SetType(v string) *ProjectArtifacts {
	s.Type = &v
	return s
}

// Information about the build badge for the build project.
type ProjectBadge struct {
	_ struct{} `type:"structure"`

	// Set this to true to generate a publicly accessible URL for your project's
	// build badge.
	BadgeEnabled *bool `locationName:"badgeEnabled" type:"boolean"`

	// The publicly-accessible URL through which you can access the build badge
	// for your project.
	//
	// The publicly accessible URL through which you can access the build badge
	// for your project.
	BadgeRequestUrl *string `locationName:"badgeRequestUrl" type:"string"`
}

// String returns the string representation
func (s ProjectBadge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectBadge) GoString() string {
	return s.String()
}

// SetBadgeEnabled sets the BadgeEnabled field's value.
func (s *ProjectBadge) SetBadgeEnabled(v bool) *ProjectBadge {
	s.BadgeEnabled = &v
	return s
}

// SetBadgeRequestUrl sets the BadgeRequestUrl field's value.
func (s *ProjectBadge) SetBadgeRequestUrl(v string) *ProjectBadge {
	s.BadgeRequestUrl = &v
	return s
}

// Information about the cache for the build project.
type ProjectCache struct {
	_ struct{} `type:"structure"`

	// Information about the cache location:
	//
	//    * NO_CACHE: This value is ignored.
	//
	//    * S3: This is the S3 bucket name/prefix.
	Location *string `locationName:"location" type:"string"`

	// The type of cache used by the build project. Valid values include:
	//
	//    * NO_CACHE: The build project does not use any cache.
	//
	//    * S3: The build project reads and writes from and to S3.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CacheType"`
}

// String returns the string representation
func (s ProjectCache) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectCache) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectCache) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectCache"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *ProjectCache) SetLocation(v string) *ProjectCache {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectCache) SetType(v string) *ProjectCache {
	s.Type = &v
	return s
}

// Information about the build environment of the build project.
type ProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `locationName:"certificate" type:"string"`

	// Information about the compute resources the build project uses. Available
	// values include:
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds.
	//
	// ComputeType is a required field
	ComputeType *string `locationName:"computeType" type:"string" required:"true" enum:"ComputeType"`

	// A set of environment variables to make available to builds for this build
	// project.
	EnvironmentVariables []*EnvironmentVariable `locationName:"environmentVariables" type:"list"`

	// The image tag or image digest that identifies the Docker image to use for
	// this build project. Use the following formats:
	//
	//    * For an image tag: registry/repository:tag. For example, to specify an
	//    image with the tag "latest," use registry/repository:latest.
	//
	//    * For an image digest: registry/repository@digest. For example, to specify
	//    an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf,"
	//    use registry/repository@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf.
	//
	// Image is a required field
	Image *string `locationName:"image" min:"1" type:"string" required:"true"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	// There are two valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust AWS CodeBuild's
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `locationName:"imagePullCredentialsType" type:"string" enum:"ImagePullCredentialsType"`

	// Enables running the Docker daemon inside a Docker container. Set to true
	// only if the build project is be used to build Docker images, and the specified
	// build environment image is not provided by AWS CodeBuild with Docker support.
	// Otherwise, all associated builds that attempt to interact with the Docker
	// daemon fail. You must also start the Docker daemon so that builds can interact
	// with it. One way to do this is to initialize the Docker daemon during the
	// install phase of your build spec by running the following build commands.
	// (Do not run these commands if the specified build environment image is provided
	// by AWS CodeBuild with Docker support.)
	//
	// If the operating system's base image is Ubuntu Linux:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay& - timeout 15 sh -c "until docker info; do echo
	// .; sleep 1; done"
	//
	// If the operating system's base image is Alpine Linux, add the -t argument
	// to timeout:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay& - timeout 15 -t sh -c "until docker info; do echo
	// .; sleep 1; done"
	PrivilegedMode *bool `locationName:"privilegedMode" type:"boolean"`

	// The credentials for access to a private registry.
	RegistryCredential *RegistryCredential `locationName:"registryCredential" type:"structure"`

	// The type of build environment to use for related builds.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EnvironmentType"`
}

// String returns the string representation
func (s ProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectEnvironment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectEnvironment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectEnvironment"}
	if s.ComputeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeType"))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil && len(*s.Image) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Image", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.EnvironmentVariables != nil {
		for i, v := range s.EnvironmentVariables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariables", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RegistryCredential != nil {
		if err := s.RegistryCredential.Validate(); err != nil {
			invalidParams.AddNested("RegistryCredential", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ProjectEnvironment) SetCertificate(v string) *ProjectEnvironment {
	s.Certificate = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *ProjectEnvironment) SetComputeType(v string) *ProjectEnvironment {
	s.ComputeType = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *ProjectEnvironment) SetEnvironmentVariables(v []*EnvironmentVariable) *ProjectEnvironment {
	s.EnvironmentVariables = v
	return s
}

// SetImage sets the Image field's value.
func (s *ProjectEnvironment) SetImage(v string) *ProjectEnvironment {
	s.Image = &v
	return s
}

// SetImagePullCredentialsType sets the ImagePullCredentialsType field's value.
func (s *ProjectEnvironment) SetImagePullCredentialsType(v string) *ProjectEnvironment {
	s.ImagePullCredentialsType = &v
	return s
}

// SetPrivilegedMode sets the PrivilegedMode field's value.
func (s *ProjectEnvironment) SetPrivilegedMode(v bool) *ProjectEnvironment {
	s.PrivilegedMode = &v
	return s
}

// SetRegistryCredential sets the RegistryCredential field's value.
func (s *ProjectEnvironment) SetRegistryCredential(v *RegistryCredential) *ProjectEnvironment {
	s.RegistryCredential = v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectEnvironment) SetType(v string) *ProjectEnvironment {
	s.Type = &v
	return s
}

// Information about the build input source code for the build project.
type ProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the authorization settings for AWS CodeBuild to access
	// the source code to be built.
	//
	// This information is for the AWS CodeBuild console's use only. Your code should
	// not get or set this information directly.
	Auth *SourceAuth `locationName:"auth" type:"structure"`

	// The build spec declaration to use for the builds in this build project.
	//
	// If this value is not specified, a build spec must be included along with
	// the source code to be built.
	Buildspec *string `locationName:"buildspec" type:"string"`

	// Information about the git clone depth for the build project.
	GitCloneDepth *int64 `locationName:"gitCloneDepth" type:"integer"`

	// Enable this flag to ignore SSL warnings while connecting to the project source
	// code.
	InsecureSsl *bool `locationName:"insecureSsl" type:"boolean"`

	// Information about the location of the source code to be built. Valid values
	// include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the build spec (for
	//    example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name).
	//
	//    * For source code in an Amazon Simple Storage Service (Amazon S3) input
	//    bucket, one of the following.
	//
	//  The path to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//
	//
	//  The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec. You must connect your AWS
	//    account to your GitHub account. Use the AWS CodeBuild console to start
	//    creating a build project. When you use the console to connect (or reconnect)
	//    with GitHub, on the GitHub Authorize application page, for Organization
	//    access, choose Request access next to each repository you want to allow
	//    AWS CodeBuild to have access to, and then choose Authorize application.
	//    (After you have connected to your GitHub account, you do not need to finish
	//    creating the build project. You can leave the AWS CodeBuild console.)
	//    To instruct AWS CodeBuild to use this connection, in the source object,
	//    set the auth object's type value to OAUTH.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec. You must connect
	//    your AWS account to your Bitbucket account. Use the AWS CodeBuild console
	//    to start creating a build project. When you use the console to connect
	//    (or reconnect) with Bitbucket, on the Bitbucket Confirm access to your
	//    account page, choose Grant access. (After you have connected to your Bitbucket
	//    account, you do not need to finish creating the build project. You can
	//    leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this
	//    connection, in the source object, set the auth object's type value to
	//    OAUTH.
	Location *string `locationName:"location" type:"string"`

	// Set to true to report the status of a build's start and finish to your source
	// provider. This option is valid only when your source provider is GitHub,
	// GitHub Enterprise, or Bitbucket. If this is set and you use a different source
	// provider, an invalidInputException is thrown.
	ReportBuildStatus *bool `locationName:"reportBuildStatus" type:"boolean"`

	// An identifier for this project source.
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// include:
	//
	//    * BITBUCKET: The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT: The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE: The source code settings are specified in the source action
	//    of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB: The source code is in a GitHub repository.
	//
	//    * NO_SOURCE: The project does not have input source code.
	//
	//    * S3: The source code is in an Amazon Simple Storage Service (Amazon S3)
	//    input bucket.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SourceType"`
}

// String returns the string representation
func (s ProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectSource"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Auth != nil {
		if err := s.Auth.Validate(); err != nil {
			invalidParams.AddNested("Auth", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuth sets the Auth field's value.
func (s *ProjectSource) SetAuth(v *SourceAuth) *ProjectSource {
	s.Auth = v
	return s
}

// SetBuildspec sets the Buildspec field's value.
func (s *ProjectSource) SetBuildspec(v string) *ProjectSource {
	s.Buildspec = &v
	return s
}

// SetGitCloneDepth sets the GitCloneDepth field's value.
func (s *ProjectSource) SetGitCloneDepth(v int64) *ProjectSource {
	s.GitCloneDepth = &v
	return s
}

// SetInsecureSsl sets the InsecureSsl field's value.
func (s *ProjectSource) SetInsecureSsl(v bool) *ProjectSource {
	s.InsecureSsl = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ProjectSource) SetLocation(v string) *ProjectSource {
	s.Location = &v
	return s
}

// SetReportBuildStatus sets the ReportBuildStatus field's value.
func (s *ProjectSource) SetReportBuildStatus(v bool) *ProjectSource {
	s.ReportBuildStatus = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *ProjectSource) SetSourceIdentifier(v string) *ProjectSource {
	s.SourceIdentifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectSource) SetType(v string) *ProjectSource {
	s.Type = &v
	return s
}

// A source identifier and its corresponding version.
type ProjectSourceVersion struct {
	_ struct{} `type:"structure"`

	// An identifier for a source in the build project.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string" required:"true"`

	// The source version for the corresponding source identifier. If specified,
	// must be one of:
	//
	//    * For AWS CodeCommit: the commit ID to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	//
	// SourceVersion is a required field
	SourceVersion *string `locationName:"sourceVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectSourceVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSourceVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSourceVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectSourceVersion"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SourceVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *ProjectSourceVersion) SetSourceIdentifier(v string) *ProjectSourceVersion {
	s.SourceIdentifier = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *ProjectSourceVersion) SetSourceVersion(v string) *ProjectSourceVersion {
	s.SourceVersion = &v
	return s
}

// Information about credentials that provide access to a private Docker registry.
// When this is set:
//
//    * imagePullCredentialsType must be set to SERVICE_ROLE.
//
//    *  images cannot be curated or an Amazon ECR image.
//
// For more information, see Private Registry with AWS Secrets Manager Samle
// for AWS CodeBuild (http://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html).
type RegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current region.
	//
	// Credential is a required field
	Credential *string `locationName:"credential" min:"1" type:"string" required:"true"`

	// The service that created the credentials to access a private Docker registry.
	// The valid value, SECRETS_MANAGER, is for AWS Secrets Manager.
	//
	// CredentialProvider is a required field
	CredentialProvider *string `locationName:"credentialProvider" type:"string" required:"true" enum:"CredentialProviderType"`
}

// String returns the string representation
func (s RegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegistryCredential) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegistryCredential) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegistryCredential"}
	if s.Credential == nil {
		invalidParams.Add(request.NewErrParamRequired("Credential"))
	}
	if s.Credential != nil && len(*s.Credential) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Credential", 1))
	}
	if s.CredentialProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredential sets the Credential field's value.
func (s *RegistryCredential) SetCredential(v string) *RegistryCredential {
	s.Credential = &v
	return s
}

// SetCredentialProvider sets the CredentialProvider field's value.
func (s *RegistryCredential) SetCredentialProvider(v string) *RegistryCredential {
	s.CredentialProvider = &v
	return s
}

// Information about S3 logs for a build project.
type S3LogsConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3
	// bucket name is my-bucket, and your path prefix is build-log, then acceptable
	// formats are my-bucket/build-log or arn:aws:s3:::my-bucket/build-log.
	Location *string `locationName:"location" type:"string"`

	// The current status of the S3 build logs. Valid values are:
	//
	//    * ENABLED: S3 build logs are enabled for this build project.
	//
	//    * DISABLED: S3 build logs are not enabled for this build project.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"LogsConfigStatusType"`
}

// String returns the string representation
func (s S3LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3LogsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3LogsConfig"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *S3LogsConfig) SetLocation(v string) *S3LogsConfig {
	s.Location = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *S3LogsConfig) SetStatus(v string) *S3LogsConfig {
	s.Status = &v
	return s
}

// Information about the authorization settings for AWS CodeBuild to access
// the source code to be built.
//
// This information is for the AWS CodeBuild console's use only. Your code should
// not get or set this information directly.
type SourceAuth struct {
	_ struct{} `type:"structure"`

	// The resource value that applies to the specified authorization type.
	Resource *string `locationName:"resource" type:"string"`

	// This data type is deprecated and is no longer accurate or used.
	//
	// The authorization type to use. The only valid value is OAUTH, which represents
	// the OAuth authorization type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SourceAuthType"`
}

// String returns the string representation
func (s SourceAuth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceAuth) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAuth) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceAuth"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *SourceAuth) SetResource(v string) *SourceAuth {
	s.Resource = &v
	return s
}

// SetType sets the Type field's value.
func (s *SourceAuth) SetType(v string) *SourceAuth {
	s.Type = &v
	return s
}

// Information about the credentials for a GitHub, GitHub Enterprise, or Bitbucket
// repository.
type SourceCredentialsInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The type of authentication used by the credentials. Valid options are OAUTH,
	// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN.
	AuthType *string `locationName:"authType" type:"string" enum:"AuthType"`

	// The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE,
	// or BITBUCKET.
	ServerType *string `locationName:"serverType" type:"string" enum:"ServerType"`
}

// String returns the string representation
func (s SourceCredentialsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceCredentialsInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SourceCredentialsInfo) SetArn(v string) *SourceCredentialsInfo {
	s.Arn = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *SourceCredentialsInfo) SetAuthType(v string) *SourceCredentialsInfo {
	s.AuthType = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *SourceCredentialsInfo) SetServerType(v string) *SourceCredentialsInfo {
	s.ServerType = &v
	return s
}

type StartBuildInput struct {
	_ struct{} `type:"structure"`

	// Build output artifact settings that override, for this build only, the latest
	// ones already defined in the build project.
	ArtifactsOverride *ProjectArtifacts `locationName:"artifactsOverride" type:"structure"`

	// A build spec declaration that overrides, for this build only, the latest
	// one already defined in the build project.
	BuildspecOverride *string `locationName:"buildspecOverride" type:"string"`

	// A ProjectCache object specified for this build that overrides the one defined
	// in the build project.
	CacheOverride *ProjectCache `locationName:"cacheOverride" type:"structure"`

	// The name of a certificate for this build that overrides the one specified
	// in the build project.
	CertificateOverride *string `locationName:"certificateOverride" type:"string"`

	// The name of a compute type for this build that overrides the one specified
	// in the build project.
	ComputeTypeOverride *string `locationName:"computeTypeOverride" type:"string" enum:"ComputeType"`

	// A container type for this build that overrides the one specified in the build
	// project.
	EnvironmentTypeOverride *string `locationName:"environmentTypeOverride" type:"string" enum:"EnvironmentType"`

	// A set of environment variables that overrides, for this build only, the latest
	// ones already defined in the build project.
	EnvironmentVariablesOverride []*EnvironmentVariable `locationName:"environmentVariablesOverride" type:"list"`

	// The user-defined depth of history, with a minimum value of 0, that overrides,
	// for this build only, any previous depth of history defined in the build project.
	GitCloneDepthOverride *int64 `locationName:"gitCloneDepthOverride" type:"integer"`

	// A unique, case sensitive identifier you provide to ensure the idempotency
	// of the StartBuild request. The token is included in the StartBuild request
	// and is valid for 12 hours. If you repeat the StartBuild request with the
	// same token, but change a parameter, AWS CodeBuild returns a parameter mismatch
	// error.
	IdempotencyToken *string `locationName:"idempotencyToken" type:"string"`

	// The name of an image for this build that overrides the one specified in the
	// build project.
	ImageOverride *string `locationName:"imageOverride" min:"1" type:"string"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	// There are two valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust AWS CodeBuild's
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When using a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When using an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsTypeOverride *string `locationName:"imagePullCredentialsTypeOverride" type:"string" enum:"ImagePullCredentialsType"`

	// Enable this flag to override the insecure SSL setting that is specified in
	// the build project. The insecure SSL setting determines whether to ignore
	// SSL warnings while connecting to the project source code. This override applies
	// only if the build's source is GitHub Enterprise.
	InsecureSslOverride *bool `locationName:"insecureSslOverride" type:"boolean"`

	// Log settings for this build that override the log settings defined in the
	// build project.
	LogsConfigOverride *LogsConfig `locationName:"logsConfigOverride" type:"structure"`

	// Enable this flag to override privileged mode in the build project.
	PrivilegedModeOverride *bool `locationName:"privilegedModeOverride" type:"boolean"`

	// The name of the AWS CodeBuild build project to start running a build.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutesOverride *int64 `locationName:"queuedTimeoutInMinutesOverride" min:"5" type:"integer"`

	// The credentials for access to a private registry.
	RegistryCredentialOverride *RegistryCredential `locationName:"registryCredentialOverride" type:"structure"`

	// Set to true to report to your source provider the status of a build's start
	// and completion. If you use this option with a source provider other than
	// GitHub, GitHub Enterprise, or Bitbucket, an invalidInputException is thrown.
	ReportBuildStatusOverride *bool `locationName:"reportBuildStatusOverride" type:"boolean"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifactsOverride []*ProjectArtifacts `locationName:"secondaryArtifactsOverride" type:"list"`

	// An array of ProjectSource objects.
	SecondarySourcesOverride []*ProjectSource `locationName:"secondarySourcesOverride" type:"list"`

	// An array of ProjectSourceVersion objects that specify one or more versions
	// of the project's secondary sources to be used for this build only.
	SecondarySourcesVersionOverride []*ProjectSourceVersion `locationName:"secondarySourcesVersionOverride" type:"list"`

	// The name of a service role for this build that overrides the one specified
	// in the build project.
	ServiceRoleOverride *string `locationName:"serviceRoleOverride" min:"1" type:"string"`

	// An authorization type for this build that overrides the one defined in the
	// build project. This override applies only if the build project's source is
	// BitBucket or GitHub.
	SourceAuthOverride *SourceAuth `locationName:"sourceAuthOverride" type:"structure"`

	// A location that overrides, for this build, the source location for the one
	// defined in the build project.
	SourceLocationOverride *string `locationName:"sourceLocationOverride" type:"string"`

	// A source input type, for this build, that overrides the source input defined
	// in the build project.
	SourceTypeOverride *string `locationName:"sourceTypeOverride" type:"string" enum:"SourceType"`

	// A version of the build input to be built, for this build only. If not specified,
	// the latest version is used. If specified, must be one of:
	//
	//    * For AWS CodeCommit: the commit ID to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	SourceVersion *string `locationName:"sourceVersion" type:"string"`

	// The number of build timeout minutes, from 5 to 480 (8 hours), that overrides,
	// for this build only, the latest setting already defined in the build project.
	TimeoutInMinutesOverride *int64 `locationName:"timeoutInMinutesOverride" min:"5" type:"integer"`
}

// String returns the string representation
func (s StartBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartBuildInput"}
	if s.ImageOverride != nil && len(*s.ImageOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageOverride", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.QueuedTimeoutInMinutesOverride != nil && *s.QueuedTimeoutInMinutesOverride < 5 {
		invalidParams.Add(request.NewErrParamMinValue("QueuedTimeoutInMinutesOverride", 5))
	}
	if s.ServiceRoleOverride != nil && len(*s.ServiceRoleOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRoleOverride", 1))
	}
	if s.TimeoutInMinutesOverride != nil && *s.TimeoutInMinutesOverride < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutesOverride", 5))
	}
	if s.ArtifactsOverride != nil {
		if err := s.ArtifactsOverride.Validate(); err != nil {
			invalidParams.AddNested("ArtifactsOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.CacheOverride != nil {
		if err := s.CacheOverride.Validate(); err != nil {
			invalidParams.AddNested("CacheOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.EnvironmentVariablesOverride != nil {
		for i, v := range s.EnvironmentVariablesOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariablesOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogsConfigOverride != nil {
		if err := s.LogsConfigOverride.Validate(); err != nil {
			invalidParams.AddNested("LogsConfigOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.RegistryCredentialOverride != nil {
		if err := s.RegistryCredentialOverride.Validate(); err != nil {
			invalidParams.AddNested("RegistryCredentialOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.SecondaryArtifactsOverride != nil {
		for i, v := range s.SecondaryArtifactsOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondaryArtifactsOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecondarySourcesOverride != nil {
		for i, v := range s.SecondarySourcesOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondarySourcesOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecondarySourcesVersionOverride != nil {
		for i, v := range s.SecondarySourcesVersionOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondarySourcesVersionOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceAuthOverride != nil {
		if err := s.SourceAuthOverride.Validate(); err != nil {
			invalidParams.AddNested("SourceAuthOverride", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactsOverride sets the ArtifactsOverride field's value.
func (s *StartBuildInput) SetArtifactsOverride(v *ProjectArtifacts) *StartBuildInput {
	s.ArtifactsOverride = v
	return s
}

// SetBuildspecOverride sets the BuildspecOverride field's value.
func (s *StartBuildInput) SetBuildspecOverride(v string) *StartBuildInput {
	s.BuildspecOverride = &v
	return s
}

// SetCacheOverride sets the CacheOverride field's value.
func (s *StartBuildInput) SetCacheOverride(v *ProjectCache) *StartBuildInput {
	s.CacheOverride = v
	return s
}

// SetCertificateOverride sets the CertificateOverride field's value.
func (s *StartBuildInput) SetCertificateOverride(v string) *StartBuildInput {
	s.CertificateOverride = &v
	return s
}

// SetComputeTypeOverride sets the ComputeTypeOverride field's value.
func (s *StartBuildInput) SetComputeTypeOverride(v string) *StartBuildInput {
	s.ComputeTypeOverride = &v
	return s
}

// SetEnvironmentTypeOverride sets the EnvironmentTypeOverride field's value.
func (s *StartBuildInput) SetEnvironmentTypeOverride(v string) *StartBuildInput {
	s.EnvironmentTypeOverride = &v
	return s
}

// SetEnvironmentVariablesOverride sets the EnvironmentVariablesOverride field's value.
func (s *StartBuildInput) SetEnvironmentVariablesOverride(v []*EnvironmentVariable) *StartBuildInput {
	s.EnvironmentVariablesOverride = v
	return s
}

// SetGitCloneDepthOverride sets the GitCloneDepthOverride field's value.
func (s *StartBuildInput) SetGitCloneDepthOverride(v int64) *StartBuildInput {
	s.GitCloneDepthOverride = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartBuildInput) SetIdempotencyToken(v string) *StartBuildInput {
	s.IdempotencyToken = &v
	return s
}

// SetImageOverride sets the ImageOverride field's value.
func (s *StartBuildInput) SetImageOverride(v string) *StartBuildInput {
	s.ImageOverride = &v
	return s
}

// SetImagePullCredentialsTypeOverride sets the ImagePullCredentialsTypeOverride field's value.
func (s *StartBuildInput) SetImagePullCredentialsTypeOverride(v string) *StartBuildInput {
	s.ImagePullCredentialsTypeOverride = &v
	return s
}

// SetInsecureSslOverride sets the InsecureSslOverride field's value.
func (s *StartBuildInput) SetInsecureSslOverride(v bool) *StartBuildInput {
	s.InsecureSslOverride = &v
	return s
}

// SetLogsConfigOverride sets the LogsConfigOverride field's value.
func (s *StartBuildInput) SetLogsConfigOverride(v *LogsConfig) *StartBuildInput {
	s.LogsConfigOverride = v
	return s
}

// SetPrivilegedModeOverride sets the PrivilegedModeOverride field's value.
func (s *StartBuildInput) SetPrivilegedModeOverride(v bool) *StartBuildInput {
	s.PrivilegedModeOverride = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *StartBuildInput) SetProjectName(v string) *StartBuildInput {
	s.ProjectName = &v
	return s
}

// SetQueuedTimeoutInMinutesOverride sets the QueuedTimeoutInMinutesOverride field's value.
func (s *StartBuildInput) SetQueuedTimeoutInMinutesOverride(v int64) *StartBuildInput {
	s.QueuedTimeoutInMinutesOverride = &v
	return s
}

// SetRegistryCredentialOverride sets the RegistryCredentialOverride field's value.
func (s *StartBuildInput) SetRegistryCredentialOverride(v *RegistryCredential) *StartBuildInput {
	s.RegistryCredentialOverride = v
	return s
}

// SetReportBuildStatusOverride sets the ReportBuildStatusOverride field's value.
func (s *StartBuildInput) SetReportBuildStatusOverride(v bool) *StartBuildInput {
	s.ReportBuildStatusOverride = &v
	return s
}

// SetSecondaryArtifactsOverride sets the SecondaryArtifactsOverride field's value.
func (s *StartBuildInput) SetSecondaryArtifactsOverride(v []*ProjectArtifacts) *StartBuildInput {
	s.SecondaryArtifactsOverride = v
	return s
}

// SetSecondarySourcesOverride sets the SecondarySourcesOverride field's value.
func (s *StartBuildInput) SetSecondarySourcesOverride(v []*ProjectSource) *StartBuildInput {
	s.SecondarySourcesOverride = v
	return s
}

// SetSecondarySourcesVersionOverride sets the SecondarySourcesVersionOverride field's value.
func (s *StartBuildInput) SetSecondarySourcesVersionOverride(v []*ProjectSourceVersion) *StartBuildInput {
	s.SecondarySourcesVersionOverride = v
	return s
}

// SetServiceRoleOverride sets the ServiceRoleOverride field's value.
func (s *StartBuildInput) SetServiceRoleOverride(v string) *StartBuildInput {
	s.ServiceRoleOverride = &v
	return s
}

// SetSourceAuthOverride sets the SourceAuthOverride field's value.
func (s *StartBuildInput) SetSourceAuthOverride(v *SourceAuth) *StartBuildInput {
	s.SourceAuthOverride = v
	return s
}

// SetSourceLocationOverride sets the SourceLocationOverride field's value.
func (s *StartBuildInput) SetSourceLocationOverride(v string) *StartBuildInput {
	s.SourceLocationOverride = &v
	return s
}

// SetSourceTypeOverride sets the SourceTypeOverride field's value.
func (s *StartBuildInput) SetSourceTypeOverride(v string) *StartBuildInput {
	s.SourceTypeOverride = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *StartBuildInput) SetSourceVersion(v string) *StartBuildInput {
	s.SourceVersion = &v
	return s
}

// SetTimeoutInMinutesOverride sets the TimeoutInMinutesOverride field's value.
func (s *StartBuildInput) SetTimeoutInMinutesOverride(v int64) *StartBuildInput {
	s.TimeoutInMinutesOverride = &v
	return s
}

type StartBuildOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build to be run.
	Build *Build `locationName:"build" type:"structure"`
}

// String returns the string representation
func (s StartBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *StartBuildOutput) SetBuild(v *Build) *StartBuildOutput {
	s.Build = v
	return s
}

type StopBuildInput struct {
	_ struct{} `type:"structure"`

	// The ID of the build.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopBuildInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopBuildInput) SetId(v string) *StopBuildInput {
	s.Id = &v
	return s
}

type StopBuildOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build.
	Build *Build `locationName:"build" type:"structure"`
}

// String returns the string representation
func (s StopBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *StopBuildOutput) SetBuild(v *Build) *StopBuildOutput {
	s.Build = v
	return s
}

// A tag, consisting of a key and a value.
//
// This tag is available for use by AWS services that support tags in AWS CodeBuild.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The tag's value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// Information to be changed about the build output artifacts for the build
	// project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// Set this to true to generate a publicly accessible URL for your project's
	// build badge.
	BadgeEnabled *bool `locationName:"badgeEnabled" type:"boolean"`

	// Stores recently used information so that it can be quickly accessed at a
	// later time.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// A new or replacement description of the build project.
	Description *string `locationName:"description" type:"string"`

	// The replacement AWS Key Management Service (AWS KMS) customer master key
	// (CMK) to be used for encrypting the build output artifacts.
	//
	// You can specify either the Amazon Resource Name (ARN)of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information to be changed about the build environment for the build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// Information about logs for the build project. A project can create logs in
	// Amazon CloudWatch Logs, logs in an S3 bucket, or both.
	LogsConfig *LogsConfig `locationName:"logsConfig" type:"structure"`

	// The name of the build project.
	//
	// You cannot change a build project's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" min:"5" type:"integer"`

	// An array of ProjectSource objects.
	SecondaryArtifacts []*ProjectArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []*ProjectSource `locationName:"secondarySources" type:"list"`

	// The replacement ARN of the AWS Identity and Access Management (IAM) role
	// that enables AWS CodeBuild to interact with dependent AWS services on behalf
	// of the AWS account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information to be changed about the build input source code for the build
	// project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// The replacement set of tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild
	// to wait before timing out any related build that did not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`

	// VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueuedTimeoutInMinutes != nil && *s.QueuedTimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("QueuedTimeoutInMinutes", 5))
	}
	if s.ServiceRole != nil && len(*s.ServiceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRole", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 5))
	}
	if s.Artifacts != nil {
		if err := s.Artifacts.Validate(); err != nil {
			invalidParams.AddNested("Artifacts", err.(request.ErrInvalidParams))
		}
	}
	if s.Cache != nil {
		if err := s.Cache.Validate(); err != nil {
			invalidParams.AddNested("Cache", err.(request.ErrInvalidParams))
		}
	}
	if s.Environment != nil {
		if err := s.Environment.Validate(); err != nil {
			invalidParams.AddNested("Environment", err.(request.ErrInvalidParams))
		}
	}
	if s.LogsConfig != nil {
		if err := s.LogsConfig.Validate(); err != nil {
			invalidParams.AddNested("LogsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SecondaryArtifacts != nil {
		for i, v := range s.SecondaryArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondaryArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecondarySources != nil {
		for i, v := range s.SecondarySources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecondarySources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifacts sets the Artifacts field's value.
func (s *UpdateProjectInput) SetArtifacts(v *ProjectArtifacts) *UpdateProjectInput {
	s.Artifacts = v
	return s
}

// SetBadgeEnabled sets the BadgeEnabled field's value.
func (s *UpdateProjectInput) SetBadgeEnabled(v bool) *UpdateProjectInput {
	s.BadgeEnabled = &v
	return s
}

// SetCache sets the Cache field's value.
func (s *UpdateProjectInput) SetCache(v *ProjectCache) *UpdateProjectInput {
	s.Cache = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *UpdateProjectInput) SetEncryptionKey(v string) *UpdateProjectInput {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateProjectInput) SetEnvironment(v *ProjectEnvironment) *UpdateProjectInput {
	s.Environment = v
	return s
}

// SetLogsConfig sets the LogsConfig field's value.
func (s *UpdateProjectInput) SetLogsConfig(v *LogsConfig) *UpdateProjectInput {
	s.LogsConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// SetQueuedTimeoutInMinutes sets the QueuedTimeoutInMinutes field's value.
func (s *UpdateProjectInput) SetQueuedTimeoutInMinutes(v int64) *UpdateProjectInput {
	s.QueuedTimeoutInMinutes = &v
	return s
}

// SetSecondaryArtifacts sets the SecondaryArtifacts field's value.
func (s *UpdateProjectInput) SetSecondaryArtifacts(v []*ProjectArtifacts) *UpdateProjectInput {
	s.SecondaryArtifacts = v
	return s
}

// SetSecondarySources sets the SecondarySources field's value.
func (s *UpdateProjectInput) SetSecondarySources(v []*ProjectSource) *UpdateProjectInput {
	s.SecondarySources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *UpdateProjectInput) SetServiceRole(v string) *UpdateProjectInput {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateProjectInput) SetSource(v *ProjectSource) *UpdateProjectInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateProjectInput) SetTags(v []*Tag) *UpdateProjectInput {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *UpdateProjectInput) SetTimeoutInMinutes(v int64) *UpdateProjectInput {
	s.TimeoutInMinutes = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateProjectInput) SetVpcConfig(v *VpcConfig) *UpdateProjectInput {
	s.VpcConfig = v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build project that was changed.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectOutput) SetProject(v *Project) *UpdateProjectOutput {
	s.Project = v
	return s
}

type UpdateWebhookInput struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"2" type:"string" required:"true"`

	// A boolean value that specifies whether the associated GitHub repository's
	// secret token should be updated. If you use Bitbucket for your repository,
	// rotateSecret is ignored.
	RotateSecret *bool `locationName:"rotateSecret" type:"boolean"`
}

// String returns the string representation
func (s UpdateWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWebhookInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchFilter sets the BranchFilter field's value.
func (s *UpdateWebhookInput) SetBranchFilter(v string) *UpdateWebhookInput {
	s.BranchFilter = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateWebhookInput) SetProjectName(v string) *UpdateWebhookInput {
	s.ProjectName = &v
	return s
}

// SetRotateSecret sets the RotateSecret field's value.
func (s *UpdateWebhookInput) SetRotateSecret(v bool) *UpdateWebhookInput {
	s.RotateSecret = &v
	return s
}

type UpdateWebhookOutput struct {
	_ struct{} `type:"structure"`

	// Information about a repository's webhook that is associated with a project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s UpdateWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebhookOutput) GoString() string {
	return s.String()
}

// SetWebhook sets the Webhook field's value.
func (s *UpdateWebhookOutput) SetWebhook(v *Webhook) *UpdateWebhookOutput {
	s.Webhook = v
	return s
}

// Information about the VPC configuration that AWS CodeBuild accesses.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your Amazon VPC.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The ID of the Amazon VPC.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *VpcConfig) SetSubnets(v []*string) *VpcConfig {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfig) SetVpcId(v string) *VpcConfig {
	s.VpcId = &v
	return s
}

// Information about a webhook that connects repository events to a build project
// in AWS CodeBuild.
type Webhook struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// A timestamp that indicates the last time a repository's secret token was
	// modified.
	LastModifiedSecret *time.Time `locationName:"lastModifiedSecret" type:"timestamp"`

	// The AWS CodeBuild endpoint where webhook events are sent.
	PayloadUrl *string `locationName:"payloadUrl" min:"1" type:"string"`

	// The secret token of the associated repository.
	//
	// A Bitbucket webhook does not support secret.
	Secret *string `locationName:"secret" min:"1" type:"string"`

	// The URL to the webhook.
	Url *string `locationName:"url" min:"1" type:"string"`
}

// String returns the string representation
func (s Webhook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Webhook) GoString() string {
	return s.String()
}

// SetBranchFilter sets the BranchFilter field's value.
func (s *Webhook) SetBranchFilter(v string) *Webhook {
	s.BranchFilter = &v
	return s
}

// SetLastModifiedSecret sets the LastModifiedSecret field's value.
func (s *Webhook) SetLastModifiedSecret(v time.Time) *Webhook {
	s.LastModifiedSecret = &v
	return s
}

// SetPayloadUrl sets the PayloadUrl field's value.
func (s *Webhook) SetPayloadUrl(v string) *Webhook {
	s.PayloadUrl = &v
	return s
}

// SetSecret sets the Secret field's value.
func (s *Webhook) SetSecret(v string) *Webhook {
	s.Secret = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Webhook) SetUrl(v string) *Webhook {
	s.Url = &v
	return s
}

const (
	// ArtifactNamespaceNone is a ArtifactNamespace enum value
	ArtifactNamespaceNone = "NONE"

	// ArtifactNamespaceBuildId is a ArtifactNamespace enum value
	ArtifactNamespaceBuildId = "BUILD_ID"
)

const (
	// ArtifactPackagingNone is a ArtifactPackaging enum value
	ArtifactPackagingNone = "NONE"

	// ArtifactPackagingZip is a ArtifactPackaging enum value
	ArtifactPackagingZip = "ZIP"
)

const (
	// ArtifactsTypeCodepipeline is a ArtifactsType enum value
	ArtifactsTypeCodepipeline = "CODEPIPELINE"

	// ArtifactsTypeS3 is a ArtifactsType enum value
	ArtifactsTypeS3 = "S3"

	// ArtifactsTypeNoArtifacts is a ArtifactsType enum value
	ArtifactsTypeNoArtifacts = "NO_ARTIFACTS"
)

const (
	// AuthTypeOauth is a AuthType enum value
	AuthTypeOauth = "OAUTH"

	// AuthTypeBasicAuth is a AuthType enum value
	AuthTypeBasicAuth = "BASIC_AUTH"

	// AuthTypePersonalAccessToken is a AuthType enum value
	AuthTypePersonalAccessToken = "PERSONAL_ACCESS_TOKEN"
)

const (
	// BuildPhaseTypeSubmitted is a BuildPhaseType enum value
	BuildPhaseTypeSubmitted = "SUBMITTED"

	// BuildPhaseTypeQueued is a BuildPhaseType enum value
	BuildPhaseTypeQueued = "QUEUED"

	// BuildPhaseTypeProvisioning is a BuildPhaseType enum value
	BuildPhaseTypeProvisioning = "PROVISIONING"

	// BuildPhaseTypeDownloadSource is a BuildPhaseType enum value
	BuildPhaseTypeDownloadSource = "DOWNLOAD_SOURCE"

	// BuildPhaseTypeInstall is a BuildPhaseType enum value
	BuildPhaseTypeInstall = "INSTALL"

	// BuildPhaseTypePreBuild is a BuildPhaseType enum value
	BuildPhaseTypePreBuild = "PRE_BUILD"

	// BuildPhaseTypeBuild is a BuildPhaseType enum value
	BuildPhaseTypeBuild = "BUILD"

	// BuildPhaseTypePostBuild is a BuildPhaseType enum value
	BuildPhaseTypePostBuild = "POST_BUILD"

	// BuildPhaseTypeUploadArtifacts is a BuildPhaseType enum value
	BuildPhaseTypeUploadArtifacts = "UPLOAD_ARTIFACTS"

	// BuildPhaseTypeFinalizing is a BuildPhaseType enum value
	BuildPhaseTypeFinalizing = "FINALIZING"

	// BuildPhaseTypeCompleted is a BuildPhaseType enum value
	BuildPhaseTypeCompleted = "COMPLETED"
)

const (
	// CacheTypeNoCache is a CacheType enum value
	CacheTypeNoCache = "NO_CACHE"

	// CacheTypeS3 is a CacheType enum value
	CacheTypeS3 = "S3"
)

const (
	// ComputeTypeBuildGeneral1Small is a ComputeType enum value
	ComputeTypeBuildGeneral1Small = "BUILD_GENERAL1_SMALL"

	// ComputeTypeBuildGeneral1Medium is a ComputeType enum value
	ComputeTypeBuildGeneral1Medium = "BUILD_GENERAL1_MEDIUM"

	// ComputeTypeBuildGeneral1Large is a ComputeType enum value
	ComputeTypeBuildGeneral1Large = "BUILD_GENERAL1_LARGE"
)

const (
	// CredentialProviderTypeSecretsManager is a CredentialProviderType enum value
	CredentialProviderTypeSecretsManager = "SECRETS_MANAGER"
)

const (
	// EnvironmentTypeWindowsContainer is a EnvironmentType enum value
	EnvironmentTypeWindowsContainer = "WINDOWS_CONTAINER"

	// EnvironmentTypeLinuxContainer is a EnvironmentType enum value
	EnvironmentTypeLinuxContainer = "LINUX_CONTAINER"
)

const (
	// EnvironmentVariableTypePlaintext is a EnvironmentVariableType enum value
	EnvironmentVariableTypePlaintext = "PLAINTEXT"

	// EnvironmentVariableTypeParameterStore is a EnvironmentVariableType enum value
	EnvironmentVariableTypeParameterStore = "PARAMETER_STORE"
)

const (
	// ImagePullCredentialsTypeCodebuild is a ImagePullCredentialsType enum value
	ImagePullCredentialsTypeCodebuild = "CODEBUILD"

	// ImagePullCredentialsTypeServiceRole is a ImagePullCredentialsType enum value
	ImagePullCredentialsTypeServiceRole = "SERVICE_ROLE"
)

const (
	// LanguageTypeJava is a LanguageType enum value
	LanguageTypeJava = "JAVA"

	// LanguageTypePython is a LanguageType enum value
	LanguageTypePython = "PYTHON"

	// LanguageTypeNodeJs is a LanguageType enum value
	LanguageTypeNodeJs = "NODE_JS"

	// LanguageTypeRuby is a LanguageType enum value
	LanguageTypeRuby = "RUBY"

	// LanguageTypeGolang is a LanguageType enum value
	LanguageTypeGolang = "GOLANG"

	// LanguageTypeDocker is a LanguageType enum value
	LanguageTypeDocker = "DOCKER"

	// LanguageTypeAndroid is a LanguageType enum value
	LanguageTypeAndroid = "ANDROID"

	// LanguageTypeDotnet is a LanguageType enum value
	LanguageTypeDotnet = "DOTNET"

	// LanguageTypeBase is a LanguageType enum value
	LanguageTypeBase = "BASE"

	// LanguageTypePhp is a LanguageType enum value
	LanguageTypePhp = "PHP"
)

const (
	// LogsConfigStatusTypeEnabled is a LogsConfigStatusType enum value
	LogsConfigStatusTypeEnabled = "ENABLED"

	// LogsConfigStatusTypeDisabled is a LogsConfigStatusType enum value
	LogsConfigStatusTypeDisabled = "DISABLED"
)

const (
	// PlatformTypeDebian is a PlatformType enum value
	PlatformTypeDebian = "DEBIAN"

	// PlatformTypeAmazonLinux is a PlatformType enum value
	PlatformTypeAmazonLinux = "AMAZON_LINUX"

	// PlatformTypeUbuntu is a PlatformType enum value
	PlatformTypeUbuntu = "UBUNTU"

	// PlatformTypeWindowsServer is a PlatformType enum value
	PlatformTypeWindowsServer = "WINDOWS_SERVER"
)

const (
	// ProjectSortByTypeName is a ProjectSortByType enum value
	ProjectSortByTypeName = "NAME"

	// ProjectSortByTypeCreatedTime is a ProjectSortByType enum value
	ProjectSortByTypeCreatedTime = "CREATED_TIME"

	// ProjectSortByTypeLastModifiedTime is a ProjectSortByType enum value
	ProjectSortByTypeLastModifiedTime = "LAST_MODIFIED_TIME"
)

const (
	// ServerTypeGithub is a ServerType enum value
	ServerTypeGithub = "GITHUB"

	// ServerTypeBitbucket is a ServerType enum value
	ServerTypeBitbucket = "BITBUCKET"

	// ServerTypeGithubEnterprise is a ServerType enum value
	ServerTypeGithubEnterprise = "GITHUB_ENTERPRISE"
)

const (
	// SortOrderTypeAscending is a SortOrderType enum value
	SortOrderTypeAscending = "ASCENDING"

	// SortOrderTypeDescending is a SortOrderType enum value
	SortOrderTypeDescending = "DESCENDING"
)

const (
	// SourceAuthTypeOauth is a SourceAuthType enum value
	SourceAuthTypeOauth = "OAUTH"
)

const (
	// SourceTypeCodecommit is a SourceType enum value
	SourceTypeCodecommit = "CODECOMMIT"

	// SourceTypeCodepipeline is a SourceType enum value
	SourceTypeCodepipeline = "CODEPIPELINE"

	// SourceTypeGithub is a SourceType enum value
	SourceTypeGithub = "GITHUB"

	// SourceTypeS3 is a SourceType enum value
	SourceTypeS3 = "S3"

	// SourceTypeBitbucket is a SourceType enum value
	SourceTypeBitbucket = "BITBUCKET"

	// SourceTypeGithubEnterprise is a SourceType enum value
	SourceTypeGithubEnterprise = "GITHUB_ENTERPRISE"

	// SourceTypeNoSource is a SourceType enum value
	SourceTypeNoSource = "NO_SOURCE"
)

const (
	// StatusTypeSucceeded is a StatusType enum value
	StatusTypeSucceeded = "SUCCEEDED"

	// StatusTypeFailed is a StatusType enum value
	StatusTypeFailed = "FAILED"

	// StatusTypeFault is a StatusType enum value
	StatusTypeFault = "FAULT"

	// StatusTypeTimedOut is a StatusType enum value
	StatusTypeTimedOut = "TIMED_OUT"

	// StatusTypeInProgress is a StatusType enum value
	StatusTypeInProgress = "IN_PROGRESS"

	// StatusTypeStopped is a StatusType enum value
	StatusTypeStopped = "STOPPED"
)
