package costmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReportsClient is the client for the Reports methods of the Costmanagement service.
type ReportsClient struct {
	BaseClient
}

// NewReportsClient creates an instance of the ReportsClient client.
func NewReportsClient(subscriptionID string) ReportsClient {
	return NewReportsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewReportsClientWithBaseURI creates an instance of the ReportsClient client.
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return ReportsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate the operation to create or update a report. Update operation requires latest eTag to be set in the
// request mandatorily. You may obtain the latest eTag by performing a get operation. Create operation does not require
// eTag.
// Parameters:
// reportName - report Name.
// parameters - parameters supplied to the CreateOrUpdate Report operation.
func (client ReportsClient) CreateOrUpdate(ctx context.Context, reportName string, parameters Report) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ReportProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod.From", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ReportsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, reportName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ReportsClient) CreateOrUpdatePreparer(ctx context.Context, reportName string, parameters Report) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":     autorest.Encode("path", reportName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ReportsClient) CreateOrUpdateResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateByBillingAccount the operation to create or update a report for billingAccount. Update operation
// requires latest eTag to be set in the request mandatorily. You may obtain the latest eTag by performing a get
// operation. Create operation does not require eTag.
// Parameters:
// billingAccountID - billingAccount ID
// reportName - report Name.
// parameters - parameters supplied to the CreateOrUpdate Report operation.
func (client ReportsClient) CreateOrUpdateByBillingAccount(ctx context.Context, billingAccountID string, reportName string, parameters Report) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.CreateOrUpdateByBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ReportProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod.From", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ReportsClient", "CreateOrUpdateByBillingAccount", err.Error())
	}

	req, err := client.CreateOrUpdateByBillingAccountPreparer(ctx, billingAccountID, reportName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateByBillingAccountPreparer prepares the CreateOrUpdateByBillingAccount request.
func (client ReportsClient) CreateOrUpdateByBillingAccountPreparer(ctx context.Context, billingAccountID string, reportName string, parameters Report) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"reportName":       autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateByBillingAccountSender sends the CreateOrUpdateByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) CreateOrUpdateByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateOrUpdateByBillingAccountResponder handles the response to the CreateOrUpdateByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) CreateOrUpdateByBillingAccountResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateByDepartment the operation to create or update a report for department. Update operation requires
// latest eTag to be set in the request mandatorily. You may obtain the latest eTag by performing a get operation.
// Create operation does not require eTag.
// Parameters:
// departmentID - department ID
// reportName - report Name.
// parameters - parameters supplied to the CreateOrUpdate Report operation.
func (client ReportsClient) CreateOrUpdateByDepartment(ctx context.Context, departmentID string, reportName string, parameters Report) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.CreateOrUpdateByDepartment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ReportProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod.From", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ReportsClient", "CreateOrUpdateByDepartment", err.Error())
	}

	req, err := client.CreateOrUpdateByDepartmentPreparer(ctx, departmentID, reportName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByDepartment", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateByDepartmentPreparer prepares the CreateOrUpdateByDepartment request.
func (client ReportsClient) CreateOrUpdateByDepartmentPreparer(ctx context.Context, departmentID string, reportName string, parameters Report) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
		"reportName":   autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateByDepartmentSender sends the CreateOrUpdateByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) CreateOrUpdateByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateOrUpdateByDepartmentResponder handles the response to the CreateOrUpdateByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) CreateOrUpdateByDepartmentResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateByResourceGroupName the operation to create or update a report. Update operation requires latest eTag
// to be set in the request mandatorily. You may obtain the latest eTag by performing a get operation. Create operation
// does not require eTag.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// reportName - report Name.
// parameters - parameters supplied to the CreateOrUpdate Report operation.
func (client ReportsClient) CreateOrUpdateByResourceGroupName(ctx context.Context, resourceGroupName string, reportName string, parameters Report) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.CreateOrUpdateByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ReportProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.ReportProperties.Schedule.RecurrencePeriod.From", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("costmanagement.ReportsClient", "CreateOrUpdateByResourceGroupName", err.Error())
	}

	req, err := client.CreateOrUpdateByResourceGroupNamePreparer(ctx, resourceGroupName, reportName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "CreateOrUpdateByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateByResourceGroupNamePreparer prepares the CreateOrUpdateByResourceGroupName request.
func (client ReportsClient) CreateOrUpdateByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, reportName string, parameters Report) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":        autorest.Encode("path", reportName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateByResourceGroupNameSender sends the CreateOrUpdateByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) CreateOrUpdateByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateOrUpdateByResourceGroupNameResponder handles the response to the CreateOrUpdateByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) CreateOrUpdateByResourceGroupNameResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete the operation to delete a report.
// Parameters:
// reportName - report Name.
func (client ReportsClient) Delete(ctx context.Context, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ReportsClient) DeletePreparer(ctx context.Context, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":     autorest.Encode("path", reportName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ReportsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByBillingAccount the operation to delete a report for billing account.
// Parameters:
// billingAccountID - billingAccount ID
// reportName - report Name.
func (client ReportsClient) DeleteByBillingAccount(ctx context.Context, billingAccountID string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.DeleteByBillingAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByBillingAccountPreparer(ctx, billingAccountID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByBillingAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// DeleteByBillingAccountPreparer prepares the DeleteByBillingAccount request.
func (client ReportsClient) DeleteByBillingAccountPreparer(ctx context.Context, billingAccountID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"reportName":       autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByBillingAccountSender sends the DeleteByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) DeleteByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByBillingAccountResponder handles the response to the DeleteByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) DeleteByBillingAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByDepartment the operation to delete a report for department.
// Parameters:
// departmentID - department ID
// reportName - report Name.
func (client ReportsClient) DeleteByDepartment(ctx context.Context, departmentID string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.DeleteByDepartment")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByDepartmentPreparer(ctx, departmentID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByDepartmentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByDepartment", resp, "Failure responding to request")
	}

	return
}

// DeleteByDepartmentPreparer prepares the DeleteByDepartment request.
func (client ReportsClient) DeleteByDepartmentPreparer(ctx context.Context, departmentID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
		"reportName":   autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByDepartmentSender sends the DeleteByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) DeleteByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByDepartmentResponder handles the response to the DeleteByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) DeleteByDepartmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByResourceGroupName the operation to delete a report.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// reportName - report Name.
func (client ReportsClient) DeleteByResourceGroupName(ctx context.Context, resourceGroupName string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.DeleteByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByResourceGroupNamePreparer(ctx, resourceGroupName, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteByResourceGroupNameSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "DeleteByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// DeleteByResourceGroupNamePreparer prepares the DeleteByResourceGroupName request.
func (client ReportsClient) DeleteByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":        autorest.Encode("path", reportName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByResourceGroupNameSender sends the DeleteByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) DeleteByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteByResourceGroupNameResponder handles the response to the DeleteByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) DeleteByResourceGroupNameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Execute the operation to execute a report.
// Parameters:
// reportName - report Name.
func (client ReportsClient) Execute(ctx context.Context, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.Execute")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExecutePreparer(ctx, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Execute", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Execute", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Execute", resp, "Failure responding to request")
	}

	return
}

// ExecutePreparer prepares the Execute request.
func (client ReportsClient) ExecutePreparer(ctx context.Context, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":     autorest.Encode("path", reportName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports/{reportName}/run", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSender sends the Execute request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ExecuteSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ExecuteResponder handles the response to the Execute request. The method always
// closes the http.Response Body.
func (client ReportsClient) ExecuteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExecuteByBillingAccount the operation to execute a report by billing account.
// Parameters:
// billingAccountID - billingAccount ID
// reportName - report Name.
func (client ReportsClient) ExecuteByBillingAccount(ctx context.Context, billingAccountID string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ExecuteByBillingAccount")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExecuteByBillingAccountPreparer(ctx, billingAccountID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteByBillingAccountSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// ExecuteByBillingAccountPreparer prepares the ExecuteByBillingAccount request.
func (client ReportsClient) ExecuteByBillingAccountPreparer(ctx context.Context, billingAccountID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"reportName":       autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports/{reportName}/run", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteByBillingAccountSender sends the ExecuteByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ExecuteByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ExecuteByBillingAccountResponder handles the response to the ExecuteByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) ExecuteByBillingAccountResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExecuteByDepartment the operation to execute a report by department.
// Parameters:
// departmentID - department ID
// reportName - report Name.
func (client ReportsClient) ExecuteByDepartment(ctx context.Context, departmentID string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ExecuteByDepartment")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExecuteByDepartmentPreparer(ctx, departmentID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteByDepartmentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByDepartment", resp, "Failure responding to request")
	}

	return
}

// ExecuteByDepartmentPreparer prepares the ExecuteByDepartment request.
func (client ReportsClient) ExecuteByDepartmentPreparer(ctx context.Context, departmentID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
		"reportName":   autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports/{reportName}/run", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteByDepartmentSender sends the ExecuteByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ExecuteByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ExecuteByDepartmentResponder handles the response to the ExecuteByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) ExecuteByDepartmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExecuteByResourceGroupName the operation to execute a report.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// reportName - report Name.
func (client ReportsClient) ExecuteByResourceGroupName(ctx context.Context, resourceGroupName string, reportName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ExecuteByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExecuteByResourceGroupNamePreparer(ctx, resourceGroupName, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteByResourceGroupNameSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ExecuteByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// ExecuteByResourceGroupNamePreparer prepares the ExecuteByResourceGroupName request.
func (client ReportsClient) ExecuteByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":        autorest.Encode("path", reportName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports/{reportName}/run", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteByResourceGroupNameSender sends the ExecuteByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ExecuteByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ExecuteByResourceGroupNameResponder handles the response to the ExecuteByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) ExecuteByResourceGroupNameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the report for a subscription by report name.
// Parameters:
// reportName - report Name.
func (client ReportsClient) Get(ctx context.Context, reportName string) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReportsClient) GetPreparer(ctx context.Context, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":     autorest.Encode("path", reportName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByBillingAccount gets the report for a billing account by report name.
// Parameters:
// billingAccountID - billingAccount ID
// reportName - report Name.
func (client ReportsClient) GetByBillingAccount(ctx context.Context, billingAccountID string, reportName string) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetByBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByBillingAccountPreparer(ctx, billingAccountID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// GetByBillingAccountPreparer prepares the GetByBillingAccount request.
func (client ReportsClient) GetByBillingAccountPreparer(ctx context.Context, billingAccountID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"reportName":       autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByBillingAccountSender sends the GetByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByBillingAccountResponder handles the response to the GetByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetByBillingAccountResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByDepartment gets the report for a department by report name.
// Parameters:
// departmentID - department ID
// reportName - report Name.
func (client ReportsClient) GetByDepartment(ctx context.Context, departmentID string, reportName string) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetByDepartment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByDepartmentPreparer(ctx, departmentID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.GetByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByDepartment", resp, "Failure responding to request")
	}

	return
}

// GetByDepartmentPreparer prepares the GetByDepartment request.
func (client ReportsClient) GetByDepartmentPreparer(ctx context.Context, departmentID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
		"reportName":   autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByDepartmentSender sends the GetByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByDepartmentResponder handles the response to the GetByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetByDepartmentResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByResourceGroupName gets the report for a resource group under a subscription by report name.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// reportName - report Name.
func (client ReportsClient) GetByResourceGroupName(ctx context.Context, resourceGroupName string, reportName string) (result Report, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByResourceGroupNamePreparer(ctx, resourceGroupName, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.GetByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// GetByResourceGroupNamePreparer prepares the GetByResourceGroupName request.
func (client ReportsClient) GetByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":        autorest.Encode("path", reportName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports/{reportName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByResourceGroupNameSender sends the GetByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetByResourceGroupNameResponder handles the response to the GetByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetByResourceGroupNameResponder(resp *http.Response) (result Report, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExecutionHistory gets the execution history of a report for a subscription by report name.
// Parameters:
// reportName - report Name.
func (client ReportsClient) GetExecutionHistory(ctx context.Context, reportName string) (result ReportExecutionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetExecutionHistory")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExecutionHistoryPreparer(ctx, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExecutionHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistory", resp, "Failure sending request")
		return
	}

	result, err = client.GetExecutionHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistory", resp, "Failure responding to request")
	}

	return
}

// GetExecutionHistoryPreparer prepares the GetExecutionHistory request.
func (client ReportsClient) GetExecutionHistoryPreparer(ctx context.Context, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":     autorest.Encode("path", reportName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports/{reportName}/runHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExecutionHistorySender sends the GetExecutionHistory request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetExecutionHistorySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExecutionHistoryResponder handles the response to the GetExecutionHistory request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetExecutionHistoryResponder(resp *http.Response) (result ReportExecutionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExecutionHistoryByBillingAccount gets the execution history of a report for a billing account by report name.
// Parameters:
// billingAccountID - billingAccount ID
// reportName - report Name.
func (client ReportsClient) GetExecutionHistoryByBillingAccount(ctx context.Context, billingAccountID string, reportName string) (result ReportExecutionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetExecutionHistoryByBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExecutionHistoryByBillingAccountPreparer(ctx, billingAccountID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExecutionHistoryByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.GetExecutionHistoryByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// GetExecutionHistoryByBillingAccountPreparer prepares the GetExecutionHistoryByBillingAccount request.
func (client ReportsClient) GetExecutionHistoryByBillingAccountPreparer(ctx context.Context, billingAccountID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"reportName":       autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports/{reportName}/runHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExecutionHistoryByBillingAccountSender sends the GetExecutionHistoryByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetExecutionHistoryByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExecutionHistoryByBillingAccountResponder handles the response to the GetExecutionHistoryByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetExecutionHistoryByBillingAccountResponder(resp *http.Response) (result ReportExecutionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExecutionHistoryByDepartment gets the execution history of a report for a department by report name.
// Parameters:
// departmentID - department ID
// reportName - report Name.
func (client ReportsClient) GetExecutionHistoryByDepartment(ctx context.Context, departmentID string, reportName string) (result ReportExecutionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetExecutionHistoryByDepartment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExecutionHistoryByDepartmentPreparer(ctx, departmentID, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExecutionHistoryByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.GetExecutionHistoryByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByDepartment", resp, "Failure responding to request")
	}

	return
}

// GetExecutionHistoryByDepartmentPreparer prepares the GetExecutionHistoryByDepartment request.
func (client ReportsClient) GetExecutionHistoryByDepartmentPreparer(ctx context.Context, departmentID string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
		"reportName":   autorest.Encode("path", reportName),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports/{reportName}/runHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExecutionHistoryByDepartmentSender sends the GetExecutionHistoryByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetExecutionHistoryByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExecutionHistoryByDepartmentResponder handles the response to the GetExecutionHistoryByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetExecutionHistoryByDepartmentResponder(resp *http.Response) (result ReportExecutionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExecutionHistoryByResourceGroupName gets the execution history of a report for a resource group by report name.
// Parameters:
// resourceGroupName - azure Resource Group Name.
// reportName - report Name.
func (client ReportsClient) GetExecutionHistoryByResourceGroupName(ctx context.Context, resourceGroupName string, reportName string) (result ReportExecutionListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.GetExecutionHistoryByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExecutionHistoryByResourceGroupNamePreparer(ctx, resourceGroupName, reportName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExecutionHistoryByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.GetExecutionHistoryByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "GetExecutionHistoryByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// GetExecutionHistoryByResourceGroupNamePreparer prepares the GetExecutionHistoryByResourceGroupName request.
func (client ReportsClient) GetExecutionHistoryByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string, reportName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"reportName":        autorest.Encode("path", reportName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports/{reportName}/runHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExecutionHistoryByResourceGroupNameSender sends the GetExecutionHistoryByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) GetExecutionHistoryByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExecutionHistoryByResourceGroupNameResponder handles the response to the GetExecutionHistoryByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) GetExecutionHistoryByResourceGroupNameResponder(resp *http.Response) (result ReportExecutionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all reports for a subscription.
func (client ReportsClient) List(ctx context.Context) (result ReportListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ReportsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.CostManagement/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ReportsClient) ListResponder(resp *http.Response) (result ReportListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByBillingAccount lists all reports for a billing account.
// Parameters:
// billingAccountID - billingAccount ID
func (client ReportsClient) ListByBillingAccount(ctx context.Context, billingAccountID string) (result ReportListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ListByBillingAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByBillingAccountPreparer(ctx, billingAccountID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByBillingAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByBillingAccount", resp, "Failure sending request")
		return
	}

	result, err = client.ListByBillingAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByBillingAccount", resp, "Failure responding to request")
	}

	return
}

// ListByBillingAccountPreparer prepares the ListByBillingAccount request.
func (client ReportsClient) ListByBillingAccountPreparer(ctx context.Context, billingAccountID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingAccountSender sends the ListByBillingAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ListByBillingAccountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByBillingAccountResponder handles the response to the ListByBillingAccount request. The method always
// closes the http.Response Body.
func (client ReportsClient) ListByBillingAccountResponder(resp *http.Response) (result ReportListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDepartment lists all reports for a department.
// Parameters:
// departmentID - department ID
func (client ReportsClient) ListByDepartment(ctx context.Context, departmentID string) (result ReportListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ListByDepartment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByDepartmentPreparer(ctx, departmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByDepartment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDepartmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByDepartment", resp, "Failure sending request")
		return
	}

	result, err = client.ListByDepartmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByDepartment", resp, "Failure responding to request")
	}

	return
}

// ListByDepartmentPreparer prepares the ListByDepartment request.
func (client ReportsClient) ListByDepartmentPreparer(ctx context.Context, departmentID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"departmentId": autorest.Encode("path", departmentID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.CostManagement/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDepartmentSender sends the ListByDepartment request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ListByDepartmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByDepartmentResponder handles the response to the ListByDepartment request. The method always
// closes the http.Response Body.
func (client ReportsClient) ListByDepartmentResponder(resp *http.Response) (result ReportListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupName lists all reports for a resource group under a subscription.
// Parameters:
// resourceGroupName - azure Resource Group Name.
func (client ReportsClient) ListByResourceGroupName(ctx context.Context, resourceGroupName string) (result ReportListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportsClient.ListByResourceGroupName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByResourceGroupNamePreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByResourceGroupName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByResourceGroupName", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "costmanagement.ReportsClient", "ListByResourceGroupName", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupNamePreparer prepares the ListByResourceGroupName request.
func (client ReportsClient) ListByResourceGroupNamePreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CostManagement/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupNameSender sends the ListByResourceGroupName request. The method will close the
// http.Response Body if it receives an error.
func (client ReportsClient) ListByResourceGroupNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByResourceGroupNameResponder handles the response to the ListByResourceGroupName request. The method always
// closes the http.Response Body.
func (client ReportsClient) ListByResourceGroupNameResponder(resp *http.Response) (result ReportListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
