package virtualmachineimagebuilder

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ProvisioningErrorCode enumerates the values for provisioning error code.
type ProvisioningErrorCode string

const (
	// BadCustomizerType ...
	BadCustomizerType ProvisioningErrorCode = "BadCustomizerType"
	// BadDistributeType ...
	BadDistributeType ProvisioningErrorCode = "BadDistributeType"
	// BadISOSource ...
	BadISOSource ProvisioningErrorCode = "BadISOSource"
	// BadManagedImageSource ...
	BadManagedImageSource ProvisioningErrorCode = "BadManagedImageSource"
	// BadPIRSource ...
	BadPIRSource ProvisioningErrorCode = "BadPIRSource"
	// BadSharedImageDistribute ...
	BadSharedImageDistribute ProvisioningErrorCode = "BadSharedImageDistribute"
	// BadSourceType ...
	BadSourceType ProvisioningErrorCode = "BadSourceType"
	// NoCustomizerScript ...
	NoCustomizerScript ProvisioningErrorCode = "NoCustomizerScript"
	// Other ...
	Other ProvisioningErrorCode = "Other"
	// ServerError ...
	ServerError ProvisioningErrorCode = "ServerError"
	// UnsupportedCustomizerType ...
	UnsupportedCustomizerType ProvisioningErrorCode = "UnsupportedCustomizerType"
)

// PossibleProvisioningErrorCodeValues returns an array of possible values for the ProvisioningErrorCode const type.
func PossibleProvisioningErrorCodeValues() []ProvisioningErrorCode {
	return []ProvisioningErrorCode{BadCustomizerType, BadDistributeType, BadISOSource, BadManagedImageSource, BadPIRSource, BadSharedImageDistribute, BadSourceType, NoCustomizerScript, Other, ServerError, UnsupportedCustomizerType}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Deleting, Failed, Succeeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Succeeded}
}

// RunState enumerates the values for run state.
type RunState string

const (
	// RunStateFailed ...
	RunStateFailed RunState = "Failed"
	// RunStatePartiallySucceeded ...
	RunStatePartiallySucceeded RunState = "PartiallySucceeded"
	// RunStateRunning ...
	RunStateRunning RunState = "Running"
	// RunStateSucceeded ...
	RunStateSucceeded RunState = "Succeeded"
)

// PossibleRunStateValues returns an array of possible values for the RunState const type.
func PossibleRunStateValues() []RunState {
	return []RunState{RunStateFailed, RunStatePartiallySucceeded, RunStateRunning, RunStateSucceeded}
}

// RunSubState enumerates the values for run sub state.
type RunSubState string

const (
	// Building ...
	Building RunSubState = "Building"
	// Customizing ...
	Customizing RunSubState = "Customizing"
	// Distributing ...
	Distributing RunSubState = "Distributing"
	// Queued ...
	Queued RunSubState = "Queued"
)

// PossibleRunSubStateValues returns an array of possible values for the RunSubState const type.
func PossibleRunSubStateValues() []RunSubState {
	return []RunSubState{Building, Customizing, Distributing, Queued}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeImageTemplateSource ...
	TypeImageTemplateSource Type = "ImageTemplateSource"
	// TypeISO ...
	TypeISO Type = "ISO"
	// TypeManagedImage ...
	TypeManagedImage Type = "ManagedImage"
	// TypePlatformImage ...
	TypePlatformImage Type = "PlatformImage"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeImageTemplateSource, TypeISO, TypeManagedImage, TypePlatformImage}
}

// TypeBasicImageTemplateCustomizer enumerates the values for type basic image template customizer.
type TypeBasicImageTemplateCustomizer string

const (
	// TypeImageTemplateCustomizer ...
	TypeImageTemplateCustomizer TypeBasicImageTemplateCustomizer = "ImageTemplateCustomizer"
	// TypePowerShell ...
	TypePowerShell TypeBasicImageTemplateCustomizer = "PowerShell"
	// TypeShell ...
	TypeShell TypeBasicImageTemplateCustomizer = "Shell"
	// TypeWindowsRestart ...
	TypeWindowsRestart TypeBasicImageTemplateCustomizer = "WindowsRestart"
)

// PossibleTypeBasicImageTemplateCustomizerValues returns an array of possible values for the TypeBasicImageTemplateCustomizer const type.
func PossibleTypeBasicImageTemplateCustomizerValues() []TypeBasicImageTemplateCustomizer {
	return []TypeBasicImageTemplateCustomizer{TypeImageTemplateCustomizer, TypePowerShell, TypeShell, TypeWindowsRestart}
}

// TypeBasicImageTemplateDistributor enumerates the values for type basic image template distributor.
type TypeBasicImageTemplateDistributor string

const (
	// TypeBasicImageTemplateDistributorTypeImageTemplateDistributor ...
	TypeBasicImageTemplateDistributorTypeImageTemplateDistributor TypeBasicImageTemplateDistributor = "ImageTemplateDistributor"
	// TypeBasicImageTemplateDistributorTypeManagedImage ...
	TypeBasicImageTemplateDistributorTypeManagedImage TypeBasicImageTemplateDistributor = "ManagedImage"
	// TypeBasicImageTemplateDistributorTypeSharedImage ...
	TypeBasicImageTemplateDistributorTypeSharedImage TypeBasicImageTemplateDistributor = "SharedImage"
	// TypeBasicImageTemplateDistributorTypeVHD ...
	TypeBasicImageTemplateDistributorTypeVHD TypeBasicImageTemplateDistributor = "VHD"
)

// PossibleTypeBasicImageTemplateDistributorValues returns an array of possible values for the TypeBasicImageTemplateDistributor const type.
func PossibleTypeBasicImageTemplateDistributorValues() []TypeBasicImageTemplateDistributor {
	return []TypeBasicImageTemplateDistributor{TypeBasicImageTemplateDistributorTypeImageTemplateDistributor, TypeBasicImageTemplateDistributorTypeManagedImage, TypeBasicImageTemplateDistributorTypeSharedImage, TypeBasicImageTemplateDistributorTypeVHD}
}
