package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AadConnectivityState enumerates the values for aad connectivity state.
type AadConnectivityState string

const (
	// Connected ...
	Connected AadConnectivityState = "Connected"
	// Discovered ...
	Discovered AadConnectivityState = "Discovered"
	// NotLicensed ...
	NotLicensed AadConnectivityState = "NotLicensed"
)

// PossibleAadConnectivityStateValues returns an array of possible values for the AadConnectivityState const type.
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return []AadConnectivityState{Connected, Discovered, NotLicensed}
}

// Action enumerates the values for action.
type Action string

const (
	// Add ...
	Add Action = "Add"
	// Recommended ...
	Recommended Action = "Recommended"
	// Remove ...
	Remove Action = "Remove"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Add, Recommended, Remove}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAutomationAction ...
	ActionTypeAutomationAction ActionType = "AutomationAction"
	// ActionTypeEventHub ...
	ActionTypeEventHub ActionType = "EventHub"
	// ActionTypeLogicApp ...
	ActionTypeLogicApp ActionType = "LogicApp"
	// ActionTypeWorkspace ...
	ActionTypeWorkspace ActionType = "Workspace"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAutomationAction, ActionTypeEventHub, ActionTypeLogicApp, ActionTypeWorkspace}
}

// AlertIntent enumerates the values for alert intent.
type AlertIntent string

const (
	// Collection ...
	Collection AlertIntent = "Collection"
	// CommandAndControl ...
	CommandAndControl AlertIntent = "CommandAndControl"
	// CredentialAccess ...
	CredentialAccess AlertIntent = "CredentialAccess"
	// DefenseEvasion ...
	DefenseEvasion AlertIntent = "DefenseEvasion"
	// Discovery ...
	Discovery AlertIntent = "Discovery"
	// Execution ...
	Execution AlertIntent = "Execution"
	// Exfiltration ...
	Exfiltration AlertIntent = "Exfiltration"
	// Exploitation ...
	Exploitation AlertIntent = "Exploitation"
	// Impact ...
	Impact AlertIntent = "Impact"
	// InitialAccess ...
	InitialAccess AlertIntent = "InitialAccess"
	// LateralMovement ...
	LateralMovement AlertIntent = "LateralMovement"
	// Persistence ...
	Persistence AlertIntent = "Persistence"
	// PreAttack ...
	PreAttack AlertIntent = "PreAttack"
	// PrivilegeEscalation ...
	PrivilegeEscalation AlertIntent = "PrivilegeEscalation"
	// Probing ...
	Probing AlertIntent = "Probing"
	// Unknown ...
	Unknown AlertIntent = "Unknown"
)

// PossibleAlertIntentValues returns an array of possible values for the AlertIntent const type.
func PossibleAlertIntentValues() []AlertIntent {
	return []AlertIntent{Collection, CommandAndControl, CredentialAccess, DefenseEvasion, Discovery, Execution, Exfiltration, Exploitation, Impact, InitialAccess, LateralMovement, Persistence, PreAttack, PrivilegeEscalation, Probing, Unknown}
}

// AlertNotifications enumerates the values for alert notifications.
type AlertNotifications string

const (
	// Off Don't get notifications on new alerts
	Off AlertNotifications = "Off"
	// On Get notifications on new alerts
	On AlertNotifications = "On"
)

// PossibleAlertNotificationsValues returns an array of possible values for the AlertNotifications const type.
func PossibleAlertNotificationsValues() []AlertNotifications {
	return []AlertNotifications{Off, On}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// High ...
	High AlertSeverity = "High"
	// Informational ...
	Informational AlertSeverity = "Informational"
	// Low ...
	Low AlertSeverity = "Low"
	// Medium ...
	Medium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{High, Informational, Low, Medium}
}

// AlertsToAdmins enumerates the values for alerts to admins.
type AlertsToAdmins string

const (
	// AlertsToAdminsOff Don't send notification on new alerts to the subscription's admins
	AlertsToAdminsOff AlertsToAdmins = "Off"
	// AlertsToAdminsOn Send notification on new alerts to the subscription's admins
	AlertsToAdminsOn AlertsToAdmins = "On"
)

// PossibleAlertsToAdminsValues returns an array of possible values for the AlertsToAdmins const type.
func PossibleAlertsToAdminsValues() []AlertsToAdmins {
	return []AlertsToAdmins{AlertsToAdminsOff, AlertsToAdminsOn}
}

// AssessedResourceType enumerates the values for assessed resource type.
type AssessedResourceType string

const (
	// AssessedResourceTypeAdditionalData ...
	AssessedResourceTypeAdditionalData AssessedResourceType = "AdditionalData"
	// AssessedResourceTypeContainerRegistryVulnerability ...
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = "ContainerRegistryVulnerability"
	// AssessedResourceTypeServerVulnerabilityAssessment ...
	AssessedResourceTypeServerVulnerabilityAssessment AssessedResourceType = "ServerVulnerabilityAssessment"
	// AssessedResourceTypeSQLServerVulnerability ...
	AssessedResourceTypeSQLServerVulnerability AssessedResourceType = "SqlServerVulnerability"
)

// PossibleAssessedResourceTypeValues returns an array of possible values for the AssessedResourceType const type.
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return []AssessedResourceType{AssessedResourceTypeAdditionalData, AssessedResourceTypeContainerRegistryVulnerability, AssessedResourceTypeServerVulnerabilityAssessment, AssessedResourceTypeSQLServerVulnerability}
}

// AssessmentStatusCode enumerates the values for assessment status code.
type AssessmentStatusCode string

const (
	// Healthy The resource is healthy
	Healthy AssessmentStatusCode = "Healthy"
	// NotApplicable Assessment for this resource did not happen
	NotApplicable AssessmentStatusCode = "NotApplicable"
	// Unhealthy The resource has a security issue that needs to be addressed
	Unhealthy AssessmentStatusCode = "Unhealthy"
)

// PossibleAssessmentStatusCodeValues returns an array of possible values for the AssessmentStatusCode const type.
func PossibleAssessmentStatusCodeValues() []AssessmentStatusCode {
	return []AssessmentStatusCode{Healthy, NotApplicable, Unhealthy}
}

// AssessmentType enumerates the values for assessment type.
type AssessmentType string

const (
	// BuiltIn Azure Security Center managed assessments
	BuiltIn AssessmentType = "BuiltIn"
	// CustomerManaged User assessments pushed directly by the user or other third party to Azure Security
	// Center
	CustomerManaged AssessmentType = "CustomerManaged"
	// CustomPolicy User defined policies that are automatically ingested from Azure Policy to Azure Security
	// Center
	CustomPolicy AssessmentType = "CustomPolicy"
	// VerifiedPartner An assessment that was created by a verified 3rd party if the user connected it to ASC
	VerifiedPartner AssessmentType = "VerifiedPartner"
)

// PossibleAssessmentTypeValues returns an array of possible values for the AssessmentType const type.
func PossibleAssessmentTypeValues() []AssessmentType {
	return []AssessmentType{BuiltIn, CustomerManaged, CustomPolicy, VerifiedPartner}
}

// AuthenticationProvisioningState enumerates the values for authentication provisioning state.
type AuthenticationProvisioningState string

const (
	// Expired the connection is expired
	Expired AuthenticationProvisioningState = "Expired"
	// IncorrectPolicy Incorrect policy of the connector
	IncorrectPolicy AuthenticationProvisioningState = "IncorrectPolicy"
	// Invalid Invalid connector
	Invalid AuthenticationProvisioningState = "Invalid"
	// Valid Valid connector
	Valid AuthenticationProvisioningState = "Valid"
)

// PossibleAuthenticationProvisioningStateValues returns an array of possible values for the AuthenticationProvisioningState const type.
func PossibleAuthenticationProvisioningStateValues() []AuthenticationProvisioningState {
	return []AuthenticationProvisioningState{Expired, IncorrectPolicy, Invalid, Valid}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAuthenticationDetailsProperties ...
	AuthenticationTypeAuthenticationDetailsProperties AuthenticationType = "AuthenticationDetailsProperties"
	// AuthenticationTypeAwsAssumeRole ...
	AuthenticationTypeAwsAssumeRole AuthenticationType = "awsAssumeRole"
	// AuthenticationTypeAwsCreds ...
	AuthenticationTypeAwsCreds AuthenticationType = "awsCreds"
	// AuthenticationTypeGcpCredentials ...
	AuthenticationTypeGcpCredentials AuthenticationType = "gcpCredentials"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAuthenticationDetailsProperties, AuthenticationTypeAwsAssumeRole, AuthenticationTypeAwsCreds, AuthenticationTypeGcpCredentials}
}

// AutoProvision enumerates the values for auto provision.
type AutoProvision string

const (
	// AutoProvisionOff Do not install security agent on the VMs automatically
	AutoProvisionOff AutoProvision = "Off"
	// AutoProvisionOn Install missing security agent on VMs automatically
	AutoProvisionOn AutoProvision = "On"
)

// PossibleAutoProvisionValues returns an array of possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{AutoProvisionOff, AutoProvisionOn}
}

// Category enumerates the values for category.
type Category string

const (
	// Compute ...
	Compute Category = "Compute"
	// Data ...
	Data Category = "Data"
	// IdentityAndAccess ...
	IdentityAndAccess Category = "IdentityAndAccess"
	// IoT ...
	IoT Category = "IoT"
	// Networking ...
	Networking Category = "Networking"
)

// PossibleCategoryValues returns an array of possible values for the Category const type.
func PossibleCategoryValues() []Category {
	return []Category{Compute, Data, IdentityAndAccess, IoT, Networking}
}

// ConfigurationStatus enumerates the values for configuration status.
type ConfigurationStatus string

const (
	// Configured ...
	Configured ConfigurationStatus = "Configured"
	// Failed ...
	Failed ConfigurationStatus = "Failed"
	// InProgress ...
	InProgress ConfigurationStatus = "InProgress"
	// NoStatus ...
	NoStatus ConfigurationStatus = "NoStatus"
	// NotConfigured ...
	NotConfigured ConfigurationStatus = "NotConfigured"
)

// PossibleConfigurationStatusValues returns an array of possible values for the ConfigurationStatus const type.
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return []ConfigurationStatus{Configured, Failed, InProgress, NoStatus, NotConfigured}
}

// ConfigurationStatus1 enumerates the values for configuration status 1.
type ConfigurationStatus1 string

const (
	// ConfigurationStatus1Configured ...
	ConfigurationStatus1Configured ConfigurationStatus1 = "Configured"
	// ConfigurationStatus1Failed ...
	ConfigurationStatus1Failed ConfigurationStatus1 = "Failed"
	// ConfigurationStatus1InProgress ...
	ConfigurationStatus1InProgress ConfigurationStatus1 = "InProgress"
	// ConfigurationStatus1NoStatus ...
	ConfigurationStatus1NoStatus ConfigurationStatus1 = "NoStatus"
	// ConfigurationStatus1NotConfigured ...
	ConfigurationStatus1NotConfigured ConfigurationStatus1 = "NotConfigured"
)

// PossibleConfigurationStatus1Values returns an array of possible values for the ConfigurationStatus1 const type.
func PossibleConfigurationStatus1Values() []ConfigurationStatus1 {
	return []ConfigurationStatus1{ConfigurationStatus1Configured, ConfigurationStatus1Failed, ConfigurationStatus1InProgress, ConfigurationStatus1NoStatus, ConfigurationStatus1NotConfigured}
}

// ConfigurationStatus2 enumerates the values for configuration status 2.
type ConfigurationStatus2 string

const (
	// ConfigurationStatus2Configured ...
	ConfigurationStatus2Configured ConfigurationStatus2 = "Configured"
	// ConfigurationStatus2Failed ...
	ConfigurationStatus2Failed ConfigurationStatus2 = "Failed"
	// ConfigurationStatus2InProgress ...
	ConfigurationStatus2InProgress ConfigurationStatus2 = "InProgress"
	// ConfigurationStatus2NoStatus ...
	ConfigurationStatus2NoStatus ConfigurationStatus2 = "NoStatus"
	// ConfigurationStatus2NotConfigured ...
	ConfigurationStatus2NotConfigured ConfigurationStatus2 = "NotConfigured"
)

// PossibleConfigurationStatus2Values returns an array of possible values for the ConfigurationStatus2 const type.
func PossibleConfigurationStatus2Values() []ConfigurationStatus2 {
	return []ConfigurationStatus2{ConfigurationStatus2Configured, ConfigurationStatus2Failed, ConfigurationStatus2InProgress, ConfigurationStatus2NoStatus, ConfigurationStatus2NotConfigured}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// External ...
	External ConnectionType = "External"
	// Internal ...
	Internal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{External, Internal}
}

// ControlType enumerates the values for control type.
type ControlType string

const (
	// ControlTypeBuiltIn Azure Security Center managed assessments
	ControlTypeBuiltIn ControlType = "BuiltIn"
	// ControlTypeCustom Non Azure Security Center managed assessments
	ControlTypeCustom ControlType = "Custom"
)

// PossibleControlTypeValues returns an array of possible values for the ControlType const type.
func PossibleControlTypeValues() []ControlType {
	return []ControlType{ControlTypeBuiltIn, ControlTypeCustom}
}

// DataSource enumerates the values for data source.
type DataSource string

const (
	// TwinData Devices twin data
	TwinData DataSource = "TwinData"
)

// PossibleDataSourceValues returns an array of possible values for the DataSource const type.
func PossibleDataSourceValues() []DataSource {
	return []DataSource{TwinData}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EnforcementMode enumerates the values for enforcement mode.
type EnforcementMode string

const (
	// Audit ...
	Audit EnforcementMode = "Audit"
	// Enforce ...
	Enforce EnforcementMode = "Enforce"
	// None ...
	None EnforcementMode = "None"
)

// PossibleEnforcementModeValues returns an array of possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{Audit, Enforce, None}
}

// EnforcementSupport enumerates the values for enforcement support.
type EnforcementSupport string

const (
	// EnforcementSupportNotSupported ...
	EnforcementSupportNotSupported EnforcementSupport = "NotSupported"
	// EnforcementSupportSupported ...
	EnforcementSupportSupported EnforcementSupport = "Supported"
	// EnforcementSupportUnknown ...
	EnforcementSupportUnknown EnforcementSupport = "Unknown"
)

// PossibleEnforcementSupportValues returns an array of possible values for the EnforcementSupport const type.
func PossibleEnforcementSupportValues() []EnforcementSupport {
	return []EnforcementSupport{EnforcementSupportNotSupported, EnforcementSupportSupported, EnforcementSupportUnknown}
}

// EventSource enumerates the values for event source.
type EventSource string

const (
	// Alerts ...
	Alerts EventSource = "Alerts"
	// Assessments ...
	Assessments EventSource = "Assessments"
)

// PossibleEventSourceValues returns an array of possible values for the EventSource const type.
func PossibleEventSourceValues() []EventSource {
	return []EventSource{Alerts, Assessments}
}

// Exe enumerates the values for exe.
type Exe string

const (
	// ExeAudit ...
	ExeAudit Exe = "Audit"
	// ExeEnforce ...
	ExeEnforce Exe = "Enforce"
	// ExeNone ...
	ExeNone Exe = "None"
)

// PossibleExeValues returns an array of possible values for the Exe const type.
func PossibleExeValues() []Exe {
	return []Exe{ExeAudit, ExeEnforce, ExeNone}
}

// Executable enumerates the values for executable.
type Executable string

const (
	// ExecutableAudit ...
	ExecutableAudit Executable = "Audit"
	// ExecutableEnforce ...
	ExecutableEnforce Executable = "Enforce"
	// ExecutableNone ...
	ExecutableNone Executable = "None"
)

// PossibleExecutableValues returns an array of possible values for the Executable const type.
func PossibleExecutableValues() []Executable {
	return []Executable{ExecutableAudit, ExecutableEnforce, ExecutableNone}
}

// ExpandControlsEnum enumerates the values for expand controls enum.
type ExpandControlsEnum string

const (
	// Definition Add definition object for each control
	Definition ExpandControlsEnum = "definition"
)

// PossibleExpandControlsEnumValues returns an array of possible values for the ExpandControlsEnum const type.
func PossibleExpandControlsEnumValues() []ExpandControlsEnum {
	return []ExpandControlsEnum{Definition}
}

// ExpandEnum enumerates the values for expand enum.
type ExpandEnum string

const (
	// Links All links associated with an assessment
	Links ExpandEnum = "links"
	// Metadata Assessment metadata
	Metadata ExpandEnum = "metadata"
)

// PossibleExpandEnumValues returns an array of possible values for the ExpandEnum const type.
func PossibleExpandEnumValues() []ExpandEnum {
	return []ExpandEnum{Links, Metadata}
}

// ExportData enumerates the values for export data.
type ExportData string

const (
	// RawEvents Agent raw events
	RawEvents ExportData = "RawEvents"
)

// PossibleExportDataValues returns an array of possible values for the ExportData const type.
func PossibleExportDataValues() []ExportData {
	return []ExportData{RawEvents}
}

// ExternalSecuritySolutionKind enumerates the values for external security solution kind.
type ExternalSecuritySolutionKind string

const (
	// AAD ...
	AAD ExternalSecuritySolutionKind = "AAD"
	// ATA ...
	ATA ExternalSecuritySolutionKind = "ATA"
	// CEF ...
	CEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns an array of possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{AAD, ATA, CEF}
}

// Family enumerates the values for family.
type Family string

const (
	// Ngfw ...
	Ngfw Family = "Ngfw"
	// SaasWaf ...
	SaasWaf Family = "SaasWaf"
	// Va ...
	Va Family = "Va"
	// Waf ...
	Waf Family = "Waf"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Ngfw, SaasWaf, Va, Waf}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDll ...
	FileTypeDll FileType = "Dll"
	// FileTypeExe ...
	FileTypeExe FileType = "Exe"
	// FileTypeExecutable ...
	FileTypeExecutable FileType = "Executable"
	// FileTypeMsi ...
	FileTypeMsi FileType = "Msi"
	// FileTypeScript ...
	FileTypeScript FileType = "Script"
	// FileTypeUnknown ...
	FileTypeUnknown FileType = "Unknown"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDll, FileTypeExe, FileTypeExecutable, FileTypeMsi, FileTypeScript, FileTypeUnknown}
}

// HybridComputeProvisioningState enumerates the values for hybrid compute provisioning state.
type HybridComputeProvisioningState string

const (
	// HybridComputeProvisioningStateExpired the service principal details are expired
	HybridComputeProvisioningStateExpired HybridComputeProvisioningState = "Expired"
	// HybridComputeProvisioningStateInvalid Invalid service principal details.
	HybridComputeProvisioningStateInvalid HybridComputeProvisioningState = "Invalid"
	// HybridComputeProvisioningStateValid Valid service principal details.
	HybridComputeProvisioningStateValid HybridComputeProvisioningState = "Valid"
)

// PossibleHybridComputeProvisioningStateValues returns an array of possible values for the HybridComputeProvisioningState const type.
func PossibleHybridComputeProvisioningStateValues() []HybridComputeProvisioningState {
	return []HybridComputeProvisioningState{HybridComputeProvisioningStateExpired, HybridComputeProvisioningStateInvalid, HybridComputeProvisioningStateValid}
}

// ImplementationEffort enumerates the values for implementation effort.
type ImplementationEffort string

const (
	// ImplementationEffortHigh ...
	ImplementationEffortHigh ImplementationEffort = "High"
	// ImplementationEffortLow ...
	ImplementationEffortLow ImplementationEffort = "Low"
	// ImplementationEffortModerate ...
	ImplementationEffortModerate ImplementationEffort = "Moderate"
)

// PossibleImplementationEffortValues returns an array of possible values for the ImplementationEffort const type.
func PossibleImplementationEffortValues() []ImplementationEffort {
	return []ImplementationEffort{ImplementationEffortHigh, ImplementationEffortLow, ImplementationEffortModerate}
}

// Issue enumerates the values for issue.
type Issue string

const (
	// ExecutableViolationsAudited ...
	ExecutableViolationsAudited Issue = "ExecutableViolationsAudited"
	// MsiAndScriptViolationsAudited ...
	MsiAndScriptViolationsAudited Issue = "MsiAndScriptViolationsAudited"
	// MsiAndScriptViolationsBlocked ...
	MsiAndScriptViolationsBlocked Issue = "MsiAndScriptViolationsBlocked"
	// RulesViolatedManually ...
	RulesViolatedManually Issue = "RulesViolatedManually"
	// ViolationsAudited ...
	ViolationsAudited Issue = "ViolationsAudited"
	// ViolationsBlocked ...
	ViolationsBlocked Issue = "ViolationsBlocked"
)

// PossibleIssueValues returns an array of possible values for the Issue const type.
func PossibleIssueValues() []Issue {
	return []Issue{ExecutableViolationsAudited, MsiAndScriptViolationsAudited, MsiAndScriptViolationsBlocked, RulesViolatedManually, ViolationsAudited, ViolationsBlocked}
}

// KindEnum enumerates the values for kind enum.
type KindEnum string

const (
	// KindDataExportSettings ...
	KindDataExportSettings KindEnum = "DataExportSettings"
	// KindSetting ...
	KindSetting KindEnum = "Setting"
	// KindSettingResource ...
	KindSettingResource KindEnum = "SettingResource"
)

// PossibleKindEnumValues returns an array of possible values for the KindEnum const type.
func PossibleKindEnumValues() []KindEnum {
	return []KindEnum{KindDataExportSettings, KindSetting, KindSettingResource}
}

// KindEnum1 enumerates the values for kind enum 1.
type KindEnum1 string

const (
	// KindAAD ...
	KindAAD KindEnum1 = "AAD"
	// KindATA ...
	KindATA KindEnum1 = "ATA"
	// KindCEF ...
	KindCEF KindEnum1 = "CEF"
	// KindExternalSecuritySolution ...
	KindExternalSecuritySolution KindEnum1 = "ExternalSecuritySolution"
)

// PossibleKindEnum1Values returns an array of possible values for the KindEnum1 const type.
func PossibleKindEnum1Values() []KindEnum1 {
	return []KindEnum1{KindAAD, KindATA, KindCEF, KindExternalSecuritySolution}
}

// Msi enumerates the values for msi.
type Msi string

const (
	// MsiAudit ...
	MsiAudit Msi = "Audit"
	// MsiEnforce ...
	MsiEnforce Msi = "Enforce"
	// MsiNone ...
	MsiNone Msi = "None"
)

// PossibleMsiValues returns an array of possible values for the Msi const type.
func PossibleMsiValues() []Msi {
	return []Msi{MsiAudit, MsiEnforce, MsiNone}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equals ...
	Equals Operator = "Equals"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqualTo ...
	GreaterThanOrEqualTo Operator = "GreaterThanOrEqualTo"
	// LesserThan ...
	LesserThan Operator = "LesserThan"
	// LesserThanOrEqualTo ...
	LesserThanOrEqualTo Operator = "LesserThanOrEqualTo"
	// NotEquals ...
	NotEquals Operator = "NotEquals"
	// StartsWith ...
	StartsWith Operator = "StartsWith"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Contains, EndsWith, Equals, GreaterThan, GreaterThanOrEqualTo, LesserThan, LesserThanOrEqualTo, NotEquals, StartsWith}
}

// PermissionProperty enumerates the values for permission property.
type PermissionProperty string

const (
	// AWSAmazonSSMAutomationRole The permission provides for EC2 Automation service to execute activities
	// defined within Automation documents.
	AWSAmazonSSMAutomationRole PermissionProperty = "AWS::AmazonSSMAutomationRole"
	// AWSAWSSecurityHubReadOnlyAccess This permission provides read only access to AWS Security Hub resources.
	AWSAWSSecurityHubReadOnlyAccess PermissionProperty = "AWS::AWSSecurityHubReadOnlyAccess"
	// AWSSecurityAudit This permission grants access to read security configuration metadata.
	AWSSecurityAudit PermissionProperty = "AWS::SecurityAudit"
	// GCPSecurityCenterAdminViewer This permission provides read only access to GCP Security Command Center.
	GCPSecurityCenterAdminViewer PermissionProperty = "GCP::Security Center Admin Viewer"
)

// PossiblePermissionPropertyValues returns an array of possible values for the PermissionProperty const type.
func PossiblePermissionPropertyValues() []PermissionProperty {
	return []PermissionProperty{AWSAmazonSSMAutomationRole, AWSAWSSecurityHubReadOnlyAccess, AWSSecurityAudit, GCPSecurityCenterAdminViewer}
}

// PricingTier enumerates the values for pricing tier.
type PricingTier string

const (
	// Free Get free Azure security center experience with basic security features
	Free PricingTier = "Free"
	// Standard Get the standard Azure security center experience with advanced security features
	Standard PricingTier = "Standard"
)

// PossiblePricingTierValues returns an array of possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{Free, Standard}
}

// PropertyType enumerates the values for property type.
type PropertyType string

const (
	// Boolean ...
	Boolean PropertyType = "Boolean"
	// Integer ...
	Integer PropertyType = "Integer"
	// Number ...
	Number PropertyType = "Number"
	// String ...
	String PropertyType = "String"
)

// PossiblePropertyTypeValues returns an array of possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{Boolean, Integer, Number, String}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// All ...
	All Protocol = "*"
	// TCP ...
	TCP Protocol = "TCP"
	// UDP ...
	UDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{All, TCP, UDP}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Canceled ...
	ProvisioningState1Canceled ProvisioningState1 = "Canceled"
	// ProvisioningState1Deprovisioning ...
	ProvisioningState1Deprovisioning ProvisioningState1 = "Deprovisioning"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Provisioning ...
	ProvisioningState1Provisioning ProvisioningState1 = "Provisioning"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Canceled, ProvisioningState1Deprovisioning, ProvisioningState1Failed, ProvisioningState1Provisioning, ProvisioningState1Succeeded}
}

// Rank enumerates the values for rank.
type Rank string

const (
	// RankCritical ...
	RankCritical Rank = "Critical"
	// RankHigh ...
	RankHigh Rank = "High"
	// RankLow ...
	RankLow Rank = "Low"
	// RankMedium ...
	RankMedium Rank = "Medium"
	// RankNone ...
	RankNone Rank = "None"
)

// PossibleRankValues returns an array of possible values for the Rank const type.
func PossibleRankValues() []Rank {
	return []Rank{RankCritical, RankHigh, RankLow, RankMedium, RankNone}
}

// RecommendationAction enumerates the values for recommendation action.
type RecommendationAction string

const (
	// RecommendationActionAdd ...
	RecommendationActionAdd RecommendationAction = "Add"
	// RecommendationActionRecommended ...
	RecommendationActionRecommended RecommendationAction = "Recommended"
	// RecommendationActionRemove ...
	RecommendationActionRemove RecommendationAction = "Remove"
)

// PossibleRecommendationActionValues returns an array of possible values for the RecommendationAction const type.
func PossibleRecommendationActionValues() []RecommendationAction {
	return []RecommendationAction{RecommendationActionAdd, RecommendationActionRecommended, RecommendationActionRemove}
}

// RecommendationAction1 enumerates the values for recommendation action 1.
type RecommendationAction1 string

const (
	// RecommendationAction1Add ...
	RecommendationAction1Add RecommendationAction1 = "Add"
	// RecommendationAction1Recommended ...
	RecommendationAction1Recommended RecommendationAction1 = "Recommended"
	// RecommendationAction1Remove ...
	RecommendationAction1Remove RecommendationAction1 = "Remove"
)

// PossibleRecommendationAction1Values returns an array of possible values for the RecommendationAction1 const type.
func PossibleRecommendationAction1Values() []RecommendationAction1 {
	return []RecommendationAction1{RecommendationAction1Add, RecommendationAction1Recommended, RecommendationAction1Remove}
}

// RecommendationConfigStatus enumerates the values for recommendation config status.
type RecommendationConfigStatus string

const (
	// Disabled ...
	Disabled RecommendationConfigStatus = "Disabled"
	// Enabled ...
	Enabled RecommendationConfigStatus = "Enabled"
)

// PossibleRecommendationConfigStatusValues returns an array of possible values for the RecommendationConfigStatus const type.
func PossibleRecommendationConfigStatusValues() []RecommendationConfigStatus {
	return []RecommendationConfigStatus{Disabled, Enabled}
}

// RecommendationSeverity enumerates the values for recommendation severity.
type RecommendationSeverity string

const (
	// RecommendationSeverityHealthy ...
	RecommendationSeverityHealthy RecommendationSeverity = "Healthy"
	// RecommendationSeverityHigh ...
	RecommendationSeverityHigh RecommendationSeverity = "High"
	// RecommendationSeverityLow ...
	RecommendationSeverityLow RecommendationSeverity = "Low"
	// RecommendationSeverityMedium ...
	RecommendationSeverityMedium RecommendationSeverity = "Medium"
	// RecommendationSeverityNotApplicable ...
	RecommendationSeverityNotApplicable RecommendationSeverity = "NotApplicable"
	// RecommendationSeverityOffByPolicy ...
	RecommendationSeverityOffByPolicy RecommendationSeverity = "OffByPolicy"
	// RecommendationSeverityUnknown ...
	RecommendationSeverityUnknown RecommendationSeverity = "Unknown"
)

// PossibleRecommendationSeverityValues returns an array of possible values for the RecommendationSeverity const type.
func PossibleRecommendationSeverityValues() []RecommendationSeverity {
	return []RecommendationSeverity{RecommendationSeverityHealthy, RecommendationSeverityHigh, RecommendationSeverityLow, RecommendationSeverityMedium, RecommendationSeverityNotApplicable, RecommendationSeverityOffByPolicy, RecommendationSeverityUnknown}
}

// RecommendationStatus enumerates the values for recommendation status.
type RecommendationStatus string

const (
	// RecommendationStatusNoStatus ...
	RecommendationStatusNoStatus RecommendationStatus = "NoStatus"
	// RecommendationStatusNotAvailable ...
	RecommendationStatusNotAvailable RecommendationStatus = "NotAvailable"
	// RecommendationStatusNotRecommended ...
	RecommendationStatusNotRecommended RecommendationStatus = "NotRecommended"
	// RecommendationStatusRecommended ...
	RecommendationStatusRecommended RecommendationStatus = "Recommended"
)

// PossibleRecommendationStatusValues returns an array of possible values for the RecommendationStatus const type.
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return []RecommendationStatus{RecommendationStatusNoStatus, RecommendationStatusNotAvailable, RecommendationStatusNotRecommended, RecommendationStatusRecommended}
}

// RecommendationType enumerates the values for recommendation type.
type RecommendationType string

const (
	// IoTACRAuthentication Authentication schema used for pull an edge module from an ACR repository does not
	// use Service Principal Authentication.
	IoTACRAuthentication RecommendationType = "IoT_ACRAuthentication"
	// IoTAgentSendsUnutilizedMessages IoT agent message size capacity is currently underutilized, causing an
	// increase in the number of sent messages. Adjust message intervals for better utilization.
	IoTAgentSendsUnutilizedMessages RecommendationType = "IoT_AgentSendsUnutilizedMessages"
	// IoTBaseline Identified security related system configuration issues.
	IoTBaseline RecommendationType = "IoT_Baseline"
	// IoTEdgeHubMemOptimize You can optimize Edge Hub memory usage by turning off protocol heads for any
	// protocols not used by Edge modules in your solution.
	IoTEdgeHubMemOptimize RecommendationType = "IoT_EdgeHubMemOptimize"
	// IoTEdgeLoggingOptions Logging is disabled for this edge module.
	IoTEdgeLoggingOptions RecommendationType = "IoT_EdgeLoggingOptions"
	// IoTInconsistentModuleSettings A minority within a device security group has inconsistent Edge Module
	// settings with the rest of their group.
	IoTInconsistentModuleSettings RecommendationType = "IoT_InconsistentModuleSettings"
	// IoTInstallAgent Install the Azure Security of Things Agent.
	IoTInstallAgent RecommendationType = "IoT_InstallAgent"
	// IoTIPFilterDenyAll IP Filter Configuration should have rules defined for allowed traffic and should deny
	// all other traffic by default.
	IoTIPFilterDenyAll RecommendationType = "IoT_IPFilter_DenyAll"
	// IoTIPFilterPermissiveRule An Allow IP Filter rules source IP range is too large. Overly permissive rules
	// might expose your IoT hub to malicious intenders.
	IoTIPFilterPermissiveRule RecommendationType = "IoT_IPFilter_PermissiveRule"
	// IoTOpenPorts A listening endpoint was found on the device.
	IoTOpenPorts RecommendationType = "IoT_OpenPorts"
	// IoTPermissiveFirewallPolicy An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny
	// all traffic by default and define rules to allow necessary communication to/from the device.
	IoTPermissiveFirewallPolicy RecommendationType = "IoT_PermissiveFirewallPolicy"
	// IoTPermissiveInputFirewallRules A rule in the firewall has been found that contains a permissive pattern
	// for a wide range of IP addresses or Ports.
	IoTPermissiveInputFirewallRules RecommendationType = "IoT_PermissiveInputFirewallRules"
	// IoTPermissiveOutputFirewallRules A rule in the firewall has been found that contains a permissive
	// pattern for a wide range of IP addresses or Ports.
	IoTPermissiveOutputFirewallRules RecommendationType = "IoT_PermissiveOutputFirewallRules"
	// IoTPrivilegedDockerOptions Edge module is configured to run in privileged mode, with extensive Linux
	// capabilities or with host-level network access (send/receive data to host machine).
	IoTPrivilegedDockerOptions RecommendationType = "IoT_PrivilegedDockerOptions"
	// IoTSharedCredentials Same authentication credentials to the IoT Hub used by multiple devices. This could
	// indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device
	// impersonation by an attacker.
	IoTSharedCredentials RecommendationType = "IoT_SharedCredentials"
	// IoTVulnerableTLSCipherSuite Insecure TLS configurations detected. Immediate upgrade recommended.
	IoTVulnerableTLSCipherSuite RecommendationType = "IoT_VulnerableTLSCipherSuite"
)

// PossibleRecommendationTypeValues returns an array of possible values for the RecommendationType const type.
func PossibleRecommendationTypeValues() []RecommendationType {
	return []RecommendationType{IoTACRAuthentication, IoTAgentSendsUnutilizedMessages, IoTBaseline, IoTEdgeHubMemOptimize, IoTEdgeLoggingOptions, IoTInconsistentModuleSettings, IoTInstallAgent, IoTIPFilterDenyAll, IoTIPFilterPermissiveRule, IoTOpenPorts, IoTPermissiveFirewallPolicy, IoTPermissiveInputFirewallRules, IoTPermissiveOutputFirewallRules, IoTPrivilegedDockerOptions, IoTSharedCredentials, IoTVulnerableTLSCipherSuite}
}

// ReportedSeverity enumerates the values for reported severity.
type ReportedSeverity string

const (
	// ReportedSeverityHigh ...
	ReportedSeverityHigh ReportedSeverity = "High"
	// ReportedSeverityInformational ...
	ReportedSeverityInformational ReportedSeverity = "Informational"
	// ReportedSeverityLow ...
	ReportedSeverityLow ReportedSeverity = "Low"
	// ReportedSeverityMedium ...
	ReportedSeverityMedium ReportedSeverity = "Medium"
)

// PossibleReportedSeverityValues returns an array of possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{ReportedSeverityHigh, ReportedSeverityInformational, ReportedSeverityLow, ReportedSeverityMedium}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// ResourceStatusHealthy This assessment on the resource is healthy
	ResourceStatusHealthy ResourceStatus = "Healthy"
	// ResourceStatusNotApplicable This assessment is not applicable to this resource
	ResourceStatusNotApplicable ResourceStatus = "NotApplicable"
	// ResourceStatusNotHealthy This assessment on the resource is not healthy
	ResourceStatusNotHealthy ResourceStatus = "NotHealthy"
	// ResourceStatusOffByPolicy This assessment is turned off by policy on this subscription
	ResourceStatusOffByPolicy ResourceStatus = "OffByPolicy"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{ResourceStatusHealthy, ResourceStatusNotApplicable, ResourceStatusNotHealthy, ResourceStatusOffByPolicy}
}

// RuleState enumerates the values for rule state.
type RuleState string

const (
	// RuleStateDisabled ...
	RuleStateDisabled RuleState = "Disabled"
	// RuleStateEnabled ...
	RuleStateEnabled RuleState = "Enabled"
	// RuleStateExpired ...
	RuleStateExpired RuleState = "Expired"
)

// PossibleRuleStateValues returns an array of possible values for the RuleState const type.
func PossibleRuleStateValues() []RuleState {
	return []RuleState{RuleStateDisabled, RuleStateEnabled, RuleStateExpired}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// RuleTypeActiveConnectionsNotInAllowedRange ...
	RuleTypeActiveConnectionsNotInAllowedRange RuleType = "ActiveConnectionsNotInAllowedRange"
	// RuleTypeAllowlistCustomAlertRule ...
	RuleTypeAllowlistCustomAlertRule RuleType = "AllowlistCustomAlertRule"
	// RuleTypeAmqpC2DMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DMessagesNotInAllowedRange RuleType = "AmqpC2DMessagesNotInAllowedRange"
	// RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange RuleType = "AmqpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeAmqpD2CMessagesNotInAllowedRange ...
	RuleTypeAmqpD2CMessagesNotInAllowedRange RuleType = "AmqpD2CMessagesNotInAllowedRange"
	// RuleTypeConnectionToIPNotAllowed ...
	RuleTypeConnectionToIPNotAllowed RuleType = "ConnectionToIpNotAllowed"
	// RuleTypeCustomAlertRule ...
	RuleTypeCustomAlertRule RuleType = "CustomAlertRule"
	// RuleTypeDenylistCustomAlertRule ...
	RuleTypeDenylistCustomAlertRule RuleType = "DenylistCustomAlertRule"
	// RuleTypeDirectMethodInvokesNotInAllowedRange ...
	RuleTypeDirectMethodInvokesNotInAllowedRange RuleType = "DirectMethodInvokesNotInAllowedRange"
	// RuleTypeFailedLocalLoginsNotInAllowedRange ...
	RuleTypeFailedLocalLoginsNotInAllowedRange RuleType = "FailedLocalLoginsNotInAllowedRange"
	// RuleTypeFileUploadsNotInAllowedRange ...
	RuleTypeFileUploadsNotInAllowedRange RuleType = "FileUploadsNotInAllowedRange"
	// RuleTypeHTTPC2DMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DMessagesNotInAllowedRange RuleType = "HttpC2DMessagesNotInAllowedRange"
	// RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange RuleType = "HttpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeHTTPD2CMessagesNotInAllowedRange ...
	RuleTypeHTTPD2CMessagesNotInAllowedRange RuleType = "HttpD2CMessagesNotInAllowedRange"
	// RuleTypeListCustomAlertRule ...
	RuleTypeListCustomAlertRule RuleType = "ListCustomAlertRule"
	// RuleTypeLocalUserNotAllowed ...
	RuleTypeLocalUserNotAllowed RuleType = "LocalUserNotAllowed"
	// RuleTypeMqttC2DMessagesNotInAllowedRange ...
	RuleTypeMqttC2DMessagesNotInAllowedRange RuleType = "MqttC2DMessagesNotInAllowedRange"
	// RuleTypeMqttC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeMqttC2DRejectedMessagesNotInAllowedRange RuleType = "MqttC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeMqttD2CMessagesNotInAllowedRange ...
	RuleTypeMqttD2CMessagesNotInAllowedRange RuleType = "MqttD2CMessagesNotInAllowedRange"
	// RuleTypeProcessNotAllowed ...
	RuleTypeProcessNotAllowed RuleType = "ProcessNotAllowed"
	// RuleTypeQueuePurgesNotInAllowedRange ...
	RuleTypeQueuePurgesNotInAllowedRange RuleType = "QueuePurgesNotInAllowedRange"
	// RuleTypeThresholdCustomAlertRule ...
	RuleTypeThresholdCustomAlertRule RuleType = "ThresholdCustomAlertRule"
	// RuleTypeTimeWindowCustomAlertRule ...
	RuleTypeTimeWindowCustomAlertRule RuleType = "TimeWindowCustomAlertRule"
	// RuleTypeTwinUpdatesNotInAllowedRange ...
	RuleTypeTwinUpdatesNotInAllowedRange RuleType = "TwinUpdatesNotInAllowedRange"
	// RuleTypeUnauthorizedOperationsNotInAllowedRange ...
	RuleTypeUnauthorizedOperationsNotInAllowedRange RuleType = "UnauthorizedOperationsNotInAllowedRange"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{RuleTypeActiveConnectionsNotInAllowedRange, RuleTypeAllowlistCustomAlertRule, RuleTypeAmqpC2DMessagesNotInAllowedRange, RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange, RuleTypeAmqpD2CMessagesNotInAllowedRange, RuleTypeConnectionToIPNotAllowed, RuleTypeCustomAlertRule, RuleTypeDenylistCustomAlertRule, RuleTypeDirectMethodInvokesNotInAllowedRange, RuleTypeFailedLocalLoginsNotInAllowedRange, RuleTypeFileUploadsNotInAllowedRange, RuleTypeHTTPC2DMessagesNotInAllowedRange, RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange, RuleTypeHTTPD2CMessagesNotInAllowedRange, RuleTypeListCustomAlertRule, RuleTypeLocalUserNotAllowed, RuleTypeMqttC2DMessagesNotInAllowedRange, RuleTypeMqttC2DRejectedMessagesNotInAllowedRange, RuleTypeMqttD2CMessagesNotInAllowedRange, RuleTypeProcessNotAllowed, RuleTypeQueuePurgesNotInAllowedRange, RuleTypeThresholdCustomAlertRule, RuleTypeTimeWindowCustomAlertRule, RuleTypeTwinUpdatesNotInAllowedRange, RuleTypeUnauthorizedOperationsNotInAllowedRange}
}

// Script enumerates the values for script.
type Script string

const (
	// ScriptAudit ...
	ScriptAudit Script = "Audit"
	// ScriptEnforce ...
	ScriptEnforce Script = "Enforce"
	// ScriptNone ...
	ScriptNone Script = "None"
)

// PossibleScriptValues returns an array of possible values for the Script const type.
func PossibleScriptValues() []Script {
	return []Script{ScriptAudit, ScriptEnforce, ScriptNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityHigh ...
	SeverityHigh Severity = "High"
	// SeverityLow ...
	SeverityLow Severity = "Low"
	// SeverityMedium ...
	SeverityMedium Severity = "Medium"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityHigh, SeverityLow, SeverityMedium}
}

// SolutionStatus enumerates the values for solution status.
type SolutionStatus string

const (
	// SolutionStatusDisabled ...
	SolutionStatusDisabled SolutionStatus = "Disabled"
	// SolutionStatusEnabled ...
	SolutionStatusEnabled SolutionStatus = "Enabled"
)

// PossibleSolutionStatusValues returns an array of possible values for the SolutionStatus const type.
func PossibleSolutionStatusValues() []SolutionStatus {
	return []SolutionStatus{SolutionStatusDisabled, SolutionStatusEnabled}
}

// Source enumerates the values for source.
type Source string

const (
	// SourceAzure ...
	SourceAzure Source = "Azure"
	// SourceOnPremise ...
	SourceOnPremise Source = "OnPremise"
	// SourceOnPremiseSQL ...
	SourceOnPremiseSQL Source = "OnPremiseSql"
	// SourceResourceDetails ...
	SourceResourceDetails Source = "ResourceDetails"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{SourceAzure, SourceOnPremise, SourceOnPremiseSQL, SourceResourceDetails}
}

// SourceSystem enumerates the values for source system.
type SourceSystem string

const (
	// SourceSystemAzureAppLocker ...
	SourceSystemAzureAppLocker SourceSystem = "Azure_AppLocker"
	// SourceSystemAzureAuditD ...
	SourceSystemAzureAuditD SourceSystem = "Azure_AuditD"
	// SourceSystemNonAzureAppLocker ...
	SourceSystemNonAzureAppLocker SourceSystem = "NonAzure_AppLocker"
	// SourceSystemNonAzureAuditD ...
	SourceSystemNonAzureAuditD SourceSystem = "NonAzure_AuditD"
	// SourceSystemNone ...
	SourceSystemNone SourceSystem = "None"
)

// PossibleSourceSystemValues returns an array of possible values for the SourceSystem const type.
func PossibleSourceSystemValues() []SourceSystem {
	return []SourceSystem{SourceSystemAzureAppLocker, SourceSystemAzureAuditD, SourceSystemNonAzureAppLocker, SourceSystemNonAzureAuditD, SourceSystemNone}
}

// State enumerates the values for state.
type State string

const (
	// StateFailed At least one supported regulatory compliance control in the given standard has a state of
	// failed
	StateFailed State = "Failed"
	// StatePassed All supported regulatory compliance controls in the given standard have a passed state
	StatePassed State = "Passed"
	// StateSkipped All supported regulatory compliance controls in the given standard have a state of skipped
	StateSkipped State = "Skipped"
	// StateUnsupported No supported regulatory compliance data for the given standard
	StateUnsupported State = "Unsupported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateFailed, StatePassed, StateSkipped, StateUnsupported}
}

// Status enumerates the values for status.
type Status string

const (
	// Initiated ...
	Initiated Status = "Initiated"
	// Revoked ...
	Revoked Status = "Revoked"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Initiated, Revoked}
}

// StatusReason enumerates the values for status reason.
type StatusReason string

const (
	// StatusReasonExpired ...
	StatusReasonExpired StatusReason = "Expired"
	// StatusReasonNewerRequestInitiated ...
	StatusReasonNewerRequestInitiated StatusReason = "NewerRequestInitiated"
	// StatusReasonUserRequested ...
	StatusReasonUserRequested StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns an array of possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{StatusReasonExpired, StatusReasonNewerRequestInitiated, StatusReasonUserRequested}
}

// SubAssessmentStatusCode enumerates the values for sub assessment status code.
type SubAssessmentStatusCode string

const (
	// SubAssessmentStatusCodeHealthy The resource is healthy
	SubAssessmentStatusCodeHealthy SubAssessmentStatusCode = "Healthy"
	// SubAssessmentStatusCodeNotApplicable Assessment for this resource did not happen
	SubAssessmentStatusCodeNotApplicable SubAssessmentStatusCode = "NotApplicable"
	// SubAssessmentStatusCodeUnhealthy The resource has a security issue that needs to be addressed
	SubAssessmentStatusCodeUnhealthy SubAssessmentStatusCode = "Unhealthy"
)

// PossibleSubAssessmentStatusCodeValues returns an array of possible values for the SubAssessmentStatusCode const type.
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return []SubAssessmentStatusCode{SubAssessmentStatusCodeHealthy, SubAssessmentStatusCodeNotApplicable, SubAssessmentStatusCodeUnhealthy}
}

// Threats enumerates the values for threats.
type Threats string

const (
	// AccountBreach ...
	AccountBreach Threats = "accountBreach"
	// DataExfiltration ...
	DataExfiltration Threats = "dataExfiltration"
	// DataSpillage ...
	DataSpillage Threats = "dataSpillage"
	// DenialOfService ...
	DenialOfService Threats = "denialOfService"
	// ElevationOfPrivilege ...
	ElevationOfPrivilege Threats = "elevationOfPrivilege"
	// MaliciousInsider ...
	MaliciousInsider Threats = "maliciousInsider"
	// MissingCoverage ...
	MissingCoverage Threats = "missingCoverage"
	// ThreatResistance ...
	ThreatResistance Threats = "threatResistance"
)

// PossibleThreatsValues returns an array of possible values for the Threats const type.
func PossibleThreatsValues() []Threats {
	return []Threats{AccountBreach, DataExfiltration, DataSpillage, DenialOfService, ElevationOfPrivilege, MaliciousInsider, MissingCoverage, ThreatResistance}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "TCP"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "UDP"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// Type enumerates the values for type.
type Type string

const (
	// BinarySignature ...
	BinarySignature Type = "BinarySignature"
	// File ...
	File Type = "File"
	// FileHash ...
	FileHash Type = "FileHash"
	// ProductSignature ...
	ProductSignature Type = "ProductSignature"
	// PublisherSignature ...
	PublisherSignature Type = "PublisherSignature"
	// VersionAndAboveSignature ...
	VersionAndAboveSignature Type = "VersionAndAboveSignature"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{BinarySignature, File, FileHash, ProductSignature, PublisherSignature, VersionAndAboveSignature}
}

// UnmaskedIPLoggingStatus enumerates the values for unmasked ip logging status.
type UnmaskedIPLoggingStatus string

const (
	// UnmaskedIPLoggingStatusDisabled Unmasked IP logging is disabled
	UnmaskedIPLoggingStatusDisabled UnmaskedIPLoggingStatus = "Disabled"
	// UnmaskedIPLoggingStatusEnabled Unmasked IP logging is enabled
	UnmaskedIPLoggingStatusEnabled UnmaskedIPLoggingStatus = "Enabled"
)

// PossibleUnmaskedIPLoggingStatusValues returns an array of possible values for the UnmaskedIPLoggingStatus const type.
func PossibleUnmaskedIPLoggingStatusValues() []UnmaskedIPLoggingStatus {
	return []UnmaskedIPLoggingStatus{UnmaskedIPLoggingStatusDisabled, UnmaskedIPLoggingStatusEnabled}
}

// UserImpact enumerates the values for user impact.
type UserImpact string

const (
	// UserImpactHigh ...
	UserImpactHigh UserImpact = "High"
	// UserImpactLow ...
	UserImpactLow UserImpact = "Low"
	// UserImpactModerate ...
	UserImpactModerate UserImpact = "Moderate"
)

// PossibleUserImpactValues returns an array of possible values for the UserImpact const type.
func PossibleUserImpactValues() []UserImpact {
	return []UserImpact{UserImpactHigh, UserImpactLow, UserImpactModerate}
}

// ValueType enumerates the values for value type.
type ValueType string

const (
	// ValueTypeIPCidr An IP range in CIDR format (e.g. '192.168.0.1/8').
	ValueTypeIPCidr ValueType = "IpCidr"
	// ValueTypeString Any string value.
	ValueTypeString ValueType = "String"
)

// PossibleValueTypeValues returns an array of possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{ValueTypeIPCidr, ValueTypeString}
}
