package costmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertCategory enumerates the values for alert category.
type AlertCategory string

const (
	// Billing ...
	Billing AlertCategory = "Billing"
	// Cost ...
	Cost AlertCategory = "Cost"
	// Usage ...
	Usage AlertCategory = "Usage"
)

// PossibleAlertCategoryValues returns an array of possible values for the AlertCategory const type.
func PossibleAlertCategoryValues() []AlertCategory {
	return []AlertCategory{Billing, Cost, Usage}
}

// AlertCriteria enumerates the values for alert criteria.
type AlertCriteria string

const (
	// CostThresholdExceeded ...
	CostThresholdExceeded AlertCriteria = "CostThresholdExceeded"
	// CreditThresholdReached ...
	CreditThresholdReached AlertCriteria = "CreditThresholdReached"
	// UsageThresholdExceeded ...
	UsageThresholdExceeded AlertCriteria = "UsageThresholdExceeded"
)

// PossibleAlertCriteriaValues returns an array of possible values for the AlertCriteria const type.
func PossibleAlertCriteriaValues() []AlertCriteria {
	return []AlertCriteria{CostThresholdExceeded, CreditThresholdReached, UsageThresholdExceeded}
}

// AlertSource enumerates the values for alert source.
type AlertSource string

const (
	// Preset ...
	Preset AlertSource = "Preset"
	// User ...
	User AlertSource = "User"
)

// PossibleAlertSourceValues returns an array of possible values for the AlertSource const type.
func PossibleAlertSourceValues() []AlertSource {
	return []AlertSource{Preset, User}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active ...
	Active AlertStatus = "Active"
	// Dismissed ...
	Dismissed AlertStatus = "Dismissed"
	// Overridden ...
	Overridden AlertStatus = "Overridden"
	// Resolved ...
	Resolved AlertStatus = "Resolved"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{Active, Dismissed, Overridden, Resolved}
}

// AlertType enumerates the values for alert type.
type AlertType string

const (
	// Budget ...
	Budget AlertType = "Budget"
	// Credit ...
	Credit AlertType = "Credit"
	// Invoice ...
	Invoice AlertType = "Invoice"
)

// PossibleAlertTypeValues returns an array of possible values for the AlertType const type.
func PossibleAlertTypeValues() []AlertType {
	return []AlertType{Budget, Credit, Invoice}
}

// ConnectorStatus enumerates the values for connector status.
type ConnectorStatus string

const (
	// ConnectorStatusActive ...
	ConnectorStatusActive ConnectorStatus = "active"
	// ConnectorStatusError ...
	ConnectorStatusError ConnectorStatus = "error"
	// ConnectorStatusSuspended ...
	ConnectorStatusSuspended ConnectorStatus = "suspended"
)

// PossibleConnectorStatusValues returns an array of possible values for the ConnectorStatus const type.
func PossibleConnectorStatusValues() []ConnectorStatus {
	return []ConnectorStatus{ConnectorStatusActive, ConnectorStatusError, ConnectorStatusSuspended}
}

// ExecutionStatus enumerates the values for execution status.
type ExecutionStatus string

const (
	// Completed ...
	Completed ExecutionStatus = "Completed"
	// DataNotAvailable ...
	DataNotAvailable ExecutionStatus = "DataNotAvailable"
	// Failed ...
	Failed ExecutionStatus = "Failed"
	// InProgress ...
	InProgress ExecutionStatus = "InProgress"
	// NewDataNotAvailable ...
	NewDataNotAvailable ExecutionStatus = "NewDataNotAvailable"
	// Queued ...
	Queued ExecutionStatus = "Queued"
	// Timeout ...
	Timeout ExecutionStatus = "Timeout"
)

// PossibleExecutionStatusValues returns an array of possible values for the ExecutionStatus const type.
func PossibleExecutionStatusValues() []ExecutionStatus {
	return []ExecutionStatus{Completed, DataNotAvailable, Failed, InProgress, NewDataNotAvailable, Queued, Timeout}
}

// ExecutionType enumerates the values for execution type.
type ExecutionType string

const (
	// OnDemand ...
	OnDemand ExecutionType = "OnDemand"
	// Scheduled ...
	Scheduled ExecutionType = "Scheduled"
)

// PossibleExecutionTypeValues returns an array of possible values for the ExecutionType const type.
func PossibleExecutionTypeValues() []ExecutionType {
	return []ExecutionType{OnDemand, Scheduled}
}

// FormatType enumerates the values for format type.
type FormatType string

const (
	// Csv ...
	Csv FormatType = "Csv"
)

// PossibleFormatTypeValues returns an array of possible values for the FormatType const type.
func PossibleFormatTypeValues() []FormatType {
	return []FormatType{Csv}
}

// GranularityType enumerates the values for granularity type.
type GranularityType string

const (
	// Daily ...
	Daily GranularityType = "Daily"
	// Hourly ...
	Hourly GranularityType = "Hourly"
)

// PossibleGranularityTypeValues returns an array of possible values for the GranularityType const type.
func PossibleGranularityTypeValues() []GranularityType {
	return []GranularityType{Daily, Hourly}
}

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// RecurrenceTypeAnnually ...
	RecurrenceTypeAnnually RecurrenceType = "Annually"
	// RecurrenceTypeDaily ...
	RecurrenceTypeDaily RecurrenceType = "Daily"
	// RecurrenceTypeMonthly ...
	RecurrenceTypeMonthly RecurrenceType = "Monthly"
	// RecurrenceTypeWeekly ...
	RecurrenceTypeWeekly RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns an array of possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{RecurrenceTypeAnnually, RecurrenceTypeDaily, RecurrenceTypeMonthly, RecurrenceTypeWeekly}
}

// ReportColumnType enumerates the values for report column type.
type ReportColumnType string

const (
	// ReportColumnTypeDimension ...
	ReportColumnTypeDimension ReportColumnType = "Dimension"
	// ReportColumnTypeTag ...
	ReportColumnTypeTag ReportColumnType = "Tag"
)

// PossibleReportColumnTypeValues returns an array of possible values for the ReportColumnType const type.
func PossibleReportColumnTypeValues() []ReportColumnType {
	return []ReportColumnType{ReportColumnTypeDimension, ReportColumnTypeTag}
}

// StatusType enumerates the values for status type.
type StatusType string

const (
	// StatusTypeActive ...
	StatusTypeActive StatusType = "Active"
	// StatusTypeInactive ...
	StatusTypeInactive StatusType = "Inactive"
)

// PossibleStatusTypeValues returns an array of possible values for the StatusType const type.
func PossibleStatusTypeValues() []StatusType {
	return []StatusType{StatusTypeActive, StatusTypeInactive}
}

// TimeframeType enumerates the values for timeframe type.
type TimeframeType string

const (
	// Custom ...
	Custom TimeframeType = "Custom"
	// MonthToDate ...
	MonthToDate TimeframeType = "MonthToDate"
	// WeekToDate ...
	WeekToDate TimeframeType = "WeekToDate"
)

// PossibleTimeframeTypeValues returns an array of possible values for the TimeframeType const type.
func PossibleTimeframeTypeValues() []TimeframeType {
	return []TimeframeType{Custom, MonthToDate, WeekToDate}
}
