package netapp

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/netapp/mgmt/2019-05-01/netapp"

// Account netApp account resource
type Account struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// AccountProperties - NetApp Account properties
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AccountList list of NetApp account resources
type AccountList struct {
	autorest.Response `json:"-"`
	// Value - Multiple NetApp accounts
	Value *[]Account `json:"value,omitempty"`
}

// AccountPatch netApp account patch resource
type AccountPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// AccountProperties - NetApp Account properties
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountPatch.
func (ap AccountPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	if ap.AccountProperties != nil {
		objectMap["properties"] = ap.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountPatch struct.
func (ap *AccountPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				ap.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AccountProperties netApp account properties
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ActiveDirectories - Active Directories
	ActiveDirectories *[]ActiveDirectory `json:"activeDirectories,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ActiveDirectories != nil {
		objectMap["activeDirectories"] = ap.ActiveDirectories
	}
	return json.Marshal(objectMap)
}

// AccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsCreateOrUpdateFuture) Result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.AccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.AccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.AccountsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsDeleteFuture) Result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.AccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.AccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ActiveDirectory active Directory
type ActiveDirectory struct {
	// ActiveDirectoryID - Id of the Active Directory
	ActiveDirectoryID *string `json:"activeDirectoryId,omitempty"`
	// Username - Username of Active Directory domain administrator
	Username *string `json:"username,omitempty"`
	// Password - Plain text password of Active Directory domain administrator
	Password *string `json:"password,omitempty"`
	// Domain - Name of the Active Directory domain
	Domain *string `json:"domain,omitempty"`
	// DNS - Comma separated list of DNS server IP addresses for the Active Directory domain
	DNS *string `json:"dns,omitempty"`
	// Status - Status of the Active Directory
	Status *string `json:"status,omitempty"`
	// SmbServerName - NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
	SmbServerName *string `json:"smbServerName,omitempty"`
	// OrganizationalUnit - The Organizational Unit (OU) within the Windows Active Directory
	OrganizationalUnit *string `json:"organizationalUnit,omitempty"`
}

// CapacityPool capacity pool resource
type CapacityPool struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// PoolProperties - Capacity pool properties
	*PoolProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityPool.
func (cp CapacityPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	if cp.PoolProperties != nil {
		objectMap["properties"] = cp.PoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityPool struct.
func (cp *CapacityPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		case "properties":
			if v != nil {
				var poolProperties PoolProperties
				err = json.Unmarshal(*v, &poolProperties)
				if err != nil {
					return err
				}
				cp.PoolProperties = &poolProperties
			}
		}
	}

	return nil
}

// CapacityPoolList list of capacity pool resources
type CapacityPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of Capacity pools
	Value *[]CapacityPool `json:"value,omitempty"`
}

// CapacityPoolPatch capacity pool patch resource
type CapacityPoolPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// PoolPatchProperties - Capacity pool properties
	*PoolPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityPoolPatch.
func (cpp CapacityPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Location != nil {
		objectMap["location"] = cpp.Location
	}
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	if cpp.PoolPatchProperties != nil {
		objectMap["properties"] = cpp.PoolPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityPoolPatch struct.
func (cpp *CapacityPoolPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cpp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var poolPatchProperties PoolPatchProperties
				err = json.Unmarshal(*v, &poolPatchProperties)
				if err != nil {
					return err
				}
				cpp.PoolPatchProperties = &poolPatchProperties
			}
		}
	}

	return nil
}

// Dimension dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// ExportPolicyRule volume Export Policy Rule
type ExportPolicyRule struct {
	// RuleIndex - Order index
	RuleIndex *int32 `json:"ruleIndex,omitempty"`
	// UnixReadOnly - Read only access
	UnixReadOnly *bool `json:"unixReadOnly,omitempty"`
	// UnixReadWrite - Read and write access
	UnixReadWrite *bool `json:"unixReadWrite,omitempty"`
	// Cifs - Allows CIFS protocol
	Cifs *bool `json:"cifs,omitempty"`
	// Nfsv3 - Allows NFSv3 protocol
	Nfsv3 *bool `json:"nfsv3,omitempty"`
	// Nfsv4 - Deprecated: Will use the NFSv4.1 protocol, please use swagger version 2019-07-01 or later
	Nfsv4 *bool `json:"nfsv4,omitempty"`
	// AllowedClients - Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
	AllowedClients *string `json:"allowedClients,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// MountTarget mount Target
type MountTarget struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// MountTargetProperties - Mount Target Properties
	*MountTargetProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MountTarget.
func (mt MountTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mt.Location != nil {
		objectMap["location"] = mt.Location
	}
	if mt.Tags != nil {
		objectMap["tags"] = mt.Tags
	}
	if mt.MountTargetProperties != nil {
		objectMap["properties"] = mt.MountTargetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MountTarget struct.
func (mt *MountTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mt.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mt.Name = &name
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mt.Tags = tags
			}
		case "properties":
			if v != nil {
				var mountTargetProperties MountTargetProperties
				err = json.Unmarshal(*v, &mountTargetProperties)
				if err != nil {
					return err
				}
				mt.MountTargetProperties = &mountTargetProperties
			}
		}
	}

	return nil
}

// MountTargetList list of Mount Targets
type MountTargetList struct {
	autorest.Response `json:"-"`
	// Value - A list of Mount targets
	Value *[]MountTarget `json:"value,omitempty"`
}

// MountTargetProperties mount target properties
type MountTargetProperties struct {
	// MountTargetID - READ-ONLY; UUID v4 used to identify the MountTarget
	MountTargetID *string `json:"mountTargetId,omitempty"`
	// FileSystemID - UUID v4 used to identify the MountTarget
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// IPAddress - READ-ONLY; The mount target's IPv4 address
	IPAddress *string `json:"ipAddress,omitempty"`
	// Subnet - The subnet
	Subnet *string `json:"subnet,omitempty"`
	// StartIP - The start of IPv4 address range to use when creating a new mount target
	StartIP *string `json:"startIp,omitempty"`
	// EndIP - The end of IPv4 address range to use when creating a new mount target
	EndIP *string `json:"endIp,omitempty"`
	// Gateway - The gateway of the IPv4 address range to use when creating a new mount target
	Gateway *string `json:"gateway,omitempty"`
	// Netmask - The netmask of the IPv4 address range to use when creating a new mount target
	Netmask *string `json:"netmask,omitempty"`
	// SmbServerFqdn - The SMB server's Fully Qualified Domain Name, FQDN
	SmbServerFqdn *string `json:"smbServerFqdn,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for MountTargetProperties.
func (mtp MountTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtp.FileSystemID != nil {
		objectMap["fileSystemId"] = mtp.FileSystemID
	}
	if mtp.Subnet != nil {
		objectMap["subnet"] = mtp.Subnet
	}
	if mtp.StartIP != nil {
		objectMap["startIp"] = mtp.StartIP
	}
	if mtp.EndIP != nil {
		objectMap["endIp"] = mtp.EndIP
	}
	if mtp.Gateway != nil {
		objectMap["gateway"] = mtp.Gateway
	}
	if mtp.Netmask != nil {
		objectMap["netmask"] = mtp.Netmask
	}
	if mtp.SmbServerFqdn != nil {
		objectMap["smbServerFqdn"] = mtp.SmbServerFqdn
	}
	return json.Marshal(objectMap)
}

// Operation microsoft.NetApp REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft NetApp.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Cloud Volume operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PoolPatchProperties patchable pool properties
type PoolPatchProperties struct {
	// Size - Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Ultra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
}

// PoolProperties pool properties
type PoolProperties struct {
	// PoolID - READ-ONLY; UUID v4 used to identify the Pool
	PoolID *string `json:"poolId,omitempty"`
	// Size - Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Ultra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PoolProperties.
func (pp PoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Size != nil {
		objectMap["size"] = pp.Size
	}
	if pp.ServiceLevel != "" {
		objectMap["serviceLevel"] = pp.ServiceLevel
	}
	return json.Marshal(objectMap)
}

// PoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoolsCreateOrUpdateFuture) Result(client PoolsClient) (cp CapacityPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.PoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.PoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cp.Response.Response, err = future.GetResult(sender); err == nil && cp.Response.Response.StatusCode != http.StatusNoContent {
		cp, err = client.CreateOrUpdateResponder(cp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.PoolsCreateOrUpdateFuture", "Result", cp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoolsDeleteFuture) Result(client PoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.PoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.PoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ResourceNameAvailability information regarding availability of a resource name.
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	// IsAvailable - <code>true</code> indicates name is valid and available. <code>false</code> indicates the name is invalid, unavailable, or both.
	IsAvailable *bool `json:"isAvailable,omitempty"`
	// Reason - <code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason InAvailabilityReasonType `json:"reason,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'MicrosoftNetAppnetAppAccounts', 'MicrosoftNetAppnetAppAccountscapacityPools', 'MicrosoftNetAppnetAppAccountscapacityPoolsvolumes', 'MicrosoftNetAppnetAppAccountscapacityPoolsvolumessnapshots'
	Type CheckNameResourceTypes `json:"type,omitempty"`
	// ResourceGroup - Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Snapshot snapshot of a Volume
type Snapshot struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// SnapshotProperties - Snapshot Properties
	*SnapshotProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		}
	}

	return nil
}

// SnapshotPatch snapshot patch
type SnapshotPatch struct {
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
}

// SnapshotProperties snapshot properties
type SnapshotProperties struct {
	// SnapshotID - READ-ONLY; UUID v4 used to identify the Snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
	// FileSystemID - UUID v4 used to identify the FileSystem
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the snapshot
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotProperties.
func (sp SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.FileSystemID != nil {
		objectMap["fileSystemId"] = sp.FileSystemID
	}
	return json.Marshal(objectMap)
}

// SnapshotsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SnapshotsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SnapshotsCreateFuture) Result(client SnapshotsClient) (s Snapshot, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.SnapshotsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.SnapshotsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.SnapshotsCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SnapshotsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SnapshotsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SnapshotsDeleteFuture) Result(client SnapshotsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.SnapshotsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.SnapshotsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SnapshotsList list of Snapshots
type SnapshotsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Snapshots
	Value *[]Snapshot `json:"value,omitempty"`
}

// Volume volume resource
type Volume struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// VolumeProperties - Volume properties
	*VolumeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.VolumeProperties != nil {
		objectMap["properties"] = vVar.VolumeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Volume struct.
func (vVar *Volume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vVar.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumeProperties VolumeProperties
				err = json.Unmarshal(*v, &volumeProperties)
				if err != nil {
					return err
				}
				vVar.VolumeProperties = &volumeProperties
			}
		}
	}

	return nil
}

// VolumeList list of volume resources
type VolumeList struct {
	autorest.Response `json:"-"`
	// Value - List of volumes
	Value *[]Volume `json:"value,omitempty"`
}

// VolumePatch volume patch resource
type VolumePatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// VolumePatchProperties - Patchable volume properties
	*VolumePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumePatch.
func (vp VolumePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Location != nil {
		objectMap["location"] = vp.Location
	}
	if vp.Tags != nil {
		objectMap["tags"] = vp.Tags
	}
	if vp.VolumePatchProperties != nil {
		objectMap["properties"] = vp.VolumePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumePatch struct.
func (vp *VolumePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vp.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumePatchProperties VolumePatchProperties
				err = json.Unmarshal(*v, &volumePatchProperties)
				if err != nil {
					return err
				}
				vp.VolumePatchProperties = &volumePatchProperties
			}
		}
	}

	return nil
}

// VolumePatchProperties patchable volume properties
type VolumePatchProperties struct {
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Ultra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
	// ExportPolicy - Set of export policy rules
	ExportPolicy *VolumePatchPropertiesExportPolicy `json:"exportPolicy,omitempty"`
}

// VolumePatchPropertiesExportPolicy set of export policy rules
type VolumePatchPropertiesExportPolicy struct {
	// Rules - Export policy rule
	Rules *[]ExportPolicyRule `json:"rules,omitempty"`
}

// VolumeProperties volume properties
type VolumeProperties struct {
	// FileSystemID - READ-ONLY; Unique FileSystem Identifier.
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// CreationToken - A unique file path for the volume. Used when creating mount targets
	CreationToken *string `json:"creationToken,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Ultra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
	// ExportPolicy - Set of export policy rules
	ExportPolicy *VolumePropertiesExportPolicy `json:"exportPolicy,omitempty"`
	// ProtocolTypes - Set of protocol types
	ProtocolTypes *[]string `json:"protocolTypes,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SnapshotID - UUID v4 used to identify the Snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
	// BaremetalTenantID - READ-ONLY; Unique Baremetal Tenant Identifier.
	BaremetalTenantID *string `json:"baremetalTenantId,omitempty"`
	// SubnetID - The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string `json:"subnetId,omitempty"`
	// MountTargets - List of mount targets
	MountTargets *[]MountTargetProperties `json:"mountTargets,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeProperties.
func (vp VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.CreationToken != nil {
		objectMap["creationToken"] = vp.CreationToken
	}
	if vp.ServiceLevel != "" {
		objectMap["serviceLevel"] = vp.ServiceLevel
	}
	if vp.UsageThreshold != nil {
		objectMap["usageThreshold"] = vp.UsageThreshold
	}
	if vp.ExportPolicy != nil {
		objectMap["exportPolicy"] = vp.ExportPolicy
	}
	if vp.ProtocolTypes != nil {
		objectMap["protocolTypes"] = vp.ProtocolTypes
	}
	if vp.SnapshotID != nil {
		objectMap["snapshotId"] = vp.SnapshotID
	}
	if vp.SubnetID != nil {
		objectMap["subnetId"] = vp.SubnetID
	}
	if vp.MountTargets != nil {
		objectMap["mountTargets"] = vp.MountTargets
	}
	return json.Marshal(objectMap)
}

// VolumePropertiesExportPolicy set of export policy rules
type VolumePropertiesExportPolicy struct {
	// Rules - Export policy rule
	Rules *[]ExportPolicyRule `json:"rules,omitempty"`
}

// VolumesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VolumesCreateOrUpdateFuture) Result(client VolumesClient) (vVar Volume, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.VolumesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.VolumesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.VolumesCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VolumesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VolumesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VolumesDeleteFuture) Result(client VolumesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.VolumesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.VolumesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
