// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// +build go1.10

package transcribestreamingservice

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"reflect"
	"testing"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/corehandlers"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/awstesting/unit"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamtest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

var _ time.Time
var _ awserr.Error

func TestStartStreamTranscription_Read(t *testing.T) {
	expectEvents, eventMsgs := mockStartStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestStartStreamTranscription_ReadClose(t *testing.T) {
	_, eventMsgs := mockStartStreamTranscriptionReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()
	select {
	case _, ok := <-resp.GetStream().Events():
		if !ok {
			t.Fatalf("expect stream not to be closed, but was")
		}
	default:
	}

	resp.GetStream().Close()
	<-resp.GetStream().Events()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func BenchmarkStartStreamTranscription_Read(b *testing.B) {
	_, eventMsgs := mockStartStreamTranscriptionReadEvents()
	var buf bytes.Buffer
	encoder := eventstream.NewEncoder(&buf)
	for _, msg := range eventMsgs {
		if err := encoder.Encode(msg); err != nil {
			b.Fatalf("failed to encode message, %v", err)
		}
	}
	stream := &loopReader{source: bytes.NewReader(buf.Bytes())}

	sess := unit.Session
	svc := New(sess, &aws.Config{
		Endpoint:               aws.String("https://example.com"),
		DisableParamValidation: aws.Bool(true),
	})
	svc.Handlers.Send.Swap(corehandlers.SendHandler.Name,
		request.NamedHandler{Name: "mockSend",
			Fn: func(r *request.Request) {
				r.HTTPResponse = &http.Response{
					Status:     "200 OK",
					StatusCode: 200,
					Header:     http.Header{},
					Body:       ioutil.NopCloser(stream),
				}
			},
		},
	)

	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		b.Fatalf("failed to create request, %v", err)
	}
	defer resp.GetStream().Close()
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		if err = resp.GetStream().Err(); err != nil {
			b.Fatalf("expect no error, got %v", err)
		}
		event := <-resp.GetStream().Events()
		if event == nil {
			b.Fatalf("expect event, got nil, %v, %d", resp.GetStream().Err(), i)
		}
	}
}

func mockStartStreamTranscriptionReadEvents() (
	[]TranscriptResultStreamEvent,
	[]eventstream.Message,
) {
	expectEvents := []TranscriptResultStreamEvent{
		&TranscriptEvent{
			Transcript: &Transcript{
				Results: []*Result{
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
					{
						Alternatives: []*Alternative{
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
							{
								Items: []*Item{
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Content:   aws.String("string value goes here"),
										EndTime:   aws.Float64(123.45),
										StartTime: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
								Transcript: aws.String("string value goes here"),
							},
						},
						EndTime:   aws.Float64(123.45),
						IsPartial: aws.Bool(true),
						ResultId:  aws.String("string value goes here"),
						StartTime: aws.Float64(123.45),
					},
				},
			},
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("TranscriptEvent"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	return expectEvents, eventMsgs
}
func TestStartStreamTranscription_ReadException(t *testing.T) {
	expectEvents := []TranscriptResultStreamEvent{
		&BadRequestException{
			Message_: aws.String("string value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventExceptionTypeHeader,
				{
					Name:  eventstreamapi.ExceptionTypeHeader,
					Value: eventstream.StringValue("BadRequestException"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.StartStreamTranscription(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	<-resp.GetStream().Events()

	err = resp.GetStream().Err()
	if err == nil {
		t.Fatalf("expect err, got none")
	}

	expectErr := &BadRequestException{
		Message_: aws.String("string value goes here"),
	}
	aerr, ok := err.(awserr.Error)
	if !ok {
		t.Errorf("expect exception, got %T, %#v", err, err)
	}
	if e, a := expectErr.Code(), aerr.Code(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}
	if e, a := expectErr.Message(), aerr.Message(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}

	if e, a := expectErr, aerr; !reflect.DeepEqual(e, a) {
		t.Errorf("expect %#v, got %#v", e, a)
	}
}

var _ awserr.Error = (*BadRequestException)(nil)
var _ awserr.Error = (*ConflictException)(nil)
var _ awserr.Error = (*InternalFailureException)(nil)
var _ awserr.Error = (*LimitExceededException)(nil)

type loopReader struct {
	source *bytes.Reader
}

func (c *loopReader) Read(p []byte) (int, error) {
	if c.source.Len() == 0 {
		c.source.Seek(0, 0)
	}

	return c.source.Read(p)
}
