// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package outpostsiface provides an interface to enable mocking the AWS Outposts service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package outpostsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/outposts"
)

// OutpostsAPI provides an interface to enable mocking the
// outposts.Outposts service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Outposts.
//    func myFunc(svc outpostsiface.OutpostsAPI) bool {
//        // Make svc.CreateOutpost request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := outposts.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockOutpostsClient struct {
//        outpostsiface.OutpostsAPI
//    }
//    func (m *mockOutpostsClient) CreateOutpost(input *outposts.CreateOutpostInput) (*outposts.CreateOutpostOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockOutpostsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OutpostsAPI interface {
	CreateOutpost(*outposts.CreateOutpostInput) (*outposts.CreateOutpostOutput, error)
	CreateOutpostWithContext(aws.Context, *outposts.CreateOutpostInput, ...request.Option) (*outposts.CreateOutpostOutput, error)
	CreateOutpostRequest(*outposts.CreateOutpostInput) (*request.Request, *outposts.CreateOutpostOutput)

	DeleteOutpost(*outposts.DeleteOutpostInput) (*outposts.DeleteOutpostOutput, error)
	DeleteOutpostWithContext(aws.Context, *outposts.DeleteOutpostInput, ...request.Option) (*outposts.DeleteOutpostOutput, error)
	DeleteOutpostRequest(*outposts.DeleteOutpostInput) (*request.Request, *outposts.DeleteOutpostOutput)

	DeleteSite(*outposts.DeleteSiteInput) (*outposts.DeleteSiteOutput, error)
	DeleteSiteWithContext(aws.Context, *outposts.DeleteSiteInput, ...request.Option) (*outposts.DeleteSiteOutput, error)
	DeleteSiteRequest(*outposts.DeleteSiteInput) (*request.Request, *outposts.DeleteSiteOutput)

	GetOutpost(*outposts.GetOutpostInput) (*outposts.GetOutpostOutput, error)
	GetOutpostWithContext(aws.Context, *outposts.GetOutpostInput, ...request.Option) (*outposts.GetOutpostOutput, error)
	GetOutpostRequest(*outposts.GetOutpostInput) (*request.Request, *outposts.GetOutpostOutput)

	GetOutpostInstanceTypes(*outposts.GetOutpostInstanceTypesInput) (*outposts.GetOutpostInstanceTypesOutput, error)
	GetOutpostInstanceTypesWithContext(aws.Context, *outposts.GetOutpostInstanceTypesInput, ...request.Option) (*outposts.GetOutpostInstanceTypesOutput, error)
	GetOutpostInstanceTypesRequest(*outposts.GetOutpostInstanceTypesInput) (*request.Request, *outposts.GetOutpostInstanceTypesOutput)

	ListOutposts(*outposts.ListOutpostsInput) (*outposts.ListOutpostsOutput, error)
	ListOutpostsWithContext(aws.Context, *outposts.ListOutpostsInput, ...request.Option) (*outposts.ListOutpostsOutput, error)
	ListOutpostsRequest(*outposts.ListOutpostsInput) (*request.Request, *outposts.ListOutpostsOutput)

	ListOutpostsPages(*outposts.ListOutpostsInput, func(*outposts.ListOutpostsOutput, bool) bool) error
	ListOutpostsPagesWithContext(aws.Context, *outposts.ListOutpostsInput, func(*outposts.ListOutpostsOutput, bool) bool, ...request.Option) error

	ListSites(*outposts.ListSitesInput) (*outposts.ListSitesOutput, error)
	ListSitesWithContext(aws.Context, *outposts.ListSitesInput, ...request.Option) (*outposts.ListSitesOutput, error)
	ListSitesRequest(*outposts.ListSitesInput) (*request.Request, *outposts.ListSitesOutput)

	ListSitesPages(*outposts.ListSitesInput, func(*outposts.ListSitesOutput, bool) bool) error
	ListSitesPagesWithContext(aws.Context, *outposts.ListSitesInput, func(*outposts.ListSitesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*outposts.ListTagsForResourceInput) (*outposts.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *outposts.ListTagsForResourceInput, ...request.Option) (*outposts.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*outposts.ListTagsForResourceInput) (*request.Request, *outposts.ListTagsForResourceOutput)

	TagResource(*outposts.TagResourceInput) (*outposts.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *outposts.TagResourceInput, ...request.Option) (*outposts.TagResourceOutput, error)
	TagResourceRequest(*outposts.TagResourceInput) (*request.Request, *outposts.TagResourceOutput)

	UntagResource(*outposts.UntagResourceInput) (*outposts.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *outposts.UntagResourceInput, ...request.Option) (*outposts.UntagResourceOutput, error)
	UntagResourceRequest(*outposts.UntagResourceInput) (*request.Request, *outposts.UntagResourceOutput)
}

var _ OutpostsAPI = (*outposts.Outposts)(nil)
