// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mq

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateBroker = "CreateBroker"

// CreateBrokerRequest generates a "aws/request.Request" representing the
// client's request for the CreateBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBroker for more information on using the CreateBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBrokerRequest method.
//    req, resp := client.CreateBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker
func (c *MQ) CreateBrokerRequest(input *CreateBrokerRequest) (req *request.Request, output *CreateBrokerResponse) {
	op := &request.Operation{
		Name:       opCreateBroker,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/brokers",
	}

	if input == nil {
		input = &CreateBrokerRequest{}
	}

	output = &CreateBrokerResponse{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBroker API operation for AmazonMQ.
//
// Creates a broker. Note: This API is asynchronous.
//
// To create a broker, you must either use the AmazonMQFullAccess IAM policy
// or include the following EC2 permissions in your IAM policy.
//
//    * ec2:CreateNetworkInterface This permission is required to allow Amazon
//    MQ to create an elastic network interface (ENI) on behalf of your account.
//
//    * ec2:CreateNetworkInterfacePermission This permission is required to
//    attach the ENI to the broker instance.
//
//    * ec2:DeleteNetworkInterface
//
//    * ec2:DeleteNetworkInterfacePermission
//
//    * ec2:DetachNetworkInterface
//
//    * ec2:DescribeInternetGateways
//
//    * ec2:DescribeNetworkInterfaces
//
//    * ec2:DescribeNetworkInterfacePermissions
//
//    * ec2:DescribeRouteTables
//
//    * ec2:DescribeSecurityGroups
//
//    * ec2:DescribeSubnets
//
//    * ec2:DescribeVpcs
//
// For more information, see Create an IAM User and Get Your AWS Credentials
// (https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-setting-up.html#create-iam-user)
// and Never Modify or Delete the Amazon MQ Elastic Network Interface (https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/connecting-to-amazon-mq.html#never-modify-delete-elastic-network-interface)
// in the Amazon MQ Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation CreateBroker for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * UnauthorizedException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker
func (c *MQ) CreateBroker(input *CreateBrokerRequest) (*CreateBrokerResponse, error) {
	req, out := c.CreateBrokerRequest(input)
	return out, req.Send()
}

// CreateBrokerWithContext is the same as CreateBroker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) CreateBrokerWithContext(ctx aws.Context, input *CreateBrokerRequest, opts ...request.Option) (*CreateBrokerResponse, error) {
	req, out := c.CreateBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguration = "CreateConfiguration"

// CreateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguration for more information on using the CreateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationRequest method.
//    req, resp := client.CreateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration
func (c *MQ) CreateConfigurationRequest(input *CreateConfigurationRequest) (req *request.Request, output *CreateConfigurationResponse) {
	op := &request.Operation{
		Name:       opCreateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &CreateConfigurationRequest{}
	}

	output = &CreateConfigurationResponse{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguration API operation for AmazonMQ.
//
// Creates a new configuration for the specified configuration name. Amazon
// MQ uses the default configuration (the engine type and version).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation CreateConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration
func (c *MQ) CreateConfiguration(input *CreateConfigurationRequest) (*CreateConfigurationResponse, error) {
	req, out := c.CreateConfigurationRequest(input)
	return out, req.Send()
}

// CreateConfigurationWithContext is the same as CreateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) CreateConfigurationWithContext(ctx aws.Context, input *CreateConfigurationRequest, opts ...request.Option) (*CreateConfigurationResponse, error) {
	req, out := c.CreateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags
func (c *MQ) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for AmazonMQ.
//
// Add a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags
func (c *MQ) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser
func (c *MQ) CreateUserRequest(input *CreateUserRequest) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/brokers/{broker-id}/users/{username}",
	}

	if input == nil {
		input = &CreateUserRequest{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateUser API operation for AmazonMQ.
//
// Creates an ActiveMQ user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser
func (c *MQ) CreateUser(input *CreateUserRequest) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) CreateUserWithContext(ctx aws.Context, input *CreateUserRequest, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBroker = "DeleteBroker"

// DeleteBrokerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBroker for more information on using the DeleteBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBrokerRequest method.
//    req, resp := client.DeleteBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker
func (c *MQ) DeleteBrokerRequest(input *DeleteBrokerInput) (req *request.Request, output *DeleteBrokerResponse) {
	op := &request.Operation{
		Name:       opDeleteBroker,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/brokers/{broker-id}",
	}

	if input == nil {
		input = &DeleteBrokerInput{}
	}

	output = &DeleteBrokerResponse{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBroker API operation for AmazonMQ.
//
// Deletes a broker. Note: This API is asynchronous.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DeleteBroker for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker
func (c *MQ) DeleteBroker(input *DeleteBrokerInput) (*DeleteBrokerResponse, error) {
	req, out := c.DeleteBrokerRequest(input)
	return out, req.Send()
}

// DeleteBrokerWithContext is the same as DeleteBroker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DeleteBrokerWithContext(ctx aws.Context, input *DeleteBrokerInput, opts ...request.Option) (*DeleteBrokerResponse, error) {
	req, out := c.DeleteBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags
func (c *MQ) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for AmazonMQ.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags
func (c *MQ) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser
func (c *MQ) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/brokers/{broker-id}/users/{username}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AmazonMQ.
//
// Deletes an ActiveMQ user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser
func (c *MQ) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBroker = "DescribeBroker"

// DescribeBrokerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBroker for more information on using the DescribeBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBrokerRequest method.
//    req, resp := client.DescribeBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker
func (c *MQ) DescribeBrokerRequest(input *DescribeBrokerInput) (req *request.Request, output *DescribeBrokerResponse) {
	op := &request.Operation{
		Name:       opDescribeBroker,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/brokers/{broker-id}",
	}

	if input == nil {
		input = &DescribeBrokerInput{}
	}

	output = &DescribeBrokerResponse{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBroker API operation for AmazonMQ.
//
// Returns information about the specified broker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeBroker for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker
func (c *MQ) DescribeBroker(input *DescribeBrokerInput) (*DescribeBrokerResponse, error) {
	req, out := c.DescribeBrokerRequest(input)
	return out, req.Send()
}

// DescribeBrokerWithContext is the same as DescribeBroker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeBrokerWithContext(ctx aws.Context, input *DescribeBrokerInput, opts ...request.Option) (*DescribeBrokerResponse, error) {
	req, out := c.DescribeBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBrokerEngineTypes = "DescribeBrokerEngineTypes"

// DescribeBrokerEngineTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBrokerEngineTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBrokerEngineTypes for more information on using the DescribeBrokerEngineTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBrokerEngineTypesRequest method.
//    req, resp := client.DescribeBrokerEngineTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes
func (c *MQ) DescribeBrokerEngineTypesRequest(input *DescribeBrokerEngineTypesInput) (req *request.Request, output *DescribeBrokerEngineTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeBrokerEngineTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/broker-engine-types",
	}

	if input == nil {
		input = &DescribeBrokerEngineTypesInput{}
	}

	output = &DescribeBrokerEngineTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBrokerEngineTypes API operation for AmazonMQ.
//
// Describe available engine types and versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeBrokerEngineTypes for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes
func (c *MQ) DescribeBrokerEngineTypes(input *DescribeBrokerEngineTypesInput) (*DescribeBrokerEngineTypesOutput, error) {
	req, out := c.DescribeBrokerEngineTypesRequest(input)
	return out, req.Send()
}

// DescribeBrokerEngineTypesWithContext is the same as DescribeBrokerEngineTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBrokerEngineTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeBrokerEngineTypesWithContext(ctx aws.Context, input *DescribeBrokerEngineTypesInput, opts ...request.Option) (*DescribeBrokerEngineTypesOutput, error) {
	req, out := c.DescribeBrokerEngineTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBrokerInstanceOptions = "DescribeBrokerInstanceOptions"

// DescribeBrokerInstanceOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBrokerInstanceOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBrokerInstanceOptions for more information on using the DescribeBrokerInstanceOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBrokerInstanceOptionsRequest method.
//    req, resp := client.DescribeBrokerInstanceOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions
func (c *MQ) DescribeBrokerInstanceOptionsRequest(input *DescribeBrokerInstanceOptionsInput) (req *request.Request, output *DescribeBrokerInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeBrokerInstanceOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/broker-instance-options",
	}

	if input == nil {
		input = &DescribeBrokerInstanceOptionsInput{}
	}

	output = &DescribeBrokerInstanceOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBrokerInstanceOptions API operation for AmazonMQ.
//
// Describe available broker instance options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeBrokerInstanceOptions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions
func (c *MQ) DescribeBrokerInstanceOptions(input *DescribeBrokerInstanceOptionsInput) (*DescribeBrokerInstanceOptionsOutput, error) {
	req, out := c.DescribeBrokerInstanceOptionsRequest(input)
	return out, req.Send()
}

// DescribeBrokerInstanceOptionsWithContext is the same as DescribeBrokerInstanceOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBrokerInstanceOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeBrokerInstanceOptionsWithContext(ctx aws.Context, input *DescribeBrokerInstanceOptionsInput, opts ...request.Option) (*DescribeBrokerInstanceOptionsOutput, error) {
	req, out := c.DescribeBrokerInstanceOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfiguration = "DescribeConfiguration"

// DescribeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfiguration for more information on using the DescribeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRequest method.
//    req, resp := client.DescribeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration
func (c *MQ) DescribeConfigurationRequest(input *DescribeConfigurationInput) (req *request.Request, output *DescribeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{configuration-id}",
	}

	if input == nil {
		input = &DescribeConfigurationInput{}
	}

	output = &DescribeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfiguration API operation for AmazonMQ.
//
// Returns information about the specified configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration
func (c *MQ) DescribeConfiguration(input *DescribeConfigurationInput) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeConfigurationWithContext is the same as DescribeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeConfigurationWithContext(ctx aws.Context, input *DescribeConfigurationInput, opts ...request.Option) (*DescribeConfigurationOutput, error) {
	req, out := c.DescribeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRevision = "DescribeConfigurationRevision"

// DescribeConfigurationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRevision for more information on using the DescribeConfigurationRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRevisionRequest method.
//    req, resp := client.DescribeConfigurationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision
func (c *MQ) DescribeConfigurationRevisionRequest(input *DescribeConfigurationRevisionInput) (req *request.Request, output *DescribeConfigurationRevisionResponse) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRevision,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{configuration-id}/revisions/{configuration-revision}",
	}

	if input == nil {
		input = &DescribeConfigurationRevisionInput{}
	}

	output = &DescribeConfigurationRevisionResponse{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRevision API operation for AmazonMQ.
//
// Returns the specified configuration revision for the specified configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeConfigurationRevision for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision
func (c *MQ) DescribeConfigurationRevision(input *DescribeConfigurationRevisionInput) (*DescribeConfigurationRevisionResponse, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRevisionWithContext is the same as DescribeConfigurationRevision with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeConfigurationRevisionWithContext(ctx aws.Context, input *DescribeConfigurationRevisionInput, opts ...request.Option) (*DescribeConfigurationRevisionResponse, error) {
	req, out := c.DescribeConfigurationRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser
func (c *MQ) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserResponse) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/brokers/{broker-id}/users/{username}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserResponse{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for AmazonMQ.
//
// Returns information about an ActiveMQ user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser
func (c *MQ) DescribeUser(input *DescribeUserInput) (*DescribeUserResponse, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserResponse, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBrokers = "ListBrokers"

// ListBrokersRequest generates a "aws/request.Request" representing the
// client's request for the ListBrokers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBrokers for more information on using the ListBrokers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBrokersRequest method.
//    req, resp := client.ListBrokersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers
func (c *MQ) ListBrokersRequest(input *ListBrokersInput) (req *request.Request, output *ListBrokersResponse) {
	op := &request.Operation{
		Name:       opListBrokers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/brokers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBrokersInput{}
	}

	output = &ListBrokersResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListBrokers API operation for AmazonMQ.
//
// Returns a list of all brokers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation ListBrokers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers
func (c *MQ) ListBrokers(input *ListBrokersInput) (*ListBrokersResponse, error) {
	req, out := c.ListBrokersRequest(input)
	return out, req.Send()
}

// ListBrokersWithContext is the same as ListBrokers with the addition of
// the ability to pass a context and additional request options.
//
// See ListBrokers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListBrokersWithContext(ctx aws.Context, input *ListBrokersInput, opts ...request.Option) (*ListBrokersResponse, error) {
	req, out := c.ListBrokersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBrokersPages iterates over the pages of a ListBrokers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBrokers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBrokers operation.
//    pageNum := 0
//    err := client.ListBrokersPages(params,
//        func(page *mq.ListBrokersResponse, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MQ) ListBrokersPages(input *ListBrokersInput, fn func(*ListBrokersResponse, bool) bool) error {
	return c.ListBrokersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBrokersPagesWithContext same as ListBrokersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListBrokersPagesWithContext(ctx aws.Context, input *ListBrokersInput, fn func(*ListBrokersResponse, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBrokersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBrokersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBrokersResponse), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfigurationRevisions = "ListConfigurationRevisions"

// ListConfigurationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationRevisions for more information on using the ListConfigurationRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationRevisionsRequest method.
//    req, resp := client.ListConfigurationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions
func (c *MQ) ListConfigurationRevisionsRequest(input *ListConfigurationRevisionsInput) (req *request.Request, output *ListConfigurationRevisionsResponse) {
	op := &request.Operation{
		Name:       opListConfigurationRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{configuration-id}/revisions",
	}

	if input == nil {
		input = &ListConfigurationRevisionsInput{}
	}

	output = &ListConfigurationRevisionsResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationRevisions API operation for AmazonMQ.
//
// Returns a list of all revisions for the specified configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation ListConfigurationRevisions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions
func (c *MQ) ListConfigurationRevisions(input *ListConfigurationRevisionsInput) (*ListConfigurationRevisionsResponse, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	return out, req.Send()
}

// ListConfigurationRevisionsWithContext is the same as ListConfigurationRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListConfigurationRevisionsWithContext(ctx aws.Context, input *ListConfigurationRevisionsInput, opts ...request.Option) (*ListConfigurationRevisionsResponse, error) {
	req, out := c.ListConfigurationRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurations for more information on using the ListConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationsRequest method.
//    req, resp := client.ListConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations
func (c *MQ) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsResponse) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	output = &ListConfigurationsResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurations API operation for AmazonMQ.
//
// Returns a list of all configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations
func (c *MQ) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsResponse, error) {
	req, out := c.ListConfigurationsRequest(input)
	return out, req.Send()
}

// ListConfigurationsWithContext is the same as ListConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListConfigurationsWithContext(ctx aws.Context, input *ListConfigurationsInput, opts ...request.Option) (*ListConfigurationsResponse, error) {
	req, out := c.ListConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags
func (c *MQ) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AmazonMQ.
//
// Lists tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags
func (c *MQ) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers
func (c *MQ) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersResponse) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/brokers/{broker-id}/users",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersResponse{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AmazonMQ.
//
// Returns a list of all ActiveMQ users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers
func (c *MQ) ListUsers(input *ListUsersInput) (*ListUsersResponse, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersResponse, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootBroker = "RebootBroker"

// RebootBrokerRequest generates a "aws/request.Request" representing the
// client's request for the RebootBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootBroker for more information on using the RebootBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootBrokerRequest method.
//    req, resp := client.RebootBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker
func (c *MQ) RebootBrokerRequest(input *RebootBrokerInput) (req *request.Request, output *RebootBrokerOutput) {
	op := &request.Operation{
		Name:       opRebootBroker,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/brokers/{broker-id}/reboot",
	}

	if input == nil {
		input = &RebootBrokerInput{}
	}

	output = &RebootBrokerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RebootBroker API operation for AmazonMQ.
//
// Reboots a broker. Note: This API is asynchronous.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation RebootBroker for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker
func (c *MQ) RebootBroker(input *RebootBrokerInput) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	return out, req.Send()
}

// RebootBrokerWithContext is the same as RebootBroker with the addition of
// the ability to pass a context and additional request options.
//
// See RebootBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) RebootBrokerWithContext(ctx aws.Context, input *RebootBrokerInput, opts ...request.Option) (*RebootBrokerOutput, error) {
	req, out := c.RebootBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBroker = "UpdateBroker"

// UpdateBrokerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBroker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBroker for more information on using the UpdateBroker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBrokerRequest method.
//    req, resp := client.UpdateBrokerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker
func (c *MQ) UpdateBrokerRequest(input *UpdateBrokerRequest) (req *request.Request, output *UpdateBrokerResponse) {
	op := &request.Operation{
		Name:       opUpdateBroker,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/brokers/{broker-id}",
	}

	if input == nil {
		input = &UpdateBrokerRequest{}
	}

	output = &UpdateBrokerResponse{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBroker API operation for AmazonMQ.
//
// Adds a pending configuration change to a broker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation UpdateBroker for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker
func (c *MQ) UpdateBroker(input *UpdateBrokerRequest) (*UpdateBrokerResponse, error) {
	req, out := c.UpdateBrokerRequest(input)
	return out, req.Send()
}

// UpdateBrokerWithContext is the same as UpdateBroker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBroker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) UpdateBrokerWithContext(ctx aws.Context, input *UpdateBrokerRequest, opts ...request.Option) (*UpdateBrokerResponse, error) {
	req, out := c.UpdateBrokerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguration = "UpdateConfiguration"

// UpdateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguration for more information on using the UpdateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigurationRequest method.
//    req, resp := client.UpdateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration
func (c *MQ) UpdateConfigurationRequest(input *UpdateConfigurationRequest) (req *request.Request, output *UpdateConfigurationResponse) {
	op := &request.Operation{
		Name:       opUpdateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/configurations/{configuration-id}",
	}

	if input == nil {
		input = &UpdateConfigurationRequest{}
	}

	output = &UpdateConfigurationResponse{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguration API operation for AmazonMQ.
//
// Updates the specified configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation UpdateConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration
func (c *MQ) UpdateConfiguration(input *UpdateConfigurationRequest) (*UpdateConfigurationResponse, error) {
	req, out := c.UpdateConfigurationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationWithContext is the same as UpdateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) UpdateConfigurationWithContext(ctx aws.Context, input *UpdateConfigurationRequest, opts ...request.Option) (*UpdateConfigurationResponse, error) {
	req, out := c.UpdateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser
func (c *MQ) UpdateUserRequest(input *UpdateUserRequest) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/brokers/{broker-id}/users/{username}",
	}

	if input == nil {
		input = &UpdateUserRequest{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUser API operation for AmazonMQ.
//
// Updates the information for an ActiveMQ user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMQ's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Returns information about an error.
//
//   * BadRequestException
//   Returns information about an error.
//
//   * InternalServerErrorException
//   Returns information about an error.
//
//   * ConflictException
//   Returns information about an error.
//
//   * ForbiddenException
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser
func (c *MQ) UpdateUser(input *UpdateUserRequest) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MQ) UpdateUserWithContext(ctx aws.Context, input *UpdateUserRequest, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Name of the availability zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// Id for the availability zone.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// Returns information about an error.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Types of broker engines.
type BrokerEngineType struct {
	_ struct{} `type:"structure"`

	// The broker's engine type.
	EngineType *string `locationName:"engineType" type:"string" enum:"EngineType"`

	// The list of engine versions.
	EngineVersions []*EngineVersion `locationName:"engineVersions" type:"list"`
}

// String returns the string representation
func (s BrokerEngineType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerEngineType) GoString() string {
	return s.String()
}

// SetEngineType sets the EngineType field's value.
func (s *BrokerEngineType) SetEngineType(v string) *BrokerEngineType {
	s.EngineType = &v
	return s
}

// SetEngineVersions sets the EngineVersions field's value.
func (s *BrokerEngineType) SetEngineVersions(v []*EngineVersion) *BrokerEngineType {
	s.EngineVersions = v
	return s
}

// Returns information about all brokers.
type BrokerInstance struct {
	_ struct{} `type:"structure"`

	// The brokers web console URL.
	ConsoleURL *string `locationName:"consoleURL" type:"string"`

	// The broker's wire-level protocol endpoints.
	Endpoints []*string `locationName:"endpoints" type:"list"`

	// The IP address of the Elastic Network Interface (ENI) attached to the broker.
	// Does not apply to RabbitMQ brokers.
	IpAddress *string `locationName:"ipAddress" type:"string"`
}

// String returns the string representation
func (s BrokerInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerInstance) GoString() string {
	return s.String()
}

// SetConsoleURL sets the ConsoleURL field's value.
func (s *BrokerInstance) SetConsoleURL(v string) *BrokerInstance {
	s.ConsoleURL = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *BrokerInstance) SetEndpoints(v []*string) *BrokerInstance {
	s.Endpoints = v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *BrokerInstance) SetIpAddress(v string) *BrokerInstance {
	s.IpAddress = &v
	return s
}

// Option for host instance type.
type BrokerInstanceOption struct {
	_ struct{} `type:"structure"`

	// The list of available az.
	AvailabilityZones []*AvailabilityZone `locationName:"availabilityZones" type:"list"`

	// The broker's engine type.
	EngineType *string `locationName:"engineType" type:"string" enum:"EngineType"`

	// The broker's instance type.
	HostInstanceType *string `locationName:"hostInstanceType" type:"string"`

	// The broker's storage type.
	StorageType *string `locationName:"storageType" type:"string" enum:"BrokerStorageType"`

	// The list of supported deployment modes.
	SupportedDeploymentModes []*string `locationName:"supportedDeploymentModes" type:"list"`

	// The list of supported engine versions.
	SupportedEngineVersions []*string `locationName:"supportedEngineVersions" type:"list"`
}

// String returns the string representation
func (s BrokerInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerInstanceOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *BrokerInstanceOption) SetAvailabilityZones(v []*AvailabilityZone) *BrokerInstanceOption {
	s.AvailabilityZones = v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *BrokerInstanceOption) SetEngineType(v string) *BrokerInstanceOption {
	s.EngineType = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *BrokerInstanceOption) SetHostInstanceType(v string) *BrokerInstanceOption {
	s.HostInstanceType = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *BrokerInstanceOption) SetStorageType(v string) *BrokerInstanceOption {
	s.StorageType = &v
	return s
}

// SetSupportedDeploymentModes sets the SupportedDeploymentModes field's value.
func (s *BrokerInstanceOption) SetSupportedDeploymentModes(v []*string) *BrokerInstanceOption {
	s.SupportedDeploymentModes = v
	return s
}

// SetSupportedEngineVersions sets the SupportedEngineVersions field's value.
func (s *BrokerInstanceOption) SetSupportedEngineVersions(v []*string) *BrokerInstanceOption {
	s.SupportedEngineVersions = v
	return s
}

// Returns information about all brokers.
type BrokerSummary struct {
	_ struct{} `type:"structure"`

	// The broker's Amazon Resource Name (ARN).
	BrokerArn *string `locationName:"brokerArn" type:"string"`

	// The unique ID that Amazon MQ generates for the broker.
	BrokerId *string `locationName:"brokerId" type:"string"`

	// The broker's name. This value is unique in your AWS account, 1-50 characters
	// long, and containing only letters, numbers, dashes, and underscores, and
	// must not contain white spaces, brackets, wildcard characters, or special
	// characters.
	BrokerName *string `locationName:"brokerName" type:"string"`

	// The broker's status.
	BrokerState *string `locationName:"brokerState" type:"string" enum:"BrokerState"`

	// The time when the broker was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	// The broker's deployment mode.
	//
	// DeploymentMode is a required field
	DeploymentMode *string `locationName:"deploymentMode" type:"string" required:"true" enum:"DeploymentMode"`

	// The type of broker engine.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The broker's instance type.
	HostInstanceType *string `locationName:"hostInstanceType" type:"string"`
}

// String returns the string representation
func (s BrokerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerSummary) GoString() string {
	return s.String()
}

// SetBrokerArn sets the BrokerArn field's value.
func (s *BrokerSummary) SetBrokerArn(v string) *BrokerSummary {
	s.BrokerArn = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *BrokerSummary) SetBrokerId(v string) *BrokerSummary {
	s.BrokerId = &v
	return s
}

// SetBrokerName sets the BrokerName field's value.
func (s *BrokerSummary) SetBrokerName(v string) *BrokerSummary {
	s.BrokerName = &v
	return s
}

// SetBrokerState sets the BrokerState field's value.
func (s *BrokerSummary) SetBrokerState(v string) *BrokerSummary {
	s.BrokerState = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *BrokerSummary) SetCreated(v time.Time) *BrokerSummary {
	s.Created = &v
	return s
}

// SetDeploymentMode sets the DeploymentMode field's value.
func (s *BrokerSummary) SetDeploymentMode(v string) *BrokerSummary {
	s.DeploymentMode = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *BrokerSummary) SetEngineType(v string) *BrokerSummary {
	s.EngineType = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *BrokerSummary) SetHostInstanceType(v string) *BrokerSummary {
	s.HostInstanceType = &v
	return s
}

// Returns information about all configurations.
type Configuration struct {
	_ struct{} `type:"structure"`

	// Required. The ARN of the configuration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Optional. The authentication strategy associated with the configuration.
	// The default is SIMPLE.
	//
	// AuthenticationStrategy is a required field
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" required:"true" enum:"AuthenticationStrategy"`

	// Required. The date and time of the configuration revision.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Required. The description of the configuration.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Required. The type of broker engine. Currently, Amazon MQ supports ACTIVEMQ
	// and RABBITMQ.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// Required. The broker engine's version. For a list of supported engine versions,
	// see, Supported engines (https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/broker-engine.html).
	//
	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`

	// Required. The unique ID that Amazon MQ generates for the configuration.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Required. The latest revision of the configuration.
	//
	// LatestRevision is a required field
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure" required:"true"`

	// Required. The name of the configuration. This value can contain only alphanumeric
	// characters, dashes, periods, underscores, and tildes (- . _ ~). This value
	// must be 1-150 characters long.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The list of all tags associated with this configuration.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Configuration) SetArn(v string) *Configuration {
	s.Arn = &v
	return s
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *Configuration) SetAuthenticationStrategy(v string) *Configuration {
	s.AuthenticationStrategy = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *Configuration) SetCreated(v time.Time) *Configuration {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Configuration) SetDescription(v string) *Configuration {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *Configuration) SetEngineType(v string) *Configuration {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *Configuration) SetEngineVersion(v string) *Configuration {
	s.EngineVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *Configuration) SetId(v string) *Configuration {
	s.Id = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *Configuration) SetLatestRevision(v *ConfigurationRevision) *Configuration {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *Configuration) SetName(v string) *Configuration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Configuration) SetTags(v map[string]*string) *Configuration {
	s.Tags = v
	return s
}

// A list of information about the configuration.
//
// Does not apply to RabbitMQ brokers.
type ConfigurationId struct {
	_ struct{} `type:"structure"`

	// Required. The unique ID that Amazon MQ generates for the configuration.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The revision number of the configuration.
	Revision *int64 `locationName:"revision" type:"integer"`
}

// String returns the string representation
func (s ConfigurationId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationId"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ConfigurationId) SetId(v string) *ConfigurationId {
	s.Id = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationId) SetRevision(v int64) *ConfigurationId {
	s.Revision = &v
	return s
}

// Returns information about the specified configuration revision.
type ConfigurationRevision struct {
	_ struct{} `type:"structure"`

	// Required. The date and time of the configuration revision.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configuration revision.
	Description *string `locationName:"description" type:"string"`

	// Required. The revision number of the configuration.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`
}

// String returns the string representation
func (s ConfigurationRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRevision) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *ConfigurationRevision) SetCreated(v time.Time) *ConfigurationRevision {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigurationRevision) SetDescription(v string) *ConfigurationRevision {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *ConfigurationRevision) SetRevision(v int64) *ConfigurationRevision {
	s.Revision = &v
	return s
}

// Broker configuration information
type Configurations struct {
	_ struct{} `type:"structure"`

	// The broker's current configuration.
	Current *ConfigurationId `locationName:"current" type:"structure"`

	// The history of configurations applied to the broker.
	History []*ConfigurationId `locationName:"history" type:"list"`

	// The broker's pending configuration.
	Pending *ConfigurationId `locationName:"pending" type:"structure"`
}

// String returns the string representation
func (s Configurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configurations) GoString() string {
	return s.String()
}

// SetCurrent sets the Current field's value.
func (s *Configurations) SetCurrent(v *ConfigurationId) *Configurations {
	s.Current = v
	return s
}

// SetHistory sets the History field's value.
func (s *Configurations) SetHistory(v []*ConfigurationId) *Configurations {
	s.History = v
	return s
}

// SetPending sets the Pending field's value.
func (s *Configurations) SetPending(v *ConfigurationId) *Configurations {
	s.Pending = v
	return s
}

// Returns information about an error.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateBrokerRequest struct {
	_ struct{} `type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	// AutoMinorVersionUpgrade is a required field
	AutoMinorVersionUpgrade *bool `locationName:"autoMinorVersionUpgrade" type:"boolean" required:"true"`

	// BrokerName is a required field
	BrokerName *string `locationName:"brokerName" type:"string" required:"true"`

	// A list of information about the configuration.
	//
	// Does not apply to RabbitMQ brokers.
	Configuration *ConfigurationId `locationName:"configuration" type:"structure"`

	CreatorRequestId *string `locationName:"creatorRequestId" type:"string" idempotencyToken:"true"`

	// The broker's deployment mode.
	//
	// DeploymentMode is a required field
	DeploymentMode *string `locationName:"deploymentMode" type:"string" required:"true" enum:"DeploymentMode"`

	// Does not apply to RabbitMQ brokers.
	//
	// Encryption options for the broker.
	EncryptionOptions *EncryptionOptions `locationName:"encryptionOptions" type:"structure"`

	// The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`

	// HostInstanceType is a required field
	HostInstanceType *string `locationName:"hostInstanceType" type:"string" required:"true"`

	// Optional. The metadata of the LDAP server used to authenticate and authorize
	// connections to the broker.
	//
	// Does not apply to RabbitMQ brokers.
	LdapServerMetadata *LdapServerMetadataInput `locationName:"ldapServerMetadata" type:"structure"`

	// The list of information about logs to be enabled for the specified broker.
	Logs *Logs `locationName:"logs" type:"structure"`

	// The scheduled time period relative to UTC during which Amazon MQ begins to
	// apply pending updates or patches to the broker.
	MaintenanceWindowStartTime *WeeklyStartTime `locationName:"maintenanceWindowStartTime" type:"structure"`

	// PubliclyAccessible is a required field
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean" required:"true"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The broker's storage type.
	//
	// EFS is not supported for RabbitMQ engine type.
	StorageType *string `locationName:"storageType" type:"string" enum:"BrokerStorageType"`

	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// Users is a required field
	Users []*User `locationName:"users" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateBrokerRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBrokerRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBrokerRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBrokerRequest"}
	if s.AutoMinorVersionUpgrade == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoMinorVersionUpgrade"))
	}
	if s.BrokerName == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerName"))
	}
	if s.DeploymentMode == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentMode"))
	}
	if s.EngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineType"))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.HostInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("HostInstanceType"))
	}
	if s.PubliclyAccessible == nil {
		invalidParams.Add(request.NewErrParamRequired("PubliclyAccessible"))
	}
	if s.Users == nil {
		invalidParams.Add(request.NewErrParamRequired("Users"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionOptions != nil {
		if err := s.EncryptionOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LdapServerMetadata != nil {
		if err := s.LdapServerMetadata.Validate(); err != nil {
			invalidParams.AddNested("LdapServerMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.MaintenanceWindowStartTime != nil {
		if err := s.MaintenanceWindowStartTime.Validate(); err != nil {
			invalidParams.AddNested("MaintenanceWindowStartTime", err.(request.ErrInvalidParams))
		}
	}
	if s.Users != nil {
		for i, v := range s.Users {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Users", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *CreateBrokerRequest) SetAuthenticationStrategy(v string) *CreateBrokerRequest {
	s.AuthenticationStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateBrokerRequest) SetAutoMinorVersionUpgrade(v bool) *CreateBrokerRequest {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBrokerName sets the BrokerName field's value.
func (s *CreateBrokerRequest) SetBrokerName(v string) *CreateBrokerRequest {
	s.BrokerName = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateBrokerRequest) SetConfiguration(v *ConfigurationId) *CreateBrokerRequest {
	s.Configuration = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateBrokerRequest) SetCreatorRequestId(v string) *CreateBrokerRequest {
	s.CreatorRequestId = &v
	return s
}

// SetDeploymentMode sets the DeploymentMode field's value.
func (s *CreateBrokerRequest) SetDeploymentMode(v string) *CreateBrokerRequest {
	s.DeploymentMode = &v
	return s
}

// SetEncryptionOptions sets the EncryptionOptions field's value.
func (s *CreateBrokerRequest) SetEncryptionOptions(v *EncryptionOptions) *CreateBrokerRequest {
	s.EncryptionOptions = v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *CreateBrokerRequest) SetEngineType(v string) *CreateBrokerRequest {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateBrokerRequest) SetEngineVersion(v string) *CreateBrokerRequest {
	s.EngineVersion = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *CreateBrokerRequest) SetHostInstanceType(v string) *CreateBrokerRequest {
	s.HostInstanceType = &v
	return s
}

// SetLdapServerMetadata sets the LdapServerMetadata field's value.
func (s *CreateBrokerRequest) SetLdapServerMetadata(v *LdapServerMetadataInput) *CreateBrokerRequest {
	s.LdapServerMetadata = v
	return s
}

// SetLogs sets the Logs field's value.
func (s *CreateBrokerRequest) SetLogs(v *Logs) *CreateBrokerRequest {
	s.Logs = v
	return s
}

// SetMaintenanceWindowStartTime sets the MaintenanceWindowStartTime field's value.
func (s *CreateBrokerRequest) SetMaintenanceWindowStartTime(v *WeeklyStartTime) *CreateBrokerRequest {
	s.MaintenanceWindowStartTime = v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateBrokerRequest) SetPubliclyAccessible(v bool) *CreateBrokerRequest {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CreateBrokerRequest) SetSecurityGroups(v []*string) *CreateBrokerRequest {
	s.SecurityGroups = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateBrokerRequest) SetStorageType(v string) *CreateBrokerRequest {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateBrokerRequest) SetSubnetIds(v []*string) *CreateBrokerRequest {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBrokerRequest) SetTags(v map[string]*string) *CreateBrokerRequest {
	s.Tags = v
	return s
}

// SetUsers sets the Users field's value.
func (s *CreateBrokerRequest) SetUsers(v []*User) *CreateBrokerRequest {
	s.Users = v
	return s
}

type CreateBrokerResponse struct {
	_ struct{} `type:"structure"`

	BrokerArn *string `locationName:"brokerArn" type:"string"`

	BrokerId *string `locationName:"brokerId" type:"string"`
}

// String returns the string representation
func (s CreateBrokerResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBrokerResponse) GoString() string {
	return s.String()
}

// SetBrokerArn sets the BrokerArn field's value.
func (s *CreateBrokerResponse) SetBrokerArn(v string) *CreateBrokerResponse {
	s.BrokerArn = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *CreateBrokerResponse) SetBrokerId(v string) *CreateBrokerResponse {
	s.BrokerId = &v
	return s
}

type CreateConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	// The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationRequest"}
	if s.EngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineType"))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *CreateConfigurationRequest) SetAuthenticationStrategy(v string) *CreateConfigurationRequest {
	s.AuthenticationStrategy = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *CreateConfigurationRequest) SetEngineType(v string) *CreateConfigurationRequest {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateConfigurationRequest) SetEngineVersion(v string) *CreateConfigurationRequest {
	s.EngineVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationRequest) SetName(v string) *CreateConfigurationRequest {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationRequest) SetTags(v map[string]*string) *CreateConfigurationRequest {
	s.Tags = v
	return s
}

type CreateConfigurationResponse struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	Id *string `locationName:"id" type:"string"`

	// Returns information about the specified configuration revision.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateConfigurationResponse) SetArn(v string) *CreateConfigurationResponse {
	s.Arn = &v
	return s
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *CreateConfigurationResponse) SetAuthenticationStrategy(v string) *CreateConfigurationResponse {
	s.AuthenticationStrategy = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *CreateConfigurationResponse) SetCreated(v time.Time) *CreateConfigurationResponse {
	s.Created = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateConfigurationResponse) SetId(v string) *CreateConfigurationResponse {
	s.Id = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *CreateConfigurationResponse) SetLatestRevision(v *ConfigurationRevision) *CreateConfigurationResponse {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigurationResponse) SetName(v string) *CreateConfigurationResponse {
	s.Name = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateTagsInput) SetResourceArn(v string) *CreateTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v map[string]*string) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

type CreateUserRequest struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	ConsoleAccess *bool `locationName:"consoleAccess" type:"boolean"`

	Groups []*string `locationName:"groups" type:"list"`

	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true"`

	// Username is a required field
	Username *string `location:"uri" locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserRequest"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *CreateUserRequest) SetBrokerId(v string) *CreateUserRequest {
	s.BrokerId = &v
	return s
}

// SetConsoleAccess sets the ConsoleAccess field's value.
func (s *CreateUserRequest) SetConsoleAccess(v bool) *CreateUserRequest {
	s.ConsoleAccess = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *CreateUserRequest) SetGroups(v []*string) *CreateUserRequest {
	s.Groups = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserRequest) SetPassword(v string) *CreateUserRequest {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserRequest) SetUsername(v string) *CreateUserRequest {
	s.Username = &v
	return s
}

type DeleteBrokerInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBrokerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBrokerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBrokerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBrokerInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *DeleteBrokerInput) SetBrokerId(v string) *DeleteBrokerInput {
	s.BrokerId = &v
	return s
}

type DeleteBrokerResponse struct {
	_ struct{} `type:"structure"`

	BrokerId *string `locationName:"brokerId" type:"string"`
}

// String returns the string representation
func (s DeleteBrokerResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBrokerResponse) GoString() string {
	return s.String()
}

// SetBrokerId sets the BrokerId field's value.
func (s *DeleteBrokerResponse) SetBrokerId(v string) *DeleteBrokerResponse {
	s.BrokerId = &v
	return s
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteTagsInput) SetResourceArn(v string) *DeleteTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	// Username is a required field
	Username *string `location:"uri" locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *DeleteUserInput) SetBrokerId(v string) *DeleteUserInput {
	s.BrokerId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DeleteUserInput) SetUsername(v string) *DeleteUserInput {
	s.Username = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeBrokerEngineTypesInput struct {
	_ struct{} `type:"structure"`

	EngineType *string `location:"querystring" locationName:"engineType" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerEngineTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerEngineTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBrokerEngineTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBrokerEngineTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineType sets the EngineType field's value.
func (s *DescribeBrokerEngineTypesInput) SetEngineType(v string) *DescribeBrokerEngineTypesInput {
	s.EngineType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBrokerEngineTypesInput) SetMaxResults(v int64) *DescribeBrokerEngineTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBrokerEngineTypesInput) SetNextToken(v string) *DescribeBrokerEngineTypesInput {
	s.NextToken = &v
	return s
}

type DescribeBrokerEngineTypesOutput struct {
	_ struct{} `type:"structure"`

	BrokerEngineTypes []*BrokerEngineType `locationName:"brokerEngineTypes" type:"list"`

	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerEngineTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerEngineTypesOutput) GoString() string {
	return s.String()
}

// SetBrokerEngineTypes sets the BrokerEngineTypes field's value.
func (s *DescribeBrokerEngineTypesOutput) SetBrokerEngineTypes(v []*BrokerEngineType) *DescribeBrokerEngineTypesOutput {
	s.BrokerEngineTypes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBrokerEngineTypesOutput) SetMaxResults(v int64) *DescribeBrokerEngineTypesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBrokerEngineTypesOutput) SetNextToken(v string) *DescribeBrokerEngineTypesOutput {
	s.NextToken = &v
	return s
}

type DescribeBrokerInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBrokerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBrokerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBrokerInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *DescribeBrokerInput) SetBrokerId(v string) *DescribeBrokerInput {
	s.BrokerId = &v
	return s
}

type DescribeBrokerInstanceOptionsInput struct {
	_ struct{} `type:"structure"`

	EngineType *string `location:"querystring" locationName:"engineType" type:"string"`

	HostInstanceType *string `location:"querystring" locationName:"hostInstanceType" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	StorageType *string `location:"querystring" locationName:"storageType" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerInstanceOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerInstanceOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBrokerInstanceOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBrokerInstanceOptionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineType sets the EngineType field's value.
func (s *DescribeBrokerInstanceOptionsInput) SetEngineType(v string) *DescribeBrokerInstanceOptionsInput {
	s.EngineType = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *DescribeBrokerInstanceOptionsInput) SetHostInstanceType(v string) *DescribeBrokerInstanceOptionsInput {
	s.HostInstanceType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBrokerInstanceOptionsInput) SetMaxResults(v int64) *DescribeBrokerInstanceOptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBrokerInstanceOptionsInput) SetNextToken(v string) *DescribeBrokerInstanceOptionsInput {
	s.NextToken = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DescribeBrokerInstanceOptionsInput) SetStorageType(v string) *DescribeBrokerInstanceOptionsInput {
	s.StorageType = &v
	return s
}

type DescribeBrokerInstanceOptionsOutput struct {
	_ struct{} `type:"structure"`

	BrokerInstanceOptions []*BrokerInstanceOption `locationName:"brokerInstanceOptions" type:"list"`

	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeBrokerInstanceOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerInstanceOptionsOutput) GoString() string {
	return s.String()
}

// SetBrokerInstanceOptions sets the BrokerInstanceOptions field's value.
func (s *DescribeBrokerInstanceOptionsOutput) SetBrokerInstanceOptions(v []*BrokerInstanceOption) *DescribeBrokerInstanceOptionsOutput {
	s.BrokerInstanceOptions = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBrokerInstanceOptionsOutput) SetMaxResults(v int64) *DescribeBrokerInstanceOptionsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBrokerInstanceOptionsOutput) SetNextToken(v string) *DescribeBrokerInstanceOptionsOutput {
	s.NextToken = &v
	return s
}

type DescribeBrokerResponse struct {
	_ struct{} `type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	AutoMinorVersionUpgrade *bool `locationName:"autoMinorVersionUpgrade" type:"boolean"`

	BrokerArn *string `locationName:"brokerArn" type:"string"`

	BrokerId *string `locationName:"brokerId" type:"string"`

	BrokerInstances []*BrokerInstance `locationName:"brokerInstances" type:"list"`

	BrokerName *string `locationName:"brokerName" type:"string"`

	// The broker's status.
	BrokerState *string `locationName:"brokerState" type:"string" enum:"BrokerState"`

	// Broker configuration information
	Configurations *Configurations `locationName:"configurations" type:"structure"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	// The broker's deployment mode.
	DeploymentMode *string `locationName:"deploymentMode" type:"string" enum:"DeploymentMode"`

	// Does not apply to RabbitMQ brokers.
	//
	// Encryption options for the broker.
	EncryptionOptions *EncryptionOptions `locationName:"encryptionOptions" type:"structure"`

	// The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.
	EngineType *string `locationName:"engineType" type:"string" enum:"EngineType"`

	EngineVersion *string `locationName:"engineVersion" type:"string"`

	HostInstanceType *string `locationName:"hostInstanceType" type:"string"`

	// Optional. The metadata of the LDAP server used to authenticate and authorize
	// connections to the broker.
	LdapServerMetadata *LdapServerMetadataOutput `locationName:"ldapServerMetadata" type:"structure"`

	// The list of information about logs currently enabled and pending to be deployed
	// for the specified broker.
	Logs *LogsSummary `locationName:"logs" type:"structure"`

	// The scheduled time period relative to UTC during which Amazon MQ begins to
	// apply pending updates or patches to the broker.
	MaintenanceWindowStartTime *WeeklyStartTime `locationName:"maintenanceWindowStartTime" type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	PendingAuthenticationStrategy *string `locationName:"pendingAuthenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	PendingEngineVersion *string `locationName:"pendingEngineVersion" type:"string"`

	PendingHostInstanceType *string `locationName:"pendingHostInstanceType" type:"string"`

	// Optional. The metadata of the LDAP server used to authenticate and authorize
	// connections to the broker.
	PendingLdapServerMetadata *LdapServerMetadataOutput `locationName:"pendingLdapServerMetadata" type:"structure"`

	PendingSecurityGroups []*string `locationName:"pendingSecurityGroups" type:"list"`

	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// The broker's storage type.
	//
	// EFS is not supported for RabbitMQ engine type.
	StorageType *string `locationName:"storageType" type:"string" enum:"BrokerStorageType"`

	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	Users []*UserSummary `locationName:"users" type:"list"`
}

// String returns the string representation
func (s DescribeBrokerResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBrokerResponse) GoString() string {
	return s.String()
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *DescribeBrokerResponse) SetAuthenticationStrategy(v string) *DescribeBrokerResponse {
	s.AuthenticationStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *DescribeBrokerResponse) SetAutoMinorVersionUpgrade(v bool) *DescribeBrokerResponse {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBrokerArn sets the BrokerArn field's value.
func (s *DescribeBrokerResponse) SetBrokerArn(v string) *DescribeBrokerResponse {
	s.BrokerArn = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *DescribeBrokerResponse) SetBrokerId(v string) *DescribeBrokerResponse {
	s.BrokerId = &v
	return s
}

// SetBrokerInstances sets the BrokerInstances field's value.
func (s *DescribeBrokerResponse) SetBrokerInstances(v []*BrokerInstance) *DescribeBrokerResponse {
	s.BrokerInstances = v
	return s
}

// SetBrokerName sets the BrokerName field's value.
func (s *DescribeBrokerResponse) SetBrokerName(v string) *DescribeBrokerResponse {
	s.BrokerName = &v
	return s
}

// SetBrokerState sets the BrokerState field's value.
func (s *DescribeBrokerResponse) SetBrokerState(v string) *DescribeBrokerResponse {
	s.BrokerState = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *DescribeBrokerResponse) SetConfigurations(v *Configurations) *DescribeBrokerResponse {
	s.Configurations = v
	return s
}

// SetCreated sets the Created field's value.
func (s *DescribeBrokerResponse) SetCreated(v time.Time) *DescribeBrokerResponse {
	s.Created = &v
	return s
}

// SetDeploymentMode sets the DeploymentMode field's value.
func (s *DescribeBrokerResponse) SetDeploymentMode(v string) *DescribeBrokerResponse {
	s.DeploymentMode = &v
	return s
}

// SetEncryptionOptions sets the EncryptionOptions field's value.
func (s *DescribeBrokerResponse) SetEncryptionOptions(v *EncryptionOptions) *DescribeBrokerResponse {
	s.EncryptionOptions = v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *DescribeBrokerResponse) SetEngineType(v string) *DescribeBrokerResponse {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeBrokerResponse) SetEngineVersion(v string) *DescribeBrokerResponse {
	s.EngineVersion = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *DescribeBrokerResponse) SetHostInstanceType(v string) *DescribeBrokerResponse {
	s.HostInstanceType = &v
	return s
}

// SetLdapServerMetadata sets the LdapServerMetadata field's value.
func (s *DescribeBrokerResponse) SetLdapServerMetadata(v *LdapServerMetadataOutput) *DescribeBrokerResponse {
	s.LdapServerMetadata = v
	return s
}

// SetLogs sets the Logs field's value.
func (s *DescribeBrokerResponse) SetLogs(v *LogsSummary) *DescribeBrokerResponse {
	s.Logs = v
	return s
}

// SetMaintenanceWindowStartTime sets the MaintenanceWindowStartTime field's value.
func (s *DescribeBrokerResponse) SetMaintenanceWindowStartTime(v *WeeklyStartTime) *DescribeBrokerResponse {
	s.MaintenanceWindowStartTime = v
	return s
}

// SetPendingAuthenticationStrategy sets the PendingAuthenticationStrategy field's value.
func (s *DescribeBrokerResponse) SetPendingAuthenticationStrategy(v string) *DescribeBrokerResponse {
	s.PendingAuthenticationStrategy = &v
	return s
}

// SetPendingEngineVersion sets the PendingEngineVersion field's value.
func (s *DescribeBrokerResponse) SetPendingEngineVersion(v string) *DescribeBrokerResponse {
	s.PendingEngineVersion = &v
	return s
}

// SetPendingHostInstanceType sets the PendingHostInstanceType field's value.
func (s *DescribeBrokerResponse) SetPendingHostInstanceType(v string) *DescribeBrokerResponse {
	s.PendingHostInstanceType = &v
	return s
}

// SetPendingLdapServerMetadata sets the PendingLdapServerMetadata field's value.
func (s *DescribeBrokerResponse) SetPendingLdapServerMetadata(v *LdapServerMetadataOutput) *DescribeBrokerResponse {
	s.PendingLdapServerMetadata = v
	return s
}

// SetPendingSecurityGroups sets the PendingSecurityGroups field's value.
func (s *DescribeBrokerResponse) SetPendingSecurityGroups(v []*string) *DescribeBrokerResponse {
	s.PendingSecurityGroups = v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DescribeBrokerResponse) SetPubliclyAccessible(v bool) *DescribeBrokerResponse {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeBrokerResponse) SetSecurityGroups(v []*string) *DescribeBrokerResponse {
	s.SecurityGroups = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DescribeBrokerResponse) SetStorageType(v string) *DescribeBrokerResponse {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DescribeBrokerResponse) SetSubnetIds(v []*string) *DescribeBrokerResponse {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeBrokerResponse) SetTags(v map[string]*string) *DescribeBrokerResponse {
	s.Tags = v
	return s
}

// SetUsers sets the Users field's value.
func (s *DescribeBrokerResponse) SetUsers(v []*UserSummary) *DescribeBrokerResponse {
	s.Users = v
	return s
}

type DescribeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationId is a required field
	ConfigurationId *string `location:"uri" locationName:"configuration-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *DescribeConfigurationInput) SetConfigurationId(v string) *DescribeConfigurationInput {
	s.ConfigurationId = &v
	return s
}

type DescribeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	// The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.
	EngineType *string `locationName:"engineType" type:"string" enum:"EngineType"`

	EngineVersion *string `locationName:"engineVersion" type:"string"`

	Id *string `locationName:"id" type:"string"`

	// Returns information about the specified configuration revision.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeConfigurationOutput) SetArn(v string) *DescribeConfigurationOutput {
	s.Arn = &v
	return s
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *DescribeConfigurationOutput) SetAuthenticationStrategy(v string) *DescribeConfigurationOutput {
	s.AuthenticationStrategy = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *DescribeConfigurationOutput) SetCreated(v time.Time) *DescribeConfigurationOutput {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationOutput) SetDescription(v string) *DescribeConfigurationOutput {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *DescribeConfigurationOutput) SetEngineType(v string) *DescribeConfigurationOutput {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeConfigurationOutput) SetEngineVersion(v string) *DescribeConfigurationOutput {
	s.EngineVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeConfigurationOutput) SetId(v string) *DescribeConfigurationOutput {
	s.Id = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *DescribeConfigurationOutput) SetLatestRevision(v *ConfigurationRevision) *DescribeConfigurationOutput {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeConfigurationOutput) SetName(v string) *DescribeConfigurationOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeConfigurationOutput) SetTags(v map[string]*string) *DescribeConfigurationOutput {
	s.Tags = v
	return s
}

type DescribeConfigurationRevisionInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationId is a required field
	ConfigurationId *string `location:"uri" locationName:"configuration-id" type:"string" required:"true"`

	// ConfigurationRevision is a required field
	ConfigurationRevision *string `location:"uri" locationName:"configuration-revision" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationRevisionInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}
	if s.ConfigurationRevision == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRevision"))
	}
	if s.ConfigurationRevision != nil && len(*s.ConfigurationRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *DescribeConfigurationRevisionInput) SetConfigurationId(v string) *DescribeConfigurationRevisionInput {
	s.ConfigurationId = &v
	return s
}

// SetConfigurationRevision sets the ConfigurationRevision field's value.
func (s *DescribeConfigurationRevisionInput) SetConfigurationRevision(v string) *DescribeConfigurationRevisionInput {
	s.ConfigurationRevision = &v
	return s
}

type DescribeConfigurationRevisionResponse struct {
	_ struct{} `type:"structure"`

	ConfigurationId *string `locationName:"configurationId" type:"string"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	Data *string `locationName:"data" type:"string"`

	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationRevisionResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRevisionResponse) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *DescribeConfigurationRevisionResponse) SetConfigurationId(v string) *DescribeConfigurationRevisionResponse {
	s.ConfigurationId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *DescribeConfigurationRevisionResponse) SetCreated(v time.Time) *DescribeConfigurationRevisionResponse {
	s.Created = &v
	return s
}

// SetData sets the Data field's value.
func (s *DescribeConfigurationRevisionResponse) SetData(v string) *DescribeConfigurationRevisionResponse {
	s.Data = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConfigurationRevisionResponse) SetDescription(v string) *DescribeConfigurationRevisionResponse {
	s.Description = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	// Username is a required field
	Username *string `location:"uri" locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *DescribeUserInput) SetBrokerId(v string) *DescribeUserInput {
	s.BrokerId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DescribeUserInput) SetUsername(v string) *DescribeUserInput {
	s.Username = &v
	return s
}

type DescribeUserResponse struct {
	_ struct{} `type:"structure"`

	BrokerId *string `locationName:"brokerId" type:"string"`

	ConsoleAccess *bool `locationName:"consoleAccess" type:"boolean"`

	Groups []*string `locationName:"groups" type:"list"`

	// Returns information about the status of the changes pending for the ActiveMQ
	// user.
	Pending *UserPendingChanges `locationName:"pending" type:"structure"`

	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s DescribeUserResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserResponse) GoString() string {
	return s.String()
}

// SetBrokerId sets the BrokerId field's value.
func (s *DescribeUserResponse) SetBrokerId(v string) *DescribeUserResponse {
	s.BrokerId = &v
	return s
}

// SetConsoleAccess sets the ConsoleAccess field's value.
func (s *DescribeUserResponse) SetConsoleAccess(v bool) *DescribeUserResponse {
	s.ConsoleAccess = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *DescribeUserResponse) SetGroups(v []*string) *DescribeUserResponse {
	s.Groups = v
	return s
}

// SetPending sets the Pending field's value.
func (s *DescribeUserResponse) SetPending(v *UserPendingChanges) *DescribeUserResponse {
	s.Pending = v
	return s
}

// SetUsername sets the Username field's value.
func (s *DescribeUserResponse) SetUsername(v string) *DescribeUserResponse {
	s.Username = &v
	return s
}

// Does not apply to RabbitMQ brokers.
//
// Encryption options for the broker.
type EncryptionOptions struct {
	_ struct{} `type:"structure"`

	// The customer master key (CMK) to use for the AWS Key Management Service (KMS).
	// This key is used to encrypt your data at rest. If not provided, Amazon MQ
	// will use a default CMK to encrypt your data.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// Enables the use of an AWS owned CMK using AWS Key Management Service (KMS).
	// Set to true by default, if no value is provided, for example, for RabbitMQ
	// brokers.
	//
	// UseAwsOwnedKey is a required field
	UseAwsOwnedKey *bool `locationName:"useAwsOwnedKey" type:"boolean" required:"true"`
}

// String returns the string representation
func (s EncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionOptions"}
	if s.UseAwsOwnedKey == nil {
		invalidParams.Add(request.NewErrParamRequired("UseAwsOwnedKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionOptions) SetKmsKeyId(v string) *EncryptionOptions {
	s.KmsKeyId = &v
	return s
}

// SetUseAwsOwnedKey sets the UseAwsOwnedKey field's value.
func (s *EncryptionOptions) SetUseAwsOwnedKey(v bool) *EncryptionOptions {
	s.UseAwsOwnedKey = &v
	return s
}

// Id of the engine version.
type EngineVersion struct {
	_ struct{} `type:"structure"`

	// Id for the version.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s EngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineVersion) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EngineVersion) SetName(v string) *EngineVersion {
	s.Name = &v
	return s
}

// Returns information about an error.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns information about an error.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Optional. The metadata of the LDAP server used to authenticate and authorize
// connections to the broker.
//
// Does not apply to RabbitMQ brokers.
type LdapServerMetadataInput struct {
	_ struct{} `type:"structure"`

	// Specifies the location of the LDAP server such as AWS Directory Service for
	// Microsoft Active Directory . Optional failover server.
	//
	// Hosts is a required field
	Hosts []*string `locationName:"hosts" type:"list" required:"true"`

	// The distinguished name of the node in the directory information tree (DIT)
	// to search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example,
	// dc=com.
	//
	// RoleBase is a required field
	RoleBase *string `locationName:"roleBase" type:"string" required:"true"`

	// Specifies the LDAP attribute that identifies the group name attribute in
	// the object returned from the group membership query.
	RoleName *string `locationName:"roleName" type:"string"`

	// The LDAP search filter used to find roles within the roleBase. The distinguished
	// name of the user matched by userSearchMatching is substituted into the {0}
	// placeholder in the search filter. The client's username is substituted into
	// the {1} placeholder. For example, if you set this option to (member=uid={1})for
	// the user janedoe, the search filter becomes (member=uid=janedoe) after string
	// substitution. It matches all role entries that have a member attribute equal
	// to uid=janedoe under the subtree selected by the roleBase.
	//
	// RoleSearchMatching is a required field
	RoleSearchMatching *string `locationName:"roleSearchMatching" type:"string" required:"true"`

	// The directory search scope for the role. If set to true, scope is to search
	// the entire subtree.
	RoleSearchSubtree *bool `locationName:"roleSearchSubtree" type:"boolean"`

	// Service account password. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// ServiceAccountPassword is a required field
	ServiceAccountPassword *string `locationName:"serviceAccountPassword" type:"string" required:"true"`

	// Service account username. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// ServiceAccountUsername is a required field
	ServiceAccountUsername *string `locationName:"serviceAccountUsername" type:"string" required:"true"`

	// Select a particular subtree of the directory information tree (DIT) to search
	// for user entries. The subtree is specified by a DN, which specifies the base
	// node of the subtree. For example, by setting this option to ou=Users,ou=corp,
	// dc=corp, dc=example, dc=com, the search for user entries is restricted to
	// the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
	//
	// UserBase is a required field
	UserBase *string `locationName:"userBase" type:"string" required:"true"`

	// Specifies the name of the LDAP attribute for the user group membership.
	UserRoleName *string `locationName:"userRoleName" type:"string"`

	// The LDAP search filter used to find users within the userBase. The client's
	// username is substituted into the {0} placeholder in the search filter. For
	// example, if this option is set to (uid={0}) and the received username is
	// janedoe, the search filter becomes (uid=janedoe) after string substitution.
	// It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp,
	// dc=example, dc=com.
	//
	// UserSearchMatching is a required field
	UserSearchMatching *string `locationName:"userSearchMatching" type:"string" required:"true"`

	// The directory search scope for the user. If set to true, scope is to search
	// the entire subtree.
	UserSearchSubtree *bool `locationName:"userSearchSubtree" type:"boolean"`
}

// String returns the string representation
func (s LdapServerMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LdapServerMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LdapServerMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LdapServerMetadataInput"}
	if s.Hosts == nil {
		invalidParams.Add(request.NewErrParamRequired("Hosts"))
	}
	if s.RoleBase == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleBase"))
	}
	if s.RoleSearchMatching == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleSearchMatching"))
	}
	if s.ServiceAccountPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccountPassword"))
	}
	if s.ServiceAccountUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccountUsername"))
	}
	if s.UserBase == nil {
		invalidParams.Add(request.NewErrParamRequired("UserBase"))
	}
	if s.UserSearchMatching == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSearchMatching"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHosts sets the Hosts field's value.
func (s *LdapServerMetadataInput) SetHosts(v []*string) *LdapServerMetadataInput {
	s.Hosts = v
	return s
}

// SetRoleBase sets the RoleBase field's value.
func (s *LdapServerMetadataInput) SetRoleBase(v string) *LdapServerMetadataInput {
	s.RoleBase = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *LdapServerMetadataInput) SetRoleName(v string) *LdapServerMetadataInput {
	s.RoleName = &v
	return s
}

// SetRoleSearchMatching sets the RoleSearchMatching field's value.
func (s *LdapServerMetadataInput) SetRoleSearchMatching(v string) *LdapServerMetadataInput {
	s.RoleSearchMatching = &v
	return s
}

// SetRoleSearchSubtree sets the RoleSearchSubtree field's value.
func (s *LdapServerMetadataInput) SetRoleSearchSubtree(v bool) *LdapServerMetadataInput {
	s.RoleSearchSubtree = &v
	return s
}

// SetServiceAccountPassword sets the ServiceAccountPassword field's value.
func (s *LdapServerMetadataInput) SetServiceAccountPassword(v string) *LdapServerMetadataInput {
	s.ServiceAccountPassword = &v
	return s
}

// SetServiceAccountUsername sets the ServiceAccountUsername field's value.
func (s *LdapServerMetadataInput) SetServiceAccountUsername(v string) *LdapServerMetadataInput {
	s.ServiceAccountUsername = &v
	return s
}

// SetUserBase sets the UserBase field's value.
func (s *LdapServerMetadataInput) SetUserBase(v string) *LdapServerMetadataInput {
	s.UserBase = &v
	return s
}

// SetUserRoleName sets the UserRoleName field's value.
func (s *LdapServerMetadataInput) SetUserRoleName(v string) *LdapServerMetadataInput {
	s.UserRoleName = &v
	return s
}

// SetUserSearchMatching sets the UserSearchMatching field's value.
func (s *LdapServerMetadataInput) SetUserSearchMatching(v string) *LdapServerMetadataInput {
	s.UserSearchMatching = &v
	return s
}

// SetUserSearchSubtree sets the UserSearchSubtree field's value.
func (s *LdapServerMetadataInput) SetUserSearchSubtree(v bool) *LdapServerMetadataInput {
	s.UserSearchSubtree = &v
	return s
}

// Optional. The metadata of the LDAP server used to authenticate and authorize
// connections to the broker.
type LdapServerMetadataOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the location of the LDAP server such as AWS Directory Service for
	// Microsoft Active Directory . Optional failover server.
	//
	// Hosts is a required field
	Hosts []*string `locationName:"hosts" type:"list" required:"true"`

	// The distinguished name of the node in the directory information tree (DIT)
	// to search for roles or groups. For example, ou=group, ou=corp, dc=corp, dc=example,
	// dc=com.
	//
	// RoleBase is a required field
	RoleBase *string `locationName:"roleBase" type:"string" required:"true"`

	// Specifies the LDAP attribute that identifies the group name attribute in
	// the object returned from the group membership query.
	RoleName *string `locationName:"roleName" type:"string"`

	// The LDAP search filter used to find roles within the roleBase. The distinguished
	// name of the user matched by userSearchMatching is substituted into the {0}
	// placeholder in the search filter. The client's username is substituted into
	// the {1} placeholder. For example, if you set this option to (member=uid={1})for
	// the user janedoe, the search filter becomes (member=uid=janedoe) after string
	// substitution. It matches all role entries that have a member attribute equal
	// to uid=janedoe under the subtree selected by the roleBase.
	//
	// RoleSearchMatching is a required field
	RoleSearchMatching *string `locationName:"roleSearchMatching" type:"string" required:"true"`

	// The directory search scope for the role. If set to true, scope is to search
	// the entire subtree.
	RoleSearchSubtree *bool `locationName:"roleSearchSubtree" type:"boolean"`

	// Service account username. A service account is an account in your LDAP server
	// that has access to initiate a connection. For example, cn=admin,dc=corp,
	// dc=example, dc=com.
	//
	// ServiceAccountUsername is a required field
	ServiceAccountUsername *string `locationName:"serviceAccountUsername" type:"string" required:"true"`

	// Select a particular subtree of the directory information tree (DIT) to search
	// for user entries. The subtree is specified by a DN, which specifies the base
	// node of the subtree. For example, by setting this option to ou=Users,ou=corp,
	// dc=corp, dc=example, dc=com, the search for user entries is restricted to
	// the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
	//
	// UserBase is a required field
	UserBase *string `locationName:"userBase" type:"string" required:"true"`

	// Specifies the name of the LDAP attribute for the user group membership.
	UserRoleName *string `locationName:"userRoleName" type:"string"`

	// The LDAP search filter used to find users within the userBase. The client's
	// username is substituted into the {0} placeholder in the search filter. For
	// example, if this option is set to (uid={0}) and the received username is
	// janedoe, the search filter becomes (uid=janedoe) after string substitution.
	// It will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp,
	// dc=example, dc=com.
	//
	// UserSearchMatching is a required field
	UserSearchMatching *string `locationName:"userSearchMatching" type:"string" required:"true"`

	// The directory search scope for the user. If set to true, scope is to search
	// the entire subtree.
	UserSearchSubtree *bool `locationName:"userSearchSubtree" type:"boolean"`
}

// String returns the string representation
func (s LdapServerMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LdapServerMetadataOutput) GoString() string {
	return s.String()
}

// SetHosts sets the Hosts field's value.
func (s *LdapServerMetadataOutput) SetHosts(v []*string) *LdapServerMetadataOutput {
	s.Hosts = v
	return s
}

// SetRoleBase sets the RoleBase field's value.
func (s *LdapServerMetadataOutput) SetRoleBase(v string) *LdapServerMetadataOutput {
	s.RoleBase = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *LdapServerMetadataOutput) SetRoleName(v string) *LdapServerMetadataOutput {
	s.RoleName = &v
	return s
}

// SetRoleSearchMatching sets the RoleSearchMatching field's value.
func (s *LdapServerMetadataOutput) SetRoleSearchMatching(v string) *LdapServerMetadataOutput {
	s.RoleSearchMatching = &v
	return s
}

// SetRoleSearchSubtree sets the RoleSearchSubtree field's value.
func (s *LdapServerMetadataOutput) SetRoleSearchSubtree(v bool) *LdapServerMetadataOutput {
	s.RoleSearchSubtree = &v
	return s
}

// SetServiceAccountUsername sets the ServiceAccountUsername field's value.
func (s *LdapServerMetadataOutput) SetServiceAccountUsername(v string) *LdapServerMetadataOutput {
	s.ServiceAccountUsername = &v
	return s
}

// SetUserBase sets the UserBase field's value.
func (s *LdapServerMetadataOutput) SetUserBase(v string) *LdapServerMetadataOutput {
	s.UserBase = &v
	return s
}

// SetUserRoleName sets the UserRoleName field's value.
func (s *LdapServerMetadataOutput) SetUserRoleName(v string) *LdapServerMetadataOutput {
	s.UserRoleName = &v
	return s
}

// SetUserSearchMatching sets the UserSearchMatching field's value.
func (s *LdapServerMetadataOutput) SetUserSearchMatching(v string) *LdapServerMetadataOutput {
	s.UserSearchMatching = &v
	return s
}

// SetUserSearchSubtree sets the UserSearchSubtree field's value.
func (s *LdapServerMetadataOutput) SetUserSearchSubtree(v bool) *LdapServerMetadataOutput {
	s.UserSearchSubtree = &v
	return s
}

type ListBrokersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBrokersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBrokersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBrokersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBrokersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBrokersInput) SetMaxResults(v int64) *ListBrokersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBrokersInput) SetNextToken(v string) *ListBrokersInput {
	s.NextToken = &v
	return s
}

type ListBrokersResponse struct {
	_ struct{} `type:"structure"`

	BrokerSummaries []*BrokerSummary `locationName:"brokerSummaries" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBrokersResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBrokersResponse) GoString() string {
	return s.String()
}

// SetBrokerSummaries sets the BrokerSummaries field's value.
func (s *ListBrokersResponse) SetBrokerSummaries(v []*BrokerSummary) *ListBrokersResponse {
	s.BrokerSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBrokersResponse) SetNextToken(v string) *ListBrokersResponse {
	s.NextToken = &v
	return s
}

type ListConfigurationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationId is a required field
	ConfigurationId *string `location:"uri" locationName:"configuration-id" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationRevisionsInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ListConfigurationRevisionsInput) SetConfigurationId(v string) *ListConfigurationRevisionsInput {
	s.ConfigurationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationRevisionsInput) SetMaxResults(v int64) *ListConfigurationRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsInput) SetNextToken(v string) *ListConfigurationRevisionsInput {
	s.NextToken = &v
	return s
}

type ListConfigurationRevisionsResponse struct {
	_ struct{} `type:"structure"`

	ConfigurationId *string `locationName:"configurationId" type:"string"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Revisions []*ConfigurationRevision `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListConfigurationRevisionsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationRevisionsResponse) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ListConfigurationRevisionsResponse) SetConfigurationId(v string) *ListConfigurationRevisionsResponse {
	s.ConfigurationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationRevisionsResponse) SetMaxResults(v int64) *ListConfigurationRevisionsResponse {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationRevisionsResponse) SetNextToken(v string) *ListConfigurationRevisionsResponse {
	s.NextToken = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *ListConfigurationRevisionsResponse) SetRevisions(v []*ConfigurationRevision) *ListConfigurationRevisionsResponse {
	s.Revisions = v
	return s
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsInput) SetMaxResults(v int64) *ListConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsInput) SetNextToken(v string) *ListConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListConfigurationsResponse struct {
	_ struct{} `type:"structure"`

	Configurations []*Configuration `locationName:"configurations" type:"list"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsResponse) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *ListConfigurationsResponse) SetConfigurations(v []*Configuration) *ListConfigurationsResponse {
	s.Configurations = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsResponse) SetMaxResults(v int64) *ListConfigurationsResponse {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsResponse) SetNextToken(v string) *ListConfigurationsResponse {
	s.NextToken = &v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsInput) SetResourceArn(v string) *ListTagsInput {
	s.ResourceArn = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v map[string]*string) *ListTagsOutput {
	s.Tags = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *ListUsersInput) SetBrokerId(v string) *ListUsersInput {
	s.BrokerId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersResponse struct {
	_ struct{} `type:"structure"`

	BrokerId *string `locationName:"brokerId" type:"string"`

	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Users []*UserSummary `locationName:"users" type:"list"`
}

// String returns the string representation
func (s ListUsersResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersResponse) GoString() string {
	return s.String()
}

// SetBrokerId sets the BrokerId field's value.
func (s *ListUsersResponse) SetBrokerId(v string) *ListUsersResponse {
	s.BrokerId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersResponse) SetMaxResults(v int64) *ListUsersResponse {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersResponse) SetNextToken(v string) *ListUsersResponse {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersResponse) SetUsers(v []*UserSummary) *ListUsersResponse {
	s.Users = v
	return s
}

// The list of information about logs to be enabled for the specified broker.
type Logs struct {
	_ struct{} `type:"structure"`

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.
	Audit *bool `locationName:"audit" type:"boolean"`

	// Enables general logging.
	General *bool `locationName:"general" type:"boolean"`
}

// String returns the string representation
func (s Logs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Logs) GoString() string {
	return s.String()
}

// SetAudit sets the Audit field's value.
func (s *Logs) SetAudit(v bool) *Logs {
	s.Audit = &v
	return s
}

// SetGeneral sets the General field's value.
func (s *Logs) SetGeneral(v bool) *Logs {
	s.General = &v
	return s
}

// The list of information about logs currently enabled and pending to be deployed
// for the specified broker.
type LogsSummary struct {
	_ struct{} `type:"structure"`

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged.
	Audit *bool `locationName:"audit" type:"boolean"`

	// The location of the CloudWatch Logs log group where audit logs are sent.
	AuditLogGroup *string `locationName:"auditLogGroup" type:"string"`

	// Enables general logging.
	//
	// General is a required field
	General *bool `locationName:"general" type:"boolean" required:"true"`

	// The location of the CloudWatch Logs log group where general logs are sent.
	//
	// GeneralLogGroup is a required field
	GeneralLogGroup *string `locationName:"generalLogGroup" type:"string" required:"true"`

	// The list of information about logs pending to be deployed for the specified
	// broker.
	Pending *PendingLogs `locationName:"pending" type:"structure"`
}

// String returns the string representation
func (s LogsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogsSummary) GoString() string {
	return s.String()
}

// SetAudit sets the Audit field's value.
func (s *LogsSummary) SetAudit(v bool) *LogsSummary {
	s.Audit = &v
	return s
}

// SetAuditLogGroup sets the AuditLogGroup field's value.
func (s *LogsSummary) SetAuditLogGroup(v string) *LogsSummary {
	s.AuditLogGroup = &v
	return s
}

// SetGeneral sets the General field's value.
func (s *LogsSummary) SetGeneral(v bool) *LogsSummary {
	s.General = &v
	return s
}

// SetGeneralLogGroup sets the GeneralLogGroup field's value.
func (s *LogsSummary) SetGeneralLogGroup(v string) *LogsSummary {
	s.GeneralLogGroup = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *LogsSummary) SetPending(v *PendingLogs) *LogsSummary {
	s.Pending = v
	return s
}

// Returns information about an error.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The list of information about logs to be enabled for the specified broker.
type PendingLogs struct {
	_ struct{} `type:"structure"`

	// Enables audit logging. Every user management action made using JMX or the
	// ActiveMQ Web Console is logged.
	Audit *bool `locationName:"audit" type:"boolean"`

	// Enables general logging.
	General *bool `locationName:"general" type:"boolean"`
}

// String returns the string representation
func (s PendingLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingLogs) GoString() string {
	return s.String()
}

// SetAudit sets the Audit field's value.
func (s *PendingLogs) SetAudit(v bool) *PendingLogs {
	s.Audit = &v
	return s
}

// SetGeneral sets the General field's value.
func (s *PendingLogs) SetGeneral(v bool) *PendingLogs {
	s.General = &v
	return s
}

type RebootBrokerInput struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootBrokerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootBrokerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootBrokerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootBrokerInput"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *RebootBrokerInput) SetBrokerId(v string) *RebootBrokerInput {
	s.BrokerId = &v
	return s
}

type RebootBrokerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RebootBrokerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootBrokerOutput) GoString() string {
	return s.String()
}

// Returns information about the XML element or attribute that was sanitized
// in the configuration.
type SanitizationWarning struct {
	_ struct{} `type:"structure"`

	// The name of the XML attribute that has been sanitized.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The name of the XML element that has been sanitized.
	ElementName *string `locationName:"elementName" type:"string"`

	// Required. The reason for which the XML elements or attributes were sanitized.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"SanitizationWarningReason"`
}

// String returns the string representation
func (s SanitizationWarning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SanitizationWarning) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SanitizationWarning) SetAttributeName(v string) *SanitizationWarning {
	s.AttributeName = &v
	return s
}

// SetElementName sets the ElementName field's value.
func (s *SanitizationWarning) SetElementName(v string) *SanitizationWarning {
	s.ElementName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *SanitizationWarning) SetReason(v string) *SanitizationWarning {
	s.Reason = &v
	return s
}

// Returns information about an error.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorAttribute *string `locationName:"errorAttribute" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateBrokerRequest struct {
	_ struct{} `type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	AutoMinorVersionUpgrade *bool `locationName:"autoMinorVersionUpgrade" type:"boolean"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	// A list of information about the configuration.
	//
	// Does not apply to RabbitMQ brokers.
	Configuration *ConfigurationId `locationName:"configuration" type:"structure"`

	EngineVersion *string `locationName:"engineVersion" type:"string"`

	HostInstanceType *string `locationName:"hostInstanceType" type:"string"`

	// Optional. The metadata of the LDAP server used to authenticate and authorize
	// connections to the broker.
	//
	// Does not apply to RabbitMQ brokers.
	LdapServerMetadata *LdapServerMetadataInput `locationName:"ldapServerMetadata" type:"structure"`

	// The list of information about logs to be enabled for the specified broker.
	Logs *Logs `locationName:"logs" type:"structure"`

	// The scheduled time period relative to UTC during which Amazon MQ begins to
	// apply pending updates or patches to the broker.
	MaintenanceWindowStartTime *WeeklyStartTime `locationName:"maintenanceWindowStartTime" type:"structure"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`
}

// String returns the string representation
func (s UpdateBrokerRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBrokerRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBrokerRequest"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.LdapServerMetadata != nil {
		if err := s.LdapServerMetadata.Validate(); err != nil {
			invalidParams.AddNested("LdapServerMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.MaintenanceWindowStartTime != nil {
		if err := s.MaintenanceWindowStartTime.Validate(); err != nil {
			invalidParams.AddNested("MaintenanceWindowStartTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *UpdateBrokerRequest) SetAuthenticationStrategy(v string) *UpdateBrokerRequest {
	s.AuthenticationStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *UpdateBrokerRequest) SetAutoMinorVersionUpgrade(v bool) *UpdateBrokerRequest {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *UpdateBrokerRequest) SetBrokerId(v string) *UpdateBrokerRequest {
	s.BrokerId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateBrokerRequest) SetConfiguration(v *ConfigurationId) *UpdateBrokerRequest {
	s.Configuration = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpdateBrokerRequest) SetEngineVersion(v string) *UpdateBrokerRequest {
	s.EngineVersion = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *UpdateBrokerRequest) SetHostInstanceType(v string) *UpdateBrokerRequest {
	s.HostInstanceType = &v
	return s
}

// SetLdapServerMetadata sets the LdapServerMetadata field's value.
func (s *UpdateBrokerRequest) SetLdapServerMetadata(v *LdapServerMetadataInput) *UpdateBrokerRequest {
	s.LdapServerMetadata = v
	return s
}

// SetLogs sets the Logs field's value.
func (s *UpdateBrokerRequest) SetLogs(v *Logs) *UpdateBrokerRequest {
	s.Logs = v
	return s
}

// SetMaintenanceWindowStartTime sets the MaintenanceWindowStartTime field's value.
func (s *UpdateBrokerRequest) SetMaintenanceWindowStartTime(v *WeeklyStartTime) *UpdateBrokerRequest {
	s.MaintenanceWindowStartTime = v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *UpdateBrokerRequest) SetSecurityGroups(v []*string) *UpdateBrokerRequest {
	s.SecurityGroups = v
	return s
}

type UpdateBrokerResponse struct {
	_ struct{} `type:"structure"`

	// Optional. The authentication strategy used to secure the broker. The default
	// is SIMPLE.
	AuthenticationStrategy *string `locationName:"authenticationStrategy" type:"string" enum:"AuthenticationStrategy"`

	AutoMinorVersionUpgrade *bool `locationName:"autoMinorVersionUpgrade" type:"boolean"`

	BrokerId *string `locationName:"brokerId" type:"string"`

	// A list of information about the configuration.
	//
	// Does not apply to RabbitMQ brokers.
	Configuration *ConfigurationId `locationName:"configuration" type:"structure"`

	EngineVersion *string `locationName:"engineVersion" type:"string"`

	HostInstanceType *string `locationName:"hostInstanceType" type:"string"`

	// Optional. The metadata of the LDAP server used to authenticate and authorize
	// connections to the broker.
	LdapServerMetadata *LdapServerMetadataOutput `locationName:"ldapServerMetadata" type:"structure"`

	// The list of information about logs to be enabled for the specified broker.
	Logs *Logs `locationName:"logs" type:"structure"`

	// The scheduled time period relative to UTC during which Amazon MQ begins to
	// apply pending updates or patches to the broker.
	MaintenanceWindowStartTime *WeeklyStartTime `locationName:"maintenanceWindowStartTime" type:"structure"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`
}

// String returns the string representation
func (s UpdateBrokerResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBrokerResponse) GoString() string {
	return s.String()
}

// SetAuthenticationStrategy sets the AuthenticationStrategy field's value.
func (s *UpdateBrokerResponse) SetAuthenticationStrategy(v string) *UpdateBrokerResponse {
	s.AuthenticationStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *UpdateBrokerResponse) SetAutoMinorVersionUpgrade(v bool) *UpdateBrokerResponse {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *UpdateBrokerResponse) SetBrokerId(v string) *UpdateBrokerResponse {
	s.BrokerId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateBrokerResponse) SetConfiguration(v *ConfigurationId) *UpdateBrokerResponse {
	s.Configuration = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpdateBrokerResponse) SetEngineVersion(v string) *UpdateBrokerResponse {
	s.EngineVersion = &v
	return s
}

// SetHostInstanceType sets the HostInstanceType field's value.
func (s *UpdateBrokerResponse) SetHostInstanceType(v string) *UpdateBrokerResponse {
	s.HostInstanceType = &v
	return s
}

// SetLdapServerMetadata sets the LdapServerMetadata field's value.
func (s *UpdateBrokerResponse) SetLdapServerMetadata(v *LdapServerMetadataOutput) *UpdateBrokerResponse {
	s.LdapServerMetadata = v
	return s
}

// SetLogs sets the Logs field's value.
func (s *UpdateBrokerResponse) SetLogs(v *Logs) *UpdateBrokerResponse {
	s.Logs = v
	return s
}

// SetMaintenanceWindowStartTime sets the MaintenanceWindowStartTime field's value.
func (s *UpdateBrokerResponse) SetMaintenanceWindowStartTime(v *WeeklyStartTime) *UpdateBrokerResponse {
	s.MaintenanceWindowStartTime = v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *UpdateBrokerResponse) SetSecurityGroups(v []*string) *UpdateBrokerResponse {
	s.SecurityGroups = v
	return s
}

type UpdateConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// ConfigurationId is a required field
	ConfigurationId *string `location:"uri" locationName:"configuration-id" type:"string" required:"true"`

	// Data is a required field
	Data *string `locationName:"data" type:"string" required:"true"`

	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s UpdateConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationRequest"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *UpdateConfigurationRequest) SetConfigurationId(v string) *UpdateConfigurationRequest {
	s.ConfigurationId = &v
	return s
}

// SetData sets the Data field's value.
func (s *UpdateConfigurationRequest) SetData(v string) *UpdateConfigurationRequest {
	s.Data = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfigurationRequest) SetDescription(v string) *UpdateConfigurationRequest {
	s.Description = &v
	return s
}

type UpdateConfigurationResponse struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	Id *string `locationName:"id" type:"string"`

	// Returns information about the specified configuration revision.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	Warnings []*SanitizationWarning `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s UpdateConfigurationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateConfigurationResponse) SetArn(v string) *UpdateConfigurationResponse {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *UpdateConfigurationResponse) SetCreated(v time.Time) *UpdateConfigurationResponse {
	s.Created = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateConfigurationResponse) SetId(v string) *UpdateConfigurationResponse {
	s.Id = &v
	return s
}

// SetLatestRevision sets the LatestRevision field's value.
func (s *UpdateConfigurationResponse) SetLatestRevision(v *ConfigurationRevision) *UpdateConfigurationResponse {
	s.LatestRevision = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfigurationResponse) SetName(v string) *UpdateConfigurationResponse {
	s.Name = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *UpdateConfigurationResponse) SetWarnings(v []*SanitizationWarning) *UpdateConfigurationResponse {
	s.Warnings = v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

type UpdateUserRequest struct {
	_ struct{} `type:"structure"`

	// BrokerId is a required field
	BrokerId *string `location:"uri" locationName:"broker-id" type:"string" required:"true"`

	ConsoleAccess *bool `locationName:"consoleAccess" type:"boolean"`

	Groups []*string `locationName:"groups" type:"list"`

	Password *string `locationName:"password" type:"string"`

	// Username is a required field
	Username *string `location:"uri" locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserRequest"}
	if s.BrokerId == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerId"))
	}
	if s.BrokerId != nil && len(*s.BrokerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BrokerId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerId sets the BrokerId field's value.
func (s *UpdateUserRequest) SetBrokerId(v string) *UpdateUserRequest {
	s.BrokerId = &v
	return s
}

// SetConsoleAccess sets the ConsoleAccess field's value.
func (s *UpdateUserRequest) SetConsoleAccess(v bool) *UpdateUserRequest {
	s.ConsoleAccess = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *UpdateUserRequest) SetGroups(v []*string) *UpdateUserRequest {
	s.Groups = v
	return s
}

// SetPassword sets the Password field's value.
func (s *UpdateUserRequest) SetPassword(v string) *UpdateUserRequest {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UpdateUserRequest) SetUsername(v string) *UpdateUserRequest {
	s.Username = &v
	return s
}

// A user associated with the broker. For RabbitMQ brokers, one and only one
// administrative user is accepted and created when a broker is first provisioned.
// All subsequent broker users are created by making RabbitMQ API calls directly
// to brokers or via the RabbitMQ web console.
type User struct {
	_ struct{} `type:"structure"`

	// Enables access to the ActiveMQ Web Console for the ActiveMQ user. Does not
	// apply to RabbitMQ brokers.
	ConsoleAccess *bool `locationName:"consoleAccess" type:"boolean"`

	// The list of groups (20 maximum) to which the ActiveMQ user belongs. This
	// value can contain only alphanumeric characters, dashes, periods, underscores,
	// and tildes (- . _ ~). This value must be 2-100 characters long. Does not
	// apply to RabbitMQ brokers.
	Groups []*string `locationName:"groups" type:"list"`

	// Required. The password of the user. This value must be at least 12 characters
	// long, must contain at least 4 unique characters, and must not contain commas,
	// colons, or equal signs (,:=).
	//
	// Password is a required field
	Password *string `locationName:"password" type:"string" required:"true"`

	// important>Amazon MQ for ActiveMQ For ActiveMQ brokers, this value can contain
	// only alphanumeric characters, dashes, periods, underscores, and tildes (-
	// . _ ~). This value must be 2-100 characters long./important> Amazon MQ for
	// RabbitMQ
	// For RabbitMQ brokers, this value can contain only alphanumeric characters,
	// dashes, periods, underscores (- . _). This value must not contain a tilde
	// (~) character. Amazon MQ prohibts using guest as a valid usename. This value
	// must be 2-100 characters long.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *User) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "User"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsoleAccess sets the ConsoleAccess field's value.
func (s *User) SetConsoleAccess(v bool) *User {
	s.ConsoleAccess = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *User) SetGroups(v []*string) *User {
	s.Groups = v
	return s
}

// SetPassword sets the Password field's value.
func (s *User) SetPassword(v string) *User {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *User) SetUsername(v string) *User {
	s.Username = &v
	return s
}

// Returns information about the status of the changes pending for the ActiveMQ
// user.
type UserPendingChanges struct {
	_ struct{} `type:"structure"`

	// Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
	ConsoleAccess *bool `locationName:"consoleAccess" type:"boolean"`

	// The list of groups (20 maximum) to which the ActiveMQ user belongs. This
	// value can contain only alphanumeric characters, dashes, periods, underscores,
	// and tildes (- . _ ~). This value must be 2-100 characters long.
	Groups []*string `locationName:"groups" type:"list"`

	// Required. The type of change pending for the ActiveMQ user.
	//
	// PendingChange is a required field
	PendingChange *string `locationName:"pendingChange" type:"string" required:"true" enum:"ChangeType"`
}

// String returns the string representation
func (s UserPendingChanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPendingChanges) GoString() string {
	return s.String()
}

// SetConsoleAccess sets the ConsoleAccess field's value.
func (s *UserPendingChanges) SetConsoleAccess(v bool) *UserPendingChanges {
	s.ConsoleAccess = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *UserPendingChanges) SetGroups(v []*string) *UserPendingChanges {
	s.Groups = v
	return s
}

// SetPendingChange sets the PendingChange field's value.
func (s *UserPendingChanges) SetPendingChange(v string) *UserPendingChanges {
	s.PendingChange = &v
	return s
}

// Returns a list of all broker users. Does not apply to RabbitMQ brokers.
type UserSummary struct {
	_ struct{} `type:"structure"`

	// The type of change pending for the broker user.
	PendingChange *string `locationName:"pendingChange" type:"string" enum:"ChangeType"`

	// Required. The username of the broker user. This value can contain only alphanumeric
	// characters, dashes, periods, underscores, and tildes (- . _ ~). This value
	// must be 2-100 characters long.
	//
	// Username is a required field
	Username *string `locationName:"username" type:"string" required:"true"`
}

// String returns the string representation
func (s UserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserSummary) GoString() string {
	return s.String()
}

// SetPendingChange sets the PendingChange field's value.
func (s *UserSummary) SetPendingChange(v string) *UserSummary {
	s.PendingChange = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UserSummary) SetUsername(v string) *UserSummary {
	s.Username = &v
	return s
}

// The scheduled time period relative to UTC during which Amazon MQ begins to
// apply pending updates or patches to the broker.
type WeeklyStartTime struct {
	_ struct{} `type:"structure"`

	// Required. The day of the week.
	//
	// DayOfWeek is a required field
	DayOfWeek *string `locationName:"dayOfWeek" type:"string" required:"true" enum:"DayOfWeek"`

	// Required. The time, in 24-hour format.
	//
	// TimeOfDay is a required field
	TimeOfDay *string `locationName:"timeOfDay" type:"string" required:"true"`

	// The time zone, UTC by default, in either the Country/City format, or the
	// UTC offset format.
	TimeZone *string `locationName:"timeZone" type:"string"`
}

// String returns the string representation
func (s WeeklyStartTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeeklyStartTime) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeeklyStartTime) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeeklyStartTime"}
	if s.DayOfWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfWeek"))
	}
	if s.TimeOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeOfDay"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *WeeklyStartTime) SetDayOfWeek(v string) *WeeklyStartTime {
	s.DayOfWeek = &v
	return s
}

// SetTimeOfDay sets the TimeOfDay field's value.
func (s *WeeklyStartTime) SetTimeOfDay(v string) *WeeklyStartTime {
	s.TimeOfDay = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *WeeklyStartTime) SetTimeZone(v string) *WeeklyStartTime {
	s.TimeZone = &v
	return s
}

// Optional. The authentication strategy used to secure the broker. The default
// is SIMPLE.
const (
	// AuthenticationStrategySimple is a AuthenticationStrategy enum value
	AuthenticationStrategySimple = "SIMPLE"

	// AuthenticationStrategyLdap is a AuthenticationStrategy enum value
	AuthenticationStrategyLdap = "LDAP"
)

// AuthenticationStrategy_Values returns all elements of the AuthenticationStrategy enum
func AuthenticationStrategy_Values() []string {
	return []string{
		AuthenticationStrategySimple,
		AuthenticationStrategyLdap,
	}
}

// The broker's status.
const (
	// BrokerStateCreationInProgress is a BrokerState enum value
	BrokerStateCreationInProgress = "CREATION_IN_PROGRESS"

	// BrokerStateCreationFailed is a BrokerState enum value
	BrokerStateCreationFailed = "CREATION_FAILED"

	// BrokerStateDeletionInProgress is a BrokerState enum value
	BrokerStateDeletionInProgress = "DELETION_IN_PROGRESS"

	// BrokerStateRunning is a BrokerState enum value
	BrokerStateRunning = "RUNNING"

	// BrokerStateRebootInProgress is a BrokerState enum value
	BrokerStateRebootInProgress = "REBOOT_IN_PROGRESS"
)

// BrokerState_Values returns all elements of the BrokerState enum
func BrokerState_Values() []string {
	return []string{
		BrokerStateCreationInProgress,
		BrokerStateCreationFailed,
		BrokerStateDeletionInProgress,
		BrokerStateRunning,
		BrokerStateRebootInProgress,
	}
}

// The broker's storage type.
//
// EFS is not supported for RabbitMQ engine type.
const (
	// BrokerStorageTypeEbs is a BrokerStorageType enum value
	BrokerStorageTypeEbs = "EBS"

	// BrokerStorageTypeEfs is a BrokerStorageType enum value
	BrokerStorageTypeEfs = "EFS"
)

// BrokerStorageType_Values returns all elements of the BrokerStorageType enum
func BrokerStorageType_Values() []string {
	return []string{
		BrokerStorageTypeEbs,
		BrokerStorageTypeEfs,
	}
}

// The type of change pending for the ActiveMQ user.
const (
	// ChangeTypeCreate is a ChangeType enum value
	ChangeTypeCreate = "CREATE"

	// ChangeTypeUpdate is a ChangeType enum value
	ChangeTypeUpdate = "UPDATE"

	// ChangeTypeDelete is a ChangeType enum value
	ChangeTypeDelete = "DELETE"
)

// ChangeType_Values returns all elements of the ChangeType enum
func ChangeType_Values() []string {
	return []string{
		ChangeTypeCreate,
		ChangeTypeUpdate,
		ChangeTypeDelete,
	}
}

const (
	// DayOfWeekMonday is a DayOfWeek enum value
	DayOfWeekMonday = "MONDAY"

	// DayOfWeekTuesday is a DayOfWeek enum value
	DayOfWeekTuesday = "TUESDAY"

	// DayOfWeekWednesday is a DayOfWeek enum value
	DayOfWeekWednesday = "WEDNESDAY"

	// DayOfWeekThursday is a DayOfWeek enum value
	DayOfWeekThursday = "THURSDAY"

	// DayOfWeekFriday is a DayOfWeek enum value
	DayOfWeekFriday = "FRIDAY"

	// DayOfWeekSaturday is a DayOfWeek enum value
	DayOfWeekSaturday = "SATURDAY"

	// DayOfWeekSunday is a DayOfWeek enum value
	DayOfWeekSunday = "SUNDAY"
)

// DayOfWeek_Values returns all elements of the DayOfWeek enum
func DayOfWeek_Values() []string {
	return []string{
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
	}
}

// The broker's deployment mode.
const (
	// DeploymentModeSingleInstance is a DeploymentMode enum value
	DeploymentModeSingleInstance = "SINGLE_INSTANCE"

	// DeploymentModeActiveStandbyMultiAz is a DeploymentMode enum value
	DeploymentModeActiveStandbyMultiAz = "ACTIVE_STANDBY_MULTI_AZ"

	// DeploymentModeClusterMultiAz is a DeploymentMode enum value
	DeploymentModeClusterMultiAz = "CLUSTER_MULTI_AZ"
)

// DeploymentMode_Values returns all elements of the DeploymentMode enum
func DeploymentMode_Values() []string {
	return []string{
		DeploymentModeSingleInstance,
		DeploymentModeActiveStandbyMultiAz,
		DeploymentModeClusterMultiAz,
	}
}

// The type of broker engine. Amazon MQ supports ActiveMQ and RabbitMQ.
const (
	// EngineTypeActivemq is a EngineType enum value
	EngineTypeActivemq = "ACTIVEMQ"

	// EngineTypeRabbitmq is a EngineType enum value
	EngineTypeRabbitmq = "RABBITMQ"
)

// EngineType_Values returns all elements of the EngineType enum
func EngineType_Values() []string {
	return []string{
		EngineTypeActivemq,
		EngineTypeRabbitmq,
	}
}

// The reason for which the XML elements or attributes were sanitized.
const (
	// SanitizationWarningReasonDisallowedElementRemoved is a SanitizationWarningReason enum value
	SanitizationWarningReasonDisallowedElementRemoved = "DISALLOWED_ELEMENT_REMOVED"

	// SanitizationWarningReasonDisallowedAttributeRemoved is a SanitizationWarningReason enum value
	SanitizationWarningReasonDisallowedAttributeRemoved = "DISALLOWED_ATTRIBUTE_REMOVED"

	// SanitizationWarningReasonInvalidAttributeValueRemoved is a SanitizationWarningReason enum value
	SanitizationWarningReasonInvalidAttributeValueRemoved = "INVALID_ATTRIBUTE_VALUE_REMOVED"
)

// SanitizationWarningReason_Values returns all elements of the SanitizationWarningReason enum
func SanitizationWarningReason_Values() []string {
	return []string{
		SanitizationWarningReasonDisallowedElementRemoved,
		SanitizationWarningReasonDisallowedAttributeRemoved,
		SanitizationWarningReasonInvalidAttributeValueRemoved,
	}
}
