// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ioteventsdata

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchAcknowledgeAlarm = "BatchAcknowledgeAlarm"

// BatchAcknowledgeAlarmRequest generates a "aws/request.Request" representing the
// client's request for the BatchAcknowledgeAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAcknowledgeAlarm for more information on using the BatchAcknowledgeAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAcknowledgeAlarmRequest method.
//    req, resp := client.BatchAcknowledgeAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm
func (c *IoTEventsData) BatchAcknowledgeAlarmRequest(input *BatchAcknowledgeAlarmInput) (req *request.Request, output *BatchAcknowledgeAlarmOutput) {
	op := &request.Operation{
		Name:       opBatchAcknowledgeAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/alarms/acknowledge",
	}

	if input == nil {
		input = &BatchAcknowledgeAlarmInput{}
	}

	output = &BatchAcknowledgeAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAcknowledgeAlarm API operation for AWS IoT Events Data.
//
// Acknowledges one or more alarms. The alarms change to the ACKNOWLEDGED state
// after you acknowledge them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchAcknowledgeAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm
func (c *IoTEventsData) BatchAcknowledgeAlarm(input *BatchAcknowledgeAlarmInput) (*BatchAcknowledgeAlarmOutput, error) {
	req, out := c.BatchAcknowledgeAlarmRequest(input)
	return out, req.Send()
}

// BatchAcknowledgeAlarmWithContext is the same as BatchAcknowledgeAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAcknowledgeAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchAcknowledgeAlarmWithContext(ctx aws.Context, input *BatchAcknowledgeAlarmInput, opts ...request.Option) (*BatchAcknowledgeAlarmOutput, error) {
	req, out := c.BatchAcknowledgeAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableAlarm = "BatchDisableAlarm"

// BatchDisableAlarmRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableAlarm for more information on using the BatchDisableAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisableAlarmRequest method.
//    req, resp := client.BatchDisableAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm
func (c *IoTEventsData) BatchDisableAlarmRequest(input *BatchDisableAlarmInput) (req *request.Request, output *BatchDisableAlarmOutput) {
	op := &request.Operation{
		Name:       opBatchDisableAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/alarms/disable",
	}

	if input == nil {
		input = &BatchDisableAlarmInput{}
	}

	output = &BatchDisableAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableAlarm API operation for AWS IoT Events Data.
//
// Disables one or more alarms. The alarms change to the DISABLED state after
// you disable them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchDisableAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm
func (c *IoTEventsData) BatchDisableAlarm(input *BatchDisableAlarmInput) (*BatchDisableAlarmOutput, error) {
	req, out := c.BatchDisableAlarmRequest(input)
	return out, req.Send()
}

// BatchDisableAlarmWithContext is the same as BatchDisableAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchDisableAlarmWithContext(ctx aws.Context, input *BatchDisableAlarmInput, opts ...request.Option) (*BatchDisableAlarmOutput, error) {
	req, out := c.BatchDisableAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableAlarm = "BatchEnableAlarm"

// BatchEnableAlarmRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableAlarm for more information on using the BatchEnableAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEnableAlarmRequest method.
//    req, resp := client.BatchEnableAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm
func (c *IoTEventsData) BatchEnableAlarmRequest(input *BatchEnableAlarmInput) (req *request.Request, output *BatchEnableAlarmOutput) {
	op := &request.Operation{
		Name:       opBatchEnableAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/alarms/enable",
	}

	if input == nil {
		input = &BatchEnableAlarmInput{}
	}

	output = &BatchEnableAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableAlarm API operation for AWS IoT Events Data.
//
// Enables one or more alarms. The alarms change to the NORMAL state after you
// enable them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchEnableAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm
func (c *IoTEventsData) BatchEnableAlarm(input *BatchEnableAlarmInput) (*BatchEnableAlarmOutput, error) {
	req, out := c.BatchEnableAlarmRequest(input)
	return out, req.Send()
}

// BatchEnableAlarmWithContext is the same as BatchEnableAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchEnableAlarmWithContext(ctx aws.Context, input *BatchEnableAlarmInput, opts ...request.Option) (*BatchEnableAlarmOutput, error) {
	req, out := c.BatchEnableAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutMessage = "BatchPutMessage"

// BatchPutMessageRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutMessage for more information on using the BatchPutMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutMessageRequest method.
//    req, resp := client.BatchPutMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage
func (c *IoTEventsData) BatchPutMessageRequest(input *BatchPutMessageInput) (req *request.Request, output *BatchPutMessageOutput) {
	op := &request.Operation{
		Name:       opBatchPutMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/inputs/messages",
	}

	if input == nil {
		input = &BatchPutMessageInput{}
	}

	output = &BatchPutMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutMessage API operation for AWS IoT Events Data.
//
// Sends a set of messages to the AWS IoT Events system. Each message payload
// is transformed into the input you specify ("inputName") and ingested into
// any detectors that monitor that input. If multiple messages are sent, the
// order in which the messages are processed isn't guaranteed. To guarantee
// ordering, you must send messages one at a time and wait for a successful
// response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchPutMessage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage
func (c *IoTEventsData) BatchPutMessage(input *BatchPutMessageInput) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	return out, req.Send()
}

// BatchPutMessageWithContext is the same as BatchPutMessage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchPutMessageWithContext(ctx aws.Context, input *BatchPutMessageInput, opts ...request.Option) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchResetAlarm = "BatchResetAlarm"

// BatchResetAlarmRequest generates a "aws/request.Request" representing the
// client's request for the BatchResetAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchResetAlarm for more information on using the BatchResetAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchResetAlarmRequest method.
//    req, resp := client.BatchResetAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm
func (c *IoTEventsData) BatchResetAlarmRequest(input *BatchResetAlarmInput) (req *request.Request, output *BatchResetAlarmOutput) {
	op := &request.Operation{
		Name:       opBatchResetAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/alarms/reset",
	}

	if input == nil {
		input = &BatchResetAlarmInput{}
	}

	output = &BatchResetAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchResetAlarm API operation for AWS IoT Events Data.
//
// Resets one or more alarms. The alarms return to the NORMAL state after you
// reset them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchResetAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm
func (c *IoTEventsData) BatchResetAlarm(input *BatchResetAlarmInput) (*BatchResetAlarmOutput, error) {
	req, out := c.BatchResetAlarmRequest(input)
	return out, req.Send()
}

// BatchResetAlarmWithContext is the same as BatchResetAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See BatchResetAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchResetAlarmWithContext(ctx aws.Context, input *BatchResetAlarmInput, opts ...request.Option) (*BatchResetAlarmOutput, error) {
	req, out := c.BatchResetAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchSnoozeAlarm = "BatchSnoozeAlarm"

// BatchSnoozeAlarmRequest generates a "aws/request.Request" representing the
// client's request for the BatchSnoozeAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchSnoozeAlarm for more information on using the BatchSnoozeAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchSnoozeAlarmRequest method.
//    req, resp := client.BatchSnoozeAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm
func (c *IoTEventsData) BatchSnoozeAlarmRequest(input *BatchSnoozeAlarmInput) (req *request.Request, output *BatchSnoozeAlarmOutput) {
	op := &request.Operation{
		Name:       opBatchSnoozeAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/alarms/snooze",
	}

	if input == nil {
		input = &BatchSnoozeAlarmInput{}
	}

	output = &BatchSnoozeAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchSnoozeAlarm API operation for AWS IoT Events Data.
//
// Changes one or more alarms to the snooze mode. The alarms change to the SNOOZE_DISABLED
// state after you set them to the snooze mode.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchSnoozeAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm
func (c *IoTEventsData) BatchSnoozeAlarm(input *BatchSnoozeAlarmInput) (*BatchSnoozeAlarmOutput, error) {
	req, out := c.BatchSnoozeAlarmRequest(input)
	return out, req.Send()
}

// BatchSnoozeAlarmWithContext is the same as BatchSnoozeAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See BatchSnoozeAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchSnoozeAlarmWithContext(ctx aws.Context, input *BatchSnoozeAlarmInput, opts ...request.Option) (*BatchSnoozeAlarmOutput, error) {
	req, out := c.BatchSnoozeAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateDetector = "BatchUpdateDetector"

// BatchUpdateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateDetector for more information on using the BatchUpdateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateDetectorRequest method.
//    req, resp := client.BatchUpdateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector
func (c *IoTEventsData) BatchUpdateDetectorRequest(input *BatchUpdateDetectorInput) (req *request.Request, output *BatchUpdateDetectorOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detectors",
	}

	if input == nil {
		input = &BatchUpdateDetectorInput{}
	}

	output = &BatchUpdateDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateDetector API operation for AWS IoT Events Data.
//
// Updates the state, variable values, and timer settings of one or more detectors
// (instances) of a specified detector model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchUpdateDetector for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector
func (c *IoTEventsData) BatchUpdateDetector(input *BatchUpdateDetectorInput) (*BatchUpdateDetectorOutput, error) {
	req, out := c.BatchUpdateDetectorRequest(input)
	return out, req.Send()
}

// BatchUpdateDetectorWithContext is the same as BatchUpdateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchUpdateDetectorWithContext(ctx aws.Context, input *BatchUpdateDetectorInput, opts ...request.Option) (*BatchUpdateDetectorOutput, error) {
	req, out := c.BatchUpdateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlarm = "DescribeAlarm"

// DescribeAlarmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarm for more information on using the DescribeAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlarmRequest method.
//    req, resp := client.DescribeAlarmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm
func (c *IoTEventsData) DescribeAlarmRequest(input *DescribeAlarmInput) (req *request.Request, output *DescribeAlarmOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarm,
		HTTPMethod: "GET",
		HTTPPath:   "/alarms/{alarmModelName}/keyValues/",
	}

	if input == nil {
		input = &DescribeAlarmInput{}
	}

	output = &DescribeAlarmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarm API operation for AWS IoT Events Data.
//
// Retrieves information about an alarm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation DescribeAlarm for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm
func (c *IoTEventsData) DescribeAlarm(input *DescribeAlarmInput) (*DescribeAlarmOutput, error) {
	req, out := c.DescribeAlarmRequest(input)
	return out, req.Send()
}

// DescribeAlarmWithContext is the same as DescribeAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) DescribeAlarmWithContext(ctx aws.Context, input *DescribeAlarmInput, opts ...request.Option) (*DescribeAlarmOutput, error) {
	req, out := c.DescribeAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetector for more information on using the DescribeDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDetectorRequest method.
//    req, resp := client.DescribeDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector
func (c *IoTEventsData) DescribeDetectorRequest(input *DescribeDetectorInput) (req *request.Request, output *DescribeDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "GET",
		HTTPPath:   "/detectors/{detectorModelName}/keyValues/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	output = &DescribeDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetector API operation for AWS IoT Events Data.
//
// Returns information about the specified detector (instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation DescribeDetector for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector
func (c *IoTEventsData) DescribeDetector(input *DescribeDetectorInput) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	return out, req.Send()
}

// DescribeDetectorWithContext is the same as DescribeDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) DescribeDetectorWithContext(ctx aws.Context, input *DescribeDetectorInput, opts ...request.Option) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAlarms = "ListAlarms"

// ListAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlarms for more information on using the ListAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAlarmsRequest method.
//    req, resp := client.ListAlarmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms
func (c *IoTEventsData) ListAlarmsRequest(input *ListAlarmsInput) (req *request.Request, output *ListAlarmsOutput) {
	op := &request.Operation{
		Name:       opListAlarms,
		HTTPMethod: "GET",
		HTTPPath:   "/alarms/{alarmModelName}",
	}

	if input == nil {
		input = &ListAlarmsInput{}
	}

	output = &ListAlarmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlarms API operation for AWS IoT Events Data.
//
// Lists one or more alarms. The operation returns only the metadata associated
// with each alarm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation ListAlarms for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms
func (c *IoTEventsData) ListAlarms(input *ListAlarmsInput) (*ListAlarmsOutput, error) {
	req, out := c.ListAlarmsRequest(input)
	return out, req.Send()
}

// ListAlarmsWithContext is the same as ListAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) ListAlarmsWithContext(ctx aws.Context, input *ListAlarmsInput, opts ...request.Option) (*ListAlarmsOutput, error) {
	req, out := c.ListAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectors = "ListDetectors"

// ListDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectors for more information on using the ListDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorsRequest method.
//    req, resp := client.ListDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors
func (c *IoTEventsData) ListDetectorsRequest(input *ListDetectorsInput) (req *request.Request, output *ListDetectorsOutput) {
	op := &request.Operation{
		Name:       opListDetectors,
		HTTPMethod: "GET",
		HTTPPath:   "/detectors/{detectorModelName}",
	}

	if input == nil {
		input = &ListDetectorsInput{}
	}

	output = &ListDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectors API operation for AWS IoT Events Data.
//
// Lists detectors (the instances of a detector model).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation ListDetectors for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors
func (c *IoTEventsData) ListDetectors(input *ListDetectorsInput) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	return out, req.Send()
}

// ListDetectorsWithContext is the same as ListDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) ListDetectorsWithContext(ctx aws.Context, input *ListDetectorsInput, opts ...request.Option) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains the configuration information of an acknowledge action.
type AcknowledgeActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The note that you can leave when you acknowledge the alarm.
	Note *string `locationName:"note" type:"string"`
}

// String returns the string representation
func (s AcknowledgeActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeActionConfiguration) GoString() string {
	return s.String()
}

// SetNote sets the Note field's value.
func (s *AcknowledgeActionConfiguration) SetNote(v string) *AcknowledgeActionConfiguration {
	s.Note = &v
	return s
}

// Information needed to acknowledge the alarm.
type AcknowledgeAlarmActionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The note that you can leave when you acknowledge the alarm.
	Note *string `locationName:"note" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AcknowledgeAlarmActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeAlarmActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeAlarmActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeAlarmActionRequest"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *AcknowledgeAlarmActionRequest) SetAlarmModelName(v string) *AcknowledgeAlarmActionRequest {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *AcknowledgeAlarmActionRequest) SetKeyValue(v string) *AcknowledgeAlarmActionRequest {
	s.KeyValue = &v
	return s
}

// SetNote sets the Note field's value.
func (s *AcknowledgeAlarmActionRequest) SetNote(v string) *AcknowledgeAlarmActionRequest {
	s.Note = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AcknowledgeAlarmActionRequest) SetRequestId(v string) *AcknowledgeAlarmActionRequest {
	s.RequestId = &v
	return s
}

// Contains information about an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string"`

	// The version of the alarm model.
	AlarmModelVersion *string `locationName:"alarmModelVersion" min:"1" type:"string"`

	// Contains information about the current state of the alarm.
	AlarmState *AlarmState `locationName:"alarmState" type:"structure"`

	// The time the alarm was created, in the Unix epoch format.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the alarm was last updated, in the Unix epoch format.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// A non-negative integer that reflects the severity level of the alarm.
	Severity *int64 `locationName:"severity" type:"integer"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *Alarm) SetAlarmModelName(v string) *Alarm {
	s.AlarmModelName = &v
	return s
}

// SetAlarmModelVersion sets the AlarmModelVersion field's value.
func (s *Alarm) SetAlarmModelVersion(v string) *Alarm {
	s.AlarmModelVersion = &v
	return s
}

// SetAlarmState sets the AlarmState field's value.
func (s *Alarm) SetAlarmState(v *AlarmState) *Alarm {
	s.AlarmState = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Alarm) SetCreationTime(v time.Time) *Alarm {
	s.CreationTime = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *Alarm) SetKeyValue(v string) *Alarm {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Alarm) SetLastUpdateTime(v time.Time) *Alarm {
	s.LastUpdateTime = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Alarm) SetSeverity(v int64) *Alarm {
	s.Severity = &v
	return s
}

// Contains information about the current state of the alarm.
type AlarmState struct {
	_ struct{} `type:"structure"`

	// Contains information about the action that you can take to respond to the
	// alarm.
	CustomerAction *CustomerAction `locationName:"customerAction" type:"structure"`

	// Information needed to evaluate data.
	RuleEvaluation *RuleEvaluation `locationName:"ruleEvaluation" type:"structure"`

	// The name of the alarm state. The state name can be one of the following values:
	//
	//    * DISABLED - When the alarm is in the DISABLED state, it isn't ready to
	//    evaluate data. To enable the alarm, you must change the alarm to the NORMAL
	//    state.
	//
	//    * NORMAL - When the alarm is in the NORMAL state, it's ready to evaluate
	//    data.
	//
	//    * ACTIVE - If the alarm is in the ACTIVE state, the alarm is invoked.
	//
	//    * ACKNOWLEDGED - When the alarm is in the ACKNOWLEDGED state, the alarm
	//    was invoked and you acknowledged the alarm.
	//
	//    * SNOOZE_DISABLED - When the alarm is in the SNOOZE_DISABLED state, the
	//    alarm is disabled for a specified period of time. After the snooze time,
	//    the alarm automatically changes to the NORMAL state.
	//
	//    * LATCHED - When the alarm is in the LATCHED state, the alarm was invoked.
	//    However, the data that the alarm is currently evaluating is within the
	//    specified range. To change the alarm to the NORMAL state, you must acknowledge
	//    the alarm.
	StateName *string `locationName:"stateName" type:"string" enum:"AlarmStateName"`

	// Contains information about alarm state changes.
	SystemEvent *SystemEvent `locationName:"systemEvent" type:"structure"`
}

// String returns the string representation
func (s AlarmState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmState) GoString() string {
	return s.String()
}

// SetCustomerAction sets the CustomerAction field's value.
func (s *AlarmState) SetCustomerAction(v *CustomerAction) *AlarmState {
	s.CustomerAction = v
	return s
}

// SetRuleEvaluation sets the RuleEvaluation field's value.
func (s *AlarmState) SetRuleEvaluation(v *RuleEvaluation) *AlarmState {
	s.RuleEvaluation = v
	return s
}

// SetStateName sets the StateName field's value.
func (s *AlarmState) SetStateName(v string) *AlarmState {
	s.StateName = &v
	return s
}

// SetSystemEvent sets the SystemEvent field's value.
func (s *AlarmState) SetSystemEvent(v *SystemEvent) *AlarmState {
	s.SystemEvent = v
	return s
}

// Contains a summary of an alarm.
type AlarmSummary struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string"`

	// The version of the alarm model.
	AlarmModelVersion *string `locationName:"alarmModelVersion" min:"1" type:"string"`

	// The time the alarm was created, in the Unix epoch format.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the alarm was last updated, in the Unix epoch format.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the alarm state. The state name can be one of the following values:
	//
	//    * DISABLED - When the alarm is in the DISABLED state, it isn't ready to
	//    evaluate data. To enable the alarm, you must change the alarm to the NORMAL
	//    state.
	//
	//    * NORMAL - When the alarm is in the NORMAL state, it's ready to evaluate
	//    data.
	//
	//    * ACTIVE - If the alarm is in the ACTIVE state, the alarm is invoked.
	//
	//    * ACKNOWLEDGED - When the alarm is in the ACKNOWLEDGED state, the alarm
	//    was invoked and you acknowledged the alarm.
	//
	//    * SNOOZE_DISABLED - When the alarm is in the SNOOZE_DISABLED state, the
	//    alarm is disabled for a specified period of time. After the snooze time,
	//    the alarm automatically changes to the NORMAL state.
	//
	//    * LATCHED - When the alarm is in the LATCHED state, the alarm was invoked.
	//    However, the data that the alarm is currently evaluating is within the
	//    specified range. To change the alarm to the NORMAL state, you must acknowledge
	//    the alarm.
	StateName *string `locationName:"stateName" type:"string" enum:"AlarmStateName"`
}

// String returns the string representation
func (s AlarmSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmSummary) GoString() string {
	return s.String()
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *AlarmSummary) SetAlarmModelName(v string) *AlarmSummary {
	s.AlarmModelName = &v
	return s
}

// SetAlarmModelVersion sets the AlarmModelVersion field's value.
func (s *AlarmSummary) SetAlarmModelVersion(v string) *AlarmSummary {
	s.AlarmModelVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AlarmSummary) SetCreationTime(v time.Time) *AlarmSummary {
	s.CreationTime = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *AlarmSummary) SetKeyValue(v string) *AlarmSummary {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AlarmSummary) SetLastUpdateTime(v time.Time) *AlarmSummary {
	s.LastUpdateTime = &v
	return s
}

// SetStateName sets the StateName field's value.
func (s *AlarmSummary) SetStateName(v string) *AlarmSummary {
	s.StateName = &v
	return s
}

type BatchAcknowledgeAlarmInput struct {
	_ struct{} `type:"structure"`

	// The list of acknowledge action requests. You can specify up to 10 requests
	// per operation.
	//
	// AcknowledgeActionRequests is a required field
	AcknowledgeActionRequests []*AcknowledgeAlarmActionRequest `locationName:"acknowledgeActionRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAcknowledgeAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAcknowledgeAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAcknowledgeAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAcknowledgeAlarmInput"}
	if s.AcknowledgeActionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("AcknowledgeActionRequests"))
	}
	if s.AcknowledgeActionRequests != nil && len(s.AcknowledgeActionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AcknowledgeActionRequests", 1))
	}
	if s.AcknowledgeActionRequests != nil {
		for i, v := range s.AcknowledgeActionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AcknowledgeActionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcknowledgeActionRequests sets the AcknowledgeActionRequests field's value.
func (s *BatchAcknowledgeAlarmInput) SetAcknowledgeActionRequests(v []*AcknowledgeAlarmActionRequest) *BatchAcknowledgeAlarmInput {
	s.AcknowledgeActionRequests = v
	return s
}

type BatchAcknowledgeAlarmOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors associated with the request, or null if there are no errors.
	// Each error entry contains an entry ID that helps you identify the entry that
	// failed.
	ErrorEntries []*BatchAlarmActionErrorEntry `locationName:"errorEntries" type:"list"`
}

// String returns the string representation
func (s BatchAcknowledgeAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAcknowledgeAlarmOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchAcknowledgeAlarmOutput) SetErrorEntries(v []*BatchAlarmActionErrorEntry) *BatchAcknowledgeAlarmOutput {
	s.ErrorEntries = v
	return s
}

// Contains error messages associated with one of the following requests:
//
//    * BatchAcknowledgeAlarm (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchAcknowledgeAlarm.html)
//
//    * BatchDisableAlarm (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchDisableAlarm.html)
//
//    * BatchEnableAlarm (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchEnableAlarm.html)
//
//    * BatchResetAlarm (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchResetAlarm.html)
//
//    * BatchSnoozeAlarm (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchSnoozeAlarm.html)
type BatchAlarmActionErrorEntry struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A message that describes the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchAlarmActionErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAlarmActionErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchAlarmActionErrorEntry) SetErrorCode(v string) *BatchAlarmActionErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchAlarmActionErrorEntry) SetErrorMessage(v string) *BatchAlarmActionErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *BatchAlarmActionErrorEntry) SetRequestId(v string) *BatchAlarmActionErrorEntry {
	s.RequestId = &v
	return s
}

type BatchDisableAlarmInput struct {
	_ struct{} `type:"structure"`

	// The list of disable action requests. You can specify up to 10 requests per
	// operation.
	//
	// DisableActionRequests is a required field
	DisableActionRequests []*DisableAlarmActionRequest `locationName:"disableActionRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisableAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisableAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisableAlarmInput"}
	if s.DisableActionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("DisableActionRequests"))
	}
	if s.DisableActionRequests != nil && len(s.DisableActionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisableActionRequests", 1))
	}
	if s.DisableActionRequests != nil {
		for i, v := range s.DisableActionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DisableActionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisableActionRequests sets the DisableActionRequests field's value.
func (s *BatchDisableAlarmInput) SetDisableActionRequests(v []*DisableAlarmActionRequest) *BatchDisableAlarmInput {
	s.DisableActionRequests = v
	return s
}

type BatchDisableAlarmOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors associated with the request, or null if there are no errors.
	// Each error entry contains an entry ID that helps you identify the entry that
	// failed.
	ErrorEntries []*BatchAlarmActionErrorEntry `locationName:"errorEntries" type:"list"`
}

// String returns the string representation
func (s BatchDisableAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableAlarmOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchDisableAlarmOutput) SetErrorEntries(v []*BatchAlarmActionErrorEntry) *BatchDisableAlarmOutput {
	s.ErrorEntries = v
	return s
}

type BatchEnableAlarmInput struct {
	_ struct{} `type:"structure"`

	// The list of enable action requests. You can specify up to 10 requests per
	// operation.
	//
	// EnableActionRequests is a required field
	EnableActionRequests []*EnableAlarmActionRequest `locationName:"enableActionRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEnableAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEnableAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEnableAlarmInput"}
	if s.EnableActionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableActionRequests"))
	}
	if s.EnableActionRequests != nil && len(s.EnableActionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnableActionRequests", 1))
	}
	if s.EnableActionRequests != nil {
		for i, v := range s.EnableActionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnableActionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableActionRequests sets the EnableActionRequests field's value.
func (s *BatchEnableAlarmInput) SetEnableActionRequests(v []*EnableAlarmActionRequest) *BatchEnableAlarmInput {
	s.EnableActionRequests = v
	return s
}

type BatchEnableAlarmOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors associated with the request, or null if there are no errors.
	// Each error entry contains an entry ID that helps you identify the entry that
	// failed.
	ErrorEntries []*BatchAlarmActionErrorEntry `locationName:"errorEntries" type:"list"`
}

// String returns the string representation
func (s BatchEnableAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableAlarmOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchEnableAlarmOutput) SetErrorEntries(v []*BatchAlarmActionErrorEntry) *BatchEnableAlarmOutput {
	s.ErrorEntries = v
	return s
}

// Contains information about the errors encountered.
type BatchPutMessageErrorEntry struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A message that describes the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the message that caused the error. (See the value corresponding
	// to the "messageId" key in the "message" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutMessageErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutMessageErrorEntry) SetErrorCode(v string) *BatchPutMessageErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutMessageErrorEntry) SetErrorMessage(v string) *BatchPutMessageErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BatchPutMessageErrorEntry) SetMessageId(v string) *BatchPutMessageErrorEntry {
	s.MessageId = &v
	return s
}

type BatchPutMessageInput struct {
	_ struct{} `type:"structure"`

	// The list of messages to send. Each message has the following format: '{ "messageId":
	// "string", "inputName": "string", "payload": "string"}'
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutMessageInput"}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Messages", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessages sets the Messages field's value.
func (s *BatchPutMessageInput) SetMessages(v []*Message) *BatchPutMessageInput {
	s.Messages = v
	return s
}

type BatchPutMessageOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors encountered when sending the messages.
	BatchPutMessageErrorEntries []*BatchPutMessageErrorEntry `type:"list"`
}

// String returns the string representation
func (s BatchPutMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageOutput) GoString() string {
	return s.String()
}

// SetBatchPutMessageErrorEntries sets the BatchPutMessageErrorEntries field's value.
func (s *BatchPutMessageOutput) SetBatchPutMessageErrorEntries(v []*BatchPutMessageErrorEntry) *BatchPutMessageOutput {
	s.BatchPutMessageErrorEntries = v
	return s
}

type BatchResetAlarmInput struct {
	_ struct{} `type:"structure"`

	// The list of reset action requests. You can specify up to 10 requests per
	// operation.
	//
	// ResetActionRequests is a required field
	ResetActionRequests []*ResetAlarmActionRequest `locationName:"resetActionRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchResetAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchResetAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchResetAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchResetAlarmInput"}
	if s.ResetActionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("ResetActionRequests"))
	}
	if s.ResetActionRequests != nil && len(s.ResetActionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResetActionRequests", 1))
	}
	if s.ResetActionRequests != nil {
		for i, v := range s.ResetActionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResetActionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResetActionRequests sets the ResetActionRequests field's value.
func (s *BatchResetAlarmInput) SetResetActionRequests(v []*ResetAlarmActionRequest) *BatchResetAlarmInput {
	s.ResetActionRequests = v
	return s
}

type BatchResetAlarmOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors associated with the request, or null if there are no errors.
	// Each error entry contains an entry ID that helps you identify the entry that
	// failed.
	ErrorEntries []*BatchAlarmActionErrorEntry `locationName:"errorEntries" type:"list"`
}

// String returns the string representation
func (s BatchResetAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchResetAlarmOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchResetAlarmOutput) SetErrorEntries(v []*BatchAlarmActionErrorEntry) *BatchResetAlarmOutput {
	s.ErrorEntries = v
	return s
}

type BatchSnoozeAlarmInput struct {
	_ struct{} `type:"structure"`

	// The list of snooze action requests. You can specify up to 10 requests per
	// operation.
	//
	// SnoozeActionRequests is a required field
	SnoozeActionRequests []*SnoozeAlarmActionRequest `locationName:"snoozeActionRequests" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchSnoozeAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSnoozeAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchSnoozeAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchSnoozeAlarmInput"}
	if s.SnoozeActionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("SnoozeActionRequests"))
	}
	if s.SnoozeActionRequests != nil && len(s.SnoozeActionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnoozeActionRequests", 1))
	}
	if s.SnoozeActionRequests != nil {
		for i, v := range s.SnoozeActionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SnoozeActionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnoozeActionRequests sets the SnoozeActionRequests field's value.
func (s *BatchSnoozeAlarmInput) SetSnoozeActionRequests(v []*SnoozeAlarmActionRequest) *BatchSnoozeAlarmInput {
	s.SnoozeActionRequests = v
	return s
}

type BatchSnoozeAlarmOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors associated with the request, or null if there are no errors.
	// Each error entry contains an entry ID that helps you identify the entry that
	// failed.
	ErrorEntries []*BatchAlarmActionErrorEntry `locationName:"errorEntries" type:"list"`
}

// String returns the string representation
func (s BatchSnoozeAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSnoozeAlarmOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchSnoozeAlarmOutput) SetErrorEntries(v []*BatchAlarmActionErrorEntry) *BatchSnoozeAlarmOutput {
	s.ErrorEntries = v
	return s
}

// Information about the error that occurred when attempting to update a detector.
type BatchUpdateDetectorErrorEntry struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A message that describes the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The "messageId" of the update request that caused the error. (The value of
	// the "messageId" in the update request "Detector" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchUpdateDetectorErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchUpdateDetectorErrorEntry) SetErrorCode(v string) *BatchUpdateDetectorErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchUpdateDetectorErrorEntry) SetErrorMessage(v string) *BatchUpdateDetectorErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BatchUpdateDetectorErrorEntry) SetMessageId(v string) *BatchUpdateDetectorErrorEntry {
	s.MessageId = &v
	return s
}

type BatchUpdateDetectorInput struct {
	_ struct{} `type:"structure"`

	// The list of detectors (instances) to update, along with the values to update.
	//
	// Detectors is a required field
	Detectors []*UpdateDetectorRequest `locationName:"detectors" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateDetectorInput"}
	if s.Detectors == nil {
		invalidParams.Add(request.NewErrParamRequired("Detectors"))
	}
	if s.Detectors != nil && len(s.Detectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Detectors", 1))
	}
	if s.Detectors != nil {
		for i, v := range s.Detectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Detectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectors sets the Detectors field's value.
func (s *BatchUpdateDetectorInput) SetDetectors(v []*UpdateDetectorRequest) *BatchUpdateDetectorInput {
	s.Detectors = v
	return s
}

type BatchUpdateDetectorOutput struct {
	_ struct{} `type:"structure"`

	// A list of those detector updates that resulted in errors. (If an error is
	// listed here, the specific update did not occur.)
	BatchUpdateDetectorErrorEntries []*BatchUpdateDetectorErrorEntry `locationName:"batchUpdateDetectorErrorEntries" type:"list"`
}

// String returns the string representation
func (s BatchUpdateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorOutput) GoString() string {
	return s.String()
}

// SetBatchUpdateDetectorErrorEntries sets the BatchUpdateDetectorErrorEntries field's value.
func (s *BatchUpdateDetectorOutput) SetBatchUpdateDetectorErrorEntries(v []*BatchUpdateDetectorErrorEntry) *BatchUpdateDetectorOutput {
	s.BatchUpdateDetectorErrorEntries = v
	return s
}

// Contains information about the action that you can take to respond to the
// alarm.
type CustomerAction struct {
	_ struct{} `type:"structure"`

	// Contains the configuration information of an acknowledge action.
	AcknowledgeActionConfiguration *AcknowledgeActionConfiguration `locationName:"acknowledgeActionConfiguration" type:"structure"`

	// The name of the action. The action name can be one of the following values:
	//
	//    * SNOOZE - When you snooze the alarm, the alarm state changes to SNOOZE_DISABLED.
	//
	//    * ENABLE - When you enable the alarm, the alarm state changes to NORMAL.
	//
	//    * DISABLE - When you disable the alarm, the alarm state changes to DISABLED.
	//
	//    * ACKNOWLEDGE - When you acknowledge the alarm, the alarm state changes
	//    to ACKNOWLEDGED.
	//
	//    * RESET - When you reset the alarm, the alarm state changes to NORMAL.
	//
	// For more information, see the AlarmState (https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html)
	// API.
	ActionName *string `locationName:"actionName" type:"string" enum:"CustomerActionName"`

	// Contains the configuration information of a disable action.
	DisableActionConfiguration *DisableActionConfiguration `locationName:"disableActionConfiguration" type:"structure"`

	// Contains the configuration information of an enable action.
	EnableActionConfiguration *EnableActionConfiguration `locationName:"enableActionConfiguration" type:"structure"`

	// Contains the configuration information of a reset action.
	ResetActionConfiguration *ResetActionConfiguration `locationName:"resetActionConfiguration" type:"structure"`

	// Contains the configuration information of a snooze action.
	SnoozeActionConfiguration *SnoozeActionConfiguration `locationName:"snoozeActionConfiguration" type:"structure"`
}

// String returns the string representation
func (s CustomerAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerAction) GoString() string {
	return s.String()
}

// SetAcknowledgeActionConfiguration sets the AcknowledgeActionConfiguration field's value.
func (s *CustomerAction) SetAcknowledgeActionConfiguration(v *AcknowledgeActionConfiguration) *CustomerAction {
	s.AcknowledgeActionConfiguration = v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *CustomerAction) SetActionName(v string) *CustomerAction {
	s.ActionName = &v
	return s
}

// SetDisableActionConfiguration sets the DisableActionConfiguration field's value.
func (s *CustomerAction) SetDisableActionConfiguration(v *DisableActionConfiguration) *CustomerAction {
	s.DisableActionConfiguration = v
	return s
}

// SetEnableActionConfiguration sets the EnableActionConfiguration field's value.
func (s *CustomerAction) SetEnableActionConfiguration(v *EnableActionConfiguration) *CustomerAction {
	s.EnableActionConfiguration = v
	return s
}

// SetResetActionConfiguration sets the ResetActionConfiguration field's value.
func (s *CustomerAction) SetResetActionConfiguration(v *ResetActionConfiguration) *CustomerAction {
	s.ResetActionConfiguration = v
	return s
}

// SetSnoozeActionConfiguration sets the SnoozeActionConfiguration field's value.
func (s *CustomerAction) SetSnoozeActionConfiguration(v *SnoozeActionConfiguration) *CustomerAction {
	s.SnoozeActionConfiguration = v
	return s
}

type DescribeAlarmInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `location:"uri" locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `location:"querystring" locationName:"keyValue" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmInput"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *DescribeAlarmInput) SetAlarmModelName(v string) *DescribeAlarmInput {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DescribeAlarmInput) SetKeyValue(v string) *DescribeAlarmInput {
	s.KeyValue = &v
	return s
}

type DescribeAlarmOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an alarm.
	Alarm *Alarm `locationName:"alarm" type:"structure"`
}

// String returns the string representation
func (s DescribeAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAlarmOutput) GoString() string {
	return s.String()
}

// SetAlarm sets the Alarm field's value.
func (s *DescribeAlarmOutput) SetAlarm(v *Alarm) *DescribeAlarmOutput {
	s.Alarm = v
	return s
}

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model whose detectors (instances) you want information
	// about.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// A filter used to limit results to detectors (instances) created because of
	// the given key ID.
	KeyValue *string `location:"querystring" locationName:"keyValue" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DescribeDetectorInput) SetDetectorModelName(v string) *DescribeDetectorInput {
	s.DetectorModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DescribeDetectorInput) SetKeyValue(v string) *DescribeDetectorInput {
	s.KeyValue = &v
	return s
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the detector (instance).
	Detector *Detector `locationName:"detector" type:"structure"`
}

// String returns the string representation
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorOutput) GoString() string {
	return s.String()
}

// SetDetector sets the Detector field's value.
func (s *DescribeDetectorOutput) SetDetector(v *Detector) *DescribeDetectorOutput {
	s.Detector = v
	return s
}

// Information about the detector (instance).
type Detector struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Detector) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Detector) SetCreationTime(v time.Time) *Detector {
	s.CreationTime = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *Detector) SetDetectorModelName(v string) *Detector {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *Detector) SetDetectorModelVersion(v string) *Detector {
	s.DetectorModelVersion = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *Detector) SetKeyValue(v string) *Detector {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Detector) SetLastUpdateTime(v time.Time) *Detector {
	s.LastUpdateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Detector) SetState(v *DetectorState) *Detector {
	s.State = v
	return s
}

// Information about the current state of the detector instance.
type DetectorState struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The current state of the detector's timers.
	//
	// Timers is a required field
	Timers []*Timer `locationName:"timers" type:"list" required:"true"`

	// The current values of the detector's variables.
	//
	// Variables is a required field
	Variables []*Variable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorState) GoString() string {
	return s.String()
}

// SetStateName sets the StateName field's value.
func (s *DetectorState) SetStateName(v string) *DetectorState {
	s.StateName = &v
	return s
}

// SetTimers sets the Timers field's value.
func (s *DetectorState) SetTimers(v []*Timer) *DetectorState {
	s.Timers = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *DetectorState) SetVariables(v []*Variable) *DetectorState {
	s.Variables = v
	return s
}

// The new state, variable values, and timer settings of the detector (instance).
type DetectorStateDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the new state of the detector (instance).
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The new values of the detector's timers. Any timer whose value isn't specified
	// is cleared, and its timeout event won't occur.
	//
	// Timers is a required field
	Timers []*TimerDefinition `locationName:"timers" type:"list" required:"true"`

	// The new values of the detector's variables. Any variable whose value isn't
	// specified is cleared.
	//
	// Variables is a required field
	Variables []*VariableDefinition `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorStateDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorStateDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorStateDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectorStateDefinition"}
	if s.StateName == nil {
		invalidParams.Add(request.NewErrParamRequired("StateName"))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateName", 1))
	}
	if s.Timers == nil {
		invalidParams.Add(request.NewErrParamRequired("Timers"))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.Timers != nil {
		for i, v := range s.Timers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Timers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateName sets the StateName field's value.
func (s *DetectorStateDefinition) SetStateName(v string) *DetectorStateDefinition {
	s.StateName = &v
	return s
}

// SetTimers sets the Timers field's value.
func (s *DetectorStateDefinition) SetTimers(v []*TimerDefinition) *DetectorStateDefinition {
	s.Timers = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *DetectorStateDefinition) SetVariables(v []*VariableDefinition) *DetectorStateDefinition {
	s.Variables = v
	return s
}

// Information about the detector state.
type DetectorStateSummary struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	StateName *string `locationName:"stateName" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorStateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorStateSummary) GoString() string {
	return s.String()
}

// SetStateName sets the StateName field's value.
func (s *DetectorStateSummary) SetStateName(v string) *DetectorStateSummary {
	s.StateName = &v
	return s
}

// Information about the detector (instance).
type DetectorSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorStateSummary `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s DetectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DetectorSummary) SetCreationTime(v time.Time) *DetectorSummary {
	s.CreationTime = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorSummary) SetDetectorModelName(v string) *DetectorSummary {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *DetectorSummary) SetDetectorModelVersion(v string) *DetectorSummary {
	s.DetectorModelVersion = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DetectorSummary) SetKeyValue(v string) *DetectorSummary {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DetectorSummary) SetLastUpdateTime(v time.Time) *DetectorSummary {
	s.LastUpdateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *DetectorSummary) SetState(v *DetectorStateSummary) *DetectorSummary {
	s.State = v
	return s
}

// Contains the configuration information of a disable action.
type DisableActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The note that you can leave when you disable the alarm.
	Note *string `locationName:"note" type:"string"`
}

// String returns the string representation
func (s DisableActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableActionConfiguration) GoString() string {
	return s.String()
}

// SetNote sets the Note field's value.
func (s *DisableActionConfiguration) SetNote(v string) *DisableActionConfiguration {
	s.Note = &v
	return s
}

// Information used to disable the alarm.
type DisableAlarmActionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The note that you can leave when you disable the alarm.
	Note *string `locationName:"note" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAlarmActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAlarmActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAlarmActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAlarmActionRequest"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *DisableAlarmActionRequest) SetAlarmModelName(v string) *DisableAlarmActionRequest {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DisableAlarmActionRequest) SetKeyValue(v string) *DisableAlarmActionRequest {
	s.KeyValue = &v
	return s
}

// SetNote sets the Note field's value.
func (s *DisableAlarmActionRequest) SetNote(v string) *DisableAlarmActionRequest {
	s.Note = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DisableAlarmActionRequest) SetRequestId(v string) *DisableAlarmActionRequest {
	s.RequestId = &v
	return s
}

// Contains the configuration information of an enable action.
type EnableActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The note that you can leave when you enable the alarm.
	Note *string `locationName:"note" type:"string"`
}

// String returns the string representation
func (s EnableActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableActionConfiguration) GoString() string {
	return s.String()
}

// SetNote sets the Note field's value.
func (s *EnableActionConfiguration) SetNote(v string) *EnableActionConfiguration {
	s.Note = &v
	return s
}

// Information needed to enable the alarm.
type EnableAlarmActionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The note that you can leave when you enable the alarm.
	Note *string `locationName:"note" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAlarmActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAlarmActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAlarmActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAlarmActionRequest"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *EnableAlarmActionRequest) SetAlarmModelName(v string) *EnableAlarmActionRequest {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *EnableAlarmActionRequest) SetKeyValue(v string) *EnableAlarmActionRequest {
	s.KeyValue = &v
	return s
}

// SetNote sets the Note field's value.
func (s *EnableAlarmActionRequest) SetNote(v string) *EnableAlarmActionRequest {
	s.Note = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EnableAlarmActionRequest) SetRequestId(v string) *EnableAlarmActionRequest {
	s.RequestId = &v
	return s
}

// An internal failure occurred.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `location:"uri" locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token that you can use to return the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAlarmsInput"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *ListAlarmsInput) SetAlarmModelName(v string) *ListAlarmsInput {
	s.AlarmModelName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAlarmsInput) SetMaxResults(v int64) *ListAlarmsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlarmsInput) SetNextToken(v string) *ListAlarmsInput {
	s.NextToken = &v
	return s
}

type ListAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each alarm.
	AlarmSummaries []*AlarmSummary `locationName:"alarmSummaries" type:"list"`

	// The token that you can use to return the next set of results, or null if
	// there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAlarmsOutput) GoString() string {
	return s.String()
}

// SetAlarmSummaries sets the AlarmSummaries field's value.
func (s *ListAlarmsOutput) SetAlarmSummaries(v []*AlarmSummary) *ListAlarmsOutput {
	s.AlarmSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAlarmsOutput) SetNextToken(v string) *ListAlarmsOutput {
	s.NextToken = &v
	return s
}

type ListDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model whose detectors (instances) are listed.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token that you can use to return the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter that limits results to those detectors (instances) in the given
	// state.
	StateName *string `location:"querystring" locationName:"stateName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorsInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *ListDetectorsInput) SetDetectorModelName(v string) *ListDetectorsInput {
	s.DetectorModelName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorsInput) SetMaxResults(v int64) *ListDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsInput) SetNextToken(v string) *ListDetectorsInput {
	s.NextToken = &v
	return s
}

// SetStateName sets the StateName field's value.
func (s *ListDetectorsInput) SetStateName(v string) *ListDetectorsInput {
	s.StateName = &v
	return s
}

type ListDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of summary information about the detectors (instances).
	DetectorSummaries []*DetectorSummary `locationName:"detectorSummaries" type:"list"`

	// The token that you can use to return the next set of results, or null if
	// there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectorSummaries sets the DetectorSummaries field's value.
func (s *ListDetectorsOutput) SetDetectorSummaries(v []*DetectorSummary) *ListDetectorsOutput {
	s.DetectorSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsOutput) SetNextToken(v string) *ListDetectorsOutput {
	s.NextToken = &v
	return s
}

// Information about a message.
type Message struct {
	_ struct{} `type:"structure"`

	// The name of the input into which the message payload is transformed.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The ID to assign to the message. Within each batch sent, each "messageId"
	// must be unique.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The payload of the message. This can be a JSON string or a Base-64-encoded
	// string representing binary data (in which case you must decode it).
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`

	// The timestamp associated with the message.
	Timestamp *TimestampValue `locationName:"timestamp" type:"structure"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}
	if s.Timestamp != nil {
		if err := s.Timestamp.Validate(); err != nil {
			invalidParams.AddNested("Timestamp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputName sets the InputName field's value.
func (s *Message) SetInputName(v string) *Message {
	s.InputName = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *Message) SetMessageId(v string) *Message {
	s.MessageId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *Message) SetPayload(v []byte) *Message {
	s.Payload = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Message) SetTimestamp(v *TimestampValue) *Message {
	s.Timestamp = v
	return s
}

// Contains the configuration information of a reset action.
type ResetActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The note that you can leave when you reset the alarm.
	Note *string `locationName:"note" type:"string"`
}

// String returns the string representation
func (s ResetActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetActionConfiguration) GoString() string {
	return s.String()
}

// SetNote sets the Note field's value.
func (s *ResetActionConfiguration) SetNote(v string) *ResetActionConfiguration {
	s.Note = &v
	return s
}

// Information needed to reset the alarm.
type ResetAlarmActionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The note that you can leave when you reset the alarm.
	Note *string `locationName:"note" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetAlarmActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetAlarmActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetAlarmActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetAlarmActionRequest"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *ResetAlarmActionRequest) SetAlarmModelName(v string) *ResetAlarmActionRequest {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *ResetAlarmActionRequest) SetKeyValue(v string) *ResetAlarmActionRequest {
	s.KeyValue = &v
	return s
}

// SetNote sets the Note field's value.
func (s *ResetAlarmActionRequest) SetNote(v string) *ResetAlarmActionRequest {
	s.Note = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ResetAlarmActionRequest) SetRequestId(v string) *ResetAlarmActionRequest {
	s.RequestId = &v
	return s
}

// The resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information needed to evaluate data.
type RuleEvaluation struct {
	_ struct{} `type:"structure"`

	// Information needed to compare two values with a comparison operator.
	SimpleRuleEvaluation *SimpleRuleEvaluation `locationName:"simpleRuleEvaluation" type:"structure"`
}

// String returns the string representation
func (s RuleEvaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleEvaluation) GoString() string {
	return s.String()
}

// SetSimpleRuleEvaluation sets the SimpleRuleEvaluation field's value.
func (s *RuleEvaluation) SetSimpleRuleEvaluation(v *SimpleRuleEvaluation) *RuleEvaluation {
	s.SimpleRuleEvaluation = v
	return s
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information needed to compare two values with a comparison operator.
type SimpleRuleEvaluation struct {
	_ struct{} `type:"structure"`

	// The value of the input property, on the left side of the comparison operator.
	InputPropertyValue *string `locationName:"inputPropertyValue" type:"string"`

	// The comparison operator.
	Operator *string `locationName:"operator" type:"string" enum:"ComparisonOperator"`

	// The threshold value, on the right side of the comparison operator.
	ThresholdValue *string `locationName:"thresholdValue" type:"string"`
}

// String returns the string representation
func (s SimpleRuleEvaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimpleRuleEvaluation) GoString() string {
	return s.String()
}

// SetInputPropertyValue sets the InputPropertyValue field's value.
func (s *SimpleRuleEvaluation) SetInputPropertyValue(v string) *SimpleRuleEvaluation {
	s.InputPropertyValue = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *SimpleRuleEvaluation) SetOperator(v string) *SimpleRuleEvaluation {
	s.Operator = &v
	return s
}

// SetThresholdValue sets the ThresholdValue field's value.
func (s *SimpleRuleEvaluation) SetThresholdValue(v string) *SimpleRuleEvaluation {
	s.ThresholdValue = &v
	return s
}

// Contains the configuration information of a snooze action.
type SnoozeActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The note that you can leave when you snooze the alarm.
	Note *string `locationName:"note" type:"string"`

	// The snooze time in seconds. The alarm automatically changes to the NORMAL
	// state after this duration.
	SnoozeDuration *int64 `locationName:"snoozeDuration" type:"integer"`
}

// String returns the string representation
func (s SnoozeActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnoozeActionConfiguration) GoString() string {
	return s.String()
}

// SetNote sets the Note field's value.
func (s *SnoozeActionConfiguration) SetNote(v string) *SnoozeActionConfiguration {
	s.Note = &v
	return s
}

// SetSnoozeDuration sets the SnoozeDuration field's value.
func (s *SnoozeActionConfiguration) SetSnoozeDuration(v int64) *SnoozeActionConfiguration {
	s.SnoozeDuration = &v
	return s
}

// Information needed to snooze the alarm.
type SnoozeAlarmActionRequest struct {
	_ struct{} `type:"structure"`

	// The name of the alarm model.
	//
	// AlarmModelName is a required field
	AlarmModelName *string `locationName:"alarmModelName" min:"1" type:"string" required:"true"`

	// The value of the key used as a filter to select only the alarms associated
	// with the key (https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The note that you can leave when you snooze the alarm.
	Note *string `locationName:"note" type:"string"`

	// The request ID. Each ID must be unique within each batch.
	//
	// RequestId is a required field
	RequestId *string `locationName:"requestId" min:"1" type:"string" required:"true"`

	// The snooze time in seconds. The alarm automatically changes to the NORMAL
	// state after this duration.
	//
	// SnoozeDuration is a required field
	SnoozeDuration *int64 `locationName:"snoozeDuration" type:"integer" required:"true"`
}

// String returns the string representation
func (s SnoozeAlarmActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnoozeAlarmActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnoozeAlarmActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnoozeAlarmActionRequest"}
	if s.AlarmModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmModelName"))
	}
	if s.AlarmModelName != nil && len(*s.AlarmModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.RequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestId"))
	}
	if s.RequestId != nil && len(*s.RequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestId", 1))
	}
	if s.SnoozeDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("SnoozeDuration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmModelName sets the AlarmModelName field's value.
func (s *SnoozeAlarmActionRequest) SetAlarmModelName(v string) *SnoozeAlarmActionRequest {
	s.AlarmModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *SnoozeAlarmActionRequest) SetKeyValue(v string) *SnoozeAlarmActionRequest {
	s.KeyValue = &v
	return s
}

// SetNote sets the Note field's value.
func (s *SnoozeAlarmActionRequest) SetNote(v string) *SnoozeAlarmActionRequest {
	s.Note = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *SnoozeAlarmActionRequest) SetRequestId(v string) *SnoozeAlarmActionRequest {
	s.RequestId = &v
	return s
}

// SetSnoozeDuration sets the SnoozeDuration field's value.
func (s *SnoozeAlarmActionRequest) SetSnoozeDuration(v int64) *SnoozeAlarmActionRequest {
	s.SnoozeDuration = &v
	return s
}

// Contains the configuration information of alarm state changes.
type StateChangeConfiguration struct {
	_ struct{} `type:"structure"`

	// The trigger type. If the value is SNOOZE_TIMEOUT, the snooze duration ends
	// and the alarm automatically changes to the NORMAL state.
	TriggerType *string `locationName:"triggerType" type:"string" enum:"TriggerType"`
}

// String returns the string representation
func (s StateChangeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StateChangeConfiguration) GoString() string {
	return s.String()
}

// SetTriggerType sets the TriggerType field's value.
func (s *StateChangeConfiguration) SetTriggerType(v string) *StateChangeConfiguration {
	s.TriggerType = &v
	return s
}

// Contains information about alarm state changes.
type SystemEvent struct {
	_ struct{} `type:"structure"`

	// The event type. If the value is STATE_CHANGE, the event contains information
	// about alarm state changes.
	EventType *string `locationName:"eventType" type:"string" enum:"EventType"`

	// Contains the configuration information of alarm state changes.
	StateChangeConfiguration *StateChangeConfiguration `locationName:"stateChangeConfiguration" type:"structure"`
}

// String returns the string representation
func (s SystemEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemEvent) GoString() string {
	return s.String()
}

// SetEventType sets the EventType field's value.
func (s *SystemEvent) SetEventType(v string) *SystemEvent {
	s.EventType = &v
	return s
}

// SetStateChangeConfiguration sets the StateChangeConfiguration field's value.
func (s *SystemEvent) SetStateChangeConfiguration(v *StateChangeConfiguration) *SystemEvent {
	s.StateChangeConfiguration = v
	return s
}

// The request could not be completed due to throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The current state of a timer.
type Timer struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The number of seconds which have elapsed on the timer.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Timer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Timer) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Timer) SetName(v string) *Timer {
	s.Name = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Timer) SetTimestamp(v time.Time) *Timer {
	s.Timestamp = &v
	return s
}

// The new setting of a timer.
type TimerDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new setting of the timer (the number of seconds before the timer elapses).
	//
	// Seconds is a required field
	Seconds *int64 `locationName:"seconds" type:"integer" required:"true"`
}

// String returns the string representation
func (s TimerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimerDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimerDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Seconds == nil {
		invalidParams.Add(request.NewErrParamRequired("Seconds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TimerDefinition) SetName(v string) *TimerDefinition {
	s.Name = &v
	return s
}

// SetSeconds sets the Seconds field's value.
func (s *TimerDefinition) SetSeconds(v int64) *TimerDefinition {
	s.Seconds = &v
	return s
}

// Contains information about a timestamp.
type TimestampValue struct {
	_ struct{} `type:"structure"`

	// The value of the timestamp, in the Unix epoch format.
	TimeInMillis *int64 `locationName:"timeInMillis" min:"1" type:"long"`
}

// String returns the string representation
func (s TimestampValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimestampValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestampValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestampValue"}
	if s.TimeInMillis != nil && *s.TimeInMillis < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeInMillis", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimeInMillis sets the TimeInMillis field's value.
func (s *TimestampValue) SetTimeInMillis(v int64) *TimestampValue {
	s.TimeInMillis = &v
	return s
}

// Information used to update the detector (instance).
type UpdateDetectorRequest struct {
	_ struct{} `type:"structure"`

	// The name of the detector model that created the detectors (instances).
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The value of the input key attribute (identifying the device or system) that
	// caused the creation of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The ID to assign to the detector update "message". Each "messageId" must
	// be unique within each batch sent.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The new state, variable values, and timer settings of the detector (instance).
	//
	// State is a required field
	State *DetectorStateDefinition `locationName:"state" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorRequest"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *UpdateDetectorRequest) SetDetectorModelName(v string) *UpdateDetectorRequest {
	s.DetectorModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *UpdateDetectorRequest) SetKeyValue(v string) *UpdateDetectorRequest {
	s.KeyValue = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateDetectorRequest) SetMessageId(v string) *UpdateDetectorRequest {
	s.MessageId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateDetectorRequest) SetState(v *DetectorStateDefinition) *UpdateDetectorRequest {
	s.State = v
	return s
}

// The current state of the variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Variable) SetValue(v string) *Variable {
	s.Value = &v
	return s
}

// The new value of the variable.
type VariableDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VariableDefinition) SetName(v string) *VariableDefinition {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *VariableDefinition) SetValue(v string) *VariableDefinition {
	s.Value = &v
	return s
}

const (
	// AlarmStateNameDisabled is a AlarmStateName enum value
	AlarmStateNameDisabled = "DISABLED"

	// AlarmStateNameNormal is a AlarmStateName enum value
	AlarmStateNameNormal = "NORMAL"

	// AlarmStateNameActive is a AlarmStateName enum value
	AlarmStateNameActive = "ACTIVE"

	// AlarmStateNameAcknowledged is a AlarmStateName enum value
	AlarmStateNameAcknowledged = "ACKNOWLEDGED"

	// AlarmStateNameSnoozeDisabled is a AlarmStateName enum value
	AlarmStateNameSnoozeDisabled = "SNOOZE_DISABLED"

	// AlarmStateNameLatched is a AlarmStateName enum value
	AlarmStateNameLatched = "LATCHED"
)

// AlarmStateName_Values returns all elements of the AlarmStateName enum
func AlarmStateName_Values() []string {
	return []string{
		AlarmStateNameDisabled,
		AlarmStateNameNormal,
		AlarmStateNameActive,
		AlarmStateNameAcknowledged,
		AlarmStateNameSnoozeDisabled,
		AlarmStateNameLatched,
	}
}

const (
	// ComparisonOperatorGreater is a ComparisonOperator enum value
	ComparisonOperatorGreater = "GREATER"

	// ComparisonOperatorGreaterOrEqual is a ComparisonOperator enum value
	ComparisonOperatorGreaterOrEqual = "GREATER_OR_EQUAL"

	// ComparisonOperatorLess is a ComparisonOperator enum value
	ComparisonOperatorLess = "LESS"

	// ComparisonOperatorLessOrEqual is a ComparisonOperator enum value
	ComparisonOperatorLessOrEqual = "LESS_OR_EQUAL"

	// ComparisonOperatorEqual is a ComparisonOperator enum value
	ComparisonOperatorEqual = "EQUAL"

	// ComparisonOperatorNotEqual is a ComparisonOperator enum value
	ComparisonOperatorNotEqual = "NOT_EQUAL"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorGreater,
		ComparisonOperatorGreaterOrEqual,
		ComparisonOperatorLess,
		ComparisonOperatorLessOrEqual,
		ComparisonOperatorEqual,
		ComparisonOperatorNotEqual,
	}
}

const (
	// CustomerActionNameSnooze is a CustomerActionName enum value
	CustomerActionNameSnooze = "SNOOZE"

	// CustomerActionNameEnable is a CustomerActionName enum value
	CustomerActionNameEnable = "ENABLE"

	// CustomerActionNameDisable is a CustomerActionName enum value
	CustomerActionNameDisable = "DISABLE"

	// CustomerActionNameAcknowledge is a CustomerActionName enum value
	CustomerActionNameAcknowledge = "ACKNOWLEDGE"

	// CustomerActionNameReset is a CustomerActionName enum value
	CustomerActionNameReset = "RESET"
)

// CustomerActionName_Values returns all elements of the CustomerActionName enum
func CustomerActionName_Values() []string {
	return []string{
		CustomerActionNameSnooze,
		CustomerActionNameEnable,
		CustomerActionNameDisable,
		CustomerActionNameAcknowledge,
		CustomerActionNameReset,
	}
}

const (
	// ErrorCodeResourceNotFoundException is a ErrorCode enum value
	ErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// ErrorCodeInvalidRequestException is a ErrorCode enum value
	ErrorCodeInvalidRequestException = "InvalidRequestException"

	// ErrorCodeInternalFailureException is a ErrorCode enum value
	ErrorCodeInternalFailureException = "InternalFailureException"

	// ErrorCodeServiceUnavailableException is a ErrorCode enum value
	ErrorCodeServiceUnavailableException = "ServiceUnavailableException"

	// ErrorCodeThrottlingException is a ErrorCode enum value
	ErrorCodeThrottlingException = "ThrottlingException"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeResourceNotFoundException,
		ErrorCodeInvalidRequestException,
		ErrorCodeInternalFailureException,
		ErrorCodeServiceUnavailableException,
		ErrorCodeThrottlingException,
	}
}

const (
	// EventTypeStateChange is a EventType enum value
	EventTypeStateChange = "STATE_CHANGE"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeStateChange,
	}
}

const (
	// TriggerTypeSnoozeTimeout is a TriggerType enum value
	TriggerTypeSnoozeTimeout = "SNOOZE_TIMEOUT"
)

// TriggerType_Values returns all elements of the TriggerType enum
func TriggerType_Values() []string {
	return []string{
		TriggerTypeSnoozeTimeout,
	}
}
