// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EnableAddOnInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the add-on to enable or modify.
	//
	// AddOnRequest is a required field
	AddOnRequest *AddOnRequest `locationName:"addOnRequest" type:"structure" required:"true"`

	// The name of the source resource for which to enable or modify the add-on.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAddOnInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAddOnInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableAddOnInput"}

	if s.AddOnRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("AddOnRequest"))
	}

	if s.ResourceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceName"))
	}
	if s.AddOnRequest != nil {
		if err := s.AddOnRequest.Validate(); err != nil {
			invalidParams.AddNested("AddOnRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableAddOnOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of your request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s EnableAddOnOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableAddOn = "EnableAddOn"

// EnableAddOnRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Enables or modifies an add-on for an Amazon Lightsail resource. For more
// information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
//
//    // Example sending a request using EnableAddOnRequest.
//    req := client.EnableAddOnRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn
func (c *Client) EnableAddOnRequest(input *EnableAddOnInput) EnableAddOnRequest {
	op := &aws.Operation{
		Name:       opEnableAddOn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAddOnInput{}
	}

	req := c.newRequest(op, input, &EnableAddOnOutput{})
	return EnableAddOnRequest{Request: req, Input: input, Copy: c.EnableAddOnRequest}
}

// EnableAddOnRequest is the request type for the
// EnableAddOn API operation.
type EnableAddOnRequest struct {
	*aws.Request
	Input *EnableAddOnInput
	Copy  func(*EnableAddOnInput) EnableAddOnRequest
}

// Send marshals and sends the EnableAddOn API request.
func (r EnableAddOnRequest) Send(ctx context.Context) (*EnableAddOnResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableAddOnResponse{
		EnableAddOnOutput: r.Request.Data.(*EnableAddOnOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableAddOnResponse is the response type for the
// EnableAddOn API operation.
type EnableAddOnResponse struct {
	*EnableAddOnOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableAddOn request.
func (r *EnableAddOnResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
