// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The configuration for the agent to use.
type AgentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the period to follow the configuration (to profile or not) and
	// call back to get a new configuration.
	//
	// PeriodInSeconds is a required field
	PeriodInSeconds *int64 `locationName:"periodInSeconds" type:"integer" required:"true"`

	// Specifies if the profiling should be enabled by the agent.
	//
	// ShouldProfile is a required field
	ShouldProfile *bool `locationName:"shouldProfile" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AgentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.PeriodInSeconds != nil {
		v := *s.PeriodInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "periodInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.ShouldProfile != nil {
		v := *s.ShouldProfile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shouldProfile", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Configuration to orchestrate agents to create and report agent profiles of
// the profiling group. Agents are orchestrated if they follow the agent orchestration
// protocol.
type AgentOrchestrationConfig struct {
	_ struct{} `type:"structure"`

	// If the agents should be enabled to create and report profiles.
	//
	// ProfilingEnabled is a required field
	ProfilingEnabled *bool `locationName:"profilingEnabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s AgentOrchestrationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentOrchestrationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AgentOrchestrationConfig"}

	if s.ProfilingEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AgentOrchestrationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProfilingEnabled != nil {
		v := *s.ProfilingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profilingEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The time range of an aggregated profile.
type AggregatedProfileTime struct {
	_ struct{} `type:"structure"`

	// The aggregation period of the aggregated profile.
	Period AggregationPeriod `locationName:"period" type:"string" enum:"true"`

	// The start time of the aggregated profile.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AggregatedProfileTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AggregatedProfileTime) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Period) > 0 {
		v := s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "period", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Periods of time used for aggregation of profiles, represented using ISO 8601
// format.
type ProfileTime struct {
	_ struct{} `type:"structure"`

	// The start time of the profile.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfileTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfileTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The description of a profiling group.
type ProfilingGroupDescription struct {
	_ struct{} `type:"structure"`

	// Configuration to orchestrate agents to create and report agent profiles of
	// the profiling group. Agents are orchestrated if they follow the agent orchestration
	// protocol.
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure"`

	// The ARN of the profiling group.
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp of when the profiling group was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the profiling group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of profiling of a profiling group.
	ProfilingStatus *ProfilingStatus `locationName:"profilingStatus" type:"structure"`

	// The timestamp of when the profiling group was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ProfilingGroupDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfilingGroupDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AgentOrchestrationConfig != nil {
		v := s.AgentOrchestrationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "agentOrchestrationConfig", v, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfilingStatus != nil {
		v := s.ProfilingStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "profilingStatus", v, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The status of profiling of a profiling group.
type ProfilingStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the last interaction of the agent with configureAgent API
	// for orchestration.
	LatestAgentOrchestratedAt *time.Time `locationName:"latestAgentOrchestratedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Timestamp of when the latest agent profile was successfully reported.
	LatestAgentProfileReportedAt *time.Time `locationName:"latestAgentProfileReportedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The time range of latest aggregated profile available.
	LatestAggregatedProfile *AggregatedProfileTime `locationName:"latestAggregatedProfile" type:"structure"`
}

// String returns the string representation
func (s ProfilingStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProfilingStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.LatestAgentOrchestratedAt != nil {
		v := *s.LatestAgentOrchestratedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latestAgentOrchestratedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LatestAgentProfileReportedAt != nil {
		v := *s.LatestAgentProfileReportedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "latestAgentProfileReportedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LatestAggregatedProfile != nil {
		v := s.LatestAggregatedProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "latestAggregatedProfile", v, metadata)
	}
	return nil
}
