// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The log pattern.
	//
	// Pattern is a required field
	Pattern *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// Rank of the log pattern.
	//
	// Rank is a required field
	Rank *int64 `type:"integer" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogPatternInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLogPatternInput"}

	if s.Pattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Pattern", 1))
	}

	if s.PatternName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternName", 1))
	}

	if s.PatternSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternSetName", 1))
	}

	if s.Rank == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rank"))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateLogPatternOutput struct {
	_ struct{} `type:"structure"`

	// The successfully created log pattern.
	LogPattern *LogPattern `type:"structure"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLogPattern = "CreateLogPattern"

// CreateLogPatternRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Adds an log pattern to a LogPatternSet.
//
//    // Example sending a request using CreateLogPatternRequest.
//    req := client.CreateLogPatternRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateLogPattern
func (c *Client) CreateLogPatternRequest(input *CreateLogPatternInput) CreateLogPatternRequest {
	op := &aws.Operation{
		Name:       opCreateLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogPatternInput{}
	}

	req := c.newRequest(op, input, &CreateLogPatternOutput{})
	return CreateLogPatternRequest{Request: req, Input: input, Copy: c.CreateLogPatternRequest}
}

// CreateLogPatternRequest is the request type for the
// CreateLogPattern API operation.
type CreateLogPatternRequest struct {
	*aws.Request
	Input *CreateLogPatternInput
	Copy  func(*CreateLogPatternInput) CreateLogPatternRequest
}

// Send marshals and sends the CreateLogPattern API request.
func (r CreateLogPatternRequest) Send(ctx context.Context) (*CreateLogPatternResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLogPatternResponse{
		CreateLogPatternOutput: r.Request.Data.(*CreateLogPatternOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLogPatternResponse is the response type for the
// CreateLogPattern API operation.
type CreateLogPatternResponse struct {
	*CreateLogPatternOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLogPattern request.
func (r *CreateLogPatternResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
