// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCostAndUsageInput struct {
	_ struct{} `type:"structure"`

	// Filters AWS costs by different dimensions. For example, you can specify SERVICE
	// and LINKED_ACCOUNT and get the costs that are associated with that account's
	// usage of that service. You can nest Expression objects to define any combination
	// of dimension filters. For more information, see Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
	Filter *Expression `type:"structure"`

	// Sets the AWS cost granularity to MONTHLY or DAILY, or HOURLY. If Granularity
	// isn't set, the response object doesn't include the Granularity, either MONTHLY
	// or DAILY, or HOURLY.
	Granularity Granularity `type:"string" enum:"true"`

	// You can group AWS costs using up to two different groups, either dimensions,
	// tag keys, or both.
	//
	// When you group by tag key, you get all tag values, including empty strings.
	//
	// Valid values are AZ, INSTANCE_TYPE, LEGAL_ENTITY_NAME, LINKED_ACCOUNT, OPERATION,
	// PLATFORM, PURCHASE_TYPE, SERVICE, TAGS, TENANCY, RECORD_TYPE, and USAGE_TYPE.
	GroupBy []GroupDefinition `type:"list"`

	// Which metrics are returned in the query. For more information about blended
	// and unblended rates, see Why does the "blended" annotation appear on some
	// line items in my bill? (https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/).
	//
	// Valid values are AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
	// NormalizedUsageAmount, UnblendedCost, and UsageQuantity.
	//
	// If you return the UsageQuantity metric, the service aggregates all usage
	// numbers without taking into account the units. For example, if you aggregate
	// usageQuantity across all of Amazon EC2, the results aren't meaningful because
	// Amazon EC2 compute hours and data transfer are measured in different units
	// (for example, hours vs. GB). To get more meaningful UsageQuantity metrics,
	// filter by UsageType or UsageTypeGroups.
	//
	// Metrics is required for GetCostAndUsage requests.
	Metrics []string `type:"list"`

	// The token to retrieve the next set of results. AWS provides the token when
	// the response from a previous call has more results than the maximum page
	// size.
	NextPageToken *string `type:"string"`

	// Sets the start and end dates for retrieving AWS costs. The start date is
	// inclusive, but the end date is exclusive. For example, if start is 2017-01-01
	// and end is 2017-05-01, then the cost and usage data is retrieved from 2017-01-01
	// up to and including 2017-04-30 but not including 2017-05-01.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCostAndUsageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCostAndUsageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCostAndUsageInput"}

	if s.TimePeriod == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCostAndUsageOutput struct {
	_ struct{} `type:"structure"`

	// The groups that are specified by the Filter or GroupBy parameters in the
	// request.
	GroupDefinitions []GroupDefinition `type:"list"`

	// The token for the next set of retrievable results. AWS provides the token
	// when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string `type:"string"`

	// The time period that is covered by the results in the response.
	ResultsByTime []ResultByTime `type:"list"`
}

// String returns the string representation
func (s GetCostAndUsageOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCostAndUsage = "GetCostAndUsage"

// GetCostAndUsageRequest returns a request value for making API operation for
// AWS Cost Explorer Service.
//
// Retrieves cost and usage metrics for your account. You can specify which
// cost and usage-related metric, such as BlendedCosts or UsageQuantity, that
// you want the request to return. You can also filter and group your data by
// various dimensions, such as SERVICE or AZ, in a specific time range. For
// a complete list of valid dimensions, see the GetDimensionValues (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html)
// operation. Master accounts in an organization in AWS Organizations have access
// to all member accounts.
//
//    // Example sending a request using GetCostAndUsageRequest.
//    req := client.GetCostAndUsageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetCostAndUsage
func (c *Client) GetCostAndUsageRequest(input *GetCostAndUsageInput) GetCostAndUsageRequest {
	op := &aws.Operation{
		Name:       opGetCostAndUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCostAndUsageInput{}
	}

	req := c.newRequest(op, input, &GetCostAndUsageOutput{})
	return GetCostAndUsageRequest{Request: req, Input: input, Copy: c.GetCostAndUsageRequest}
}

// GetCostAndUsageRequest is the request type for the
// GetCostAndUsage API operation.
type GetCostAndUsageRequest struct {
	*aws.Request
	Input *GetCostAndUsageInput
	Copy  func(*GetCostAndUsageInput) GetCostAndUsageRequest
}

// Send marshals and sends the GetCostAndUsage API request.
func (r GetCostAndUsageRequest) Send(ctx context.Context) (*GetCostAndUsageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCostAndUsageResponse{
		GetCostAndUsageOutput: r.Request.Data.(*GetCostAndUsageOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCostAndUsageResponse is the response type for the
// GetCostAndUsage API operation.
type GetCostAndUsageResponse struct {
	*GetCostAndUsageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCostAndUsage request.
func (r *GetCostAndUsageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
