// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecycleHookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLifecycleHookInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.LifecycleHookName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLifecycleHook = "DeleteLifecycleHook"

// DeleteLifecycleHookRequest returns a request value for making API operation for
// Auto Scaling.
//
// Deletes the specified lifecycle hook.
//
// If there are any outstanding lifecycle actions, they are completed first
// (ABANDON for launching instances, CONTINUE for terminating instances).
//
//    // Example sending a request using DeleteLifecycleHookRequest.
//    req := client.DeleteLifecycleHookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook
func (c *Client) DeleteLifecycleHookRequest(input *DeleteLifecycleHookInput) DeleteLifecycleHookRequest {
	op := &aws.Operation{
		Name:       opDeleteLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLifecycleHookInput{}
	}

	req := c.newRequest(op, input, &DeleteLifecycleHookOutput{})
	return DeleteLifecycleHookRequest{Request: req, Input: input, Copy: c.DeleteLifecycleHookRequest}
}

// DeleteLifecycleHookRequest is the request type for the
// DeleteLifecycleHook API operation.
type DeleteLifecycleHookRequest struct {
	*aws.Request
	Input *DeleteLifecycleHookInput
	Copy  func(*DeleteLifecycleHookInput) DeleteLifecycleHookRequest
}

// Send marshals and sends the DeleteLifecycleHook API request.
func (r DeleteLifecycleHookRequest) Send(ctx context.Context) (*DeleteLifecycleHookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLifecycleHookResponse{
		DeleteLifecycleHookOutput: r.Request.Data.(*DeleteLifecycleHookOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLifecycleHookResponse is the response type for the
// DeleteLifecycleHook API operation.
type DeleteLifecycleHookResponse struct {
	*DeleteLifecycleHookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLifecycleHook request.
func (r *DeleteLifecycleHookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
