// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

type ListRateBasedRulesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of Rules that you want AWS WAF to return for this request.
	// If you have more Rules than the number that you specify for Limit, the response
	// includes a NextMarker value that you can use to get another batch of Rules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more Rules than the value of
	// Limit, AWS WAF returns a NextMarker value in the response that allows you
	// to list another group of Rules. For the second and subsequent ListRateBasedRules
	// requests, specify the value of NextMarker from the previous response to get
	// information about another batch of Rules.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRateBasedRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRateBasedRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRateBasedRulesInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListRateBasedRulesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more Rules than the number that you specified for Limit in the
	// request, the response includes a NextMarker value. To list more Rules, submit
	// another ListRateBasedRules request, and specify the NextMarker value from
	// the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleSummary objects.
	Rules []waf.RuleSummary `type:"list"`
}

// String returns the string representation
func (s ListRateBasedRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRateBasedRules = "ListRateBasedRules"

// ListRateBasedRulesRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Returns an array of RuleSummary objects.
//
//    // Example sending a request using ListRateBasedRulesRequest.
//    req := client.ListRateBasedRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRateBasedRules
func (c *Client) ListRateBasedRulesRequest(input *ListRateBasedRulesInput) ListRateBasedRulesRequest {
	op := &aws.Operation{
		Name:       opListRateBasedRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRateBasedRulesInput{}
	}

	req := c.newRequest(op, input, &ListRateBasedRulesOutput{})
	return ListRateBasedRulesRequest{Request: req, Input: input, Copy: c.ListRateBasedRulesRequest}
}

// ListRateBasedRulesRequest is the request type for the
// ListRateBasedRules API operation.
type ListRateBasedRulesRequest struct {
	*aws.Request
	Input *ListRateBasedRulesInput
	Copy  func(*ListRateBasedRulesInput) ListRateBasedRulesRequest
}

// Send marshals and sends the ListRateBasedRules API request.
func (r ListRateBasedRulesRequest) Send(ctx context.Context) (*ListRateBasedRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRateBasedRulesResponse{
		ListRateBasedRulesOutput: r.Request.Data.(*ListRateBasedRulesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListRateBasedRulesResponse is the response type for the
// ListRateBasedRules API operation.
type ListRateBasedRulesResponse struct {
	*ListRateBasedRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRateBasedRules request.
func (r *ListRateBasedRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
