// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListCodeRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only Git repositories that were created after the specified
	// time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only Git repositories that were created before the
	// specified time.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// A filter that returns only Git repositories that were last modified after
	// the specified time.
	LastModifiedTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only Git repositories that were last modified before
	// the specified time.
	LastModifiedTimeBefore *time.Time `type:"timestamp"`

	// The maximum number of Git repositories to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the Git repositories name. This filter returns only repositories
	// whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the result of a ListCodeRepositoriesOutput request was truncated, the
	// response includes a NextToken. To get the next set of Git repositories, use
	// the token in the next request.
	NextToken *string `type:"string"`

	// The field to sort results by. The default is Name.
	SortBy CodeRepositorySortBy `type:"string" enum:"true"`

	// The sort order for results. The default is Ascending.
	SortOrder CodeRepositorySortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListCodeRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCodeRepositoriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCodeRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCodeRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// Gets a list of summaries of the Git repositories. Each summary specifies
	// the following values for the repository:
	//
	//    * Name
	//
	//    * Amazon Resource Name (ARN)
	//
	//    * Creation time
	//
	//    * Last modified time
	//
	//    * Configuration information, including the URL location of the repository
	//    and the ARN of the AWS Secrets Manager secret that contains the credentials
	//    used to access the repository.
	//
	// CodeRepositorySummaryList is a required field
	CodeRepositorySummaryList []CodeRepositorySummary `type:"list" required:"true"`

	// If the result of a ListCodeRepositoriesOutput request was truncated, the
	// response includes a NextToken. To get the next set of Git repositories, use
	// the token in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCodeRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCodeRepositories = "ListCodeRepositories"

// ListCodeRepositoriesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Gets a list of the Git repositories in your account.
//
//    // Example sending a request using ListCodeRepositoriesRequest.
//    req := client.ListCodeRepositoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories
func (c *Client) ListCodeRepositoriesRequest(input *ListCodeRepositoriesInput) ListCodeRepositoriesRequest {
	op := &aws.Operation{
		Name:       opListCodeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCodeRepositoriesInput{}
	}

	req := c.newRequest(op, input, &ListCodeRepositoriesOutput{})
	return ListCodeRepositoriesRequest{Request: req, Input: input, Copy: c.ListCodeRepositoriesRequest}
}

// ListCodeRepositoriesRequest is the request type for the
// ListCodeRepositories API operation.
type ListCodeRepositoriesRequest struct {
	*aws.Request
	Input *ListCodeRepositoriesInput
	Copy  func(*ListCodeRepositoriesInput) ListCodeRepositoriesRequest
}

// Send marshals and sends the ListCodeRepositories API request.
func (r ListCodeRepositoriesRequest) Send(ctx context.Context) (*ListCodeRepositoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCodeRepositoriesResponse{
		ListCodeRepositoriesOutput: r.Request.Data.(*ListCodeRepositoriesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCodeRepositoriesRequestPaginator returns a paginator for ListCodeRepositories.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCodeRepositoriesRequest(input)
//   p := sagemaker.NewListCodeRepositoriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCodeRepositoriesPaginator(req ListCodeRepositoriesRequest) ListCodeRepositoriesPaginator {
	return ListCodeRepositoriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCodeRepositoriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCodeRepositoriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCodeRepositoriesPaginator struct {
	aws.Pager
}

func (p *ListCodeRepositoriesPaginator) CurrentPage() *ListCodeRepositoriesOutput {
	return p.Pager.CurrentPage().(*ListCodeRepositoriesOutput)
}

// ListCodeRepositoriesResponse is the response type for the
// ListCodeRepositories API operation.
type ListCodeRepositoriesResponse struct {
	*ListCodeRepositoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCodeRepositories request.
func (r *ListCodeRepositoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
