// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyClusterDbRevisionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose database revision you want to modify.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the database revision. You can retrieve this value from
	// the response to the DescribeClusterDbRevisions request.
	//
	// RevisionTarget is a required field
	RevisionTarget *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyClusterDbRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterDbRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyClusterDbRevisionInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if s.RevisionTarget == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionTarget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyClusterDbRevisionOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterDbRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyClusterDbRevision = "ModifyClusterDbRevision"

// ModifyClusterDbRevisionRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies the database revision of a cluster. The database revision is a unique
// revision of the database running in a cluster.
//
//    // Example sending a request using ModifyClusterDbRevisionRequest.
//    req := client.ModifyClusterDbRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision
func (c *Client) ModifyClusterDbRevisionRequest(input *ModifyClusterDbRevisionInput) ModifyClusterDbRevisionRequest {
	op := &aws.Operation{
		Name:       opModifyClusterDbRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterDbRevisionInput{}
	}

	req := c.newRequest(op, input, &ModifyClusterDbRevisionOutput{})
	return ModifyClusterDbRevisionRequest{Request: req, Input: input, Copy: c.ModifyClusterDbRevisionRequest}
}

// ModifyClusterDbRevisionRequest is the request type for the
// ModifyClusterDbRevision API operation.
type ModifyClusterDbRevisionRequest struct {
	*aws.Request
	Input *ModifyClusterDbRevisionInput
	Copy  func(*ModifyClusterDbRevisionInput) ModifyClusterDbRevisionRequest
}

// Send marshals and sends the ModifyClusterDbRevision API request.
func (r ModifyClusterDbRevisionRequest) Send(ctx context.Context) (*ModifyClusterDbRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyClusterDbRevisionResponse{
		ModifyClusterDbRevisionOutput: r.Request.Data.(*ModifyClusterDbRevisionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyClusterDbRevisionResponse is the response type for the
// ModifyClusterDbRevision API operation.
type ModifyClusterDbRevisionResponse struct {
	*ModifyClusterDbRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyClusterDbRevision request.
func (r *ModifyClusterDbRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
