// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A string with a length between [0-32768].
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateModelInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Schema == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelId != nil {
		v := *s.ModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateModel = "CreateModel"

// CreateModelRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Creates a Model for an API.
//
//    // Example sending a request using CreateModelRequest.
//    req := client.CreateModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateModel
func (c *Client) CreateModelRequest(input *CreateModelInput) CreateModelRequest {
	op := &aws.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/models",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	req := c.newRequest(op, input, &CreateModelOutput{})
	return CreateModelRequest{Request: req, Input: input, Copy: c.CreateModelRequest}
}

// CreateModelRequest is the request type for the
// CreateModel API operation.
type CreateModelRequest struct {
	*aws.Request
	Input *CreateModelInput
	Copy  func(*CreateModelInput) CreateModelRequest
}

// Send marshals and sends the CreateModel API request.
func (r CreateModelRequest) Send(ctx context.Context) (*CreateModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateModelResponse{
		CreateModelOutput: r.Request.Data.(*CreateModelOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateModelResponse is the response type for the
// CreateModel API operation.
type CreateModelResponse struct {
	*CreateModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateModel request.
func (r *CreateModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
