// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	// Describes a single backup.
	BackupId *string `type:"string"`

	// This is not currently implemented for DescribeBackups requests.
	MaxResults *int64 `min:"1" type:"integer"`

	// This is not currently implemented for DescribeBackups requests.
	NextToken *string `type:"string"`

	// Returns backups for the server with the specified ServerName.
	ServerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to a DescribeBackups request.
	Backups []Backup `type:"list"`

	// This is not currently implemented for DescribeBackups requests.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Describes backups. The results are ordered by time, with newest backups first.
// If you do not specify a BackupId or ServerName, the command returns all backups.
//
// This operation is synchronous.
//
// A ResourceNotFoundException is thrown when the backup does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
//    // Example sending a request using DescribeBackupsRequest.
//    req := client.DescribeBackupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups
func (c *Client) DescribeBackupsRequest(input *DescribeBackupsInput) DescribeBackupsRequest {
	op := &aws.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	req := c.newRequest(op, input, &DescribeBackupsOutput{})
	return DescribeBackupsRequest{Request: req, Input: input, Copy: c.DescribeBackupsRequest}
}

// DescribeBackupsRequest is the request type for the
// DescribeBackups API operation.
type DescribeBackupsRequest struct {
	*aws.Request
	Input *DescribeBackupsInput
	Copy  func(*DescribeBackupsInput) DescribeBackupsRequest
}

// Send marshals and sends the DescribeBackups API request.
func (r DescribeBackupsRequest) Send(ctx context.Context) (*DescribeBackupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBackupsResponse{
		DescribeBackupsOutput: r.Request.Data.(*DescribeBackupsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBackupsResponse is the response type for the
// DescribeBackups API operation.
type DescribeBackupsResponse struct {
	*DescribeBackupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBackups request.
func (r *DescribeBackupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
