// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartOutboundVoiceContactInput struct {
	_ struct{} `type:"structure"`

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like
	// any other contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]string `type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. The token is valid for 7 days after creation. If a contact
	// is already started, the contact ID is returned. If the contact is disconnected,
	// a new contact is started.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier of the contact flow for the outbound call.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The phone number of the customer, in E.164 format.
	//
	// DestinationPhoneNumber is a required field
	DestinationPhoneNumber *string `type:"string" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The queue for the call. If you specify a queue, the phone displayed for caller
	// ID is the phone number specified in the queue. If you do not specify a queue,
	// the queue defined in the contact flow is used. If you do not specify a queue,
	// you must specify a source phone number.
	QueueId *string `type:"string"`

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	SourcePhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOutboundVoiceContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartOutboundVoiceContactInput"}

	if s.ContactFlowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactFlowId"))
	}

	if s.DestinationPhoneNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationPhoneNumber"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartOutboundVoiceContactInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContactFlowId != nil {
		v := *s.ContactFlowId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactFlowId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationPhoneNumber != nil {
		v := *s.DestinationPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueueId != nil {
		v := *s.QueueId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueueId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourcePhoneNumber != nil {
		v := *s.SourcePhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourcePhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartOutboundVoiceContactOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartOutboundVoiceContactOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartOutboundVoiceContact = "StartOutboundVoiceContact"

// StartOutboundVoiceContactRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Initiates a contact flow to place an outbound call to a customer.
//
// There is a 60 second dialing timeout for this operation. If the call is not
// connected after 60 seconds, it fails.
//
//    // Example sending a request using StartOutboundVoiceContactRequest.
//    req := client.StartOutboundVoiceContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Client) StartOutboundVoiceContactRequest(input *StartOutboundVoiceContactInput) StartOutboundVoiceContactRequest {
	op := &aws.Operation{
		Name:       opStartOutboundVoiceContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/outbound-voice",
	}

	if input == nil {
		input = &StartOutboundVoiceContactInput{}
	}

	req := c.newRequest(op, input, &StartOutboundVoiceContactOutput{})
	return StartOutboundVoiceContactRequest{Request: req, Input: input, Copy: c.StartOutboundVoiceContactRequest}
}

// StartOutboundVoiceContactRequest is the request type for the
// StartOutboundVoiceContact API operation.
type StartOutboundVoiceContactRequest struct {
	*aws.Request
	Input *StartOutboundVoiceContactInput
	Copy  func(*StartOutboundVoiceContactInput) StartOutboundVoiceContactRequest
}

// Send marshals and sends the StartOutboundVoiceContact API request.
func (r StartOutboundVoiceContactRequest) Send(ctx context.Context) (*StartOutboundVoiceContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartOutboundVoiceContactResponse{
		StartOutboundVoiceContactOutput: r.Request.Data.(*StartOutboundVoiceContactOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartOutboundVoiceContactResponse is the response type for the
// StartOutboundVoiceContact API operation.
type StartOutboundVoiceContactResponse struct {
	*StartOutboundVoiceContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartOutboundVoiceContact request.
func (r *StartOutboundVoiceContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
