// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakera2iruntime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// The name of the human loop you want to delete.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `location:"uri" locationName:"HumanLoopName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHumanLoopInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHumanLoopInput"}

	if s.HumanLoopName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHumanLoopInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.HumanLoopName != nil {
		v := *s.HumanLoopName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "HumanLoopName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteHumanLoopOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHumanLoopOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteHumanLoop = "DeleteHumanLoop"

// DeleteHumanLoopRequest returns a request value for making API operation for
// Amazon Augmented AI Runtime.
//
// Deletes the specified human loop for a flow definition.
//
//    // Example sending a request using DeleteHumanLoopRequest.
//    req := client.DeleteHumanLoopRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop
func (c *Client) DeleteHumanLoopRequest(input *DeleteHumanLoopInput) DeleteHumanLoopRequest {
	op := &aws.Operation{
		Name:       opDeleteHumanLoop,
		HTTPMethod: "DELETE",
		HTTPPath:   "/human-loops/{HumanLoopName}",
	}

	if input == nil {
		input = &DeleteHumanLoopInput{}
	}

	req := c.newRequest(op, input, &DeleteHumanLoopOutput{})
	return DeleteHumanLoopRequest{Request: req, Input: input, Copy: c.DeleteHumanLoopRequest}
}

// DeleteHumanLoopRequest is the request type for the
// DeleteHumanLoop API operation.
type DeleteHumanLoopRequest struct {
	*aws.Request
	Input *DeleteHumanLoopInput
	Copy  func(*DeleteHumanLoopInput) DeleteHumanLoopRequest
}

// Send marshals and sends the DeleteHumanLoop API request.
func (r DeleteHumanLoopRequest) Send(ctx context.Context) (*DeleteHumanLoopResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHumanLoopResponse{
		DeleteHumanLoopOutput: r.Request.Data.(*DeleteHumanLoopOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHumanLoopResponse is the response type for the
// DeleteHumanLoop API operation.
type DeleteHumanLoopResponse struct {
	*DeleteHumanLoopOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHumanLoop request.
func (r *DeleteHumanLoopResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
