// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account where you want to create the dashboard.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Options for publishing the dashboard when you create it:
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This status can be either
	//    ENABLED or DISABLED. When this is set to DISABLED, QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    ad hoc (one-time) filtering. This option is ENABLED by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This status can be either
	//    ENABLED or DISABLED. The visual option to export data to .csv format isn't
	//    enabled when this is set to DISABLED. This option is ENABLED by default.
	//
	//    * VisibilityState for SheetControlsOption - This visibility state can
	//    be either COLLAPSED or EXPANDED. The sheet controls pane is collapsed
	//    by default when set to true. This option is COLLAPSED by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the parameters of the dashboard. These are parameter
	// overrides for a dashboard. A dashboard can have any type of parameters, and
	// some parameters might accept multiple values. You can use the dashboard permissions
	// structure described following to override two string parameters that accept
	// multiple values.
	Parameters *Parameters `type:"structure"`

	// A structure that contains the permissions of the dashboard. You can use this
	// structure for granting permissions with principal and action information.
	Permissions []ResourcePermission `min:"1" type:"list"`

	// The source entity from which the dashboard is created. The source entity
	// accepts the Amazon Resource Name (ARN) of the source template or analysis
	// and also references the replacement datasets for the placeholders set when
	// creating the template. The replacement datasets need to follow the same schema
	// as the datasets for which placeholders were created when creating the template.
	//
	// If you are creating a dashboard from a source entity in a different AWS account,
	// use the ARN of the source template.
	//
	// SourceEntity is a required field
	SourceEntity *DashboardSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dashboard.
	Tags []Tag `min:"1" type:"list"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDashboardInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.DashboardId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DashboardId", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Permissions", 1))
	}

	if s.SourceEntity == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDashboardInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DashboardPublishOptions != nil {
		v := s.DashboardPublishOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DashboardPublishOptions", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Parameters != nil {
		v := s.Parameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Parameters", v, metadata)
	}
	if s.Permissions != nil {
		v := s.Permissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Permissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceEntity != nil {
		v := s.SourceEntity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceEntity", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersionDescription != nil {
		v := *s.VersionDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	Arn *string `type:"string"`

	// The status of the dashboard creation request.
	CreationStatus ResourceStatus `type:"string" enum:"true"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ARN of the dashboard, including the version number of the first version
	// that is created.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDashboardOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CreationStatus) > 0 {
		v := s.CreationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DashboardId != nil {
		v := *s.DashboardId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DashboardId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionArn != nil {
		v := *s.VersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Creates a dashboard from a template. To first create a template, see the
// CreateTemplate API operation.
//
// A dashboard is an entity in QuickSight that identifies QuickSight reports,
// created from analyses. You can share QuickSight dashboards. With the right
// permissions, you can create scheduled email reports from them. The CreateDashboard,
// DescribeDashboard, and ListDashboardsByUser API operations act on the dashboard
// entity. If you have the correct permissions, you can create a dashboard from
// a template that exists in a different AWS account.
//
//    // Example sending a request using CreateDashboardRequest.
//    req := client.CreateDashboardRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *Client) CreateDashboardRequest(input *CreateDashboardInput) CreateDashboardRequest {
	op := &aws.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	req := c.newRequest(op, input, &CreateDashboardOutput{})
	return CreateDashboardRequest{Request: req, Input: input, Copy: c.CreateDashboardRequest}
}

// CreateDashboardRequest is the request type for the
// CreateDashboard API operation.
type CreateDashboardRequest struct {
	*aws.Request
	Input *CreateDashboardInput
	Copy  func(*CreateDashboardInput) CreateDashboardRequest
}

// Send marshals and sends the CreateDashboard API request.
func (r CreateDashboardRequest) Send(ctx context.Context) (*CreateDashboardResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDashboardResponse{
		CreateDashboardOutput: r.Request.Data.(*CreateDashboardOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDashboardResponse is the response type for the
// CreateDashboard API operation.
type CreateDashboardResponse struct {
	*CreateDashboardOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDashboard request.
func (r *CreateDashboardResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
