// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// ListLocationsRequest
type ListLocationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of locations to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// ListLocationsResponse
type ListLocationsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains a list of locations.
	Locations []LocationListEntry `type:"list"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLocations = "ListLocations"

// ListLocationsRequest returns a request value for making API operation for
// AWS DataSync.
//
// Returns a lists of source and destination locations.
//
// If you have more locations than are returned in a response (that is, the
// response returns only a truncated list of your agents), the response contains
// a token that you can specify in your next request to fetch the next page
// of locations.
//
//    // Example sending a request using ListLocationsRequest.
//    req := client.ListLocationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations
func (c *Client) ListLocationsRequest(input *ListLocationsInput) ListLocationsRequest {
	op := &aws.Operation{
		Name:       opListLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLocationsInput{}
	}

	req := c.newRequest(op, input, &ListLocationsOutput{})
	return ListLocationsRequest{Request: req, Input: input, Copy: c.ListLocationsRequest}
}

// ListLocationsRequest is the request type for the
// ListLocations API operation.
type ListLocationsRequest struct {
	*aws.Request
	Input *ListLocationsInput
	Copy  func(*ListLocationsInput) ListLocationsRequest
}

// Send marshals and sends the ListLocations API request.
func (r ListLocationsRequest) Send(ctx context.Context) (*ListLocationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLocationsResponse{
		ListLocationsOutput: r.Request.Data.(*ListLocationsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListLocationsRequestPaginator returns a paginator for ListLocations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListLocationsRequest(input)
//   p := datasync.NewListLocationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListLocationsPaginator(req ListLocationsRequest) ListLocationsPaginator {
	return ListLocationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListLocationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListLocationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListLocationsPaginator struct {
	aws.Pager
}

func (p *ListLocationsPaginator) CurrentPage() *ListLocationsOutput {
	return p.Pager.CurrentPage().(*ListLocationsOutput)
}

// ListLocationsResponse is the response type for the
// ListLocations API operation.
type ListLocationsResponse struct {
	*ListLocationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLocations request.
func (r *ListLocationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
