// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSegmentInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.SegmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "segment-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SegmentResponse != nil {
		v := s.SegmentResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "SegmentResponse", v, metadata)
	}
	return nil
}

const opGetSegment = "GetSegment"

// GetSegmentRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific segment that's associated with an application.
//
//    // Example sending a request using GetSegmentRequest.
//    req := client.GetSegmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Client) GetSegmentRequest(input *GetSegmentInput) GetSegmentRequest {
	op := &aws.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	req := c.newRequest(op, input, &GetSegmentOutput{})
	return GetSegmentRequest{Request: req, Input: input, Copy: c.GetSegmentRequest}
}

// GetSegmentRequest is the request type for the
// GetSegment API operation.
type GetSegmentRequest struct {
	*aws.Request
	Input *GetSegmentInput
	Copy  func(*GetSegmentInput) GetSegmentRequest
}

// Send marshals and sends the GetSegment API request.
func (r GetSegmentRequest) Send(ctx context.Context) (*GetSegmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSegmentResponse{
		GetSegmentOutput: r.Request.Data.(*GetSegmentOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSegmentResponse is the response type for the
// GetSegment API operation.
type GetSegmentResponse struct {
	*GetSegmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSegment request.
func (r *GetSegmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
