// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCapacityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of one or more capacity
	// providers. Up to 100 capacity providers can be described in an action.
	CapacityProviders []string `locationName:"capacityProviders" type:"list"`

	// Specifies whether or not you want to see the resource tags for the capacity
	// provider. If TAGS is specified, the tags are included in the response. If
	// this field is omitted, tags are not included in the response.
	Include []CapacityProviderField `locationName:"include" type:"list"`

	// The maximum number of account setting results returned by DescribeCapacityProviders
	// in paginated output. When this parameter is used, DescribeCapacityProviders
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeCapacityProviders request with the returned nextToken value.
	// This value can be between 1 and 10. If this parameter is not used, then DescribeCapacityProviders
	// returns up to 10 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeCapacityProviders
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCapacityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeCapacityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of capacity providers.
	CapacityProviders []CapacityProvider `locationName:"capacityProviders" type:"list"`

	// Any failures associated with the call.
	Failures []Failure `locationName:"failures" type:"list"`

	// The nextToken value to include in a future DescribeCapacityProviders request.
	// When the results of a DescribeCapacityProviders request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCapacityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCapacityProviders = "DescribeCapacityProviders"

// DescribeCapacityProvidersRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Describes one or more of your capacity providers.
//
//    // Example sending a request using DescribeCapacityProvidersRequest.
//    req := client.DescribeCapacityProvidersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeCapacityProviders
func (c *Client) DescribeCapacityProvidersRequest(input *DescribeCapacityProvidersInput) DescribeCapacityProvidersRequest {
	op := &aws.Operation{
		Name:       opDescribeCapacityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCapacityProvidersInput{}
	}

	req := c.newRequest(op, input, &DescribeCapacityProvidersOutput{})
	return DescribeCapacityProvidersRequest{Request: req, Input: input, Copy: c.DescribeCapacityProvidersRequest}
}

// DescribeCapacityProvidersRequest is the request type for the
// DescribeCapacityProviders API operation.
type DescribeCapacityProvidersRequest struct {
	*aws.Request
	Input *DescribeCapacityProvidersInput
	Copy  func(*DescribeCapacityProvidersInput) DescribeCapacityProvidersRequest
}

// Send marshals and sends the DescribeCapacityProviders API request.
func (r DescribeCapacityProvidersRequest) Send(ctx context.Context) (*DescribeCapacityProvidersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCapacityProvidersResponse{
		DescribeCapacityProvidersOutput: r.Request.Data.(*DescribeCapacityProvidersOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCapacityProvidersResponse is the response type for the
// DescribeCapacityProviders API operation.
type DescribeCapacityProvidersResponse struct {
	*DescribeCapacityProvidersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCapacityProviders request.
func (r *DescribeCapacityProvidersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
