// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetEventsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventsConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEventsConfigurationInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.BotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEventsConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BotId != nil {
		v := *s.BotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "botId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetEventsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The events configuration details.
	EventsConfiguration *EventsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetEventsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEventsConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EventsConfiguration != nil {
		v := s.EventsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventsConfiguration", v, metadata)
	}
	return nil
}

const opGetEventsConfiguration = "GetEventsConfiguration"

// GetEventsConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Gets details for an events configuration that allows a bot to receive outgoing
// events, such as an HTTPS endpoint or Lambda function ARN.
//
//    // Example sending a request using GetEventsConfigurationRequest.
//    req := client.GetEventsConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration
func (c *Client) GetEventsConfigurationRequest(input *GetEventsConfigurationInput) GetEventsConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetEventsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &GetEventsConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetEventsConfigurationOutput{})
	return GetEventsConfigurationRequest{Request: req, Input: input, Copy: c.GetEventsConfigurationRequest}
}

// GetEventsConfigurationRequest is the request type for the
// GetEventsConfiguration API operation.
type GetEventsConfigurationRequest struct {
	*aws.Request
	Input *GetEventsConfigurationInput
	Copy  func(*GetEventsConfigurationInput) GetEventsConfigurationRequest
}

// Send marshals and sends the GetEventsConfiguration API request.
func (r GetEventsConfigurationRequest) Send(ctx context.Context) (*GetEventsConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEventsConfigurationResponse{
		GetEventsConfigurationOutput: r.Request.Data.(*GetEventsConfigurationOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEventsConfigurationResponse is the response type for the
// GetEventsConfiguration API operation.
type GetEventsConfigurationResponse struct {
	*GetEventsConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEventsConfiguration request.
func (r *GetEventsConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
