// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualRouterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVirtualRouterInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}

	if s.VirtualRouterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVirtualRouterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// An object that represents a virtual router returned by a describe operation.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVirtualRouterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualRouter != nil {
		v := s.VirtualRouter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "virtualRouter", v, metadata)
	}
	return nil
}

const opDeleteVirtualRouter = "DeleteVirtualRouter"

// DeleteVirtualRouterRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Deletes an existing virtual router.
//
// You must delete any routes associated with the virtual router before you
// can delete the router itself.
//
//    // Example sending a request using DeleteVirtualRouterRequest.
//    req := client.DeleteVirtualRouterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteVirtualRouter
func (c *Client) DeleteVirtualRouterRequest(input *DeleteVirtualRouterInput) DeleteVirtualRouterRequest {
	op := &aws.Operation{
		Name:       opDeleteVirtualRouter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DeleteVirtualRouterInput{}
	}

	req := c.newRequest(op, input, &DeleteVirtualRouterOutput{})
	return DeleteVirtualRouterRequest{Request: req, Input: input, Copy: c.DeleteVirtualRouterRequest}
}

// DeleteVirtualRouterRequest is the request type for the
// DeleteVirtualRouter API operation.
type DeleteVirtualRouterRequest struct {
	*aws.Request
	Input *DeleteVirtualRouterInput
	Copy  func(*DeleteVirtualRouterInput) DeleteVirtualRouterRequest
}

// Send marshals and sends the DeleteVirtualRouter API request.
func (r DeleteVirtualRouterRequest) Send(ctx context.Context) (*DeleteVirtualRouterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVirtualRouterResponse{
		DeleteVirtualRouterOutput: r.Request.Data.(*DeleteVirtualRouterOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVirtualRouterResponse is the response type for the
// DeleteVirtualRouter API operation.
type DeleteVirtualRouterResponse struct {
	*DeleteVirtualRouterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVirtualRouter request.
func (r *DeleteVirtualRouterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
