// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/security/privateca/v1beta1/resources.proto

package privateca

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A [RevocationReason][google.cloud.security.privateca.v1beta1.RevocationReason] indicates whether a [Certificate][google.cloud.security.privateca.v1beta1.Certificate] has been revoked,
// and the reason for revocation. These correspond to standard revocation
// reasons from RFC 5280. Note that the enum labels and values in this
// definition are not the same ASN.1 values defined in RFC 5280. These values
// will be translated to the correct ASN.1 values when a CRL is created.
type RevocationReason int32

const (
	// Default unspecified value. This value does indicate that a [Certificate][google.cloud.security.privateca.v1beta1.Certificate]
	// has been revoked, but that a reason has not been recorded.
	RevocationReason_REVOCATION_REASON_UNSPECIFIED RevocationReason = 0
	// Key material for this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] may have leaked.
	RevocationReason_KEY_COMPROMISE RevocationReason = 1
	// The key material for a certificate authority in the issuing path may have
	// leaked.
	RevocationReason_CERTIFICATE_AUTHORITY_COMPROMISE RevocationReason = 2
	// The subject or other attributes in this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] have changed.
	RevocationReason_AFFILIATION_CHANGED RevocationReason = 3
	// This [Certificate][google.cloud.security.privateca.v1beta1.Certificate] has been superseded.
	RevocationReason_SUPERSEDED RevocationReason = 4
	// This [Certificate][google.cloud.security.privateca.v1beta1.Certificate] or entities in the issuing path have ceased to
	// operate.
	RevocationReason_CESSATION_OF_OPERATION RevocationReason = 5
	// This [Certificate][google.cloud.security.privateca.v1beta1.Certificate] should not be considered valid, it is expected that it
	// may become valid in the future.
	RevocationReason_CERTIFICATE_HOLD RevocationReason = 6
	// This [Certificate][google.cloud.security.privateca.v1beta1.Certificate] no longer has permission to assert the listed
	// attributes.
	RevocationReason_PRIVILEGE_WITHDRAWN RevocationReason = 7
	// The authority which determines appropriate attributes for a [Certificate][google.cloud.security.privateca.v1beta1.Certificate]
	// may have been compromised.
	RevocationReason_ATTRIBUTE_AUTHORITY_COMPROMISE RevocationReason = 8
)

// Enum value maps for RevocationReason.
var (
	RevocationReason_name = map[int32]string{
		0: "REVOCATION_REASON_UNSPECIFIED",
		1: "KEY_COMPROMISE",
		2: "CERTIFICATE_AUTHORITY_COMPROMISE",
		3: "AFFILIATION_CHANGED",
		4: "SUPERSEDED",
		5: "CESSATION_OF_OPERATION",
		6: "CERTIFICATE_HOLD",
		7: "PRIVILEGE_WITHDRAWN",
		8: "ATTRIBUTE_AUTHORITY_COMPROMISE",
	}
	RevocationReason_value = map[string]int32{
		"REVOCATION_REASON_UNSPECIFIED":    0,
		"KEY_COMPROMISE":                   1,
		"CERTIFICATE_AUTHORITY_COMPROMISE": 2,
		"AFFILIATION_CHANGED":              3,
		"SUPERSEDED":                       4,
		"CESSATION_OF_OPERATION":           5,
		"CERTIFICATE_HOLD":                 6,
		"PRIVILEGE_WITHDRAWN":              7,
		"ATTRIBUTE_AUTHORITY_COMPROMISE":   8,
	}
)

func (x RevocationReason) Enum() *RevocationReason {
	p := new(RevocationReason)
	*p = x
	return p
}

func (x RevocationReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RevocationReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[0].Descriptor()
}

func (RevocationReason) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[0]
}

func (x RevocationReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RevocationReason.Descriptor instead.
func (RevocationReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

// The type of a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], indicating its issuing chain.
type CertificateAuthority_Type int32

const (
	// Not specified.
	CertificateAuthority_TYPE_UNSPECIFIED CertificateAuthority_Type = 0
	// Self-signed CA.
	CertificateAuthority_SELF_SIGNED CertificateAuthority_Type = 1
	// Subordinate CA. Could be issued by a Private CA [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
	// or an unmanaged CA.
	CertificateAuthority_SUBORDINATE CertificateAuthority_Type = 2
)

// Enum value maps for CertificateAuthority_Type.
var (
	CertificateAuthority_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SELF_SIGNED",
		2: "SUBORDINATE",
	}
	CertificateAuthority_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SELF_SIGNED":      1,
		"SUBORDINATE":      2,
	}
)

func (x CertificateAuthority_Type) Enum() *CertificateAuthority_Type {
	p := new(CertificateAuthority_Type)
	*p = x
	return p
}

func (x CertificateAuthority_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[1].Descriptor()
}

func (CertificateAuthority_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[1]
}

func (x CertificateAuthority_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_Type.Descriptor instead.
func (CertificateAuthority_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The tier of a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], indicating its supported
// functionality and/or billing SKU.
type CertificateAuthority_Tier int32

const (
	// Not specified.
	CertificateAuthority_TIER_UNSPECIFIED CertificateAuthority_Tier = 0
	// Enterprise tier.
	CertificateAuthority_ENTERPRISE CertificateAuthority_Tier = 1
	// DevOps tier.
	CertificateAuthority_DEVOPS CertificateAuthority_Tier = 2
)

// Enum value maps for CertificateAuthority_Tier.
var (
	CertificateAuthority_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "ENTERPRISE",
		2: "DEVOPS",
	}
	CertificateAuthority_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"ENTERPRISE":       1,
		"DEVOPS":           2,
	}
)

func (x CertificateAuthority_Tier) Enum() *CertificateAuthority_Tier {
	p := new(CertificateAuthority_Tier)
	*p = x
	return p
}

func (x CertificateAuthority_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[2].Descriptor()
}

func (CertificateAuthority_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[2]
}

func (x CertificateAuthority_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_Tier.Descriptor instead.
func (CertificateAuthority_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// The state of a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], indicating if it can be used.
type CertificateAuthority_State int32

const (
	// Not specified.
	CertificateAuthority_STATE_UNSPECIFIED CertificateAuthority_State = 0
	// Certificates can be issued from this CA. CRLs will be generated for this
	// CA.
	CertificateAuthority_ENABLED CertificateAuthority_State = 1
	// Certificates cannot be issued from this CA. CRLs will still be generated.
	CertificateAuthority_DISABLED CertificateAuthority_State = 2
	// Certificates cannot be issued from this CA. CRLs will not be generated.
	CertificateAuthority_PENDING_ACTIVATION CertificateAuthority_State = 3
	// Certificates cannot be issued from this CA. CRLs will not be generated.
	CertificateAuthority_PENDING_DELETION CertificateAuthority_State = 4
)

// Enum value maps for CertificateAuthority_State.
var (
	CertificateAuthority_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "PENDING_ACTIVATION",
		4: "PENDING_DELETION",
	}
	CertificateAuthority_State_value = map[string]int32{
		"STATE_UNSPECIFIED":  0,
		"ENABLED":            1,
		"DISABLED":           2,
		"PENDING_ACTIVATION": 3,
		"PENDING_DELETION":   4,
	}
)

func (x CertificateAuthority_State) Enum() *CertificateAuthority_State {
	p := new(CertificateAuthority_State)
	*p = x
	return p
}

func (x CertificateAuthority_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[3].Descriptor()
}

func (CertificateAuthority_State) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[3]
}

func (x CertificateAuthority_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_State.Descriptor instead.
func (CertificateAuthority_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 2}
}

// The algorithm of a Cloud KMS CryptoKeyVersion of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey] with the
// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose] value
// `ASYMMETRIC_SIGN`. These values correspond to the
// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
// values. For RSA signing algorithms, the PSS algorithms should be preferred,
// use PKCS1 algorithms if required for compatibility. For further
// recommandations, see
// https://cloud.google.com/kms/docs/algorithms#algorithm_recommendations.
type CertificateAuthority_SignHashAlgorithm int32

const (
	// Not specified.
	CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED CertificateAuthority_SignHashAlgorithm = 0
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256
	CertificateAuthority_RSA_PSS_2048_SHA256 CertificateAuthority_SignHashAlgorithm = 1
	// maps to CryptoKeyVersionAlgorithm. RSA_SIGN_PSS_3072_SHA256
	CertificateAuthority_RSA_PSS_3072_SHA256 CertificateAuthority_SignHashAlgorithm = 2
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_4096_SHA256
	CertificateAuthority_RSA_PSS_4096_SHA256 CertificateAuthority_SignHashAlgorithm = 3
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_2048_SHA256
	CertificateAuthority_RSA_PKCS1_2048_SHA256 CertificateAuthority_SignHashAlgorithm = 6
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_3072_SHA256
	CertificateAuthority_RSA_PKCS1_3072_SHA256 CertificateAuthority_SignHashAlgorithm = 7
	// maps to CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_4096_SHA256
	CertificateAuthority_RSA_PKCS1_4096_SHA256 CertificateAuthority_SignHashAlgorithm = 8
	// maps to CryptoKeyVersionAlgorithm.EC_SIGN_P256_SHA256
	CertificateAuthority_EC_P256_SHA256 CertificateAuthority_SignHashAlgorithm = 4
	// maps to CryptoKeyVersionAlgorithm.EC_SIGN_P384_SHA384
	CertificateAuthority_EC_P384_SHA384 CertificateAuthority_SignHashAlgorithm = 5
)

// Enum value maps for CertificateAuthority_SignHashAlgorithm.
var (
	CertificateAuthority_SignHashAlgorithm_name = map[int32]string{
		0: "SIGN_HASH_ALGORITHM_UNSPECIFIED",
		1: "RSA_PSS_2048_SHA256",
		2: "RSA_PSS_3072_SHA256",
		3: "RSA_PSS_4096_SHA256",
		6: "RSA_PKCS1_2048_SHA256",
		7: "RSA_PKCS1_3072_SHA256",
		8: "RSA_PKCS1_4096_SHA256",
		4: "EC_P256_SHA256",
		5: "EC_P384_SHA384",
	}
	CertificateAuthority_SignHashAlgorithm_value = map[string]int32{
		"SIGN_HASH_ALGORITHM_UNSPECIFIED": 0,
		"RSA_PSS_2048_SHA256":             1,
		"RSA_PSS_3072_SHA256":             2,
		"RSA_PSS_4096_SHA256":             3,
		"RSA_PKCS1_2048_SHA256":           6,
		"RSA_PKCS1_3072_SHA256":           7,
		"RSA_PKCS1_4096_SHA256":           8,
		"EC_P256_SHA256":                  4,
		"EC_P384_SHA384":                  5,
	}
)

func (x CertificateAuthority_SignHashAlgorithm) Enum() *CertificateAuthority_SignHashAlgorithm {
	p := new(CertificateAuthority_SignHashAlgorithm)
	*p = x
	return p
}

func (x CertificateAuthority_SignHashAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateAuthority_SignHashAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[4].Descriptor()
}

func (CertificateAuthority_SignHashAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[4]
}

func (x CertificateAuthority_SignHashAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateAuthority_SignHashAlgorithm.Descriptor instead.
func (CertificateAuthority_SignHashAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 3}
}

// The state of a [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList], indicating if it is current.
type CertificateRevocationList_State int32

const (
	// Not specified.
	CertificateRevocationList_STATE_UNSPECIFIED CertificateRevocationList_State = 0
	// The [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] is up to date.
	CertificateRevocationList_ACTIVE CertificateRevocationList_State = 1
	// The [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] is no longer current.
	CertificateRevocationList_SUPERSEDED CertificateRevocationList_State = 2
)

// Enum value maps for CertificateRevocationList_State.
var (
	CertificateRevocationList_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "SUPERSEDED",
	}
	CertificateRevocationList_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"SUPERSEDED":        2,
	}
)

func (x CertificateRevocationList_State) Enum() *CertificateRevocationList_State {
	p := new(CertificateRevocationList_State)
	*p = x
	return p
}

func (x CertificateRevocationList_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateRevocationList_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[5].Descriptor()
}

func (CertificateRevocationList_State) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[5]
}

func (x CertificateRevocationList_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateRevocationList_State.Descriptor instead.
func (CertificateRevocationList_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// Types of public keys that are supported.
// At a minimum, we support RSA and ECDSA, for the key sizes or curves listed:
// https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
type PublicKey_KeyType int32

const (
	// Default unspecified value.
	PublicKey_KEY_TYPE_UNSPECIFIED PublicKey_KeyType = 0
	// A PEM-encoded PKCS#1/RFC 3447 RSAPrivateKey structure.
	PublicKey_PEM_RSA_KEY PublicKey_KeyType = 1
	// A PEM-encoded compressed NIST P-256/secp256r1/prime256v1 or P-384 key.
	PublicKey_PEM_EC_KEY PublicKey_KeyType = 2
)

// Enum value maps for PublicKey_KeyType.
var (
	PublicKey_KeyType_name = map[int32]string{
		0: "KEY_TYPE_UNSPECIFIED",
		1: "PEM_RSA_KEY",
		2: "PEM_EC_KEY",
	}
	PublicKey_KeyType_value = map[string]int32{
		"KEY_TYPE_UNSPECIFIED": 0,
		"PEM_RSA_KEY":          1,
		"PEM_EC_KEY":           2,
	}
)

func (x PublicKey_KeyType) Enum() *PublicKey_KeyType {
	p := new(PublicKey_KeyType)
	*p = x
	return p
}

func (x PublicKey_KeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicKey_KeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[6].Descriptor()
}

func (PublicKey_KeyType) Type() protoreflect.EnumType {
	return &file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes[6]
}

func (x PublicKey_KeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicKey_KeyType.Descriptor instead.
func (PublicKey_KeyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{7, 0}
}

// A [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] represents an individual Certificate Authority.
// A [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] can be used to create [Certificates][google.cloud.security.privateca.v1beta1.Certificate].
type CertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] in the
	// format `projects/*/locations/*/certificateAuthorities/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The [Type][google.cloud.security.privateca.v1beta1.CertificateAuthority.Type] of this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	Type CertificateAuthority_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.security.privateca.v1beta1.CertificateAuthority_Type" json:"type,omitempty"`
	// Required. Immutable. The [Tier][google.cloud.security.privateca.v1beta1.CertificateAuthority.Tier] of this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	Tier CertificateAuthority_Tier `protobuf:"varint,3,opt,name=tier,proto3,enum=google.cloud.security.privateca.v1beta1.CertificateAuthority_Tier" json:"tier,omitempty"`
	// Required. Immutable. The config used to create a self-signed X.509 certificate or CSR.
	Config *CertificateConfig `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The desired lifetime of the CA certificate. Used to create the
	// "not_before_time" and "not_after_time" fields inside an X.509
	// certificate.
	Lifetime *durationpb.Duration `protobuf:"bytes,5,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// Required. Immutable. Used when issuing certificates for this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]. If this
	// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] is a self-signed CertificateAuthority, this key
	// is also used to sign the self-signed CA certificate. Otherwise, it
	// is used to sign a CSR.
	KeySpec *CertificateAuthority_KeyVersionSpec `protobuf:"bytes,6,opt,name=key_spec,json=keySpec,proto3" json:"key_spec,omitempty"`
	// Optional. The [CertificateAuthorityPolicy][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy] to enforce when issuing
	// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] from this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	CertificatePolicy *CertificateAuthority_CertificateAuthorityPolicy `protobuf:"bytes,7,opt,name=certificate_policy,json=certificatePolicy,proto3" json:"certificate_policy,omitempty"`
	// Optional. The [IssuingOptions][google.cloud.security.privateca.v1beta1.CertificateAuthority.IssuingOptions] to follow when issuing [Certificates][google.cloud.security.privateca.v1beta1.Certificate]
	// from this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	IssuingOptions *CertificateAuthority_IssuingOptions `protobuf:"bytes,8,opt,name=issuing_options,json=issuingOptions,proto3" json:"issuing_options,omitempty"`
	// Optional. If this is a subordinate [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], this field will be set
	// with the subordinate configuration, which describes its issuers. This may
	// be updated, but this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] must continue to validate.
	SubordinateConfig *SubordinateConfig `protobuf:"bytes,19,opt,name=subordinate_config,json=subordinateConfig,proto3" json:"subordinate_config,omitempty"`
	// Output only. The [State][google.cloud.security.privateca.v1beta1.CertificateAuthority.State] for this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	State CertificateAuthority_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.security.privateca.v1beta1.CertificateAuthority_State" json:"state,omitempty"`
	// Output only. This [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s certificate chain, including the current
	// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s certificate. Ordered such that the root issuer
	// is the final element (consistent with RFC 5246). For a self-signed CA, this
	// will only list the current [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s certificate.
	PemCaCertificates []string `protobuf:"bytes,9,rep,name=pem_ca_certificates,json=pemCaCertificates,proto3" json:"pem_ca_certificates,omitempty"`
	// Output only. A structured description of this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s CA certificate
	// and its issuers. Ordered as self-to-root.
	CaCertificateDescriptions []*CertificateDescription `protobuf:"bytes,12,rep,name=ca_certificate_descriptions,json=caCertificateDescriptions,proto3" json:"ca_certificate_descriptions,omitempty"`
	// Immutable. The name of a Cloud Storage bucket where this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] will
	// publish content, such as the CA certificate and CRLs. This must be a bucket
	// name, without any prefixes (such as `gs://`) or suffixes (such as
	// `.googleapis.com`). For example, to use a bucket named `my-bucket`, you
	// would simply specify `my-bucket`. If not specified, a managed bucket will
	// be created.
	GcsBucket string `protobuf:"bytes,13,opt,name=gcs_bucket,json=gcsBucket,proto3" json:"gcs_bucket,omitempty"`
	// Output only. URLs for accessing content published by this CA, such as the CA certificate
	// and CRLs.
	AccessUrls *CertificateAuthority_AccessUrls `protobuf:"bytes,14,opt,name=access_urls,json=accessUrls,proto3" json:"access_urls,omitempty"`
	// Output only. The time at which this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time at which this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] will be deleted, if
	// scheduled for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,18,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *CertificateAuthority) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateAuthority) GetType() CertificateAuthority_Type {
	if x != nil {
		return x.Type
	}
	return CertificateAuthority_TYPE_UNSPECIFIED
}

func (x *CertificateAuthority) GetTier() CertificateAuthority_Tier {
	if x != nil {
		return x.Tier
	}
	return CertificateAuthority_TIER_UNSPECIFIED
}

func (x *CertificateAuthority) GetConfig() *CertificateConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CertificateAuthority) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *CertificateAuthority) GetKeySpec() *CertificateAuthority_KeyVersionSpec {
	if x != nil {
		return x.KeySpec
	}
	return nil
}

func (x *CertificateAuthority) GetCertificatePolicy() *CertificateAuthority_CertificateAuthorityPolicy {
	if x != nil {
		return x.CertificatePolicy
	}
	return nil
}

func (x *CertificateAuthority) GetIssuingOptions() *CertificateAuthority_IssuingOptions {
	if x != nil {
		return x.IssuingOptions
	}
	return nil
}

func (x *CertificateAuthority) GetSubordinateConfig() *SubordinateConfig {
	if x != nil {
		return x.SubordinateConfig
	}
	return nil
}

func (x *CertificateAuthority) GetState() CertificateAuthority_State {
	if x != nil {
		return x.State
	}
	return CertificateAuthority_STATE_UNSPECIFIED
}

func (x *CertificateAuthority) GetPemCaCertificates() []string {
	if x != nil {
		return x.PemCaCertificates
	}
	return nil
}

func (x *CertificateAuthority) GetCaCertificateDescriptions() []*CertificateDescription {
	if x != nil {
		return x.CaCertificateDescriptions
	}
	return nil
}

func (x *CertificateAuthority) GetGcsBucket() string {
	if x != nil {
		return x.GcsBucket
	}
	return ""
}

func (x *CertificateAuthority) GetAccessUrls() *CertificateAuthority_AccessUrls {
	if x != nil {
		return x.AccessUrls
	}
	return nil
}

func (x *CertificateAuthority) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateAuthority) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateAuthority) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *CertificateAuthority) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] corresponds to a signed X.509 certificate
// Revocation List (CRL). A CRL contains the serial numbers of certificates that
// should no longer be trusted.
type CertificateRevocationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource path for this [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] in
	// the format
	// `projects/*/locations/*/certificateAuthorities/*/
	//    certificateRevocationLists/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The CRL sequence number that appears in pem_crl.
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	// Output only. The revoked serial numbers that appear in pem_crl.
	RevokedCertificates []*CertificateRevocationList_RevokedCertificate `protobuf:"bytes,3,rep,name=revoked_certificates,json=revokedCertificates,proto3" json:"revoked_certificates,omitempty"`
	// Output only. The PEM-encoded X.509 CRL.
	PemCrl string `protobuf:"bytes,4,opt,name=pem_crl,json=pemCrl,proto3" json:"pem_crl,omitempty"`
	// Output only. The location where 'pem_crl' can be accessed.
	AccessUrl string `protobuf:"bytes,5,opt,name=access_url,json=accessUrl,proto3" json:"access_url,omitempty"`
	// Output only. The [State][google.cloud.security.privateca.v1beta1.CertificateRevocationList.State] for this [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList].
	State CertificateRevocationList_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.security.privateca.v1beta1.CertificateRevocationList_State" json:"state,omitempty"`
	// Output only. The time at which this [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this [CertificateRevocationList][google.cloud.security.privateca.v1beta1.CertificateRevocationList] was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CertificateRevocationList) Reset() {
	*x = CertificateRevocationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRevocationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRevocationList) ProtoMessage() {}

func (x *CertificateRevocationList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRevocationList.ProtoReflect.Descriptor instead.
func (*CertificateRevocationList) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *CertificateRevocationList) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateRevocationList) GetSequenceNumber() int64 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

func (x *CertificateRevocationList) GetRevokedCertificates() []*CertificateRevocationList_RevokedCertificate {
	if x != nil {
		return x.RevokedCertificates
	}
	return nil
}

func (x *CertificateRevocationList) GetPemCrl() string {
	if x != nil {
		return x.PemCrl
	}
	return ""
}

func (x *CertificateRevocationList) GetAccessUrl() string {
	if x != nil {
		return x.AccessUrl
	}
	return ""
}

func (x *CertificateRevocationList) GetState() CertificateRevocationList_State {
	if x != nil {
		return x.State
	}
	return CertificateRevocationList_STATE_UNSPECIFIED
}

func (x *CertificateRevocationList) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateRevocationList) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateRevocationList) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A [Certificate][google.cloud.security.privateca.v1beta1.Certificate] corresponds to a signed X.509 certificate issued by a
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource path for this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] in the format
	// `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The config used to create a signed X.509 certificate.
	//
	// Types that are assignable to CertificateConfig:
	//	*Certificate_PemCsr
	//	*Certificate_Config
	CertificateConfig isCertificate_CertificateConfig `protobuf_oneof:"certificate_config"`
	// Required. Immutable. The desired lifetime of a certificate. Used to create the
	// "not_before_time" and "not_after_time" fields inside an X.509
	// certificate. Note that the lifetime may be truncated if it would extend
	// past the life of any certificate authority in the issuing chain.
	Lifetime *durationpb.Duration `protobuf:"bytes,4,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// Output only. Details regarding the revocation of this [Certificate][google.cloud.security.privateca.v1beta1.Certificate]. This
	// [Certificate][google.cloud.security.privateca.v1beta1.Certificate] is considered revoked if and only if this field is present.
	RevocationDetails *Certificate_RevocationDetails `protobuf:"bytes,5,opt,name=revocation_details,json=revocationDetails,proto3" json:"revocation_details,omitempty"`
	// Output only. The pem-encoded, signed X.509 certificate.
	PemCertificate string `protobuf:"bytes,6,opt,name=pem_certificate,json=pemCertificate,proto3" json:"pem_certificate,omitempty"`
	// Output only. A structured description of the issued X.509 certificate.
	CertificateDescription *CertificateDescription `protobuf:"bytes,7,opt,name=certificate_description,json=certificateDescription,proto3" json:"certificate_description,omitempty"`
	// Output only. The chain that may be used to verify the X.509 certificate. Expected to be
	// in issuer-to-root order according to RFC 5246.
	PemCertificateChain []string `protobuf:"bytes,8,rep,name=pem_certificate_chain,json=pemCertificateChain,proto3" json:"pem_certificate_chain,omitempty"`
	// Output only. The time at which this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Certificate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Certificate) GetCertificateConfig() isCertificate_CertificateConfig {
	if m != nil {
		return m.CertificateConfig
	}
	return nil
}

func (x *Certificate) GetPemCsr() string {
	if x, ok := x.GetCertificateConfig().(*Certificate_PemCsr); ok {
		return x.PemCsr
	}
	return ""
}

func (x *Certificate) GetConfig() *CertificateConfig {
	if x, ok := x.GetCertificateConfig().(*Certificate_Config); ok {
		return x.Config
	}
	return nil
}

func (x *Certificate) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *Certificate) GetRevocationDetails() *Certificate_RevocationDetails {
	if x != nil {
		return x.RevocationDetails
	}
	return nil
}

func (x *Certificate) GetPemCertificate() string {
	if x != nil {
		return x.PemCertificate
	}
	return ""
}

func (x *Certificate) GetCertificateDescription() *CertificateDescription {
	if x != nil {
		return x.CertificateDescription
	}
	return nil
}

func (x *Certificate) GetPemCertificateChain() []string {
	if x != nil {
		return x.PemCertificateChain
	}
	return nil
}

func (x *Certificate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Certificate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Certificate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isCertificate_CertificateConfig interface {
	isCertificate_CertificateConfig()
}

type Certificate_PemCsr struct {
	// Immutable. A pem-encoded X.509 certificate signing request (CSR).
	PemCsr string `protobuf:"bytes,2,opt,name=pem_csr,json=pemCsr,proto3,oneof"`
}

type Certificate_Config struct {
	// Immutable. A description of the certificate and key that does not require X.509 or
	// ASN.1.
	Config *CertificateConfig `protobuf:"bytes,3,opt,name=config,proto3,oneof"`
}

func (*Certificate_PemCsr) isCertificate_CertificateConfig() {}

func (*Certificate_Config) isCertificate_CertificateConfig() {}

// A [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig] refers to a managed [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues]. Those, in
// turn, are used to describe certain fields of an X.509 certificate, such as
// the key usage fields, fields specific to CA certificates, certificate policy
// extensions and custom extensions.
type ReusableConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource path for this [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig] in the format
	// `projects/*/locations/*/reusableConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The config values.
	Values *ReusableConfigValues `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
	// Optional. A human-readable description of scenarios these ReusableConfigValues may be
	// compatible with.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time at which this [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig] was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels with user-defined metadata.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ReusableConfig) Reset() {
	*x = ReusableConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReusableConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReusableConfig) ProtoMessage() {}

func (x *ReusableConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReusableConfig.ProtoReflect.Descriptor instead.
func (*ReusableConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ReusableConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReusableConfig) GetValues() *ReusableConfigValues {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *ReusableConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReusableConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReusableConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReusableConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues] is used to describe certain fields of an
// X.509 certificate, such as the key usage fields, fields specific to CA
// certificates, certificate policy extensions and custom extensions.
type ReusableConfigValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicates the intended use for keys that correspond to a certificate.
	KeyUsage *KeyUsage `protobuf:"bytes,1,opt,name=key_usage,json=keyUsage,proto3" json:"key_usage,omitempty"`
	// Optional. Describes options in this [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues] that are
	// relevant in a CA certificate.
	CaOptions *ReusableConfigValues_CaOptions `protobuf:"bytes,2,opt,name=ca_options,json=caOptions,proto3" json:"ca_options,omitempty"`
	// Optional. Describes the X.509 certificate policy object identifiers, per
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
	PolicyIds []*ObjectId `protobuf:"bytes,3,rep,name=policy_ids,json=policyIds,proto3" json:"policy_ids,omitempty"`
	// Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses
	// that appear in the "Authority Information Access" extension in the
	// certificate.
	AiaOcspServers []string `protobuf:"bytes,4,rep,name=aia_ocsp_servers,json=aiaOcspServers,proto3" json:"aia_ocsp_servers,omitempty"`
	// Optional. Describes custom X.509 extensions.
	AdditionalExtensions []*X509Extension `protobuf:"bytes,5,rep,name=additional_extensions,json=additionalExtensions,proto3" json:"additional_extensions,omitempty"`
}

func (x *ReusableConfigValues) Reset() {
	*x = ReusableConfigValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReusableConfigValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReusableConfigValues) ProtoMessage() {}

func (x *ReusableConfigValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReusableConfigValues.ProtoReflect.Descriptor instead.
func (*ReusableConfigValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *ReusableConfigValues) GetKeyUsage() *KeyUsage {
	if x != nil {
		return x.KeyUsage
	}
	return nil
}

func (x *ReusableConfigValues) GetCaOptions() *ReusableConfigValues_CaOptions {
	if x != nil {
		return x.CaOptions
	}
	return nil
}

func (x *ReusableConfigValues) GetPolicyIds() []*ObjectId {
	if x != nil {
		return x.PolicyIds
	}
	return nil
}

func (x *ReusableConfigValues) GetAiaOcspServers() []string {
	if x != nil {
		return x.AiaOcspServers
	}
	return nil
}

func (x *ReusableConfigValues) GetAdditionalExtensions() []*X509Extension {
	if x != nil {
		return x.AdditionalExtensions
	}
	return nil
}

// A [ReusableConfigWrapper][google.cloud.security.privateca.v1beta1.ReusableConfigWrapper] describes values that may assist in creating an
// X.509 certificate, or a reference to a pre-defined set of values.
type ReusableConfigWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reusable or inline config values.
	//
	// Types that are assignable to ConfigValues:
	//	*ReusableConfigWrapper_ReusableConfig
	//	*ReusableConfigWrapper_ReusableConfigValues
	ConfigValues isReusableConfigWrapper_ConfigValues `protobuf_oneof:"config_values"`
}

func (x *ReusableConfigWrapper) Reset() {
	*x = ReusableConfigWrapper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReusableConfigWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReusableConfigWrapper) ProtoMessage() {}

func (x *ReusableConfigWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReusableConfigWrapper.ProtoReflect.Descriptor instead.
func (*ReusableConfigWrapper) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{5}
}

func (m *ReusableConfigWrapper) GetConfigValues() isReusableConfigWrapper_ConfigValues {
	if m != nil {
		return m.ConfigValues
	}
	return nil
}

func (x *ReusableConfigWrapper) GetReusableConfig() string {
	if x, ok := x.GetConfigValues().(*ReusableConfigWrapper_ReusableConfig); ok {
		return x.ReusableConfig
	}
	return ""
}

func (x *ReusableConfigWrapper) GetReusableConfigValues() *ReusableConfigValues {
	if x, ok := x.GetConfigValues().(*ReusableConfigWrapper_ReusableConfigValues); ok {
		return x.ReusableConfigValues
	}
	return nil
}

type isReusableConfigWrapper_ConfigValues interface {
	isReusableConfigWrapper_ConfigValues()
}

type ReusableConfigWrapper_ReusableConfig struct {
	// Required. A resource path to a [ReusableConfig][google.cloud.security.privateca.v1beta1.ReusableConfig] in the format
	// `projects/*/locations/*/reusableConfigs/*`.
	ReusableConfig string `protobuf:"bytes,1,opt,name=reusable_config,json=reusableConfig,proto3,oneof"`
}

type ReusableConfigWrapper_ReusableConfigValues struct {
	// Required. A user-specified inline [ReusableConfigValues][google.cloud.security.privateca.v1beta1.ReusableConfigValues].
	ReusableConfigValues *ReusableConfigValues `protobuf:"bytes,2,opt,name=reusable_config_values,json=reusableConfigValues,proto3,oneof"`
}

func (*ReusableConfigWrapper_ReusableConfig) isReusableConfigWrapper_ConfigValues() {}

func (*ReusableConfigWrapper_ReusableConfigValues) isReusableConfigWrapper_ConfigValues() {}

// Describes a subordinate CA's issuers. This is either a resource path to a
// known issuing [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], or a PEM issuer certificate chain.
type SubordinateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SubordinateConfig:
	//	*SubordinateConfig_CertificateAuthority
	//	*SubordinateConfig_PemIssuerChain
	SubordinateConfig isSubordinateConfig_SubordinateConfig `protobuf_oneof:"subordinate_config"`
}

func (x *SubordinateConfig) Reset() {
	*x = SubordinateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubordinateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubordinateConfig) ProtoMessage() {}

func (x *SubordinateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubordinateConfig.ProtoReflect.Descriptor instead.
func (*SubordinateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{6}
}

func (m *SubordinateConfig) GetSubordinateConfig() isSubordinateConfig_SubordinateConfig {
	if m != nil {
		return m.SubordinateConfig
	}
	return nil
}

func (x *SubordinateConfig) GetCertificateAuthority() string {
	if x, ok := x.GetSubordinateConfig().(*SubordinateConfig_CertificateAuthority); ok {
		return x.CertificateAuthority
	}
	return ""
}

func (x *SubordinateConfig) GetPemIssuerChain() *SubordinateConfig_SubordinateConfigChain {
	if x, ok := x.GetSubordinateConfig().(*SubordinateConfig_PemIssuerChain); ok {
		return x.PemIssuerChain
	}
	return nil
}

type isSubordinateConfig_SubordinateConfig interface {
	isSubordinateConfig_SubordinateConfig()
}

type SubordinateConfig_CertificateAuthority struct {
	// Required. This can refer to a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] in the same project that
	// was used to create a subordinate [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]. This field
	// is used for information and usability purposes only. The resource name
	// is in the format `projects/*/locations/*/certificateAuthorities/*`.
	CertificateAuthority string `protobuf:"bytes,1,opt,name=certificate_authority,json=certificateAuthority,proto3,oneof"`
}

type SubordinateConfig_PemIssuerChain struct {
	// Required. Contains the PEM certificate chain for the issuers of this
	// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority], but not pem certificate for this CA itself.
	PemIssuerChain *SubordinateConfig_SubordinateConfigChain `protobuf:"bytes,2,opt,name=pem_issuer_chain,json=pemIssuerChain,proto3,oneof"`
}

func (*SubordinateConfig_CertificateAuthority) isSubordinateConfig_SubordinateConfig() {}

func (*SubordinateConfig_PemIssuerChain) isSubordinateConfig_SubordinateConfig() {}

// A [PublicKey][google.cloud.security.privateca.v1beta1.PublicKey] describes a public key.
type PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of public key.
	Type PublicKey_KeyType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.security.privateca.v1beta1.PublicKey_KeyType" json:"type,omitempty"`
	// Required. A public key. Padding and encoding varies by 'KeyType' and is described
	// along with the KeyType values.
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *PublicKey) Reset() {
	*x = PublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKey) ProtoMessage() {}

func (x *PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKey.ProtoReflect.Descriptor instead.
func (*PublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *PublicKey) GetType() PublicKey_KeyType {
	if x != nil {
		return x.Type
	}
	return PublicKey_KEY_TYPE_UNSPECIFIED
}

func (x *PublicKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

// A [CertificateConfig][google.cloud.security.privateca.v1beta1.CertificateConfig] describes an X.509 certificate or CSR that is to be
// created, as an alternative to using ASN.1.
type CertificateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies some of the values in a certificate that are related to the
	// subject.
	SubjectConfig *CertificateConfig_SubjectConfig `protobuf:"bytes,1,opt,name=subject_config,json=subjectConfig,proto3" json:"subject_config,omitempty"`
	// Required. Describes how some of the technical fields in a certificate should be
	// populated.
	ReusableConfig *ReusableConfigWrapper `protobuf:"bytes,2,opt,name=reusable_config,json=reusableConfig,proto3" json:"reusable_config,omitempty"`
	// Optional. The public key that corresponds to this config. This is, for example, used
	// when issuing [Certificates][google.cloud.security.privateca.v1beta1.Certificate], but not when creating a
	// self-signed [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] or [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] CSR.
	PublicKey *PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
}

func (x *CertificateConfig) Reset() {
	*x = CertificateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateConfig) ProtoMessage() {}

func (x *CertificateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateConfig.ProtoReflect.Descriptor instead.
func (*CertificateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *CertificateConfig) GetSubjectConfig() *CertificateConfig_SubjectConfig {
	if x != nil {
		return x.SubjectConfig
	}
	return nil
}

func (x *CertificateConfig) GetReusableConfig() *ReusableConfigWrapper {
	if x != nil {
		return x.ReusableConfig
	}
	return nil
}

func (x *CertificateConfig) GetPublicKey() *PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

// A [CertificateDescription][google.cloud.security.privateca.v1beta1.CertificateDescription] describes an X.509 certificate or CSR that has
// been issued, as an alternative to using ASN.1 / X.509.
type CertificateDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes some of the values in a certificate that are related to the
	// subject and lifetime.
	SubjectDescription *CertificateDescription_SubjectDescription `protobuf:"bytes,1,opt,name=subject_description,json=subjectDescription,proto3" json:"subject_description,omitempty"`
	// Describes some of the technical fields in a certificate.
	ConfigValues *ReusableConfigValues `protobuf:"bytes,2,opt,name=config_values,json=configValues,proto3" json:"config_values,omitempty"`
	// The public key that corresponds to an issued certificate.
	PublicKey *PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Provides a means of identifiying certificates that contain a particular
	// public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
	SubjectKeyId *CertificateDescription_KeyId `protobuf:"bytes,4,opt,name=subject_key_id,json=subjectKeyId,proto3" json:"subject_key_id,omitempty"`
	// Identifies the subject_key_id of the parent certificate, per
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.1
	AuthorityKeyId *CertificateDescription_KeyId `protobuf:"bytes,5,opt,name=authority_key_id,json=authorityKeyId,proto3" json:"authority_key_id,omitempty"`
	// Describes a list of locations to obtain CRL information, i.e.
	// the DistributionPoint.fullName described by
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.13
	CrlDistributionPoints []string `protobuf:"bytes,6,rep,name=crl_distribution_points,json=crlDistributionPoints,proto3" json:"crl_distribution_points,omitempty"`
	// Describes lists of issuer CA certificate URLs that appear in the
	// "Authority Information Access" extension in the certificate.
	AiaIssuingCertificateUrls []string `protobuf:"bytes,7,rep,name=aia_issuing_certificate_urls,json=aiaIssuingCertificateUrls,proto3" json:"aia_issuing_certificate_urls,omitempty"`
	// The hash of the x.509 certificate.
	CertFingerprint *CertificateDescription_CertificateFingerprint `protobuf:"bytes,8,opt,name=cert_fingerprint,json=certFingerprint,proto3" json:"cert_fingerprint,omitempty"`
}

func (x *CertificateDescription) Reset() {
	*x = CertificateDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription) ProtoMessage() {}

func (x *CertificateDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription.ProtoReflect.Descriptor instead.
func (*CertificateDescription) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *CertificateDescription) GetSubjectDescription() *CertificateDescription_SubjectDescription {
	if x != nil {
		return x.SubjectDescription
	}
	return nil
}

func (x *CertificateDescription) GetConfigValues() *ReusableConfigValues {
	if x != nil {
		return x.ConfigValues
	}
	return nil
}

func (x *CertificateDescription) GetPublicKey() *PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *CertificateDescription) GetSubjectKeyId() *CertificateDescription_KeyId {
	if x != nil {
		return x.SubjectKeyId
	}
	return nil
}

func (x *CertificateDescription) GetAuthorityKeyId() *CertificateDescription_KeyId {
	if x != nil {
		return x.AuthorityKeyId
	}
	return nil
}

func (x *CertificateDescription) GetCrlDistributionPoints() []string {
	if x != nil {
		return x.CrlDistributionPoints
	}
	return nil
}

func (x *CertificateDescription) GetAiaIssuingCertificateUrls() []string {
	if x != nil {
		return x.AiaIssuingCertificateUrls
	}
	return nil
}

func (x *CertificateDescription) GetCertFingerprint() *CertificateDescription_CertificateFingerprint {
	if x != nil {
		return x.CertFingerprint
	}
	return nil
}

// An [ObjectId][google.cloud.security.privateca.v1beta1.ObjectId] specifies an object identifier (OID). These provide context
// and describe types in ASN.1 messages.
type ObjectId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parts of an OID path. The most significant parts of the path come
	// first.
	ObjectIdPath []int32 `protobuf:"varint,1,rep,packed,name=object_id_path,json=objectIdPath,proto3" json:"object_id_path,omitempty"`
}

func (x *ObjectId) Reset() {
	*x = ObjectId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectId) ProtoMessage() {}

func (x *ObjectId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectId.ProtoReflect.Descriptor instead.
func (*ObjectId) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *ObjectId) GetObjectIdPath() []int32 {
	if x != nil {
		return x.ObjectIdPath
	}
	return nil
}

// An [X509Extension][google.cloud.security.privateca.v1beta1.X509Extension] specifies an X.509 extension, which may be used in
// different parts of X.509 objects like certificates, CSRs, and CRLs.
type X509Extension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The OID for this X.509 extension.
	ObjectId *ObjectId `protobuf:"bytes,1,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Required. Indicates whether or not this extension is critical (i.e., if the client
	// does not know how to handle this extension, the client should consider this
	// to be an error).
	Critical bool `protobuf:"varint,2,opt,name=critical,proto3" json:"critical,omitempty"`
	// Required. The value of this X.509 extension.
	Value []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *X509Extension) Reset() {
	*x = X509Extension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Extension) ProtoMessage() {}

func (x *X509Extension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Extension.ProtoReflect.Descriptor instead.
func (*X509Extension) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *X509Extension) GetObjectId() *ObjectId {
	if x != nil {
		return x.ObjectId
	}
	return nil
}

func (x *X509Extension) GetCritical() bool {
	if x != nil {
		return x.Critical
	}
	return false
}

func (x *X509Extension) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// A [KeyUsage][google.cloud.security.privateca.v1beta1.KeyUsage] describes key usage values that may appear in an X.509
// certificate.
type KeyUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes high-level ways in which a key may be used.
	BaseKeyUsage *KeyUsage_KeyUsageOptions `protobuf:"bytes,1,opt,name=base_key_usage,json=baseKeyUsage,proto3" json:"base_key_usage,omitempty"`
	// Detailed scenarios in which a key may be used.
	ExtendedKeyUsage *KeyUsage_ExtendedKeyUsageOptions `protobuf:"bytes,2,opt,name=extended_key_usage,json=extendedKeyUsage,proto3" json:"extended_key_usage,omitempty"`
	// Used to describe extended key usages that are not listed in the
	// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1beta1.KeyUsage.ExtendedKeyUsageOptions] message.
	UnknownExtendedKeyUsages []*ObjectId `protobuf:"bytes,3,rep,name=unknown_extended_key_usages,json=unknownExtendedKeyUsages,proto3" json:"unknown_extended_key_usages,omitempty"`
}

func (x *KeyUsage) Reset() {
	*x = KeyUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage) ProtoMessage() {}

func (x *KeyUsage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage.ProtoReflect.Descriptor instead.
func (*KeyUsage) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *KeyUsage) GetBaseKeyUsage() *KeyUsage_KeyUsageOptions {
	if x != nil {
		return x.BaseKeyUsage
	}
	return nil
}

func (x *KeyUsage) GetExtendedKeyUsage() *KeyUsage_ExtendedKeyUsageOptions {
	if x != nil {
		return x.ExtendedKeyUsage
	}
	return nil
}

func (x *KeyUsage) GetUnknownExtendedKeyUsages() []*ObjectId {
	if x != nil {
		return x.UnknownExtendedKeyUsages
	}
	return nil
}

// [Subject][google.cloud.security.privateca.v1beta1.Subject] describes parts of a distinguished name that, in turn,
// describes the subject of the certificate.
type Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The country code of the subject.
	CountryCode string `protobuf:"bytes,1,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The organization of the subject.
	Organization string `protobuf:"bytes,2,opt,name=organization,proto3" json:"organization,omitempty"`
	// The organizational_unit of the subject.
	OrganizationalUnit string `protobuf:"bytes,3,opt,name=organizational_unit,json=organizationalUnit,proto3" json:"organizational_unit,omitempty"`
	// The locality or city of the subject.
	Locality string `protobuf:"bytes,4,opt,name=locality,proto3" json:"locality,omitempty"`
	// The province, territory, or regional state of the subject.
	Province string `protobuf:"bytes,5,opt,name=province,proto3" json:"province,omitempty"`
	// The street address of the subject.
	StreetAddress string `protobuf:"bytes,6,opt,name=street_address,json=streetAddress,proto3" json:"street_address,omitempty"`
	// The postal code of the subject.
	PostalCode string `protobuf:"bytes,7,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
}

func (x *Subject) Reset() {
	*x = Subject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subject) ProtoMessage() {}

func (x *Subject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subject.ProtoReflect.Descriptor instead.
func (*Subject) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *Subject) GetCountryCode() string {
	if x != nil {
		return x.CountryCode
	}
	return ""
}

func (x *Subject) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *Subject) GetOrganizationalUnit() string {
	if x != nil {
		return x.OrganizationalUnit
	}
	return ""
}

func (x *Subject) GetLocality() string {
	if x != nil {
		return x.Locality
	}
	return ""
}

func (x *Subject) GetProvince() string {
	if x != nil {
		return x.Province
	}
	return ""
}

func (x *Subject) GetStreetAddress() string {
	if x != nil {
		return x.StreetAddress
	}
	return ""
}

func (x *Subject) GetPostalCode() string {
	if x != nil {
		return x.PostalCode
	}
	return ""
}

// [SubjectAltNames][google.cloud.security.privateca.v1beta1.SubjectAltNames] corresponds to a more modern way of listing what
// the asserted identity is in a certificate (i.e., compared to the "common
// name" in the distinguished name).
type SubjectAltNames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains only valid, fully-qualified host names.
	DnsNames []string `protobuf:"bytes,1,rep,name=dns_names,json=dnsNames,proto3" json:"dns_names,omitempty"`
	// Contains only valid RFC 3986 URIs.
	Uris []string `protobuf:"bytes,2,rep,name=uris,proto3" json:"uris,omitempty"`
	// Contains only valid RFC 2822 E-mail addresses.
	EmailAddresses []string `protobuf:"bytes,3,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
	IpAddresses []string `protobuf:"bytes,4,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// Contains additional subject alternative name values.
	CustomSans []*X509Extension `protobuf:"bytes,5,rep,name=custom_sans,json=customSans,proto3" json:"custom_sans,omitempty"`
}

func (x *SubjectAltNames) Reset() {
	*x = SubjectAltNames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubjectAltNames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubjectAltNames) ProtoMessage() {}

func (x *SubjectAltNames) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubjectAltNames.ProtoReflect.Descriptor instead.
func (*SubjectAltNames) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *SubjectAltNames) GetDnsNames() []string {
	if x != nil {
		return x.DnsNames
	}
	return nil
}

func (x *SubjectAltNames) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *SubjectAltNames) GetEmailAddresses() []string {
	if x != nil {
		return x.EmailAddresses
	}
	return nil
}

func (x *SubjectAltNames) GetIpAddresses() []string {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *SubjectAltNames) GetCustomSans() []*X509Extension {
	if x != nil {
		return x.CustomSans
	}
	return nil
}

// Options that affect all certificates issued by a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
type CertificateAuthority_IssuingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. When true, includes a URL to the issuing CA certificate in the
	// "authority information access" X.509 extension.
	IncludeCaCertUrl bool `protobuf:"varint,1,opt,name=include_ca_cert_url,json=includeCaCertUrl,proto3" json:"include_ca_cert_url,omitempty"`
	// Required. When true, includes a URL to the CRL corresponding to certificates
	// issued from a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
	// CRLs will expire 7 days from their creation. However, we will rebuild
	// daily. CRLs are also rebuilt shortly after a certificate is revoked.
	IncludeCrlAccessUrl bool `protobuf:"varint,2,opt,name=include_crl_access_url,json=includeCrlAccessUrl,proto3" json:"include_crl_access_url,omitempty"`
}

func (x *CertificateAuthority_IssuingOptions) Reset() {
	*x = CertificateAuthority_IssuingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_IssuingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_IssuingOptions) ProtoMessage() {}

func (x *CertificateAuthority_IssuingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_IssuingOptions.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_IssuingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CertificateAuthority_IssuingOptions) GetIncludeCaCertUrl() bool {
	if x != nil {
		return x.IncludeCaCertUrl
	}
	return false
}

func (x *CertificateAuthority_IssuingOptions) GetIncludeCrlAccessUrl() bool {
	if x != nil {
		return x.IncludeCrlAccessUrl
	}
	return false
}

// The issuing policy for a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] will not be successfully issued from this
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] if they violate the policy.
type CertificateAuthority_CertificateAuthorityPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allowed configurations or a single configuration for all issued
	// certificates.
	//
	// Types that are assignable to ConfigPolicy:
	//	*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_
	//	*CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues
	ConfigPolicy isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy `protobuf_oneof:"config_policy"`
	// Optional. If any [Subject][google.cloud.security.privateca.v1beta1.Subject] is specified here, then all
	// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] must
	// match at least one listed [Subject][google.cloud.security.privateca.v1beta1.Subject]. If a [Subject][google.cloud.security.privateca.v1beta1.Subject] has an empty
	// field, any value will be allowed for that field.
	AllowedLocationsAndOrganizations []*Subject `protobuf:"bytes,3,rep,name=allowed_locations_and_organizations,json=allowedLocationsAndOrganizations,proto3" json:"allowed_locations_and_organizations,omitempty"`
	// Optional. If any value is specified here, then all
	// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] must
	// match at least one listed value. If no value is specified, all values
	// will be allowed for this fied. Glob patterns are also supported.
	AllowedCommonNames []string `protobuf:"bytes,4,rep,name=allowed_common_names,json=allowedCommonNames,proto3" json:"allowed_common_names,omitempty"`
	// Optional. If a [AllowedSubjectAltNames][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames] is specified here, then all
	// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] must
	// match [AllowedSubjectAltNames][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames]. If no value or an empty value
	// is specified, any value will be allowed for the [SubjectAltNames][google.cloud.security.privateca.v1beta1.SubjectAltNames]
	// field.
	AllowedSans *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames `protobuf:"bytes,5,opt,name=allowed_sans,json=allowedSans,proto3" json:"allowed_sans,omitempty"`
	// Optional. The maximum lifetime allowed by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]. Note that
	// if the any part if the issuing chain expires before a [Certificate][google.cloud.security.privateca.v1beta1.Certificate]'s
	// requested maximum_lifetime, the effective lifetime will be explicitly
	// truncated.
	MaximumLifetime *durationpb.Duration `protobuf:"bytes,6,opt,name=maximum_lifetime,json=maximumLifetime,proto3" json:"maximum_lifetime,omitempty"`
	// Optional. If specified, then only methods allowed in the [IssuanceModes][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.IssuanceModes] may be
	// used to issue [Certificates][google.cloud.security.privateca.v1beta1.Certificate].
	AllowedIssuanceModes *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes `protobuf:"bytes,8,opt,name=allowed_issuance_modes,json=allowedIssuanceModes,proto3" json:"allowed_issuance_modes,omitempty"`
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) Reset() {
	*x = CertificateAuthority_CertificateAuthorityPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_CertificateAuthorityPolicy) ProtoMessage() {}

func (x *CertificateAuthority_CertificateAuthorityPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_CertificateAuthorityPolicy.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_CertificateAuthorityPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (m *CertificateAuthority_CertificateAuthorityPolicy) GetConfigPolicy() isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy {
	if m != nil {
		return m.ConfigPolicy
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetAllowedConfigList() *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList {
	if x, ok := x.GetConfigPolicy().(*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_); ok {
		return x.AllowedConfigList
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetOverwriteConfigValues() *ReusableConfigWrapper {
	if x, ok := x.GetConfigPolicy().(*CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues); ok {
		return x.OverwriteConfigValues
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetAllowedLocationsAndOrganizations() []*Subject {
	if x != nil {
		return x.AllowedLocationsAndOrganizations
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetAllowedCommonNames() []string {
	if x != nil {
		return x.AllowedCommonNames
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetAllowedSans() *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames {
	if x != nil {
		return x.AllowedSans
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetMaximumLifetime() *durationpb.Duration {
	if x != nil {
		return x.MaximumLifetime
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy) GetAllowedIssuanceModes() *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes {
	if x != nil {
		return x.AllowedIssuanceModes
	}
	return nil
}

type isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy interface {
	isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy()
}

type CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_ struct {
	// Optional. All [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
	// must match at least one listed [ReusableConfigWrapper][google.cloud.security.privateca.v1beta1.ReusableConfigWrapper] in the list.
	AllowedConfigList *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList `protobuf:"bytes,1,opt,name=allowed_config_list,json=allowedConfigList,proto3,oneof"`
}

type CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues struct {
	// Optional. All [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
	// will use the provided configuration values, overwriting any requested
	// configuration values.
	OverwriteConfigValues *ReusableConfigWrapper `protobuf:"bytes,2,opt,name=overwrite_config_values,json=overwriteConfigValues,proto3,oneof"`
}

func (*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_) isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy() {
}

func (*CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues) isCertificateAuthority_CertificateAuthorityPolicy_ConfigPolicy() {
}

// URLs where a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] will publish content.
type CertificateAuthority_AccessUrls struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL where this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s CA certificate is
	// published. This will only be set for CAs that have been activated.
	CaCertificateAccessUrl string `protobuf:"bytes,1,opt,name=ca_certificate_access_url,json=caCertificateAccessUrl,proto3" json:"ca_certificate_access_url,omitempty"`
	// The URL where this [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]'s CRLs are published. This
	// will only be set for CAs that have been activated.
	CrlAccessUrl string `protobuf:"bytes,2,opt,name=crl_access_url,json=crlAccessUrl,proto3" json:"crl_access_url,omitempty"`
}

func (x *CertificateAuthority_AccessUrls) Reset() {
	*x = CertificateAuthority_AccessUrls{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_AccessUrls) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_AccessUrls) ProtoMessage() {}

func (x *CertificateAuthority_AccessUrls) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_AccessUrls.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_AccessUrls) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 2}
}

func (x *CertificateAuthority_AccessUrls) GetCaCertificateAccessUrl() string {
	if x != nil {
		return x.CaCertificateAccessUrl
	}
	return ""
}

func (x *CertificateAuthority_AccessUrls) GetCrlAccessUrl() string {
	if x != nil {
		return x.CrlAccessUrl
	}
	return ""
}

// A Cloud KMS key configuration that a [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] will use.
type CertificateAuthority_KeyVersionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to KeyVersion:
	//	*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion
	//	*CertificateAuthority_KeyVersionSpec_Algorithm
	KeyVersion isCertificateAuthority_KeyVersionSpec_KeyVersion `protobuf_oneof:"KeyVersion"`
}

func (x *CertificateAuthority_KeyVersionSpec) Reset() {
	*x = CertificateAuthority_KeyVersionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_KeyVersionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_KeyVersionSpec) ProtoMessage() {}

func (x *CertificateAuthority_KeyVersionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_KeyVersionSpec.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_KeyVersionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 3}
}

func (m *CertificateAuthority_KeyVersionSpec) GetKeyVersion() isCertificateAuthority_KeyVersionSpec_KeyVersion {
	if m != nil {
		return m.KeyVersion
	}
	return nil
}

func (x *CertificateAuthority_KeyVersionSpec) GetCloudKmsKeyVersion() string {
	if x, ok := x.GetKeyVersion().(*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion); ok {
		return x.CloudKmsKeyVersion
	}
	return ""
}

func (x *CertificateAuthority_KeyVersionSpec) GetAlgorithm() CertificateAuthority_SignHashAlgorithm {
	if x, ok := x.GetKeyVersion().(*CertificateAuthority_KeyVersionSpec_Algorithm); ok {
		return x.Algorithm
	}
	return CertificateAuthority_SIGN_HASH_ALGORITHM_UNSPECIFIED
}

type isCertificateAuthority_KeyVersionSpec_KeyVersion interface {
	isCertificateAuthority_KeyVersionSpec_KeyVersion()
}

type CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion struct {
	// Required. The resource name for an existing Cloud KMS CryptoKeyVersion in the
	// format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
	// This option enables full flexibility in the key's capabilities and
	// properties.
	CloudKmsKeyVersion string `protobuf:"bytes,1,opt,name=cloud_kms_key_version,json=cloudKmsKeyVersion,proto3,oneof"`
}

type CertificateAuthority_KeyVersionSpec_Algorithm struct {
	// Required. The algorithm to use for creating a managed Cloud KMS key for a for a
	// simplified experience. All managed keys will be have their
	// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] as `HSM`.
	Algorithm CertificateAuthority_SignHashAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.security.privateca.v1beta1.CertificateAuthority_SignHashAlgorithm,oneof"`
}

func (*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion) isCertificateAuthority_KeyVersionSpec_KeyVersion() {
}

func (*CertificateAuthority_KeyVersionSpec_Algorithm) isCertificateAuthority_KeyVersionSpec_KeyVersion() {
}

type CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. All [Certificates][google.cloud.security.privateca.v1beta1.Certificate] issued by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority]
	// must match at least one listed [ReusableConfigWrapper][google.cloud.security.privateca.v1beta1.ReusableConfigWrapper]. If a
	// [ReusableConfigWrapper][google.cloud.security.privateca.v1beta1.ReusableConfigWrapper] has an empty field, any value will be
	// allowed for that field.
	AllowedConfigValues []*ReusableConfigWrapper `protobuf:"bytes,1,rep,name=allowed_config_values,json=allowedConfigValues,proto3" json:"allowed_config_values,omitempty"`
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) Reset() {
	*x = CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) ProtoMessage() {}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList) GetAllowedConfigValues() []*ReusableConfigWrapper {
	if x != nil {
		return x.AllowedConfigValues
	}
	return nil
}

// [AllowedSubjectAltNames][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames] specifies the allowed values for
// [SubjectAltNames][google.cloud.security.privateca.v1beta1.SubjectAltNames] by the [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority] when issuing
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate].
type CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Contains valid, fully-qualified host names. Glob patterns are also
	// supported. To allow an explicit wildcard certificate, escape with
	// backlash (i.e. "\*").
	// E.g. for globbed entries: '*bar.com' will allow foo.bar.com, but not
	// *.bar.com, unless the [allow_globbing_dns_wildcards][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames.allow_globbing_dns_wildcards] field is set.
	// E.g. for wildcard entries: '\*.bar.com' will allow '*.bar.com', but not
	// 'foo.bar.com'.
	AllowedDnsNames []string `protobuf:"bytes,1,rep,name=allowed_dns_names,json=allowedDnsNames,proto3" json:"allowed_dns_names,omitempty"`
	// Optional. Contains valid RFC 3986 URIs. Glob patterns are also supported. To
	// match across path seperators (i.e. '/') use the double star glob
	// pattern (i.e. '**').
	AllowedUris []string `protobuf:"bytes,2,rep,name=allowed_uris,json=allowedUris,proto3" json:"allowed_uris,omitempty"`
	// Optional. Contains valid RFC 2822 E-mail addresses. Glob patterns are also
	// supported.
	AllowedEmailAddresses []string `protobuf:"bytes,3,rep,name=allowed_email_addresses,json=allowedEmailAddresses,proto3" json:"allowed_email_addresses,omitempty"`
	// Optional. Contains valid 32-bit IPv4 addresses and subnet ranges or RFC 4291 IPv6
	// addresses and subnet ranges. Subnet ranges are specified using the
	// '/' notation (e.g. 10.0.0.0/8, 2001:700:300:1800::/64). Glob patterns
	// are supported only for ip address entries (i.e. not for subnet ranges).
	AllowedIps []string `protobuf:"bytes,4,rep,name=allowed_ips,json=allowedIps,proto3" json:"allowed_ips,omitempty"`
	// Optional. Specifies if glob patterns used for [allowed_dns_names][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames.allowed_dns_names] allows
	// wildcard certificates.
	AllowGlobbingDnsWildcards bool `protobuf:"varint,5,opt,name=allow_globbing_dns_wildcards,json=allowGlobbingDnsWildcards,proto3" json:"allow_globbing_dns_wildcards,omitempty"`
	// Optional. Specifies if to allow custom X509Extension values.
	AllowCustomSans bool `protobuf:"varint,6,opt,name=allow_custom_sans,json=allowCustomSans,proto3" json:"allow_custom_sans,omitempty"`
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) Reset() {
	*x = CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) ProtoMessage() {}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowedDnsNames() []string {
	if x != nil {
		return x.AllowedDnsNames
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowedUris() []string {
	if x != nil {
		return x.AllowedUris
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowedEmailAddresses() []string {
	if x != nil {
		return x.AllowedEmailAddresses
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowedIps() []string {
	if x != nil {
		return x.AllowedIps
	}
	return nil
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowGlobbingDnsWildcards() bool {
	if x != nil {
		return x.AllowGlobbingDnsWildcards
	}
	return false
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames) GetAllowCustomSans() bool {
	if x != nil {
		return x.AllowCustomSans
	}
	return false
}

// [IssuanceModes][google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.IssuanceModes] specifies the allowed ways in which
// [Certificates][google.cloud.security.privateca.v1beta1.Certificate] may be requested from this
// [CertificateAuthority][google.cloud.security.privateca.v1beta1.CertificateAuthority].
type CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. When true, allows callers to create [Certificates][google.cloud.security.privateca.v1beta1.Certificate] by
	// specifying a CSR.
	AllowCsrBasedIssuance bool `protobuf:"varint,1,opt,name=allow_csr_based_issuance,json=allowCsrBasedIssuance,proto3" json:"allow_csr_based_issuance,omitempty"`
	// Required. When true, allows callers to create [Certificates][google.cloud.security.privateca.v1beta1.Certificate] by
	// specifying a [CertificateConfig][google.cloud.security.privateca.v1beta1.CertificateConfig].
	AllowConfigBasedIssuance bool `protobuf:"varint,2,opt,name=allow_config_based_issuance,json=allowConfigBasedIssuance,proto3" json:"allow_config_based_issuance,omitempty"`
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) Reset() {
	*x = CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) ProtoMessage() {}

func (x *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) GetAllowCsrBasedIssuance() bool {
	if x != nil {
		return x.AllowCsrBasedIssuance
	}
	return false
}

func (x *CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes) GetAllowConfigBasedIssuance() bool {
	if x != nil {
		return x.AllowConfigBasedIssuance
	}
	return false
}

// Describes a revoked [Certificate][google.cloud.security.privateca.v1beta1.Certificate].
type CertificateRevocationList_RevokedCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource path for the [Certificate][google.cloud.security.privateca.v1beta1.Certificate] in the format
	// `projects/*/locations/*/certificateAuthorities/*/certificates/*`.
	Certificate string `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// The serial number of the [Certificate][google.cloud.security.privateca.v1beta1.Certificate].
	HexSerialNumber string `protobuf:"bytes,2,opt,name=hex_serial_number,json=hexSerialNumber,proto3" json:"hex_serial_number,omitempty"`
	// The reason the [Certificate][google.cloud.security.privateca.v1beta1.Certificate] was revoked.
	RevocationReason RevocationReason `protobuf:"varint,3,opt,name=revocation_reason,json=revocationReason,proto3,enum=google.cloud.security.privateca.v1beta1.RevocationReason" json:"revocation_reason,omitempty"`
}

func (x *CertificateRevocationList_RevokedCertificate) Reset() {
	*x = CertificateRevocationList_RevokedCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRevocationList_RevokedCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRevocationList_RevokedCertificate) ProtoMessage() {}

func (x *CertificateRevocationList_RevokedCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRevocationList_RevokedCertificate.ProtoReflect.Descriptor instead.
func (*CertificateRevocationList_RevokedCertificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CertificateRevocationList_RevokedCertificate) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

func (x *CertificateRevocationList_RevokedCertificate) GetHexSerialNumber() string {
	if x != nil {
		return x.HexSerialNumber
	}
	return ""
}

func (x *CertificateRevocationList_RevokedCertificate) GetRevocationReason() RevocationReason {
	if x != nil {
		return x.RevocationReason
	}
	return RevocationReason_REVOCATION_REASON_UNSPECIFIED
}

// Describes fields that are relavent to the revocation of a [Certificate][google.cloud.security.privateca.v1beta1.Certificate].
type Certificate_RevocationDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates why a [Certificate][google.cloud.security.privateca.v1beta1.Certificate] was revoked.
	RevocationState RevocationReason `protobuf:"varint,1,opt,name=revocation_state,json=revocationState,proto3,enum=google.cloud.security.privateca.v1beta1.RevocationReason" json:"revocation_state,omitempty"`
	// The time at which this [Certificate][google.cloud.security.privateca.v1beta1.Certificate] was revoked.
	RevocationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=revocation_time,json=revocationTime,proto3" json:"revocation_time,omitempty"`
}

func (x *Certificate_RevocationDetails) Reset() {
	*x = Certificate_RevocationDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_RevocationDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_RevocationDetails) ProtoMessage() {}

func (x *Certificate_RevocationDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_RevocationDetails.ProtoReflect.Descriptor instead.
func (*Certificate_RevocationDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Certificate_RevocationDetails) GetRevocationState() RevocationReason {
	if x != nil {
		return x.RevocationState
	}
	return RevocationReason_REVOCATION_REASON_UNSPECIFIED
}

func (x *Certificate_RevocationDetails) GetRevocationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevocationTime
	}
	return nil
}

// Describes values that are relevant in a CA certificate.
type ReusableConfigValues_CaOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this
	// value is missing, the extension will be omitted from the CA certificate.
	IsCa *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=is_ca,json=isCa,proto3" json:"is_ca,omitempty"`
	// Optional. Refers to the path length restriction X.509 extension. For a CA
	// certificate, this value describes the depth of subordinate CA
	// certificates that are allowed.
	// If this value is less than 0, the request will fail.
	// If this value is missing, the max path length will be omitted from the
	// CA certificate.
	MaxIssuerPathLength *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=max_issuer_path_length,json=maxIssuerPathLength,proto3" json:"max_issuer_path_length,omitempty"`
}

func (x *ReusableConfigValues_CaOptions) Reset() {
	*x = ReusableConfigValues_CaOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReusableConfigValues_CaOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReusableConfigValues_CaOptions) ProtoMessage() {}

func (x *ReusableConfigValues_CaOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReusableConfigValues_CaOptions.ProtoReflect.Descriptor instead.
func (*ReusableConfigValues_CaOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ReusableConfigValues_CaOptions) GetIsCa() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsCa
	}
	return nil
}

func (x *ReusableConfigValues_CaOptions) GetMaxIssuerPathLength() *wrapperspb.Int32Value {
	if x != nil {
		return x.MaxIssuerPathLength
	}
	return nil
}

// This message describes a subordinate CA's issuer certificate chain. This
// wrapper exists for compatibility reasons.
type SubordinateConfig_SubordinateConfigChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Expected to be in leaf-to-root order according to RFC 5246.
	PemCertificates []string `protobuf:"bytes,1,rep,name=pem_certificates,json=pemCertificates,proto3" json:"pem_certificates,omitempty"`
}

func (x *SubordinateConfig_SubordinateConfigChain) Reset() {
	*x = SubordinateConfig_SubordinateConfigChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubordinateConfig_SubordinateConfigChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubordinateConfig_SubordinateConfigChain) ProtoMessage() {}

func (x *SubordinateConfig_SubordinateConfigChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubordinateConfig_SubordinateConfigChain.ProtoReflect.Descriptor instead.
func (*SubordinateConfig_SubordinateConfigChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SubordinateConfig_SubordinateConfigChain) GetPemCertificates() []string {
	if x != nil {
		return x.PemCertificates
	}
	return nil
}

// These values are used to create the distinguished name and subject
// alternative name fields in an X.509 certificate.
type CertificateConfig_SubjectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Contains distinguished name fields such as the location and organization.
	Subject *Subject `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// Optional. The "common name" of the distinguished name.
	CommonName string `protobuf:"bytes,2,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	// Optional. The subject alternative name fields.
	SubjectAltName *SubjectAltNames `protobuf:"bytes,3,opt,name=subject_alt_name,json=subjectAltName,proto3" json:"subject_alt_name,omitempty"`
}

func (x *CertificateConfig_SubjectConfig) Reset() {
	*x = CertificateConfig_SubjectConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateConfig_SubjectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateConfig_SubjectConfig) ProtoMessage() {}

func (x *CertificateConfig_SubjectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateConfig_SubjectConfig.ProtoReflect.Descriptor instead.
func (*CertificateConfig_SubjectConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{8, 0}
}

func (x *CertificateConfig_SubjectConfig) GetSubject() *Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *CertificateConfig_SubjectConfig) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *CertificateConfig_SubjectConfig) GetSubjectAltName() *SubjectAltNames {
	if x != nil {
		return x.SubjectAltName
	}
	return nil
}

// These values describe fields in an issued X.509 certificate such as the
// distinguished name, subject alternative names, serial number, and lifetime.
type CertificateDescription_SubjectDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains distinguished name fields such as the location and organization.
	Subject *Subject `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// The "common name" of the distinguished name.
	CommonName string `protobuf:"bytes,2,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	// The subject alternative name fields.
	SubjectAltName *SubjectAltNames `protobuf:"bytes,3,opt,name=subject_alt_name,json=subjectAltName,proto3" json:"subject_alt_name,omitempty"`
	// The serial number encoded in lowercase hexadecimal.
	HexSerialNumber string `protobuf:"bytes,4,opt,name=hex_serial_number,json=hexSerialNumber,proto3" json:"hex_serial_number,omitempty"`
	// For convenience, the actual lifetime of an issued certificate.
	// Corresponds to 'not_after_time' - 'not_before_time'.
	Lifetime *durationpb.Duration `protobuf:"bytes,5,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// The time at which the certificate becomes valid.
	NotBeforeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=not_before_time,json=notBeforeTime,proto3" json:"not_before_time,omitempty"`
	// The time at which the certificate expires.
	NotAfterTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=not_after_time,json=notAfterTime,proto3" json:"not_after_time,omitempty"`
}

func (x *CertificateDescription_SubjectDescription) Reset() {
	*x = CertificateDescription_SubjectDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_SubjectDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_SubjectDescription) ProtoMessage() {}

func (x *CertificateDescription_SubjectDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_SubjectDescription.ProtoReflect.Descriptor instead.
func (*CertificateDescription_SubjectDescription) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{9, 0}
}

func (x *CertificateDescription_SubjectDescription) GetSubject() *Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *CertificateDescription_SubjectDescription) GetSubjectAltName() *SubjectAltNames {
	if x != nil {
		return x.SubjectAltName
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetHexSerialNumber() string {
	if x != nil {
		return x.HexSerialNumber
	}
	return ""
}

func (x *CertificateDescription_SubjectDescription) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetNotBeforeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotBeforeTime
	}
	return nil
}

func (x *CertificateDescription_SubjectDescription) GetNotAfterTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NotAfterTime
	}
	return nil
}

// A KeyId identifies a specific public key, usually by hashing the public
// key.
type CertificateDescription_KeyId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most
	// likely the 160 bit SHA-1 hash of the public key.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *CertificateDescription_KeyId) Reset() {
	*x = CertificateDescription_KeyId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_KeyId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_KeyId) ProtoMessage() {}

func (x *CertificateDescription_KeyId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_KeyId.ProtoReflect.Descriptor instead.
func (*CertificateDescription_KeyId) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{9, 1}
}

func (x *CertificateDescription_KeyId) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// A group of fingerprints for the x509 certificate.
type CertificateDescription_CertificateFingerprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
	Sha256Hash string `protobuf:"bytes,1,opt,name=sha256_hash,json=sha256Hash,proto3" json:"sha256_hash,omitempty"`
}

func (x *CertificateDescription_CertificateFingerprint) Reset() {
	*x = CertificateDescription_CertificateFingerprint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateDescription_CertificateFingerprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateDescription_CertificateFingerprint) ProtoMessage() {}

func (x *CertificateDescription_CertificateFingerprint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateDescription_CertificateFingerprint.ProtoReflect.Descriptor instead.
func (*CertificateDescription_CertificateFingerprint) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{9, 2}
}

func (x *CertificateDescription_CertificateFingerprint) GetSha256Hash() string {
	if x != nil {
		return x.Sha256Hash
	}
	return ""
}

// [KeyUsage.KeyUsageOptions][google.cloud.security.privateca.v1beta1.KeyUsage.KeyUsageOptions] corresponds to the key usage values
// described in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
type KeyUsage_KeyUsageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key may be used for digital signatures.
	DigitalSignature bool `protobuf:"varint,1,opt,name=digital_signature,json=digitalSignature,proto3" json:"digital_signature,omitempty"`
	// The key may be used for cryptographic commitments. Note that this may
	// also be referred to as "non-repudiation".
	ContentCommitment bool `protobuf:"varint,2,opt,name=content_commitment,json=contentCommitment,proto3" json:"content_commitment,omitempty"`
	// The key may be used to encipher other keys.
	KeyEncipherment bool `protobuf:"varint,3,opt,name=key_encipherment,json=keyEncipherment,proto3" json:"key_encipherment,omitempty"`
	// The key may be used to encipher data.
	DataEncipherment bool `protobuf:"varint,4,opt,name=data_encipherment,json=dataEncipherment,proto3" json:"data_encipherment,omitempty"`
	// The key may be used in a key agreement protocol.
	KeyAgreement bool `protobuf:"varint,5,opt,name=key_agreement,json=keyAgreement,proto3" json:"key_agreement,omitempty"`
	// The key may be used to sign certificates.
	CertSign bool `protobuf:"varint,6,opt,name=cert_sign,json=certSign,proto3" json:"cert_sign,omitempty"`
	// The key may be used sign certificate revocation lists.
	CrlSign bool `protobuf:"varint,7,opt,name=crl_sign,json=crlSign,proto3" json:"crl_sign,omitempty"`
	// The key may be used to encipher only.
	EncipherOnly bool `protobuf:"varint,8,opt,name=encipher_only,json=encipherOnly,proto3" json:"encipher_only,omitempty"`
	// The key may be used to decipher only.
	DecipherOnly bool `protobuf:"varint,9,opt,name=decipher_only,json=decipherOnly,proto3" json:"decipher_only,omitempty"`
}

func (x *KeyUsage_KeyUsageOptions) Reset() {
	*x = KeyUsage_KeyUsageOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage_KeyUsageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage_KeyUsageOptions) ProtoMessage() {}

func (x *KeyUsage_KeyUsageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage_KeyUsageOptions.ProtoReflect.Descriptor instead.
func (*KeyUsage_KeyUsageOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *KeyUsage_KeyUsageOptions) GetDigitalSignature() bool {
	if x != nil {
		return x.DigitalSignature
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetContentCommitment() bool {
	if x != nil {
		return x.ContentCommitment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetKeyEncipherment() bool {
	if x != nil {
		return x.KeyEncipherment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetDataEncipherment() bool {
	if x != nil {
		return x.DataEncipherment
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetKeyAgreement() bool {
	if x != nil {
		return x.KeyAgreement
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetCertSign() bool {
	if x != nil {
		return x.CertSign
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetCrlSign() bool {
	if x != nil {
		return x.CrlSign
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetEncipherOnly() bool {
	if x != nil {
		return x.EncipherOnly
	}
	return false
}

func (x *KeyUsage_KeyUsageOptions) GetDecipherOnly() bool {
	if x != nil {
		return x.DecipherOnly
	}
	return false
}

// [KeyUsage.ExtendedKeyUsageOptions][google.cloud.security.privateca.v1beta1.KeyUsage.ExtendedKeyUsageOptions] has fields that correspond to
// certain common OIDs that could be specified as an extended key usage value.
type KeyUsage_ExtendedKeyUsageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW
	// server authentication", though regularly used for non-WWW TLS.
	ServerAuth bool `protobuf:"varint,1,opt,name=server_auth,json=serverAuth,proto3" json:"server_auth,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW
	// client authentication", though regularly used for non-WWW TLS.
	ClientAuth bool `protobuf:"varint,2,opt,name=client_auth,json=clientAuth,proto3" json:"client_auth,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of
	// downloadable executable code client authentication".
	CodeSigning bool `protobuf:"varint,3,opt,name=code_signing,json=codeSigning,proto3" json:"code_signing,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email
	// protection".
	EmailProtection bool `protobuf:"varint,4,opt,name=email_protection,json=emailProtection,proto3" json:"email_protection,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding
	// the hash of an object to a time".
	TimeStamping bool `protobuf:"varint,5,opt,name=time_stamping,json=timeStamping,proto3" json:"time_stamping,omitempty"`
	// Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing
	// OCSP responses".
	OcspSigning bool `protobuf:"varint,6,opt,name=ocsp_signing,json=ocspSigning,proto3" json:"ocsp_signing,omitempty"`
}

func (x *KeyUsage_ExtendedKeyUsageOptions) Reset() {
	*x = KeyUsage_ExtendedKeyUsageOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyUsage_ExtendedKeyUsageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyUsage_ExtendedKeyUsageOptions) ProtoMessage() {}

func (x *KeyUsage_ExtendedKeyUsageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyUsage_ExtendedKeyUsageOptions.ProtoReflect.Descriptor instead.
func (*KeyUsage_ExtendedKeyUsageOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP(), []int{12, 1}
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetServerAuth() bool {
	if x != nil {
		return x.ServerAuth
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetClientAuth() bool {
	if x != nil {
		return x.ClientAuth
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetCodeSigning() bool {
	if x != nil {
		return x.CodeSigning
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetEmailProtection() bool {
	if x != nil {
		return x.EmailProtection
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetTimeStamping() bool {
	if x != nil {
		return x.TimeStamping
	}
	return false
}

func (x *KeyUsage_ExtendedKeyUsageOptions) GetOcspSigning() bool {
	if x != nil {
		return x.OcspSigning
	}
	return false
}

var File_google_cloud_security_privateca_v1beta1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_security_privateca_v1beta1_resources_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x21,
	0x0a, 0x14, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x5e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x5e, 0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x69, 0x65,
	0x72, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12,
	0x5a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x08, 0x6c,
	0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c,
	0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x6f, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52,
	0x07, 0x6b, 0x65, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x8c, 0x01, 0x0a, 0x12, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x7a, 0x0a, 0x0f, 0x69, 0x73, 0x73, 0x75, 0x69,
	0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x65, 0x6d, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x1b, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x22, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x6e, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x75, 0x72,
	0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72,
	0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55,
	0x72, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x1a, 0x7e, 0x0a, 0x0e, 0x49, 0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x63,
	0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x43, 0x61,
	0x43, 0x65, 0x72, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x38, 0x0a, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x63, 0x72, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x43, 0x72, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72,
	0x6c, 0x1a, 0x88, 0x0c, 0x0a, 0x1a, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xa1, 0x01, 0x0a, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x7d, 0x0a, 0x17, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x57, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x6f, 0x76,
	0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x23, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41, 0x6e, 0x64, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x97, 0x01, 0x0a, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x73, 0x61,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x61, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x10, 0x6d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x4c, 0x69,
	0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0xa1, 0x01, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x73, 0x73,
	0x75, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x73, 0x1a, 0x8c, 0x01, 0x0a, 0x11, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x77, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xcb, 0x02, 0x0a, 0x16, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x64, 0x6e, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x44, 0x6e, 0x73,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x12, 0x3b, 0x0a,
	0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49, 0x70, 0x73,
	0x12, 0x44, 0x0a, 0x1c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x62, 0x69,
	0x6e, 0x67, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x77, 0x69, 0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x47, 0x6c, 0x6f, 0x62, 0x62, 0x69, 0x6e, 0x67, 0x44, 0x6e, 0x73, 0x57, 0x69, 0x6c,
	0x64, 0x63, 0x61, 0x72, 0x64, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x61, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x53, 0x61, 0x6e, 0x73, 0x1a, 0x91, 0x01, 0x0a, 0x0d, 0x49, 0x73, 0x73, 0x75,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x18, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x63, 0x73, 0x72, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x73, 0x73,
	0x75, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x73, 0x72, 0x42, 0x61, 0x73, 0x65, 0x64, 0x49,
	0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x73,
	0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x18, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x6d, 0x0a, 0x0a,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x63, 0x61,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x63,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x55, 0x72, 0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x63, 0x72, 0x6c, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x72, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x1a, 0xce, 0x01, 0x0a, 0x0e,
	0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x38,
	0x0a, 0x15, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x4b, 0x6d, 0x73, 0x4b, 0x65,
	0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x48,
	0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x0c,
	0x0a, 0x0a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x45, 0x4c, 0x46, 0x5f, 0x53, 0x49,
	0x47, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x55, 0x42, 0x4f, 0x52, 0x44,
	0x49, 0x4e, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0x38, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52,
	0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x56, 0x4f, 0x50, 0x53, 0x10,
	0x02, 0x22, 0x67, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x22, 0xfc, 0x01, 0x0a, 0x11, 0x53,
	0x69, 0x67, 0x6e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x12, 0x23, 0x0a, 0x1f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x41, 0x4c,
	0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53,
	0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x17,
	0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53,
	0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x53, 0x41, 0x5f, 0x50,
	0x53, 0x53, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x03,
	0x12, 0x19, 0x0a, 0x15, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x32, 0x30,
	0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x52,
	0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48,
	0x41, 0x32, 0x35, 0x36, 0x10, 0x07, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b,
	0x43, 0x53, 0x31, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x08, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x43, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x43, 0x5f, 0x50, 0x33, 0x38, 0x34,
	0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x05, 0x3a, 0x8b, 0x01, 0xea, 0x41, 0x87, 0x01,
	0x0a, 0x2d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x22, 0x9b, 0x09, 0x0a, 0x19, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x8d, 0x01, 0x0a,
	0x14, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e,
	0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x07,
	0x70, 0x65, 0x6d, 0x5f, 0x63, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x70, 0x65, 0x6d, 0x43, 0x72, 0x6c, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x6c, 0x12, 0x63,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73,
	0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x1a, 0xca, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a,
	0x11, 0x68, 0x65, 0x78, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x68, 0x65, 0x78, 0x53, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x11, 0x72, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52,
	0x10, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3a, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x50, 0x45,
	0x52, 0x53, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x3a, 0xca, 0x01, 0xea, 0x41, 0xc6, 0x01, 0x0a,
	0x32, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x8f, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x2f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x7d, 0x22, 0xd7, 0x09, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e,
	0x0a, 0x07, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x73, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x06, 0x70, 0x65, 0x6d, 0x43, 0x73, 0x72, 0x12, 0x59,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x08, 0x6c, 0x69, 0x66,
	0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x08,
	0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x7a, 0x0a, 0x12, 0x72, 0x65, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x7d, 0x0a, 0x17, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x0a, 0x15, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xbe, 0x01,
	0x0a, 0x11, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x72, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e,
	0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01,
	0x0a, 0x24, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x71, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x7d, 0x42, 0x14, 0x0a, 0x12, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0xc6, 0x04, 0x0a, 0x0e, 0x52, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x60, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x77, 0xea, 0x41, 0x74, 0x0a, 0x27, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xeb, 0x04, 0x0a, 0x14, 0x52, 0x65, 0x75,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x53, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b,
	0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x6b, 0x0a, 0x0a, 0x63, 0x61, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x61, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x61, 0x69,
	0x61, 0x5f, 0x6f, 0x63, 0x73, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x69, 0x61, 0x4f, 0x63,
	0x73, 0x70, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x70, 0x0a, 0x15, 0x61, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x98, 0x01, 0x0a, 0x09,
	0x43, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a, 0x05, 0x69, 0x73, 0x5f,
	0x63, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x69, 0x73, 0x43, 0x61, 0x12,
	0x55, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0xd4, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x75, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x12, 0x2e, 0x0a, 0x0f, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00,
	0x52, 0x0e, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x7a, 0x0a, 0x16, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x0f, 0x0a, 0x0d,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xb4, 0x02,
	0x0a, 0x11, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x14, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x82, 0x01, 0x0a, 0x10, 0x70, 0x65, 0x6d, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x5f, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x43,
	0x68, 0x61, 0x69, 0x6e, 0x1a, 0x48, 0x0a, 0x16, 0x53, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x2e,
	0x0a, 0x10, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70,
	0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x42, 0x14,
	0x0a, 0x12, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xbd, 0x01, 0x0a, 0x09, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x44,
	0x0a, 0x07, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4b, 0x45, 0x59,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x4d, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x4b,
	0x45, 0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x4d, 0x5f, 0x45, 0x43, 0x5f, 0x4b,
	0x45, 0x59, 0x10, 0x02, 0x22, 0xc1, 0x04, 0x0a, 0x11, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x0e, 0x73, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6c, 0x0a, 0x0f, 0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x72, 0x65, 0x75, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56,
	0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x1a, 0xef, 0x01, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x67, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xe1, 0x0a, 0x0a, 0x16, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x13, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x51, 0x0a,
	0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x12, 0x6b, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x52,
	0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x6f, 0x0a,
	0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x52, 0x0e,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x36,
	0x0a, 0x17, 0x63, 0x72, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x15, 0x63, 0x72, 0x6c, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x69, 0x61, 0x5f, 0x69, 0x73,
	0x73, 0x75, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x61, 0x69,
	0x61, 0x49, 0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x63, 0x65, 0x72, 0x74,
	0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x0f, 0x63, 0x65, 0x72, 0x74,
	0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x1a, 0xce, 0x03, 0x0a, 0x12,
	0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x62, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x68, 0x65, 0x78, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x68, 0x65, 0x78, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x35, 0x0a, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x69,
	0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x6e, 0x6f, 0x74, 0x5f, 0x62, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6e, 0x6f, 0x74,
	0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x6e, 0x6f,
	0x74, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c,
	0x6e, 0x6f, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x23, 0x0a, 0x05,
	0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49,
	0x64, 0x1a, 0x39, 0x0a, 0x16, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x68, 0x61, 0x32, 0x35, 0x36, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x48, 0x61, 0x73, 0x68, 0x22, 0x35, 0x0a, 0x08,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x50,
	0x61, 0x74, 0x68, 0x22, 0xa0, 0x01, 0x0a, 0x0d, 0x58, 0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x72,
	0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc1, 0x07, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x67, 0x0a, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4b,
	0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c,
	0x62, 0x61, 0x73, 0x65, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x77, 0x0a, 0x12,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x10, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65, 0x79,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x70, 0x0a, 0x1b, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x52, 0x18, 0x75,
	0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x4b, 0x65,
	0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xec, 0x02, 0x0a, 0x0f, 0x4b, 0x65, 0x79, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x64,
	0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f, 0x65,
	0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x6b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x6e, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x41, 0x67, 0x72, 0x65, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x69, 0x67,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x65, 0x72, 0x74, 0x53, 0x69, 0x67,
	0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x72, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x72, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x65, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x6e, 0x6c,
	0x79, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x65, 0x63, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x79, 0x1a, 0xf1, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x41, 0x75, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x69, 0x67,
	0x6e, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x63, 0x6f, 0x64, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x53,
	0x74, 0x61, 0x6d, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x63, 0x73, 0x70, 0x5f,
	0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6f,
	0x63, 0x73, 0x70, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x22, 0x81, 0x02, 0x0a, 0x07, 0x53,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a,
	0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xe7,
	0x01, 0x0a, 0x0f, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x6e, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x64, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75,
	0x72, 0x69, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12,
	0x57, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x61, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x58,
	0x35, 0x30, 0x39, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x53, 0x61, 0x6e, 0x73, 0x2a, 0x87, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x21, 0x0a,
	0x1d, 0x52, 0x45, 0x56, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x12, 0x0a, 0x0e, 0x4b, 0x45, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49,
	0x53, 0x45, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43,
	0x41, 0x54, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x46,
	0x46, 0x49, 0x4c, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x50, 0x45, 0x52, 0x53, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x45, 0x53, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4f, 0x46, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12,
	0x14, 0x0a, 0x10, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x48,
	0x4f, 0x4c, 0x44, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45,
	0x47, 0x45, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x44, 0x52, 0x41, 0x57, 0x4e, 0x10, 0x07, 0x12, 0x22,
	0x0a, 0x1e, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45,
	0x10, 0x08, 0x42, 0x9f, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x17, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x61, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0xf8,
	0x01, 0x01, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x41, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x27, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x41, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x3a, 0x3a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x41, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescData = file_google_cloud_security_privateca_v1beta1_resources_proto_rawDesc
)

func file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescData)
	})
	return file_google_cloud_security_privateca_v1beta1_resources_proto_rawDescData
}

var file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 36)
var file_google_cloud_security_privateca_v1beta1_resources_proto_goTypes = []interface{}{
	(RevocationReason)(0),                                   // 0: google.cloud.security.privateca.v1beta1.RevocationReason
	(CertificateAuthority_Type)(0),                          // 1: google.cloud.security.privateca.v1beta1.CertificateAuthority.Type
	(CertificateAuthority_Tier)(0),                          // 2: google.cloud.security.privateca.v1beta1.CertificateAuthority.Tier
	(CertificateAuthority_State)(0),                         // 3: google.cloud.security.privateca.v1beta1.CertificateAuthority.State
	(CertificateAuthority_SignHashAlgorithm)(0),             // 4: google.cloud.security.privateca.v1beta1.CertificateAuthority.SignHashAlgorithm
	(CertificateRevocationList_State)(0),                    // 5: google.cloud.security.privateca.v1beta1.CertificateRevocationList.State
	(PublicKey_KeyType)(0),                                  // 6: google.cloud.security.privateca.v1beta1.PublicKey.KeyType
	(*CertificateAuthority)(nil),                            // 7: google.cloud.security.privateca.v1beta1.CertificateAuthority
	(*CertificateRevocationList)(nil),                       // 8: google.cloud.security.privateca.v1beta1.CertificateRevocationList
	(*Certificate)(nil),                                     // 9: google.cloud.security.privateca.v1beta1.Certificate
	(*ReusableConfig)(nil),                                  // 10: google.cloud.security.privateca.v1beta1.ReusableConfig
	(*ReusableConfigValues)(nil),                            // 11: google.cloud.security.privateca.v1beta1.ReusableConfigValues
	(*ReusableConfigWrapper)(nil),                           // 12: google.cloud.security.privateca.v1beta1.ReusableConfigWrapper
	(*SubordinateConfig)(nil),                               // 13: google.cloud.security.privateca.v1beta1.SubordinateConfig
	(*PublicKey)(nil),                                       // 14: google.cloud.security.privateca.v1beta1.PublicKey
	(*CertificateConfig)(nil),                               // 15: google.cloud.security.privateca.v1beta1.CertificateConfig
	(*CertificateDescription)(nil),                          // 16: google.cloud.security.privateca.v1beta1.CertificateDescription
	(*ObjectId)(nil),                                        // 17: google.cloud.security.privateca.v1beta1.ObjectId
	(*X509Extension)(nil),                                   // 18: google.cloud.security.privateca.v1beta1.X509Extension
	(*KeyUsage)(nil),                                        // 19: google.cloud.security.privateca.v1beta1.KeyUsage
	(*Subject)(nil),                                         // 20: google.cloud.security.privateca.v1beta1.Subject
	(*SubjectAltNames)(nil),                                 // 21: google.cloud.security.privateca.v1beta1.SubjectAltNames
	(*CertificateAuthority_IssuingOptions)(nil),             // 22: google.cloud.security.privateca.v1beta1.CertificateAuthority.IssuingOptions
	(*CertificateAuthority_CertificateAuthorityPolicy)(nil), // 23: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy
	(*CertificateAuthority_AccessUrls)(nil),                 // 24: google.cloud.security.privateca.v1beta1.CertificateAuthority.AccessUrls
	(*CertificateAuthority_KeyVersionSpec)(nil),             // 25: google.cloud.security.privateca.v1beta1.CertificateAuthority.KeyVersionSpec
	nil, // 26: google.cloud.security.privateca.v1beta1.CertificateAuthority.LabelsEntry
	(*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList)(nil),      // 27: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedConfigList
	(*CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames)(nil), // 28: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames
	(*CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes)(nil),          // 29: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.IssuanceModes
	(*CertificateRevocationList_RevokedCertificate)(nil),                           // 30: google.cloud.security.privateca.v1beta1.CertificateRevocationList.RevokedCertificate
	nil,                                    // 31: google.cloud.security.privateca.v1beta1.CertificateRevocationList.LabelsEntry
	(*Certificate_RevocationDetails)(nil),  // 32: google.cloud.security.privateca.v1beta1.Certificate.RevocationDetails
	nil,                                    // 33: google.cloud.security.privateca.v1beta1.Certificate.LabelsEntry
	nil,                                    // 34: google.cloud.security.privateca.v1beta1.ReusableConfig.LabelsEntry
	(*ReusableConfigValues_CaOptions)(nil), // 35: google.cloud.security.privateca.v1beta1.ReusableConfigValues.CaOptions
	(*SubordinateConfig_SubordinateConfigChain)(nil),      // 36: google.cloud.security.privateca.v1beta1.SubordinateConfig.SubordinateConfigChain
	(*CertificateConfig_SubjectConfig)(nil),               // 37: google.cloud.security.privateca.v1beta1.CertificateConfig.SubjectConfig
	(*CertificateDescription_SubjectDescription)(nil),     // 38: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription
	(*CertificateDescription_KeyId)(nil),                  // 39: google.cloud.security.privateca.v1beta1.CertificateDescription.KeyId
	(*CertificateDescription_CertificateFingerprint)(nil), // 40: google.cloud.security.privateca.v1beta1.CertificateDescription.CertificateFingerprint
	(*KeyUsage_KeyUsageOptions)(nil),                      // 41: google.cloud.security.privateca.v1beta1.KeyUsage.KeyUsageOptions
	(*KeyUsage_ExtendedKeyUsageOptions)(nil),              // 42: google.cloud.security.privateca.v1beta1.KeyUsage.ExtendedKeyUsageOptions
	(*durationpb.Duration)(nil),                           // 43: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                         // 44: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),                          // 45: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),                         // 46: google.protobuf.Int32Value
}
var file_google_cloud_security_privateca_v1beta1_resources_proto_depIdxs = []int32{
	1,  // 0: google.cloud.security.privateca.v1beta1.CertificateAuthority.type:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.Type
	2,  // 1: google.cloud.security.privateca.v1beta1.CertificateAuthority.tier:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.Tier
	15, // 2: google.cloud.security.privateca.v1beta1.CertificateAuthority.config:type_name -> google.cloud.security.privateca.v1beta1.CertificateConfig
	43, // 3: google.cloud.security.privateca.v1beta1.CertificateAuthority.lifetime:type_name -> google.protobuf.Duration
	25, // 4: google.cloud.security.privateca.v1beta1.CertificateAuthority.key_spec:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.KeyVersionSpec
	23, // 5: google.cloud.security.privateca.v1beta1.CertificateAuthority.certificate_policy:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy
	22, // 6: google.cloud.security.privateca.v1beta1.CertificateAuthority.issuing_options:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.IssuingOptions
	13, // 7: google.cloud.security.privateca.v1beta1.CertificateAuthority.subordinate_config:type_name -> google.cloud.security.privateca.v1beta1.SubordinateConfig
	3,  // 8: google.cloud.security.privateca.v1beta1.CertificateAuthority.state:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.State
	16, // 9: google.cloud.security.privateca.v1beta1.CertificateAuthority.ca_certificate_descriptions:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription
	24, // 10: google.cloud.security.privateca.v1beta1.CertificateAuthority.access_urls:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.AccessUrls
	44, // 11: google.cloud.security.privateca.v1beta1.CertificateAuthority.create_time:type_name -> google.protobuf.Timestamp
	44, // 12: google.cloud.security.privateca.v1beta1.CertificateAuthority.update_time:type_name -> google.protobuf.Timestamp
	44, // 13: google.cloud.security.privateca.v1beta1.CertificateAuthority.delete_time:type_name -> google.protobuf.Timestamp
	26, // 14: google.cloud.security.privateca.v1beta1.CertificateAuthority.labels:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.LabelsEntry
	30, // 15: google.cloud.security.privateca.v1beta1.CertificateRevocationList.revoked_certificates:type_name -> google.cloud.security.privateca.v1beta1.CertificateRevocationList.RevokedCertificate
	5,  // 16: google.cloud.security.privateca.v1beta1.CertificateRevocationList.state:type_name -> google.cloud.security.privateca.v1beta1.CertificateRevocationList.State
	44, // 17: google.cloud.security.privateca.v1beta1.CertificateRevocationList.create_time:type_name -> google.protobuf.Timestamp
	44, // 18: google.cloud.security.privateca.v1beta1.CertificateRevocationList.update_time:type_name -> google.protobuf.Timestamp
	31, // 19: google.cloud.security.privateca.v1beta1.CertificateRevocationList.labels:type_name -> google.cloud.security.privateca.v1beta1.CertificateRevocationList.LabelsEntry
	15, // 20: google.cloud.security.privateca.v1beta1.Certificate.config:type_name -> google.cloud.security.privateca.v1beta1.CertificateConfig
	43, // 21: google.cloud.security.privateca.v1beta1.Certificate.lifetime:type_name -> google.protobuf.Duration
	32, // 22: google.cloud.security.privateca.v1beta1.Certificate.revocation_details:type_name -> google.cloud.security.privateca.v1beta1.Certificate.RevocationDetails
	16, // 23: google.cloud.security.privateca.v1beta1.Certificate.certificate_description:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription
	44, // 24: google.cloud.security.privateca.v1beta1.Certificate.create_time:type_name -> google.protobuf.Timestamp
	44, // 25: google.cloud.security.privateca.v1beta1.Certificate.update_time:type_name -> google.protobuf.Timestamp
	33, // 26: google.cloud.security.privateca.v1beta1.Certificate.labels:type_name -> google.cloud.security.privateca.v1beta1.Certificate.LabelsEntry
	11, // 27: google.cloud.security.privateca.v1beta1.ReusableConfig.values:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigValues
	44, // 28: google.cloud.security.privateca.v1beta1.ReusableConfig.create_time:type_name -> google.protobuf.Timestamp
	44, // 29: google.cloud.security.privateca.v1beta1.ReusableConfig.update_time:type_name -> google.protobuf.Timestamp
	34, // 30: google.cloud.security.privateca.v1beta1.ReusableConfig.labels:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfig.LabelsEntry
	19, // 31: google.cloud.security.privateca.v1beta1.ReusableConfigValues.key_usage:type_name -> google.cloud.security.privateca.v1beta1.KeyUsage
	35, // 32: google.cloud.security.privateca.v1beta1.ReusableConfigValues.ca_options:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigValues.CaOptions
	17, // 33: google.cloud.security.privateca.v1beta1.ReusableConfigValues.policy_ids:type_name -> google.cloud.security.privateca.v1beta1.ObjectId
	18, // 34: google.cloud.security.privateca.v1beta1.ReusableConfigValues.additional_extensions:type_name -> google.cloud.security.privateca.v1beta1.X509Extension
	11, // 35: google.cloud.security.privateca.v1beta1.ReusableConfigWrapper.reusable_config_values:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigValues
	36, // 36: google.cloud.security.privateca.v1beta1.SubordinateConfig.pem_issuer_chain:type_name -> google.cloud.security.privateca.v1beta1.SubordinateConfig.SubordinateConfigChain
	6,  // 37: google.cloud.security.privateca.v1beta1.PublicKey.type:type_name -> google.cloud.security.privateca.v1beta1.PublicKey.KeyType
	37, // 38: google.cloud.security.privateca.v1beta1.CertificateConfig.subject_config:type_name -> google.cloud.security.privateca.v1beta1.CertificateConfig.SubjectConfig
	12, // 39: google.cloud.security.privateca.v1beta1.CertificateConfig.reusable_config:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigWrapper
	14, // 40: google.cloud.security.privateca.v1beta1.CertificateConfig.public_key:type_name -> google.cloud.security.privateca.v1beta1.PublicKey
	38, // 41: google.cloud.security.privateca.v1beta1.CertificateDescription.subject_description:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription
	11, // 42: google.cloud.security.privateca.v1beta1.CertificateDescription.config_values:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigValues
	14, // 43: google.cloud.security.privateca.v1beta1.CertificateDescription.public_key:type_name -> google.cloud.security.privateca.v1beta1.PublicKey
	39, // 44: google.cloud.security.privateca.v1beta1.CertificateDescription.subject_key_id:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription.KeyId
	39, // 45: google.cloud.security.privateca.v1beta1.CertificateDescription.authority_key_id:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription.KeyId
	40, // 46: google.cloud.security.privateca.v1beta1.CertificateDescription.cert_fingerprint:type_name -> google.cloud.security.privateca.v1beta1.CertificateDescription.CertificateFingerprint
	17, // 47: google.cloud.security.privateca.v1beta1.X509Extension.object_id:type_name -> google.cloud.security.privateca.v1beta1.ObjectId
	41, // 48: google.cloud.security.privateca.v1beta1.KeyUsage.base_key_usage:type_name -> google.cloud.security.privateca.v1beta1.KeyUsage.KeyUsageOptions
	42, // 49: google.cloud.security.privateca.v1beta1.KeyUsage.extended_key_usage:type_name -> google.cloud.security.privateca.v1beta1.KeyUsage.ExtendedKeyUsageOptions
	17, // 50: google.cloud.security.privateca.v1beta1.KeyUsage.unknown_extended_key_usages:type_name -> google.cloud.security.privateca.v1beta1.ObjectId
	18, // 51: google.cloud.security.privateca.v1beta1.SubjectAltNames.custom_sans:type_name -> google.cloud.security.privateca.v1beta1.X509Extension
	27, // 52: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.allowed_config_list:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedConfigList
	12, // 53: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.overwrite_config_values:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigWrapper
	20, // 54: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.allowed_locations_and_organizations:type_name -> google.cloud.security.privateca.v1beta1.Subject
	28, // 55: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.allowed_sans:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedSubjectAltNames
	43, // 56: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.maximum_lifetime:type_name -> google.protobuf.Duration
	29, // 57: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.allowed_issuance_modes:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.IssuanceModes
	4,  // 58: google.cloud.security.privateca.v1beta1.CertificateAuthority.KeyVersionSpec.algorithm:type_name -> google.cloud.security.privateca.v1beta1.CertificateAuthority.SignHashAlgorithm
	12, // 59: google.cloud.security.privateca.v1beta1.CertificateAuthority.CertificateAuthorityPolicy.AllowedConfigList.allowed_config_values:type_name -> google.cloud.security.privateca.v1beta1.ReusableConfigWrapper
	0,  // 60: google.cloud.security.privateca.v1beta1.CertificateRevocationList.RevokedCertificate.revocation_reason:type_name -> google.cloud.security.privateca.v1beta1.RevocationReason
	0,  // 61: google.cloud.security.privateca.v1beta1.Certificate.RevocationDetails.revocation_state:type_name -> google.cloud.security.privateca.v1beta1.RevocationReason
	44, // 62: google.cloud.security.privateca.v1beta1.Certificate.RevocationDetails.revocation_time:type_name -> google.protobuf.Timestamp
	45, // 63: google.cloud.security.privateca.v1beta1.ReusableConfigValues.CaOptions.is_ca:type_name -> google.protobuf.BoolValue
	46, // 64: google.cloud.security.privateca.v1beta1.ReusableConfigValues.CaOptions.max_issuer_path_length:type_name -> google.protobuf.Int32Value
	20, // 65: google.cloud.security.privateca.v1beta1.CertificateConfig.SubjectConfig.subject:type_name -> google.cloud.security.privateca.v1beta1.Subject
	21, // 66: google.cloud.security.privateca.v1beta1.CertificateConfig.SubjectConfig.subject_alt_name:type_name -> google.cloud.security.privateca.v1beta1.SubjectAltNames
	20, // 67: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription.subject:type_name -> google.cloud.security.privateca.v1beta1.Subject
	21, // 68: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription.subject_alt_name:type_name -> google.cloud.security.privateca.v1beta1.SubjectAltNames
	43, // 69: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription.lifetime:type_name -> google.protobuf.Duration
	44, // 70: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription.not_before_time:type_name -> google.protobuf.Timestamp
	44, // 71: google.cloud.security.privateca.v1beta1.CertificateDescription.SubjectDescription.not_after_time:type_name -> google.protobuf.Timestamp
	72, // [72:72] is the sub-list for method output_type
	72, // [72:72] is the sub-list for method input_type
	72, // [72:72] is the sub-list for extension type_name
	72, // [72:72] is the sub-list for extension extendee
	0,  // [0:72] is the sub-list for field type_name
}

func init() { file_google_cloud_security_privateca_v1beta1_resources_proto_init() }
func file_google_cloud_security_privateca_v1beta1_resources_proto_init() {
	if File_google_cloud_security_privateca_v1beta1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRevocationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReusableConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReusableConfigValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReusableConfigWrapper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubordinateConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Extension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubjectAltNames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_IssuingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_CertificateAuthorityPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_AccessUrls); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_KeyVersionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_CertificateAuthorityPolicy_AllowedSubjectAltNames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateAuthority_CertificateAuthorityPolicy_IssuanceModes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRevocationList_RevokedCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_RevocationDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReusableConfigValues_CaOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubordinateConfig_SubordinateConfigChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateConfig_SubjectConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_SubjectDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_KeyId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateDescription_CertificateFingerprint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage_KeyUsageOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyUsage_ExtendedKeyUsageOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Certificate_PemCsr)(nil),
		(*Certificate_Config)(nil),
	}
	file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ReusableConfigWrapper_ReusableConfig)(nil),
		(*ReusableConfigWrapper_ReusableConfigValues)(nil),
	}
	file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*SubordinateConfig_CertificateAuthority)(nil),
		(*SubordinateConfig_PemIssuerChain)(nil),
	}
	file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*CertificateAuthority_CertificateAuthorityPolicy_AllowedConfigList_)(nil),
		(*CertificateAuthority_CertificateAuthorityPolicy_OverwriteConfigValues)(nil),
	}
	file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*CertificateAuthority_KeyVersionSpec_CloudKmsKeyVersion)(nil),
		(*CertificateAuthority_KeyVersionSpec_Algorithm)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_security_privateca_v1beta1_resources_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   36,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_security_privateca_v1beta1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_security_privateca_v1beta1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_security_privateca_v1beta1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_security_privateca_v1beta1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_security_privateca_v1beta1_resources_proto = out.File
	file_google_cloud_security_privateca_v1beta1_resources_proto_rawDesc = nil
	file_google_cloud_security_privateca_v1beta1_resources_proto_goTypes = nil
	file_google_cloud_security_privateca_v1beta1_resources_proto_depIdxs = nil
}
