// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to describe.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDatasetGroupInput"}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the dataset group's properties.
	DatasetGroup *DatasetGroup `locationName:"datasetGroup" type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDatasetGroup = "DescribeDatasetGroup"

// DescribeDatasetGroupRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes the given dataset group. For more information on dataset groups,
// see CreateDatasetGroup.
//
//    // Example sending a request using DescribeDatasetGroupRequest.
//    req := client.DescribeDatasetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup
func (c *Client) DescribeDatasetGroupRequest(input *DescribeDatasetGroupInput) DescribeDatasetGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeDatasetGroupOutput{})
	return DescribeDatasetGroupRequest{Request: req, Input: input, Copy: c.DescribeDatasetGroupRequest}
}

// DescribeDatasetGroupRequest is the request type for the
// DescribeDatasetGroup API operation.
type DescribeDatasetGroupRequest struct {
	*aws.Request
	Input *DescribeDatasetGroupInput
	Copy  func(*DescribeDatasetGroupInput) DescribeDatasetGroupRequest
}

// Send marshals and sends the DescribeDatasetGroup API request.
func (r DescribeDatasetGroupRequest) Send(ctx context.Context) (*DescribeDatasetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDatasetGroupResponse{
		DescribeDatasetGroupOutput: r.Request.Data.(*DescribeDatasetGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDatasetGroupResponse is the response type for the
// DescribeDatasetGroup API operation.
type DescribeDatasetGroupResponse struct {
	*DescribeDatasetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDatasetGroup request.
func (r *DescribeDatasetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
