// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mediaconnectiface provides an interface to enable mocking the AWS MediaConnect service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mediaconnectiface

import (
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect"
)

// ClientAPI provides an interface to enable mocking the
// mediaconnect.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS MediaConnect.
//    func myFunc(svc mediaconnectiface.ClientAPI) bool {
//        // Make svc.AddFlowOutputs request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := mediaconnect.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        mediaconnectiface.ClientPI
//    }
//    func (m *mockClientClient) AddFlowOutputs(input *mediaconnect.AddFlowOutputsInput) (*mediaconnect.AddFlowOutputsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddFlowOutputsRequest(*mediaconnect.AddFlowOutputsInput) mediaconnect.AddFlowOutputsRequest

	CreateFlowRequest(*mediaconnect.CreateFlowInput) mediaconnect.CreateFlowRequest

	DeleteFlowRequest(*mediaconnect.DeleteFlowInput) mediaconnect.DeleteFlowRequest

	DescribeFlowRequest(*mediaconnect.DescribeFlowInput) mediaconnect.DescribeFlowRequest

	GrantFlowEntitlementsRequest(*mediaconnect.GrantFlowEntitlementsInput) mediaconnect.GrantFlowEntitlementsRequest

	ListEntitlementsRequest(*mediaconnect.ListEntitlementsInput) mediaconnect.ListEntitlementsRequest

	ListFlowsRequest(*mediaconnect.ListFlowsInput) mediaconnect.ListFlowsRequest

	ListTagsForResourceRequest(*mediaconnect.ListTagsForResourceInput) mediaconnect.ListTagsForResourceRequest

	RemoveFlowOutputRequest(*mediaconnect.RemoveFlowOutputInput) mediaconnect.RemoveFlowOutputRequest

	RevokeFlowEntitlementRequest(*mediaconnect.RevokeFlowEntitlementInput) mediaconnect.RevokeFlowEntitlementRequest

	StartFlowRequest(*mediaconnect.StartFlowInput) mediaconnect.StartFlowRequest

	StopFlowRequest(*mediaconnect.StopFlowInput) mediaconnect.StopFlowRequest

	TagResourceRequest(*mediaconnect.TagResourceInput) mediaconnect.TagResourceRequest

	UntagResourceRequest(*mediaconnect.UntagResourceInput) mediaconnect.UntagResourceRequest

	UpdateFlowEntitlementRequest(*mediaconnect.UpdateFlowEntitlementInput) mediaconnect.UpdateFlowEntitlementRequest

	UpdateFlowOutputRequest(*mediaconnect.UpdateFlowOutputInput) mediaconnect.UpdateFlowOutputRequest

	UpdateFlowSourceRequest(*mediaconnect.UpdateFlowSourceInput) mediaconnect.UpdateFlowSourceRequest
}

var _ ClientAPI = (*mediaconnect.Client)(nil)
