// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UnsubscribeFromEventInput struct {
	_ struct{} `type:"structure"`

	// The event for which you want to stop receiving SNS notifications.
	//
	// Event is a required field
	Event InspectorEvent `locationName:"event" type:"string" required:"true" enum:"true"`

	// The ARN of the assessment template that is used during the event for which
	// you want to stop receiving SNS notifications.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The ARN of the SNS topic to which SNS notifications are sent.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"topicArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeFromEventInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeFromEventInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnsubscribeFromEventInput"}
	if len(s.Event) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Event"))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UnsubscribeFromEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeFromEventOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnsubscribeFromEvent = "UnsubscribeFromEvent"

// UnsubscribeFromEventRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Disables the process of sending Amazon Simple Notification Service (SNS)
// notifications about a specified event to a specified SNS topic.
//
//    // Example sending a request using UnsubscribeFromEventRequest.
//    req := client.UnsubscribeFromEventRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent
func (c *Client) UnsubscribeFromEventRequest(input *UnsubscribeFromEventInput) UnsubscribeFromEventRequest {
	op := &aws.Operation{
		Name:       opUnsubscribeFromEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnsubscribeFromEventInput{}
	}

	req := c.newRequest(op, input, &UnsubscribeFromEventOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UnsubscribeFromEventRequest{Request: req, Input: input, Copy: c.UnsubscribeFromEventRequest}
}

// UnsubscribeFromEventRequest is the request type for the
// UnsubscribeFromEvent API operation.
type UnsubscribeFromEventRequest struct {
	*aws.Request
	Input *UnsubscribeFromEventInput
	Copy  func(*UnsubscribeFromEventInput) UnsubscribeFromEventRequest
}

// Send marshals and sends the UnsubscribeFromEvent API request.
func (r UnsubscribeFromEventRequest) Send(ctx context.Context) (*UnsubscribeFromEventResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnsubscribeFromEventResponse{
		UnsubscribeFromEventOutput: r.Request.Data.(*UnsubscribeFromEventOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnsubscribeFromEventResponse is the response type for the
// UnsubscribeFromEvent API operation.
type UnsubscribeFromEventResponse struct {
	*UnsubscribeFromEventOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnsubscribeFromEvent request.
func (r *UnsubscribeFromEventResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
