//! Configuration lookup, parsing and validation.
//!
//! This module takes care of sourcing configuration options from
//! multiple inputs (CLI and files), merging, and validating them.
//! It contains the following entities:
//!  * "options": configuration fragments (CLI flags, file snippets).
//!  * "app settings": runtime settings, result of config validation.

mod cli;
mod file;
mod options;
mod settings;

pub use self::settings::AppSettings;

/// Common prefix for graph-builder metrics.
pub const METRICS_PREFIX: &str = "cincinnati_gb";
