package metadata

releases: "0.12.0": {
	date:        "2021-03-10"
	codename:    "Vector Remap Language"
	description: """
		The Vector team is pleased to announce 0.12.0. This release	introduces the [**Vector Remap Language**](\(urls.vrl_reference)),
		an expression-oriented language designed for transforming observability data (logs and metrics) in a
		[safe](\(urls.vrl_safety)) and [performant](\(urls.vrl_performance)) manner.

		Check out the [VRL announcement post](\(urls.vrl_announcement)) for more details as well as the
		[highlights](#highlights) and [changelog](#changelog) for a complete list of changes in 0.12.0.
		"""

	whats_next: [
		{
			title: "Vector's own observability"
			description: """
				We will be working to improve Vector's own observability with high-quality internal metrics, logs,
				CLI tools, and dashboards.
				"""
		},
		{
			title: "Improved Vector to Vector communication"
			description: """
				The `vector` source and sink currently leverage the TCP protocol to transmit data. While this has
				served users well, it presents operational challenges for large-scale deployments of Vector. Because
				HTTP is widely used and easy to integrate into platforms like Kubernetes we will be moving these
				components to the HTTP protocol.
				"""
		},
		{
			title:       "Schema support"
			description: """
				With the inclusion of [type-safety in VRL](\(urls.vrl_type_safety)) we will be working to officially
				support common and custom schemas within Vector. This will be an opt-in feature that will provide
				Vector with type information about your data, making Vector type safe from end to end and further
				raising confidence that Vector will operate properly post-deployment.
				"""
		},
	]

	commits: [
		{sha: "5ae2247d946733fc0f53d03d12afe83a2998cb7e", date: "2020-12-02 19:50:10 UTC", description: "Add UNIX datagram mode", pr_number:                                                          5298, scopes: ["socket source"], type:                                       "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             8, insertions_count:  272, deletions_count:  64},
		{sha: "cb73ba0bc7d8bcb80578872181c7e539986060ea", date: "2020-12-03 21:38:10 UTC", description: "support path queries for variables", pr_number:                                              5277, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                72, insertions_count: 2230, deletions_count: 449},
		{sha: "e19264990fc8f5b75d55f52c49460e8893690e01", date: "2020-12-03 22:15:25 UTC", description: "add support for literal arrays", pr_number:                                                  5278, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                6, insertions_count:  145, deletions_count:  14},
		{sha: "e9371ac1de252bb667a8c6d833dbd0ecfdb882b3", date: "2020-12-03 22:48:07 UTC", description: "accept array of arguments for function parameters", pr_number:                               5283, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                12, insertions_count: 303, deletions_count:  40},
		{sha: "c920bc7c95745e4d369e0c25fe38cb1ca071ee2a", date: "2020-12-04 19:14:56 UTC", description: "add `redact` function", pr_number:                                                           5297, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                4, insertions_count:  235, deletions_count:  0},
		{sha: "687456cc3a067905e8349df4c0ab557795105406", date: "2020-12-05 00:39:56 UTC", description: "Helm chart for deploying Vector with an aggregator role", pr_number:                         4404, scopes: ["administration"], type:                                      "feat", breaking_change:        false, author: "MOZGIII", files_count:                   32, insertions_count: 1262, deletions_count: 48},
		{sha: "a5d67b3038b7d90aee13284bccad4d8db8e6f411", date: "2020-12-05 04:34:40 UTC", description: "Support exposing internal mertics out of the box in our Helm charts", pr_number:             4854, scopes: ["kubernetes platform"], type:                                 "enhancement", breaking_change: false, author: "MOZGIII", files_count:                   24, insertions_count: 767, deletions_count:  8},
		{sha: "d4b7b306fe0af1354891920ff039917b61851849", date: "2020-12-05 09:17:05 UTC", description: "Add exclusion label at vector-aggregator", pr_number:                                        5388, scopes: ["kubernetes platform"], type:                                 "fix", breaking_change:         false, author: "MOZGIII", files_count:                   3, insertions_count:  3, deletions_count:    0},
		{sha: "2593d91b729e014abc4c8d2a79f6d4128e82baf6", date: "2020-12-05 07:34:25 UTC", description: "Implement TCP keepalive `time` configuration", pr_number:                                    5157, scopes: ["networking"], type:                                          "enhancement", breaking_change: false, author: "Pablo Sichert", files_count:             32, insertions_count: 313, deletions_count:  82},
		{sha: "f25d0420afb7e6c5321d62d75bc6c3ca28930145", date: "2020-12-08 21:18:37 UTC", description: "fixing Compression parsing with tests", pr_number:                                           5429, scopes: ["config"], type:                                              "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  101, deletions_count:  29},
		{sha: "8b3d59562d5665c60ecf255b2cadc68579acea94", date: "2020-12-09 06:45:47 UTC", description: "require features for generate_configfile test", pr_number:                                   5427, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  9, deletions_count:    9},
		{sha: "7fd382fd459986e5241963bb7fb1693fba12cf0a", date: "2020-12-08 21:12:30 UTC", description: "Enable excluding Docker containers via configuration", pr_number:                            5301, scopes: ["docker_logs source"], type:                                  "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               2, insertions_count:  99, deletions_count:   28},
		{sha: "3a48a0a47dd1e1b59113041a96cdced29937cc19", date: "2020-12-10 21:59:42 UTC", description: "Remove default `encoding.codec` where appropriate", pr_number:                               5281, scopes: ["codec"], type:                                               "enhancement", breaking_change: true, author:  "Kirill Fomichev", files_count:           18, insertions_count: 242, deletions_count:  244},
		{sha: "b1bc779d1fc96e06ddc34b11585fc1651ce2da86", date: "2020-12-11 03:52:44 UTC", description: "add initial \"trl\" CLI", pr_number:                                                         5450, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                5, insertions_count:  245, deletions_count:  1},
		{sha: "e04d32d0dfd513b95880ef2c1a7c8d362aac7317", date: "2020-12-11 04:02:01 UTC", description: "support multiline expressions", pr_number:                                                   5309, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                2, insertions_count:  11, deletions_count:   1},
		{sha: "b57f4d96a74da49c091aaf66d3974f5bd4330fdc", date: "2020-12-10 21:51:52 UTC", description: "Export metadata to remote_write", pr_number:                                                 5445, scopes: ["prometheus sink"], type:                                     "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             6, insertions_count:  441, deletions_count:  151},
		{sha: "feb0c0e7c6f9c21b4d1021076d9fec651ceba200", date: "2020-12-11 12:26:59 UTC", description: "Fix build issue caused by macro removal", pr_number:                                         5480, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             2, insertions_count:  13, deletions_count:   1},
		{sha: "f38fb43999a5bb0896ac55c8f901d70db3af0ab8", date: "2020-12-11 19:46:57 UTC", description: "New internal_logs source", pr_number:                                                        5346, scopes: ["new source"], type:                                          "feat", breaking_change:        false, author: "Bruce Guenter", files_count:             8, insertions_count:  404, deletions_count:  26},
		{sha: "44ecc2bf4c90f8903b858a681e32db0dbbaedda3", date: "2020-12-13 02:45:52 UTC", description: "Add support for basic auth credendtials in URL for more sinks", pr_number:                   5379, scopes: ["auth"], type:                                                "enhancement", breaking_change: false, author: "Duy Do", files_count:                    10, insertions_count: 247, deletions_count:  181},
		{sha: "565bc52ad0ba535a38e6a1f6a86575db205ffa36", date: "2020-12-13 19:54:38 UTC", description: "add integer division", pr_number:                                                            5353, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            6, insertions_count:  42, deletions_count:   3},
		{sha: "b40750a92083df2d33cfbd9deb58d75fe357fc20", date: "2020-12-13 21:52:35 UTC", description: "add initial CLI REPL support", pr_number:                                                    5490, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                7, insertions_count:  303, deletions_count:  68},
		{sha: "6e4b7a91e9119763ad1e803eba76523144ef8082", date: "2020-12-14 01:19:02 UTC", description: "allow multiple statements in boolean conditional", pr_number:                                5438, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                4, insertions_count:  46, deletions_count:   10},
		{sha: "da297f1c8fb2f0ce1c779cab38649c57e7091411", date: "2020-12-14 07:41:46 UTC", description: "Add missing methods to Subscriber forwarder", pr_number:                                     5529, scopes: ["metrics"], type:                                             "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             1, insertions_count:  10, deletions_count:   0},
		{sha: "1d3b7c1814dc33a29126e0ecbc217d54646b04a8", date: "2020-12-15 17:08:01 UTC", description: "Correct the prometheus format parsing at K8s E2E tests for the metrics pipeline", pr_number: 5540, scopes: ["kubernetes platform"], type:                                 "fix", breaking_change:         false, author: "MOZGIII", files_count:                   3, insertions_count:  28, deletions_count:   6},
		{sha: "38f0e7c90ff6d760993e0d0929c63215b749ab71", date: "2020-12-17 08:19:21 UTC", description: "Add host and TLS configuations", pr_number:                                                  5532, scopes: ["docker_logs source"], type:                                  "enhancement", breaking_change: false, author: "Duy Do", files_count:                    4, insertions_count:  150, deletions_count:  31},
		{sha: "171301191c8d5bc04409e7c3bf2b516e360c8f8b", date: "2020-12-17 04:47:04 UTC", description: "Implement improvements to the Pod recreation on Helm release upgrades", pr_number:           5525, scopes: ["kubernetes platform"], type:                                 "fix", breaking_change:         false, author: "MOZGIII", files_count:                   10, insertions_count: 96, deletions_count:   12},
		{sha: "bf29d061c79d755e89069a4aa16ac1e0d37c97c8", date: "2020-12-17 21:15:30 UTC", description: "add remap functions to CLI", pr_number:                                                      5531, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                11, insertions_count: 146, deletions_count:  73},
		{sha: "535d898c8c9e337942cc3a2d772174382abc4f66", date: "2020-12-17 23:35:25 UTC", description: "track inner container type definitions", pr_number:                                          5375, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                51, insertions_count: 414, deletions_count:  111},
		{sha: "a646ad908271ef6b81b16f769dc05fe20c23952f", date: "2020-12-18 06:11:50 UTC", description: "add `ok` error handling function", pr_number:                                                5469, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                5, insertions_count:  111, deletions_count:  1},
		{sha: "4b33ff0b9eeb8e112dbf7e0cc77c1b52fa11ca19", date: "2020-12-18 06:50:28 UTC", description: "add support for literal maps", pr_number:                                                    5279, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                16, insertions_count: 390, deletions_count:  181},
		{sha: "e46bf469aacf4616cbda578c9511427535be7509", date: "2020-12-18 10:49:37 UTC", description: "Expose host metrics in our Helm charts out of the box", pr_number:                           5100, scopes: ["kubernetes platform"], type:                                 "enhancement", breaking_change: false, author: "MOZGIII", files_count:                   8, insertions_count:  185, deletions_count:  7},
		{sha: "01e726af0e4d24e8a45345441420397e5a9e8803", date: "2020-12-18 11:36:37 UTC", description: "Add global `healthchecks` option", pr_number:                                                5528, scopes: ["config"], type:                                              "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        13, insertions_count: 153, deletions_count:  71},
		{sha: "9f760f2c7d57ff37fe2c0b7bfabda681b334e832", date: "2020-12-18 12:41:49 UTC", description: "Emit `processed_events_total` in topology for transforms", pr_number:                        5492, scopes: ["observability"], type:                                       "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        60, insertions_count: 47, deletions_count:   410},
		{sha: "6389e8866af00e72e36b7e4d91d42da7c908f7a9", date: "2020-12-18 18:11:02 UTC", description: "add `parse_aws_alb_log` function", pr_number:                                                5489, scopes: ["remap transform"], type:                                     "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           7, insertions_count:  403, deletions_count:  0},
		{sha: "e7316773675d04a5bf13bb20b67e2b88151b17df", date: "2020-12-18 18:32:07 UTC", description: "adjust deny.toml", pr_number:                                                                5552, scopes: ["ci"], type:                                                  "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:           3, insertions_count:  27, deletions_count:   30},
		{sha: "5f97129f8e2f5bc0e86f4e85d2d4dbf7cb2c2a09", date: "2020-12-18 22:12:18 UTC", description: "improve error messages, part 1", pr_number:                                                  5477, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                3, insertions_count:  100, deletions_count:  453},
		{sha: "5488be0a6252efe152bde9fd4babbffb7970fb75", date: "2020-12-19 02:03:10 UTC", description: "add `parse_aws_vpc_flow_log` function", pr_number:                                           5504, scopes: ["remap transform"], type:                                     "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           7, insertions_count:  365, deletions_count:  1},
		{sha: "c62b51511f61379c7e418c5a3de6e8c5ac687bf3", date: "2020-12-19 02:22:03 UTC", description: "add support for data streams", pr_number:                                                    5126, scopes: ["elasticsearch sink"], type:                                  "enhancement", breaking_change: false, author: "Spencer Gilbert", files_count:           3, insertions_count:  88, deletions_count:   6},
		{sha: "7cc42beec5d3e859f4278fdeca599bbf48b67189", date: "2020-12-19 00:33:55 UTC", description: "Enable format selection for generator source", pr_number:                                    5399, scopes: ["generator source"], type:                                    "enhancement", breaking_change: true, author:  "Luc Perkins", files_count:               11, insertions_count: 434, deletions_count:  102},
		{sha: "c12020dbccb7b04ff3c3a2165fb50d47cb9baa7a", date: "2020-12-19 05:25:31 UTC", description: "Add includes function for arrays", pr_number:                                                5541, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               5, insertions_count:  225, deletions_count:  1},
		{sha: "a3f086cb6035455d1a28a91a44597f383b7c7785", date: "2020-12-19 23:04:33 UTC", description: "enable remap to work with metric events", pr_number:                                         5475, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "FungusHumungus", files_count:            7, insertions_count:  841, deletions_count:  368},
		{sha: "91f77ef44a4dfa182c27cf3483a878ad576d8757", date: "2020-12-20 02:39:07 UTC", description: "fix set metric reset on flush period", pr_number:                                            5258, scopes: ["prometheus sink"], type:                                     "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  146, deletions_count:  77},
		{sha: "7b0424cbf22b88be759bbaf84110f887a429ee8a", date: "2020-12-20 00:53:10 UTC", description: "tenant_id is templatable on loki sink", pr_number:                                           5629, scopes: ["documentation"], type:                                       "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:             1, insertions_count:  2, deletions_count:    1},
		{sha: "8df93bc21eddce7f8be6ab3d3f4d12bec96fdc5b", date: "2020-12-20 07:47:45 UTC", description: "Fix type definition for `includes()`", pr_number:                                            5628, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:             2, insertions_count:  6, deletions_count:    0},
		{sha: "47734445cb07cf104bc0bebd8102075b7953962b", date: "2020-12-21 23:13:21 UTC", description: "Add to_syslog_level function for parsing Syslog levels into strings", pr_number:             5503, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               5, insertions_count:  200, deletions_count:  0},
		{sha: "b31cb7ec71765928194d14fd88f9718a3adf5f80", date: "2020-12-22 09:56:00 UTC", description: "docs for remap transform metrics", pr_number:                                                5626, scopes: ["remap transform"], type:                                     "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            1, insertions_count:  9, deletions_count:    2},
		{sha: "ecc26afd3f0d71adb27cb192fa2152862696f90e", date: "2020-12-22 04:02:33 UTC", description: "podman pod stop/rm don't need a --name option", pr_number:                                   5669, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             1, insertions_count:  25, deletions_count:   25},
		{sha: "b38ce3daef8e104aa518a9f5cb73c3794761de78", date: "2020-12-22 02:54:50 UTC", description: "Add to_syslog_severity function for Syslog log level keywords", pr_number:                   5505, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               4, insertions_count:  181, deletions_count:  0},
		{sha: "a894cf7cc5370f0d7176dc11a7b93838a045a2c9", date: "2020-12-22 19:36:50 UTC", description: "Allow owning the same port with different protocols", pr_number:                             5625, scopes: ["networking"], type:                                          "fix", breaking_change:         false, author: "Duy Do", files_count:                    10, insertions_count: 67, deletions_count:   22},
		{sha: "284e18f8b50de17a0673ebac8d6d8726fc325870", date: "2020-12-23 07:24:25 UTC", description: "Print warning on encoding error", pr_number:                                                 5651, scopes: ["codec", "observability"], type:                              "enhancement", breaking_change: false, author: "Duy Do", files_count:                    7, insertions_count:  110, deletions_count:  120},
		{sha: "ce9185eea202ceb5963a1e24b8f05d33600fcc16", date: "2020-12-23 04:55:05 UTC", description: "add encode_json function", pr_number:                                                        5653, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           6, insertions_count:  218, deletions_count:  1},
		{sha: "ee27b6835b44eeb753c50a89120fce34e89837f1", date: "2020-12-23 16:43:34 UTC", description: "handle incorrect int sequences as strings", pr_number:                                       5683, scopes: ["journald source"], type:                                     "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  21, deletions_count:   5},
		{sha: "5a2dffc230b183c1cbfe3f9828452e9b1e745fc5", date: "2020-12-23 23:51:49 UTC", description: "fix tests for fake journal", pr_number:                                                      5694, scopes: ["journald source"], type:                                     "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  3, deletions_count:    3},
		{sha: "ef45085f1c217fea58c9c608314baeae596945e2", date: "2020-12-24 08:51:29 UTC", description: "Support TLS configuration for Humio sinks", pr_number:                                       5692, scopes: ["networking", "security", "humio sink"], type:                "enhancement", breaking_change: false, author: "Duy Do", files_count:                    3, insertions_count:  17, deletions_count:   2},
		{sha: "740624539d5a543f34ff9c1c6a692238055bb5eb", date: "2020-12-24 06:34:24 UTC", description: "File source metrics", pr_number:                                                             5645, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                23, insertions_count: 1451, deletions_count: 674},
		{sha: "263616f958daf64c47986e32f8bc9fa0cb6a32a9", date: "2020-12-26 01:28:49 UTC", description: "Add hostname to Docker source", pr_number:                                                   5690, scopes: ["docker_logs source"], type:                                  "enhancement", breaking_change: false, author: "Duy Do", files_count:                    3, insertions_count:  40, deletions_count:   6},
		{sha: "63e49917bb75c176a27bf572240431d8ad926701", date: "2020-12-25 11:12:24 UTC", description: "Add JSON format", pr_number:                                                                 5630, scopes: ["generator source"], type:                                    "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  56, deletions_count:   4},
		{sha: "bbb5fb66e741496490ff6460e61679d75fc244f0", date: "2020-12-27 01:14:25 UTC", description: "Add RFC 3164 format", pr_number:                                                             5631, scopes: ["generator source"], type:                                    "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  50, deletions_count:   6},
		{sha: "6c4151f764b5ea4ad21181a5d2500ae93eeec53c", date: "2020-12-28 06:25:36 UTC", description: "Add `gzip` & `deflate` decompression", pr_number:                                            5638, scopes: ["http source"], type:                                         "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        10, insertions_count: 221, deletions_count:  65},
		{sha: "194353149be8652e82a7bcb381c7166d675e46a8", date: "2020-12-29 00:26:06 UTC", description: "`componentByName` query", pr_number:                                                         5707, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                8, insertions_count:  101, deletions_count:  12},
		{sha: "8877d141963b0502a2bbe878eddfd960b533c1d3", date: "2020-12-28 23:34:38 UTC", description: "lower handle http req log to debug", pr_number:                                              5705, scopes: ["http source"], type:                                         "fix", breaking_change:         false, author: "Spencer Gilbert", files_count:           1, insertions_count:  1, deletions_count:    1},
		{sha: "881ff658acc71703ea2a589bd69518fac1f0881e", date: "2020-12-28 23:38:59 UTC", description: "Make internal metrics pass promtools check", pr_number:                                      5743, scopes: ["internal_metrics source"], type:                             "fix", breaking_change:         false, author: "James Turnbull", files_count:            2, insertions_count:  3, deletions_count:    3},
		{sha: "3d0e1cfd7717dc54b2f9fc73384e6b2d62b4a999", date: "2020-12-29 09:05:02 UTC", description: "Better tracing/tests on rdkafka options.", pr_number:                                        5652, scopes: ["kafka sink"], type:                                          "enhancement", breaking_change: false, author: "Ana Hobden", files_count:                1, insertions_count:  108, deletions_count:  39},
		{sha: "99f67cc19c23d7289301bdcd525e2c586bb0778e", date: "2020-12-29 09:05:09 UTC", description: "Fixup version script", pr_number:                                                            5752, scopes: [], type:                                                      "chore", breaking_change:       false, author: "Ana Hobden", files_count:                1, insertions_count:  1, deletions_count:    1},
		{sha: "977c0106ecb7923eda630b88f3ab42b7c510f960", date: "2020-12-30 01:53:43 UTC", description: "add `parse_regex` and `parse_regex_all` remap functions", pr_number:                         5594, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "FungusHumungus", files_count:            8, insertions_count:  455, deletions_count:  1},
		{sha: "acf9cfc375d2421a091e47d33e7ab8843573a4ea", date: "2021-01-01 22:42:39 UTC", description: "Adds script for generating README.md for Agent role helm-chart", pr_number:                  5590, scopes: ["kubernetes platform"], type:                                 "enhancement", breaking_change: false, author: "Ian Henry", files_count:                 1, insertions_count:  8, deletions_count:    0},
		{sha: "a07132a9496f74891b7868e5997da099e8dea43b", date: "2021-01-03 09:46:19 UTC", description: "do not use static year in tests", pr_number:                                                 5803, scopes: ["syslog source"], type:                                       "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  12, deletions_count:   10},
		{sha: "ad8909ca968ba185690c31fa6e4e510855bdd7ae", date: "2021-01-03 02:43:46 UTC", description: "Build ARMv7 images for all supported platforms", pr_number:                                  5787, scopes: ["ci"], type:                                                  "enhancement", breaking_change: false, author: "Dan Norris", files_count:                2, insertions_count:  2, deletions_count:    2},
		{sha: "18b22b0c0166f209eb6087a2302971304add8310", date: "2021-01-04 06:53:54 UTC", description: "add `parse_aws_cloudwatch_log_subscription_message` function", pr_number:                    5764, scopes: ["remap transform"], type:                                     "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           12, insertions_count: 302, deletions_count:  29},
		{sha: "26f730d62f9331b7c295ed71f3344afeca751849", date: "2021-01-03 22:28:31 UTC", description: "Trivial fixes for metrics batch buffer", pr_number:                                          5699, scopes: ["metrics"], type:                                             "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             2, insertions_count:  89, deletions_count:   62},
		{sha: "242f4db6dda14f125efdc948072b8c44d8e6b08e", date: "2021-01-03 20:38:55 UTC", description: "Enable casting timestamps into integers", pr_number:                                         5753, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               2, insertions_count:  66, deletions_count:   114},
		{sha: "6b97409f3298ad99c0d7d71c25dbb1e17930116a", date: "2021-01-04 07:55:44 UTC", description: "allow send metrics to kafka", pr_number:                                                     5712, scopes: ["kafka sink"], type:                                          "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           2, insertions_count:  90, deletions_count:   23},
		{sha: "a1f0d6b328bd053e4aea497332ece7ebc8ce8fe1", date: "2021-01-04 08:03:19 UTC", description: "Correct misspelling", pr_number:                                                             5826, scopes: ["internal docs"], type:                                       "fix", breaking_change:         false, author: "Jose Diaz-Gonzalez", files_count:        1, insertions_count:  1, deletions_count:    1},
		{sha: "3b415d160de76e1ee4b600be5b475b922d38c221", date: "2021-01-05 00:49:11 UTC", description: "fix features for lib/shared", pr_number:                                                     5829, scopes: ["deps"], type:                                                "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  1, deletions_count:    1},
		{sha: "9691d4f6392cbd5142aa30fe46877f8e81777b21", date: "2021-01-05 01:16:49 UTC", description: "Adds docker push guard back into CI scripts", pr_number:                                     5848, scopes: ["ci"], type:                                                  "chore", breaking_change:       false, author: "Ian Henry", files_count:                 2, insertions_count:  6, deletions_count:    1},
		{sha: "c6a8c3e17618d97cade170cc030b649982d48e36", date: "2021-01-05 21:36:54 UTC", description: "added `parse_key_value` remap function", pr_number:                                          5760, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "FungusHumungus", files_count:            5, insertions_count:  526, deletions_count:  0},
		{sha: "d612b3caaaadba1790902efaf5addf5347b7be81", date: "2021-01-06 01:24:06 UTC", description: "correctly handle nested map insertions", pr_number:                                          5834, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Jean Mertz", files_count:                2, insertions_count:  25, deletions_count:   13},
		{sha: "948599795653f3b5894fa58046b309cb3ccc8da1", date: "2021-01-06 01:24:50 UTC", description: "non-boolean if conditional compile-time error", pr_number:                                   5835, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                3, insertions_count:  29, deletions_count:   18},
		{sha: "a64d67156913b2702b1601f5011c9a279ac377c0", date: "2021-01-07 03:07:18 UTC", description: "Relay connections (components, initially)", pr_number:                                       5747, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                11, insertions_count: 652, deletions_count:  83},
		{sha: "2daa2856fea746879eaa98645e74cd6018a77b0e", date: "2021-01-07 05:45:14 UTC", description: "Relay-compatible connections for sources/transforms/sinks", pr_number:                       5880, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                7, insertions_count:  643, deletions_count:  119},
		{sha: "b85cde4eff1ef790e78b6ae6ba83fc4aabc5624f", date: "2021-01-07 05:58:44 UTC", description: "Add is_nullish function to VRL", pr_number:                                                  5754, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               6, insertions_count:  249, deletions_count:  1},
		{sha: "b2e8c2680a5aae1828a0dfbfba7fee1fb8d6f403", date: "2021-01-07 20:44:19 UTC", description: "Fix HTTP and HTTPS URL", pr_number:                                                          5882, scopes: ["docker_logs source"], type:                                  "fix", breaking_change:         false, author: "Duy Do", files_count:                    2, insertions_count:  34, deletions_count:   6},
		{sha: "5b5222c25b25552a139cf7b0349dda280bb790fd", date: "2021-01-07 07:20:37 UTC", description: "Move VRL CLI into the Vector CLI", pr_number:                                                5756, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               13, insertions_count: 231, deletions_count:  156},
		{sha: "7458ebcd41bb7201ab71c560cf6798bd43b6237f", date: "2021-01-07 20:26:48 UTC", description: "add error coalescing operator", pr_number:                                                   5830, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                5, insertions_count:  100, deletions_count:  3},
		{sha: "7844bb7449a1981ff4dbe2e7745064182f407eb8", date: "2021-01-07 20:45:37 UTC", description: "support \"abort on error\" bang-function-calls", pr_number:                                  5876, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                5, insertions_count:  97, deletions_count:   17},
		{sha: "19a90e8f1cba1642cfc9b97e8598c6a9ef310372", date: "2021-01-07 20:16:23 UTC", description: "Addressed minor spelling error in variable", pr_number:                                      5899, scopes: [], type:                                                      "chore", breaking_change:       false, author: "James Turnbull", files_count:            1, insertions_count:  3, deletions_count:    3},
		{sha: "577edaf502d91b49f265b9853eb0d9dec10b3065", date: "2021-01-08 23:39:02 UTC", description: "error-return-value error handling pattern", pr_number:                                       5911, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                12, insertions_count: 324, deletions_count:  62},
		{sha: "411100307f44d1d73933b0080dca1da254cd914d", date: "2021-01-08 18:55:35 UTC", description: "allow user configuration of the `ignore_not_found` option", pr_number:                       5616, scopes: ["file source"], type:                                         "feat", breaking_change:        false, author: "Spencer Gilbert", files_count:           2, insertions_count:  9, deletions_count:    1},
		{sha: "08bb58f02b536a266d92b395f4785335debf8e64", date: "2021-01-08 20:58:10 UTC", description: "Handle early return from influxdb create database", pr_number:                               5928, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             2, insertions_count:  36, deletions_count:   18},
		{sha: "1d99cefa0ebd5432a39fc38539c0a84ca6ff2fd7", date: "2021-01-09 08:30:32 UTC", description: "Fix prometheus exposition format", pr_number:                                                5914, scopes: ["prometheus_exporter sink"], type:                            "fix", breaking_change:         false, author: "Raphael Taylor-Davies", files_count:     2, insertions_count:  34, deletions_count:   28},
		{sha: "dbcef9cedf9960169e0564ca6ed08808c4c9fc74", date: "2021-01-09 21:51:58 UTC", description: "bare variable names", pr_number:                                                             5856, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jean Mertz", files_count:                6, insertions_count:  210, deletions_count:  120},
		{sha: "808d0a61b647d13f4f9d7b90baa499cda97d15f6", date: "2021-01-11 04:03:35 UTC", description: "Avoid alias `in_flight_limit`", pr_number:                                                   5950, scopes: ["config"], type:                                              "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        2, insertions_count:  32, deletions_count:   7},
		{sha: "df7136e69a37be36d6217116e1beec31cb6244b3", date: "2021-01-11 04:40:15 UTC", description: "Add to_syslog_facility function for parsing syslog facilities into strings", pr_number:      5770, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Josh Bradley", files_count:              6, insertions_count:  318, deletions_count:  1},
		{sha: "02952782aee141597d0ba15df0873c6e482d68a4", date: "2021-01-11 19:00:10 UTC", description: "Add to_unix_timestamp function", pr_number:                                                  5767, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               5, insertions_count:  275, deletions_count:  0},
		{sha: "4c6af99cc8a485b219d0d19c47a2fc4896d50ab6", date: "2021-01-11 22:10:28 UTC", description: "Rename tokenize to parse_tokens", pr_number:                                                 5983, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Luc Perkins", files_count:               5, insertions_count:  30, deletions_count:   30},
		{sha: "69df85b59e3425214113ad8dcaba37d13c4ac78f", date: "2021-01-11 23:22:14 UTC", description: "Add push and append functions", pr_number:                                                   5750, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               8, insertions_count:  419, deletions_count:  1},
		{sha: "1b9880c704d34cbe173feb2be213c11a0ed296af", date: "2021-01-12 01:16:07 UTC", description: "Add base64 encoding and decoding functions", pr_number:                                      5768, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               10, insertions_count: 367, deletions_count:  1},
		{sha: "fece63629576cb394912c13998dd96af6e1826c5", date: "2021-01-12 01:32:12 UTC", description: "Make the redact function fallible", pr_number:                                               5933, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Luc Perkins", files_count:               1, insertions_count:  83, deletions_count:   2},
		{sha: "66674728a2bd6a66d37580105ab9e9242f23d139", date: "2021-01-12 18:15:34 UTC", description: "Set `core_threads` for `merge_and_fork`", pr_number:                                         5968, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        1, insertions_count:  5, deletions_count:    1},
		{sha: "fa541ab35ca5132f5ff357034d71cfad05b935a5", date: "2021-01-13 00:47:54 UTC", description: "remove the check_fields default for conditions", pr_number:                                  5978, scopes: ["config"], type:                                              "enhancement", breaking_change: true, author:  "FungusHumungus", files_count:            7, insertions_count:  47, deletions_count:   25},
		{sha: "d29319746634c002c8c05ef0316826be1c55733b", date: "2021-01-13 18:33:56 UTC", description: "Fix remove_label_fields", pr_number:                                                         5974, scopes: ["loki sink"], type:                                           "fix", breaking_change:         false, author: "Duy Do", files_count:                    1, insertions_count:  6, deletions_count:    2},
		{sha: "30642958e7835604f2b18022a898cb3136c065c2", date: "2021-01-13 19:53:55 UTC", description: "Fix transmission of counter metrics", pr_number:                                             5922, scopes: ["influxdb_metrics sink"], type:                               "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             2, insertions_count:  137, deletions_count:  53},
		{sha: "28155e37848feab7ab59fb8fe7a0818c5dce78b3", date: "2021-01-14 03:30:29 UTC", description: "Adjusting pod security policy to allow vector-agent to read host logs", pr_number:           6019, scopes: ["kubernetes platform"], type:                                 "fix", breaking_change:         false, author: "Thor Anker Kvisgård Lange", files_count: 1, insertions_count:  5, deletions_count:    3},
		{sha: "e784d59040153f84cee43df429832f55c36f8681", date: "2021-01-14 06:40:14 UTC", description: "correct start/stop instructions", pr_number:                                                 6029, scopes: ["ci"], type:                                                  "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:           3, insertions_count:  4, deletions_count:    4},
		{sha: "281db2bb0b09b7851e624065be27ae9c4a992a63", date: "2021-01-15 01:19:47 UTC", description: "Adjusting to adhere to linting rules used by ct", pr_number:                                 6021, scopes: ["kubernetes platform"], type:                                 "fix", breaking_change:         false, author: "Thor Anker Kvisgård Lange", files_count: 5, insertions_count:  9, deletions_count:    9},
		{sha: "36adac70be243988803f9fe10580f06a8818cf3c", date: "2021-01-15 00:57:13 UTC", description: "allow comments between multiline statements", pr_number:                                     6036, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:            3, insertions_count:  35, deletions_count:   3},
		{sha: "50ec1abe557ea78514da64aa2f7af2d6562eb988", date: "2021-01-15 08:44:02 UTC", description: "Allow passing component configs as YAML in Helm charts", pr_number:                          5673, scopes: ["kubernetes platform"], type:                                 "enhancement", breaking_change: false, author: "MOZGIII", files_count:                   30, insertions_count: 1593, deletions_count: 170},
		{sha: "c750955256a7a07488b98df542730113c296f299", date: "2021-01-15 08:44:35 UTC", description: "Rework defaults and a minimal scraping interval value", pr_number:                           5682, scopes: ["internal_metrics source"], type:                             "fix", breaking_change:         false, author: "MOZGIII", files_count:                   1, insertions_count:  13, deletions_count:   24},
		{sha: "7fa399f6ebfac4885ca2158fe76e8b427e424d0d", date: "2021-01-14 22:58:23 UTC", description: "Open docs URL for help in VRL REPL", pr_number:                                              5926, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  60, deletions_count:   10},
		{sha: "ecf0537e8fdf0a3d19fb4efc145dc431b3937355", date: "2021-01-15 08:55:34 UTC", description: "Pretty print functions list in VRL REPL", pr_number:                                         5935, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  47, deletions_count:   11},
		{sha: "b7e1234ab24aa33c155f093ed7a8e0f3a08c934b", date: "2021-01-15 19:03:44 UTC", description: "Support X-Scope-OrgID header", pr_number:                                                    5987, scopes: ["prometheus_remote_write sink"], type:                        "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             4, insertions_count:  210, deletions_count:  41},
		{sha: "0f7b6003aa6a7cb7fb37cc9f1eda2f54771caabc", date: "2021-01-16 05:07:06 UTC", description: "deprecate `check_fields` conditions", pr_number:                                             6037, scopes: ["config"], type:                                              "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            26, insertions_count: 893, deletions_count:  583},
		{sha: "158c7d78d0462737caeac9f7cc34ab0ea3ef1b21", date: "2021-01-15 23:04:48 UTC", description: "Add charset parameter to encode_base64 function", pr_number:                                 6065, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  147, deletions_count:  34},
		{sha: "b5835aa3c6c30f7ff37097bfde96ddaebd938535", date: "2021-01-16 09:58:36 UTC", description: "add tls support", pr_number:                                                                 6078, scopes: ["prometheus_exporter sink"], type:                            "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           6, insertions_count:  121, deletions_count:  54},
		{sha: "a4211e5a498980d0639e7178621589f98b096fcc", date: "2021-01-16 03:36:10 UTC", description: "Capture initialization logs", pr_number:                                                     6014, scopes: ["internal_logs source"], type:                                "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             3, insertions_count:  106, deletions_count:  35},
		{sha: "05e7359b139a942fb285e932a996fa4fdf48c1c3", date: "2021-01-16 23:38:05 UTC", description: "New `get_env_var` Remap function", pr_number:                                                6017, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Duy Do", files_count:                    5, insertions_count:  131, deletions_count:  1},
		{sha: "9089bdfcc24ed23ae36c9b3faf4773555bdeb900", date: "2021-01-18 00:31:42 UTC", description: "Trigger `leveldb` compact after certain amount of deleted bytes", pr_number:                 5821, scopes: ["buffers"], type:                                             "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        4, insertions_count:  131, deletions_count:  13},
		{sha: "6f147f3e5bc80ef027b921ac7f6a4af585e86220", date: "2021-01-18 18:49:52 UTC", description: "Filtering in the API", pr_number:                                                            6028, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                10, insertions_count: 1670, deletions_count: 468},
		{sha: "f5f7228339fe3362d1cb841324deb87eeef78eb0", date: "2021-01-19 07:04:24 UTC", description: "Support for collecting logs from static pods", pr_number:                                    6056, scopes: ["kubernetes_logs source"], type:                              "fix", breaking_change:         false, author: "MOZGIII", files_count:                   5, insertions_count:  229, deletions_count:  5},
		{sha: "a2107bb182d471b5a351600d4ff8079de066564b", date: "2021-01-19 09:20:07 UTC", description: "diagnostic error messages", pr_number:                                                       6023, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                44, insertions_count: 2306, deletions_count: 1170},
		{sha: "bf3401cf188aea7b4faff77b5a9050e5666461ab", date: "2021-01-19 02:59:58 UTC", description: "Update VRL CLI behavior", pr_number:                                                         6035, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               2, insertions_count:  30, deletions_count:   18},
		{sha: "a33537613404080d617aeafd117bd8ae53daad53", date: "2021-01-19 03:00:24 UTC", description: "Add length function for VRL", pr_number:                                                     6088, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               11, insertions_count: 279, deletions_count:  6},
		{sha: "0e248d4103ba169cf15dafadd3daf45c0d2980d2", date: "2021-01-19 10:02:51 UTC", description: "Fix Metrics not Updating", pr_number:                                                        5917, scopes: ["prometheus_exporter sink"], type:                            "fix", breaking_change:         false, author: "Raphael Taylor-Davies", files_count:     1, insertions_count:  66, deletions_count:   0},
		{sha: "7e5f6baa19cc616eab8b69e5be43c4c70990e1ff", date: "2021-01-19 19:26:38 UTC", description: "improve test harness set-up", pr_number:                                                     6105, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "Jean Mertz", files_count:                31, insertions_count: 273, deletions_count:  13},
		{sha: "f33a2a4c03d1d8bfd3f1c22403964a1afb636377", date: "2021-01-19 23:39:54 UTC", description: "API sorting, starting with `components`", pr_number:                                         6115, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                5, insertions_count:  419, deletions_count:  35},
		{sha: "d119fe9ee7889848f95375fe9a11fad8da8b9153", date: "2021-01-20 00:30:43 UTC", description: "`ipv6_to_ipv4` function allows ipv4 addresses to pass through", pr_number:                   6052, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:            2, insertions_count:  31, deletions_count:   44},
		{sha: "c7a6fef2841767df73a0be706497ac8d5e2717ad", date: "2021-01-20 15:06:28 UTC", description: "Sorting for sources/transforms/sinks", pr_number:                                            6136, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                6, insertions_count:  710, deletions_count:  193},
		{sha: "2f97437915c659be299aca8a39833bef738a777e", date: "2021-01-21 00:25:46 UTC", description: "Update VRL docs URLs", pr_number:                                                            6120, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Luc Perkins", files_count:               1, insertions_count:  3, deletions_count:    2},
		{sha: "9c3baf76bf705dfd5e2ec53d88376aafc6976983", date: "2021-01-21 03:38:05 UTC", description: "Add encoding charset and line delimiter configuration", pr_number:                           5436, scopes: ["file source"], type:                                         "enhancement", breaking_change: false, author: "Anup Dhamala", files_count:              20, insertions_count: 728, deletions_count:  26},
		{sha: "5efa5d95f48640295728ac4c0672cfe6545b43ed", date: "2021-01-22 03:56:37 UTC", description: "support regexp in filters", pr_number:                                                       6118, scopes: ["postgresql_metrics source"], type:                           "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           3, insertions_count:  204, deletions_count:  84},
		{sha: "98a066a1b659e43843c75760fc16cbbac6214380", date: "2021-01-22 18:34:36 UTC", description: "fix and document exclude_self logic", pr_number:                                             5998, scopes: ["docker_logs source"], type:                                  "fix", breaking_change:         false, author: "Duy Do", files_count:                    2, insertions_count:  39, deletions_count:   61},
		{sha: "e8ac7d50c89fd85d81363e866f8c613252b43336", date: "2021-01-23 05:58:13 UTC", description: "Add `auth.access_key_id` and `auth.secret_access_key` options", pr_number:                   6188, scopes: ["auth", "aws platform"], type:                                "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        3, insertions_count:  64, deletions_count:   18},
		{sha: "35430409c771f63e45716035d0ae9fb12393943e", date: "2021-01-23 05:11:52 UTC", description: "Rename healthcheck error", pr_number:                                                        6192, scopes: ["aws_cloudwatch_logs sink"], type:                            "fix", breaking_change:         false, author: "Andrew Haines", files_count:             1, insertions_count:  3, deletions_count:    3},
		{sha: "cfeb2c2e358c6bc47c3c70f7a8ded2970f958a2c", date: "2021-01-27 01:30:46 UTC", description: "add `get_hostname` function", pr_number:                                                     6141, scopes: ["remap transform"], type:                                     "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           7, insertions_count:  111, deletions_count:  0},
		{sha: "87a21478b5e4256239894072095a57f61c1af725", date: "2021-01-27 02:32:55 UTC", description: "Merge configs for `vector test`", pr_number:                                                 6214, scopes: [], type:                                                      "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:        7, insertions_count:  58, deletions_count:   80},
		{sha: "e777720e1e8ba17514500df6d4e010d9fb10012d", date: "2021-01-28 03:24:51 UTC", description: "add wildcard expansion to inputs", pr_number:                                                6170, scopes: ["config"], type:                                              "feat", breaking_change:        false, author: "Luke Steensen", files_count:             5, insertions_count:  188, deletions_count:  35},
		{sha: "dad5a052f0669e9ea39172b197cc4a2775d506bd", date: "2021-01-29 04:43:53 UTC", description: "call ack on any result", pr_number:                                                          6267, scopes: ["nats sink"], type:                                           "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  2, deletions_count:    1},
		{sha: "7b762a072901f1be4a26dc37430d3ae1183b3ca3", date: "2021-01-28 19:44:39 UTC", description: "Extract new second-level features from Cargo.toml", pr_number:                               6263, scopes: ["ci"], type:                                                  "chore", breaking_change:       false, author: "Bruce Guenter", files_count:             1, insertions_count:  11, deletions_count:   3},
		{sha: "ae47b00fa3a0691d950c83976df48f5b83335662", date: "2021-01-29 05:02:03 UTC", description: "fix field sublocation_type in parse_aws_vpc_flow_log", pr_number:                            6229, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           1, insertions_count:  1, deletions_count:    1},
		{sha: "e5ed779d4321793a55594b40235a7252d9c90200", date: "2021-01-29 06:20:33 UTC", description: "add the ability to configure Vector API at the Helm charts", pr_number:                      6248, scopes: ["kubernetes platform"], type:                                 "enhancement", breaking_change: false, author: "Oleg Tsymbal", files_count:              10, insertions_count: 65, deletions_count:   0},
		{sha: "aa665d3bef94575a476fc533debc3049471eb6ea", date: "2021-01-29 05:11:03 UTC", description: "test again released version of loki", pr_number:                                             6279, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Luke Steensen", files_count:             1, insertions_count:  2, deletions_count:    2},
		{sha: "5382390239a4dfff5cc5ec2cc738d5309087d749", date: "2021-01-29 08:17:13 UTC", description: "Add more benchmark comparisons", pr_number:                                                  6233, scopes: ["performance"], type:                                         "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               9, insertions_count:  752, deletions_count:  3},
		{sha: "92a81794668fb89dbb576fdfcd8408138c2b41c6", date: "2021-01-29 19:36:51 UTC", description: "`parse_grok` should error when it fails to parse", pr_number:                                6271, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:            1, insertions_count:  7, deletions_count:    6},
		{sha: "06749528c7ae94601738284dc818dfb31ef0de24", date: "2021-01-29 20:05:33 UTC", description: "split start_at_beginning into simpler options", pr_number:                                   6178, scopes: ["file source"], type:                                         "enhancement", breaking_change: false, author: "Luke Steensen", files_count:             6, insertions_count:  209, deletions_count:  65},
		{sha: "36b36a53bc6504c9176dac6fa445ab9347929659", date: "2021-01-29 22:36:28 UTC", description: "disallow non-unique component names", pr_number:                                             6270, scopes: ["config"], type:                                              "fix", breaking_change:         false, author: "Luke Steensen", files_count:             2, insertions_count:  69, deletions_count:   0},
		{sha: "3d37188984d1c519c134bc89fb1a617be9e76df7", date: "2021-01-30 06:55:59 UTC", description: "Make size of socket send/receive buffers configurable", pr_number:                           6177, scopes: ["networking"], type:                                          "enhancement", breaking_change: false, author: "Pablo Sichert", files_count:             32, insertions_count: 545, deletions_count:  164},
		{sha: "a2a54f561a9f7157bd59f12a7b72b564e346887d", date: "2021-01-30 00:33:18 UTC", description: "Fix metrics::tests::test_cardinality_metric", pr_number:                                     6278, scopes: ["metrics"], type:                                             "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             1, insertions_count:  23, deletions_count:   10},
		{sha: "51f5827df6c6d3337db6099016af03cefbc7f9dc", date: "2021-01-30 05:01:41 UTC", description: "use poll backend for watcher", pr_number:                                                    6286, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Luke Steensen", files_count:             1, insertions_count:  4, deletions_count:    6},
		{sha: "055524028977e2ea5aa2fadbee093125e4d07ec1", date: "2021-02-02 02:44:41 UTC", description: "maintain type definitions for maps", pr_number:                                              6182, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            27, insertions_count: 748, deletions_count:  179},
		{sha: "316937ce8067cc2785510d077e4172fb4f63ac58", date: "2021-02-02 16:10:34 UTC", description: "Fix out-of-order error", pr_number:                                                          5973, scopes: ["loki sink"], type:                                           "fix", breaking_change:         false, author: "Duy Do", files_count:                    4, insertions_count:  361, deletions_count:  38},
		{sha: "080a10cf5c2d3127ca3ff232b80aa6cf06d1573e", date: "2021-02-02 05:40:10 UTC", description: "revert poll watcher change", pr_number:                                                      6311, scopes: ["tests"], type:                                               "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:             1, insertions_count:  6, deletions_count:    4},
		{sha: "1e9d21123352b59ab590ba85aaabfe9eca9bcbb8", date: "2021-02-03 02:03:20 UTC", description: "Rework the metrics batch buffer", pr_number:                                                 6251, scopes: ["metrics"], type:                                             "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             11, insertions_count: 877, deletions_count:  456},
		{sha: "594a6c43e4e0f2d4e01136618f85a3a782eeec14", date: "2021-02-03 08:20:06 UTC", description: "Add charset option to decode_base64 function", pr_number:                                    6296, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               7, insertions_count:  219, deletions_count:  138},
		{sha: "7f3443202d9b793568977280ee2951467165fc19", date: "2021-02-03 21:52:33 UTC", description: "#5642 - build deb packages that install on Deb 8", pr_number:                                6332, scopes: ["deployment"], type:                                          "fix", breaking_change:         false, author: "James Turnbull", files_count:            2, insertions_count:  2, deletions_count:    2},
		{sha: "9c55395cd85423fb63893596617b29130abfadd9", date: "2021-02-03 21:52:46 UTC", description: "Re-flatten the remap-functions directory tree", pr_number:                                   6335, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Luc Perkins", files_count:               5, insertions_count:  53, deletions_count:   56},
		{sha: "cf6f56ac088ae525b1e368de64eaf9655487fbd3", date: "2021-02-04 02:50:17 UTC", description: "Fix handling of component errors", pr_number:                                                6309, scopes: ["topology"], type:                                            "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:             2, insertions_count:  89, deletions_count:   88},
		{sha: "344053fec4afc74ad8eed4833ade2c14a924a06e", date: "2021-02-05 01:28:33 UTC", description: "Add `uptime` & `boot_time` metrics", pr_number:                                              6292, scopes: ["host_metrics source"], type:                                 "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        2, insertions_count:  59, deletions_count:   1},
		{sha: "f53e7ec9d07e3ea6d555b82e85c038887113c1c2", date: "2021-02-04 18:11:35 UTC", description: "Add HTTP auth support", pr_number:                                                           6281, scopes: ["prometheus_remote_write sink"], type:                        "feat", breaking_change:        false, author: "William Perron", files_count:            2, insertions_count:  47, deletions_count:   2},
		{sha: "e758240ecc8a83d8bdf568a8ce2f1759b944077f", date: "2021-02-05 05:36:45 UTC", description: "Correct the real world benches", pr_number:                                                  6350, scopes: [], type:                                                      "chore", breaking_change:       false, author: "MOZGIII", files_count:                   1, insertions_count:  7, deletions_count:    2},
		{sha: "f2529f091786df59ab9d7155c69483f93fec3041", date: "2021-02-05 01:48:23 UTC", description: "Deprecate fingerprint.bytes option", pr_number:                                              6338, scopes: ["file source"], type:                                         "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:             2, insertions_count:  19, deletions_count:   20},
		{sha: "fe17fe46ae60c5983bd9f063bb412d7170e1eb15", date: "2021-02-06 05:08:15 UTC", description: "Add `parse_common_log` function", pr_number:                                                 6230, scopes: ["remap transform"], type:                                     "feat", breaking_change:        false, author: "Pablo Sichert", files_count:             5, insertions_count:  389, deletions_count:  0},
		{sha: "103a0a7c07b351565f6ac136123a91bb1e373dda", date: "2021-02-05 22:46:33 UTC", description: "Add join function", pr_number:                                                               6313, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               5, insertions_count:  282, deletions_count:  0},
		{sha: "bec2c634c935341468b5da73bd43403697eddac4", date: "2021-02-06 06:16:47 UTC", description: "Add `parse_glog` function", pr_number:                                                       6293, scopes: ["remap transform"], type:                                     "feat", breaking_change:        false, author: "Pablo Sichert", files_count:             6, insertions_count:  275, deletions_count:  0},
		{sha: "e56874a27d8186820bc0aa664c351b8c532d04f5", date: "2021-02-06 02:49:34 UTC", description: "Update bollard to 0.9.1 to fix #5937", pr_number:                                            6369, scopes: ["docker", "dependencies"], type:                              "fix", breaking_change:         false, author: "James Turnbull", files_count:            2, insertions_count:  3, deletions_count:    3},
		{sha: "c6c87329cb2de7baab8a9e7792dcb4a7668d2d9e", date: "2021-02-08 01:10:15 UTC", description: "Emit `processed_events_total` after transform has processed event", pr_number:               6294, scopes: ["observability"], type:                                       "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        4, insertions_count:  69, deletions_count:   14},
		{sha: "85c0a29593418d7555357ae96e5980b8653ccb4b", date: "2021-02-08 10:36:46 UTC", description: "Switch to `futures-0.3` channels", pr_number:                                                6283, scopes: [], type:                                                      "perf", breaking_change:        false, author: "Kruno Tomola Fabro", files_count:        4, insertions_count:  36, deletions_count:   11},
		{sha: "9c0bdd3adca4fe9243cca75053c66d10ed2fe9eb", date: "2021-02-09 04:29:18 UTC", description: "remove connect in SourceConfig::build", pr_number:                                           6246, scopes: ["mongodb_metrics source", "postgresql_metrics source"], type: "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:           2, insertions_count:  111, deletions_count:  109},
		{sha: "2dc29ea32748b6f6839fa2941077c1ee4330ee0e", date: "2021-02-09 06:51:17 UTC", description: "`FileSourceMetricFile` sort", pr_number:                                                     6154, scopes: ["graphql api"], type:                                         "enhancement", breaking_change: false, author: "Lee Benson", files_count:                6, insertions_count:  339, deletions_count:  32},
		{sha: "2000686a0d3b8671026ec87e762e9e6964758e21", date: "2021-02-09 00:56:00 UTC", description: "Move normalization out of MetricsBuffer", pr_number:                                         6340, scopes: ["metrics", "sinks"], type:                                    "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             7, insertions_count:  171, deletions_count:  87},
		{sha: "c82bb6a5e74e89a59dcf853384e2acba970fc6d3", date: "2021-02-09 08:00:35 UTC", description: "Fix parse_json Wasm function", pr_number:                                                    6398, scopes: ["wasm transform"], type:                                      "fix", breaking_change:         false, author: "Luc Perkins", files_count:               1, insertions_count:  13, deletions_count:   5},
		{sha: "48af0ac6757f88241c708ad2063dffb637b5146e", date: "2021-02-09 22:12:38 UTC", description: "Log IO errors when globbing", pr_number:                                                     6384, scopes: ["file source"], type:                                         "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        7, insertions_count:  78, deletions_count:   19},
		{sha: "a6d8ef583ebe7009af91418caf1ae584cfb75db1", date: "2021-02-09 20:51:09 UTC", description: "Add support for metrics in templates", pr_number:                                            6351, scopes: ["templating"], type:                                          "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             2, insertions_count:  97, deletions_count:   18},
		{sha: "f5574b5b53f9ac39f1008ffe29d69eafcaec5c9f", date: "2021-02-10 07:05:30 UTC", description: "change release profile", pr_number:                                                          6202, scopes: ["releasing"], type:                                           "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:           4, insertions_count:  14, deletions_count:   28},
		{sha: "879c5f55a1cc1c96bcb00234118c33a616acc543", date: "2021-02-09 22:31:35 UTC", description: "Fix merge error with test cases", pr_number:                                                 6405, scopes: ["templating"], type:                                          "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             1, insertions_count:  2, deletions_count:    2},
		{sha: "ce108f3c03a9da7c8e07ecca735843c8ca6bfa6b", date: "2021-02-10 23:45:06 UTC", description: "Expose node-port for vector-aggregator", pr_number:                                          6020, scopes: ["kubernetes platform"], type:                                 "feat", breaking_change:        false, author: "Thor Anker Kvisgård Lange", files_count: 9, insertions_count:  95, deletions_count:   53},
		{sha: "066c22e6b1eab5bbc4e9dfe4ee6a24f3e491c421", date: "2021-02-10 22:24:26 UTC", description: "Handle OK response from api_watcher with embedded desync elegantly", pr_number:              6053, scopes: ["kubernetes_logs source"], type:                              "fix", breaking_change:         false, author: "Ian Henry", files_count:                 13, insertions_count: 1365, deletions_count: 187},
		{sha: "4b6cf6556606af62e17bbe5414fa380e60580ce3", date: "2021-02-11 01:13:38 UTC", description: "Fix lua_field_filter/v2 implementation", pr_number:                                          6355, scopes: ["lua transform"], type:                                       "perf", breaking_change:        false, author: "Jesse Szwedko", files_count:             1, insertions_count:  4, deletions_count:    5},
		{sha: "8011a223b599a765018dbc708585cdac802aaecf", date: "2021-02-13 06:13:53 UTC", description: "Reintegrate complex metrics", pr_number:                                                     6280, scopes: ["prometheus_remote_write source"], type:                      "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             19, insertions_count: 858, deletions_count:  420},
		{sha: "3d55e18f3549d443d75c04cadff02d9bfb6fc913", date: "2021-02-16 02:30:05 UTC", description: "Restrict benchmark runs to specific directories", pr_number:                                 6421, scopes: ["ci"], type:                                                  "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               1, insertions_count:  13, deletions_count:   1},
		{sha: "25e9e5e0c92243bcb6756d2049f52b7502e8cdce", date: "2021-02-17 23:57:57 UTC", description: "improved type definitions for `or` with nullable fields", pr_number:                         6462, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            3, insertions_count:  64, deletions_count:   10},
		{sha: "8a4fe909a9e0d3fa1e0c857218dbe8e29403167e", date: "2021-02-17 17:07:51 UTC", description: "Convert to indoc blocks", pr_number:                                                         6386, scopes: ["dev"], type:                                                 "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               29, insertions_count: 2129, deletions_count: 2120},
		{sha: "61db5c65a63c4e1db43f2aa64db5214b55b794c8", date: "2021-02-17 20:23:09 UTC", description: "Split fake data into separate module", pr_number:                                            6464, scopes: ["deps"], type:                                                "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               7, insertions_count:  29, deletions_count:   12},
		{sha: "8de7955738170eea8cf27b6c78cdd76022e46ddf", date: "2021-02-18 01:48:16 UTC", description: "Enable opening docs for VRL error codes", pr_number:                                         6465, scopes: ["cli"], type:                                                 "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               3, insertions_count:  34, deletions_count:   8},
		{sha: "08718330fa229f8a04c5b9886309957216200a8f", date: "2021-02-19 09:53:46 UTC", description: "add merge and merge equals operations", pr_number:                                           6482, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            21, insertions_count: 326, deletions_count:  55},
		{sha: "750e383ad1226111e131a25ecdb202fc84f5bc8d", date: "2021-02-19 02:25:02 UTC", description: "Adjust the strength of `gauge_add` atomics", pr_number:                                      6480, scopes: ["performance"], type:                                         "enhancement", breaking_change: false, author: "Brian L. Troutwine", files_count:        1, insertions_count:  29, deletions_count:   15},
		{sha: "1137fbe3598e604f0806a21e91b47fa2f2a165f6", date: "2021-02-19 13:21:10 UTC", description: "Add function name hinting to VRL REPL", pr_number:                                           6205, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               1, insertions_count:  51, deletions_count:   6},
		{sha: "420c911925540a23f2d88a6ef4f9f4b4a93245d9", date: "2021-02-20 23:02:30 UTC", description: "Add `events_in_total` & `events_out_total` metrics", pr_number:                              6433, scopes: ["observability"], type:                                       "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:        9, insertions_count:  82, deletions_count:   12},
		{sha: "ebab8b21fef4b819ba3274b1d0783b9ea4b76b84", date: "2021-02-21 19:40:52 UTC", description: "Extract version in parse_syslog function", pr_number:                                        6499, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:             1, insertions_count:  9, deletions_count:    3},
		{sha: "15b5a2363baebfe47ae44e4cbdbafacb4e46d12c", date: "2021-02-22 20:57:54 UTC", description: "Close stream on bad data in vector source", pr_number:                                       6414, scopes: ["vector source"], type:                                       "fix", breaking_change:         false, author: "Ian Henry", files_count:                 2, insertions_count:  126, deletions_count:  10},
		{sha: "2b8d7b75b44e3687ebdbda50d27edb6e2e8c1a2e", date: "2021-02-23 22:14:07 UTC", description: "Add VRL test suite to CI", pr_number:                                                        6537, scopes: ["ci"], type:                                                  "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               5, insertions_count:  54, deletions_count:   4},
		{sha: "2ac861e09f99036145749ee8af7a7e0d7aa945c6", date: "2021-02-25 00:01:14 UTC", description: "Build Rustdoc site on PR merge", pr_number:                                                  6551, scopes: ["ci"], type:                                                  "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               1, insertions_count:  28, deletions_count:   0},
		{sha: "cd3329716d554ab120a4973304c1c2a07f1c1d58", date: "2021-02-25 20:14:23 UTC", description: "Update VRL error messages", pr_number:                                                       6506, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               50, insertions_count: 711, deletions_count:  622},
		{sha: "0f6b78887428fc2f3d85389d132e0d7e569f67f2", date: "2021-02-25 21:13:59 UTC", description: "rustdoc build changes", pr_number:                                                           6561, scopes: ["ci"], type:                                                  "enhancement", breaking_change: false, author: "Luc Perkins", files_count:               1, insertions_count:  7, deletions_count:    10},
		{sha: "6e37d6180dd675aab0bbb996a7a30731ad4049cf", date: "2021-02-26 01:17:10 UTC", description: "Retry sending after no connection", pr_number:                                               6542, scopes: ["http sink"], type:                                           "fix", breaking_change:         false, author: "Bruce Guenter", files_count:             6, insertions_count:  118, deletions_count:  68},
		{sha: "9918ebc011557d8d3b3d17cd002ac250d298f07d", date: "2021-02-26 04:10:11 UTC", description: "Enhance vector protocol for new metric data", pr_number:                                     6554, scopes: ["data model"], type:                                          "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             2, insertions_count:  135, deletions_count:  34},
		{sha: "65ef0079cac167c77b84a97157b7e1fed1632ab5", date: "2021-02-26 05:58:57 UTC", description: "Allow specifying default timezone", pr_number:                                               6533, scopes: ["transforms"], type:                                          "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:             31, insertions_count: 344, deletions_count:  165},
		{sha: "3456c6a8d587be01587dc12edac0a2967246d8d7", date: "2021-03-01 19:44:39 UTC", description: "parse create bulk action error", pr_number:                                                  6550, scopes: ["elasticsearch sink"], type:                                  "fix", breaking_change:         false, author: "Daniel Jin", files_count:                1, insertions_count:  29, deletions_count:   3},
		{sha: "76047d19bdbcd561103cf683d184ad9390c00fa0", date: "2021-03-02 01:48:50 UTC", description: "re-enable @ in identifiers.", pr_number:                                                     6529, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:            5, insertions_count:  47, deletions_count:   2},
		{sha: "c19ce9b810f6b493c123869fce9bd8095475ac00", date: "2021-03-02 17:52:37 UTC", description: "re-add progressive type-checking to the language", pr_number:                                6535, scopes: ["remap"], type:                                               "feat", breaking_change:        false, author: "FungusHumungus", files_count:            63, insertions_count: 441, deletions_count:  281},
		{sha: "081372e1562278b1e6d5d0ecee74d2af68a2a20a", date: "2021-03-02 19:07:11 UTC", description: "don't mark `/` as a valid escape target", pr_number:                                         6577, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Jean Mertz", files_count:                3, insertions_count:  20, deletions_count:   2},
		{sha: "8297828fa1e9d6a83c45f60e0942303611c19764", date: "2021-03-04 01:34:00 UTC", description: "Preload log scheme", pr_number:                                                              6581, scopes: ["config"], type:                                              "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:        16, insertions_count: 208, deletions_count:  102},
		{sha: "08af86d8482ecd691cff8d12dad625e04f8bad50", date: "2021-03-04 21:04:40 UTC", description: "Add support for metric namespaces", pr_number:                                               6623, scopes: ["lua transform"], type:                                       "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:             1, insertions_count:  9, deletions_count:    0},
		{sha: "333ba2393945f5b0f77ead19f32065ba9941f694", date: "2021-03-05 09:14:11 UTC", description: "added rate limit parameter to log function.", pr_number:                                     6622, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            5, insertions_count:  61, deletions_count:   34},
		{sha: "a557735e1f3a83d6e2aaec8898e4c992e3e8f5b6", date: "2021-03-05 09:14:42 UTC", description: "add parse_apache_log function", pr_number:                                                   6608, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            8, insertions_count:  640, deletions_count:  130},
		{sha: "ff508465d8d9a68d5720402a79ef129c100a241a", date: "2021-03-05 20:29:24 UTC", description: "Set correct Host header with AWS ES", pr_number:                                             6617, scopes: ["elastic service", "networking"], type:                       "fix", breaking_change:         false, author: "Ethan Hall", files_count:                1, insertions_count:  29, deletions_count:   0},
		{sha: "01ef9a070dbd783b8e0c9a9cbd0ab55f4960df26", date: "2021-03-06 00:26:15 UTC", description: "emit basic component utilization statistics", pr_number:                                     6634, scopes: ["observability"], type:                                       "feat", breaking_change:        false, author: "Luke Steensen", files_count:             5, insertions_count:  198, deletions_count:  90},
		{sha: "4294333f5c62006582288c29a332740a3952d6eb", date: "2021-03-06 08:57:09 UTC", description: "allow partially quoted fields to be parsed as undelimited.", pr_number:                      6639, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:            1, insertions_count:  141, deletions_count:  28},
		{sha: "25a7bd9d243c8c23bd524d1f1b7873e09c4dc2fb", date: "2021-03-09 00:48:58 UTC", description: "added the parse_logfmt remap function", pr_number:                                           6659, scopes: ["remap"], type:                                               "enhancement", breaking_change: false, author: "FungusHumungus", files_count:            5, insertions_count:  101, deletions_count:  3},
		{sha: "d1e8fbdd416e2ff9d0af27de6d4898ce11e4a58f", date: "2021-03-09 02:00:24 UTC", description: "correct type defs for boolean operations", pr_number:                                        6662, scopes: ["remap"], type:                                               "fix", breaking_change:         false, author: "Jean Mertz", files_count:                1, insertions_count:  189, deletions_count:  39},
		{sha: "d53a3698ac54032291c7e6ec3ff360eed1f80511", date: "2021-03-09 02:11:21 UTC", description: "support for kubeconfigs as an alternative to in_cluster configuration", pr_number:           4837, scopes: ["kubernetes_logs source"], type:                              "enhancement", breaking_change: false, author: "Johan Thomsen", files_count:             9, insertions_count:  407, deletions_count:  13},
		{sha: "2da91152e75e58b66decce58610ea11072a378da", date: "2021-03-09 03:13:32 UTC", description: "Add `tag_types_externally` function", pr_number:                                             6382, scopes: ["remap transform"], type:                                     "feat", breaking_change:        false, author: "Pablo Sichert", files_count:             6, insertions_count:  397, deletions_count:  0},
		{sha: "1d38a71d192d3742c2ab48c3acd4fddb22a60d82", date: "2021-03-10 22:04:29 UTC", description: "Define events for the `datadog_logs` sink", pr_number:                                       6637, scopes: ["datadog_logs sink"], type:                                   "enhancement", breaking_change: false, author: "Vladimir Zhuk", files_count:             3, insertions_count:  34, deletions_count:   1},
		{sha: "76ef1363b926412b0a9efd0b77ad31ca6131c6b3", date: "2021-03-11 00:34:43 UTC", description: "URL path configuration flexibility, path also exposed as a new field", pr_number:            6626, scopes: ["http source"], type:                                         "enhancement", breaking_change: false, author: "Pierre Rognant", files_count:            5, insertions_count:  278, deletions_count:  38},
	]
}
