# Defining your API

The API generated by Kubebuilder is just a shell, your actual API will likely have more fields defined on it.

Kubernetes has a lot of conventions and requirements around API design. 
The [Kubebuilder docs][apidesign] have some helpful hints on how to design your types.

[apidesign]: https://book.kubebuilder.io/cronjob-tutorial/api-design.html#designing-an-api


Let's take a look at what was generated for us: 

```go
// MailgunClusterSpec defines the desired state of MailgunCluster
type MailgunClusterSpec struct {
	// INSERT ADDITIONAL SPEC FIELDS - desired state of cluster
	// Important: Run "make" to regenerate code after modifying this file
}

// MailgunClusterStatus defines the observed state of MailgunCluster
type MailgunClusterStatus struct {
	// INSERT ADDITIONAL STATUS FIELD - define observed state of cluster
	// Important: Run "make" to regenerate code after modifying this file
}
```

Our API is based on Mailgun, so we're going to have some email based fields:

```go
type Priority string

const (
	// PriorityUrgent means do this right away
	PriorityUrgent = Priority("Urgent")

	// PriorityUrgent means do this immediately
	PriorityExtremelyUrgent = Priority("ExtremelyUrgent")

	// PriorityBusinessCritical means you absolutely need to do this now
	PriorityBusinessCritical = Priority("BusinessCritical")
)

// MailgunClusterSpec defines the desired state of MailgunCluster
type MailgunClusterSpec struct {
	// Priority is how quickly you need this cluster
	Priority Priority `json:"priority"`
	// Request is where you ask extra nicely
	Request string `json:"request"`
	// Requester is the email of the person sending the request
	Requester string `json:"requester"`
}

// MailgunClusterStatus defines the observed state of MailgunCluster
type MailgunClusterStatus struct {
	// MessageID is set to the message ID from Mailgun when our message has been sent
	MessageID *string `json:"response"`
}
```

As the deleted comments request, run `make manager manifests` to regenerate some of the generated data files afterwards.

```bash
git add .
git commit -m "Added cluster types"
```
