import { GraphQLSchema, FieldNode } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
export default class HoistField implements Transform {
    private readonly typeName;
    private readonly newFieldName;
    private readonly pathToField;
    private readonly oldFieldName;
    private readonly transformer;
    constructor(typeName: string, path: Array<string>, newFieldName: string, alias?: string);
    transformSchema(schema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult;
}
export declare function wrapFieldNode(fieldNode: FieldNode, path: Array<string>, alias: string): FieldNode;
export declare function unwrapValue(originalValue: any, alias: string): any;
