// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UpdateRdsDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The database password.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The Amazon RDS instance's ARN.
	//
	// RdsDbInstanceArn is a required field
	RdsDbInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRdsDbInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRdsDbInstanceInput"}

	if s.RdsDbInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RdsDbInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRdsDbInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRdsDbInstance = "UpdateRdsDbInstance"

// UpdateRdsDbInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Updates an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using UpdateRdsDbInstanceRequest.
//    req := client.UpdateRdsDbInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateRdsDbInstance
func (c *Client) UpdateRdsDbInstanceRequest(input *UpdateRdsDbInstanceInput) UpdateRdsDbInstanceRequest {
	op := &aws.Operation{
		Name:       opUpdateRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRdsDbInstanceInput{}
	}

	req := c.newRequest(op, input, &UpdateRdsDbInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateRdsDbInstanceRequest{Request: req, Input: input, Copy: c.UpdateRdsDbInstanceRequest}
}

// UpdateRdsDbInstanceRequest is the request type for the
// UpdateRdsDbInstance API operation.
type UpdateRdsDbInstanceRequest struct {
	*aws.Request
	Input *UpdateRdsDbInstanceInput
	Copy  func(*UpdateRdsDbInstanceInput) UpdateRdsDbInstanceRequest
}

// Send marshals and sends the UpdateRdsDbInstance API request.
func (r UpdateRdsDbInstanceRequest) Send(ctx context.Context) (*UpdateRdsDbInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRdsDbInstanceResponse{
		UpdateRdsDbInstanceOutput: r.Request.Data.(*UpdateRdsDbInstanceOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRdsDbInstanceResponse is the response type for the
// UpdateRdsDbInstance API operation.
type UpdateRdsDbInstanceResponse struct {
	*UpdateRdsDbInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRdsDbInstance request.
func (r *UpdateRdsDbInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
